{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit PopMenu;

Interface


Uses OpCrt,
     Common,MyIo,PopHelp,
     FastTTT5,WinTTT5,KeyTTT5,MenuTTT5;

Var
 M : Menu_Record;              { Menu Records }
 Changed : Boolean;            { Config changed ? }
 Choice,                       { Menu Choice      }
 ErrorCode : Integer;          { ErrorCode        }

function PopYnQ(Str : String): Boolean;
Procedure MakeMenu(Str : String; Var M : Menu_REcord);

Implementation


function phours(s:astr; lotime,hitime:integer):astr;
begin
  if (lotime<>hitime) then
    phours:=tch(cstr(lotime div 60))+':'+tch(cstr(lotime mod 60))+'...'+
            tch(cstr(hitime div 60))+':'+tch(cstr(hitime mod 60))
  else
    phours:=s;
end;

function sltype(i:integer):string;
begin
  case i of
    0:sltype:='File only';
    1:sltype:='Printer & File';
    2:sltype:='Printer only';
  end;
end;

Procedure DoYnq(Str : String; i : Integer; Var REturn : Boolean);
Var
 Tmp : Boolean;
Begin
 Case I of
   1:Tmp := TRUE;
   2:Tmp := False;
  End;
 Return := TMP;
End;

Procedure MakeAskYn(Var M : Menu_Record; Str : String);
Var
 Str1 : String;
 I : integer;
Begin
   Menu_Set(M);
   with M do
   Begin
    Heading1   :=SoftWareName+' Configuration';
    Heading2   :='Yes or No';
   for I := 1 to 2 do
    Begin
    Str1 :='';
    Case I of
      1: Str1 := Str + ' Yes';
      2: Str1 := Str + ' No';
     End;
    Topic[i] := Str1;
    End;
    TotalPicks   :=2;
    PicksPerLine :=1;
    Boxtype      :=5;
    Colors[1]    :=15;      {HF,HB,LF,LB,Box}
    Colors[2]    :=6;       {HF,HB,LF,LB,Box}
    Colors[3]    :=White;      {HF,HB,LF,LB,Box}
    Colors[4]    :=Blue;       {HF,HB,LF,LB,Box}
    Colors[5]    :=8;       {HF,HB,LF,LB,Box}
    Margins      :=1;
    AllowEsc     :=TRUE;                 {true if Esc will exit}
    Hook         :=No_Hook;
 End;
End;

function PopYnQ(Str : String): Boolean;
Var Tmp : Boolean;
    M : Menu_Record;
    ErrorCode,
    Choice : Integer;
Begin
  Tmp := False;
  Choice :=1;
  ErrorCode :=1;
 repeat
   MakeAskYn(M,Str);
   DisplayMenu(M,False,Choice,Errorcode);
   if (ErrorCode = 0) then
       DoYnQ(Str,Choice,Tmp);
 Until (ErrorCode = 1) or (Tmp) or Not (Tmp);
 PopYnQ := Tmp;
  ErrorCode :=0;
End;

Procedure MakeMenu(Str : String; Var M : Menu_REcord);
Var
 I : Integer;

Begin
   Menu_Set(M);
  if Str = 'MODEMCFG' then
   With M,Systat do
   Begin
    Heading1   :=SoftWareName+' Configuration';
    Heading2   :='Modem Configuration';
   for I := 1 to 13 do
    Begin
    Case I of
      1: Str :='Max BPS Rate       :'+Cstrl(WaitBaud);
      2: Str :='Modem ComPort      :'+Cstr(ComPort);
      3: Str :='Modem Init         :'+Init;
      4: Str :='Modem Anwer        :'+Answer;
      5: Str :='Modem HangUp       :'+HangUp;
      6: Str :='Modem OffHook      :'+OffHook;
      7: Str :='No Call Init Time  :'+Cstr(NoCallInitTime);
      8: Str :='Modem Result Codes                                       ';
      9  : Str :='NO CARRIER       : '+Cstr(NoCarrier);
      10 : Str :='NO DIAL          : '+Cstr(NoDialTone);
      11 : Str :='BUSY             : '+Cstr(Busy);
      12 : Str :='Port BPS Locked? :'+syn(LockedPort);
      13 : Str :='BPS locked Rate  :'+Cstr(LockedPortBaud);
     End;
    Topic[i] := Str;
    End;
    TotalPicks   :=13;
    PicksPerLine :=1;
    AddPrefix    :=1;
    Boxtype      :=5;     {0,1,2,3, >3}
    Colors[1]    :=14;      {HF,HB,LF,LB,Box}
    Colors[2]    :=0;       {HF,HB,LF,LB,Box}
    Colors[3]    :=15;      {HF,HB,LF,LB,Box}
    Colors[4]    :=3;       {HF,HB,LF,LB,Box}
    Margins      :=1;
    AllowEsc     :=TRUE;                 {true if Esc will exit}
    Hook         :=HelpModem;
   End else
   If (Str =  'MODEMCFG2') then
   With M,Systat do
   Begin
    Heading1   :=SoftWareName+' Configuration';
    Heading2   :='Modem Result Code';
      for i:=0 to 4 do
      begin      (* was 5 *)
        case i of
          0:Str :=' 300';
          1:Str :='1200';
          2:Str :='2400';
          3:Str :='4800';
          4:Str :='9600';
        end;
      Str:=Str+' BPS  : '+ mn(resultcode[1][i],3)+'  '+ mn(resultcode[2][i],3);
     Topic[i+1] := Str;
    End;
    TotalPicks   :=5;
    TopleftXY[1] := 0;        {auto center}
    TopLeftXY[2] := 4;
    Hook         :=HelpModem2;
   End else
   if Str ='SYSCONFIG' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='System Information';
      for I := 0 to 21 do
      Begin
      case i of
       0: Str:='Sysop Name/Alias '+SysopName;
       1: Str:='BBS Name '+BBSName;             
       2: Str:='BBS Number '+BBSPhone;
       3: Str:='Sysop Chat Hrs '+mln(phours('*None*',lowtime,hitime),16);
       4: Str:='Regular Dl Hours '+mln(phours('Always allowed',dllowtime,dlhitime),16);
       5: Str:='300 BPS Dl Hrs '+phours('Always allowed',b300dllowtime,b300dlhitime);
       6: Str:='LockOut 300 BPS calls '+Syn(Lock300);
       7:Str:='300 BPS Time Zone '+phours('Always allowed',b300lowtime,b300hitime);
       8: Str:='New Users are '+aonoff(closedsystem,'Rejected','Accepted');
       9: Str:='Swap Shell '+aonoff(swapshell,'Active','In-active');
       10:Str:='System Password '+SysOpPw;
       11:Str:='New User Password '+NewUserPw;
       12:Str:='Pre-Event Warning '+cstr(eventwarningtime)+' seconds';
       13:Str:='Last TFile Edit '+TfileDate;
       14: Str:='System Paths';
     End;  { Case }
        Topic[i+1] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=15;
      AddPrefix    :=1;
      PicksPerLine :=2;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpCFG;
   End else
    If Str = 'SYSCONFIG2' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='System Path Information';
      for I := 1 to 12 do
     Begin
      case i of
       1:Str:='Swap Shell Path:'+swappath;
       2:Str:='Data File Path :'+gfilepath;
       3:Str:='ANS/ASC Path   :'+afilepath;
       4:Str:='MsgBase Path   :'+msgpath;
       5:Str:='Menu Path      :'+MenuPath;
       6:Str:='TextFile Path  :'+tfilePath;
       7:Str:='LogFile Path   :'+TrapPath;
       8:Str:='Temp/Work Path :'+TempPath;
       9:Str:='Sema Path      :'+SemaPath;
      10:Str:='Overlay Path   :'+OvrPath;
      11:Str:='Net File Path  :'+NetFilePath;
      12:Str:='Net Mail Path  :'+NetMailPath;
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=12;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpCFG2;
   End else
  if Str = 'MAINMENU' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='Main System Configuration Menu';
      for I := 1 to 6 do
     Begin
      case i of
       1:Str :='System Path/BBS Info Configuration';
       2:Str :='Modem Configuration';
       3:Str :='System ACS Settings Configuration';
       4:Str :='System Maximums and Others';
       5:Str :='System Flag Configuration';
       6:Str :='Network Configuration';
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=6;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=MainHelp;
   End else
  if Str = 'ACSCFG' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='System ACS Configuration';
      for I := 1 to 17 do
     Begin
      case i of
        1: Str := 'Full SySop                        :'+Sop;
        2: Str := 'Co-Sysop                          :'+Csop;
        3: Str := 'File Base Sysop                   :'+Fsop;
        4: Str := 'Message Base Sysop                :'+Msop;
        5: Str := 'SysOp Pw at login                 :'+Spw;
        6: Str := 'See Passwords Remote              :'+SeePw;
        7: Str := 'Public Post Minumum               :'+NormPubPost;
        8: Str := 'Private Post Minimum              :'+NormPrivPost;
        9: Str := 'See Anon Public Posts             :'+AnonPubread;
        10: Str := 'See Anon Private Posts            :'+ AnonPrivRead;
        11: Str := 'Post Anonymous any base           :'+ AnonPubPost;
        12: Str := 'See Unvalidated files             :'+seeunval;
        13: Str := 'Download UnValidated Files        :'+DlUnVal;
        14: Str := 'No Ul/DL Ratio                    :'+NoDlRatio;
        15: Str := 'No Post Call Ratio                :'+NoPostRatio;
        16: Str := 'No File Point checking            :'+NoFilePts;
        17: Str := 'Uploads Autocredited (Validated)  :'+UlValReq;
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=17;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 1;
      Hook         :=AcsHelp;
  End else
  if Str = 'MAXCFG' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='System Maximum Settings';
      for I := 1 to 16 do
     Begin
      case i of
        1: Str := 'Max Email Per Call           : '+Cstr(MaxPrivPost);
        2: Str := 'Max Public Post Per Call     : '+Cstr(MaxPubPost);
        3: Str := 'Max Chat Attempts            : '+Cstr(MaxChat);
        4: Str := 'Normal Max MsgLines          : '+Cstr(MaxLines);
        5: Str := 'Co SysOp Max MsgLines        : '+Cstr(CSMaxLines);
        6: Str := 'Max Login Attempts           : '+Cstr(MaxLogonTries);
        7: Str := 'Email to SysOp Base          : '+Cstr(EmailBase);
        8: Str := 'SysOp Chat Color             : '+Cstr(SysOpColor);
        9: Str := 'User Chat Color              : '+Cstr(UserColor);
        10: Str := 'Minimum Space for Posts     : '+Cstr(MinSpaceForPost);
        11: Str := 'Minimum Space for Upload    : '+Cstr(MinSpaceForUpload);
        12: Str := 'Days to keep SysOp log      : '+Cstr(BackSysOpLogs);
        13: Str := 'Screen Blank Time           : '+Cstr(WfcBlankTime);
        14: Str := 'Default Video Length        : '+Cstr(LineLen);
        15: Str := 'Default Page Length         : '+Cstr(PageLen);
        16: Str := 'User Number To Get FeedBack : '+Cstr(SysOpMessage);
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=16;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 1;
      Hook         :=HelpMax;
  End else
  if Str = 'FLAGCFG' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='System Flag Settings';
      for I := 1 to 24 do
     Begin
      case i of
         1: Str :='Check for waiting Mail :'+OnOff(CheckForWaiting);
         2: Str :='Handles Allowed :'+OnOff(AllowAlias);
         3: Str :='Phone Number in Login :'+OnOff(PhonePw);
         4: Str :='Local Security Protection :'+OnOff(LocalSec);
         5: Str :='Local Screen Security :'+OnOff(LocalScreenSec);
         6: Str :='Global Activity Trapping :'+OnOff(GlobalTrap);
         7: Str :='Auto Chat Logging :'+OnOff(AutoChatOpen);
         8: Str :='Auto Message in Login :'+OnOff(AutoMinLogon);
         9: Str :='Bulletins in Login :'+OnOff(BullinLogon);
        10: Str :='Last Few Callers in Login :'+OnOff(LCallInLogon);
        11: Str :='Use Echo/Netmail Errorlevels :'+OnOff(EchoErrorLevel);
        12: Str :='Take Off Hook in Local Login :'+OnOff(OffHookLocalLogon);
        13: Str :='Compress File-Msg Numbers :'+OnOff(CompressBases);
        14: Str :='Check for Duplicate Uploads :'+OnOff(SearchDup);
        15: Str :='Sysop Log Type :'+SlType(SlogType);
        16: Str :='Strip Color Off Log File :'+OnOff(StripClog);
        17: Str :='Send Video via BIOS :'+OnOff(UseBios);
        18: Str :='Snow Checking (CGA) :'+OnOff(CGaSnow);
        19: Str :='Use EMS for OVERLAY File :'+OnOff(UseEms);
        20: Str :='New User Message Sent To :'+Cstr(NewApp);
        21: Str :='Guest User Number :'+Cstr(GuestUser);
        22: Str :='Minutes Before Timeout Bell :'+Cstr(TimeOutBell);
        23: Str :='Minutes Before Timeout :'+Cstr(TimeOut);
        24: Str :='Multi-Node :'+OnOff(MultiNode);
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      PicksPerLine :=2;
      TotalPicks   :=24;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpFlag;
  End else
    if Str = 'NETCFG' then
   With M,Systat do
    with fidor do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='Network Configuration Menu';
      for I := 1 to 9 do
     Begin
      case i of
       1:Str :='Network Address Menu';
       2:Str :='Default Origin Line     '+origin;
       3:Str :='Strip Kludge Lines      '+onoff(skludge);
       4:Str :='Strip SEEN-BY Lines     '+onoff(sseenby);
       5:Str :='Strip Origin Lines      '+onoff(sorigin);
       6:Str :='Color Of Standard Text  '+cstr(text_color);
       7:Str :='Color Of Tear Line      '+cstr(quote_color);
       8:Str :='Color Of Origin line    '+cstr(origin_color);
       9:Str :='Add Tear - Origin Lines '+onoff(addtear);
     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=9;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpNet;
   End else
    if Str = 'NETCFG2' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='Address Configuration Menu';
      for I := 1 to 10 do
     Begin
       Str :=GetAddress(Addr[i].Zone,Addr[i].net,Addr[i].node,
                        Addr[i].point)+addr[i].domain;
       Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=10;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpNet2;
   End else
  if Str= 'WAITFORCALL' then
   With M do
   Begin
      Heading1   :=SoftWareName+' Wait for Call Menu';
      Heading2   :=' ';
      for I := 1 to 19 do
     Begin
      case i of
       1:Str :='C)aller List';
       2:Str :='L)Sysop Logs';
       3:Str :='S)ystem Stats';
       4:Str :='Z)Usage Log';
       5:Str :='A)nswer Modem';
       6:Str :='H)ang UP Modem';
       7:Str :='O)ff Hook';
       8:Str :='+)Init Modem';
       9:Str :='M)ail Read (All)';
      10:Str :='R)ead users Mail';
      11:Str :='W)rite Mail';
      12:Str :='B)MsgBase Config';
      13:Str :='F)ileBase Config';
      14:Str :='E)vent EDIT';
      15:Str :='G)TextFileBase EDIT';
      16:Str :='P)System Misc Config';
      17:Str :='U)ser Edit';
      18:Str :='X)Protocol Edit';
      19:Str :='#)Menu Edit';

     End;  { Case }
        Topic[i] := Str;
      End;
      Margins      :=1;
      PicksPerLine :=3;
      TotalPicks   :=19;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpWait;
   End else

    if Str = 'NETCFG2' then
   With M,Systat do
   Begin
      Heading1   :=SoftWareName+' Configuration';
      Heading2   :='Address Configuration Menu';
      for I := 1 to 10 do
     Begin
       Str :=GetAddress(Addr[i].Zone,Addr[i].net,Addr[i].node,
                        Addr[i].point)+addr[i].domain;
       Topic[i] := Str;
      End;
      Margins      :=1;
      TotalPicks   :=10;
      Colors[1]    :=14;      {HF,HB,LF,LB,Box}
      Colors[2]    :=0;       {HF,HB,LF,LB,Box}
      Colors[3]    :=15;      {HF,HB,LF,LB,Box}
      Colors[4]    :=3;       {HF,HB,LF,LB,Box}
      TopleftXY[1] := 0;        {auto center}
      TopLeftXY[2] := 4;
      Hook         :=HelpNet2;
      End Else
End;

End.
