
{ Record Structure for ShadowBBS  1991                                  }
{ All are subject to change without any notice!                         }
{                                                                       }
{                                                                       }

CONST
  Ver : String[30]='94.01';

  MaxMsgBoards    = 1000;  { 1 - }
  MaxUBoards      = 254;   { 0 - }    { Was 143!! }
  MaxProtocols    = 120;   { 0 - }
  MaxEvents       = 10;    { 0 - }   { #0 is Nightly Events (if active) }
  MaxArcs         = 8;     { 1 - }
  MaxUBatchfiles  = 20;
  MaxMenuCmds     = 50;
  MaxEditors      = 5;
  MaxAka          = 10;
  MaxEchoAreas    = 300;   { Used for Tosser/Packer , need to link list this}
  MaxDownlinks    = 20;    { Unused at this time    }

TYPE
  AStr    =string[160];
  ACString=string[20];            { Access Condition String }
  ACRQ    ='@'..'Z';              { AR flags }

  Uflags = (rlogon,                       { L - Restricted to one call a day }
            rchat,                        { C - Can't page the SysOp }
            rvalidate,                    { V - Posts marked unvalidated }
            rbackspace,                   { B - Can't do ^B/^N/etc in messages }
            ramsg,                        { A - Can't change the AutoMessage }
            rpostan,                      { * - Can't post anonymously }
            rpost,                        { P - Can't post at all }
            remail,                       { E - Can't send any Email }
            rXXX,                         { K - XXX }
            rXXXX,                        { M - XXXX }
            spcsr,                        { }
            onekey,                       { onekey input mode }
            avatar,                       { user has AVATAR }
            pause,                        { pause }
            novice,                       { user is at novice help level }
            ansi,                         { user has ANSI }
            color,                        { user has color }
            alert,                        { alert SysOp when user logs on }
            smw,                          { short-message waiting for user }
            nomail,                       { user mail-box is closed }
            fnodlratio,                   { 1 - No UL/DL ratio }
            fnopostratio,                 { 2 - No post/call ratio }
            fnofilepts,                   { 3 - No file points checking }
            fnodeletion);                 { 4 - Protection from deletion }

  CLRS  = Array [FALSE..TRUE,0..9] of byte; { color records }
  SecRange= array[0..255] of integer;       { security tables }
  CPackDateTime= Array [1..6] of byte;
  FZscanr = Set of 0..MaxUBoards;
  DlNScan = Set of 0..96;

      UOnTypes =(OneHere,TwoHere,ThreeHere,FourHere,FiveHere,
                 SixHere,SevenHere,EightHere);

     OUserOnRecord = Record          { USERON.NODE }
       ONodeOn  : Byte;
       OName,
       OAlias  : String[36];
       ONUser  : Integer;
       OAttr   : Set of UOnTypes;
       UOnStr  : String[255];      { string used for notes and such }
End;


(* -------------------------- END ------------------------------- *)


EditorRecord = Record
             Name                : String[40];
             CommandLine,
             Extra               : String;
             Number,
             ExtraInt            : Integer;
End;

AddressRecord = Record
              Zone,
              Net,
              Node,
              Point  : Integer;
              Domain : String;
End;

BadFileRecord = Record                     { BadFile.Dat     }
                FileName : String[12];     { Contains the list of unwanted files }
         end;

  SMalrec =  record                   { NAMES.LST : Sorted names listing }
    Name,                             { user name/alias   }
    RealName       : String[36];      { RealName    }
    Number         : Integer;         { User number }
  end;


   LastPtrRecord  = Record               { LASTREAD.DAT }
      Ptr     : Array [1..MaxMsgBoards] of Longint;  { Ptr to LRP }
      Scan    : Array [1..MaxMsgBoards] of boolean;  { Does user wish to }
                                                     { scan this base ?  }
      resptr  : Array [1..50] of byte;
  End;

  userrec =  record                   { USER.LST : User account records }
    Name:string[36];                  { user name        }
    RealName:string[36];              { real name        }
    PW:string[20];                    { user password    }
    Ph:string[12];                    { user phone #     }
    BDay,                             { user birthdate   }
    FirstOn,                          { firston date     }
    LastOn:string[8];                 { laston date      }
    EditorChoice   : Byte;
    Street,                           { mailing address  }
    CityState  :string[30];           { city, state      }

    ExtraStrX  : string[30];

    info1,                            { SysOp defined info... }
    info2:string[40];                 { Sysop defined info }
    ZipCode:string[10];               { zipcode          }
    Note:string[39];                  { SysOp note       }

    lockedout,                        { if locked out    }
    deleted:boolean;                  { if deleted       }
    lockedfile:string[8];             { lockout msg to print }

    AC:set of uflags;                 { user flags   }
    AR:set of acrq;                   { AR flags     }

    ZZDLNScn:dlnscan;                 { scan uboards flags }
    Sex:char;                         { user sex }
    TTimeon:longint;                  { total mins spent on  }

    Uk,                               { UL k                 }
    Dk:longint;                       { DL k                 }
    Uploads,
    Downloads,                        { # of ULs / # of DLs  }
    Loggedon,                         { # times logged on    }
    Tltoday,                          { # min left today     }
    Msgpost,                          { # public posts       }
    Emailsent,                        { # email sent         }
    Feedback,                         { # feedback sent      }
    Forusr,                           { forward mail to user # }
    Filepoints:integer;               { # of file points     }

    reservedmail,                     { reserved mail chat byte  }
    linelen,                          { line length (# cols)     }
    pagelen,                          { page length (# rows)     }
    ontoday,                          { # times on today         }
    illegal,                          { # illegal logon attempts }
    sl,
    dsl:byte;                      { SL / DSL }
    cols:clrs;                        { user colors }

    lastmsg,
    lastfil:word;                     { last msg/file areas   }
    credit:longint;                   { $$$ Netmail credit in dollars }

    timebankadd,                      { time added to timebank TODAY }
    timebank:integer;                 { # mins in Time Bank   }

    trapactivity,                     { if trapping users activity }
    trapseperate:boolean;             { if trap to seperate TRAP file }

    mpointer:longint;                 { pointer to entry in MACRO.LST }
    userstartmenu:string[8];          { menu to start user out on }

    chatauto,                         { if auto chat trapping }
    chatseperate,                     { if seperate chat file to trap to }
    slogseperate:boolean;             { seperate SysOp log? }

    clsmsg,                              { 0= menu, 1 =msg, 2= none, 3 Both }
    flistopt,                            { type of file list type to use }
    msgorder,                            { 0:Chrono, 1:ReplyTree }
    avadjust:byte;                       { AVATAR color adjust: 1=no, 2=yes }

    LastReadPtr  : Longint;              { Points to record in LASTREAD.DAT}

    ArcType      : byte;                 { Arctype used for QWK packets }

    Reserved     : Array [1..254] of Byte;     { reserved  }
    resscan      : Array [1..64] of word;      { reserved  }
    resqscn      : Array [1..64] of boolean;   { reserved  }
    resbdsys     : Array [1..3] of byte;       { reserved  }

  end;

  zscanrec=   record              { ZSCAN.DAT : NewScan recs (file) }
    fzscan:fzscanr;               { NewScan file bases }
  end;                            { ** b0..b3 }


  Zlogrec =  record                 { ZLOG.DAT : System log }
    Date:string[8];
    userbaud : Array[0..4] of integer;
    active,calls,newusers,pubpost,
    privpost,fback,criterr,
    uploads,downloads:integer;
    uk,dk:longint;
  end;

  filearcinforec=                 { Archive configuration records }
  record
    active:boolean;               { whether this archive format is active }
    ext:string[3];                { 3-chr file extension }
    listline,                     { /x for internal;     }
                                  { x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline, '' for *None* }
    cmtline:string[25];           { comment cmdline, '' for *None* }
    succlevel:integer;            { success ERRORLEVEL, -1=ignore results }
  end;


  fstringrec =  record                { STRING.DAT }
    ansiq:string[80];                 { "Do you want ANSI? " string }
    note:array[1..2] of string[80];   { Logon notes (L #1-2) }
    lprompt:string[80];               { Logon prompt (L #3) }
    echoc:char;                       { Echo char for PWs }
    sysopin,                          { "SysOp In" (inside SysOp hours)}
    sysopout,                         { "SysOp Out" }
    engage,                           { "Engage Chat" }
    endchat,                          { "End Chat" }
    wait,                             { "SysOp Working" }
    pause,                            { "Pause" }
    entermsg1,                        { "Enter Message" line #1 }
    entermsg2,                        { "Enter Message" line #2 }
    newscan1,                         { "NewScan begin" }
    newscan2,                         { "NewScan done" }
    scanmessage,                      { Message scanning prompt }
    automsgt:string[80];              { Auto-Message title }
    autom:char;                       { Auto-Message border characters }

    shelldos1,                        { " >> SysOp shelling to DOS ..." }
    shelldos2,                        { " ... thank you for waiting." }
    chatcall1,                        { "Paging SysOp, please wait..." }
    chatcall2,                        { ">>><*><<<" }
    guestline,                        { "To be a guest ... " }
    namenotfound,                     { "Name NOT found in user list." }
    bulletinline,                     { Bulletin line }
    scanwait,                         { "Scanning for Waiting Mail..." }

    listline,                         { "List files - P to pause" }
    newline,                          { "Search for new files -" }
    searchline,                       { "Search all dirs for file mask" }
    findline1,                        { "Search for descriptions... " }
    findline2,                        { "Enter the string to search for.." }
    downloadline,                     { "Download - " }
    uploadline,                       { "Upload - " }
    viewline,                         { "View interior files - " }
    nofilepts,                        { "Insufficient file points." }
    unbalance,                        { "Your UL/DL ratio is unbalanced" }

    Info1,                            { "What is your favorite Hobby?"}
    Info2,                            { "What can you contribute to this BBS?"}
    pninfo,                           { "P to Pause, N for next dir" }
    gfnline1,                         { "[Enter]=All files" }
    gfnline2,                         { "File mask: " }
    batchadd:string[80];              { "File added to batch queue." }
  end;

  systatrec = record                  { SHADOW.DAT }

    GFilePath,                        { GFILES path }
    AFilepath,                        { AFILES path (text files path) }
    MenuPath,                         { MENUS path  }
    TrapPath,                         { LOG path (traps, chats, SysOp logs) }
    MsgPath,                          { MSG path (priv/pub mail path) }
    TFilePath,                        { TFILES path }
    Swappath,                         { swap shell path }
    SemaPath,
    OvrPath,
    TempPath,
    NetFilePath,
    NetMailPath:string[79];           { TEMP path - "temp" directory }

    BBSName:string[80];               { BBS name }
    BBSPhone:string[12];              { BBS phone number }
    SysopName:string[30];             { SysOp's full name or alias }

    Addr : Array [1..MaxAka] of AddressRecord; { Address/AKAs }

    MaxUsers,                         { max number of users system can have }
    Lowtime,                          { SysOp begin minute (in minutes) }
    Hitime,                           { SysOp end time }
    DLlowtime,                        { normal downloading hours begin.. }
    DLHitime:integer;                 { ..and end }

    MultiNode,
    Lock300:boolean;                  { lock out 300 baud? }

    SysopPw,                          { SysOp PW }
    NewuserPw   :string[20];          { newuser PW (or NULL if none) }
    QWKFilename : string[8];
    PSExtra  : string[11];

    B300lowtime,                      { 300 baud calling hours begin.. }
    B300hitime,                       { ..and end }
    B300dllowtime,                    { 300 baud downloading hours begin.. }
    B300dlhitime:integer;             { ..and end }

    Closedsystem,                     { DON'T allow new users? }
    SwapShell:boolean;                { is swap shell function enabled? }
    Eventwarningtime:integer;         { time before event warning }
    TFiledate:string[8];              { last date text-files were inserted }
    LongExtra : longint;

    Sop,                              { SysOp }
    CSop,                             { Co-SysOp }
    MSop,                             { Message SysOp }
    FSop,                             { File SysOp }
    Spw,                              { SysOp PW at logon }
    SeePw,                            { see SysOp PWs remotely  }
    NormPubPost,                      { make normal public posts }
    NormPrivPost,                     { send normal e-mail }
    AnonPubRead,                      { see who posted public anon }
    AnonPrivRead,                     { see who sent anon e-mail }
    AnonPubPost,                      { make anon posts }
    AXXX,                             { XXX }
    SeeUnVal,                         { see unvalidated files }
    DLunVal,                          { DL unvalidated files }
    NoDLRatio,                        { no UL/DL ratio }
    NoPostRatio,                      { no post/call ratio }
    NoFilePts,                        { no file points checking }
    UlValReq:acstring;                { uploads require validation by SysOp }

    MaxPrivPost,                      { max e-mail can send per call }
    MaxFBack,                         { max feedback per call }
    MaxPubPost,                       { max posts per call }
    MaxChat,                          { max chat-pages per call }
    MaxWaiting,                       { max mail in mail-box }
    CSMaxWaiting,                     { max mail in mail-box for Co-SysOp + }
    Maxlines,                         { max lines in message }
    CSMaxlines,                       { max lines in message for Co-SysOp + }
    MaxlogonTries,                    { tries allowed for PW's at logon }
    SysopColor,                       { SysOp color in chat mode }
    UserColor:byte;                   { user color in chat mode }

    EmailBase : Word;                 { Mesage base to send FeedBack/Sysop Mail }
    SysOpMessage : integer;           { User # who recieves FeedBAck/SysOp messages }

    MinSpaceForPost,                  { minimum K drive space left to post }
    MinSpaceForUpload:integer;        { minimum K drive space left to upload }

    Backsysoplogs,                    { days to keep SYSOP##.LOG }
    WFCblanktime:byte;                { minutes after which to blank WFC menu }
    Linelen,                          { default video line length }
    Pagelen:byte;                     { default video page length }

    Checkforwaiting,                  { Check for waiting mail in login? }
    Allowalias,                       { allow alias's? (handles) }
    Phonepw,                          { use phone number password in logon? }
    Localsec,                         { is local security ON? }
    Localscreensec,                   { is local screen-security ON? }
    Globaltrap,                       { trap ALL USER'S activity? }
    Autochatopen,                     { does chat buffer auto-open? }
    Autominlogon,                     { Auto-Message in logon? }
    Bullinlogon,                      { bulletins in logon? }
    Lcallinlogon,                     { "Last Few Callers" list in logon? }
    Yourinfoinlogon,                  { "Your Info" in logon? }
    EchoErrorLevel,                   { Exit with Error level 4 when echo mail is entered?}
    Offhooklocallogon,                { take phone off-hook for local logons? }
    Forcevoting,                      { is manditory logon voting active? }
    Compressbases,                    { "compress" file/message base numbers? }
    Searchdup,                        { search for dup. filenames when UL? }
    Stripclog:boolean;                { strip colors from SysOp log output? }

    Slogtype:byte;                    { SysOp log type: File/Printer/Both }

    Newapp,                           { user# to send new user application to }
    Guestuser,                        { user# of guest user account }
    Timeoutbell,                      { minutes before time-out bell }
    Timeout:integer;                  { minutes before timeout (logoff) }

    Useems,                           { attempt to use EMS for overlay }
    Usebios,                          { use ROM BIOS for local video output }
    Cgasnow,                          { suppress snow on CGA systems }
    Uldlratio,                        { are UL/DL ratios active? }
    Fileptratio:boolean;              { is auto file-pt compensation active? }
    Filearcinfo:array[1..maxarcs] of filearcinforec; { archive specs }
    Filearccomment:array[1..3] of string[80]; { BBS comments for archives }
    Fileptcomp,                       { file point compensation ratio }
    Fileptcompbasesize,               { file point "base compensation size" }
    Ulrefund,                         { percent time refund for ULs }
    Tosysopdir:byte;                  { "To SysOp" file base }
    Validateallfiles:boolean;         { validate ALL FILES automatically? }
    Remdevice:string[10];             { remote output device (GATEx,COMx,etc) }
    Maxintemp,                        { max K allowed in TEMP\3\ }
    Minresume:integer;                { min K to allow resume-later }
    Maxdbatch,                        { max files in DL batch queue }
    Maxubatch:byte;                   { max files in UL batch queue }

    Newsl,                            { newuser SL }
    Newdsl:byte;                      { newuser DSL }
    Newar:set of acrq;                { newuser AR }
    Newac:set of uflags;              { newuser AC }
    Newfp:integer;                    { newuser file points }
    Autosl,                           { auto-validation SL }
    Autodsl:byte;                     { auto-validation DSL }
    Autoar:set of acrq;               { auto-validation AR }
    Autoac:set of uflags;             { auto-validation AC }

    Allstartmenu:string[8];           { logon menu to start ALL users on }
    Chatcfilter1,                     { SysOp chat color-filter }
    Chatcfilter2:string[12];          { user chat color-filter }
    Bulletprefix:string[8];           { default bulletins filename prefix }

    Timeallow,                        { time allowance }
    Callallow,                        { call allowance }
    Dlratio,                          { # ULs/# DLs ratios }
    Dlkratio,                         { DLk/ULk ratios }
    Postratio:secrange;               { post/call ratios }
    Postcredits:integer;    {file points/upload credit compensation for posts}

    Lastdate:string[8];               { last system date }
    Curwindow:byte;                   { type of SysOp window currently in use }
    Istopwindow:boolean;              { is SysOp window on top of screen? }
    Callernum:longint;                { total number of callers }
    Numusers:integer;                 { number of users }

    Todayzlog:zlogrec;                { TODAY's ZLOG record }


    Rebootforevent,                   { reboot before events? }
    ExtraStuffB       : boolean;

    Windowon:boolean;

  { Modem Information               }

    Waitbaud:word;               { wait baud }
    Comport:byte;                { comport number }
    Init:string[80];             { initialization string }
    Answer:string[40];           { answer string }
    Hangup:string[40];           { hangup string }
    Offhook:string[40];          { phone off-hook string }
    Nocallinittime:integer;      { reinit modem after x mins of inactivity }
    Lockedportbaud:word;         { baud rate to use when COM port locked }
    Lockedport:boolean;          { whether COM port is locked }
    Nocarrier:integer;           { no carrier result code }
    Nodialtone:integer;          { no dialtone result code }
    Busy:integer;                { busy result code }
    Resultcode:array[1..2,0..4] of integer;     { Result codes }

    Editor : Array [1..MaxEditors] of EditorRecord;
  end;

  TBflags=
   (tbunhidden,                   { whether *VISIBLE* to users w/o access }
    tbnetlink,                    { whether Net Linked to other SYSTEMS }
    tbisdir);                     { if a text-file base directory }

  tfilerec =  record              { GFILES.DAT : Text-file records }
    title:string[40];             { title }
    filen:string[12];             { filename }
    gdate:string[8];              { date of Tfile / Tfile base }
    gdaten:integer;               { numeric date for fast calculation }
    acs,                          { access requirement }
    ulacs:acstring;               { upload to base access requirement }
    tbstat:set of tbflags;        { text-file base status vars }
    permindx:longint;             { permanent index # }
    tbdepth:integer;              { tfile base dir depth }
    res:array[1..4] of byte;      { RESERVED }
  end;

  smr =   record                  { SHORTMSG.DAT : One-line messages }
    msg:astr;
    destin:integer;
  end;



  fbflags=
   (fbnoratio,                    { if <No Ratio> active }
    fbunhidden,                   { whether *VISIBLE* to users w/o access }
    fbdirdlpath,                  { if *.DIR file stored in DLPATH }
    fbisdir,                      { if a file base directory }
    fbusegifspecs,                { whether to use GifSpecs }
    fbnetlink);                   { whether Net-Linked to other Telegards }

  ulrec=                          { UPLOADS.DAT : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:integer;             { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    fbdepth:integer;              { file base dir depth }
    fbstat:set of fbflags;        { file base status vars }
    acs,                          { access requirements }
    ulacs,                        { upload requirements }
    nameacs:acstring;             { see-names requirements }
    permindx:longint;             { permanent index # }
    res:array[1..6] of byte;      { RESERVED }
  end;

  filstat=
   (notval,                       { if file is NOT validated }
    isrequest,                    { if file is REQUEST }
    resumelater);                 { if file is RESUME-LATER }

Ulfrec= Record                         { *.DIR : File records }

    filename:string[12];          { Filename }
    description:string[60];       { File description }
    filepoints:integer;           { File points }
    nacc:integer;                 { Number DLs }
    ft:byte;                      { File type (useless?) }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:integer;                { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;

  verbrec=                        { VERBOSE.DAT : Verbose descriptions }
  record
    descr:array[1..4] of string[50];
  end;

  lcallers=                       { LASTON.DAT : Last few callers records }
  record
    callernum:integer;            { system caller number }
    name:string[36];              { user name of caller }
    number:integer;               { user number of caller }
    citystate:string[30];         { city/state of caller }
  end;

  eventrec=                       { EVENTS.DAT : Event records }
  record
    active:boolean;               { whether active }
    description:string[30];       { event description (for logs) }
    etype:char;                   { A:CS, C:hat, D:os call, E:xternal }
    execdata:string[20];          { errorlevel if "E", commandline if "D" }
    busytime:integer;             { off-hook time before; 0 if none }
    exectime:integer;             { time of execution }
    busyduring:boolean;           { busy phone DURING event? }
    duration:integer;             { length of time event takes }
    execdays:byte;                { bitwise execution days or day of month if monthly }
    monthly:boolean;              { monthly event? }
  end;

  macrorec=                       { MACROS.LST : Macro records }
  record
    macro:array[1..4] of string[240];
  end;

  mnuflags=
   (clrscrbefore,                 { C: clear screen before menu display }
    dontcenter,                   { D: don't center the menu titles! }
    nomenuprompt,                 { N: no menu prompt whatsoever? }
    forcepause,                   { P: force a pause before menu display? }
    autotime);                    { T: is time displayed automatically? }

  menurec=                        { *.MNU : Menu records }
  record
    menuname:array[1..3] of string[100]; { menu name }
    directive,                           { help file displayed }
    tutorial:string[12];                 { tutorial help file }
    menuprompt:string[120];              { menu prompt }
    acs:acstring;                        { access requirements }
    password:string[15];                 { password required }
    fallback:string[8];                  { fallback menu }
    forcehelplevel:byte;                 { forced help level for menu }
    gencols:byte;                        { generic menus: # of columns }
    gcol:array[1..3] of byte;            { generic menus: colors }
    menuflags:set of mnuflags;           { menu status variables }
  end;

  cmdflags=
   (hidden,                       { H: is command ALWAYS hidden? }
    unhidden);                    { U: is command ALWAYS visible? }

  commandrec=                       { *.MNU : Command records }
  record
    ldesc:string[70];               { long command description }
    sdesc:string[35];               { short command description }
    ckeys:string[14];               { command-execution keys }
    acs:acstring;                   { access requirements }
    cmdkeys:string[2];              { command keys: type of command }
    mstring:string[50];             { MString: command data }
    commandflags:set of cmdflags;   { command status variables }
  end;

  xbflags=
      (xbactive,
       xbisbatch,
       xbisresume,
       xbxferokcode);

  protrec = record              { PROTOCOL.DAT }

    xbstat:set of xbflags;                       { protocol flags }
    ckeys:string[14];                            { command keys }
    descr:string[40];                            { description }
    acs:acstring;                                { access string }
    templog:string[25];                          { temp. log file }
    uloadlog,dloadlog:string[25];                { permanent log files }
    ulcmd,dlcmd:string[78];                      { UL/DL commandlines }
    ulcode,dlcode:array [1..6] of string[6];     { UL/DL codes }
    envcmd:string[60];                           { environment setup cmd }
    dlflist:string[25];                          { DL file lists }
    maxchrs:integer;                             { max chrs in cmdline }
    logpf,logps:integer;                         { pos in log file for data }
    permindx:longint;                            { permanent index # }
    res:array[1..11] of byte;                    { RESERVED }
  end;

  datetimerec=
  record
    day,hour,min,sec:longint;
  end;

  cfilterrec=array[0..255] of byte;          { color filter record }

  fidorec=                          { NETWORK.DAT :Echo/FidoNet information }
  record
    origin:string[50];              { origin line }
    text_color:byte;                { color of standard text }
    quote_color:byte;               { color of quoted text }
    tear_color:byte;                { color of tear line }
    origin_color:byte;              { color of origin line }
    skludge:boolean;                { strip kludge lines? }
    sseenby:boolean;                { strip SEEN-BY lines? }
    sorigin:boolean;                { strip origin line? }
    scenter:boolean;                { strip TG centering codes? }
    sbox:boolean;                   { strip TG box codes? }
    mcenter:boolean;                { center boxed/centered lines? }
    addtear:boolean;                { add tear/origin lines? }
    echopath:string[40];            { default EchoMail path }
    grouppath:string[40];           { default GroupMail path }
    res:array[1..1896] of byte;     { RESERVED }
  end;

(* Message base Structure for Shadow BBS Copyright by Mike Wilson    *)
(* AllRights reserved; 1991                                          *)
(*      SEEKHERE                                                     *)

CONST
 ThisRec     = 1;    { Used for MsgTXT stuff... }
 NextRec     = 2;
 PreviousRec = 3;

TYPE

  MsgTypes     =(EchoMail,NetMail,Local,Private,Public,Recieved,
                 Sent,MsgDeleted,Validated,PermMessage,
                 MsgTypeRes1,MsgTypeRes2,MsgTypeRes3);
  AnonTypes    =(UseAlias,UserSelect,DearAbby,ForceAlias,RealNameOnly,
                 AliasReserv1,AliasReserve2);
  MsgBaseTypes =(PrivateBase,PublicBase,PubPrivBase,
                 EchoBase,NetBase,MsgHidden,MsgUnHidden,
                 MsgBaseRes1,MsgBaseRes2,MsgBaseRes3);

   MsgHdrRecord = Record                     { *.HDR }
     WhoTo,                        { Message is To :          }
     FromReal,                     { Message is FROM REALNAME }
     FromAlias,                    { Message is FROM Alias    }
     Sub        : String[45];      { Message Subeject         }
     MsgType    : Set of MsgTypes; { Msg Type, Private/Public/Net/Echo/Local }
     Date_Time,                    { Packed Date/Time Message was posted }
     MsgTxtPtr  : LongInt;         { Pointer to Message text in MsgTxt   }
     MsgTxtRecs : Word;            { The number of records of text to read }
     Reply      : Array[1..3] of Longint; { Reply tree 1= ThisMessage    }
                                          { 2= NextReply 3= Previous reply}
                                          { this is a pointer to the header}
                                          { that has/is the replys...       }
End;


 TxtRecord = Record                          { *.TXT }
           Text : String;           { Text In String format 255 chars }
End;


 LastReadRecord = Record                       {*.LRP }
          LastMsg : LongInt;             { Points to last Read message in   }
                                         { this base }
End;

                                        { *.DLN }
 DownLinkRecord = Record
          Addr  : Array[1..MaxDownlinks] of AddressRecord;
End;


   GlobalMsgRecord = Record                     { GMAIL.DAT }
         WhomTo,                                { WhoTo?    }
         Subj        : String[45];              { Subject   }
         BoardNum    : Word;                    { Board number msg is in }
         MsgNumber   : Longint;                 { Msgnumber in Board     }
End;
            

    MsgBoardsRecord = Record               { MSGBRDS.DAT            }
       Name          : String[50];         { Message Board Name     }
       FileName      : String[8];          { Message Board FileName }
       Path          : String[80];         { PathTo MessageBoard    }
       Password,
       TagName       : String[45];
       AKA           : Byte;               { Address to use... }
       NetWork       : FidoRec;            { NetWork/FidoNEt configs}
       MsgBaseType   : Set of MsgBaseTypes;{ Message Base types...  }
       AnonType      : Set of AnonTypes;   { Anonymous Types        }
       Acs           : Acstring;           { Access string          }
       KillRecieved  : Boolean;            { Kill Recieved Messages?}
       OldMail       : Integer;            { Kill mail after XX days}
       MaxMessages,                        { Max Messages to have   }
       FirstMsg,                           { First Msg Number       }
       LastMsg,                            { Last Msg Number        }
       TotalMsgs,                          { Total Messages Active !}
       DlPtr         : LongInt;            { Pointer to Downlink file}
       Reserved      : Array [1..600] of Byte;
End;


   ScanEchoRecord = Record                   { ECHOMAIL.EXP       }
                  ScanBoardNum : Word;       { MsgBoardNumber     }
                  ScanMsgNum   : LongInt;    { Msg number to scan }
 End;


(* ---------------- File "STRUCT.111"-------------------------- *)

(* Structures document for RemoteAccess 1.10/1.11/Noncommercial. *)
(* May be freely distributed in unmodified form and used         *)
(* by third-party developers. This document is Copyright         *)
(* (C) 1991 Andrew Milner and Continental Software.              *)


type
  AskType        = (Yes, No, Ask, Only);
  VideoType      = (Auto, Short, Long);
  OrphanType     = (Ignore, Create, Kill);
  FlagType       = array[1..4] of Byte;
  RATime           = String[5];
  RADate           = String[8];
  LongDate       = String[9];

  NetAddress     = record
                     Zone,
                     Net,
                     Node,
                     Point          : Word;
                   end;

  MSGTOIDXrecord = String[35];

  USERONrecord   = record
                     Name,
                     Handle         : MSGTOIDXrecord;
                     Line           : Byte;
                     Baud           : Word;
                     City           : String[25];
                     DoNotDisturb   : Boolean;
                     Status         : Byte;
                     Attribute      : Byte;
                   end;

                   { Status byte - 0 : Browsing (in a menu)
                                   1 : Uploading/downloading
                                   2 : Reading/posting messages
                                   3 : In a door/external utility
                                   4 : Chatting with sysop
                                   5 : Answering questionnaire 
                                   6 : System ready (0=busy)

                     Attribute   - Bit 0 : Hidden }

  RALASTREADrecord = array[1..200] of Word;

  COMBINEDrecord = array[1..25] of Byte;

  USERSIDXrecord = record
                     NameCRC32,
                     HandleCRC32    : LongInt;
                   end;

  USERSXIrecord  = record
                     Handle         : String[35];
                     Comment        : String[80];
                     FirstDate      : RADate;
                     CombinedInfo   : COMBINEDrecord;
                     BirthDate,
                     SubDate        : RADate;
                     ScreenWidth,
                     MsgArea,
                     FileArea,
                     Language,
                     DateFormat     : Byte;      
                     ForwardTo      : String[35];
                     ExtraSpace     : Array[1..43] of Byte;
                   end;

  USERSrecord    = record
                     Name           : MSGTOIDXrecord;
                     Location       : String[25];
                     Password       : String[15];
                     DataPhone,
                     VoicePhone     : String[12];
                     LastTime       : RATime;
                     LastDate       : RADate;
                     Attribute      : Byte;

                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }

                     Flags          : FlagType;
                     Credit,
                     Pending        : Word;
                     MsgsPosted,
                     LastRead,
                     Security,
                     NoCalls,
                     Ups,
                     Downs,
                     UpK,
                     DownK     : Word;
                     TodayK,
                     Elapsed        : Integer;
                     ScreenLength   : Word;
                     LastPwdChange,
                     Attribute2,

                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist }


                     Group          : Byte;
                     XIrecord       : Word;
                     ExtraSpace     : array[1..3] of Byte;
                   end;

  SYSINFOrecord  = record
                     TotalCalls     : LongInt;
                     LastCaller     : MSGTOIDXrecord;
                     ExtraSpace     : array[1..128] of Byte;
                   end;

  TIMELOGrecord  = record
                     StartDate      : RADate;
                     BusyPerHour    : array[0..23] of Word;
                     BusyPerDay     : array[0..6] of Word;
                   end;

  EVENTrecord    = record
                     Status         : Byte; { 0=Deleted 1=Enabled 2=Disabled }
                     StartTime      : RATime;
                     ErrorLevel     : Byte;
                     Days           : Byte;
                     Forced         : Boolean;
                     LastTimeRun    : RADate;
                   end;

  EVENTrecordArray = array[1..20] of EVENTrecord;

  CONFIGrecord = record
    VersionID           : Word;
    CommPort            : Byte;
    Baud                : LongInt;
    InitTries           : Byte;
    InitStr,
    BusyStr             : String[70];
    InitResp,
    BusyResp,
    Connect300,
    Connect1200,
    Connect2400,
    Connect4800,
    Connect9600,
    Connect19k,
    Connect38k          : String[40];
    AnswerPhone         : Boolean;
    Ring,
    AnswerStr           : String[20];
    FlushBuffer         : Boolean;
    ModemDelay          : Integer;

    MinimumBaud,
    GraphicsBaud,
    TransferBaud        : Integer;
    SlowBaudTimeStart,
    SlowBaudTimeEnd,
    DownloadTimeStart,
    DownloadTimeEnd     : RATime;

    PageStart           : Array[0..6] of RATime;
    PageEnd             : Array[0..6] of RaTime;

{}  FreeSpace1          : Array[1..70] of Byte;
    PwdExpiry           : Word;

    MenuPath,
    TextPath,
    AttachPath,
    NodelistPath,
    MsgBasePath,
    SysPath,
    ExternalEdCmd       : String[60];

    Address             : Array[0..9] of NetAddress;
    SystemName          : String[30];

    NewSecurity         : Word;
    NewCredit           : Word;
    NewFlags            : FlagType;

    OriginLine          : String[60];
    QuoteString         : String[15];
    Sysop               : String[35];
    LogFileName         : String[60];
    FastLogon,
    AllowSysRem,
    MonoMode,
    StrictPwdChecking,
    DirectWrite,
    SnowCheck           : Boolean;
    CreditFactor        : Integer;

    UserTimeOut,
    LogonTime,
    PasswordTries,
    MaxPage,
    PageLength          : Word;
    CheckForMultiLogon,
    ExcludeSysopFromList,
    OneWordNames        : Boolean;
    CheckMail           : AskType;
    AskVoicePhone,
    AskDataPhone,
    DoFullMailCheck,
    AllowFileShells,
    FixUploadDates,
    FreezeChat          : Boolean;
    ANSI,                       { ANSI: Yes, no, or ask new users     }
    ClearScreen,                { Clear:        "                     }
    MorePrompt          : AskType;    { More:         "                     }
    UploadMsgs          : Boolean;
    KillSent            : AskType;    { Kill/Sent     "                     }

    CrashAskSec         : Word;       { Min sec# to ask 'Crash Mail ?'      }
    CrashAskFlags       : FlagType;
    CrashSec            : Word;       { Min sec# to always send crash mail. }
    CrashFlags          : FlagType;
    FAttachSec          : Word;       {        "    ask 'File Attach ?'     }
    FAttachFlags        : FlagType;

    NormFore,
    NormBack,
    StatFore,
    StatBack,
    HiBack,
    HiFore,
    WindFore,
    WindBack,
    ExitLocal,
    Exit300,
    Exit1200,
    Exit2400,
    Exit4800,
    Exit9600,
    Exit19k,
    Exit38k             : Byte;

    MultiLine           : Boolean;
    MinPwdLen           : Byte;
    MinUpSpace          : Word;
    HotKeys             : AskType;
    BorderFore,
    BorderBack,
    BarFore,
    BarBack,
    LogStyle,
    MultiTasker,
    PwdBoard            : Byte;
    BufferSize          : Word;
    FKeys               : Array[1..10] of String[60];

    WhyPage             : Boolean;
    LeaveMsg            : Byte;
    ShowMissingFiles    : Boolean;
{}  FreeSpace2          : Array[1..11] of Byte;
    AllowNetmailReplies : Boolean;
    LogonPrompt         : String[40];
    CheckNewFiles       : AskType;
    ReplyHeader         : String[60];
    BlankSecs           : byte;
    ProtocolAttrib      : Array[1..6] of Byte;
    ErrorFreeString     : String[15];
    DefaultCombined     : COMBINEDrecord;
    RenumThreshold      : Word;
    LeftBracket,
    RightBracket        : Char;
    AskForHandle        : Boolean;
    AskForBirthDate     : Boolean;

    GroupMailSec        : Word;

    ConfirmMsgDeletes   : Boolean;
    FreeSpace3          : Array[1..163] of Byte;
    NewUserGroup        : Byte;
    AVATAR              : AskType;
    BadPwdArea          : Byte;
    Location            : String[40];
    DoAfterAction       : Byte; {0 = wait for CR, > 0 = wait for x seconds}
    FileLine            : String[40];
    CRfore,
    CRback              : Byte;
    LangHdr             : String[40];
    SendBreak           : Boolean;
    ListPath            : String[60];
    FullMsgView         : AskType;
    EMSI_Enable         : AskType;
    EMSI_NewUser        : Boolean;

    EchoChar            : String[1];
    Connect7200,
    Connect12000,
    Connect14400        : String[40];
    Exit7200,
    Exit12000,
    Exit14400           : Byte;
    ChatCommand         : String[60];
    ExtEd               : AskType;
    NewuserLanguage     : Byte;
    LanguagePrompt      : String[40];
    VideoMode           : VideoType;
    AutoDetectANSI      : Boolean;
    OffHook             : Boolean;
    NewUserDateFormat   : Byte;
    KeyboardPwd         : String[15];
    CapLocation         : Boolean;
    NewuserSub          : Byte;
    PrinterName         : String[4];
    HilitePromptFore,
    HiLitePromptBack    : Byte;
    InitStr2            : String[70];
    AltJSwap            : Boolean;
    SemPath             : String[60];
    AutoChatCapture     : Boolean;

    FutureExpansion : Array[1..97] of Byte;
  end;

  EXITrecord = record
                     BaudRate         : Word;
                     SysInfo          : SYSINFOrecord;
                     TimeLogInfo      : TIMELOGrecord;
                     UserInfo         : USERSrecord;
                     EventInfo        : EVENTrecord;
                     NetMailEntered,
                     EchoMailEntered  : Boolean;
                     LoginTime        : RATime;
                     LoginDate        : RADate;
                     TmLimit        : Word;
                     LoginSec,
                     Credit           : LongInt;
                     UserRecNum       : Integer;
                     ReadThru,
                     NumberPages,
                     DownLimit    : Word;
                     TimeOfCreation   : RATime;
                     LogonPassword    : String[15];
                     WantChat         : Boolean;

                     DeductedTime     : Integer;
                     MenuStack        : Array[1..50] of String[8];
                     MenuStackPointer : Byte;
                     UserXIinfo       : USERSXIrecord;
                     ErrorFreeConnect,
                     SysopNext        : Boolean;

                     EMSI_Session     : Boolean;        { These fields hold  }
                     EMSI_Crtdef,                       { data related to an }
                     EMSI_Protocols,                    { EMSI session       }
                     EMSI_Capabilities,
                     EMSI_Requests,
                     EMSI_Software    : String[40];
                     Hold_Attr1,
                     Hold_Attr2,
                     Hold_Len         : Byte;

                     ExtraSpace       : Array[1..100] of Byte;
                 end;

(* End of file "STRUCT.111" *)

