(* 26 August 1996 Updated *)

{ OCT 97 - Fixed Bug which didn't display the selected file area }
{          Added HoldPage                                        }


{ OCT 97 - Release Notes                                         }
{ Used to select a main file area                                }
{ There is a bug in here, which dosen't update the display with  }
{ selected file area                                             }

Unit MainFile;

interface

Uses Crt, Data, Lib, Colours, ErrorLog, WaitTix;

procedure SysopOpenCloseMainAreas;
procedure SelectMainFileArea(Area : Word);

implementation

procedure SysopOpenCloseMainAreas;
Var
  Step,
  Code    : word;
  AreaNum : longInt;
  Done    : Boolean;
begin
  Done := False;
  Val(SAreas.AreaNumber, AreaNum, Code);
  Repeat
    ClearDisplay(True);
    Colour(FCyan);
    LineFeed;
    Print('     File Area                       Sub Areas      File Total     Status');
    LineFeed;
    LineFeed;
    for step := 0 to FileSize(CatArea) - 1 do
      begin
        {$I-} Seek(CatArea, Step);
              Read(CatArea, SAreas); {$I+}
        FileError := IOResult;
        If FileError <> 0 then
          begin
            LogError('Unable To read Area File - ' + ErrorString(FileError));
          end;
        Colour(FYellow);
        Print('  ' + SAreas.AreaNumber + '. ');
        Colour(FWhite);
        Print(SAreas.Description);
        SetX('48');
        If SAreas.OpenClosed then
          begin
            Colour(FGreen);
            Print('OPEN');
          end
        Else
          begin
            BlinkOn;
            Colour(FGreen);
            Print('CLOSED');
            BlinkOff;
          end;
        LineFeed;
      end;
     LineFeed;
     LineFeed;
     Colour(FYellow);
     Print('Sysop Press File Number To Toggle Open/Closed - Blank To Exit ');
     Response := ReadKB(5);
     Val(Response, Step, Code);
     if (Step <= 0) or (Step > FileSize(CatArea)) then
       begin
         {$I-} Seek(CatArea, AreaNum - 1);
               Read(CatArea, SAreas); {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File Category Area File - ' + ErrorString(FileError));
         Done := True;
      end
    Else
      begin
        {$I-} Seek(CatArea, Step - 1);
              Read(CatArea, SAreas); {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File Category Area File - ' + ErrorString(FileError));
         If SAreas.OpenClosed then
           begin
            SAreas.OpenClosed := False;
            Seek(CatArea, Step - 1);
            Write(CatArea, SAreas);
          end
       Else
         begin
            SAreas.OpenClosed := True;
            {$I-} Seek(CatArea, Step - 1);
                  Write(CatArea, SAreas); {$I+}
            FileError := IOResult;
         If FileError <> 0 then LogError('Error Writing To File Category Area File - ' + ErrorString(FileError));
         end;
       Seek(CatArea, AreaNum - 1);
       Read(CatArea, SAreas);
     end;
  Until Done;
  LineFeed;
  LineFeed;
end;

function ListAreas: Integer;
Var
  PageInc       : Byte;
  Step,
  Code          : word;
  TFile,
  TSub,
  AreaNum       : longInt;
  Strgs,
  CurrentArea   : string;
begin
  TSub  := 0;
  TFile := 0;
  CurrentArea := SAreas.Description;
  Val(SAreas.AreaNumber, AreaNum, Code);
  ClearDisplay(True);
  Colour(FCyan);
  LineFeed;
  Print('     File Area                       Sub Areas      File Total     Status');
  LineFeed;
  LineFeed;
  PageInc := 0;
  for step := 0 to FileSize(CatArea) - 1 do
    begin
      {$I-} Seek(CatArea, Step);
            Read(CatArea, SAreas); {I+}
      FileError := IOResult;
      If FileError <> 0 then LogError('Error Reading File Categorys File - ' + ErrorString(FileError));
      Colour(FYellow);
      Print('  ' + SAreas.AreaNumber + '. ');
      Colour(FWhite);
      Print(SAreas.Description);
      Colour(FMagenta);
      SetX('42');
      Strgs := '';
      str(SAreas.CatNumber, strgs);
      Print(Strgs);
      TSub := TSub + SAreas.CatNumber;
      SetX('57');
      Strgs := '';
      Str(SAreas.FileNumber, Strgs);
      Print(Strgs);
      Tfile := TFile + SAreas.FileNumber;
      SetX('68');
      If SAreas.OpenClosed then
        begin
          Colour(FGreen);
          Print('OPEN');
        end
      Else
        begin
          BlinkOn;
          Colour(FGreen);
          Print('CLOSED');
          BlinkOff;
        end;
      inc(PageInc);
      LineFeed;
      if (PageInc = (UserInfo.UserLines - 3)) then
        begin
          PageInc := 0;
          HoldPage;
        end;
    end;
   LineFeed;
   SetX('32');
   Write('Totals');
   SetX('42');
   Colour(FCyan);
   Str(TSub, Strgs);
   Print(Strgs);
   SetX('57');
   Strgs := '';
   Str(TFile,Strgs);
   Print(Strgs);
   LineFeed;
   LineFeed;
   Colour(FWhite);
   Print('Current File Area : ');
   Colour(FCyan);
   Print(CurrentArea);
   LineFeed;
   LineFeed;
   Colour(FYellow);
   Print('Please Select File Area or Q To Exit : ');
   Response := ReadKB(5);
   if Response <> 'Q' then
    begin
      Val(Response, Step, Code);
      if (Step <= 0) or (Step > FileSize(CatArea)) then
        begin
          {$I-}
          Seek(CatArea, AreaNum - 1);
          Read(CatArea, SAreas);
          {$I+}
          FileError := IOResult;
          If FileError <> 0 then LogError('Error Reading File - ' + ErrorString(FileError));
       end
     Else
      begin
         {$I-} Seek(CatArea, Step - 1);
               Read(CatArea, SAreas);  {$I+}
         FileError := IOResult;
         If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError));
         If SAreas.OpenClosed then
           begin
             {$I-} Close(FileArea); {$I+}
             If IOResult <> 0 Then LogError('Unable To Close File Area - ' + ErrorString(IOResult));
             {$I-} Assign(FileArea, 'AREA.' + Response);
                   Reset(FileArea); {$I+}
             FileError := IOResult;
             If FileError <> 0 then
               begin
                 LogError('Error Opening : AREA.' + Response + ' - ' + ErrorString(FileError));
               end
             Else
               begin
                 {$I-} Seek(FileArea, 0);
                       Read(FileArea, Areas); {$I+}
                 FileError := IOResult;
                 If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError))
                  Else AreaSize := FileSize(FileArea);
              end;
          end
        Else
          begin
            LineFeed;
            LineFeed;
            Print('Sorry, File Area Closed');
            {$I-} Seek(CatArea, AreaNum - 1);
                  Read(CatArea, SAreas); {$I+}
            FileError := IOResult;
            If FileError <> 0 then LogError('Error Reading File - Main File Data - ' + ErrorString(FileError));
            Wait(30);
          end;
      end;
      ListAreas := 0;
    end
  Else
    begin
      ListAreas := 1;
      {$I-} Seek(CatArea, AreaNum - 1);
            Read(CatArea, SAreas); {$I+}
      FileError := IOResult;
      If FileError <> 0 then LogError('Error Reading File - ' + ErrorString(FileError));
    end;
end;

procedure SelectMainFileArea(Area : Word);
Var
  AreaCat : String;
begin
  If Area <= 0 then
    begin
       while ListAreas <> 1 do
    end
  Else
    begin
      If Area <= FileSize(CatArea) then
        begin
          Str(Area, AreaCat);
{          OpenFileArea('Area.' + AreaCat); }
        end
      Else
        begin
          { Invalid Area }
        end;
    end;
end;

end.