{ Lib 1 }

Unit Libs;

Interface

Uses Crt, Dos, Data;

Procedure TCol(Col1 : Integer);
Procedure BCol(Col2 : Integer);
procedure Print(Buffer : String);
function ReadKB(Flag : Integer): string;
procedure LineFeed;
procedure ClearDisplay;
procedure SetCur(Row, Col : String);
procedure Home;

Implementation

Procedure TCol(Col1 : Integer);
begin
  TextColor(Col1);
end;

Procedure BCol(Col2 : Integer);
begin
  TextBackground(Col2);
end;


procedure Print(buffer : String);
Var
  Copy4 : String;
  Stringlen, Count : Integer;
begin
  TCol(White);
  BCol(Green);
  Write(Buffer);
end;

function ReadKeys: integer;
begin
  Regs.Ah := $00;
  Intr($16, Regs);
  ReadKeys := Regs.Al; { Get ASCII Code From Keyboard Buffer }
end;

procedure ClearKBuffer;
begin
  Regs.Ah := $0C;
  Intr($21, Regs);
end;

function ReadKB(Flag : Integer): string;
Var
  Buffer   : String;
  KeyIn    : Integer;
  Key      : Integer;
begin
  Buffer := '';
  Key    := 0;
  Repeat
    KeyIn := ReadKeys;
        Case KeyIn of
        32..125 : begin
                     Inc(Key);
                     Print(Chr(KeyIn));
                     Insert(Chr(KeyIn), Buffer, Key); { Do not Store CR }
                   end;
               8 : begin
                     If Key > 0 then
                       begin
                         Print(Chr(KeyIn));
                         print(Chr($20));
                         Print(Chr(KeyIn));
                         Delete(Buffer, Key, 1);
                         Dec(Key);
                      end;
                   end;
       end; { Case End }
      Until (KeyIn = 13) or (Key = Flag);
      For Loop := 1 to Key do
        begin  { Convert To Upper Case }
          Buffer[Loop] := UpCase(Buffer[Loop]);
        end;
      ReadKB := Buffer;
      ClearKBuffer;
end;

procedure LineFeed;
begin
  Print(Chr(13));
  Print(Chr(10));
end;

procedure ClearDisplay;
begin
  if Local then ClrScr;
  if UserInfo.UserAnsi = 1 then
    begin
      Print(Chr(27));
      print('[2J');
    end
  Else
    begin
      Print(Chr($0C));
      ClrScr;
    end;
end;

{ Cursor Control : ANSI Only Command }
procedure SetCur(Row, Col : string);
begin
  Print(Chr(27));
  Print('[0;0H');
  Print(Chr(27));
  Print('[');
  Row := Row + 'B';
  Print(Row);
  Print(Chr(27));
  Print('[');
  Col := Col + 'C';
  Print(Col);
end;


procedure Home;
begin
  Print(Chr($13));
end;

end.