{ OCT 97 - Fixed bugs & Cleaned Up Code }

{ OCT 97 - Release Notes                                         }
{ Tags files for download, displays tagged files and creates     }
{ a download list for the protocal software                      }

Unit FileTag;

Interface

Uses Crt, Dos, Data, Lib, Colours, ErrorLog, WaitTix;

procedure Tag(Number : Integer);
procedure ShowTags;
procedure MakeTagList;

Implementation

procedure OpenTagFile;
Var
  UserTag : String;
begin
  If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = '\' then
    begin
      UserTag := BBSCfg.TempDir + UserInfo.UserAcc + '.TAG';
    end
  Else
    begin
      UserTag := BBSCfg.TempDir + '\' + UserInfo.UserAcc + '.TAG';
    end;
  Assign(TagInfo, UserTag);
  {$I-} Reset(TagInfo); {$I+}
  If IOResult <> 0 then
   begin
     {$I-} Rewrite(TagInfo); {$I+}
     FileError := IOResult;
     If FileError <> 0 Then
      begin
        LogError('Unable To Create User Tag File.: ' + UserTag + ErrorString(FileError));
        { Sends User Error }
        LineFeed;
        Print('Sorry, Unable Tag File At The Moment..');
        Wait(30);
      end;
   end;
   if FileError = 0 then
     begin
       TagSize := FileSize(TagInfo);
     end;
end;

procedure Tag(Number : Integer);
Var
  FileName : String;
  Step, St : Integer;
  Found    : Boolean;
begin
  OpenTagFile;
  St := Number;
  LineFeed;
  If Number = -1 then
    begin
      Print('Enter File Number To Tag : ');
      Response := ReadKB(5);
      Val(Response, St, Step);
    end;
  Seek(Files, St);
  Read(Files, FInfo);
  FileName := FInfo.FileName;
  LineFeed;
  Print('TAGGING ' + Filename);
  found := false;
  for St := 0 to FileSize(Files) - 1 do
  begin
  Seek(Files, St);
  Read(Files, FInfo);
  If Pos(FileName, FInfo.FileName) <> 0 then
    begin
     {Check For Duplicate}
     If TagSize <> 0 then
      begin
        for Step := 0 to TagSize - 1 do
         begin
           Seek(TagInfo, Step);
           Read(TagInfo, Tags);
           If (Pos(FileName, Tags.FileName) > 0) and (Tags.Tagged <> 0) then
             begin
               LineFeed;
               Print('File Already Tagged..');
               Wait(30);
               Found := True;
               Exit;
             end
           Else
             begin
               Seek(TagInfo, TagSize);
               Tags.FileName  := FileName;
               Tags.Dir       := Areas.Dir;
               Tags.DirLst    := Areas.FileLst;
               Tags.Des       := FInfo.Des1;
               Tags.Tagged    := 1;
               Tags.Size      := FInfo.Size;
               Tags.DLTimes   := FInfo.DLTimes;
               Tags.ULUser    := FInfo.ULUser;
               Tags.Date      := FInfo.FDate;
               Tags.RecNumber := St;
               Write(TagInfo, Tags);
               Found := True;
               Wait(30);
             end;
         end;
      end
    Else
     begin
       If Found Then Exit;
       Seek(TagInfo, TagSize);
       Tags.FileName  := FileName;
       Tags.Dir       := Areas.Dir;
       Tags.DirLst    := Areas.FileLst;
       Tags.Des       := FInfo.Des1;
       Tags.Tagged    := 1;
       Tags.Size      := FInfo.Size;
       Tags.DLTimes   := FInfo.DLTimes;
       Tags.ULUser    := FInfo.ULUser;
       Tags.Date      := FInfo.FDate;
       Tags.RecNumber := St;
       Write(TagInfo, Tags);
       Found := True;
       Wait(30);
     end;
    end;
  end;
  Close(TagInfo);
  If Not Found then
    begin
      LineFeed;
      Print('*Unable To Locate File..');
      WAit(30);
    end;
end;

procedure ShowTags;
Var
  Step, Nx : Integer;
  DLTime   : Integer;
  CPS, NOS : Real;
  Strgs    : String;
  ToTalMin : Integer;
  Fart     : Integer;
begin
  OpenTagFile;
  TotalMin := 0;
  Nx       := 4;
  Fart     := 0;
  If TagSize = 0 then
   begin
     Colour(FGreen);
     Print('There Are No Files Tagged..');
     Colour(FWhite);
     Wait(30);
   end
  Else
   begin
     ClearDisplay(True);
     { Display Tagged Files }
     For Step := 1 to TagSize  do
       begin
         Seek(TagInFo, Step - 1);
         Read(TagInfo, Tags);
         If Tags.Tagged = 1 then
           begin
             Inc(Fart);
             CPS := 0;
             NOS := 0;
             DLTime := 0;
             If Fart = Nx then
               begin
                 LineFeed;
                 If UserInfo.UserColour = 1 then
                   begin
                     Colour(FMagenta);
                   end;
                 Print('Press Any Key To Continue..');
                 Response := ReadKB(1);
                 ClearDisplay(True);
                 Nx := Nx + 3;
               end;
             LineFeed;
             Colour(FWhite);
             Print('Filename      : ');
             If UserInfo.UserColour = 1 then
             Colour(FGreen);
             Print(Tags.FileName);
             Colour(FWhite);
             SetX('32');
             Print('UpLoad Date : ');
             Colour(FGreen);
             Print(Tags.Date);
             str(Step, Strgs);
             Colour(FRed);
             SetX('60');
             Print('Tag No : ');
             Colour(FMagenta);
             Print(Strgs);
             LineFeed;
             Colour(FWhite);
             Print('FileSize      : ');
             Colour(FGreen);
             Str(Tags.Size, strgs);
             Print(Strgs);
             LineFeed;
             Colour(FWhite);
             Print('Description   : ');
             Colour(FGreen);
             Print(Tags.Des);
             Colour(FWhite);
             LineFeed;
             If not Local then { Calculate Approximate Download Time }
               begin
                 CPS    := LineBaud / 11;
                 NOS    := Tags.Size / CPS;
                 DLTime := Trunc(NOS / 60);
               end
             Else
               DLTime := 0;
             TotalMin := TotalMin + DLTime;
             Str(DLTime, Strgs);
             Print('Download Time : ');
             Colour(FGreen);
             Print(Strgs);
             If UserInfo.UserColour = 1 then
             Colour(FWhite);
             Print(' Minutes Approx');
             LineFeed;
             Print('Uploaded By   : ');
             Colour(FGreen);
             Print(Tags.ULUser);
             LineFeed;
             Colour(FWhite);
             Print('Downloaded    : ');
             Colour(FGreen);
             Str(Tags.DLTimes, Strgs);
             Print(Strgs);
             Colour(FWhite);
             Print(' Times');
             LineFeed;
           end;
       end;
    LineFeed;
    Colour(FGreen);
    Print('Total Tag Files : ');
    Str(Fart, Strgs);
    Colour(FMagenta);
    Print(Strgs);
    Colour(FGreen);
    Print('   Total DownLoad Time : ');
    Str(TotalMin, Strgs);
    Colour(FMagenta);
    Print(Strgs);
    Colour(FGreen);
    Print(' Minutes Approx.');
    LineFeed;
    Colour(FWhite);
    Print('*[C] Clear All Tags / [R] Remove Tagged File / [Enter] Continue : ');
    Response := ReadKB(1);
    If (Response = 'c') or (Response = 'C') then
     begin
       {$I-} Close(TagInfo);
             Erase(TagInfo); {$I+}
       If IOResult <> 0 then
         begin
           LogError('ERROR Deleting User TAG File.. ' + ErrorString(IOResult));
         end
       Else
         begin
           LineFeed;
           Print('*All Tags Clear..');
           Wait(30);
           Exit;
         end;
     end;
    If (Response = 'r') or (Response = 'R') then
      begin
        Nx := 0;
        LineFeed;
        Colour(FCyan);
        Print('Enter Tag Number : ');
        Colour(FMagenta);
        Response := ReadKB(3);
        Val(Response, Nx, TotalMin);
        If Nx > TagSize then
          begin
            Print('*InVaild Tag Number ');
            Wait(30);
          end
        Else
          begin
            {$I-} Seek(TagInfo, Nx - 1);
                  Read(TagInfo, Tags);
                  Tags.Tagged := 0;
                  Seek(TagInfo, Nx - 1);
                  Write(TagInfo, Tags); {$I-}
            FileError := IOResult;
            if (FileError <> 0) then
              begin
                LogError('Error Reading User Tag File - ' + ErrorString(FileError));
                LineFeed;
                Print('Unable To Remover Requested File..');
                Wait(30);
              end
            else
              Print('*Tagged File ReMoved');
            If Fart = 1 then
              begin
                Close(TagInfo);
                Erase(TagInfo);
              end;
            Wait(30);
            Exit;
          end;
      end;
   end;
  Close(TagInfo);
end;

procedure MakeTagList;
Var
  Lst          : Text;
  Step,
  DLTime       : Integer;
  CPS,
  NOS          : Real;
  List,
  ListFile     : String;
  DownLoadTime : Integer;
begin
  OpenTagFile;
  DownLoadTime := 0;
  If BBSCfg.TempDir[Length(BBSCfg.TempDir)] = '\' then
    begin
      ListFile := BBSCfg.TempDir + UserInfo.UserAcc + '.LST';
    end
  Else
    begin
      ListFile := BBSCfg.TempDir + '\' + UserInfo.UserAcc + '.LST';
    end;
  Assign(Lst, ListFile);
  {$I-} Rewrite(Lst); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Create Tag List : ' + ListFile);
      LineFeed;
      Print('Unable To Create Tag List..');
      Wait(30);
    end
  Else
    begin
      If TagSize <= 0 then
        begin
          Close(Lst);
          Erase(Lst);
          LineFeed;
          Print('No Tagged Files To Download');
          Wait(30);
          Error := 1;  { Exit Command With Error 1 }
          Exit;
        end
      Else
        begin
          For Step := 0 to TagSize - 1 do
             begin
               Seek(TagInfo, Step);
               Read(TagInfo, Tags);
               If Tags.Tagged = 1 then
                 begin
                   List := '';
                   List := Tags.Dir + '\' + Tags.FileName;
                   Writeln(Lst, List);
                   If not Local then
                     begin
                       CPS    := LineBaud / 11;
                       NOS    := Tags.Size / CPS;
                       DLTime := trunc(NOS / 60) + 1;
                     end
                   Else
                     begin
                       DLTime := 0;
                     end;
                   DownLoadTime := DownLoadTime + DLTime;
                 end;
             end;
          Close(lst);
          DlFile := '';
          DlFile := '@' + ListFile;
          Error  := 0;
          Tagged := True;
        end;
    end;
  If DownLoadTime > Time then
    begin
      LineFeed;
      Print('*Total DownLoad Time Exceeds Your OnLine Time');
      LineFeed;
      LineFeed;
      Print('*Press Any Key To Continue');
      Response := ReadKB(1);
      Error := 1;
    end;
end;

end.