{ OCT 97 - Added Reply To User EMail Cleaned Up Code            }

{ OCT 97 - Release Notes                                         }
{ Mail & Message Editor                                          }

Unit Editor;

interface

Uses Crt, Dos, Lib, Data, Dates, Msgs, ErrorLog, Fossil, CDrop, Colours,
     WaitTix;

procedure EditMail;
procedure TextEditStart(Flag : Boolean; User : String);
procedure ReadEMail;
procedure ReadMessage;
procedure SelectMessageArea(Area : Word);
function CountMail : byte;

implementation

Var
   Line       : array [1..100] of string[65];
   Show,
   All,
   Exits,
   EndEditor,
   EMail      : Boolean;
   MailCount,
   Max,
   Hello,
   Num         : Integer;
   MailPath,
   MailTo,                  { Send Mail To   }
   MailFrom,                { Mail Sent From }
   CurrentUser,
   CurrentArea : String;
   DirInfo     : SearchRec;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
function CountMail : byte;
begin
  MailCount := 0;
  Case Length(UserInfo.UserAcc) of
     1 : MailFrom := '000' + UserInfo.UserAcc;
     2 : MailFrom := '00' + UserInfo.UserAcc;
     3 : MailFrom := '0' + UserInfo.UserAcc;
   Else
     MailFrom := UserInfo.UserAcc;
  end; { Case End }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '\' then
    begin
      MailPath := BBSCfg.BBSMailDir + MailFrom + '*.*';
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + '\' + MailFrom + '*.*';
    end;
  FindFirst(MailPath, Archive, DirInfo);
  While DosError = 0 do
      begin
        Inc(MailCount);
        FindNext(DirInfo);
      end;
  CountMail := MailCount;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure Header;
begin
  ClearDisplay(True);
  LineFeed;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure EditLine;
Label ExitProc;
Var
  LNum,
  LCode   : Integer;
begin
  LineFeed;
  Print('*Enter Line Number To Edit : ');
  Response := ReadKb(1);
  If (Not Local) and (not FCarrier) then
        begin
          NoCarrier;
          Goto ExitProc;
        end;
  Val(Response, LNum, LCode);
  If LNum > Num then
    begin
      LineFeed;
      Print(' InVaild Line Number');
      Wait(30);
    end
  Else
    begin
      Header;
      LineFeed;
      Print(' Old Line : ');
      Print(Line[LNum]);
      LineFeed;
      Print(' New Line : ');
      Response := ReadKB(65);
      If (Not Local) and (not FCarrier) then
        begin
          NoCarrier;
          Goto ExitProc;
        end;
      Line[LNum] := Response;
      If (Not Local) and (not FCarrier) then
        begin
          NoCarrier;
          EndEditor := True;
        end;
    end;
  ExitProc:
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ReadEMail;
Label ExitProc;
Var
  Files     : Text;
  Step,
  Count     : Integer;
  Line,
  Strgs,
  ReplyMail : string;
  ReadMails : Boolean;
begin
  Case Length(UserInfo.UserAcc) of
     1 : MailTo := '000' + UserInfo.UserAcc;
     2 : MailTo := '00' + UserInfo.UserAcc;
     3 : MailTo := '0' + UserInfo.UserAcc;
   Else
     MailTo := UserInfo.UserAcc;
  end; { Case End }
  { Check For Existing Mail }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '\' then
    begin
      MailPath := BBSCfg.BBSMailDir;
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + '\';
    end;
  FindFirst(MailPath + MailTo + '*.*' , Archive, DirInfo);
  While DosError = 0 do
    begin
     Repeat
      ClearDispLay(True);
      LineFeed;
      ReplyMail := DirInfo.Name;
      Assign(Files, MailPath + DirInfo.Name);
      {I$-} Reset(Files); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
       begin
         { Error Message }
         LogError('Unable To Access ' + MailPath + DirInfo.Name + ' - ' + ErrorString(FileError));
       end
      Else
       Begin
         Step := 1;
         Colour(FYellow);
         While not Eof(Files) do
           begin
             Readln(Files, Line);
             If (Step = 5) then Colour(FWhite);
             Inc(Step);
             Print(' ');
             Print(Line);
             LineFeed;
             if Step = UserInfo.UserLines then
               begin
                 Step := 1;
                 HoldPage;
               end;
             If (Not Local) and (not FCarrier) then
               begin
                  NoCarrier;
                  Goto ExitProc;
               end;
           end;
         Close(Files);
         Colour(FRed);
         Print('[');
         Colour(FYellow);
         Print('Enter');
         Colour(FRed);
         Print('] ');
         Colour(FCyan);
         Print('Continue /');
         Colour(FRed);
         Print('[');
         Colour(FYellow);
         Print('R');
         Colour(FRed);
         Print('] ');
         Colour(FCyan);
         Print('Read E-Mail Again / ');
         Colour(FRed);
         Print('[');
         Colour(FYellow);
         Print('D');
         Colour(FRed);
         Print('] ');
         Colour(FCyan);
         Print('Delete E-Mail  / ');
         Colour(FRed);
         Print('[');
         Colour(FYellow);
         Print('S');
         Colour(FRed);
         Print('] ');
         Colour(FCyan);
         Print('Reply : ');
         Response := ReadKB(1);
         If (Not Local) and (not FCarrier) then
               begin
                  NoCarrier;
                  Goto ExitProc;
               end;
         ReadMails := True;
         If (Response = 'd') or (Response = 'D') then
           begin
             Erase(Files);
             LineFeed;
             Print('*Mail Deleted.');
             Wait(30);
           end;
         If (Response = 'r') or (Response = 'R') then ReadMails := False;
         If (Response = 's') or (Response = 'S') then
           begin
             { Reply To EMail }
             Step := 1;
             Strgs := Copy(ReplyMail, 5, 4);
             for Count := 1 to 4 do
               begin
                 if Strgs[Count] = '0' then inc(Step);
               end;
             ReplyMail := Copy(Strgs, Step, (10 - (Step + 1)));
             Header;
             TextEditStart(True, ReplyMail);
           end;
       end;
      Until ReadMails = True;
      FindNext(DirInfo);
    end;
  LineFeed;
  ExitProc:
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure EmailUser(User : string);
Var
  Step         : Integer;
  Found        : Boolean;
  MailPath     : String;
begin
  Case Length(UserInfo.UserAcc) of
     1 : MailFrom := '000' + UserInfo.UserAcc;
     2 : MailFrom := '00' + UserInfo.UserAcc;
     3 : MailFrom := '0' + UserInfo.UserAcc;
   Else
     MailFrom := UserInfo.UserAcc;
  end; { Case End }
  CurrentUser := UserInfo.UserAcc;
  Found       := False;
  Exits       := False;
  MailCount   := 0;
  Colour(FGreen);
  Print(' From    : ');
  Colour(FWhite);
  Print(UserInfo.UserName);
  Colour(FGreen);
  Line[26] := 'From    : ' + UserInfo.UserName + ' UserNo.#' + UserInfo.UserAcc;
  if User <> '0' then
    begin
      Colour(FWhite);
      Response := User;
      Colour(FGreen);
    end
  else
    begin  { If No User Number Then Ask For User ID }
      LineFeed;
      Print(' To      : ');
      Colour(FWhite);
      NoUpper := False;
      Response := ReadKB(30);
      NoUpper := True;
      Colour(Green);
   end;
  If Response = 'ALL' then All := True
   Else
     begin
       CurrentUser := UserInfo.UserACC;
       For Step := 0 to UserSize - 1 do
         begin
           Seek(DataFile, Step);
           Read(DataFile, UserInfo);
           If (Response = UserInfo.UserName)  or
              (Response = UserInfo.UserACC) then
             begin
               Response  := UserInfo.UserName + ' UserNo.#' +
               UserInfo.UserACC;
               Case Length(UserInfo.UserAcc) of
                    1 : MailTo := '000' + UserInfo.UserAcc;
                    2 : MailTo := '00' + UserInfo.UserAcc;
                    3 : MailTo := '0' + UserInfo.UserAcc;
                    4 : MailTo := UserInfo.UserAcc;
               end; { Case }
               { Check For Existing Mail }
               If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '\' then
                 begin
                   MailPath := BBSCfg.BBSMailDir + MailTo + '*.*';
                 end
               Else
                 begin
                   MailPath := BBSCfg.BBSMailDir + '\' + MailTo + '*.*';
                 end;
               FindFirst(MailPath, Archive, DirInfo);
               While DosError = 0 do
                begin
                  Inc(MailCount);
                  FindNext(DirInfo);
                end;
               Found := True;
             end;
         end;
     end;
  Val(CurrentUser, Step, Hello);
  Seek(DataFile, Step);
  Read(DataFile, UserInfo);
  If Found = False then
    begin
      LineFeed;
      LineFeed;
      Colour(FBlue);
      Print(' Sorry Unable Locate User');
      Colour(FWhite);
      Wait(30);
      NoUpper := False;
      Exits := True;
    end
  Else
    begin
      LineFeed;
      LineFeed;
      Print(' Sending Mail To ');
      Colour(FWhite);
      Print(Response);
      Line[28] := Response;
      LineFeed;
      LineFeed;
      Colour(FGreen);
      Print(' Subject : ');
      Colour(FWhite);
      Response := ReadKB(30);
      Line[27] := 'Subject : ' + Response;
      LineFeed;
      Colour(FWhite);
      Header;
    end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure PostMessage;
begin
  Exits := False;
  Print(' Area        : ');
  Line[28] := Msg.AreaName;
  Print(Line[28]);
  LineFeed;
  Print(' Comment     : ');
  NoUpper := True;
  Response := ReadKB(30);
  Line[27] := 'Comment    : ' + Response;
  LineFeed;
  Header;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure TextEdit(User : String);
Label ExitProc;
begin
  Header; { ClearScreen }
  If Show then   { Show Is Used When Once The E-Mail or Message Has Been Saved }
    begin
      If EMail then
        begin
          print(' To      : ');
          Print(Line[28]);
          LineFeed;
          print(' ');
          Print(Line[27]);
        end
     Else
        begin
          Print(' Area    : ');
          Print(Line[28]);
          LineFeed;
          Print(' ');
          Print(Line[27]);
        end;
    end;
  If not Show then
    begin
     If EMail then
       begin
         Colour(FYellow);
         Print(' E-MAIL');
         Colour(FGreen);
         Linefeed;
         EMailUser(User);
       end
     Else
       begin
         Colour(FYellow);
         Print(' POST MESSAGE');
         Colour(FGreen);
         Linefeed;
         PostMessage;
       end;
    end;
  If Exits Then Exit;
  Num := 0;
  If Not Show Then
   begin
    Max := 25;
    Colour(FMagenta);
    Print('                   Press Return On Empty Line To End Message');
    LineFeed;
    Print('                    Maximum');
    Colour(FGreen);
    Print(' 25 ');
    Colour(FMagenta);
    Print('Lines');
    Colour(FGreen);
    Print(' 65 ');
    Colour(FMagenta);
    Print('Characters Per Line');
   end;
  LineFeed;
  LineFeed;
  Repeat
  Temp := '';
  Inc(Num);
  Colour(FGreen);
  Print(' Line ');
  Str(Num, Temp);
  Colour(FYellow);
  Print(Temp);
  Colour(FGreen);
  Print(' > ');
  Colour(FWhite);
  If Not Show Then
    begin
      Response := '';
      Response := ReadKB(65);
      Line[Num] := Response;
    end
  Else
     Print(Line[Num]);
  LineFeed;
  Until (Response = '') or (Num = Max);
  Max := Num;
  ExitProc:
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure SaveEMail;
Var
  Mail,
  MailNumber  : String;
  Mails       : Text;
  Step        : Integer;
begin
  If All then
    begin
    end
  Else
    begin
      MailCount := MailCount + 1;
      Str(MailCount, MailNumber);
      Case Length(MailNumber) of
         0..1 : MailNumber := '00' + MailNumber;
            2 : MailNumber := '0' + MailNumber;
      end;
      Step := Length(BBSCfg.BBSMailDir);
      If BBSCfg.BBSMailDir[Step] = '\' then
        begin
          Mail := BBSCfg.BBSMailDir + MailTo + MailFrom + '.' + MailNumber;
        end
      Else
        begin
          Mail := BBSCfg.BBSMailDir + '\' + MailTo + MailFrom + '.' + MailNumber;
        end;
      Assign(Mails, Mail);
      {$I-} Rewrite(Mails); {$I+}
      If IOResult <> 0 then
       begin
         LineFeed;
         Print(' Sorry Mail Box Full..');
         Wait(30);
         Exit;
       end
      Else
       begin
         Writeln(Mails, 'Mail No : ', MailNumber);
         WriteLn(Mails, 'Date    : ', Today);
         Writeln(Mails, Line[26]);
         Writeln(Mails, Line[27]);
         Writeln(Mails);
         For Step := 1 to Num do
           begin
             Writeln(Mails, Line[Step]);
           end;
         Close(Mails);
         LineFeed;
         Print(' Mail Saved.');
         Wait(30);
       end;
    end;
  EndEditor := True;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure ReadMessage;
Label ReadEnd;
Var
  IndexPath,
  Strgs,
  FileName   : String;
  Message    : text;
  Step,
  Max        : word;
begin
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '\' then
    begin
      IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + '\';
    end
   Else
    begin
      IndexPath := BBSCfg.MsgDir + '\' + Msg.MsgNumber + '\';
    end;
  Assign(IdxFile, IndexPath + 'MESSAGE.IDX');
  {$I-} Reset(IdxFile); {$I+}
  FileError := IOResult;
  If FileError <> 0 then
    begin
      LogError('Error Opening ' + IndexPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
      LineFeed;
      Print('Sorry, This Message Area Is Empty..');
      Wait(30);
    end
  Else
    begin
      Str(fileSize(IdxFile), Strgs);
      LineFeed;
      Print('*Enter Number To Start From [1 - ' + Strgs + '] / (Enter) - Stop : ');
      Response := ReadKB(5);
      { Exit If Enter Is Pressed }
      if length(Response) = 0 then Exit;
      Val(Response, Max, Step);
      If (Max > FileSize(IdxFile)) or (Max = 0) then
        begin
          LineFeed;
          Print('*InValid Message Number.');
          Wait(30);
        end
      else
        begin
          For Step := 0 to FileSize(IdxFile) - 1 do
            begin
              {$I-}
                   Seek(IdxFile, Step);
                   Read(IdxFile, idx);
              {$I+}
              FileError := IOResult;
              If FileError <> 0 then
                begin
                  LogError('Error Opening : ' + IndexPath + 'MESSAGE.IDX - ' + ErrorString(FileError));
                  Exit;
                end
              else
                begin
                  Str(Idx.MsgNumber, Strgs);
                  FileName := IndexPath + Strgs + '.MSG';
                  logerror(filename);
                  Assign(Message, FileName);
                  {$I-} Reset(Message); {$I+}
                  FileError := IOResult;
                  if FileError <> 0 then
                    begin
                      LogError('Unable To Open ' + FileName + ' - ' + ErrorString(FileError));
                    end
                 Else
                    begin
                      ClearDisplay(True);
                      Max  := 0;
                      Code := 1;
                      while not Eof(Message) do
                        begin
                          Inc(Max);
                          Inc(Code);
                          If (Max < 7) and (UserInfo.UserAnsi = 1) then Print(#27 + '[1;32m');
                          if Max = 8 then
                            begin
                              If UserInfo.UserAnsi = 1 then Print(#27 + '[1;37m');
                            end;
                          Readln(Message, Strgs);
                          Print(Strgs);
                          LineFeed;
                          if Code = UserInfo.UserLines then
                            begin
                              Code := 1;
                              HoldPage;
                            end;
                        end;
                        Close(Message);
                        Print('*[S] - Stop / [Enter] - Next Message : ');
                        Response := ReadKB(2);
                        If Response = 'S' then goto ReadEnd;
                     end;
                 end;
             end;
        end;
      ReadEnd:
      Close(IdxFile);
    end;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure SaveMessage;
Label Redo;
Var
  CurrentArea,
  IndexPath,
  Directory,
  MsgFileName,
  Strgs         : String;
  MessageNumber,
  Step          : Integer;
  MsgTFile      : Text;
begin
  CurrentArea := Msg.MsgNumber;   { Store Current Message Area }
  Inc(MsIndex.MsgNumber);         { Increment Message Number }
  (* Val(CurrentArea, Step, MessageNumber); *)
  MessageNumber := MsIndex.MsgNumber;
  If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '\' then
     begin
       IndexPath := BBSCfg.MsgDir + Msg.MsgNumber + '\';
     end
  Else
     begin
       IndexPath := BBSCfg.MsgDir + '\' + Msg.MsgNumber + '\';
     end;
  Assign(IdxFile, IndexPath + 'MESSAGE.IDX');
  Redo:
  {$I-} Reset(IdxFile); {$I+}
  Step := IOResult;
  If Step <> 0 then
    begin
      If Step = 3 then { 3 Path Not Found, Create One }
        begin
          LogError(IndexPath + ErrorString(Step));
          If BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '\' then
            begin
              Directory := BBSCfg.MsgDir + Msg.MsgNumber;
            end
          Else
            begin
              Directory := BBSCfg.MsgDir + '\' + Msg.MsgNumber;
            end;
          {$I-} MkDir(Directory); {$I+}
          FileError := IOResult;
          If FileError <> 0 then
            begin
              LogError('Unable To Create ' + Directory + ' - ' + ErrorString(FileError));
            end
          Else
            begin
              LogError('Created Directory ' + Directory);
              Goto Redo;
              { Print To Log Directory Created }
            end;
        end;
      If Step = 2 then
        begin
          {$I-} Rewrite(IdxFile); {$I+}
          FileError := IOResult;
          If FileError <> 0 then
            begin
              LogError('Unable To Create MESSAGE.IDX In ' + Msg.AreaName + ErrorString(FileError));
              { Print To Error Log }
            end
          Else
            begin
              LogError('Created MESSAGE.IDX In ' + Msg.AreaName);
              { Print To Log Index file Created }
              Goto Redo;
            end;
        end;
    end
  Else
    begin
      Str(MessageNumber, Strgs);
      MsgFileName := IndexPath + Strgs + '.MSG';
      Assign(MsgTFile, MsgFileName);
      {$I-} Rewrite(MsgTFile); {$I+}
      FileError := IOResult;
      If FileError <> 0 then
        begin
          LogError('Unable To Create Message' + ErrorString(FileError));
          LineFeed;
          Print(' Message Area Full, Unable To Save Message');
          Wait(30);
        end
      Else
        begin
          Writeln(MsgTFile, '');
          Writeln(MsgTFile, ' Message No : ', MessageNumber);
          WriteLn(MsgTFile, ' Date       : ', Today);
          Writeln(MsgTFile, ' Posted By  : ', UserInfo.UserName, ' #',UserInfo.UserACC);
          Writeln(MsgTFile, ' Area       : ', Line[28]);
          Writeln(MsgTFile, ' ', Line[27]);
          Writeln(MsgTFile, '');
          For Step := 1 to Num do
            begin
              Writeln(MsgTFile, Line[Step]);
            end;
          Close(MsgTFile);
          Idx.MsgNumber := MessageNumber;
          If FileSize(IdxFile) <> 0 then
            begin
              Seek(IdxFile, FileSize(IdxFile));
              Write(IdxFile, Idx);
            end
          Else
            begin
              Write(IdxFile, Idx);
            end;
          Val(CurrentArea, Step, Max);
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
          Seek(MsgFile, 0);
          MsIndex.MsgNumber := MessageNumber;
          Write(MsgFile, Msg);
          Seek(MsgFile, Step - 1);
          Read(MsgFile, Msg);
          Seek(MsgNum, 0);
          Write(MsgNum, MsIndex);
        end;
      Close(IdxFile);
    end;
  EndEditor := True;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure TextEditStart(Flag : Boolean; User : String);
Label ExitProc;
begin
  EndEditor := False;
  Show      := False;
  All       := False;
  If Flag then
    EMail     := True
  Else
    EMail     := False;
{  If not EMail Then Show := True; }
  TextEdit(User);
  If Exits then Exit;
  Show := True;
  Repeat
  LineFeed;
  LineFeed;
  If UserInfo.UserANSI = 1 then
    begin
      Print('[31m [[33mS[31m] [36mSave Message  [31m[[33mA[31m] [36mAbort Message  ');
      Print('[31m[[33mE[31m] [36mEdit Line  [31m[[33mV[31m] [36mView Message');
    end
  Else
    Print(' [S] Save Message  [A] Abort Message  [E] Edit Line  [V] View Message');
  LineFeed;
  If UserInfo.UserAnsi = 1 then
    Print(' [37mPlease Select Option  [32m:  [33m')
  Else
    Print(' Please Select Option : ');
  Response := '';
  Response := ReadKB(2);
  If (Response = 'v') or (Response = 'V') then TextEdit(User);
  If (Response = 's') or (Response = 'S') then
    begin
      If EMail then SaveEMail
        Else SaveMessage;
    end;
  If (Response = 'e') or (Response = 'E') then EditLine;
  If (Response = 'a') or (Response = 'A') then
    begin
      LineFeed;
      Print(' Abort Message (Y/n) : ');
      Response := ReadKB(1);
      If (Response = 'y') or (Response = 'Y') then EndEditor := True;
    end;
  Until EndEditor = True;
  NoUpper := False;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure EditMail;
Label View;
Var
  Step,
  PageInc,
  UserNo    : Integer;
  MailPath,
  Strgs,
  User      : String;
  Mail      : Text;
  Filenames : array[1..12] of string[12];
begin
  CurrentUser := UserInfo.UserACC;
  Case Length(UserInfo.UserAcc) of
     1 : MailFrom := '000' + UserInfo.UserAcc;
     2 : MailFrom := '00' + UserInfo.UserAcc;
     3 : MailFrom := '0' + UserInfo.UserAcc;
   Else
     MailFrom := UserInfo.UserAcc;
  end; { Case End }
  MailCount := 0;
  Strgs     := '';
  User      := '';
  PageInc   := 0;
  { Check For Mail Sent By User }
  If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '\' then
    begin
      MailPath := BBSCfg.BBSMailDir + '*.*';
    end
  Else
    begin
      MailPath := BBSCfg.BBSMailDir + '\' + '*.*';
    end;
  ClearDisplay(True);
  { Needs to be changed with UserInfo.UserColour }
  Colour(FYellow);
  Print('Searching..');
  Colour(FWhite);
  LineFeed;
  LineFeed; {mailpath}
  FindFirst(MailPath, Archive, DirInfo);
  While DosError = 0 do
    begin
      If MailCount <= 100 then { Store Up to 100 Mails }
        begin
          IF Pos(MailFrom, DirInfo.Name) > 0 then    { Search File Name For }
            begin                                    { User Number          }
              Inc(MailCount);
              FileNames[MailCount] := DirInfo.Name;
            end;
        end;
      FindNext(DirInfo);
    end;
  If MailCount > 0 then
    begin
      Colour(FYellow);
      Print(' Users You Have Sent Mail To And Are Unread..');
      LineFeed;
      LineFeed;
      for Step := 1 to MailCount do
        begin
          Str(Step, Strgs);
          SetX('2');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
          Print(Strgs);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;37m');
            end;
          Print(' : ');
          Strgs := Copy(FileNames[Step], 1, 4); { Get User Name }
          Val(Strgs, UserNo, MAx);
          Seek(DataFile, UserNo);
          Read(DataFile, UserInfo);
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;32m');
            end;
          Print(UserInfo.UserName);
          SetX('45');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;36m');
            end;
          Print('UserNo # ');
          If UserInfo.UserAnsi = 1 then
            begin
              Print(#27 + '[1;35m');
            end;
          Print(UserInfo.UserAcc);
          LineFeed;
          UserNo := 0;
          User   := '';
          Strgs  := '';
          inc(PageInc);
          if (PageInc = (UserInfo.UserLines - 3)) then
            begin
              PageInc := 0;
              HoldPage;
            end;
        end;
     Val(CurrentUser, UserNo, Max);
     Seek(DataFile, UserNo);     { Restore Current User }
     Read(DataFile, UserInfo);
     If UserInfo.UserAnsi = 1 then
       begin
         Print(#27 + '[34m');
       end;
     LineFeed;
     Print('Please Select Mail To Edit : ');
     Response := ReadKB(90);
     If Response <> #13 then
       begin
         Val(Response, UserNo, Max);
         If UserNo <= Step then
           begin
             If BBSCfg.BBSMailDir[Length(BBSCfg.BBSMailDir)] = '\' then
               begin
                 MailPath := BBSCfg.BBSMailDir + FileNames[UserNo];
               end
             Else
               begin
                 MailPath := BBSCfg.BBSMailDir + '\' + FileNames[UserNo];
               end;
             NoUpper := True;
             UserNo := 1;
             Assign(Mail,MailPath);
             {$I-} Reset(Mail); {$I+}
             If IOResult = 0 then
               begin
                 While not eof(Mail) do
                  begin
                    Readln(Mail, Strgs);
                    Line[UserNo] := Strgs;
                    Inc(UserNo);
                  end;
                 View:
                 Num := 0;
                 Header;
                 Repeat
                   Temp := '';
                   Inc(Num);
                   If UserInfo.UserANSi = 1 then
                     Print('[32m Line ')
                   Else
                     Print(' Line ');
                   Str(Num, Temp);
                   If UserInfo.UserANSI = 1 then Print('[33m');
                   Print(Temp);
                   If UserInfo.UserANSI = 1 then
                     Print('[32m >[37m ')
                   Else
                     Print(' > ');
                   Print(Line[Num]);
                   LineFeed;
                   If Num = 23 then
                     begin
                       Print('Press Any Key To Continue');
                       Response := ReadKB(1);
                       Print(#13);
                       Print('                         ');
                       Print(#13);
                     end;
                   Until Num = UserNo - 1;
                   LineFeed;
                   EndEditor := False;
                   Repeat
                   LineFeed;
                   If UserInfo.UserANSI = 1 then
                     begin
                       Print('[31m [[33mS[31m] [36mSave Message  [31m[[33mA[31m] [36mAbort Message  ');
                       Print('[31m[[33mE[31m] [36mEdit Line  [31m[[33mV[31m] [36mView Message');
                     end
                   Else
                     Print(' [S] Save Message  [A] Abort Message  [E] Edit Line  [V] View Message');
                   LineFeed;
                   If UserInfo.UserAnsi = 1 then
                     Print(' [37mPlease Select Option  [32m:  [33m')
                   Else
                     Print(' Please Select Option : ');
                   Response := '';
                   Response := ReadKB(2);
                   If (Response = 'v') or (Response = 'V') then Goto View;
                   If (Response = 's') or (Response = 'S') then
                     begin
                       {I$-} Rewrite(Mail); {$I+}
                       If IOResult = 0 then
                         begin
                           For Step := 1 to UserNo -1 do
                            begin
                              Writeln(Mail, Line[Step]);
                            end;
                           Print('*Mail Saved');
                           EndEditor := True;
                         end
                       Else
                         begin
                           { IO Error }
                         end;
                     end;
                   If (Response = 'e') or (Response = 'E') then EditLine;
                   If (Response = 'a') or (Response = 'A') then
                   begin
                     LineFeed;
                     Print('*Abort (Y/n) : ');
                     Response := ReadKB(1);
                     If (Response = 'y') or (Response = 'Y') then EndEditor := True;
                   end;
                 Until EndEditor = True;
                 Close(Mail);
               end
             Else
               begin
                 { IO Error }
               end;
           end
         Else
           begin
             LineFeed;
             Print('Invalid Number');
             LineFeed;
             Wait(30);
           end;
       end;
    end
 Else
    begin
      { There Is No Mail By User }
    end;
  NoUpper := False;
end;
(* ------------------------------------------------------------------------ *)
(*                                                                          *)
(* ------------------------------------------------------------------------ *)
procedure SelectMessageArea(Area : Word);
Label Again, ExitProc;
begin
  CurrentArea := Msg.MsgNumber; { Store Current Message Area Number }
  If Area <= 0 then
   begin
     Again: { Loops & Gotos Bad Coding on my half }
     Print('Select Message Area or (Enter) - Exit / (?) - List Areas : ');
     Response := ReadKB(3);
     If Response = '?' then
        begin
          ListMessageAreas;
          Goto Again;
        end;
     Val(Response, Num, Max);
     If (Num <> 0) and (Num <= FileSize(MsgFile)) then
        begin
         Seek(MsgFile, Num - 1);
         Read(MsgFile, Msg);
         CurrentArea := Msg.MsgNumber;
        end
     Else
       begin
         {If No Selection Then Restore Current Message Area }
         Val(CurrentArea, Num, Max);
         Seek(MsgFile, Num - 1);
         Read(MsgFile, Msg);
       end;
   end
  Else
   begin
     If Area > FileSize(MsgFile) then
       begin
         LineFeed;
         Print('InValid Message Area Selection');
         LineFeed;
         Wait(30);
       end
     Else
       begin
         Seek(MsgFile, Area - 1);
         Read(MsgFile, Msg);
       end;
   end;
  LineFeed;
  ExitProc:
end;

end.