{ Door Unit v0.01 }

{ Date 30/08/95    }
{ Date 21/02/96  Added GetDoorTime - Returns the time caller was in a Door }
{ Date 06/07/96  Fixed Bug In GetDoorTime - Was not reading the DEF file   }
{                Probley  was returning wrong time                         }

{ OCT 97 - Release Notes                                         }
{ Creates DORDEF00.DEF file and adjust users time when returning }
{ from door program                                              }

Unit Door;

interface

Uses Crt, Data, Lib, ErrorLog, Fossil, WaitTix;

procedure MakeDorInfo(NODE : BYTE);
procedure GetDoorTime(NODE : BYTE);

implementation

procedure MakeDorInfo(NODE : BYTE);
Var
  OutFile : Text;
  Strgs,
  Fname   : String;
begin
  Str(NODE, Strgs);
  Fname := 'DORINFO' + Strgs + '.DEF';
  Assign(OutFile, Fname);
  {$I-} Rewrite(OutFile); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Create Door File : ' + Fname);
      If Local then
        begin
          Writeln('Unable To Create Door File : ',Fname);
          Wait(10);
        end;
    end
  Else
    begin
      Writeln(OutFile, BBSCfg.BBSName);
      Writeln(OutFile, BBSCfg.SysopFirst);
      Writeln(OutFile, BBSCfg.SysopSec);
      If Local then
        begin
          Writeln(OutFile,'COM0');
        end
      Else
        begin
          Writeln(OutFile,'COM',(fPort + 1));
        end;
      If Local then
        begin
          Writeln(OutFile, '0 BAUD,N,8,1');
        end
      Else
        begin
          Writeln(OutFile,ActualBaud,' BAUD,N,8,1');
        end;
      If Local then
        begin
          Writeln(OutFile,0);
        end
      Else
        begin
          Writeln(OutFile,ActualBaud);
        end;
      Writeln(OutFile, UserInfo.UserName);
      Writeln(OutFile, ' ');
      Writeln(OutFile, UserInfo.UserTown);
      Writeln(OutFile, UserInfo.UserANSI);
      Writeln(OutFile, UserInfo.UserLevel);
      Writeln(OutFile, TimeLeft);
      Close(OutFile);
    end;
end;

procedure GetDoorTime(NODE : BYTE);
Var
  OutFile    : Text;
  Strgs,
  Fname,
  GetInfo    : String;
  TimeOnDoor,
  TimeDoor   : integer;
begin
  Str(NODE, Strgs);
  Fname := 'DORINFO' + Strgs + '.DEF';
  Assign(OutFile, Fname);
  {$I-} Reset(OutFile); {$I+}
  If IOResult <> 0 then
    begin
      LogError('Unable To Read Door File : ' + Fname);
      If Local then
        begin
          Writeln('Unable To Read Door File : ',Fname);
          Wait(10);
        end;
    end
  Else
    begin
      For Loop := 1 to 12 do
        begin
          GetInfo := '';
          Readln(OutFile, GetInfo);
        end;
      Close(OutFile);
      Strgs := '';
      For Loop := 1 to length(GetInfo) do { Clear Spaces }
        begin
          if (ord(Getinfo[Loop]) >= 48) and (ord(GetInfo[Loop]) <= 57) then
            begin
              Strgs := Strgs + GetInfo[Loop];
            end;
        end;
      LogError('Time Left = ' + Strgs + ' Minutes');
      Val(Strgs, TimeDoor, Code);
      TimeOnDoor := TimeLeft - TimeDoor;
      Minutes := Minutes + TimeOnDoor;
    end;
end;

end.