(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2H .PAS -  Written by Eric Oman & Michael A. Smith                <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "H" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2h;

interface

uses
  crt, dos, overlay,
  common;

procedure pomisc1;

implementation

procedure pomisc1;
var c:char;
    abort,next,done,changed:boolean;
    cc:integer;
    oldnodeid:char;
    s:astr;
begin
  done:=FALSE;
  repeat
    with systat do begin
      cls;
      sprint(#3#5+'Miscellaneous configuration');
      nl;
      abort:=FALSE;
      oldnodeid:=nodeid;
      printacr('A. System start-out menu       :'+allstartmenu,abort,next);
      printacr('B. SysOp chat color-filter     :'+chatcfilter1,abort,next);
      printacr('C. User chat color-filter      :'+chatcfilter2,abort,next);
      printacr('D. Default bulletin prefix file:'+bulletprefix,abort,next);
      printacr('E. Node ID Number              :'+nodeid,abort,next);
      nl;
      prt('Enter selection (A-E) [Q]uit : '); onek(c,'QABCDE'^M);
      nl;
      case c of
        'Q':done:=TRUE;
        'A'..'E':begin
                   prt('Enter new: ');
                   case c of
                     'A':inputwn(allstartmenu,8,changed);
                     'B':inputwn(chatcfilter1,12,changed);
                     'C':inputwn(chatcfilter2,12,changed);
                     'D':inputwn(bulletprefix,8,changed);
                     'E':begin
                           mpl(1); inputl(s,1);
                           if (s<>'') then nodeid:=s[1];
                           if (s='') then nodeid:=oldnodeid;
                         end;
                   end;
                 end;
      end;
    end;
  until ((done) or (hangup));
end;

end.