Unit UserStuf;

Interface
Function  LoadUserInfo(Alias : String) : Boolean; (* False if Not Exist *)
Procedure WriteToLog(S : String);
Procedure Apply;
Implementation

Uses Dos,Crt,Records,GenStr,IO,Video,protcomm;

Function UserExist(handle : String) : Boolean;
Begin
 Fillchar(User,Sizeof(User),#0);
 UserExist := LoadUserInfo(Handle);
 Fillchar(User,Sizeof(User),#0);
End;


Function LoadUserInfo(Alias : String) : Boolean; (* False if Not Exist *)
Var X : Word;
Begin
 Assign(UserF,Config.Data_Dir+'USER.DAT');
 {$I-} Reset(UserF); {$I+}
 LoadUserInfo := False;
 For X := 1 to FileSize(UserF) do
  Begin
   Seek(UserF,X-1);
   Read(UserF,User);
   If (alias=User.Alias) or (alias = User.RealName) then
    Begin
     LoadUserInfo := True;
     Close(UserF);
     Exit;
    End;
  End;
 Close(UserF);
End;

Procedure WriteToLog(S : String);
Var Year,Month,Day,DOW : Word;
    Hour,Minute,Second,MSec : Word;
    LogFile : Text;
Begin
 GetDate(Year,Month,Day,DOW);
 GetTime(Hour,Minute,Second,MSec);
 Assign(LogFile,Config.Data_Dir+'SLOG_'+Strr(Config.NodeNumber)+'.'+Strr(DOW));
 {$I-} Append(LogFile); {$I+}
 If IOResult <> 0 then Rewrite(LogFile);
 Write(LogFile,'-<'+Strr(Month)+'-'+Strr(Day)+'-'+Strr(Year)+'   '+Strr(Hour)+':'+Strr(Minute)+'>- ');
 Writeln(LogFile,S);
 Close(LogFile);
End;


Procedure Apply;
Function CheckExit : Boolean;
Begin
 MultiColor(Ap_AbortApp);
 CheckExit := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
End;
Var TempInput : String[50];
    X : Word;
   TmpUser : UserRec;
Label AskHandle,AskName,AskPasswd;
Begin
 Fillchar(User,SizeOf(User),0);
 { Get Handle }
AskHandle:
 MultiColor(Ap_EnterHandle);
 SInput(TempInput,30,True,False,False,0);
 If Length(TempInput) < 2 then
  Begin
   If CheckExit then Exit else goto AskHandle;
  End;
 MultiColor(Ap_CheckHandle);
 If UserExist(TempInput) then
  Begin
   MultiColor(Ap_HandleBad);
   Goto AskHandle;
  End;
 User.Alias := TempInput;
 { Get Real Name Name }
AskName:
 MultiColor(Ap_EnterName);SInput(TempInput,30,True,False,False,0);
 If Length(TempInput) < 2 then
  Begin
   If CheckExit then Exit else goto AskName;
  End;
 If (Pos(' ',TempInput) = 0) or (TempInput = ' ') then
  Begin
   MultiColor(Ap_NameBad);
   Goto AskName;
  End;
 User.RealName := TempInput;
 {Get Phone Number }
 MultiColor(Ap_PhoneNumber);SPhoneInput(TempInput);
 User.Phone := TempInput;
 {Get User Note }
 MultiColor(Ap_UserNote);SInput(TempInput,50,False,False,False,2);
 User.UserNote := TempInput;
 {Get Password}
AskPasswd:
 Fillchar(User.Password,SizeOf(User.Password),#0);
 MultiColor(Ap_Password);SInput(TempInput,30,False,False,True,2);
 If (TempInput = '') then Goto AskPasswd;
 User.Password := TempInput;
 MultiColor(Ap_ReenterPw);SInput(TempInput,30,False,False,True,2);
 If (TempInput <> User.Password) then
  Begin
   MultiColor(Ap_PWBad);
   Goto AskPasswd;
  End;
 MultiColor(Ap_Xpert);User.XPerMode := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_FSE);User.FSE := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_Ansi);User.Ansi := AnsiYn('|15|17 Yes ','|16|07 Yes ','|15|17 No ','|16|07 No ');
 MultiColor(Ap_Filing);
 user.MainLev     := 1;
 user.FileLev     := 1;
 user.Flags       := '                          ';
 user.SysOpNote   := 'New User';
 user.AllowPage   := True;
 user.UserLog     := False;
 user.LogUser     := False;
 user.PCR         := 0;
 user.UDRatio     := 0;
 user.Credits     := 5000;
 user.Uploads     := 0;
 user.Downloads   := 0;
 user.BytesUp     := 0;
 user.BytesDown   := 0;
 user.Posts       := 0;
 user.Calls       := 0;
 user.CallsPerDay := 1000;
 user.LastCall    := 0;
 user.TimePerDay  := 0;
 user.TimeLeft    := 0;
 Assign(UserF,Config.Data_Dir+'USER.DAT');
 {$I-} Reset(UserF); {$I+}
 If IOResult <> 0 then Rewrite(UserF);
 For X := 1 to Filesize(UserF) do
  Begin
   Seek(UserF,X-1);
   Read(UserF,TmpUser);
   If (TmpUser.Mainlev = 0) or (X = Filesize(UserF)) then
    Begin
     Write(UserF,User);
     Close(UserF);
     Break;
    End;
  End;
 MultiColor(Ap_Note);
 {FSE}
 MultiColor(Ap_CallbackLater);
 Fillchar(User,SizeOf(User),#0);
 Fillchar(TmpUser,SizeOf(TmpUser),#0);
End;
End.
