PROGRAM Pack;

USES Mercury,Dos,Crt,Gentypes,BcShare; { Define Power Mail }

FUNCTION Exist(Fn:String):Boolean;
VAR S:SearchRec; I:Integer;
Begin
  I:=DosError;
  FindFirst(FN,AnyFile,S);
  Exist:=DosError=0;
End;

PROCEDURE Color(Fore,Back:Byte);
Begin
  Tc(Fore);
  Tb(Back);
End;

PROCEDURE Fill(C:Char; Len:Byte);
VAR I:Byte;
Begin
  For I:=1 to Len do Write(C);
End;

PROCEDURE Center(S:String);
Begin
  GotoXY((80-Length(S)) div 2,WhereY);
  Write(S);
End;

PROCEDURE Top(S:String);
Begin
  Window(1,1,80,25);
  Color(15,0);
  ClrScr;
  Fill('',80);
  Color(1,7);
  ClrEol;
  Center(S);
  Color(8,0);
  Writeln;
  Fill('',80);
  Window(1,4,80,25);
End;

PROCEDURE PackFiles;
VAR BF:File;     Base:FileAreaRec; I:Word; L:Integer;
    F1,F2:File;  Info:FileDataRec; B:Byte; D:Boolean;
Begin
  Top('Packing Files');
  Assign(BF,Sys.DataDir+'\FILEAREA.LST');
  Reset(BF,1);
  If IOresult<>0 then
    Begin
      Writeln('No File Areas to Compress!');
      Exit;
    End;
  Repeat
    Repeat
      BlockRead(BF,Base,SizeOf(BasE),L);
      B:=IOresult;
      If B=5 then Delay(300);
    Until B<>5;
    D:=(B=0) and (L=SizeOf(BasE));
    If D then
     Begin
       Writeln('Packing '+Base.Description);
       Assign(F1,Sys.FilesDir+'\'+Base.Name+'.DAT');
       Rename(F1,Sys.FilesDir+'\'+Base.Name+'.$$$');
       Reset(F1,1);
       If IOresult=0 then
      Begin
        Assign(F2,Sys.FilesDir+'\'+Base.Name+'.DAT');
        Rewrite(F2,1);
        If IOresult<>0 then
          Begin
            Writeln('- Critical Error!');
            Halt(1);
          End;
        Repeat
          Repeat
            BlockRead(F1,Info,SizeOf(Info),L);
            B:=IOresult;
            If B=5 then Delay(300);
          Until B<>5;
          If (L=SizeOf(Info)) and (B=0) and (Info.Status<>4) then BlockWrite(F2,Info,SizeOf(Info));
        Until (L<SizeOf(Info));
        Close(F1);
        Close(F2);
        Erase(F1);
        Writeln('- Done!');
      End else Writeln('- No Files to Compact.');
     End;
  Until (B<>0) or (Not D);
End;

PROCEDURE PackMsgs;
Begin
  Top('Packing Messages');
End;

PROCEDURE PackNuv;
Begin
  Top('Packing New User Voting Files');
End;

PROCEDURE PackLevel;
Begin
  Top('Packing Level File');
End;

PROCEDURE PackAnsi;
Begin
  Top('Packing Ansi Libraries');
End;

PROCEDURE PackPrompt;
Begin
  Top('Packing Prompt File');
End;

PROCEDURE PackUsers;
Begin
  Top('Packing User File');
End;

FUNCTION ReadStatus:Boolean;
VAR F:File of StatusRec; S:String; I:Byte;
Begin
  ReadStatus:=False;
  S:='STATUS.DAT';
  If Not Exist(S) then Exit;
  Assign(F,S);
  Repeat
    Reset(F);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  If I<>0 then Exit;
  Repeat
    Read(F,Sys);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  Close(F);
  Repeat Ignore:=IOresult Until Ignore=0;
  If I<>0 then Exit;
  ReadStatus:=True;
End;

PROCEDURE Help;
Begin
  Writeln('PACK.EXE v1.0 for OTERA BBS Program(c)');
  Color(11,0);
  Writeln('Copyright 1992-1993 Power Systems Inc.');
  Color(3,0);
  Writeln('All Rights Reserved.');
  Writeln;
  Color(15,0);
  Writeln('Usage: PACK <options>');
  Writeln;
  Color(11,0);
  Writeln('Options');
  Color(3,0);
  Writeln('   - ALL     : Pack All Data Files (except User Data Files)');
  Writeln('   - FILES   : Pack File Area Data Files');
  Writeln('   - MSGS    : Pack Message Area Data Files');
  Writeln('   - NUV     : Pack New User Voting File');
  Writeln('   - LEVEL   : Pack Level Settings Data File');
  Writeln('   - ANSI    : Pack Ansi Libraries');
  Writeln('   - PROMPT  : Pack Prompt Data Files');
  Color(12,0); Write('*');
  Color(3,0);
  Writeln('  - USERS   : Pack User Data File');
  Writeln;
  Writeln('*  - USERS packs the user file and removes any deleted user');
  Writeln('     accounts.  This, however, also resets the use numbers');
  Writeln('     and therefore should be used only in emergencies.');
      If Not ReadStatus then
        Begin
          Writeln;
          Writeln('Run this in the main OTERA directory!');
          Halt(2);
        End;
End;

VAR Good:Boolean; DoIt:Byte;

Begin
  CheckBreak:=False;
  Color(15,0);
  ClrScr;
  If ParamCount>0 then
    Begin
      Good:=True;
      If Upper(ParamStr(1))='ALL' then DoIt:=1 else
      If Upper(ParamStr(1))='FILES' then DoIt:=2 else
      If Upper(ParamStr(1))='MSGS' then DoIt:=3 else
      If Upper(ParamStr(1))='NUV' then DoIt:=4 else
      If Upper(ParamStr(1))='LEVEL' then DoIt:=5 else
      If Upper(ParamStr(1))='ANSI' then DoIt:=6 else
      If Upper(ParamStr(1))='PROMPT' then DoIt:=7 else
      If Upper(ParamStr(1))='USERS' then DoIt:=8 else Good:=False;
    End else Good:=False;
  If Not Good then Help else
    Begin
      If Not ReadStatus then
        Begin
          Writeln;
          Writeln('Run this in the main OTERA directory!');
          Halt(2);
        End;
      Case DoIt of
        1:Begin
            PackFiles;  PackMsgs;  PackNuv;
            PackLevel;  PackAnsi;  PackPrompt;
          End;
        2:PackFiles;
        3:PackMsgs;
        4:PackNuv;
        5:PackLevel;
        6:PackAnsi;
        7:PackPrompt;
        8:PackUsers;
      End;
    End;
End.
