UNIT Modem;
{ Various procedures for Interfacing with Modem & Fossil }
{$X+,I-}

INTERFACE

USES Crt,Dos,Fossil,GenTypes,OnLine,Mercury;

PROCEDURE CalculateAddress;
PROCEDURE PutChar(C:Char);
PROCEDURE PutString(S:String);
PROCEDURE OutPut(S:String);
PROCEDURE SetXY;
PROCEDURE ResetXY;
PROCEDURE Fore(B:Byte);
PROCEDURE Back(B:Byte);
PROCEDURE GoXY(X,Y:Byte);
PROCEDURE CheckIt(S:String);
PROCEDURE AnsiColor(I:Integer);
PROCEDURE SendCh(C:Char);
PROCEDURE SendStr(S:String);
PROCEDURE Print(S:String);
PROCEDURE PrintLn(S:String);
FUNCTION ChWait:Boolean;
FUNCTION InitializeModem(Speed:Word):Boolean;
FUNCTION OnLocal:Boolean;

CONST MaxY:Byte=25;

VAR
  BackX,BackY:Integer;  { Ansi info }
  High,Blink:Boolean;
  Ax,Ay:Byte;

IMPLEMENTATION

CONST VioSeg=$B800;
VAR   Address:Word;

PROCEDURE OutBios(S:String);
VAR I:Byte; Regs:Registers;
Begin
  For I:=1 to Length(S) do
    Begin
      Regs.Ah:=$02;
      Regs.Dl:=Ord(S[I]);
      Intr($21,Regs);
    End;
End;

PROCEDURE CalculateAddress;
Begin
  Address:=ax*2+ay*160;
End;

PROCEDURE PutChar(C:Char);
Begin
  If C in [#13,#8,#10] then
    Begin
      ResetXY;
      Write(C);
      If C=#8 then Write(#32#8);
      SetXY;
    End else
  If (Ax=79) and (Ay=MaxY) then
    Begin
      GotoXY(ax+1,ay+1);
      Write(C);
      ax:=0;
      ay:=maxy;
      calculateaddress;
    End else
    Begin
      Mem[VioSeg:Address]:=Ord(C);
      Inc(Address);
      Mem[VioSeg:Address]:=TextAttr;
      Inc(Address);
      If Ax=79 then
        Begin
          Ax:=0;
          Inc(Ay);
        End else Inc(Ax);
    End;
End;

PROCEDURE PutString(S:String);
VAR I:Byte;
Begin
  For I:=1 to Length(S) do PutChar(S[I]);
End;

PROCEDURE OutPut(S:String);
Begin
  PutString(S);
  SendStr(S);
End;

PROCEDURE SetXY;
Begin
  ax:=WhereX-1;
  ay:=WhereY-1;
  calculateaddress;
End;

PROCEDURE ResetXY;
Begin
  GotoXY(ax+1,ay+1);
End;

PROCEDURE GoXY(X,Y:Byte);
Begin
  If (Emulation<>Ascii) then
    Begin
      SendStr(#27+'['+Strr(Y)+';'+Strr(X)+'H');
      GotoXY(X,Y);
    End;
End;

PROCEDURE Fore(B:Byte);
Begin
  If Emulation=Ascii then Exit;
  SendStr(#27'[');
  Case B of
    0:SendStr('0;30');
    1:SendStr('0;34');
    2:SendStr('0;32');
    3:SendStr('0;36');
    4:SendStr('0;31');
    5:SendStr('0;35');
    6:SendStr('0;33');
    7:SendStr('0;37');
    8:SendStr('1;30');
    9:SendStr('1;34');
    10:SendStr('1;32');
    11:SendStr('1;36');
    12:SendStr('1;31');
    13:SendStr('1;35');
    14:SendStr('1;33');
    15:SendStr('1;37');
    16:SendStr('5;0;30');
    17:SendStr('5;0;34');
    18:SendStr('5;0;32');
    19:SendStr('5;0;36');
    20:SendStr('5;0;31');
    21:SendStr('5;0;35');
    22:SendStr('5;0;33');
    23:SendStr('5;0;37');
    24:SendStr('5;1;30');
    25:SendStr('5;1;34');
    26:SendStr('5;1;32');
    27:SendStr('5;1;36');
    28:SendStr('5;1;31');
    29:SendStr('5;1;35');
    30:SendStr('5;1;33');
    31:SendStr('5;1;37');
 End;
 SendCh('m');
 TextColor(B);
End;

PROCEDURE Back(B:Byte);
Begin
  If Emulation=Ascii then Exit;
  SendStr(#27+'[4');
  Case B of
    0:SendStr('0');
    1:SendStr('4');
    2:SendStr('2');
    3:SendStr('6');
    4:SendStr('1');
    5:SendStr('5');
    6:SendStr('3');
    7:SendStr('7');
  End;
  SendStr('m');
  TextBackGround(B);
End;

PROCEDURE SendCh(C:Char);
Begin
  If Carrier then SendChar(C);
End;

PROCEDURE SendStr(S:String);
Begin
  If Carrier then SendString(S);
End;

PROCEDURE AnsiColor(I:Integer);
Begin
  If I in [40..47] then
    Begin
      Case I of
        40:TextBackGround(0);
        41:TextBackGround(4);
        42:TextBackGround(2);
        43:TextBackGround(6);
        44:TextBackGround(1);
        45:TextBackGround(5);
        46:TextBackGround(3);
        47:TextBackGround(7);
      End;
      Exit;
    End else
  If I in [0,1,5] then
    Begin
      Case I of
        0:Begin High:=False; Blink:=False; Tc(7); Tb(0); End;
        1:Begin
            If High=False then
              Begin
                High:=True;
                TextAttr:=TextAttr+8;
              End;
          End;
        5:Begin Blink:=True; TextAttr:=TextAttr or 256; End;
      End;
    End else
  If High then
    Case I of
      30:TextColor(8);
      31:TextColor(12);
      32:TextColor(10);
      33:TextColor(14);
      34:TextColor(9);
      35:TextColor(13);
      36:TextColor(11);
      37:TextColor(15);
    End else
    Case I of
      30:TextColor(0);
      31:TextColor(4);
      32:TextColor(2);
      33:TextColor(6);
      34:TextColor(1);
      35:TextColor(5);
      36:TextColor(3);
      37:TextColor(7);
    End;
End;

PROCEDURE CheckIt(S:String);
VAR B:Byte; S1:String;
Begin
  If Emulation<>Ascii then SendStr(S);
  Delete(S,1,2);
  If (S[1]='M') and (S[Length(S)]=^N) then
    Begin
      ResetXY;
      OutBios(S);
      SetXY;
      Exit;
    End;
  If S='A' then Begin If aY>0 then Dec(aY) End else
  If S='B' then Begin If aY<MaxY-1 then Inc(aY) End else
  If S='C' then Begin If aX<79 then Inc(aX) End else
  If S='D' then Begin If aX>0 then Dec(aX) End else
  If S='m' then AnsiColor(0) else
  If S='s' then
    Begin
      BackX:=aX;
      BackY:=aY;
    End else
  If S='u' then
    Begin
      aX:=BackX;
      aY:=BackY;
    End else
  If S='K' then
    Begin
      GotoXY(aX+1,aY+1);
      ClrEol;
    End else
  If S='2J' then
    Begin
       ClrScr;
       aX:=0;
       aY:=0;
    End else
  If S='H' then
    Begin
      aX:=0;
      aY:=0;
    End else
  If (S[Length(S)]='H') and (Pos(';',S)=0) then
    Begin
      Dec(S[0]);
      aX:=0;
      aY:=Intt(S)-1;
    End else
  If (S[Length(S)]='H') and (S[1]=';') then
    Begin
      Delete(S,1,1);
      Dec(S[0]);
      aY:=Intt(S)-1;
    End else
  If S[Length(S)]='H' then
    Begin
      Dec(S[0]);
      S1:=S;
      B:=Pos(';',S);
      Repeat Dec(S[0]) until (Length(S)=B-1);
      Delete(S1,1,2);
      If S1[1]=';' then Delete(S1,1,1);
      aX:=Intt(S1)-1;
      aY:=Intt(S)-1;
      If aY>=24 then aY:=23;
    End else
  If S[Length(S)] in ['A'..'D'] then
    Begin
      Dec(S[0]);
      B:=Intt(S);
      Inc(S[0]);
      Case S[Length(S)] of
        'A':If aY-B>0 then aY:=aY-B else aY:=0;
        'B':If aY+B<MaxY-1 then aY:=aY+B else aY:=MaxY-1;
        'C':If aX+B<79 then aX:=aX+B else aX:=79;
        'D':If aX-B>0 then aX:=aX-B else aX:=0;
      End;
    End else
  If S[Length(S)]='m' then
    Begin
      B:=1;
      Repeat
        S1:='';
        Repeat
          S1:=S1+S[B];
          Inc(B);
        Until (S[B] in ['m',';']) or (B>Length(S));
        AnsiColor(Intt(S1));
        If S[B]=';' then Inc(B);
      Until (S[B]='m') or (B>Length(S));
    End else PutString(#27+'['+S);
  CalculateAddress;
End;

PROCEDURE Print(S:String);
VAR I:Byte;
Begin
  If Length(S)=0 then Exit;
  setxy;
  For I:=1 to Length(S) do
    If S[I]=#13 then
      Begin
        SendCh(S[I]); SendCh(#10);
        PutChar(S[I]); PutChar(#10);
      End else
      Begin
        SendCh(S[I]);
        PutChar(S[I]);
      End;
  resetxy;
End;

PROCEDURE PrintLn(S:String);
Begin
  Print(S+^M);
End;

FUNCTION ChWait:Boolean;
Begin
  If (CharsWaiting) or (KeyPressed) then ChWait:=True else ChWait:=False;
End;

FUNCTION InitializeModem(Speed:Word):Boolean;
Begin
  InitializeModem:=OpenCom(ComPort);
  SetModemParams(Speed,Sys.DataBits,Sys.Parity,Sys.StopBits);
End;

FUNCTION OnLocal:Boolean;
Begin
  OnLocal:=Flags[1];
End;

End.
