UNIT Misc;
{ Various Procedures and Functions (low-level) }
{$X+,I-}
INTERFACE

{** Global Variable: Total Files Uploaded **}
{** User Variable  : Files at last Call   **}
{** Stats Screen   : New Files = G-U      **}
{** Do the same thing for total posts!    **}
{** Also, have it loop at a set number,   **}
{** and if the User's Variable is greater **}
{** than the Global Variable, do what is  **}
{** in the scroll-back buffer!            **}

USES Crt,Dos,Modem,GenTypes,Mercury,Fossil,Swap,Online,PckdTime,BcShare,Modplay;

PROCEDURE SavePointer;
PROCEDURE SpeedOff;
PROCEDURE SpeedOn;
FUNCTION ValidateUser(VAR User:UserRec; Level:Integer):Boolean;
PROCEDURE Divide(VAR S,S1:String);
FUNCTION Shell(FileName,Options:String; Swp:Boolean):Integer;
FUNCTION Shell2(Exe:String; Swp:Boolean):Integer;
PROCEDURE SetLastNewscan(VAR Time:TimeArr);
FUNCTION Open(Mode:Byte):Boolean;
FUNCTION ReadString(I:Word; VAR S:String):Boolean;
FUNCTION ReadHeader(VAR Header:HeaderPtr):Boolean;
FUNCTION ReadMessage(I:Word; Rh:Boolean):Boolean;
FUNCTION LoadFirstMessage:Boolean;
PROCEDURE CloseFile;
PROCEDURE FirstMessage;
PROCEDURE ClrEnd;
PROCEDURE Cr13;
FUNCTION StartNew:Boolean;
PROCEDURE ClearMem;
PROCEDURE FromTop(I:Integer);
FUNCTION AddEnd:Boolean;
PROCEDURE NextLine;
PROCEDURE PreviousLine;
PROCEDURE StartMessage;
PROCEDURE EndMessage;
FUNCTION YankLine:Pointer;
FUNCTION Exist(Fn:String):Boolean;
FUNCTION Logoff:Boolean;
PROCEDURE ListCmd(I:Byte; S:String);
FUNCTION LoadStatus:Boolean;
PROCEDURE Cls;
PROCEDURE Cr;
PROCEDURE Bs(I:Byte);
PROCEDURE Del(I:Integer);
PROCEDURE Color(F,B:Byte);
PROCEDURE Dots;
PROCEDURE SSC(I:Byte);
PROCEDURE USC(I:Byte);
PROCEDURE SysInfo;
PROCEDURE LockPort;
FUNCTION Show(FileName:String; Clear,Abortable:Boolean):Boolean;
PROCEDURE Limit(VAR S:String; L,B:Byte);
PROCEDURE Tran(S:String);
PROCEDURE LenTran(S:String; Len:Byte);
PROCEDURE Center(S:String);
FUNCTION YesNo(T,Bar:Boolean):Boolean;
FUNCTION Yn(B:Boolean):String;
PROCEDURE ShowScreen;
PROCEDURE SplitScreenChat;
FUNCTION GetKey:Char;
PROCEDURE WordWrap(VAR S,S1:String);
PROCEDURE CmdKey(C:Char);
FUNCTION TranLen(S:String):Byte;
PROCEDURE SaveScreen;
PROCEDURE RestoreScreen;
FUNCTION CheckAccess(S:String):Boolean;
PROCEDURE MNprint(S:String);
PROCEDURE ONprint(S:String);
FUNCTION MCIcheck(S:String):Boolean;
PROCEDURE CheckBuffer;
PROCEDURE Install_Speed;
PROCEDURE DeInstall_Speed;

CONST
  BuffPtr:Byte=0;		{ 0:No key's }
  KBvec=$09;
  TimeVec=$1C;
  MaxBuffLen=1;
  LastBase:Boolean=False;
  NoMsgs:Boolean=False;
  ShellToDos:Boolean=False;
  CurrentMessage:Word=0;
  TotalMessages:Word=0;
  MessageNum:Word=0;
  BasePos:Word=0;
  FirstMsg:Boolean=False;
  Email:Boolean=False;
  OldSl:Byte=0;
  ColorOff:Boolean=False;
  OldDsl:Byte=0;
  SysOpAccess:Boolean=False;
  Reply:Boolean=False;
  DataI:Integer=0;
  TimeCheck:Boolean=False;
  Minute:Byte=1;
  Click:Byte=1; { 1..18 }
  PtClick:Byte=1; { .2 to 1.0 }
  MaxTimeLeft:Integer=0;
  TimeMessage:String='';
  SpeedInstalled:Boolean=False;
  MaxX:Byte=78;     { Maximum Line Length }
  MaxL:Integer=512; { Maximum Message Length }
  TopPtr:Pointer=Nil; { Pointer to Top of List }
  EndPtr:Pointer=Nil;
  Deep  :Integer=0;
  LineOn:Boolean=False;
  MsgPtr:Word=0;

TYPE
  BuffRec = Record
    Code,Shift:Byte;
  End;

  ReadType=(Next,NotDeleted,MailTo,MailFrom,Thread,ToUser,FromUser,Date,UserSentFrom,UserSentTo);

  (* Read Types
      Next        - Next message no matter what (unless it doesn't exist!)
      NotDeleted  - Search for a Message which has not been deleted
      MailTo      - Email Addressed to User
      MailFrom    - Email Sent from User
      Thread      - Search for a Message w/current Message Title
      ToUser      - Search for a Message addressed to current user
      FromUser    - Search for a Message sent from current user
      Date        - Search for a Message posted on Specified Date
      UserSentFrom- Search for a Message from Specified User
      UserSentTo  - Search for a Message sent to a specified user
   *)

CONST GenRead:ReadType=NotDeleted;

VAR
  KeyBuffer:Array[1..MaxBuffLen] of BuffRec;
  MenuS,DataS:String;
  Msgfile:File;
  HdrFile:File;
  BaseFile:File;
  ReplyHeader:HeaderPtr;
  SearchS:String;
  SearchDate:TimeArr;

IMPLEMENTATION

CONST NextGKchar:Char=#0;

VAR OldKBint:Pointer;
    OldTimeInt:Pointer;
    Regs:Registers;
    ScanCode,ShiftStatus:Byte;

TYPE
     ScrArr=Array[1..4000] of Byte;
     ScrPtr=^ScrArr;

CONST Speed:Boolean=False;

VAR SaveScr:ScrPtr;
    Scr:ScrArr absolute $B800:0000;
    X,Y:Byte;

FUNCTION CapFirst(S:String):String;
VAR I:Byte;
Begin
  S[1]:=Upcase(S[1]);
  For I:=2 to Length(S) do
    If S[I] in ['A'..'Z'] then S[I]:=Chr(Ord(S[I])+32);
  While S[1]=' ' do Delete(S,1,1);
  CapFirst:=S;
End;

FUNCTION FindPointer:Word;
VAR I:Integer;
Begin
  I:=0;
  Repeat
    Inc(I);
  Until (User.Bases[I]=Base.Code) or (I>1024) or (Logoff);
  If I<1025 then FindPointer:=User.LastScan[I] else
    Begin
      I:=0;
      Repeat
        Inc(I);
      Until (User.Bases[I]=0) or (I>1024) or (Logoff);
      If I<1025 then
        Begin
          User.Bases[I]:=Base.Code;
          User.LastScan[I]:=0;
        End;
      FindPointer:=0;
    End;
End;

PROCEDURE SavePointer;
VAR I:Integer;
Begin
  I:=0;
  Repeat
    Inc(I);
  Until (User.Bases[I]=Base.Code) or (I>1024);
  If User.Bases[I]=Base.Code then User.LastScan[I]:=Header^.Code+1;
End;

FUNCTION ValidateUser(VAR User:UserRec; Level:Integer):Boolean;
VAR S:String; Access:AccessRec; L:Integer; Vfile:File;
Begin
  ValidateUser:=False;
  S:=Sys.DataDir+'\LEVELS.DAT';
  If Not Exist(S) then Exit;
  Assign(Vfile,S);
  SetFileMode(ReadDenyNone);
  Repeat
    Reset(Vfile,1);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  SetFileMode(NormalMode);
  If Ignore<>0 then Exit;
  Seek(Vfile,(Level-1)*SizeOf(Access));
  Repeat
    BlockRead(Vfile,Access,SizeOf(Access),L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  If (Ignore=0) AND (L=SizeOf(Access)) then
    Begin
      ValidateUser:=True;
      User.Sl:=Access.Sl;
      User.Dsl:=Access.Dsl;
      User.Flag:=Access.Flag;
      User.Note:=Access.Note;
      (*User.Expiration:=Access.Expiration;*)
      User.TimeLimit:=Access.TimeLimit;
      User.FilePoints:=User.FilePoints+Access.FilePoints;
      User.BankMaximum:=Access.BankMaximum;
      User.MaximumDeposit:=Access.MaximumDeposit;
      User.PostCallRatio:=Access.PostCallRatio;
      User.FilesRatio:=Access.FileRatio;
      User.FilePointRatio:=Access.FilePointRatio;
    End;
  Close(Vfile);
End;

PROCEDURE Divide(VAR S,S1:String);
VAR I:Byte;
Begin
  S1:='';
  I:=Pos(' ',S);
  If I=0 then Exit;
  S1:=S;
  Repeat Dec(S[0]) until (S[Length(S)]=#32) or (S[Length(S)]=#0);
  Dec(S[0]);
  Repeat Delete(S1,1,1) Until (S1[1]=#32) or (S1='');
  Delete(S1,1,1);
End;

PROCEDURE SpeedOn;
Begin
  If Not SpeedInstalled then Exit;
  If Not Speed then Exit;
  Install_Speed;
  Speed:=False;
End;

PROCEDURE SpeedOff;
Begin
  If Not SpeedInstalled then Exit;
  If Speed then Exit;
  Deinstall_Speed;
  Speed:=True;
End;

FUNCTION Run(S,S1:String):Integer;
Begin
  SwapVectors;
  Exec(S,S1);
  SwapVectors;
  Run:=DosExitCode;
End;

FUNCTION Shell(FileName,Options:String; Swp:Boolean):Integer;
VAR I:Integer; B:Byte;
Begin
  ClrScr;
  B:=Pos('%1',Options);
  If B>0 then
    Begin
      Delete(Options,B,2);
      Insert(Strr(Comport),Options,B);
    End;
  If Bit(Status,0) then TextMode(co80);
  SpeedOff;
  New(SaveScr);
  DeinstallModem;
  Move(Scr,SaveScr^,4000);
  X:=WhereX;
  Y:=WhereY;
  If (Swp) and (DiskFree(0)>506000) then
    Shell:=Do_Exec(FileName,Options,USE_ALL,$FFFF,False) else
      Shell:=Run(FileName,Options);
  If Not InitializeModem(Rate) then
   Begin
    ComPort:=Sys.ComPort;
    Rate:=Sys.BaudRate;
    If Not InitializeModem(Rate) then
     Begin
      I:=0;
      Color(28,0);
      Write('Error Re-Instating Modem Interrupt!');
      Repeat
        Inc(I);
        Delay(1);
      Until (KeyPressed) or (I=2000);
      If KeyPressed then Readkey;
      QuickLogoff:=True;
    End;
   End;
  Move(SaveScr^,Scr,4000);
  GotoXY(X,Y);
  Dispose(SaveScr);
  SpeedOn;
  If Bit(Status,0) then TextMode(287);
  ChDir(Sys.MainDir);
End;

FUNCTION Shell2(EXE:String; Swp:Boolean):Integer;
VAR S:string;
Begin
  Divide(Exe,S);
  Shell2:=Shell(Exe,S,Swp);
End;

PROCEDURE SetLastNewscan(VAR Time:TimeArr);
Begin
  Time:=Header^.Sent;
  If Time[6]=59 then
   Begin
    Time[6]:=0;
    If Time[5]=59 then
     Begin
       Time[5]:=0;
      If Time[4]=24 then
        Begin
          Time[4]:=1;
          If Time[3]=99 then Time[3]:=00 else Inc(Time[3]);
        End else Inc(Time[4]);
     End else Inc(Time[5]);
   End Else Inc(Time[6]);
End;

FUNCTION Open(Mode:Byte):Boolean;
VAR S:String;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  CloseFile;
  Open:=False;
  S:=Sys.MsgDir+'\'+Base.Name+'.HDR';
  SetFileMode(Mode);
  Assign(HdrFile,S);
  If Not Exist(S) then
    Begin
      Repeat
        Rewrite(HdrFile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End else
    Begin
      Repeat
        Reset(HdrFile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End;
  If Ignore<>0 then Goto Done;
  S:=Sys.MsgDir+'\'+Base.Name+'.DAT';
  Assign(MsgFile,S);
  If Not Exist(S) then
    Begin
      Repeat
        Rewrite(MsgFile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End else
    Begin
      Repeat
        Reset(MsgFile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until Ignore<>5;
    End;
  If Ignore<>0 then
    Begin
      Close(HdrFile);
      Goto Done;
    End;
  Open:=True;
  NoMsgs:=(FileSize(HdrFile)=0);
  Done:
  SetFileMode(NormalMode);
  Repeat Until IOresult=0;
End;

PROCEDURE CloseFile;
Begin
  Repeat Until IOresult=0;
  Close(HdrFile);
  Close(MsgFile);
  Repeat Until IOresult=0;
End;

FUNCTION ReadHeader(VAR Header:HeaderPtr):Boolean;
VAR L:Integer;
Begin
  Repeat Until IOresult=0;
  Repeat
    BlockRead(HdrFile,Header^,SizeOf(Header^),L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  ReadHeader:=(Ignore=0) and (L=SizeOf(Header^));
  Repeat Until IOresult=0;
End;

FUNCTION ReadString(I:Word; VAR S:String):Boolean;
VAR L:Integer;
LABEL Done;
Begin
  Repeat Until IOresult=0;
  ReadString:=False;
  Seek(MsgFile,I*81);
  If IOresult<>0 then Goto Done;
  Repeat
    BlockRead(MsgFile,S,81,L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until Ignore<>5;
  If (Ignore<>0) or (L<>81) then Goto Done;
  ReadString:=True;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION ReadReplyMessage(I:Word; VAR Header:HeaderPtr):Boolean;
Begin
End;

FUNCTION ReadMessage(I:Word; Rh:Boolean):Boolean;
VAR B:Boolean;
LABEL Done;
Begin
  Repeat UntiL IOresult=0;
  ReadMessage:=False;
  If Rh then { Read Header? }
 Begin
  Seek(HdrFile,(I-1)*SizeOf(Header^));
  If IOresult<>0 then Goto Done;
  If Not ReadHeader(Header) then Goto Done;
 End;
  StartMessage;
  I:=1;
  Repeat
    B:=ReadString(Header^.Start+I-1,Top^.Text);
    AddEnd;
    NextLine;
    Inc(I);
  Until (Not B) or (Logoff) or (I>Header^.Lines);
  ReadMessage:=B;
  Done:
  Repeat Until IOresult=0;
End;

FUNCTION LoadFirstMessage:Boolean;
Begin
  LoadFirstMessage:=ReadMessage(CurrentMessage+1,True);
End;

PROCEDURE FirstMessage;
VAR I:Word; B:Boolean; S:String; F:File;
Begin
  Repeat Until IOresult=0;
  TotalMessages:=FileSize(HdrFile) div SizeOf(HeaderRec);
  If TotalMessages>0 then MessageNum:=1 else MessageNum:=0;
  CurrentMessage:=0;
  NoMsgs:=(MessageNum=0);
  FirstMsg:=Not NoMsgs;
  MsgPtr:=FindPointer;
  If Base.LastMsg<TotalMessages then
    Begin
      Println('Performing Maintenance...  Please wait.');
      Seek(HdrFile,0);
      ReadHeader(Header);
      Base.FirstMsg:=Header^.Code;
      Seek(BaseFile,FileSize(HdrFile) div SizeOf(Header^)-1);
      ReadHeader(Header);
      Base.LastMsg:=Header^.Code;
      SetFileMode(WriteDenyNone);
      Assign(F,Sys.DataDir+'\MSGBASES.LST');
      Reset(F,1);
      Seek(F,(BasePos-1)*SizeOf(Base));
      BlockWrite(F,Base,SizeOf(Base));
      Close(F);
      Println('Thank You!');
    End;
  If MsgPtr>Base.LastMsg then NoMsgs:=True;
  If Not NoMsgs then
    Begin
      If MsgPtr<Base.FirstMsg then I:=0 else
      I:=MsgPtr-Base.FirstMsg;
      B:=ReadMessage(I+1,True);
      If B then
        Begin
          FirstMsg:=False;
          CurrentMessage:=I;
          MessageNum:=I+1;
          { Getting proper count would take 2 much time }
        End else SetBit(Header^.Status,4,True); { Prevents Crash Messages }
    End;
  repeat Until IOresult=0;
End;

PROCEDURE ClrEnd;
Begin
  SendStr(#27+'[K');
  ClrEol;
End;

PROCEDURE Cr13;
Begin
  SendStr(#13);
  Write(#13);
End;

FUNCTION StartNew:Boolean;
Begin
  StartNew:=(Top=Nil);
  If Top<>Nil then Exit;
  New(Top);
  Top^.Text:='';
  Top^.Previous:=Nil;
  Top^.Next:=Nil;
  TopPtr:=Top;
  EndPtr:=Top;
  Deep:=1;
End;

PROCEDURE ClearMem;
VAR P:Pointer;
Begin
  If (Deep=0) or (Top=Nil) then Exit;
  Top:=EndPtr;
  Repeat
    P:=Top^.Previous;
    Dispose(Top);
    Top:=P;
    Dec(Deep);
  Until (Deep=0);
  Top:=Nil;
  TopPtr:=Nil;
  EndPtr:=Nil;
End;

PROCEDURE FromTop(I:Integer);
VAR B:Integer;
Begin
  B:=1;
  Top:=TopPtr;
  If I=1 then Exit;
  Repeat
    Top:=Top^.Next;
    Inc(B);
  Until (B=I) or (B=Deep);
End;

FUNCTION AddEnd:Boolean;
VAR Line:LinePtr; P:Pointer;
Begin
  AddEnd:=False;
  If Deep>=MaxL then Exit;
  New(Line);
  Line^.Previous:=EndPtr;
  Line^.Text:='';
  Line^.Next:=Nil;
  P:=Line;
  Line:=EndPtr;
  Line^.Next:=P;
  Inc(Deep);
  EndPtr:=P;
  AddEnd:=True;
End;

PROCEDURE NextLine;
Begin
  If Top<>EndPtr then Top:=Top^.Next;
End;

PROCEDURE PreviousLine;
Begin
  If Top<>TopPtr then Top:=Top^.Previous;
End;

PROCEDURE StartMessage;
Begin
  ClearMem;
  StartNew;
End;

PROCEDURE EndMessage;
Begin
  If Deep>0 then ClearMem;
End;

FUNCTION YankLine:Pointer;
VAR P,P2:Pointer;
Begin
  YankLine:=Top^.Previous;
  If Top=EndPtr then
    Begin
      EndPtr:=Top^.Previous;
      Dispose(Top);
    End else
    Begin
      P:=Top^.Previous;
      P2:=Top;
      Top:=Top^.Next;
      Top^.Previous:=P;
      Top:=P2;
      P:=Top^.Next;
      Top:=Top^.Previous;
      Top^.Next:=P;
      Top:=P2;
      Dispose(Top);
    End;
  Dec(Deep);
End;

FUNCTION Exist(Fn:String):Boolean;
VAR S:SearchRec; I:Integer;
Begin
  I:=DosError;
  FindFirst(FN,AnyFile,S);
  Exist:=DosError=0;
End;

FUNCTION Logoff:Boolean;
Begin
  If ShellToDos then
    Begin
      Tran(Strings^.Shell);
      SwapVectors;
(*    Shell(GetEnv('COMSPEC'),'',True);*)
      Exec(GetEnv('COMSPEC'),'');
      SwapVectors;
      Del(TranLen(Strings^.Shell));
    End;
  CheckBuffer;
  Logoff:=Not Carrier;
  If (Flags[1]) or (Flags[2]) then Logoff:=False;
  If QuickLogoff then Logoff:=True;
End;

PROCEDURE ListCmd(I:Byte; S:String);
Begin
  SSC(1);
  Print(' ');
  SSC(3);
  Print(Strr(I));
  For I:=WhereX to 6 do Print(#32);
  SSC(1); Print(' ');
  SSC(3); Tran(S);
  For I:=WhereX to 79 do Print(#32);
  SSC(1); Print('');
End;

FUNCTION LoadStatus:Boolean;
VAR F:File of StatusRec;
Begin
  Repeat Ignore:=IOresult Until Ignore=0;
  LoadStatus:=False;
  Assign(F,'STATUS.DAT');
  Reset(F);
  If IOresult<>0 then Exit;
  Read(F,Sys);
  Close(F);
  If IOresult=0 then LoadStatus:=True;
End;

PROCEDURE Cls;
Begin
  If Emulation=Ascii then SendStr(^L) else SendStr(#27+'[2J');
  ClrScr;
End;

PROCEDURE Cr;
Begin
  SendStr(#13#10);
  Writeln;
End;

PROCEDURE Bs(I:Byte);
VAR B:Byte;
Begin
  For I:=I downto 1 do
    Begin
      If (WhereX=1) and (WhereY>1) then
        Begin
          GotoXY(80,WhereY-1);
        End else
      If WhereX<>1 then Write(#8);
    End;
  SendStr(#27+'['+Strr(I)+'D');
End;


PROCEDURE Del(I:Integer);
Begin
  Print(Fill(#8,I));
End;

PROCEDURE Color(F,B:Byte);
Begin
  Fore(F);
  Back(B);
End;

{$I DOTS.INC}

PROCEDURE USC(I:Byte);
Begin
  Color(User.Colors[I].Fore,User.Colors[I].Back);
End;

PROCEDURE SSC(I:Byte);
Begin
  USC(I);
End;

PROCEDURE SysInfo;
VAR I:Byte;
Begin
  SSC(2); Print('                    [ ');
  SSC(1); Print('Connection Rate: ');
  Case Rate of
    300:Print(' 300k');
    1200:Print('1200k');
    2400:Print('2400k');
    4800:Print('4800k');
    9600:Print('9600k');
    14400:Print('14.4k');
    16800:Print('16.8k');
    19200:Print('19.2k');
    38400:Print('38.4k');
  End;
  SSC(2); Println(' ]');
  For I:=1 to 3 do
    Begin
      SSC(3); Print('                      ');
      SSC(1); Print(SystemInfo[I]);
      SSC(3); Println(' ');
    End;
  SSC(2); Print('                    [  ');
  SSC(1); Print(Today+'  '+Time(True));
  SSC(2); Println('  ]'#13);
End;

PROCEDURE LockPort;
VAR Lock:Word; S:String;
Begin
  If Sys.BaudRate<19200 then Exit;
  If Rate>Sys.BaudRate then Lock:=Rate else Lock:=Sys.BaudRate;
  SSC(1); Print('Locking Comport at ');
  If Lock=38400 then S:='38400' else S:=Strr(Lock);
  SSC(4); Print(S+','+Strr(Sys.DataBits)+','+Sys.Parity+','+Strr(Sys.StopBits));
  SSC(1); Print('...'); SetModemParams(Lock,Sys.DataBits,Sys.Parity,Sys.StopBits);
  If Carrier then Delay(2000);
  Println(' Done!');
End;

PROCEDURE SaveXY;
Begin
  BackX:=WhereX;
  BackY:=WhereY;
  SendStr(#27+'[s');
End;

PROCEDURE RestoreXY;
Begin
  GotoXY(BackX,BackY);
  SendStr(#27+'[u');
End;

FUNCTION Show(FileName:String; Clear,Abortable:Boolean):Boolean;
CONST Ext:Array[1..6] of String[4]=('','ASC','MSG','TXT','ANS','RIP');
VAR S:String; F:File; I,I2:Integer; Len:Integer; B,B1,Rip:Boolean;

  FUNCTION Done:Boolean;
  Begin
    Case B of
      True:Done:=(I=6);
      False:Done:=(I=5);
    End;
  End;

  FUNCTION Check:Boolean;
  Begin
    If (Abortable) and (ChWait) then Check:=True else Check:=False;
  End;

LABEL Blah,Skip;
Begin
  Show:=False;
  Repeat Ignore:=IOresult Until Ignore=0;
  If Logoff then Exit;

  High:=False; Blink:=False;
  BackX:=1;    BackY:=1;
  TextAttr:=7;
  Rip:=False;
  If Clear then Cls;

  If FileName[2]<>':' then FileName:=Sys.AnsiDir+'\'+FileName;

  B:=False;
  For I:=1 to Length(FileName) do if FileName[I]='.' then B:=True;
  (* I don't know why, but Pos won't work here! *)

  If Not B then
    Begin
      If RipGraphics then I:=7 else
      If Emulation<>Ascii then I:=6 else I:=5;
      Repeat
        Dec(I);
        S:=FileName+'.'+Ext[I];
        B1:=Exist(S);
      Until (I=1) or (B1);
      If (B1) and (I=6) then Rip:=True;
    End else
    Begin
      S:=FileName;
      B1:=Exist(S);
      If (B1) and (Pos('.RIP',Upper(FileName))>0) then Rip:=True;
    End;

  If B1 then
    Begin
      Assign(F,S);
      Reset(F,1);
      B1:=(IOresult=0);
    End;

  If (Not B1) then
    Begin
      Repeat Until IOresult=0;
      Exit;
    End else

  New(Data);
  BlockRead(F,Data^,FileSize(F),Len);
  Close(F);
  Cursor(False);
  I:=1;
  SetXY;
  If Data^[Len]=#10 then Dec(Len);
  If Data^[Len]=#13 then Dec(Len);
  If Rip then
    Begin
      If Pos('.',FileName)=0 then FileName:=FileName+'.'+Ext[6];
      S:='Showing RIP File: '+FileName+'... ';
      FastWriteXY(1,25,Fill(#32,80));
      FastWriteXY(1,25,S);
      Repeat
        SendCh(Data^[I]);
        Inc(I);
      Until (I>Len) or (Logoff) or (Check);
      Dispose(Data);
      FastWriteXY(Length(S)+1,25,'Done!');
      Show:=True;
      Cursor(True);
      Exit;
    End;
  Repeat
    If Data^[I]=#27 then
      Begin
        S:=Data^[I];
        If Data^[I+1]='M' then
          Begin
            Repeat
              Inc(I);
              S:=S+Data^[I];
            Until (S[Length(S)]=^N) or (Logoff) or (I>Len) or (Length(S)>254);
          End else
       Begin
        Repeat
          Inc(I);
          S:=S+Data^[I];
        Until (S[Length(S)] in ['A'..'Z','a'..'z',^N]) or (I>Len) or (Logoff) or
              (Length(S)>254);
       End;
        CheckIt(S);
      End else
    If (Data^[I] in ['|','%']) and (Not (Data^[I+1] in ['%','@','|',#27])) then
      Begin
        S:=Data^[I]+Data^[I+1]+Data^[I+2];
        Inc(I,2);
        If Not MCIcheck(S) then OutPut(S);
      End else
    If (Data^[I]='@') and (Upcase(Data^[I+1]) in ['A'..'Z']) then
      Begin
        Inc(I);
        S:=Data^[I-1]+Data^[I];
        If Not MCIcheck(S) then OutPut(S);
      End else
      Begin
        SendCh(Data^[I]);
        PutChar(Data^[I]);
      End;
    Inc(I);
  Until (I>Len) or (Check) or (Logoff);
  ResetXY;
  cursor(true);
  If (I<Len) and (Abortable) and (ChWait) then GetKey;
  Dispose(Data);
  Show:=True;
  Repeat Until IOresult=0;
End;

PROCEDURE Limit(VAR S:String; L,B:Byte);
VAR C,C1:Char; I:Byte; X,Y:Byte;
Begin
  S:='';
  Repeat
    If (B=2) then C:=Upcase(Getkey) else C:=Getkey;
    If (C=^Y) then
      Begin
        For I:=Length(S) downto 1 do
          Begin
            Print(#8);
            PutUp(#8);
          End;
        S:='';
      End else
      Begin
    If (B=1) and (C in [#32..#255]) and (Length(S)<L) then PutUp(C);
    If (B=1) and (C=#8) and (Length(S)>0) then PutUp(C);
      End;
    If (C in [#32..#255]) and (Length(S)<L) then
      Begin
        If B=1 then
          Begin
            Write(Strings^.Hidden);
            SendStr(Strings^.Hidden);
          End else
          Begin
            Write(C);
            SendStr(C);
          End;
        S:=S+C;
      End else
    If (C=#8) and (Length(S)>0) then
      Begin
        Del(1);
        S[Length(S)]:=#32;
        Dec(S[0]);
      End;
  Until (Logoff) or (C=#13);
  While S[Length(S)]=#32 do Delete(S,Length(S),1);
  Hidden:=False;
  Input:='';
  PopLines;
  UserInfo;
End;

FUNCTION Pipes(S:String):Boolean;
Begin
  Pipes:=True;
  If S[1]='!' then
    Begin
      Delete(S,1,1);
      OutPut(Fill(#32,Intt(S)));
      OutPut(Fill(#8,Intt(S)));
    End else
  If ((S[1] in ['0'..'3']) and (S[2] in ['0'..'9'])) and (Not ColorOff) then Fore(Intt(S)) else
  If ((S[1]='|') and (S[2] in ['0'..'7'])) and (Not ColorOff) then Back(Intt(S[2])) else
  If (S[1]='U') and (S[2] in ['0'..'8']) then USC(Intt(S[2])) else
  If (S[1]='S') and (S[2] in ['0'..'8']) then SSC(Intt(S[2])) else
  If S='U#' then OutPut(Strr(User.Number)) else
  If S='TL' then OutPut(Strr(TimeLeft)) else
  If S='SP' then OutPut(Sys.SystemPassword) else
  If S='UA' then OutPut(User.Alias) else
  If S='UN' then OutPut(User.Note) else
  If S='CT' then OutPut(Time(False)) else
  If S='SL' then OutPut(Strr(User.Sl)) else
  If S='DL' then OutPut(Strr(User.Dsl)) else
  If S='CR' then OutPut(#13#10) else Pipes:=False;
End;

FUNCTION Percent(S:String):Boolean;
Begin
  Percent:=True;
  If S='MA' then
    Begin
      If Bit(Header^.Status,4) then OutPut('Deleted') else
      If Bit(Header^.Status,1) then OutPut('Permanent') else
      If Bit(Header^.Status,2) then OutPut('Sent') else
      If Header^.Status=0 then OutPut('Normal');
    End else
  If S='CA' then Begin ResetXY; Tran(Menu.Area); SetXY; End else
  If S='MF' then
    If Bit(Header^.Status,3) then OutPut('Anonymous') else
      OutPut(Header^.From) else
  If S='MN' then OutPut(Header^.Note) else
  If S='TL' then OutPut(Strr(TimeLeft)) else
  If S='MS' then OutPut(Header^.SentTo) else
  If S='XN' then OutPut(FileInfo^.FileName) else
  If S='XS' then OutPut(Strr(FileInfo^.Size)) else
  If S='XP' then OutPut(Strr(FileInfo^.Cost*User.FilePointRatio)) else
  If S='SP' then OutPut(Sys.SystemPassword) else
  If S='MT' then OutPut(Header^.Title) else
  If S='MD' then OutPut(DateString(Header^.Sent)) else
  If S='MI' then OutPut(TimeString(Header^.Sent)) else
(*
  If S='EM' then OutPut(Strr(MailPointer)) else
*)
  If S='SN' then OutPut(Sys.Name) else
  If S='CM' then OutPut(Strr(MessageNum)) else
  If S='TM' then OutPut(Strr(TotalMessages)) else
  If S='YV' then OutPut(Strr(Nuv^.YesVotes)) else
  If S='NV' then OutPut(Strr(Nuv^.NoVotes)) else
  If (S[1]='C') and (S[2] in ['0'..'9']) then
    Begin
      If Nuv^.Comments[Intt(S[2])+1]<>'' then
      Output(Nuv^.Comments[Intt(S[2])+1]+#13#10);
    End else
  If S='VA' then OutPut(Nuv^.Alias) else
  If S='PC' then
    Begin
      If User.Calls=0 then OutPut('0') else
      OutPut(Strr(Round(User.Posts/User.Calls)*100));
      OutPut('%');
    End else
  if S[1]='%' then
    Begin
      Delete(S,1,1);
      If S[Length(S)] in ['|','!'] then Dec(S[0]);
      ResetXY;
      Show(S,False,S[Length(S)+1]='|');
      SetXY;
    End else
  If S='SY' then OutPut(Sys.SysOp) else Percent:=False;
End;

FUNCTION At(S:String):Boolean;
Begin
  At:=True;
  ResetXY;
  If S='A' then Tran(Base.Description) else
  If S='B' then Print(Strr(MessageNum)) else
  If S='C' then Print(Strr(TotalMessages)) else
  If S='D' then Tran(Forum^.Name) else
  If S='E' then Tran(FileBase^.Description) else
  If S='F' then Print(Strr(BasePos)) else
(*
  If S='G' then Print(Strr(Waiting)) else
  If S='H' then Print(Strr(OutGoing)) else
*)
  If S='M' then Print(CapFirst(Menu.Name)) else
  At:=False;
  SetXy;
End;

FUNCTION Ands(S:String):Boolean;
VAR S1:String;
Begin
  Ands:=True;
  ResetXy;
  If Intt(S)>0 then
    Begin
      Limit(S1,Intt(S),0);
    End else
  If S='PS' then Getkey else
  Ands:=False;
  SetXY;
End;

FUNCTION MCIcheck(S:String):Boolean;
VAR C:Char;
Begin
  S:=Upper(S);
  C:=S[1];
  Delete(S,1,1);
  If C='|' then MCIcheck:=Pipes(S);
  If C='%' then MCIcheck:=Percent(S);
  If C='@' then MCIcheck:=At(S);
  If C='&' then MCIcheck:=Ands(S);
End;

PROCEDURE LenTran(S:String; Len:Byte);
VAR I,L:Byte; S1:String;
Begin
  If Length(S)=0 then Exit;
  SetXY;
  I:=0;
  L:=0;
  Repeat
    Inc(I);
    Inc(L);
    If (S[I]='%') and (S[I+1]='%') and (S[I+2] in ['0'..'9']) then
      Begin
        Inc(I,2);
        S1:=S[I];
        If S[I+1] in ['0'..'9'] then
          Begin
            Inc(I);
            S1:=S1+S[I];
          End;
        MenCmd[PdPtr[Intt(S)]]^.pX:=aX+1;
        MenCmd[PdPtr[Intt(S)]]^.pY:=aY+1;
      End else
    If (S[I]='%') and (Not (S[I+1] in ['|','@',#27])) then
      Begin
        S1:=S[I];
        Inc(I);
        S1:=S1+S[I];
        If S[I]='%' then
          Begin
            Repeat
              Inc(S[I]);
              S1:=S1+S[I];
            Until (logoff) or (Length(S1)=64) or (S1[Length(S)] in ['|','!']);
            If Not MCIcheck(S1) then OutPut(S1);
          End else
          Begin
            Inc(I);
            S1:=S1+S[I];
            If Not MCIcheck(S1) then OutPut(S1);
          End;
      End else
    If S[I]='|' then
      Begin
        Inc(I,2);
        S1:=S[I-2]+S[I-1]+S[I];
        If S1[2]='!' then
          Begin
            Inc(I);
            S1:=S1+S[I];
          End;
        If Not MCIcheck(S1) then OutPut(S1);
      End else
    If (S[I]='@') and (Upcase(S[I+1]) in ['A'..'Z']) then
      Begin
        Inc(I);
        S1:=S[I-1]+S[I];
        If Not MCIcheck(S1) then OutPut(S1);
      End else
      Begin
        SendCh(S[I]);
        PutChar(S[I]);
      End;
  Until (I=Len) or (I=Length(S)) or (Logoff);
  ResetXY;
End;

PROCEDURE Tran(S:String);
Begin
  LenTran(S,255);
End;

PROCEDURE Center(S:String);
Begin
  GotoXY((80-Length(S)) div 2,WhereY);
  Write(S);
End;

FUNCTION DoBar(T:Boolean):Boolean;
VAR B:Boolean; C:Char;

PROCEDURE On;
Begin
  Color(Sys.BarOnFore,Sys.BarOnBack);
End;

PROCEDURE Off;
Begin
  Color(Sys.BarOffFore,Sys.BarOffBack);
End;

PROCEDURE Toggle;
Begin
  If B then
    Begin
      GoXY(WhereX-5,WhereY);
      Off;
      Print(' Yes  ');
      On;
      Print(' No ');
    End else
    Begin
      GoXY(WhereX-4,WhereY);
      Off;
      Print(' No ');
      GoXY(WhereX-10,WhereY);
      On;
      Print(' Yes ');
    End;
  B:=Not B;
End;

Begin
  If T then On else Off;
  Print(' Yes ');
  Off;
  Print(#32);
  If Not T then On;
  Print(' No ');
  If T then Bs(5);
  B:=T;
  Repeat
    Repeat C:=Upcase(Getkey); Until (C in [#13,#0,#27,'Y','N',#32,#8]) or (Logoff);
    If C in [#27,#32,#8] then
      Begin
        If (C=#27) and (ChWait) then
          Repeat
          Until (Logoff) or (Upcase(Getkey) in ['A'..'Z']) or (Not ChWait);
        Toggle;
        C:=#0;
      End else
    If (C=#0) and (ChWait) then
      Begin
        C:=Getkey;
        If C in [#77,#75] then Toggle;
        C:=#0;
      End else
    If (C='Y') and (Not B) then Toggle else
    If (C='N') and (B) then Toggle;
  Until (Logoff) or (C in ['Y','N',#13]);
  DoBar:=B;
End;

FUNCTION YesNo(T,Bar:Boolean):Boolean;
VAR B:Boolean; C:Char;
Begin
  If Emulation=Ascii then Bar:=False;
  Print(#32);
  If Bar then YesNo:=DoBar(T) else
    Begin
      Print('[');
      Case T of
        True:Print('Yes');
        False:Print('No');
      End;
      Print(']: ');
      Repeat C:=Upcase(Getkey) Until (Logoff) or (C in [#13,'Y','N']);
      If C in ['Y','N'] then
        Begin
          YesNo:=(C='Y');
          Case C of
            'Y':Print('Yes');
            'N':Print('No');
          End;
        End else
      If C=#13 then
        Begin
          YesNo:=T;
          Case T of
            True:Print('Yes');
            False:Print('No');
          End;
        End;
    End;
  SSC(1);
End;

FUNCTION Yn(B:Boolean):String;
Begin
  If B then Yn:='Yes' else Yn:='No';
End;

PROCEDURE ShowScreen;
VAR Scr:ScreenArr absolute $B800:0000; I:Integer;
Begin
  If Sys.LastWin then
    Begin
      Move(Screen,Scr,6880);
    End else
  If Sys.Bios then
    Begin
      TextColor(0);
      TextBackGround(0);
      ClrScr;
      I:=0;
      Repeat
        TextAttr:=Screen[I+1];
        If I<3998 then Write(Chr(Screen[I]));
        Inc(I,2);
      Until (I>3999);
      TextBackGround(1);
      TextColor(15);
    End else Move(Screen,Scr,4000);
End;

PROCEDURE SplitScreenChat;
VAR Sx,Sy,Ux,Uy,Sc,Uc, I,B:Byte;
    Ss,Us,S1,S,Bs:String; { Sysop, User, Backup }
    ChatEnd,SysOp,XX:Boolean;
    Blah:Boolean;

PROCEDURE ClrTop;
VAR I:Byte;
Begin
  For I:=1 to 11 do
    Begin
      GoXY(1,I);
      ClrEol;
      SendStr(#27+'[K');
    End;
  GoXY(1,1);
  Println(Bs);
  Sx:=1;
  Sy:=2;
End;

PROCEDURE ClrBottom;
VAR I:Byte;
Begin
  For I:=13 to 23 do
    Begin
      GoXY(1,I);
      ClrEol;
      SendStr(#27+'[K');
    End;
  GoXY(1,13);
  Println(Bs);
  Ux:=1;
  Uy:=14;
End;

PROCEDURE DrawLine;
VAR S,S1:String; I,B:Byte;
Begin
  GoXY(1,12);
  Color(13,0);
  If Bit(Status,1) then
    Begin
      S:=Sys.SysOp;
      S1:=User.Alias;
    End else
    Begin
      S:='SysOp';
      S1:='User';
    End;
  Color(5,0);
  GoXY(1,12);
  B:=(40-Length(S)) div 2-2;
  For I:=1 to B-2 do Print('');
  Print('[ ');
  Color(13,0);
  Print(#24#32+S+#32#24);
  Color(5,0);
  Print(' ]');
  B:=(40-Length(S1)) div 2+38;
  For I:=WhereX to B-2 do Print('');
  Print('[ ');
  Color(13,0);
  Print(#25#32+S1+#32#25);
  Color(5,0); Print(' ]');
  For I:=WhereX to 80 do Print('');
end;

PROCEDURE Switch;
Begin
  If SysOp then
    Begin
      GoXY(Ux,Uy);
      Color(Uc,0);
    End else
    Begin
      GoXY(Sx,Sy);
      Color(Sc,0);
    End;
  SysOp:=Not SysOp;
End;

PROCEDURE Fade(X,Y:Byte; S:String; B:Boolean);
VAR I:Byte;
Begin
  If S='' then Exit;
  Cursor(False);
  For I:=1 to 3 do
    Begin
      GoXY(X,Y);
      Case I of
        1:If B then Color(8,0) else Color(15,0);
        2:Color(7,0);
        3:If B then Color(15,0) else Color(8,0);
      End;
      Print(S);
      Delay(500);
    End;
  Cursor(True);
End;

PROCEDURE Pass(B:Boolean; C:Char);
VAR C1:Char;
Begin
  If B<>SysOp then Switch;
  If (C in [#32..#255]) and (WhereX<>80) then
    Begin
      Case B of
        True:Ss:=Ss+C;
        False:Us:=Us+C;
      End;
      Print(C);
      If B then Inc(Sx) else Inc(Ux);
    End else
  If (C in [#32..#255]) and (WhereX=80) then
    Begin
      If B then S:=Ss else S:=Us;
      WordWrap(S,S1);
      Del(Length(S1));
      S1:=S1+C;
      If B then I:=Sy else I:=Uy;
      If I in [11,23] then
        Begin
          Bs:=S;
          Case B of
            True:ClrTop;
            False:ClrBottom;
          End;
        End else
        Begin
          Cr;
          Inc(I);
          If B then Sy:=I else Uy:=I;
        End;
      Print(S1);
      I:=Length(S1);
      If B then Sx:=I else Ux:=I;
      If B then Ss:=S1 else Us:=S1;
    End else
  If C=^M then
    Begin
      If B then I:=Sy else I:=Uy;
      If I in [11,23] then
        Begin
          If B then Bs:=Ss else Bs:=Us;
          Case B of
            True:ClrTop;
            False:ClrBottom;
          End;
        End else
        Begin
          Cr;
          Inc(I);
          If B then Sy:=I else Uy:=I;
        End;
      If B then Ss:='' else Us:='';
      If B then Sx:=1 else Ux:=1;
    End else
  If C=#8 then
    Begin
      If B then S:=Ss else S:=Us;
      If Length(S)>0 then
        Begin
          Dec(S[0]);
          Del(1);
          If B then Dec(Sx) else Dec(Ux);
        End;
      If B then Ss:=S else Us:=S;
    End else
  If (C=#27) and (B) then ChatEnd:=True else
  If (C=#9) then
    Begin
      If B then S:=Ss else S:=Us;
      If Length(S)<71 then
        Begin
          Print('     ');
          S:=S+'     ';
          If B then Ss:=S else Us:=S;
        End;
    End else
  If (C=^P) or (C=^O) then
    Begin
      If B then
        Begin
          Repeat
          Until (KeyPressed) or (CharsWaiting);
          If KeyPressed then
            Begin
              C1:=Readkey;
              If (C=^P) then
                Case C1 of
                  '0':Sc:=0;
                  '1':Sc:=1;
                  '2':Sc:=2;
                  '3':Sc:=3;
                  '4':Sc:=4;
                  '5':Sc:=5;
                  '6':Sc:=6;
                  '7':Sc:=7;
                  '8':Sc:=8;
                  '9':Sc:=9;
                End;
              If (C=^O) then
                Case C1 of
                  '0':Sc:=10;
                  '1':Sc:=11;
                  '2':Sc:=12;
                  '3':Sc:=13;
                  '4':Sc:=14;
                  '5':Sc:=15;
                End;
              If SysOp then Color(Sc,0);
            End;
        End else
        Begin
          Repeat
          Until (KeyPressed) or (CharsWaiting);
          If CharsWaiting then
            Begin
              C1:=Getkey;
              If (C=^P) then
                Case C1 of
                  '0':Uc:=0;
                  '1':Uc:=1;
                  '2':Uc:=2;
                  '3':Uc:=3;
                  '4':Uc:=4;
                  '5':Uc:=5;
                  '6':Uc:=6;
                  '7':Uc:=7;
                  '8':Uc:=8;
                  '9':Uc:=9;
                End;
              If (C=^O) then
                Case C1 of
                  '0':Uc:=10;
                  '1':Uc:=11;
                  '2':Uc:=12;
                  '3':Uc:=13;
                  '4':Uc:=14;
                  '5':Uc:=15;
                End;
              If Not SysOp then Color(Uc,0);
            End;
        End;
    End;
End;

Begin
  Color(15,0);
  Cls;
  OTERAMod(2);
  If Strings^.ChatStart<>'' then
  Fade((80-Length(Strings^.ChatStart)) div 2,12,Strings^.ChatStart,True);
  ChatEnd:=False;
  SysOp:=True;
  Sx:=1; Sy:=1; SS:=''; Sc:=3;
  S1:='';
  Ux:=1; Uy:=13; Us:=''; Uc:=12;
  XX:=False;
  DrawLine;
  Color(Sc,0);
  GoXY(Sx,Sy);
  Blah:=TimeCheck;
  TimeCheck:=False;
  Repeat
    If Not XX then
      Begin
        If KeyPressed then Pass(True,Readkey) else
        If CharsWaiting then Pass(False,Getkey);
      End else
      Begin
        If KeyPressed then Pass(False,Readkey) else
        If CharsWaiting then Pass(True,Getkey);
      End;
  Until (Logoff) or (ChatEnd);
  Cls;
  TimeCheck:=Blah;
  If Strings^.ChatEnd<>'' then
  Fade((80-Length(Strings^.ChatEnd)) div 2,12,Strings^.ChatEnd,False);
  Cls;
  OTERAMod(4);
End;

FUNCTION GetKey:Char;
VAR C:Char;
LABEL Top;
Begin
  Top:
  If NextGK then
    Begin
      NextGK:=False;
      Getkey:=NextGKchar;
      Exit;
    End;
  Repeat
  Until (Logoff) or (CharsWaiting) or (KeyPressed);
  If (KeyPressed) then
    Begin
      C:=Readkey;
      If C=#0 then
        Begin
          GetKey:=C;
          C:=Readkey;
          If C in [#71,#72,#73,#75,#77,#79,#80,#81] then
             Begin
               NextGK:=True;
               NextGKchar:=C;
             End else Goto Top;
        End else GetKey:=C;
    End else
  If (CharsWaiting) then
    Begin
      GetKey:=GetChar;
      If Not Carrier then Goto Top;
    End;
End;

PROCEDURE WordWrap(VAR S,S1:String);
VAR I,B:Byte;
Begin
  S1:='';
  I:=Length(S)+1;
  Repeat Dec(I); Until (S[I]=#32) or (I=0);
  If I=0 then Exit;
  For B:=I+1 to Length(S) do S1:=S1+S[B];
  Repeat Dec(S[0]); Until (Length(S)=I);
  Dec(S[0]);
End;

PROCEDURE CmdKey(C:Char);
Begin
  SSC(1); Print('[');
  SSC(3); Print(C);
  SSC(1); Print(']');
End;

FUNCTION TranLen(S:String):Byte;
VAR B,I:Byte;
Begin
  B:=0;
  S:=Upper(S);
  For I:=1 to Length(S) do
    Begin
      If (S[I]='|') and (S[I+1]='|') and (S[I+2] in ['0'..'9']) then
        Begin
          Inc(I,2);
          Inc(B);
        End else
      If (S[I]='|') and (S[I+1] in ['0'..'9','A'..'Z']) and
                        (S[I+2] in ['0'..'9','A'..'Z']) then Inc(B);
    End;
  TranLen:=Length(S)-B*3;
End;

PROCEDURE SaveScreen;
Begin
  X:=WhereX; Y:=WhereY;
  If Sys.Bios then Begin ClrScr; Exit; End;
  Move(Scr,Screen,4000);
  ClrScr;
End;

PROCEDURE RestoreScreen;
Begin
  ClrScr;
  GotoXY(X,Y);
  If Sys.Bios then Exit;
  Move(Screen,Scr,4000);
End;

FUNCTION V(B1,B2:Boolean):Boolean;
Begin
  If B2 then V:=Not B1 else V:=B1;
End;

FUNCTION LastArea:Boolean;
Begin
  LastArea:=LastBase;
  LastBase:=False;
End;

FUNCTION CheckAccess(S:String):Boolean;
VAR I,B:Byte; Nor:Boolean; S1:String; C:Char; D:Integer;
Begin
  CheckAccess:=True;
  If S='' then Exit;
  CheckAccess:=False;
  S:=Upper(S);
  If S='MAIL' then Exit;
  I:=1;
  Repeat
    Nor:=False;
    If S[I]='!' then
      Begin
        Nor:=True;
        Inc(I);
      End;
    If (S[I]='F') and (S[I+1] in ['0'..'9']) then
      Begin
        S1:='';
        Inc(I);
        Repeat
          If S[I] in ['0'..'9'] then S1:=S1+S[I];
          Inc(I);
        Until (Logoff) or (Not (S[I] in ['0'..'9'])) or (I>Length(S));
        Dec(I);
        If Intt(S1) in [1..30] then
        If Nor then
          Begin
            If User.Flag[Intt(S1)] then Exit;
          End else If Not User.Flag[Intt(S1)] then Exit;
      End else
    If (S[I]='F') then
      Begin
        Inc(I);
        Case S[I] of
          '@':If Not Nor then
               Begin
                If Not Bit(Status,1) then Exit;
               End else If Bit(Status,1) then Exit;
          '$':If Not Nor then
               Begin
                If Not LastArea then Exit;
               End else If LastArea then Exit;
          '^':If Not Nor then
                Begin
                  If NoMsgs then Exit;
                End else If Not NoMsgs then Exit;
          '*':If Not Nor then
                Begin
                  If Not Carrier then Exit;
                End else If Carrier then Exit;
          'A'..'Z':If Not Nor then
            Begin
              If Not User.Flag[Ord(S[I])-64] then Exit;
            End else If User.Flag[Ord(S[I])-64] then Exit;
          '1'..'4':If Not Nor then
            Begin
              If Not User.Flag[26+Intt(S[I])] then Exit;
            End else If User.Flag[26+Intt(S[I])] Then Exit;
        End;
      End else
    If S[I]='C' then
      Begin
        S1:='';
        Inc(I);
        Repeat
          If S[I] in ['0'..'9'] then S1:=S1+S[I];
          Inc(I);
        Until (Logoff) or (Not (S[I] in ['0'..'9'])) or
              (I>Length(S));
        D:=Intt(S1);
        If Nor then
          Begin
            If ForumNum=D then Exit;
          End else If ForumNum<>D then Exit;
      End else
    If S[I] in ['S','D'] then
      Begin
        C:=S[I];
        Inc(I);
        If S[I] in ['>','<','='] then
          Begin
            Case S[I] of
              '>':B:=1;
              '<':B:=2;
              '=':B:=3;
            End;
            Inc(I);
            S1:='';
            Repeat
              If S[I] in ['0'..'9'] then S1:=S1+S[I];
              Inc(I);
            Until (Logoff) or (Not (S[I] in ['0'..'9'])) or (I>Length(S));
            Dec(I);
            If B=1 then
              Case C of
                'S':If User.Sl<=Intt(S1) then Exit;
                'D':If User.Dsl<=Intt(S1) then Exit;
              End else
            If B=2 then
              Case C of
                'S':If User.Sl>=Intt(S1) then Exit;
                'D':If User.Dsl>=Intt(S1) then Exit;
              End else
            If B=3 then
              Case C of
                'S':If User.Sl<>Intt(S1) then Exit;
                'D':If User.Dsl<>Intt(S1) then Exit;
              End;
          End else
          Begin
            S1:='';
            Repeat
              If S[I] in ['0'..'9'] then S1:=S1+S[I];
              Inc(I);
            Until (Logoff) or (Not (S[I] in ['0'..'9'])) or (I>Length(S));
            Dec(I);
            Case C of
              'S':If Intt(S1)>User.Sl then Exit;
              'D':If Intt(S1)>User.Dsl then Exit;
            End;
          End;
      End;
    Inc(I);
  Until (I>Length(S)) or (Logoff);
  CheckAccess:=True;
End;

CONST
  MNx:Byte=1;
  MNy:Byte=1;
  ONx:Byte=1;
  ONy:Byte=1;

PROCEDURE MNprint(S:String);
VAR B:Byte;
Begin
  If (NodeSysOp) or (Not Sys.MultiNodes) then Exit;
  TextAttr:=$03;
  If (Sys.NodeType=MainNode) then Window(3,2,78,8) else Window(4,5,77,14);
  GotoXY(MNx,MNy);
  Write(#13#10,S);
  MNx:=WhereX;
  MNy:=WhereY;
  Window(1,1,80,25);
End;

PROCEDURE ONprint(S:String);
Begin
  If (NodeSysOp) or (Sys.NodeType<>MainNode) or (Not Sys.MultiNodes) then Exit;
  Window(3,11,78,13);
  TextAttr:=$03;
  GotoXY(ONx,ONy);
  Write(#13#10,S);
  ONx:=WhereX;
  ONy:=WhereY;
  Window(1,1,80,25);
End;

FUNCTION Shift:Boolean;
Begin
  Shift:=(KeyBuffer[BuffPtr].Shift and $01) or (KeyBuffer[BuffPtr].Shift and $02) > 0;
End;

FUNCTION Ctrl:Boolean;
Begin
  Ctrl:=KeyBuffer[BuffPtr].Shift and $04 > 0;
End;

FUNCTION Alt:Boolean;
Begin
  Alt:=KeyBuffer[BuffPtr].Shift and $08 > 0;
End;

PROCEDURE CallNext;
Begin
End;

PROCEDURE CheckBuffer;
Begin
  If (Not Flags[1]) and (Not Carrier) then Exit;
  If BuffPtr<>0 then
    Begin
      If (Not Shift) and (Not Ctrl) and (Not Alt) then
        Begin
          Case KeyBuffer[BuffPtr].Code of
            63:Begin ToggleWindows; UpdateTop; End;
            68:Begin Dec(BuffPtr); SplitScreenChat; Inc(BuffPtr); End;
            61:Window3;
            59:Begin UpdateTop; Window1; End
            else CallNext;
          End;
        End else
      If (Alt) and (Not Ctrl) and (Not Shift) then
        Begin
          Case KeyBuffer[BuffPtr].Code of
            36:ShellToDos:=True;
            35:QuickLogoff:=True;
            46:ClrScr;
            45:Begin ClrScr; Halt(0); End;
            47:ValidateUser(User,2);
            31:Begin
                 If Not SysOpAccess then
                   Begin
                     OldSl:=User.Sl;
                     OldDsl:=User.Dsl;
                     User.Sl:=255;
                     User.Dsl:=255;
                     SysOpAccess:=True;
                   End else
                   Begin
                     User.Sl:=OldSl;
                     User.Dsl:=OldDsl;
                     SysOpAccess:=False;
                   End;
               End else
            CallNext;
          End;
        End;
      Dec(BuffPtr);
    End;
End;

PROCEDURE Call(Sub:Pointer);
Begin
  Asm
    Pushf         {; Push Flags             }
    Call   Sub    {; Call Procedure at Sub  }
  End;
End;

PROCEDURE NewKBint; Interrupt;
Begin
  Inline($FB); { STI }
  ShiftStatus:=Mem[$0040:$0017];
  ScanCode:=Port[$60];
  Call(OldKBint);
  If Not (BuffPtr=MaxBuffLen) then
    Begin
      Inc(BuffPtr);
      KeyBuffer[BuffPtr].Code:=ScanCode;
      KeyBuffer[BuffPtr].Shift:=ShiftStatus;
    End;
  If (ScanCode in [63,68,61,59]) then Begin Readkey; Readkey; End;
  If (ScanCode in [45,46,35]) and (Alt) then Begin ReadKey; Readkey; End;
  Inline($FA);
End;

PROCEDURE NewTimeInt; Interrupt;
Begin
  Inline($FB);
  Call(OldTimeInt);
  If TimeCheck then
    Begin
      Inc(Click);
      Inc(PtClick);
      If PtClick=5 then
        Begin
          Dec(Click);
          PtClick:=1;
        End;
{ Point Click keeps track of the .2.  Remember, the clock interrupt is
called 18.2 times per second.  That's right, 18.2.  So, in order to keep
acurate time, you need to remember the .2.  By counting from 1 to 18 you
are essentially jipping the user out of 1 second for every 18.2 that actually
pass, and by going from to 19, you are giving him and extra second for the
same amount of time.  This one second becomes over 3 seconds per minute, and
then over 180 seconds per hour.  This may seem negligible, but it is still
quite unfair! }
      If Click=18 then
        Begin
          Inc(Minute);
          If Minute=60 then
            Begin
              Dec(TimeLeft);
              TimeUp;
              Minute:=1;
              If TimeLeft=2 then TimeMessage:='You have 2 minutes left online!' else
              If TimeLeft=1 then TimeMessage:='You have 1 minute left online!' else
              If TimeLeft=0 then
                Begin
                  USC(4);
                  Print('You have run out of time!');
                  QuickLogoff:=True;
                End;
            End;
          Click:=1;
        End;
      End;
  Inline($FA);
End;

CONST Quitting:Boolean=False;

VAR OldExit:Pointer;

PROCEDURE SpeedExit; Far;
Begin
  Quitting:=True;
  DeInstall_Speed;
  ExitProc:=OldExit;
End;

PROCEDURE Install_Speed;
Begin
  GetIntVec(KBvec,OldKBint);
  SetIntVec(KBvec,@NewKBint);
  GetIntVec(TimeVec,OldTimeInt);
  SetIntVec(TimeVec,@NewTimeInt);
  OldExit:=ExitProc;
  ExitProc:=@SpeedExit;
End;

PROCEDURE DeInstall_Speed;
Begin
  SetIntVec(KBvec,OldKBint);
  SetIntVec(TimeVec,OldTimeInt);
  If Not Quitting then ExitProc:=OldExit;
End;

End.
