UNIT GlobType;

INTERFACE

                        (* Global Declarations *)
CONST

                   (* 8086/8088 hardware flags *)

   Carry_Flag     = 1;
   Parity_Flag    = 4;
   Aux_Carry_Flag = 16;
   Zero_Flag      = 64;
   Sign_Flag      = 128;

TYPE

   AnyStr   = STRING[255]  (* Matches any string for parameter passing *);

   ShortStr = STRING[30]   (* Short string *);

   KeyStr   = STRING[65]   (* Function key string *);

   FileStr  = STRING[65]   (* File name string *);

   Text_File = TEXT;

(*----------------------------------------------------------------------*)
(*               ASCII character set definitions                        *)
(*----------------------------------------------------------------------*)

CONST

   NUL  = 0          (* NULL Character  *);
   SOH  = 1          (* SOH Character   *);
   ETX  = 3          (* ETX = ^C        *);
   ENQ  = 5          (* ENQ Character   *);
   ACK  = 6;
   BELL = 7          (* BELL Character  *);
   BS   = 8          (* Backspace Char  *);
   HT   = 9          (* Horizontal Tab  *);
   LF   = 10         (* Line Feed       *);
   VT   = 11         (* Vertical Tab    *);
   FF   = 12         (* Form Feed       *);
   CR   = 13         (* Carriage Return *);
   SO   = 14         (* Start grahics   *);
   SI   = 15         (* End graphics    *);
   XON  = 17         (* XON  Character  *);
   XOFF = 19         (* XOFF Character  *);
   CAN  = 24;
   SUB  = 26         (* EOF Character   *);
   ESC  = 27         (* Escape          *);
   SP   = 32         (* Space           *);
   DEL  = 127        (* DEL  Character  *);

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*                  COMMUNICATIONS HARDWARE ADDRESSES                   *)
(*                                                                      *)
(*        These are specific to IBM PCs and close compatibles.          *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

CONST

   UART_THR   = $00;     (* offset from base of UART Registers for IBM PC *)
   UART_RBR   = $00;
   UART_IER   = $01;
   UART_IIR   = $02;
   UART_LCR   = $03;
   UART_MCR   = $04;
   UART_LSR   = $05;
   UART_MSR   = $06;

   I8259_1    = $20      (* address of first 8259  *);
   I8259_2    = $A0      (* address of second 8259 *);

   I8088_IMR1 = $21;     (* port address of the 1st Interrupt Mask Register *)
   I8088_IMR2 = $A1;     (* port address of the 2nd Interrupt Mask Register *)

   COM1_Base  = $03F8;   (* port addresses for the UART *)
   COM2_Base  = $02F8;
   COM3_Base  = $03E8;
   COM4_Base  = $02E8;

   COM1_Irq   = 4;       (* Interrupt line for the UART *)
   COM2_Irq   = 3;
   COM3_Irq   = 4;
   COM4_Irq   = 3;

   COM1_Int   = $0C;     (* Interrupt number for the UART *)
   COM2_Int   = $0B;
   COM3_Int   = $0C;
   COM4_Int   = $0B;

   RS232_Base = $0400    (* Address of RS 232 com port pointer *);

   MaxComPorts = 4       (* Four ports allowed by this code    *);

(* STRUCTURED *) CONST
                                   (* Port addresses of each com port *)

   Default_Com_Base : ARRAY[1..MaxComPorts] OF WORD =
                      ( COM1_Base, COM2_Base, COM3_Base, COM4_Base );

                                   (* IRQ line for each port *)

   Default_Com_Irq  : ARRAY[1..MaxComPorts] OF INTEGER =
                      ( COM1_Irq, COM2_Irq, COM3_Irq, COM4_Irq );

                                   (* Interrupt for each port *)

   Default_Com_Int  : ARRAY[1..MaxComPorts] OF INTEGER =
                      ( COM1_Int, COM2_Int, COM3_Int, COM4_Int );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*                   COMMUNICATIONS BUFFER VARIABLES                    *)
(*                                                                      *)
(*     The communications buffers are implemented as circular (ring)    *)
(*     buffers, or double-ended queues.  The asynchronous I/O routines  *)
(*     enter characters in the receive buffer as they arrive at the     *)
(*     serial port.  Higher-level routines may extract characters from  *)
(*     the receive buffer at leisure.  Higher-level routines insert     *)
(*     characters into the send buffer.  The asynchronous I/O routines  *)
(*     then send characters out the serial port when possible.          *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

CONST

   TimeOut             = 256        (* TimeOut value                   *);
   Async_XON           = ^Q         (* XON character                   *);
   Async_XOFF          = ^S         (* XOFF character                  *);

   Async_Overrun_Error = 2          (*   overrun                       *);
   Async_Parity_Error  = 4          (*   parity error                  *);
   Async_Framing_Error = 8          (*   framing error                 *);
   Async_Break_Found   = 16         (*   break interrupt               *);

   Async_CTS           = $10        (*   Clear to send                 *);
   Async_RTS           = $20        (*   Request to send               *);

   Async_DSR           = $20        (*   Data set ready                *);
   Async_DTR           = $10        (*   Data terminal ready           *);

   Async_RTSDTR        = $30        (*   RTS + DTR                     *);

   Async_THRE          = $20        (*   Transmit holder reg. empty    *);

TYPE
                                    (* I/O buffer type for serial port *)

   Async_Buffer_Type   = ARRAY[0..1] OF CHAR;
   Async_Ptr           = ^Async_Buffer_Type;


VAR                                 (* Port addresses for serial ports *)

   Com_Base               : ARRAY[1..MaxComPorts] OF WORD;

                                    (* IRQ line for each serial port   *)

   Com_Irq                : ARRAY[1..MaxComPorts] OF INTEGER;

                                    (* Interrupt for each serial port   *)

   Com_Int                : ARRAY[1..MaxComPorts] OF INTEGER;

VAR
   Async_Buffer_Ptr       : Async_Ptr  (* Input buffer address  *);
   Async_OBuffer_Ptr      : Async_Ptr  (* Output buffer address *);

   Async_Open_Flag        : BOOLEAN    (* true if port opened               *);
   Async_Port             : INTEGER    (* current open port number (1 -- 4) *);
   Async_Base             : INTEGER    (* base for current open port        *);
   Async_Irq              : INTEGER    (* IRQ for current open port         *);
   Async_Int              : INTEGER    (* Interrupt # for current port      *);
   Async_RS232            : INTEGER    (* RS232 address for current port    *);

   Async_Buffer_Overflow  : BOOLEAN    (* True if buffer overflow has happened *);
   Async_Buffer_Used      : INTEGER    (* Amount of input buffer used so far   *);
   Async_MaxBufferUsed    : INTEGER    (* Maximum amount of input buffer used  *);

                                       (* Async_Buffer empty if Head = Tail    *)
   Async_Buffer_Head      : INTEGER    (* Loc in Async_Buffer to put next char *);
   Async_Buffer_Tail      : INTEGER    (* Loc in Async_Buffer to get next char *);
   Async_Buffer_NewTail   : INTEGER    (* For updating tail value              *);

   Async_OBuffer_Overflow : BOOLEAN    (* True if buffer overflow has happened *);
   Async_OBuffer_Used     : INTEGER    (* Amount of output buffer used         *);
   Async_MaxOBufferUsed   : INTEGER    (* Max amount of output buffer used     *);

                                       (* Async_Buffer empty if Head = Tail    *)
   Async_OBuffer_Head     : INTEGER    (* Loc in Async_Buffer to put next char *);
   Async_OBuffer_Tail     : INTEGER    (* Loc in Async_Buffer to get next char *);
   Async_OBuffer_NewTail  : INTEGER    (* For updating tail value              *);

   Async_Buffer_Low       : INTEGER    (* Low point in receive buffer for XON  *);
   Async_Buffer_High      : INTEGER    (* High point in receive buffer for XOFF*);
   Async_Buffer_High_2    : INTEGER    (* Emergency point for XOFF             *);

   Async_XOFF_Sent        : BOOLEAN    (* If XOFF sent                      *);
   Async_Sender_On        : BOOLEAN    (* If sender is enabled              *);
   Async_Send_XOFF        : BOOLEAN    (* TRUE to send XOFF ASAP            *);
   Async_XOFF_Received    : BOOLEAN    (* If XOFF received                  *);
   Async_XOFF_Rec_Display : BOOLEAN    (* If XOFF received and displayed    *);
   Async_XON_Rec_Display  : BOOLEAN    (* If XON received                   *);
   Async_Baud_Rate        : WORD       (* Current baud rate                 *);

                                    (* Save previous serial interrupt status *)

   Async_Save_IAddr,
   Get_Reboot_Vec,
   Set_Reboot_Vector       : POINTER (* Interrupt procedure pointer          *);
   Async_Save_LCR         : BYTE    (* Old LCR register contents            *);
   Async_Save_MCR         : BYTE    (* Old MCR register contents            *);
   Async_Save_IMR         : BYTE    (* Old interrupt enabled mask           *);
   Async_Save_IER         : BYTE    (* Old interrupt enable register cont.  *);
   Async_Save_DLR         : BYTE    (* Old divisor (low) contents           *);
   Async_Save_DHR         : BYTE    (* Old divisor (high) contents          *);

   Async_Do_CTS           : BOOLEAN (* TRUE to do clear-to-send checking    *);
   Async_Do_DSR           : BOOLEAN (* TRUE to do data-set-ready checking   *);
   Async_Do_XonXoff       : BOOLEAN (* TRUE to do XON/XOFF flow checking    *);
   Async_OV_XonXoff       : BOOLEAN (* TRUE to do XON/XOFF if buffer overfl *);
   Async_Hard_Wired_On    : BOOLEAN (* TRUE if hard-wired connection        *);
   Async_Break_Length     : INTEGER (* Length of break in 1/10 seconds      *);
   Async_Line_Status      : BYTE    (* Line Status Reg at interrupt         *);
   Async_Modem_Status     : BYTE    (* Modem Status Reg at interrupt        *);
   Async_Line_Error_Flags : BYTE    (* Line status bits accumulated         *);
   Async_Buffer_Size      : INTEGER (* Stores input buffer size             *);
   Async_OBuffer_Size     : INTEGER (* Stores output buffer size            *);
   Async_Uart_IER         : INTEGER (* Interrupt enable register address    *);
   Async_Uart_MCR         : INTEGER (* Interrupt enable register address    *);
   Async_Uart_IIR         : INTEGER (* Interrupt ID register address        *);
   Async_Uart_MSR         : INTEGER (* Modem status register address        *);
   Async_Uart_LSR         : INTEGER (* Line status register address         *);
   Async_Uart_THR         : INTEGER (* Transmit hold register address       *);
   Async_Uart_LCR         : INTEGER (* Line control register address        *);
   Async_Uart_RBR         : INTEGER (* Read character register address      *);
   Async_IMR              : INTEGER (* Interrupt mask register              *);
   Async_Output_Delay     : INTEGER (* Delay in ms when output buffer full  *);
   Async_OneMSDelay       : INTEGER (* Loop count value to effect 1 ms delay*);
   Async_Buffer_Length    : INTEGER (* Receive buffer length                *);
   Async_OBuffer_Length   : INTEGER (* Send buffer length                   *);
                                    (* Pointer to Async_Send routine        *)
   Async_Send_Addr        : Async_Ptr;
   Async_Reject_Noise     : BOOLEAN (* TRUE to reject "bad" received chars  *);
   Async_Noise_Char       : CHAR    (* Character to replace "noise"         *);

IMPLEMENTATION

END (* GlobType *).
