{ =========================================================================== }
{ DESQqwik.pas - Demo for DESQview interface routines      ver 5.X, 01-01-89  }
{                and the use of QWIK5X.TPU                                    }
{ It is assumed that you are an operator of DESQview and that you are         }
{ familiar with it's operation.                                               }
{ TO TEST:                                                                    }
{   1. Make DESQdemo.exe with QWIK.TPU.                                       }
{   2. Compile DESQloop.exe.                                                  }
{   3. Add these programs to DV with Direct video = "N".                      }
{   4. Run DESQloop in one or more windows, say 1 and 2.                      }
{   5. Run this program in another one, say 3.                                }
{   6. Observe results.                                                       }
{ TO USE:                                                                     }
{   1. Optionally rename DESQ5X.TPU to DESQ.TPU                               }
{   2. Follow instruction provided by DESQview                                }
{   3. For high speed buffer writing to a DESQview window, use QWIK5X.ARC     }
{  by  James H. LeMay, CIS 76011,217                                          }
{  for Eagle Performance Software                                             }
{      P.O. Box 122237                                                        }
{      Ft. Worth, TX  76121-2237                                              }
{ =========================================================================== }

program DESQdemo;

USES Crt,Qwik,DESQ;

var
  DV_version: word;
  Strng:      string;

type
  Str9 = string[9];

{ -- Converts any number into a Hex character string -- }
function DecToHex (Number: longint; HexChars: byte): str9;
const
  D2H: array[0..$F] of char = '0123456789ABCDEF';
var
  HexStr:       Str9;
  HexChar,Bits: byte;
begin
  HexStr:='';
  for HexChar:=0 to pred(HexChars) do
    begin
      Bits:=HexChar shl 2;
      HexStr:=D2H[(Number shr Bits) and $F] + HexStr;
    end;
  DecToHex:='$' + HexStr;
end;

procedure ClearScr (Attrib: integer);
begin
  Qfill (1,1,CRTrows,CRTcols,Attrib,' ');
end;

begin
  Page0seg:=DV_Get_Video_Buffer (Page0seg);    { Base of Video segment }
  QScrSeg:=Page0seg;                           { Segment for Qwik writing }
  DV_Version:=DV_Get_Version;     { Optional }
  if not In_DV then
    begin
      ClearScr (TextAttr);
      Qwrite (1,1,SameAttr,'DESQview not active');
      GotoRC (2,1);
    end
  else
    begin
      { QWIK5X uses FAR pointers for the screen base.  DESQview only
        changes the segment and is therefore paragraph aligned (meaning the
        offset is always 0).  Since DV_Get_Video_Buffer does not work with
        the offset, DESQview assumes it to be zero for the screen base. }
      QScrOfs:=0;   { Screen base offset. }
      Qsnow:=false;
      ClearScr (SameAttr);
      Qwrite    (1,1,SameAttr,'DESQview version = ');
      Str       ((Hi(DV_Version)+Lo(DV_Version)/100):4:2,Strng);
      QwriteEos (    SameAttr,Strng);
      Qwrite    (2,1,SameAttr,'Video Segment = ');
      QwriteEos (    SameAttr,DecToHex(Page0seg,4));
      Qwrite    (3,1,SameAttr,'First character in row 1 is = ');
      QwriteEos (    SameAttr,char(Mem[Page0seg:0]));
      Qwrite    (4,1,SameAttr,'All windows should now freeze for 3 seconds');
      GotoRC    (5,1);
      Crt.delay (1000);
      DV_Begin_Critical;
      Crt.delay (3000);
      DV_End_Critical;
      Qwrite (5,1,SameAttr,'Now all windows will continue.');
      Qwrite (6,1,SameAttr,'Test completed.  Scroll back to see row 1.');
      GotoRC (7,1);
    end
end.
