{ =========================================================================== }
{ DESQdemo.pas - Demo for DESQview interface routines      ver 5.X, 01-01-89  }
{                                                                             }
{ It is assumed that you are an operator of DESQview and that you are         }
{ familiar with it's operation.                                               }
{ TO TEST:                                                                    }
{   1. Make DESQdemo.exe.                                                     }
{   2. Compile DESQloop.exe.                                                  }
{   3. Add these programs to DV with Direct video = "N".                      }
{   4. Run DESQloop in one or more windows, say 1 and 2.                      }
{   3. Run this program in another one, say 3.                                }
{   4. Observe results.                                                       }
{ TO USE:                                                                     }
{   1. Optionally rename DESQ5X.TPU to DESQ.TPU                               }
{   2. Follow instruction provided by DESQview                                }
{   3. For high speed buffer writing to a DESQview window, use QWIK5X.ARC     }
{  by  James H. LeMay, CIS 76011,217                                          }
{  for Eagle Performance Software                                             }
{      P.O. Box 122237                                                        }
{      Ft. Worth, TX  76121-2237                                              }
{ =========================================================================== }

program DESQdemo;

USES Crt, DESQ;

var
  VideoMode:  byte absolute $0040:$0049;
  VideoSeg:   word;
  DV_version: word;

type
  Str9 = string[9];

{ -- Converts any number into a Hex character string -- }
function DecToHex (Number: longint; HexChars: byte): str9;
const
  D2H: array[0..$F] of char = '0123456789ABCDEF';
var
  HexStr:       Str9;
  HexChar,Bits: byte;
begin
  HexStr:='';
  for HexChar:=0 to pred(HexChars) do
    begin
      Bits:=HexChar shl 2;
      HexStr:=D2H[(Number shr Bits) and $F] + HexStr;
    end;
  DecToHex:='$' + HexStr;
end;

begin
  DirectVideo:=false;
  if VideoMode=7 then
       VideoSeg:=$B000
  else VideoSeg:=$B800;
  VideoSeg:=DV_Get_Video_Buffer (VideoSeg);
  DV_Version:=DV_Get_Version;   { Optional }
  ClrScr;
  if DV_Version=0 then
    Writeln ('DESQview not active')
  else
    begin
      Writeln ('DESQview version = ',(Hi(DV_Version)+Lo(DV_Version)/100):4:2);
      Writeln ('Video Segment = ',DecToHex(VideoSeg,4));
      Writeln ('First character in row 1 is = ',char(Mem[VideoSeg:0]));
      Writeln ('All windows should now freeze for 3 seconds');
      delay (1000);
      DV_Begin_Critical;
      delay (3000);
      DV_End_Critical;
      Writeln ('Now all windows will continue.');
      Writeln ('Test completed.  Scroll back to see row 1.');
    end
end.
