program TheAllianceCommunicationsSoftware; {T.A.C.S.}
                                           {Written by Keith Brown}
                                           {For use with Alliance BBS Software}
                                           {Alliance - Copyright 1992 BaseTwo Software}

uses crt,dos,apansi,modem,apmisc,oomodem,strunit,fastttt5,keyttt5,menuttt5,readttt5,winttt5;

type setuprec=record
       com:byte;
       baud,inbuf,outbuf:word;
       realname,address,city,country,occup:string[30];
       voice,data:string[12];
       state:string[2];
       zipcode:string[10];
       bday:string[8];
       sex:char;
     end;

     bbsrec=record
       name,handle:string[30];
       phone:string[20];
       password:string[20];
       com:byte;
       baud:word;
       laston:string[8];
       numon:integer;
       alliance:boolean;
     end;

var setup:setuprec;
    setupfile:file of setuprec;
    bbs:array [1..50] of bbsrec;
    fon:bbsrec;
    bbsfile:file of bbsrec;
    Main_Choice,Choice,Error,i:integer;
    X,Y,ScanTop,ScanBot:byte;
    curset:char;
    MM,M1:Menu_record;
    Done:Boolean;

procedure sendmodemstring (s:string);
var i,ii:integer;
    c,cc:char;
label exit;
begin
  ii:=0;
  while ii<length (s) do begin
    inc (ii);
    cc:=s[ii];
    case cc of
      '|':sendchar (^M);
      '~':delay (500);
      '^':begin
            inc (ii);
            if ii>length (s) then cc:='^' else cc:=upcase (s[ii]);
            if cc in ['A'..'Z'] then sendchar (chr (ord (cc)-64)) else sendchar(cc);
          end;
      else sendchar (cc);
    end;
    delay (50);
    while numchars>0 do c:=getchar;
  end;
end;

procedure hangupmdm;
  var b:byte;
begin
  {hangup;
  b:=0;
  while carrier and (b<6) do begin
    sendmodemstring ('+++~~~ATH|');
    hangup;
    inc (b);
  end;}
  repeat
    hangup;
  until not carrier;
  setparam (setup.com,setup.baud,false);
end;

procedure read_string_path (i,ii,iii:integer; s:string; j:integer; var ss:string);
begin
  read_string_upper (i,ii,iii,s,j,ss);
  if ss[length (ss)]<>'\' then ss:=ss+'\';
end;

procedure read_date (i,ii:integer; s:string; iii:integer; var ss:string);
begin
  repeat
    read_string (i,ii,8,s,iii,ss);
  until validdate (ss);
end;

procedure read_time (i,ii:integer; s:string; iii:integer; var ss:string);
begin
  repeat
    read_string (i,ii,8,s,iii,ss);
  until validtime (ss);
end;

function numbbs:integer;
begin
  numbbs:=filesize (bbsfile);
end;

procedure readbbs (i:integer; var bbs:bbsrec);
begin
  seek (bbsfile,i-1);
  read (bbsfile,bbs);
end;

procedure writebbs (i:integer; bbs:bbsrec);
begin
  seek (bbsfile,i-1);
  write (bbsfile,bbs);
end;

procedure maintacs;
  var c:char;
      fon:bbsrec;
      where:integer;

    procedure alliancesettings (c:char);

      function totalpick:integer;
        var i,ii:integer;
      begin
        ii:=0;
        for i:=1 to 30 do if length (m1.topic[i])>0 then inc (ii);
        totalpick:=ii;
      end;

    begin
      curset:=c;
      Menu_Set(M1);
      With M1 do begin
        Heading1 := 'Alliance X-pert Menus';
        case c of
          'M':begin
                topic[1]:='BBS List Menu';
                topic[2]:='File Menu';
                topic[3]:='Message Menu';
              end;
          '1':begin
                topic[1]:='Add BBS';
                topic[2]:='Delete BBS';
                topic[3]:='List BBSes';
              end;
        end;
        totalpicks:=totalpick;
        inc (totalpicks);
        if c<>'M' then topic[totalpicks]:='Quit to Main' else
        topic[totalpicks]:='Quit & Save';
        AddPrefix := 2;
        if c<>'M' then PicksPerLine :=3 else PicksPerLine := 2;
        TopleftXY[1] := 0;            {system will center menu}
        TopleftXY[2] := 0;            {Y coordinate}
        Boxtype := 5;                 {fancy box}
        Margins := 2;
        AllowEsc:=true;
      end;
      If BaseOfScreen = $B800 then with RTTT do begin
        FCol := white;
        BCol := blue;
        HiFCol := white;
        HiBCol := black;
        LoFCol := lightgray;
        LoBCol := black;
        PFCol := white;
        PBCol := blue;
        BoxFCol := white;
        BoxBCol := blue;
        Msg_FCol := white;
        Msg_BCol := blue;
      end;
      Choice:=1;
    end; {Define_Menu1}

    Procedure AllianceMenu;
    Begin
      Activate_Visible_Screen;
      SlideRestoreScreen(2,Down);
      Clrscr;
      AllianceSettings ('M');
      repeat
        FillScreen(1,1,80,25,white,blue,chr(176));
        Findcursor(X,Y,ScanTop,ScanBot);
        OffCursor;
        DisplayMenu(M1,false,Choice,Error);
        case curset of
          'M':case choice of
                1:alliancesettings ('1');
                2:alliancesettings ('2');
                3:alliancesettings ('3');
                4:hangupmdm;
              end;
          '1':case choice of
                1:sendstring ('BA'#13);
                2:sendstring ('BD'#13);
                3:sendstring ('BL'#13);
                4:alliancesettings ('M');
              end;
          '2':{case choice of
              end};
          '3':{case choice of
              end};
        end;  {case}
      until not carrier;
      Choice:=1;
      restorescreen (1);
    end;

    procedure spacewrite (s:string; i:integer);
      var ii:integer;
    begin
      write (s);
      for ii:=length (s) to i-1 do write (' ');
    end;

    procedure editentry (i:integer);
      var c:char;
          fon:bbsrec;
          ii:integer;
          s:string[80];
    begin
      fon:=bbs[i];
      mkwin (17,5,63,18,15,1,6);
      textcolor (15);
      textbackground (1);
      gotoxy (19,6);
      write ('[A] Name:'); {29,6}
      gotoxy (19,7);
      write ('[B] Phone Number:'); {37,7}
      gotoxy (19,8);
      write ('[C] Handle:'); {31,8}
      gotoxy (19,9);
      write ('[D] Password:'); {33,9}
      gotoxy (19,10);
      write ('[E] COM Port:'); {33,10}
      gotoxy (19,11);
      write ('[F] Baud Rate:'); {34,11}
      gotoxy (19,12);
      write ('[G] Last on:'); {32,12}
      gotoxy (19,13);
      write ('[H] Times on:'); {33,13}
      gotoxy (19,14);
      write ('[I] Alliance BBS:'); {37,14}
      repeat
        gotoxy (29,6);
        spacewrite (fon.name,30);
        gotoxy (37,7);
        spacewrite (fon.phone,20);
        gotoxy (31,8);
        spacewrite (fon.handle,30);
        gotoxy (33,9);
        spacewrite (fon.password,20);
        gotoxy (33,10);
        write (fon.com);
        gotoxy (34,11);
        spacewrite (strr (fon.baud),5);
        gotoxy (32,12);
        spacewrite (fon.laston,8);
        gotoxy (33,13);
        spacewrite (strr (fon.numon),5);
        gotoxy (37,14);
        write (boostr (fon.alliance));
        s:='[ESC] Exit  [F1] Save  [CR] Edit';
        ii:=(80-length (s)) div 2;
        gotoxy (ii,16);
        write (s);
        c:=#0;
        c:=upcase (getkey);
        case c of
          'A':read_string (29,6,30,'',0,fon.name);
          'B':read_string (37,7,20,'',0,fon.phone);
          'C':read_string (31,8,30,'',0,fon.handle);
          'D':read_string (33,9,20,'',0,fon.password);
          'E':read_byte (33,10,1,'',0,fon.com,1,4);
          'F':read_word (34,11,5,'',0,fon.baud,1200,38400);
          'G':read_date (32,12,'',0,fon.laston);
          'H':read_int (33,13,5,'',0,fon.numon,0,32767);
          'I':read_yn (37,14,'',0,fon.alliance);
          #187:begin
                bbs[i]:=fon;
                writebbs (i,bbs[i]);
              end;
        end;
      until (c=#27) or (c=#187);
      rmwin;
    end;

    procedure showbbs (i:integer);
      var ii:integer;
    begin
      ii:=i;
      repeat
        if ii>10 then dec (ii,10);
      until ii<=10;
      gotoxy (7,ii+7);
      if where=i then begin
        textcolor (15);
        textbackground (7);
      end else begin
        textcolor (15);
        textbackground (1);
      end;
      write ('  ');
      spacewrite (strr (i),4);
      spacewrite (bbs[i].name,32);
      spacewrite (bbs[i].phone,22);
      spacewrite (strr (bbs[i].numon),7);
    end;

    procedure showdirectory (b:boolean; ii:integer);
      var i:integer;
          s:string[80];
    begin
      if b then begin
        FillScreen(1,1,80,25,white,blue,chr(176));
        OffCursor;
        mkwin (5,5,75,21,15,1,5);
        gotoxy (9,6);
        textcolor (15);
        textbackground (1);
        write ('#   Name                            Phone Number          # on');
      end;
      for i:=ii-9 to ii do showbbs (i);
      if b then begin
        s:='[D] Delete BBS  [E] Add/Edit BBS  [S] Sort';
        i:=(80-length (s)) div 2;
        gotoxy (i,19);
        write (s);
        s:='[CR] Dial  [ALT-T] Terminal  [ALT-X] Main Menu';
        i:=(80-length (s)) div 2;
        gotoxy (i,20);
        write (s);
      end;
      textbackground (0);
    end;

    procedure update (i:integer);
    begin
      case where of
        1..10:showdirectory (false,10);
        11..20:showdirectory (false,20);
        21..30:showdirectory (false,30);
        31..40:showdirectory (false,40);
        41..50:showdirectory (false,50);
      end;
    end;

    procedure terminal;
      var c,cc:char;
      label exit;
    begin
      textcolor (15);
      textbackground (0);
      clrscr;
      OnCursor;
      repeat
        c:=#0;
        cc:=#0;
        if keypressed then begin
          cc:=getkey;
          case cc of
            #163:hangupmdm;
            #160,#163:goto exit;
            #174:clrscr;
          end;
          if cc<>#0 then sendchar (cc);
          {if cc=#13 then sendchar (^J);}
        end;
        if numchars>0 then begin
          c:=getchar;
          if c<>#0 then writecharansi (c);
          {if c=#13 then write (^J);}
        end;
      until cc=#160;
      exit:
      OffCursor;
      restorescreen (1);
    end;

    procedure dialnumber (s:string);
    begin
      sendmodemstring ('ATDT'+s+'|');
    end;

    procedure dial (var bbs:bbsrec);
      var i:integer;
          s:string;
      label connect,exit;
    begin
      mkwin (25,9,55,15,15,1,6);
      textcolor (15);
      textbackground (1);
      gotoxy (27,10);
      write ('Name: '+bbs.name);
      gotoxy (27,11);
      write ('Phone: '+bbs.phone);
      s:='[ESC] Exit  [Space] Cycle';
      i:=(80-length (s)) div 2;
      gotoxy (i,13);
      write (s);
      dialnumber (bbs.phone);
      s:='';
      repeat
        if numchars>0 then if not carrier then s:=s+getchar;
        if (pos ('BUSY',s)>0) or (pos ('NO DIAL',s)>0) or (pos ('NO CARRIER',s)>0) or
        (pos ('VOICE',s)>0) then begin
          s:='';
          sendmodemstring ('|');
          delay (100);
          dialnumber (bbs.phone);
        end;
        if keypressed then case upcase (readkey) of
          #27:begin
                sendmodemstring ('|');
                hangupmdm;
                rmwin;
                goto exit;
              end;
          ' ':begin
                sendmodemstring ('|');
                delay (100);
                dialnumber (bbs.phone);
              end;
        end;
      until carrier;
      connect:
      rmwin;
      bbs.laston:=curdate;
      inc (bbs.numon);
      if bbs.alliance then alliancemenu else terminal;
      exit:
    end;

    procedure sort (i:integer);
      var b:boolean;
          bbs1,bbs2,temp:bbsrec;
          ii:integer;
    begin
      repeat
        b:=false;
        ii:=1;
        while ii<i do begin
          bbs1:=bbs[ii];
          bbs2:=bbs[ii+1];
          if (bbs1.name>bbs2.name) and (bbs2.name<>'') then begin
            b:=true;
            temp:=bbs2;
            bbs2:=bbs1;
            bbs1:=temp;
            bbs[ii]:=bbs1;
            bbs[ii+1]:=bbs2;
          end;
          inc (ii);
        end;
      until not b;
    end;

begin
  where:=1;
  showdirectory (true,10);
  repeat
    showbbs (where);
    c:=upcase (getkey);
    case c of
      'D':begin
            for i:=where+1 to numbbs do bbs[i-1]:=bbs[i];
            fillchar (bbs[numbbs],sizeof (bbs[numbbs]),0);
            update (where);
          end;
      'E':begin
            editentry (where);
            update (where);
          end;
      'S':begin
            sort (numbbs);
            update (where);
          end;
      #13:if length (bbs[where].phone)>0 then dial (bbs[where]);
      #148:terminal;
      #200:begin
             dec (where);
             if where<1 then where:=50;
             update (where);
           end;
      #201:if where>10 then begin
             dec (where,10);
             update (where);
           end;
      #208:begin
             inc (where);
             if where>50 then where:=1;
             update (where);
           end;
      #209:if where<41 then begin
             inc (where,10);
             update (where);
           end;
    end;
    savescreen (1);
  until (c=#173);
  for i:=1 to 50 do writebbs (i,bbs[i]);
  rmwin;
  textcolor (7);
  textbackground (0);
end;

procedure loadsetup (b:boolean);
begin
  assign (setupfile,'TACS.DAT');
  reset (setupfile);
  if (ioresult<>0) then if b then begin
    clrscr;
    writeln ('The setup file does not exist.  Please run SETUP.EXE.');
    halt (255);
  end else rewrite (setupfile);
  seek (setupfile,0);
end;

procedure readsetup;
begin
  loadsetup (true);
  read (setupfile,setup);
  close (setupfile);
end;

procedure writesetup;
begin
  loadsetup (false);
  write (setupfile,setup);
  close (setupfile);
end;

procedure getcolorvar (attr:byte; var fg,bk:integer);
begin
  fg:=attr and 15;
  bk:=attr div 16;
end;

procedure read_color (var color:byte);
  var c:char;
      i,ii,iii,j:integer;
begin
  mkwin (5,10,25,15,15,1,6);
  textcolor (15);
  textbackground (1);
  gotoxy (7,13);
  for i:=0 to 15 do begin
    textcolor (i);
    write ('');
  end;
  iii:=color;
  getcolorvar (iii,i,ii);
  repeat
    j:=i+(16*ii);
    gotoxy (i+7,12);
    textcolor (15);
    write ('F');
    gotoxy (ii+7,14);
    write ('B');
    if j=0 then begin
      textcolor (0);
      textbackground (7);
    end else begin
      textcolor (i);
      textbackground (ii);
    end;
    gotoxy (7,11);
    write ('Color');
    textcolor (15);
    textbackground (1);
    c:=getkey;
    if c=#205 then begin
      gotoxy (i+7,12);
      write (' ');
      inc (i);
      if i>15 then i:=0;
    end else if c=#203 then begin
      gotoxy (i+7,12);
      write (' ');
      dec (i);
      if i<0 then i:=15;
    end;
    if c=#200 then begin
      gotoxy (ii+7,14);
      write (' ');
      inc (ii);
      if ii>7 then ii:=0;
    end else if c=#208 then begin
      gotoxy (ii+7,14);
      write (' ');
      dec (ii);
      if ii<0 then ii:=7;
    end;
    j:=i+(16*ii);
  until (c=#13) or (c=#27);
  if c=#13 then color:=j;
  Rmwin;
  textbackground (0);
end;

procedure settings (c:char);

  function totalpick:integer;
    var i,ii:integer;
  begin
    ii:=0;
    for i:=1 to 30 do if length (mm.topic[i])>0 then inc (ii);
    totalpick:=ii;
  end;

begin
  curset:=c;
  Menu_Set(MM);
  With MM do begin
    Heading1 := 'TACS 1.00';
    case c of
      'M':begin
            topic[1]:='Setup Options';
            topic[2]:='TACS Dialer';
          end;
      '1':begin
            topic[1]:='Modem Info';
            topic[2]:='Personal Info';
          end;
      '2':begin
            topic[1]:='COM Port';
            topic[2]:='DTE Baud Rate';
            topic[3]:='Input Buffer';
            topic[4]:='Output Buffer';
          end;
      '3':begin
            topic[1]:='Real Name';
            topic[2]:='Voice Phone #';
            topic[3]:='Data Phone #';
            topic[4]:='Street Address';
            topic[5]:='City (not state)';
            topic[6]:='State';
            topic[7]:='Zip Code';
            topic[8]:='Sex';
            topic[9]:='Birthdate';
            topic[10]:='Occupation';
          end;
    end;
    totalpicks:=totalpick;
    inc (totalpicks);
    if c<>'M' then topic[totalpicks]:='Quit to Main' else
    topic[totalpicks]:='Quit & Save';
    AddPrefix := 2;
    if c<>'M' then PicksPerLine :=3 else PicksPerLine := 2;
    TopleftXY[1] := 0;            {system will center menu}
    TopleftXY[2] := 0;            {Y coordinate}
    Boxtype := 5;                 {fancy box}
    Margins := 2;
    AllowEsc:=true;
  end;
  If BaseOfScreen = $B800 then with RTTT do begin
    FCol := white;
    BCol := blue;
    HiFCol := white;
    HiBCol := black;
    LoFCol := lightgray;
    LoBCol := black;
    PFCol := white;
    PBCol := blue;
    BoxFCol := white;
    BoxBCol := blue;
    Msg_FCol := white;
    Msg_BCol := blue;
  end;
  Main_Choice:=1;
end; {Define_Menu1}

Procedure Menu;
  var s:string[1];
Begin
  Activate_Visible_Screen;
  SlideRestoreScreen(2,Down);
  Clrscr;
  Done:=False;
  Settings ('M');
  repeat
    FillScreen(1,1,80,25,white,blue,chr(176));
    Findcursor(X,Y,ScanTop,ScanBot);
    OffCursor;
    DisplayMenu(MM,false,Main_Choice,Error);
    case curset of
      'M':case main_choice of
            1:settings ('1');
            2:begin
                openport (setup.com,setup.baud,setup.inbuf,setup.outbuf);
                assign (bbsfile,'TACS.FON');
                reset (bbsfile);
                if ioresult<>0 then begin
                  rewrite (bbsfile);
                  fillchar (fon,sizeof (fon),0);
                  fon.com:=setup.com;
                  fon.baud:=setup.baud;
                  for i:=1 to 50 do writebbs (i,fon);
                end;
                for i:=1 to 50 do readbbs (i,bbs[i]);
                maintacs;
                close (bbsfile);
                closeport;
              end;
            3:begin
                 writesetup;
                 done:=true;
               end;
          end;
      '1':case main_choice of
            1:settings ('2');
            2:settings ('3');
            3:settings ('M');
          end;
      '2':case main_choice of
            1:read_byte (5,10,1,'^COM Port',6,setup.com,1,4);
            2:read_word (5,10,5,'^DTE Baud Rate',6,setup.baud,1200,38400);
            3:read_word (5,10,5,'^Input Buffer',6,setup.inbuf,0,65535);
            4:read_word (5,10,5,'^Output Buffer',6,setup.outbuf,0,65535);
            5:settings ('1');
          end;
      '3':case main_choice of
            1:repeat
                read_string (5,10,30,'^Real Name',6,setup.realname);
              until length (setup.realname)>0;
            2:repeat
                read_string (5,10,12,'^Voice Phone # (xxx-xxx-xxxx)',6,setup.voice);
              until (setup.voice[4]='-') and (setup.voice[8]='-');
            3:repeat
                read_string (5,10,12,'^Data Phone # (xxx-xxx-xxxx)',6,setup.data);
              until (setup.data[4]='-') and (setup.data[8]='-');
            4:repeat
                read_string (5,10,30,'^Street Address',6,setup.address);
              until length (setup.address)>0;
            5:repeat
                read_string (5,10,30,'^City (not state)',6,setup.city);
              until length (setup.city)>0;
            6:repeat
                read_string (5,10,2,'^State',6,setup.state);
              until length (setup.state)=2;
            7:repeat
                read_string (5,10,10,'^Zip Code',6,setup.zipcode);
              until length (setup.zipcode)>=5;
            8:repeat
                s:=setup.sex;
                read_string (5,10,1,'^Sex',6,s);
                setup.sex:=s[1];
              until (setup.sex='M') or (setup.sex='F');
            9:repeat
                read_string (5,10,8,'^Birthdate',6,setup.bday);
              until (setup.bday[3]='/') and (setup.bday[6]='/');
            10:repeat
                 read_string (5,10,30,'^Occupation',6,setup.occup);
               until length (setup.occup)>0;
            11:settings ('1');
          end;
    end;  {case}
  until Done;
  OnCursor;
  ClrScr;
  Main_Choice:=1;
End;

begin
  assign (setupfile,'TACS.DAT');
  reset (setupfile);
  if ioresult<>0 then begin
    rewrite (setupfile);
    setup.com:=1;
    setup.baud:=38400;
    setup.inbuf:=2048;
    setup.outbuf:=2048;
    setup.realname:='';
    setup.voice:='';
    setup.data:='';
    setup.address:='';
    setup.city:='';
    setup.state:='';
    setup.zipcode:='';
    setup.sex:=#0;
    setup.bday:='';
    setup.occup:='';
    settings ('1');
    writesetup;
  end else begin
    seek (setupfile,0);
    read (setupfile,setup);
    settings ('M');
  end;
  menu;
  writesetup;
  halt (255);
end.