Unit Scrlback;
{$F+}
Interface

Procedure DispAns(artfname : String);
Uses
   Crt;
const
   normset : array[0..7] of byte = (0, 4, 2, 6, 1, 5, 3, 7);
   highset : array[0..7] of byte = (8,12,10,14,9,13,11,15);
type
   screenline = Array[1..160] of byte;
   rgb = record
            r,g,b : byte;
         end;
   palette = array[0..63] of rgb;
var
   ansi : array[1..1500] of ^screenline;
   ansF : text;
   ansS : String;
   numlines, curline, i, j, ypos, rxpos, rypos, ryypos, xpos : integer;
   choice, absypos,  fg, bg, c, b, attr, pal : byte;
   high, blink, highback, usepipe : Boolean;
   normpal, graypal : palette;
   tempa : byte;
   numtoscroll : word;
   artfile : text;

{---------------------------------------------------------------------------}
Procedure getpals;
var
   i, gray : byte;
Begin
   for i := 0 to 63 do
   Begin
      Port[$3C7] := i;
      normpal[i].R := Port[$3C9];
      normpal[i].G := Port[$3C9];
      normpal[i].B := Port[$3C9];
      gray := (normpal[i].R + normpal[i].G + normpal[i].B) div 3;
      graypal[i].R := gray;
      graypal[i].G := gray;
      graypal[i].B := gray;
   end;
end;
{---------------------------------------------------------------------------}
Procedure setpal(pal : byte);
var
   i : byte;
Begin
   case pal of
{norm}1 : Begin
             for i := 0 to 63 do
             Begin
                Port[$3C8] := i;
                Port[$3C9] := normpal[i].R;
                Port[$3C9] := normpal[i].G;
                Port[$3C9] := normpal[i].B;
             end;
          End;
{gray}2 : Begin
             for i := 0 to 63 do
             Begin
                Port[$3C8] := i;
                Port[$3C9] := graypal[i].R;
                Port[$3C9] := graypal[i].G;
                Port[$3C9] := graypal[i].B;
             end;
          End;
{asc} 3 : Begin
             for i := 1 to 25 do
             Begin
                j := 0;
                While j <> 160 do
                Begin
                    mem[$B800 : (i-1) * 160 + (j+1)] := 7;
                    inc(j,2);
                End;
             End;
          End;
   end; {case}
End;
{---------------------------------------------------------------------------}
procedure SetScanLine(line : word);
begin
  while port[$3da] and 1 <> 0 do {nothing};
  port[$3d4] := 8;
  port[$3d5] := line and 15;
  line := (line shr 4)*80;
  port[$3d4] := $D;
  port[$3d5] := lo(line);
  port[$3d4] := $C;
  port[$3d5] := hi(line);
  inline {this is the vretrace}
    ($BA/$DA/$03/ { mov dx,$03DA   }
     $EC/         { in al,dx   <-\ }
     $A8/$08/     { test al,8    | }
     $75/$FB/     { jnz >--------/ }
     $EC/         { in al,dx   <-\ }
     $A8/$08/     { test al,8    | }
     $74/$FB);    { jz >---------/ }
end;
{---------------------------------------------------------------------------}
Procedure ToggleBlink(OffOn:Boolean); Assembler;
Asm
  Push AX
  Mov AX,$1003
  Mov BL,OffOn
  Int $10
  Pop AX
End;
{---------------------------------------------------------------------------}
Function valS(s : String) : word;
Var
   tempword : word;
   code : integer;
Begin {valS}
   Val(s, tempword, code);
   valS := tempword;
End;  {valfunc}
{---------------------------------------------------------------------------}
procedure evals(s : String);
   procedure docolor(w : word);
   Begin {docolor}
      case w of
         0 : begin
                fg := 7;
                bg := 0;
                high := False;
                blink := false;
                c := 7;
                b := 0;
             end;
         1 : begin
                if blink then c := highset[fg] + 128 else
                   c := highset[fg];
                high := true;
             end;
         5 : begin
                if high then c := highset[fg] + 128 else
                   c := normset[fg]+128;
                blink := true;
             end;
      End;
      if (w>29) and (w<38) then
      begin
         w := w - 30;
         fg := w;
         if (high=true) and (blink=true) then c := highset[fg]+128;
         if (high=true) and (blink=false) then c := highset[fg];
         if (high=false) and (blink=true) then c := normset[fg]+128;
         if (high=false) and (blink=false) then c := normset[fg];
      end;
      if (w>39) and (w<48) then
      Begin
         w := w - 40;
         bg := w;
         b := normset[bg];
      End;
      attr := b * 16 + c;
   End;  {docolor}

var
   tempw, tempw2, sindex : word;
   strpos : byte;
   temps, tempws : string;
   tempc : char;
   twochar : string[2];

Begin
   If s = '' then
   Begin
      inc(ypos); If absypos < 25 then inc(absypos);
      exit;
   End;
   strpos := 0;
   Repeat
      inc(strpos);
      If (usepipe) and (s[strpos] = '|') and (strpos <= Ord(s[0]) - 2) then
      Begin
         twochar := copy(s,strpos+1,2);
         If (twochar[1] in['0'..'9']) and (twochar[2] in['0'..'9']) Then
         Begin
            attr := valS(twochar);
            fg := attr and $0f;
            bg := (attr and $f0) shr 4;
            inc(strpos,2);
         End;
      End else
      If (usepipe) and (s[strpos] + s[strpos+1] = '@X') and (strpos+1 <= Ord(s[0]) - 2) then
      Begin
         twochar := copy(s,strpos+2,2);
         if (twochar[1] in['0'..'9', 'A'..'F']) and (twochar[2] in['0'..'9','A'..'F']) Then
         Begin
            attr := valS('$'+twochar);
            fg := attr and $0f;
            bg := (attr and $f0) shr 4;
            inc(strpos,3);
         End;
      End else
      if s[strpos] = #27 then
      Begin
         inc(strpos);
         temps := '';
         repeat
            if strpos = length(s) then break;
            inc(strpos);
            tempc := s[strpos];
            temps := temps + tempc;
         Until tempc in['h','','m','H','f','A','B','C','D','s','u','J','K'];
         case tempc of
            'm' : Begin {m}
                     Delete(temps, length(temps), 1);
                     tempw2 := 0;
                     for i := 1 to length(temps) do
                        if temps[i] = ';' then tempw2 := i;
                     if tempw2 = 0 then
                     Begin
                        docolor(valS(temps));
                     End
                     else begin
                        sindex := 0;
                        tempw := 0;
                        for i := 1 to tempw2 do
                        Begin
                           if temps[i] = ';' then
                           begin
                              sindex := tempw;
                              tempw := i;
                              tempws := copy(temps, sindex+1, tempw-(sindex+1));
                              docolor(valS(tempws));
                           end;
                        End;  {for}
                        tempws := copy(temps, tempw2+1, length(temps) - tempw2);
                        docolor(valS(tempws));
                     end; {else}
                  End;  {M}
        'f','H' : Begin
                     Delete(temps, length(temps), 1);
                     if length(temps) in[1,2] then
                     Begin
                        tempws := temps;
                        inc(ypos, valS(tempws) - absypos);
                        absypos := valS(tempws);
                        xpos := 1;
                     End
                     Else Begin
                        i := 0; repeat inc(i); until temps[i] = ';';
                        tempw := i; tempws := copy(temps, 1, tempw-1);
                        If valS(tempws) in [1..25] Then
                        Begin
                           inc(ypos, valS(tempws) - absypos);
                           absypos := valS(tempws);
                        End;
                        tempws := copy(temps, tempw+1, length(temps)-1);
                        If valS(tempws) in [1..80] Then xpos := valS(tempws);
                     End;
                  End;
            'A' : Begin
                     If length(temps) = 1 then temps := '1A';
                     delete(temps, length(temps), 1);
                     If absypos - valS(temps) > 0 Then
                     Begin
                        dec(absypos, valS(temps)); dec(ypos, valS(temps));
                     End;
                  End;
            'B' : Begin
                     If length(temps) = 1 then temps := '1B';
                     delete(temps, length(temps), 1);
                     If absypos + valS(temps) < 26 Then
                     Begin
                        inc(absypos, valS(temps)); inc(ypos, valS(temps));
                     End;
                  End;
            'C' : Begin
                     If length(temps) = 1 then temps := '1C';
                     delete(temps, length(temps), 1);
                     If xpos + valS(temps) < 81 Then inc(xpos, valS(temps));
                  End;
            'D' : Begin
                     If length(temps) = 1 then temps := '1D';
                     delete(temps, length(temps), 1);
                     If xpos - valS(temps) > 0 Then dec(xpos, valS(temps));
                  End;
            's' : Begin rxpos := xpos; rypos := absypos; ryypos := ypos; End;
            'u' : Begin
                     ypos := ryypos;
                     xpos := rxpos; absypos := rypos;
                  End;
            'J' : If temps = '2J' Then
                  Begin
                     For i := 1 to numlines do
                     Begin
                        j := 0;
                        if assigned(ansi[i]) = false then
                        Begin
                           new(ansi[i]);
                           fillchar(ansi[i]^,160,0);
                        End;
                        repeat
                           inc(j, 2);
                           ansi[i]^[j-1] := 32;
                           ansi[i]^[j] := attr;
                        until j = 160;
                     End;
                     xpos := 1;
                     ypos := 1;
                     absypos := 1;
                  End;
            'K' : Begin
                     if assigned(ansi[ypos]) = false then
                     Begin
                        new(ansi[ypos]);
                        fillchar(ansi[ypos]^,160,0);
                     End;
                     for i := xpos to 80 do
                     Begin
                        ansi[ypos]^[i*2-1] := 32;
                        ansi[ypos]^[i*2] := attr;
                     End;
                  End;
         End; {case}
      End
      else Begin
         if assigned(ansi[ypos]) = false then
         Begin
            new(ansi[ypos]);
            fillchar(ansi[ypos]^,160,0);
         End;
         ansi[ypos]^[xpos*2-1] := ord(s[strpos]);
         ansi[ypos]^[xpos*2] := attr;
         inc(xpos);
         if xpos = 81 then
         begin
            inc(ypos); If absypos < 25 then inc(absypos);
            xpos := 1;
         End;
         if numlines < ypos then numlines := ypos;
      End; {else}
   Until strpos >= length(s);
   inc(ypos); If absypos < 25 then inc(absypos);
   xpos := 1;
End;
{---------------------------------------------------------------------------}
Function GetChoice : Byte;
Var
   ch : Char;
Begin
   Repeat
      Repeat
         ch := ReadKey;
      Until ch in[#13,#27,#0,#32];
      Case ch of
         #13 : Begin GetChoice := 255; Exit; End;
         #27,#32 : Begin GetChoice := 0; Exit; End;
         #0 : Begin
                 ch := ReadKey;
                 Case ch of
                  {u}'H' : Begin GetChoice := 1; Exit; End;
                  {d}'P' : Begin GetChoice := 2; Exit; End;
                  {h}'G' : Begin GetChoice := 3; Exit; End;
                  {e}'O' : Begin GetChoice := 4; Exit; End;
                 {pu}'I' : Begin GetChoice := 5; Exit; End;
                 {pd}'Q' : Begin GetChoice := 6; Exit; End;
                 {f1}
                 {f2}
                 {f3}'=' : Begin GetChoice := 9; Exit; End;
                 {f4}'>' : Begin GetChoice := 10; Exit; End;
                 End;{inner case}
              End;
      End; {case}
   Until 0=1; {endless loop.. however each thing has an exit}
End;
{---------------------------------------------------------------------------}
Begin
   xpos := 1;
   ypos := 1;
   fg :=7;
   bg := 0;
   attr := 7;
   high := false;
   blink := false;
   absypos := 1;
   numlines := 1;
   Assign(artfile, artfname);
   Reset(artfile);
   readln(artfile, ansS);
   Readln(artfile, ansS);
   While (not eof(artfile)) do begin
      evalS(ansS);
      Readln(artfile, ansS);
   end;
   if numlines < 25 then numlines := 25;
   for i := 1 to numlines do
      if assigned(ansi[i]) = false then
      Begin
         new(ansi[i]);
         fillchar(ansi[i]^,160,0);
      End;
   tempa := textattr;
   textattr := 7;
   ClrScr;
   pal := 1;
   highback := false;
   getpals;
   toggleblink(not(highback));
   if numlines < 25 then
   Begin
      for i := 1 to numlines do
         move(ansi[i]^, ptr($B800, (i-1) * 160)^, 160);
      for i := numlines + 1 to 25 do
         fillchar(ptr($B800, (i-1) * 160)^, 160, 0);
   End else
      for i := 1 to 25 do
         move(ansi[i]^, ptr($B800, (i-1) * 160)^, 160);
   curline := 25;
   repeat
      choice := getchoice;
      case choice of
      {u}1 : If curline > 25 then
             Begin
                gotoxy(1,1); insline;
                dec(curline);
                if pal <> 3 then
                   move(ansi[curline-24]^, ptr($B800, 0)^, 160)
                else
                Begin
                   i := 0;
                   While i < 160 do
                   Begin
                      mem[$B800 : i] := ansi[curline-24]^[i+1];
                      inc(i,2);
                   End;
                End;
             End;
      {d}2 : If curline < numlines then
             Begin
                gotoxy(1,1); delline;
                inc(curline);
                if pal <> 3 then
                   move(ansi[curline]^, ptr($B800, 24 * 160)^, 160)
                else
                Begin
                   i := 0;
                   While i < 160 do
                   Begin
                      mem[$B800 : 24 * 160 + i] := ansi[curline]^[i+1];
                      inc(i,2);
                   End;
                End;
             End;
      {h}3 : If curline > 25 then
             Begin
                curline := 25;
                if pal <> 3 then
                Begin
                   for i := 1 to 25 do
                      move(ansi[i]^, ptr($B800, (i-1) * 160)^, 160);
                End
                Else
                   for i := 1 to 25 do
                   Begin
                      j := 0;
                      While j < 160 do
                      Begin
                          mem[$B800 : (i-1) * 160 + j] := ansi[i]^[j+1];
                          inc(j,2);
                      End;
                   End;
             End; {3}
      {e}4 : If curline < numlines then
             Begin
                curline := numlines;
                if pal <> 3 then
                Begin
                   for i := 1 to 25 do
                      move(ansi[curline-25+i]^, ptr($B800, (i-1) * 160)^, 160);
                End
                Else
                   for i := 1 to 25 do
                   Begin
                      j := 0;
                      While j < 160 do
                      Begin
                          mem[$B800 : (i-1) * 160 + j] := ansi[curline-25+i]^[j+1];
                          inc(j,2);
                      End;
                   End;
             End; {4}
     {pu}5 : If curline > 25 then
             Begin
                numtoscroll := curline - 25;
                if numtoscroll > 25 then numtoscroll := 25;
                dec(curline,25);
                If curline < 25 then curline := 25;
                If numtoscroll = 25 then
                Begin
                   move(ptr($B800, 0)^, ptr($B800, 4000)^,4000);
                   setscanline(25 * 16);
                   for i := 1 to 25 do
                      move(ansi[curline-25+i]^, ptr($B800, (i-1) * 160)^, 160);
                   if pal =3 then
                   Begin
                      for i := 1 to 25 do
                      Begin
                         j := 0;
                         While j <> 160 do
                         Begin
                            mem[$B800 : (i-1) * 160 + (j+1)] := 7;
                            inc(j,2);
                         End;
                      End;
                   End;
                   for i := 24 downto 0 do
                      SetScanLine(i * 16);
                End
                Else Begin
                   move(ptr($B800, 0)^, ptr($B800, 8000)^,4000);
                   setscanline(50 * 16);
                   for i := 1 to numtoscroll do
                      move(ansi[curline-(25-i)]^, ptr($B800, 4000+(24-(numtoscroll-i)) * 160)^, 160);
                   if pal = 3 then
                   Begin
                      for i := 1 to numtoscroll do
                      Begin
                         j := 0;
                         While j < 160 do
                         Begin
                            mem[$B800 : 4000+(24-(numtoscroll-i)) * 160 + j+1] := 7;
                            inc(j,2);
                         End;
                      End;
                   End;
                   for i := 1 to numtoscroll do
                      SetScanLine((50 - i) * 16);
                   move(ptr($B800, 4000+(24-numtoscroll+1)*160)^, ptr($B800, 0)^,4000);
                   setscanline(0);
                End;
             End; {5}
     {pd}6 : If curline < numlines then
             Begin
                numtoscroll := numlines - curline;
                if numtoscroll > 25 then numtoscroll := 25;
                inc(curline,25);
                If curline > numlines then curline := numlines;
                If numtoscroll = 25 then
                Begin
                   for i := 1 to 25 do
                      move(ansi[curline-25+i]^, ptr($B800, (i-1) * 160+4000)^, 160);
                   if pal =3 then
                   Begin
                      for i := 1 to 25 do
                      Begin
                         j := 0;
                         While j <> 160 do
                         Begin
                            mem[$B800 : (i-1) * 160 + (j+1)+4000] := 7;
                            inc(j,2);
                         End;
                      End;
                   End;
                   for i := 1 to 25 do
                   begin
                      SetScanLine(i * 16);
                   end;
                   move(ptr($B800,4000)^, ptr($B800,0)^,4000);
                   SetScanLine(0);
                End
                Else Begin
                   move(ptr($B800, 0)^, ptr($B800, 4000)^,4000);
                   setscanline(25 * 16);
                   for i := 1 to numtoscroll do
                      move(ansi[curline-i+1]^, ptr($B800, 8000+ (numtoscroll-i)* 160)^, 160);
                   if pal = 3 then
                   Begin
                      for i := 1 to numtoscroll do
                      Begin
                         j := 0;
                         While j < 160 do
                         Begin
                            mem[$B800 : 8000+(numtoscroll-i) * 160 + j+1] := 7;
                            inc(j,2);
                         End;
                      End;
                   End;
                   for i := 1 to numtoscroll do
                      SetScanLine((25 + i) * 16);
                   move(ptr($B800, 4000+numtoscroll*160)^, ptr($B800, 0)^,4000);
                   setscanline(0);
                End;
             End; {6}
     {f3}9 : Begin
                highback := not(highback);
                toggleblink(not(highback));
             End;
     {f4}10: Begin
                If pal = 3 then
                   for i := 1 to 25 do
                      move(ansi[curline-25+i]^, ptr($B800, (i-1) * 160)^, 160);
                inc(pal); if pal > 3 then pal := 1;
                setpal(pal);
             End;
      End; {case}
   Until choice in[255,0];
   for i := 1 to numlines do
      If Assigned(ansi[i]) then
      Begin
         dispose(ansi[i]);
         ansi[i] := nil;
      End;
   If not highback then toggleblink(false);
   if pal <> 1 then setpal(1);
   textattr := 7;
   ClrScr;
   textattr := tempa;
End;
{---------------------------------------------------------------------------}
{$F-}
end.  {unit}