
unit AHelpTpu;

interface

uses Windows, TheUnit, Crt, fxst, {BarMenu,} CenterSt, Dos, Answer;

type
	TopicKeyRec = record
    ext: boolean;
  	key: char;
    topic: string[40];
  end;

var
	TopicKey: array[1..40] of TopicKeyRec;
  HelpFn: string[79];
  keyset, extset: set of char;
  bo, tx, hi, bk, hbk: byte;

procedure SetHelpFn(chelpfn: string);
procedure SetCoords(cx1, cy1, cx2, cy2: byte);
procedure SetZCoords(cx1, cy1, cx2, cy2: byte);
procedure SetZoom(czoom: char);
procedure SetSearch(csearch: char);
procedure SetPrint(cprint: char);
procedure SetPrintFn(cprintfn: string);
procedure SetColors(cbo, ctx, chi, cbk, chbk: byte);
procedure SetEsc(cesc: char);
procedure SetCR(ccr: char);
procedure AddTopicKey(cext: boolean; ckey: char; ctopic: string);
procedure SetString(cnum: byte; ca: string);
procedure Help(topic: string);

implementation

const
	MaxA = 12;

var
  zoom, search, esc, cr, print: char;
	HelpFile: text;
  printfn: string;
  keynum: byte;
  A: array[1..MaxA] of string;
  registered: boolean;
  x1, y1, x2, y2, zx1, zy1, zx2, zy2: byte;

procedure VSwap(var x, y: byte);
  var
  	tmp: integer;
	begin
  	tmp := x;
    x  :=  y;
    y := tmp;
  end;

function LoCase(c: char): char;
	begin
  	if c in [#65..#90] then
    	LoCase := Chr(Ord(c)+32)
    else
    	LoCase := c;
  end;

function NCase(s: string): string;
  var
  	c: byte;
    space: boolean;
	begin
    if Length(s) = 0 then
    	NCase := ''
    else
    begin
      space := true;
      for c := 1 to Length(s) do
      begin
      	if space then
        	s[c] := UpCase(s[c])
        else
        	s[c] := LoCase(s[c]);
        if s[c] = ' ' then
        	space := true
        else
        	space := false;
      end;
      NCase := s;
    end;
  end;

function ULCase(s: string): string;
  var
  	c: byte;
	begin
  	if Length(s) = 0 then
    	ULCase := ''
    else
    begin
    	s[1] := UpCase(s[1]);
      if Length(s) > 1 then
      	for c := 2 to Length(s) do
        	s[c] := LoCase(s[c]);
      ULCase := s;
    end;
  end;

procedure SetZCoords(cx1, cy1, cx2, cy2: byte);
	begin
  	zx1 := cx1;
    zy1 := cy1;
    zx2 := cx2;
    zy2 := cy2;
  end;

procedure SetZoom(czoom: char);
	begin
  	zoom := czoom;
  end;

procedure SetPrint(cprint: char);
	begin
  	print := cprint;
  end;

procedure SetPrintFn(cprintfn: string);
	begin
  	printfn := cprintfn;
  end;

procedure SetSearch(csearch: char);
	begin
  	search := csearch;
  end;

procedure SetColors(cbo, ctx, chi, cbk, chbk: byte);
	begin
  	bo := cbo;
    tx := ctx;
    hi := chi;
    bk := cbk;
    hbk := chbk;
  end;

procedure SetEsc(cesc: char);
	begin
  	esc := cesc;
  end;

procedure SetCR(ccr: char);
	begin
  	cr := ccr;
  end;

procedure SetCoords(cx1, cy1, cx2, cy2: byte);
	begin
  	x1 := cx1;
    y1 := cy1;
    x2 := cx2;
    y2 := cy2;
  end;

procedure SetHelpFn(chelpfn: string);
	begin
  	HelpFn := FExpand(UpCaseStr(chelpfn));
  end;

procedure SetTopicKey(cnum: byte; cext: boolean; ckey: char; ctopic: string);
	begin
{    if TopicKey[ckey].cext then
    	extset := extset - [TopicKey[ckey].key]
    else
    	keyset := keyset - [TopicKey[ckey].key]}
    with TopicKey[cnum] do
    begin
      ext := cext;
      key := ckey;
      topic := ctopic;
    end;
{    if cext then
    	extset := extset + [ckey]
    else
    	keyset := keyset + [ckey];}
  end;

procedure AddTopicKey(cext: boolean; ckey: char; ctopic: string);
	begin
  	Inc(keynum);
  	SetTopicKey(keynum, cext, ckey, ctopic);
    if cext then
    	extset := extset + [ckey]
    else
    	keyset := keyset + [UpCase(ckey)];
  end;

procedure SetString(cnum: byte; ca: string);
	begin
  	A[cnum] := ca;
  end;

function ShowHelp(topic: string): string;
  var
    s: string;
    c: byte;
    ext: boolean;
    k: char;
    tmp: string;
  	chosen: string;
    online: byte;
    line: array[0..60] of string[76];
    max: byte;
    cur: byte;
	procedure PrintItAll;
    var
    	output: text;
      tmp: string;
      c: byte;
      bt: boolean;
		begin
      Window(x1+2, y1+1, x2-1, y2-1);
    	ClrScr;
      TextAttr := tx+bk*16;
      bt := Caps;
      Caps := true;
      s := UpCaseStr(Ask(A[12]+' ', hi+hbk*16, x2-x1-3-Length(A[12])-1, printfn));
      Caps := bt;
      TextAttr := tx+bk*16;
      ClrScr;
	    Write(A[8]);
      Assign(output, s);
      if FileExists(s) then
	      Append(output)
      else
      	Rewrite(output);
      for c := 1 to max-1 do
      begin
        Writeln(output, line[c]);
      end;
      Writeln(output, ^L);
      Close(output);
	  end;
  procedure AskSearch;
    var
      s, test: string;
  	begin
      cur := 1;
      max := 1;
      Window(x1+2, y1+1, x2-1, y2-1);
    	ClrScr;
      TextAttr := tx+bk*16;
      s := UpCaseStr(Ask(A[9]+' ', hi+hbk*16, x2-x1-3-Length(A[9])-1, ''));
      line[1] := A[10];
      TextAttr := tx+bk*16;
      ClrScr;
	    Write(A[8]);
  	  if not FileExists(helpfn) then
    	begin
	      line[1] := A[7]+':';
  	    line[2] := A[6];
    	  max := 3;
	    end
  	  else
    	begin
		    System.Reset(HelpFile);
  		  tmp := '';
    		while not (Eof(HelpFile)) do
	    	begin
	  	  	System.Readln(HelpFile, tmp);
          if (tmp[1] = '{') and (Pos('}', tmp) > 0) then
          begin
            test := UpCaseStr(Copy(tmp, 2, Pos('}', tmp)-2));
            if Pos(s, test) > 0 then
            begin
              Inc(max);
            	line[max] := ' {'+UpCaseStr(test)+'}';
            end;
          end;
  	  	end;
        if max = 1 then
          line[1] := A[11];
      end;
      Inc(max);
    end;
  procedure Show;
    var
    	ok: byte;
      c, c1, c2, c3, c4: byte;
      addtovar: boolean;
  	begin
      Cursor(off);
      TextAttr := tx+bk*16;
      Window(x1+2, y1+1, x2-1, y2-1);
      ClrScr;
      Window(x1+2, y1+1, x2-1, y2);
      if max-cur > (y2-y1-1) then
      	ok := (y2-y1-2)+cur
      else
      	ok := max-1;
      chosen := '';
      for c := cur to ok do
      begin
        c1 := Pos('{', line[c]);
        c2 := Pos('}', line[c]);
        if c = cur then
        	c3 := hi+hbk*16
        else
        	c3 := hi+bk*16;
      	if (c1 > 0) and (c2 > c1) then
        begin
          Write(Copy(line[c], 1, c1-1));
          TextAttr := c3;
          if c = cur then
	          chosen := Copy(line[c], c1+1, c2-c1-1);
          Write(ULCase(Copy(line[c], c1+1, c2-c1-1)));
          TextAttr := tx+bk*16;
          Write(Copy(line[c], c2+1, 255));
        end
        else
        	Write(line[c]);
  	    if c < ok then
 	  	  	Writeln;
      end;
     	TextAttr := bo+bk*16;
      GotoXY(1, y2-y1);
      Write(StringOf(x2-x1-3, ''));
      if chosen <> '' then
      begin
        GotoXY(1, y2-y1);
        Center(' '+A[1]+': '+ULCase(chosen)+' ');
      end;
    end;
	begin
    cur := 1;
    tmp := '';
    max := 0;
    chosen := '';
    online := 0;
    topic := UpCaseStr(topic);
    MakeWindow(x1, y1, x2, y2, bo, bk, double, ' '+A[2]+'  '+A[3]+'  '+A[4]+' ');
    Window(x1, y1, x2, y2);
    TextAttr := hi+bk*16;
    GotoXY(1, 2);
    Write('');
    GotoXY(x2-x1+1, 2);
    Write('');
    Window(x1+2, y1+1, x2-1, y2);
    TextAttr := tx+bk*16;
    Write(A[8]);
    if not FileExists(helpfn) then
    begin
      line[1] := A[7]+':';
      line[2] := A[6];
      max := 3;
    end
    else
    begin
	    System.Reset(HelpFile);
  	  tmp := '';
    	while not (Eof(HelpFile) or (tmp = '{'+topic+'}')) do
	    begin
  	  	System.Readln(HelpFile, tmp);
    	end;
	    if tmp <> '{'+topic+'}' then
      begin
        line[1] := A[7]+':';
        line[2] := A[5]+': '+ULCase(topic);
        max := 3;
      end
    	else
	    begin
  	    max := 0;
    	  line[0] := '';
	      while not (Eof(HelpFile) or (max = 60) or (line[max, 1] = '{')) do
  	    begin
    	  	Inc(max);
      	  System.Readln(HelpFile, line[max]);
          if Pos('{', line[max]) > 0 then
          	line[max] := Copy(line[max], 1, x2-x1-1)
          else
	        	line[max] := Copy(line[max], 1, x2-x1-3);
	      end;
  	    if max = 0 then
        begin
	        line[1] := A[7]+':';
  	      line[2] := A[5]+': '+ULCase(topic);
    	    max := 3;
        end
      	else
	      begin
					if line[max, 1] <> '{' then
	        	Inc(max);
  	      cur := 1;
        end;
      end;
	    Close(HelpFile);
    end;
    repeat
    	Show;
      ext := false;
      k := ReadKey;
      if k = #0 then
      begin
       	ext := true;
       	k := ReadKey;
        if (k in extset) and (keynum > 0) then
          for c := 1 to keynum do
 	        begin
   	      	if (TopicKey[c].ext) and (TopicKey[c].key = k) then
     	      	chosen := TopicKey[c].topic;
       	  end;
          if k = zoom then
         	begin
           	VSwap(x1, zx1); VSwap(y1, zy1);
            VSwap(x2, zx2); VSwap(y2, zy2);
            chosen := topic;
          end;
          if k = search then
          	AskSearch;
          if k = print then
          begin
          	PrintItAll;
            chosen := topic;
          end;
          case k of
           	#71: cur := 1;                                            {home}
            #72: if cur > 1 then Dec(cur);                              {up}
            #73: if cur > (y2-y1) then Dec(cur, y2-y1-1) else cur := 1; {pgup}
            #79: cur := max-1;                                         {end}
            #80: if cur < max-1 then Inc(cur);                        {down}
            #81: if cur < max-(y2-y1-1) then Inc(cur, y2-y1-1) else cur := max-1; {pgdn}
          end;
        end
        else
        begin
          k := UpCase(k);
          if (k in keyset) and (keynum > 0) then
            for c := 1 to keynum do
            begin
            	if (not TopicKey[c].ext) and (TopicKey[c].key = k) then
              	chosen := TopicKey[c].topic;
            end;
        end;
      until (not (ext) and (k in ([esc, cr]+keyset)) or
  		      (ext and (k in extset+[zoom, print])));
    RemoveWindow;
    if k = #27 then
    	chosen := '';
    ShowHelp := chosen;
  end;

procedure Help(topic: string);
	begin
    Assign(HelpFile, helpfn);
    repeat
 	  	topic := ShowHelp(topic);
   	until topic = '';
  end;

begin
  keynum := 0;
  keyset := [];
  extset := [];
  SetString(1, 'Selected topic');
  SetString(2, 'Help');
  SetString(3, 'Use arrows and <PgUp/PgDn> to move');
  SetString(4, '<Esc> to quit');
  SetString(5, 'Topic not found');
  SetString(6, 'Help file not found');
  SetString(7, 'Error');
  SetString(8, 'One moment...');
  SetString(9, 'Search what?');
  SetString(10,'Topics found:');
  SetString(11,'No topics found');
  SetString(12,'Print where?');
  HelpFn := 'AHELP.HLP';
  registered := true;
  SetColors(9, 7, 14, 1, 9);
  SetCoords(1, 3, 80, 11);
  SetZCoords(1, 1, 80, 25);
  SetZoom(#44);
  SetSearch(#31);
  SetPrint(#25);
  SetEsc(#27);
  SetCR(#13);
  SetPrintFn('PRN');
end.
