(* Version 3.5 Developmental Kit
Ŀ
                             
                           
                                                                             
 Description: Impulse COM Routines.  These are the ACTUAL routines used in   
              the BBS.  They were included to provide absolute compatibility 
              with Impulse Host System.                                      
Requirements: IMPULSE.IDF Will be useful in reading in communication info and
              passing it to the external program.  Record types have been    
              included and can be read and used in place of IMPULSE.IDF.     
       Notes: This file WILL need modifications to be put to use in any      
              external program.  Expect to Change things.                    

*)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
UNIT ImpCom;

INTERFACE

USES
  Dos;


TYPE
  imp_parity = (com_none, com_even, com_odd, com_zero, com_one);

CONST
  com_installed: Boolean = FALSE;

{This variable is TRUE if the interrupt driver has been installed, or FALSE
if it hasn't.  It's used to prevent installing twice or deinstalling when not
installed.}

  usefossil:boolean = FALSE;

{This variable is used to determine if fossil driver is in use.  If none is
detected, internal routines will be used in its place.}

var
  mpcoder:boolean;
  mpcode:array[1..6] of byte;
  fosport:word;
  regs:registers;
  irqnumber:byte;

procedure imp_flush_rx;  {destroy's all data being recieved}
procedure imp_flush_tx;  {destroy's all data being sent}
procedure imp_purge_tx;  {purges transmit buffer}
function imp_carrier:boolean; {returns TRUE is carrier is detected}
function imp_rx:char; {reads a character from the input buffer}
function imp_tx_ready:boolean; {returns TRUE if imp_tx can recieve a char}
function imp_tx_empty:boolean; {returns TRUE if transmit buffer is empty}
function imp_rx_empty:boolean; {returns TRUE if recieve buffer is empty}
procedure imp_tx (ch: Char); {sends a character to initialized port}
procedure imp_tx_string (st: String); {sends a string using imp_tx to port}
procedure imp_lower_dtr; {lowers DTR for hangup's and such}
procedure imp_raise_dtr; {raises DTR to ready status}
procedure imp_set_speed(speed:word); {if FOSSIL is in use, it is Locked at
                                      the speed, if Internal Driver is in use
                                      the port will be initialized at speed}
procedure imp_set_parity(parity:imp_parity; stop_bits:byte); {self explanatory}
procedure imp_install(portnum:word; var error:word; dofossil:boolean); {initialized port for the first time}
procedure imp_deinstall; {deactivates port}


implementation

{Maximum port number (minimum is 0) 0 Being Local.}

const
  max_port = 8;


{Base i/o address for each COM port}

const
  uart_base: ARRAY [1..max_port] OF Integer = ($3F8, $2F8, $3E8, $2E8,
                                               4220, 4228, 5220, 5228);


{Interrupt numbers for each COM port}

const
  intnums: ARRAY [1..max_port] OF Byte = ($0C, $0B, $0C, $0B,
                                          $0B, $0B, $0B, $0B);


{irq interrupt levels for each port}

const
  i8259levels: ARRAY [1..max_port] OF Byte = (4, 3, 4, 3, 3, 3, 3, 3);

{UART i/o addresses.  Values depend upon which COMM port is selected.}

var
  uart_data:word;            {Data register}
  uart_ier:word;             {Interrupt enable register}
  uart_iir:word;             {Interrupt identification register}
  uart_lcr:word;             {Line control register}
  uart_mcr:word;             {Modem control register}
  uart_lsr:word;             {Line status register}
  uart_msr:word;             {Modem status register}
  uart_spr:word;             {Scratch pad register}


{Original contents of IER and MCR registers.  Used to restore UART
to whatever state it was in before this driver was loaded.}

var
  old_ier:byte;
  old_mcr:byte;


{Original contents of interrupt vector.  Used to restore the vector when
the interrupt driver is deinstalled.}

var
  old_vector:pointer;


{Original contents of interrupt controller mask.  Used to restore the
bit pertaining to the comm controller we're using.}

var
  old_i8259_mask:byte;


{Bit mask for i8259 interrupt controller}

var
  i8259bit:byte;


{Interrupt vector number}

var
  intnum:byte;


{ Receive queue.  Received characters are held here
  until retrieved by imp_rx. }

const rx_queue_size=16; {16 normal, Change to suit}

var
  rx_queue:array[1..rx_queue_size] of byte;
  rx_in:word;           {Index of where to store next character}
  rx_out:word;          {Index of where to retrieve next character}
  rx_chars:word;        {Number of chars in queue}


{ Transmit queue.  Characters to be transmitted are held here
  until the UART is ready to transmit them. }

const tx_queue_size=16;    {16 normal, Change to suit}

var
  tx_queue:array[1..tx_queue_size] of byte;
  tx_in:integer;        {Index of where to store next character}
  tx_out:integer;       {Index of where to retrieve next character}
  tx_chars:integer;     {Number of chars in queue}


{This variable is used to save the next link in the "exit procedure" chain.}

var
  exit_save:pointer;


{Macro to disable interrupts.}

Procedure disable_interrupts;
Begin
  Inline($FA);  {CLI}
End;


{Macro to enable interrupts.}

Procedure enable_interrupts;
Begin
  Inline($FB);  {STI}
End;


{Interrupt driver.  The UART is programmed to cause an interrupt whenever
a character has been received or when the UART is ready to transmit another
character.}

{$S-}
procedure imp_interrupt_driver; interrupt;
var ch:char;
    dummy,iir:byte;
begin
  if (usefossil) then exit;
    { while bit 0 of the interrupt identification register is 0,
      there is an interrupt to process }
  iir:=port[uart_iir];

  while (not odd(iir)) do begin
    case (iir shr 1) of
        { IIR = 100b: Received data available.  Get the character,
          and if the buffer isn't full, then save it.
          If the buffer is full, then ignore it. }
      2:begin
          ch:=char(port[uart_data]);
          if (rx_chars<=rx_queue_size) then begin
            rx_queue[rx_in]:=ord(ch);
            inc(rx_in);
            if (rx_in>rx_queue_size) then rx_in:=1;
            rx_chars:=succ(rx_chars);
          end;
        end;

        { IIR = 010b: Transmit register empty.  If the transmit buffer
          is empty, then disable the transmitter to prevent any more
          transmit interrupts.  Otherwise, send the character.

          The test of the line-status-register is to see if the transmit
          holding register is truly empty.  Some UARTS seem to cause
          transmit interrupts when the holding register isn't empty,
          causing transmitted characters to be lost. }
      1:if (tx_chars<=0) then
          port[uart_ier]:=port[uart_ier] and not 2
        else
          if (odd(port[uart_lsr] shr 5)) then begin
            port[uart_data]:=tx_queue[tx_out];
            inc(tx_out);
            if (tx_out>tx_queue_size) then tx_out:=1;
            dec(tx_chars);
          end;

        { IIR = 001b: Change in modem status.  We don't expect
          this interrupt, but if one ever occurs we need to read
          the line status to reset it and prevent an endless loop. }
      0:dummy:=Port [uart_msr];

        { IIR = 111b: Change in line status.  We don't expect
          this interrupt, but if one ever occurs we need to read the
          line status to reset it and prevent an endless loop. }
      3:dummy:=port[uart_lsr];

    end;

    iir:=port[uart_iir];
  end;

    { tell the interrupt controller that we're done with this interrupt }
  port[$20]:=$20;
end;
{$S+}


  { flush (empty) the receive buffer. }
procedure imp_flush_rx;
var ch:char;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.ah:=$0A;
    intr($14,regs);
    exit;
  end;
  disable_interrupts;
  rx_chars:=0; rx_in:=1; rx_out:=1;
  enable_interrupts;
end;

  { flush (empty) transmit buffer. }
procedure imp_flush_tx;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.ah:=$08;
    intr($14,regs);
    exit;
  end;
  disable_interrupts;
  tx_chars:=0; tx_in:=1; tx_out:=1;
  enable_interrupts;
end;

  { purge (empty) transmit buffer. }
procedure imp_purge_tx;
begin
  if (not usefossil) then imp_flush_tx else begin
    regs.dx:=fosport;
    regs.ah:=$09;
    intr($14,regs);
  end;
end;

  { this function returns TRUE if a carrier is present. }
function imp_carrier:boolean;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.ah:=$03;
    intr($14,regs);
    if (regs.ax and $0080) = 0 then
      imp_carrier:=FALSE
    else
      imp_carrier:=TRUE;
    exit;
  end;
  imp_carrier:=((com_installed) and (odd (port[uart_msr] shr 7)));
end;

  { get a character from the receive buffer.
    If the buffer is empty, return NULL (#0). }
function imp_rx:char;
begin
  if (usefossil) then begin
    if (imp_rx_empty) then imp_rx:=#0
    else begin
      regs.dx:=fosport;
      regs.ah:=$02;
      intr($14,regs);
      imp_rx:=chr(regs.al);
    end;
    exit;
  end;
  if ((not com_installed) or (rx_chars=0)) then
    imp_rx:=#0
  else begin
    disable_interrupts;
    imp_rx:=chr(rx_queue[rx_out]);
    inc(rx_out);
    if (rx_out>rx_queue_size) then rx_out:=1;
    dec(rx_chars);
    enable_interrupts;
  end;
end;

  { this function returns TRUE if imp_tx can accept a character. }
function imp_tx_ready: Boolean;
begin
  if (usefossil) then begin
    imp_tx_ready:=TRUE;
    exit;
  end;
  imp_tx_ready:=((tx_chars<tx_queue_size) or (not com_installed));
end;

  { this function returns TRUE if the transmit buffer is empty. }
function imp_tx_empty:boolean;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.ah:=$03;
    intr($14,regs);
    imp_tx_empty:=((regs.ax and $4000) <> 0);
    exit;
  end;
  imp_tx_empty:=((tx_chars=0) or (not com_installed));
end;

  { this function returns TRUE if the receive buffer is empty. }
function imp_rx_empty:boolean;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.ah:=$0C;
    intr($14,regs);
    imp_rx_empty:=(regs.ax = $FFFF);
    exit;
  end;
  imp_rx_empty:=((rx_chars=0) or (not com_installed));
end;

  { send a character.  Waits until the transmit buffer isn't full,
    then puts the character into it.  The interrupt driver will
    send the character once the character is at the head of the
    transmit queue and a transmit interrupt occurs. }
procedure imp_tx(ch:char);
var result:word;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.al:=ord(ch);
    regs.ah:=$01;
    intr($14,regs);
    exit;
  end;
  if (com_installed) then begin
    repeat until (imp_tx_ready);
    disable_interrupts;
    tx_queue[tx_in]:=ord(ch);
    if (tx_in<tx_queue_size) then inc(tx_in) else tx_in:=1;
    inc(tx_chars);
    port[uart_ier]:=port[uart_ier] or 2;
    enable_interrupts;
  end;
end;

  { send a whole string }
procedure imp_tx_string(st:string);
var i:byte;
    result:word;
begin
  for i:=1 to length(st) do imp_tx(st[i]);
end;

  { lower (deactivate) the DTR line.  Causes most modems to hang up. }
procedure imp_lower_dtr;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.al:=$00;
    regs.ah:=$06;
    intr($14,regs);
    exit;
  end;
  if (com_installed) then begin
    disable_interrupts;
    port[uart_mcr]:=port[uart_mcr] and not 1;
    enable_interrupts;
  end;
end;

  { raise (activate) the DTR line. }
procedure imp_raise_dtr;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    regs.al:=$01;
    regs.ah:=$06;
    intr($14,regs);
    exit;
  end;
  if (com_installed) then begin
    disable_interrupts;
    port[uart_mcr]:=port[uart_mcr] or 1;
    enable_interrupts;
  end;
end;

  { set the baud rate.  Accepts any speed between 2 and 65535.  However,
    I am not sure that extremely high speeds (those above 19200) will
    always work, since the baud rate divisor will be six or less, where a
    difference of one can represent a difference in baud rate of
    3840 bits per second or more. }
procedure imp_set_speed (speed: Word);
var divisor:word;
    baudhigh:boolean;
begin
  if (usefossil) then begin
    regs.dx:=fosport;
    case speed of
    300:regs.al:=(2 shl 5)+3;
    600:regs.al:=(3 shl 5)+3;
    1200:regs.al:=(4 shl 5)+3;
    2400:regs.al:=(5 shl 5)+3;
    4800:regs.al:=(6 shl 5)+3;
    9600:regs.al:=(7 shl 5)+3;
    12000:regs.al:=(0 shl 5)+3;
    14400:regs.al:=(0 shl 5)+3;
    16800:regs.al:=(1 shl 5)+3;
    19200:regs.al:=(0 shl 5)+3;
    21600:regs.al:=(1 shl 5)+3;
    24000:regs.al:=(1 shl 5)+3;
    26400:regs.al:=(1 shl 5)+3;
    28800:regs.al:=(1 shl 5)+3;
    38400:regs.al:=(1 shl 5)+3;
    57600:begin
           baudhigh:=speed=57600;
           asm
           MOV AH, 1Bh
           INT 14h
           CMP CX, '0X'
           JNE @EXIT
           MOV AH, 1Eh
           MOV BX, 0000h
           MOV CH, 03h
           MOV DX, FOSPORT
           CMP BaudHigh, True
           JE @1
           MOV CL, 84h
           JMP @INT
          @1:
           MOV CL, 82h
          @INT:
           INT 14h
          @EXIT:
          end;
         exit;
         end;
   11520:begin
          baudhigh:=speed=11520;
           asm
           MOV AH, 1Bh
           INT 14h
           CMP CX, '0X'
           JNE @EXIT
           MOV AH, 1Eh
           MOV BX, 0000h
           MOV CH, 03h
           MOV DX, FOSPORT
           CMP BaudHigh, True
           JE @1
           MOV CL, 84h
           JMP @INT
          @1:
           MOV CL, 82h
          @INT:
           INT 14h
          @EXIT:
          end;
         exit;
        end;
    end;
    regs.ah:=$00;
    intr($14,regs);
    exit;
  end;
  if (com_installed) then begin
    if (speed<2) then speed:=2;
    divisor:=115200 div speed;
    disable_interrupts;
    port[uart_lcr]:=port[uart_lcr] or $80;
    portw[uart_data]:=divisor;
    port[uart_lcr]:=port[uart_lcr] and not $80;
    enable_interrupts;
  end;
end;

  { Set the parity and stop bits as follows:

     com_none    8 data bits, no parity
     com_even    7 data bits, even parity
     com_odd     7 data bits, odd parity
     com_zero    7 data bits, parity always zero
     com_one     7 data bits, parity always one }
procedure imp_set_parity(parity:imp_parity; stop_bits:byte);
var lcr:byte;
begin
  if (usefossil) then exit;
  case parity of
    com_none:lcr:=$00 or $03;
    com_even:lcr:=$18 or $02;
    com_odd:lcr:=$08 or $02;
    com_zero:lcr:=$38 or $02;
    com_one:lcr:=$28 or $02;
  end;
  if (stop_bits=2) then lcr:=lcr or $04;
  disable_interrupts;
  port[uart_lcr]:=port[uart_lcr] and $40 or lcr;
  enable_interrupts;
end;

  { Install the communications driver.  Portnum should be 1..max_port.
    Error codes returned are:

      0 - No error
      1 - Invalid port number
      2 - UART for that port is not present
      3 - Already installed, new installation ignored }

procedure imp_install(portnum:word; var error:word; dofossil:boolean);
var ier:byte;
begin
  usefossil:=false;
  if ((dofossil) and (not usefossil)) then begin
    usefossil:=FALSE;
    fosport:=portnum-1;
    regs.dx:=fosport;
    regs.ah:=$04;
    intr($14,regs);
    if (regs.ax = $1954) then begin
      usefossil:=TRUE;
      regs.dx:=fosport;
      regs.al:=$F0;
      regs.ah:=$0F;
      intr($14,regs);
    end;
  end;
  if (usefossil) then exit;
  if (com_installed) then error:=3
  else
    if ((portnum<1) or (portnum>max_port)) then error:=1
    else begin
        { set i/o addresses and other hardware specifics for selected port}
      uart_data:=uart_base [portnum];
      uart_ier:=uart_data+1;
      uart_iir:=uart_data+2;
      uart_lcr:=uart_data+3;
      uart_mcr:=uart_data+4;
      uart_lsr:=uart_data+5;
      uart_msr:=uart_data+6;
      uart_spr:=uart_data+7;
      intnum:=intnums[portnum];
      if irqnumber=0 then
        i8259bit:=1 shl i8259levels[portnum] else
          i8259bit:=1 shl irqnumber;
        { return error if hardware not installed }

      old_ier:=port[uart_ier];
      port[uart_ier]:=0;
      if (port[uart_ier]<>0) then error:=2
      else begin
        error:=0;

          { save original interrupt controller mask, then disable the
            interrupt controller for this interrupt. }
        disable_interrupts;
        old_i8259_mask:=port[$21];
        port[$21]:=old_i8259_mask or i8259bit;
        enable_interrupts;

          { clear the transmit and receive queues}
        imp_flush_tx;
        imp_flush_rx;

          { Save current interrupt vector, then set the interrupt
            vector to the address of our interrupt driver. }

        getintvec(intnum,old_vector);
        setintvec(intnum,@imp_interrupt_driver);
        com_installed:=TRUE;

          { set parity to none, turn off BREAK signal, and make sure
            we're not addressing the baud rate registers. }
        port[uart_lcr]:=3;

          { save original contents of modem control register, then enable
            interrupts to system bus and activate RTS.  Leave DTR the way
            it was. }
        disable_interrupts;
        old_mcr:=port[uart_mcr];
        port[uart_mcr]:=$A or (old_mcr and 1);
        enable_interrupts;

          { enable interrupt on data-available.  The interrupt for
            transmit-ready is enabled when a character is put into the
            transmit queue, and disabled when the transmit queue is empty. }
        port[uart_ier]:=1;

          { enable the interrupt controller for this interrupt. }
        disable_interrupts;
        port[$21]:=port[$21] and not i8259bit;
        enable_interrupts;
      end;
    end;
end;


  { Deinstall the interrupt driver completely.  It doesn't change
    the baud rate or mess with DTR; it tries to leave the interrupt
    vectors and enables and everything else as it was when the driver
    was installed.

    This procedure MUST be called by the exit procedure of this
    module before the program exits to DOS, or the interrupt driver
    will still be attached to its vector -- the next communications
    interrupt that came along would jump to the interrupt driver which
    is no longer protected and may have been written over. }
procedure imp_deinstall;
begin
  if (usefossil) then begin
    usefossil:=FALSE;
    regs.dx:=fosport;
    regs.ah:=$05;
    intr($14,regs);
    exit;
  end;
  if (com_installed) then begin
    com_installed:=FALSE;

      { restore Modem-Control-Register and Interrupt-Enable-Register. }
    port[uart_mcr]:=old_mcr;
    port[uart_ier]:=old_ier;

      { restore appropriate bit of interrupt controller's mask }
    disable_interrupts;
    port[$21]:=port[$21] and not i8259bit or old_i8259_mask and i8259bit;
    enable_interrupts;

      { reset the interrupt vector }
    setintvec(intnum,old_vector);
  end;
end;

  { This procedure is called when the program exits for any reason.  It
    deinstalls the interrupt driver.}
{$F+} procedure exit_procedure; {$F-}
begin
  imp_deinstall;
  exitproc:=exit_save;
end;

  { This installs the exit procedure. }
begin
  exit_save:=exitproc;
  exitproc:=@exit_procedure;
end.

