(*
  ONEEDIT.PAS - The Illusion Utilities; onliner editor
*)

{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V-}

unit oneedit;

INTERFACE

USES crt, dos, myio, windows;

Procedure oneedit1;

IMPLEMENTATION

uses iucommon;

procedure cline(s:string);
begin
  gotoxy(1,14); clreol;
  cwriteat(1,14,#3#13+s);
end;

procedure cl(c:integer);
const dcols:array[0..9] of byte=(15,7,7,15,15,15,112,7,143,7);
begin
  if (c in [0..9]) then begin
    tc(dcols[c]);
  end else case c of
  {k}107:tc(0);
  {b} 98:tc(1);
  {g}103:tc(2);
  {c} 99:tc(3);
  {r}114:tc(4);
  {m}109:tc(5);
  {y}121:tc(6);
  {w}119:tc(7);
  {K} 75:tc(8);
  {B} 66:tc(9);
  {G} 71:tc(10);
  {C} 67:tc(11);
  {R} 82:tc(12);
  {M} 77:tc(13);
  {Y} 89:tc(14);
  {W} 87:tc(15);
  end;
end;

procedure sprompt(s:string);
var i:integer;
    c:char;
    lastc:boolean;
begin
  lastc:=FALSE;
  for i:=1 to length(s) do begin
    c:=s[i];
    if (lastc) then begin
      if (((c>=#0) and (c<=#9)) or (pos(c,'kbgcrmywKBGCRMYW')<>0)) then cl(ord(c)) else
        if ((c>='0') and (c<='9')) then cl(ord(c)-48);
      lastc:=FALSE;
    end else
      case c of
        '|':lastc:=TRUE;
      else
        write(c);
      end;
  end;
end;


PROCEDURE oneedit1;
Type S65=String[65];
     Otype=Array[1..900] of S65;

Var  F:file of S65;
     S:S65;
     O:^Otype;
     i,j,total:integer;
     C:Char;
     Changed:boolean;

BEGIN
  setwindow(2,1,5,80,20,8,0,1); tc(7);

  Assign(f,systat.datapath+'RUMOR.DAT');
  {$I-} reset(f); {$I+}
  if ioresult<>0 then begin
    writeln('1EDIT: Error opening RUMOR.DAT'); pausecount(5);
    removewindow(2); exit;
  end;

  New(O); i:=1;

  cwriteat(1,1 ,#3#13'1EDIT - Illusion Oneliner Editor');
  cwriteat(1,2 ,#3#13'Ch'#3#5'ang'#3#8'es : ');
  cwriteat(1,3 ,#3#8'');

  cwriteat(1,5 ,#3#8'');
  cwriteat(1,8 ,#3#13'] '#3#5'Next          '#3#13'E '#3#5'Edit    '#3#8'');
  cwriteat(1,9 ,#3#13'[ '#3#5'Previous      '#3#13'A '#3#5'Add     '#3#8'');
  cwriteat(1,10,#3#13'G '#3#5'Goto #        '#3#13'D '#3#5'Delete  '#3#8'');
  cwriteat(1,11,#3#13'Q '#3#5'Quit          '#3#13'  '#3#5'        '#3#8'');
  cwriteat(35,9,#3#13'Co'#3#5'mma'#3#8'nd : ');

  cline('Loading file into memory');
  i:=1;
  while ((i<=filesize(f)) and (i<900)) do begin
    seek(f,i-1); read(F,O^[i]); inc(i);
  end;
  total:=filesize(f);
  close(f);
  if i>=900 then begin
    cline('Entire file not loaded');
    sound(500); delay(75); nosound; sound(500); delay(75); nosound;
    delay(2500);
  end else cline('File loaded');
  delay(750); i:=1; Changed:=FALSE;

  repeat
    tc(7); gotoxy(1,4); clreol;
    sprompt(o^[i]);

    cline(cstr(i)+' out of '+cstr(total));
    if changed then begin
      tc(14); gotoxy(11,2); write('');
    end;
    tc(13); gotoxy(45,9);
    repeat until keypressed; while keypressed do c:=upcase(readkey);

    case c of
      ']': inc(i);
      '[': dec(i);
      'G': begin
             infield_out_fgrd:=13; infield_inp_fgrd:=13;
             cwriteat(35,10,#3#13'Go'#3#5'to '#3#8'#? : ');
             tc(13); gotoxy(45,10);
             infield(S,5);
             if (value(s)>=1) and (value(s)<=total) then i:=value(s);
             gotoxy(35,10); clreol;
           end;
      'E': begin
             s:=(o^[i]);
             cline('Editing oneliner #'+cstr(i));
             infield_out_fgrd:=7; infield_inp_fgrd:=7;
             infield1(1,4,s,65);
             o^[i]:=s;
             changed:=TRUE;
           end;
      'A': begin
             inc(total); i:=total;
             s:='';
             cline('Adding oneliner');
             infield_out_fgrd:=7; infield_inp_fgrd:=7;
             infield1(1,5,s,65);
             o^[i]:=s;
             changed:=TRUE;
           end;
      'D': begin
             if i=total then begin
               dec(total); dec(i); j:=i+1;
             end else begin
               for j:=i to (total-1) do o^[j]:=o^[j+1];
               dec(total); j:=i;
             end;
             cline('Deleted #'+cstr(j)); delay(500);
             changed:=TRUE;
           end;
      'Q': clrscr;

    end;

    if i>total then i:=1; if i<1 then i:=total;

  until C='Q';

  if changed then begin
    cline('Saving changes');
    rewrite(f);
    for i:=1 to total do write(f,o^[i]);
    close(f);
  end;
  tc(7); delay(250);
  Dispose(O);
  removewindow(2);
END;

BEGIN
  infield_out_bkgd:=0;
  infield_inp_bkgd:=0;
END.
