(*
 IUCOMMON.PAS - Illusion Utilities, common functions
*)

{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V-}

unit iucommon;

INTERFACE

USES crt, dos, myio, windows,
     onetime, zerouser, namefix, delemail, top;

{$I REC25.PAS}

Var Systat:Systatrec;

procedure tc(i:byte);
function cstr(i:longint):string;
function value(s:string):longint;
function allcaps(s:string):string;
function caps(s:string):string;
function isc(var c:char):boolean;
function stripcolor(o:string):string;
function lenn(s:string):integer;
procedure cursoron(b:boolean);
function mln(s:string; l:byte):string;
function centre(s:string):string;
function tch(s:astr):astr;
function date:astr;

procedure readsystat;
procedure pausecount(b:byte);

procedure startmenu;

IMPLEMENTATION

procedure tc(i:byte);
begin
  textcolor(i);
end;

function cstr(i:longint):string;
var c:string[16];
begin
  str(i,c);
  cstr:=c;
end;

function value(s:string):longint;
var i:longint;
    j:integer;
begin
  val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    val(s,i,j)
  end;
  value:=i;
  if (s='') then value:=0;
end;

function allcaps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allcaps:=s;
end;

function caps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do
    if (s[i] in ['A'..'Z']) then s[i]:=chr(ord(s[i])+32);
  for i:=1 to length(s) do
    if (s[i]=' ') and (s[i+1] in ['a'..'z']) then s[i+1]:=upcase(s[i+1]);
  s[1]:=upcase(s[1]);
  caps:=s;
end;

function isc(var c:char):boolean;
begin
  if (pos(c,#0#1#2#3#4#5#6#7#8#9'1234567890kbgcrmywKBGCRMYW')<>0)
    then isc:=TRUE else isc:=FALSE;
end;

function stripcolor(o:string):string;
var s:string;
    i:integer;
    lc:boolean;
begin
  s:=''; lc:=FALSE;
  for i:=1 to length(o) do
    if (lc) then lc:=FALSE
      else if ((o[i]='|') and (isc(o[i+1]))) then lc:=TRUE else s:=s+o[i];
  stripcolor:=s;
end;

function lenn(s:string):integer;
var i,len:integer;
begin
  len:=length(s); i:=1;
  while (i<=length(s)) do begin
    if (s[i]='|') and isc(s[i+1]) then
      if (i<length(s)) then begin dec(len,2); inc(i); end;
    inc(i);
  end;
  lenn:=len;
end;

procedure cursoron(b:boolean);
var reg:registers;
begin
  with reg do begin
    if (b) then begin ch:=$07; cl:=$08; end else begin ch:=$09; cl:=$00; end;
    ah:=1;
    intr($10,reg);
  end;
end;

function mln(s:string; l:byte):string;
begin
  while (lenn(s)<l) do s:=s+' ';
  if (lenn(s)>l) then
    repeat s:=copy(s,1,length(s)-1) until (lenn(s)=l) or (length(s)=0);
  mln:=s;
end;

function centre(s:string):string;
var i,j:integer;
begin
  i:=length(s); j:=1;
  while (j<=length(s)) do begin
    if (s[j]='|') and (isc(s[j+1])) then begin
      dec(i,2);
      inc(j);
    end;
    inc(j);
  end;
  if i<79 then
    s:=copy('                                               ',1,
      (79-i) div 2)+s;
  centre:=s;
end;

function tch(s:astr):astr;
begin
  if (length(s)>2) then s:=copy(s,length(s)-1,2) else
    if (length(s)=1) then s:='0'+s;
  tch:=s;
end;

function date:astr;
var r:registers;
    y,m,d:string[3];
    yy,mm,dd,dow:word;
begin
  getdate(yy,mm,dd,dow);
  str(yy-1900,y); str(mm,m); str(dd,d);
  date:=tch(m)+'/'+tch(d)+'/'+tch(y);
end;

procedure readsystat;
var systatf:file of systatrec;
    s:astr;
begin
  s:=getenv('IBBS');
  if s='' then s:='ILLUSION.CFG' else s:=s+'\ILLUSION.CFG';
  assign(systatf,s);
  {$I-} reset(systatf); {$I+}
  if (ioresult<>0) then begin
    writeln('Error opening ILLUSION.CFG'); halt(0);
  end else begin
    read(systatf,systat); close(systatf);
  end;
end;

procedure pausecount(b:byte);
var i,x:byte; c:char;
begin
  write('Pausing ['); x:=wherex; i:=b;
  while (i>0) and (not keypressed) do begin
    gotoxy(x,wherey); cwrite(#3#3+cstr(i)+#3#7']');
    delay(1000); dec(i);
  end;
  while keypressed do c:=readkey;
end;

{-----------------------}
procedure pauseit;
var c:char; x,y:byte;
begin
  x:=wherex; y:=wherey;
  write('Hit a key to continue.');
  repeat until keypressed;
  while keypressed do c:=readkey;
  gotoxy(x,y);
  write('                      '); gotoxy(x,y);
end;

Procedure paramhelp;
begin
  clrscr;
  writeln('IU command line parameter help -');
  writeln;
  writeln('Syntax: IU [parameters]');
  writeln;
  writeln('Options:');
  writeln('  -B : Write to BIOS instead of direct screen writes.');
  writeln;
  writeln('  Options must have a "-" or "/" preceding them.');
  writeln;
  writeln('Functions:');
  writeln('  ONETIME             : One time caller deletor');
  writeln('  ZEROUSER            : Deleted user purger');
  writeln('  NAMEFIX             : User index rebuilder');
  writeln('  DELEMAIL            : Orphan mail deletor');
  writeln('  TOP                 : Top user bulletin creator');
  writeln('  ? | HELP            : This help screen');
  writeln('  MAINT               : Nightly maint.');
  writeln;
  writeln('    Combines Onetime, Zerouser, Namefix, Delemail, & Top');
  writeln;
  writeln('Functions and options may be in any order.');
  writeln('Starting IU without any functions loads the menu.');
  writeln;
  pauseit;
end;

procedure doit(c:byte);
begin
  textbackground(0); tc(7);
  case c of
    1: onetime1;
    2: zerouser1;
    3: namefix1;
    4: delemail1;
    5: top1;
    6: paramhelp;
  end;
end;

function doparams:boolean;
var ss:string; a,i:integer;
    optionerror,didit:boolean;
    things:array[1..6] of boolean;
begin
  writeln('Illusion Utilities  Version '+ver+'  by Kyle Oppenheim and Billy Ma');
  writeln;
  writeln('Parsing command line ...');

  doparams:=FALSE; optionerror:=FALSE; didit:=FALSE;
  for a:=1 to sizeof(things) do things[a]:=FALSE;

  a:=0;
  while (a<paramcount) do begin
    inc(a);
    ss:=allcaps(paramstr(a));
    if (ss[1]='-') or (ss[1]='/') then begin
      case ss[2] of
        'B':begin
              directvideo:=FALSE;
              writeln('  * Direct screen writes off');
            end;
        else begin
          writeln('  * INVALID OPTION "'+ss[1]+ss[2]+'"');
          optionerror:=TRUE;
        end;
      end; {case}
    end else begin
      if ss='ONETIME'  then things[1]:=TRUE else
      if ss='ZEROUSER' then things[2]:=TRUE else
      if ss='NAMEFIX'  then things[3]:=TRUE else
      if ss='DELEMAIL' then things[4]:=TRUE else
      if ss='TOP'      then things[5]:=TRUE else
      if ss='MAINT' then begin
        for i:=1 to sizeof(things) do if i in [1,2,3,4,5] then things[i]:=TRUE;
      end else
      if (ss='?') or (ss='HELP') then things[6]:=TRUE
      else begin
        writeln('  * INVALID FUNTION "'+ss+'"');
        optionerror:=TRUE;
      end;
    end;
  end; {while}

  if optionerror then begin
    writeln;
    writeln('An invalid option or function was specified on the command line.');
    writeln('IU will load the normally.  If you need more help, select the');
    writeln('"Command Line Parameters" option.');
    pauseit;
    exit;
  end;

  writeln('Executing utilities.');
  for a:=1 to sizeof(things) do if things[a] then begin doit(a); didit:=TRUE; end;
  if didit then begin
    doparams:=TRUE;
  end else begin
    delay(1000);
  end;

end;

Procedure startmenu;
const ch:byte=1;
      startline:byte=8;
      startcol:byte=27;

     items:array[1..7] of string[25]=(
      'One time caller deletor',
      'Deleted user purger',
      'User index rebuilder',
      'Orphan mail deletor',
      'Top user bulletin',
      'Command line parameters',
      'Quit');

Var i,numitems,c:byte;

Procedure redraw;
var i,j:integer;
begin
  textbackground(0); tc(7); clrscr;
  gotoxy(startcol,startline-3);
  cwrite(#3#15''+#3#7+''+#3#8+'        Ŀ');
  gotoxy(startcol,startline-2);
  cwrite(#3#7+'    Illusion  Utilities    '+#3#7+'');
  gotoxy(startcol,startline-1);
  cwrite(#3#8+'        '+#3#7+''+#3#15+'');
end;

begin
  numitems:=sizeof(items) div 26;

  if (paramstr(1)<>'') then begin
    if doparams then exit;
  end;

  redraw;

  repeat
    cursoron(FALSE);
    for i:=1 to numitems do begin
      gotoxy(startcol,startline+i);
      if ((ch=i) and (i<numitems)) then
        cwrite(#2#0+#3#15+'   '+#2#7+#3#0+' '+mln(items[i],25)+#2#0)
      else if (i<numitems) then
        cwrite(#2#0+#3#15+'    '+mln(copy(items[i],1,5)+#3#7+copy(items[i],6,9)+
               #3#8+copy(items[i],15,length(items[i])-14),29))
      else if ch=i then
        cwrite(#2#0#3#15+'Q. '+#2#7#3#0+mln(' Quit',25)+#2#0)
      else
        cwrite(#2#0#3#15+'Q.  '+mln('Quit',25));
    end;

    gotoxy(startcol,startline+numitems+1);
    cwrite(#3#8''+#3#7+''+#3#15+''+#3#7+''+#3#8+'');

    c:=ord(upcase(readkey));
    case c of
      0 :begin
           c:=ord(readkey);
           case c of
             72:begin dec(ch); if ch<1 then ch:=numitems; end;
             80:begin inc(ch); if ch>numitems then ch:=1; end;
           end;
           c:=0;
         end;
      13:c:=ch;
      81:c:=numitems;
    end; { case }

    cursoron(TRUE);

    if (c<>0) and (c<numitems) then begin
      textbackground(0); tc(7);
      doit(c);
      textbackground(0); tc(7); redraw;
    end;

  until c=numitems;
end;

end.
