(*
  FSORT.PAS - The Illusion Utilities; File base sorter
*)

{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V-}

unit fsort;

INTERFACE

USES crt, dos, myio, windows;

procedure fsort1(c1,c2:char);

IMPLEMENTATION

uses iucommon;

const
    badfpath:boolean=FALSE;       { is the current DL path BAD?           }
    badufpath:boolean=FALSE;
var totfils,totbases:longint;
    bubblesortend:integer;
    sortt:char;
    isascend:boolean;
    ulff:file of ulfrec;
    ulf:file of ulrec;
    memuboard:ulrec;
    fileboard:integer;

procedure switch(a,b:integer);
var f1,f2:ulfrec;
begin
  seek(ulff,a); read(ulff,f1);
  seek(ulff,b); read(ulff,f2); seek(ulff,b); write(ulff,f1);
  seek(ulff,a); write(ulff,f2);
end;

function greater(islesser,isequ:boolean; r1,r2:integer):boolean;
var f1,f2:ulfrec;
    b,c:boolean;

  procedure figure1;
  begin
    case sortt of
      'B':if (isequ) then b:=(f1.description<=f2.description)
                     else b:=(f1.description<f2.description);
      'D':if (isequ) then b:=(f1.daten<=f2.daten)
                     else b:=(f1.daten<f2.daten);
      'E':if (isequ) then b:=(copy(f1.filename,10,3)<=copy(f2.filename,10,3))
                     else b:=(copy(f1.filename,10,3)<copy(f2.filename,10,3));
      'F':if (isequ) then b:=(f1.filepoints<=f2.filepoints)
                     else b:=(f1.filepoints<f2.filepoints);
      'N':if (isequ) then b:=(f1.filename<=f2.filename)
                     else b:=(f1.filename<f2.filename);
      'O':if (isequ) then b:=(f1.owner<=f2.owner)
                     else b:=(f1.owner<f2.owner);
      'S':if (isequ) then b:=(f1.blocks<=f2.blocks)
                     else b:=(f1.blocks<f2.blocks);
      'T':if (isequ) then b:=(f1.nacc<=f2.nacc)
                     else b:=(f1.nacc<f2.nacc);
    end;
  end;

  procedure figure2;
  begin
    case sortt of
      'B':if (isequ) then b:=(f1.description>=f2.description)
                     else b:=(f1.description>f2.description);
      'D':if (isequ) then b:=(f1.daten>=f2.daten)
                     else b:=(f1.daten>f2.daten);
      'E':if (isequ) then b:=(copy(f1.filename,10,3)>=copy(f2.filename,10,3))
                     else b:=(copy(f1.filename,10,3)>copy(f2.filename,10,3));
      'F':if (isequ) then b:=(f1.filepoints>=f2.filepoints)
                     else b:=(f1.filepoints>f2.filepoints);
      'N':if (isequ) then b:=(f1.filename>=f2.filename)
                     else b:=(f1.filename>f2.filename);
      'O':if (isequ) then b:=(f1.owner>=f2.owner)
                     else b:=(f1.owner>f2.owner);
      'S':if (isequ) then b:=(f1.blocks>=f2.blocks)
                     else b:=(f1.blocks>f2.blocks);
      'T':if (isequ) then b:=(f1.nacc>=f2.nacc)
                     else b:=(f1.nacc>f2.nacc);
    end;
  end;

begin
  if (r1<r2) then begin
    seek(ulff,r1); read(ulff,f1);
    seek(ulff,r2); read(ulff,f2);
  end else begin
    seek(ulff,r2); read(ulff,f2);
    seek(ulff,r1); read(ulff,f1);
  end;

  if (isascend) then islesser:=not islesser;
  if (islesser) then figure1 else figure2;
  greater:=b;
end;

procedure mainsort(pl:integer);
label 10,20,30,40,50,60,70,80;
const maxsortrec=2000;   (* maximum size of directory which can be processed *)
var hold,pass:array[1..maxsortrec] of integer;
    a,b,c,d,e,f,x:integer;
begin
  a:=pl; b:=0; c:=0; d:=1; e:=1; f:=0;
10:
  if (a-e<9) then goto 70;
  b:=e; c:=a;
20:
  if (greater(TRUE,FALSE,b,c)) then begin
    switch(c,b);
    goto 60;
  end;
30:
  dec(c);
  if (c>b) then goto 20;
  inc(c);
40:
  inc(d);
  if (b-e<a-c) then begin
    hold[d]:=c; pass[d]:=a;
    a:=b;
    goto 10;
  end;
  hold[d]:=e; pass[d]:=b;
  e:=c;
  goto 10;
50:
  if (greater(FALSE,FALSE,c,b)) then begin
    switch(c,b);
    goto 30;
  end;
60:
  inc(b);
  if (c>b) then goto 50;
  inc(c);
  goto 40;
70:
  if (a-e+1=1) then goto 80;
  for b:=e+1 to a do
    for c:=e to (b-1) do begin
      f:=b-c+e-1;
      if (greater(TRUE,FALSE,f,f+1)) then begin
        x:=f+1;
        switch(f,x);
      end;
    end;
80:
  e:=hold[d]; a:=pass[d];
  dec(d);
  if (d=0) then exit;
  goto 10;
end;

procedure flipit(pl:integer);
var i:integer;
begin
  for i:=1 to pl div 2 do switch(i,(pl-i)+1);
end;

procedure bubblesort(pl:integer);
var f1,f2:ulfrec;
    i,j,numdone:integer;
    foundit:boolean;
begin
  if (bubblesortend>pl) then bubblesortend:=pl;  { should never happen, but...}
  numdone:=0;
  repeat
    i:=(bubblesortend+1)-numdone;
    foundit:=FALSE;
    while ((i<=pl) and (not foundit)) do
      if (greater(FALSE,TRUE,1,i)) then foundit:=TRUE else inc(i);

    seek(ulff,1); read(ulff,f1);

    for j:=1 to i-2 do begin
      seek(ulff,j+1); read(ulff,f2);
      seek(ulff,j); write(ulff,f2);
    end;

    seek(ulff,i-1); write(ulff,f1);
    inc(numdone);
  until ((numdone>=bubblesortend));

end;

function analysis(pl:integer):integer;
var i,j:integer;
    c1,c2:boolean;
begin
  analysis:=1;
  c1:=TRUE; c2:=TRUE;
  for i:=1 to pl-1 do begin
    if (not greater(TRUE,TRUE,i,i+1)) then c1:=FALSE;    { a }
    if (not greater(FALSE,TRUE,i,i+1)) then c2:=FALSE;   { d }
  end;
  if (c1) then analysis:=2;     { list is backwards, so flip it }
  if (c2) then analysis:=0;     { list is already sorted }
  if ((not c1) and (not c2)) then begin
    c1:=FALSE; j:=0;
    i:=pl-1;
    while ((i>=1) and (not c1)) do begin
      if (not greater(FALSE,TRUE,i,i+1)) then begin c1:=TRUE; j:=i; end;
      dec(i);
    end;
    if ((c1) and (j/pl<0.15)) then begin
      analysis:=3;
      bubblesortend:=j;
    end;
  end;
end;

procedure loaduboard(i:integer);
begin
    if ((i>=0) and (i<=filesize(ulf)-1)) then begin
      seek(ulf,i);
      read(ulf,memuboard);
  end;
end;

procedure changefileboard(b:integer);
begin
 loaduboard(b);
end;

procedure fiscan(var pl:integer); { loads in memuboard ... }
var f:ulfrec;
    dirinfo:searchrec;
    s:astr;
begin
  s:=memuboard.dlpath; s:=copy(s,1,length(s)-1);
  if ((length(s)=2) and (s[2]=':')) then badfpath:=FALSE
  else begin
    findfirst(s,dos.directory,dirinfo);
    badfpath:=(doserror<>0);
  end;

  s:=memuboard.ulpath; s:=copy(s,1,length(s)-1);
  if ((length(s)=2) and (s[2]=':')) then badufpath:=FALSE
  else begin
    findfirst(s,dos.directory,dirinfo);
    badufpath:=(doserror<>0);
  end;

  loaduboard(fileboard);
  if (fbdirdlpath in memuboard.fbstat) then
    assign(ulff,memuboard.dlpath+memuboard.filename+'.DIR')
  else
    assign(ulff,systat.datapath+memuboard.filename+'.DIR');
  {$I-} reset(ulff); {$I+}
  if (ioresult<>0) then begin
    rewrite(ulff);
    f.blocks:=0;
    write(ulff,f);
  end;
  seek(ulff,0); read(ulff,f);
  pl:=f.blocks;
end;

procedure sortfiles(b:integer);
var s:string;
    pl,sortt:integer;
begin
  changefileboard(b);
  fileboard:=b;
  fiscan(pl);
  seek(ulff,pl+1); truncate(ulff);
  cwrite('Sorting '#3#3+stripcolor(memuboard.name));
  sortt:=analysis(pl);
  case sortt of 0:s:=' '; 1,2,3:s:=' *'; end;
  cwrite(#3#11+s+#3#7); writeln;
  case sortt of
    0:;
    1:mainsort(pl);
    2:flipit(pl);
    3:bubblesort(pl);
  end;
  close(ulff);
  inc(totbases); inc(totfils,pl);
end;

{---------}

procedure fsort1(c1,c2:char);
var f:ulfrec;
    sortstart,sortend,tooktime:datetimerec;
    i:integer;
    c:char;
    d:string;
    global,abort,next,savepause:boolean;
begin
  setwindow(2,1,5,80,8,8,0,1); tc(7);

  sortt:=upcase(c1);
  c:=upcase(c2);

  case c of
    'A':isascend:=TRUE;
    'D':isascend:=FALSE;
  end;

  if ((sortt='') or ((c<>'A') and (c<>'D'))) then begin
    writeln('FSORT: Invalid Parameters'); pausecount(5);
    removewindow(2); exit;
  end;

  assign(ulf,systat.datapath+'FBOARDS.DAT');
  {$I-} reset(ulf); {$I+}
  if ioresult<>0 then begin
    writeln('FSORT: Error opening FBOARDS.DAT'); pausecount(5);
    removewindow(2); exit;
  end;

  cwrite('FSORT: Sorting file bases - Sort type: '+#3#3+sortt+#3#7+' Order: '+#3#3+c+#3#7);
  writeln;
  setwindow(3,1,9,80,20,8,0,1); tc(7);

  totfils:=0; totbases:=0;

  i:=0;
  while (i<=filesize(ulf)-1) do begin
    sortfiles(i);
    inc(i);
  end;
  close(ulf);
  pausecount(4); removewindow(3); removewindow(2);
end;

END.
