(*
  DELEMAIL.PAS - The Illusion Utilities, Orphan mail deletor
*)

{$A+,B-,D-,E-,F+,I+,L-,N-,O-,R-,S-,V-}

unit delemail;

INTERFACE

USES crt, dos, myio, windows;

Procedure delemail1;

IMPLEMENTATION

uses iucommon;

var mixf           :file;
    brdf           :file;
    mintabloaded   :word;
    mintaboffset   :longint;
    mintab         :array[0..99] of msgindexrec;
    himsg          :longint;
    himintab       :longint;
    sf             :file of smalrec;

procedure findhimsg;
var mixr:msgindexrec;
    lng:longint;
    numread:word;
begin
  himintab:=(filesize(mixf)-1) div 100;
  himsg:=himintab*100-1;
  seek(mixf,himsg+1);
  repeat
    lng:=himsg;
    blockread(mixf,mixr,1,numread);
    if ((numread=1) and (mixr.hdrptr<>-1)) then inc(himsg);
  until (lng=himsg);
end;

procedure loadmintab(x:word);
var lng:longint;
    numread:word;
    i,j:integer;
begin
  lng:=x*100;   (* stupid *#@$(@($#*($ TP typecasting... *)
  while ((lng>=filesize(mixf)) and (x>0)) do begin
    dec(x);
    lng:=x*100;
  end;

  mintaboffset:=x*100;
  seek(mixf,mintaboffset);
  blockread(mixf,mintab,100,numread);
  if (numread<>100) then begin
    for i:=numread to 99 do begin
      mintab[i].messagenum:=0;
      mintab[i].hdrptr:=-1;
      mintab[i].msgid:=0;
      mintab[i].isreplytoid:=0;
      for j:=1 to 6 do mintab[i].msgdate[i]:=0;
      mintab[i].msgdowk:=0;
      mintab[i].msgindexstat:=[];
      mintab[i].isreplyto:=65535;
      mintab[i].numreplys:=0;
    end;
    seek(mixf,mintaboffset);
    blockwrite(mixf,mintab,100);  { fill remainder with garbage .. }
  end;
  mintabloaded:=x;
end;

procedure initbrd;
var mixr:msgindexrec;
    fn:string;
    lng:longint;
    numread:word;
    i,j:integer;
begin
  fn:='EMAIL';
  assign(mixf,systat.msgpath+fn+'.MIX');
  {$I-} reset(mixf,sizeof(mixr)); {$I+}
  if (ioresult<>0) then begin
    rewrite(mixf,sizeof(mixr));
    for i:=0 to 99 do begin
      mintab[i].messagenum:=0;
      mintab[i].hdrptr:=-1;
      mintab[i].msgid:=0;
      mintab[i].isreplytoid:=0;
      for j:=1 to 6 do mintab[i].msgdate[i]:=0;
      mintab[i].msgdowk:=0;
      mintab[i].msgindexstat:=[];
      mintab[i].isreplyto:=65535;
      mintab[i].numreplys:=0;
    end;
    blockwrite(mixf,mintab[0],100);
  end;

  assign(brdf,systat.msgpath+fn+'.BRD');
  {$I-} reset(brdf,1); {$I+}
  if (ioresult<>0) then rewrite(brdf,1);

  findhimsg;
  loadmintab(himintab);
end;

function getmixnum(x:word):word;
begin
  getmixnum:=x mod 100;
end;

function getmintab(x:word):word;
begin
  getmintab:=x div 100;
end;

procedure savemix(mixr:msgindexrec; x:word);
begin
  loadmintab(getmintab(x));
  seek(mixf,mintaboffset+getmixnum(x));
  blockwrite(mixf,mixr,1);
  loadmintab(getmintab(x));
end;

procedure ensureloaded(x:word);
var i:word;
begin
  i:=getmintab(x);
  if (i<>mintabloaded) then loadmintab(i);
end;

procedure loadmhead1(var brdf:file; x:word; var mhead:mheaderrec);
begin
  blockread(brdf,mhead,sizeof(mheaderrec));
end;

procedure savemhead1(var brdf:file; mhead:mheaderrec);
begin
  blockwrite(brdf,mhead,sizeof(mheaderrec));
end;

procedure savemhead(mhead:mheaderrec);
begin
  savemhead1(brdf,mhead);
end;

procedure loadmhead(x:word; var mhead:mheaderrec);
begin
  ensureloaded(x);
  seek(brdf,mintab[getmixnum(x)].hdrptr);
  loadmhead1(brdf,x,mhead);
end;

{----------}

procedure delemail1;
var i,howmany:longint;
    mixr :msgindexrec;
    mhead:mheaderrec;
    sr   :smalrec;
    t    :integer;
    delit,foundto:boolean;
    too  :string[36];

begin
  setwindow(2,1,5,80,8,8,0,1); tc(7);

  assign(sf,systat.datapath+'USERS.IDX');
  {$I-} reset(sf); {$I+}
  if (ioresult<>0) then begin
    writeln('DELEMAIL: Error opening USERS.IDX'); pausecount(5);
    removewindow(2); exit;
  end;

  initbrd; howmany:=0;
  cwrite('DELEMAIL: '+#3#3+cstr(himsg+1)+#3#7' piece(s) of mail found.');
  setwindow(3,1,9,80,20,8,0,1); tc(7);

  cwrite(#3#23+'Working'#3#7);

  for i:=0 to himsg do begin
    ensureloaded(i);
    mixr:=mintab[getmixnum(i)];

    if not(mideleted in mixr.msgindexstat) then begin

    loadmhead(i,mhead);
    ensureloaded(i);

    with mhead do begin

      too:=toi.alias; foundto:=FALSE;
      delit:=TRUE; t:=1;
      while ((t<=filesize(sf)-1) and ((delit) or (not foundto)) ) do begin
        seek(sf,t); read(sf,sr);
        if (too=sr.name) then foundto:=TRUE;
        if (fromi.alias=sr.name) then delit:=FALSE;
        inc(t);
      end; {while}

      if ((delit) or (not foundto)) then begin
        inc(howmany);
        gotoxy(1,wherey);
        writeln('* Deleting #'+cstr(i+1)+' - From: '+fromi.alias+'  To: '+toi.alias);
        include(mixr.msgindexstat,mideleted);
        savemix(mixr,i);
        cwrite(#3#23+'Working'#3#7);
      end; {if delit}

    end; {with}

    end; {if not deleted}

  end; {for i}

  close(brdf); close(mixf); close(sf);
  gotoxy(1,wherey); clreol;
  cwrite('DELEMAIL: Deleted '#3#3+cstr(howmany)+#3#7' piece(s) of mail.'); writeln;
  pausecount(4); removewindow(3); removewindow(2);

end;

END.