{$A+,B+,D-,L-,F+,I+,N-,E-,S+,V-}
{$M 50000,0,4000}

USES
 crt, dos;
{$I REC25 }

VAR
    systat:systatrec;
    Exitsave       :Pointer;



procedure tc(i:byte);
begin
  textcolor(i);
end;

function exist(fn:string):boolean;
var srec:searchrec;
begin
  findfirst(fn,anyfile,srec);
  exist:=(doserror=0);
end;

function cstr(i:longint):string;
var c:string[16];
begin
  str(i,c);
  cstr:=c;
end;

Procedure errorhandle;
begin
  exitproc:=exitsave;
  if (erroraddr<>nil) then begin
    writeln;
    tc(12); Writeln('Critical error!  (#'+cstr(exitcode)+')');
    Writeln('191to192 halted with errorlevel 1.');
    halt(1);
  end;
end;

procedure ferror(s:string);
begin
  writeln; tc(28);
  writeln('Error: Can''t open '+s);
  halt(1);
end;

procedure readsystat;
var systatff:file of systatrec;
begin
  assign(systatff,'ILLUSION.CFG');
  {$I-} reset(systatff); {$I+}
  if (ioresult<>0) then begin
    ferror('ILLUSION.CFG');
  end else begin
    read(systatff,systat);
  end;
  close(systatff);
end;

{ ------- COLOR CONVERSION ------- }

Function newcolor(s:string):string;
Var i:integer;
    n:string;
    nc:boolean;

function ccolor(c:char):char;
begin
  if ord(c)>=48 then c:=chr(ord(c)-48);
  case c of
    #1,'1':c:='w';
    #2,'2':c:='b';
    #3,'3':c:='C';
    #4,'4':c:='B';
    #5,'5':c:='Y';
    #6,'6':c:='W';
    #7,'7':c:='R';
    #8,'8':c:='R';
    #9,'9':c:='K';
    #0,'0':c:='W';
  end;
  ccolor:=c;
end;

Begin
  n:=''; nc:=FALSE;
  For i:=1 to length(s) do begin

    if nc then begin
      nc:=FALSE;
      if s[i] in [#0..#9,'0'..'9'] then
        n:=n+'|'+ccolor(s[i])
      else
        n:=n+'|'+s[i];

    end else

    if (s[i]='|') then nc:=TRUE
    else n:=n+s[i];

  end;
  newcolor:=n;
end;

(*****)
(*****)

Procedure string_dat;
var fstring:fstringrec;
    sf:file of fstringrec;
begin
  assign(sf,systat.datapath+'STRINGS.DAT');
  reset(sf); read(sf,fstring);
  with fstring do begin

    ansidetect  :=newcolor(ansidetect);
    note[1]     :=newcolor(note[1]);
    note[2]     :=newcolor(note[2]);
    lprompt     :=newcolor(lprompt);
    matrixpw    :=newcolor(matrixpw);
    userpw      :=newcolor(userpw);
    userphone   :=newcolor(userphone);
    sysoppw     :=newcolor(sysoppw);
    echoc       :=echoc;
    namenotfound:=newcolor(namenotfound);
    lockpwprompt:=newcolor(lockpwprompt);

    sysopin     :=newcolor(sysopin);
    sysopout    :=newcolor(sysopout);
    wait        :=newcolor(wait);
    shelldos1   :=newcolor(shelldos1);
    shelldos2   :=newcolor(shelldos2);
    pause       :=newcolor(pause);
    welcome     :=newcolor(welcome);
    mmchat      :=newcolor(mmchat);
    thanxvote   :=newcolor(thanxvote);
    sendmail    :=newcolor(sendmail);
    sendsmsg    :=newcolor(sendsmsg);

    entermsg1   :=newcolor(entermsg1);
    entermsg2   :=newcolor(entermsg2);
    newscanstart:=newcolor(newscanstart);
    newscanend  :=newcolor(newscanend);
    newscan1    :=newcolor(newscan1);
    newscan2    :=newcolor(newscan2);
    scanmessage :=newcolor(scanmessage);
    msgscan     :=newcolor(msgscan);
    automsgt    :=newcolor(automsgt);
    ichar       :=ichar;
    mailread    :=newcolor(mailread);
    msgdeleted  :=newcolor(msgdeleted);
    msgunvalidated:=newcolor(msgunvalidated);

    listline    :=newcolor(listline);
    newline     :=newcolor(newline);
    searchline  :=newcolor(searchline);
    findline1   :=newcolor(findline1);
    findline2   :=newcolor(findline2);
    downloadline:=newcolor(downloadline);
    uploadline  :=newcolor(uploadline);
    viewline    :=newcolor(viewline);
    nofilepts   :=newcolor(nofilepts);
    unbalance   :=newcolor(unbalance);
    nqinfo      :=newcolor(nqinfo);
    noffound    :=newcolor(noffound);

    pninfo      :=newcolor(pninfo);
    gfnline1    :=newcolor(gfnline1);
    gfnline2    :=newcolor(gfnline2);
    batchadd    :=newcolor(batchadd);
    protline    :=newcolor(protline);
    bprotline   :=newcolor(bprotline);
    chatcall1   :=newcolor(chatcall1);
    chatcall2   :=newcolor(chatcall2);
    engage      :=newcolor(engage);
    endchat     :=newcolor(endchat);
    quoteline1  :=newcolor(quoteline1);
    quoteline2  :=newcolor(quoteline2);
    batchndl    :=newcolor(batchndl);

    genchatline :=newcolor(genchatline);
    genchat[1]  :=newcolor(genchat[1]);
    genchat[2]  :=newcolor(genchat[2]);
    genchat[3]  :=newcolor(genchat[3]);
    genchat[4]  :=newcolor(genchat[4]);
    genchat[5]  :=newcolor(genchat[5]);
    genchat[6]  :=newcolor(genchat[6]);
    genchat[7]  :=newcolor(genchat[7]);
    genchat[8]  :=newcolor(genchat[8]);
    genchat[9]  :=newcolor(genchat[9]);

    whychat     :=newcolor(whychat);
    genchatprompt:=newcolor(genchatprompt);
    chatoverride :=newcolor(chatoverride);
    banktitle    :=newcolor(banktitle);
    bankdeposit  :=newcolor(bankdeposit);
    unused1      :=newcolor(unused1);
    bankquit     :=newcolor(bankquit);
    bankwithdraw :=newcolor(bankwithdraw);
    bankcannotwithdraw:=newcolor(bankcannotwithdraw);
    bankcannotaddtoday:=newcolor(bankcannotaddtoday);
    bankcannotadd:=newcolor(bankcannotadd);
    bankprompt   :=newcolor(bankprompt);
    bankwithdrawprompt:=newcolor(bankwithdrawprompt);

    votechoice     :=newcolor(votechoice);
    questionchoice :=newcolor(questionchoice);
    mandatoryvoting:=newcolor(mandatoryvoting);

    scanningusers  :=newcolor(scanningusers);
    voted1         :=newcolor(voted1);
    voted2         :=newcolor(voted2);
    nuvprompt      :=newcolor(nuvprompt);

    {spinchars}

    macroprompt    :=newcolor(macroprompt);
    skipusers      :=newcolor(skipusers);
    unknown        :=newcolor(unknown);
    coloryes       :=newcolor(coloryes);
    colorno        :=newcolor(colorno);
    ttyyes         :=newcolor(ttyyes);
    ttyno          :=newcolor(ttyno);
    coloryesdone   :=newcolor(coloryesdone);
    colornodone    :=newcolor(colornodone);
    ttyyesdone     :=newcolor(ttyyesdone);
    ttynodone      :=newcolor(ttynodone);

    avatardetect   :=newcolor(avatardetect);

    caddress       :=newcolor(caddress);
    cbday          :=newcolor(cbday);
    ccity          :=newcolor(ccity);
    cstate         :=newcolor(cstate);
    ccountry       :=newcolor(ccountry);
    ctoolong       :=newcolor(ctoolong);
    ccomputer      :=newcolor(ccomputer);
    coccupation    :=newcolor(coccupation);
    chandle        :=newcolor(chandle);
    cnohandle      :=newcolor(cnohandle);
    cchecking      :=newcolor(cchecking);
    cdupfound      :=newcolor(cdupfound);
    cnonefound     :=newcolor(cnonefound);
    cphone         :=newcolor(cphone);
    cpassword      :=newcolor(cpassword);
    crealname      :=newcolor(crealname);
    cnotcorrect    :=newcolor(cnotcorrect);
    cgender        :=newcolor(cgender);
    creference     :=newcolor(creference);
    czipcode       :=newcolor(czipcode);
    cusernote      :=newcolor(cusernote);

    quotetitle     :=newcolor(quotetitle);
    notreply       :=newcolor(notreply);
    fnewscan       :=newcolor(fnewscan);
    qfromprompt    :=newcolor(qfromprompt);
    qtoprompt      :=newcolor(qtoprompt);
    chmsgbase      :=newcolor(chmsgbase);

    msgdefaults    :=newcolor(msgdefaults);
    invaliduser    :=newcolor(invaliduser);
    nodiskspace    :=newcolor(nodiskspace);
    uploadprepared :=newcolor(uploadprepared);
    abbyname       :=newcolor(abbyname);
    problemname    :=newcolor(problemname);
    mailboxfull    :=newcolor(mailboxfull);
    mailboxclosed  :=newcolor(mailboxclosed);
    mailyourself   :=newcolor(mailyourself);
    cannotsendmail :=newcolor(cannotsendmail);
    toomuchmail    :=newcolor(toomuchmail);
    toomuchfb      :=newcolor(toomuchfb);
    userdeleted    :=newcolor(userdeleted);

    quotecomplete  :=newcolor(quotecomplete);
    editcommand    :=newcolor(editcommand);
    newuserpw      :=newcolor(newuserpw);
    newmodprompt   :=newcolor(newmodprompt);
    savingaccount  :=newcolor(savingaccount);
    savingacdone   :=newcolor(savingacdone);
    nuvnousers     :=newcolor(nuvnousers);
    nuventercomment:=newcolor(nuventercomment);
    nuvrecorded    :=newcolor(nuvrecorded);

    pagelen        :=newcolor(pagelen);
    linelen        :=newcolor(linelen);

    asklotto       :=newcolor(asklotto);
    askbet         :=newcolor(askbet);
    notime         :=newcolor(notime);
    nocredit       :=newcolor(nocredit);
    subtime        :=newcolor(subtime);
    subcredits     :=newcolor(subcredits);
    asknumbers     :=newcolor(asknumbers);
    numdrawn       :=newcolor(numdrawn);
    nowin          :=newcolor(nowin);
    wintime        :=newcolor(wintime);
    wincredits     :=newcolor(wincredits);

    deductfp       :=newcolor(deductfp);
    thanxul        :=newcolor(thanxul);
    creditval      :=newcolor(creditval);
    pointsval      :=newcolor(pointsval);
    fileoffline    :=newcolor(fileoffline);
    cantresume     :=newcolor(cantresume);
    cantval        :=newcolor(cantval);
    canttime       :=newcolor(canttime);
    cantoffline    :=newcolor(cantoffline);
    dlnotgood      :=newcolor(dlnotgood);
    forsysop       :=newcolor(forsysop);
    enterdesc      :=newcolor(enterdesc);
    lookfdupe      :=newcolor(lookfdupe);
    nofdupes       :=newcolor(nofdupes);
    illegalfn      :=newcolor(illegalfn);

    nuvvalidate    :=newcolor(nuvvalidate);
    nuvdelete      :=newcolor(nuvdelete);
    nuvrecdel      :=newcolor(nuvrecdel);
    nuvaskcom      :=newcolor(nuvaskcom);
    nuvdispcom     :=newcolor(nuvdispcom);
    pcrhelp        :=newcolor(pcrhelp);

    bchempty       :=newcolor(bchempty);
    bchdl          :=newcolor(bchdl);
    bchnotime      :=newcolor(bchnotime);
    bchnofp        :=newcolor(bchnofp);
    bchremove      :=newcolor(bchremove);
    bchhangup      :=newcolor(bchhangup);
    chfilebase     :=newcolor(chfilebase);
    bchtl          :=newcolor(bchtl);
    bchfull        :=newcolor(bchfull);

    qnone          :=newcolor(qnone);
    qnew           :=newcolor(qnew);
    qcomp          :=newcolor(qcomp);
    qerror         :=newcolor(qerror);
    qpacket        :=newcolor(qpacket);
    qupdate        :=newcolor(qupdate);

    radd           :=newcolor(radd);
    rdrop          :=newcolor(rdrop);
    rfileon        :=newcolor(rfileon);
    rfileoff       :=newcolor(rfileoff);
    rinv[1]        :=newcolor(rinv[1]);
    rinv[2]        :=newcolor(rinv[2]);
    rtoss          :=newcolor(rtoss);
    rerror         :=newcolor(rerror);
    rerrorh        :=newcolor(rerrorh);
    rexist         :=newcolor(rexist);
    reof           :=newcolor(reof);
    rdecomp        :=newcolor(rdecomp);
    rhangup        :=newcolor(rhangup);

    alreadyhere    :=newcolor(alreadyhere);
    arenew         :=newcolor(arenew);
    isvalidated    :=newcolor(isvalidated);
    mpwis          :=newcolor(mpwis);
    logonnow       :=newcolor(logonnow);
    notvalidated   :=newcolor(notvalidated);
    nuvvoting      :=newcolor(nuvvoting);
    cannotnew      :=newcolor(cannotnew);
    nolongerworks  :=newcolor(nolongerworks);
    alreadyon      :=newcolor(alreadyon);
    onlyonce       :=newcolor(onlyonce);
    toomanycal     :=newcolor(toomanycal);
    notlefta       :=newcolor(notlefta);
    timeinbank     :=newcolor(timeinbank);
    withdrawfrombank:=newcolor(withdrawfrombank);
    hangingup      :=newcolor(hangingup);

    rdmail         :=newcolor(rdmail);
    norecord       :=newcolor(norecord);
    illegallogon   :=newcolor(illegallogon);
    ripdetect      :=newcolor(ripdetect);
    pwconfirm      :=newcolor(pwconfirm);
    fastlogon      :=newcolor(fastlogon);
  end;
  seek(sf,0); write(sf,fstring);
  close(sf);
end;

procedure oneline_dat;
var o:rumorrec;
    f:file of rumorrec;
    i:integer;
begin
  assign(f,systat.datapath+'rumor.dat');
  {$I-} reset(f); {$I+}
  if ioresult<>0 then exit;
  for i:=0 to (filesize(f)-1) do begin
    seek(f,i); read(f,o);
    o:=newcolor(o);
    seek(f,i); write(f,o);
  end;
  close(f);
end;

procedure menus(fn:string);
var f1,f2:text; s:string; i,noc:integer;
begin
  i:=0; noc:=0;
  assign(f1,fn); assign(f2,systat.menupath+'COLORFIX.TMP');
  reset(f1); rewrite(f2);
  while not(eof(f1)) do begin
    readln(f1,s); inc(i);
    if i<=15 then begin
      if i in [1,2,3,6] then writeln(f2,newcolor(s))
      else if i in [12,13,14] then
        begin
          case s[1]of
            '0':s:='W';
            '1':s:='w';
            '2':s:='b';
            '3':s:='C';
            '4':s:='B';
            '5':s:='Y';
            '6':s:='W';
            '7':s:='R';
            '8':s:='R';
            '9':s:='G';
          end;
          writeln(f2,s);
        end
      else writeln(f2,s);
    end else begin
      if i-15-(noc*7) in [1,2,6] then writeln(f2,newcolor(s))
      else writeln(f2,s); if ((i-15) mod 7)=0 then inc(noc);
    end;
  end;
  close(f1); close(f2);
  erase(f1); rename(f2,fn);
end;

procedure afiles(fn:string);
var f1,f2:text; s:string;
begin
  assign(f1,fn); assign(f2,systat.menupath+'COLORFIX.TMP');
  reset(f1); rewrite(f2);
  while not(eof(f1)) do begin
    readln(f1,s); writeln(f2,newcolor(s));
  end;
  close(f1); close(f2);
  erase(f1); rename(f2,fn);
end;

procedure boards_dat;
var bf:file of boardrec;
    b:boardrec; i:integer;
begin
  assign(bf,systat.datapath+'mboards.dat');
  reset(bf);
  for i:=0 to filesize(bf)-1 do
  with b do begin
    seek(bf,i); read(bf,b);
    name:=newcolor(name);
    seek(bf,i); write(bf,b);
  end;
  close(bf);
end;

procedure uploads_dat;
var uf:file of ulrec;
    u:ulrec; i:integer;
begin
  assign(uf,systat.datapath+'fboards.dat');
  reset(uf);
  for i:=0 to filesize(uf)-1 do
  with u do begin
    seek(uf,i); read(uf,u);
    name:=newcolor(name);
    seek(uf,i); write(uf,u);
  end;
  close(uf);
end;

(*****)
(*****)

procedure info1(s:string);
var i:integer;
begin
  tc(3); write('Updating '); tc(11); write(s+' '); tc(3);
  for i:=length(s) to 18 do write('.');
  write(' [ ]'); gotoxy(wherex-2,wherey); tc(14);
end;

function allcaps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allcaps:=s;
end;


(** MAIN **)


label part2, part3;

type
  oldbbslistrec=                  { BBSLIST.DAT : BBS list               }
  record
    ph:string[12];                { phone number                         }
    name:string[35];              { BBS name                             }
    bps:string[5];                { max. bps rate                        }
    modemflags:byte;              { $01 : V.32        $02 : V.32bis      }
                                  { $04 : V.42        $08 : V.42bis      }
                                  { $10 : HST         $20 : H14          }
                                  { $40 : H16         $80 : Unknown      }
    mb:string[5];                 { MB online                            }
    software:string[10];          { software                             }
    group:string[5];              { group affiliations                   }
    nup:string[20];               { new user password                    }
    info:string[50];              { extended info                        }
    bbsdate:string[8];            { date added/modified last             }
    modemflags2:byte;             { $01 : V.FAST      $02 : V.32terbo    }
                                  { $04 : V.34                           }
    res1:array[1..24] of byte;    { ** RESERVED ** }
  end;

var c:char;
    dirinfo:searchrec;
    y:integer;
    s:string;
    f:file of fstringrec;
    fstring:fstringrec;

    oldb:oldbbslistrec;
    newb:bbslistrec;
    oldbf:file of oldbbslistrec;
    newbf:file of bbslistrec;

    f1,f2:text;
    i:byte;

    cf:file of colorrec;
    cr:colorrec;

procedure r1w1;
begin
  readln(f1,s);
  writeln(f2,s);
end;

begin
  exitsave:=exitproc;
  exitproc:=@errorhandle;
  tc(15); writeln;
  writeln('191to192  Update utility for Illusion 1.91');
  writeln; tc(7);
  writeln('For use with the Illusion Bulletin Board System');
  writeln('Copyright 1992-1995 by Kyle Oppenheim and Billy Ma');
  writeln;
  readsystat;

  s:=paramstr(1);
  if (allcaps(copy(s,length(s)-3,4))='.MNU') then begin
    tc(3); writeln('Converting menu '+s);
    tc(11); writeln('Hit space to continue, any other key to abort.');
    c:=readkey; if c<>' ' then halt(0);
    menus(s); halt(0);
  end else
  if (s<>'') then begin
    tc(3); writeln('Converting text file '+s);
    tc(11); writeln('Hit space to continue, any other key to abort.');
    c:=readkey; if c<>' ' then halt(0);
    afiles(s); halt(0);
  end;

  textattr:=140;
  writeln('Warning!  You must obtain a new registration code or');
  writeln('risk losing your user list!!');
  textattr:=12;
  writeln;
  writeln('See README.192 for more information.');
  writeln;
  tc(11);
  Writeln('Press $ to continue, any other key to quit.');
  c:=readkey; if c<>'$' then halt(0);

  clrscr;
  tc(3);
  writeln('1st Pass ');
  writeln;
  writeln('This program will try and update your menus, text files,');
  writeln('rumors, message boards, and file boards to the new color');
  writeln('system (ie: remove any system colors).');
  writeln;
  writeln('            RUN THIS ONLY WITH ILLUSION 1.91!');
  writeln;
  writeln('Make sure you make a backup since there''s no reverse.');
  writeln('You will need to check over your configuration afterwards');
  writeln('to make sure nothing was missed or screwed up.');
  writeln; tc(11);
  Writeln('Press the space bar to begin, any other key to go to the 2nd pass.');
  c:=readkey; if c<>' ' then goto part2;

  clrscr; tc(3);
  writeln('Illusion 1.91 to 1.92 update utility ');
  writeln(''); tc(11);
  writeln('Action                       Done'); tc(3);
  writeln('');

  info1('STRINGS.DAT'); string_dat; writeln('X');
  info1('RUMOR.DAT'); oneline_dat; writeln('X');
  info1('MBOARDS.DAT'); boards_dat; writeln('X');
  info1('FBOARDS.DAT'); uploads_dat; writeln('X');

  tc(3);
  writeln(''); tc(11);
  writeln('Updating MENUS...'); tc(3);
  y:=wherey;
  window(1,y,80,y+3);
  findfirst(systat.menupath+'*.MNU',anyfile-directory,dirinfo);
  if (doserror<>0) then begin
    writeln('  * No menus found');
  end else begin
    while (doserror=0) do begin
      writeln('  '+dirinfo.name);
      menus(systat.menupath+dirinfo.name);
      findnext(dirinfo); delay(50);
    end;
  end;
  window(1,1,80,25); gotoxy(1,y+3);

  tc(3);
  writeln(''); tc(11);
  writeln('Updating AFILES...'); tc(3);
  y:=wherey;
  window(1,y,80,y+3);
  findfirst(systat.textpath+'*.MSG',anyfile-directory,dirinfo);
  if (doserror<>0) then begin
    writeln('  * No afiles found');
  end else begin
    while (doserror=0) do begin
      writeln('  '+dirinfo.name);
      afiles(systat.textpath+dirinfo.name);
      findnext(dirinfo); delay(50);
    end;
  end;
  window(1,1,80,25); gotoxy(1,y+3);

  writeln;
  tc(11); writeln('1st pass successful!'); writeln; tc(3);
  writeln('Press a key to go on to pass 2.');
  c:=readkey;

  PART2:

  clrscr; tc(3);
  writeln('2nd Pass ');
  writeln;
  writeln('This pass will update your menus, strings, and BBS list to the');
  writeln('new formats in 1.92.  Again, make sure you have backups since');
  writeln('there is no way to go back to what you had if something screws up!');
  writeln; tc(11);
  Writeln('Press the space bar to begin, any other key to quit.');
  c:=readkey; if c<>' ' then halt(0);

  clrscr; tc(3);
  writeln('Illusion 1.91 to 1.92 update utility ');
  writeln(''); tc(11);
  writeln('Action                       Done'); tc(3);
  writeln('');

  info1('STRINGS.DAT');
  assign(f,systat.datapath+'STRINGS.DAT');
  reset(f);
  read(f,fstring);
  close(f);

  with fstring do
  begin

    pwconfirm:='|cYour password: |C|XA';
    bchhangup:='Hangup after transfer';
    chfilebase:='|cChange file area (|C?=list|c): |C';
    fastlogon:='Fast logon';

  end;

  rewrite(f);
  write(f,fstring);
  close(f);

  writeln('X');

  info1('BBSLIST.DAT');

  assign(oldbf,systat.datapath+'BBSLIST.DAT');
  assign(newbf,systat.datapath+'BBSLIST.192');
  reset(oldbf);
  rewrite(newbf);

  while (not eof(oldbf)) do
  begin
    read(oldbf,oldb);

    newb.ph:=oldb.ph;
    newb.name:=oldb.name;
    newb.bps:=oldb.bps;
    newb.mb:=oldb.mb;
    newb.software:=oldb.software;
    newb.nup:=oldb.nup;
    newb.info:=oldb.info;
    newb.bbsdate:=oldb.bbsdate;
    fillchar(newb.res1,sizeof(newb.res1),#0);

    write(newbf,newb);
  end;

  close(oldbf);
  erase(oldbf);
  close(newbf);
  rename(newbf,systat.datapath+'BBSLIST.DAT');

  writeln('X');

  info1('COLOR.DAT');
  assign(cf,systat.datapath+'COLOR.DAT');
  reset(cf);
  read(cf,cr);
  cr.cl[15]:=31;
  cr.cl[16]:=140;
  seek(cf,0);
  write(cf,cr);
  close(cf);
  writeln('X');

  tc(3);
  writeln(''); tc(11);
  writeln('Updating MENUS...'); tc(3);
  y:=wherey;
  window(1,y,80,y+3);
  findfirst(systat.menupath+'*.MNU',anyfile-directory,dirinfo);
  if (doserror<>0) then begin
    writeln('  * No menus found');
  end else begin
    while (doserror=0) do begin
      writeln('  '+dirinfo.name);

      assign(f1,systat.menupath+dirinfo.name);
      assign(f2,systat.menupath+copy(dirinfo.name,1,length(dirinfo.name)-4)+'.NEW');
      reset(f1);
      rewrite(f2);
      for i:=1 to 5 do
        r1w1;
      writeln(f2,'*OFF*');
      r1w1;
      for i:=1 to 2 do
        writeln(f2,'0');
      for i:=1 to 8 do
        r1w1;
      readln(f1,s);
      if (pos('A',s)<>0) then
        delete(s,pos('A',s),1);
      writeln(f2,s);
      while (not eof(f1)) do
        r1w1;
      close(f1);
      close(f2);
      erase(f1);
      findnext(dirinfo); delay(50);
    end;
    findfirst(systat.menupath+'*.NEW',anyfile-directory,dirinfo);
    while (doserror=0) do
    begin
      assign(f1,systat.menupath+dirinfo.name);
      rename(f1,systat.menupath+copy(dirinfo.name,1,length(dirinfo.name)-4)+'.MNU');
      findnext(dirinfo);
    end;
  end;
  window(1,1,80,25); gotoxy(1,y+3);

  writeln;
  tc(11); writeln('2nd pass successful!'); writeln; tc(3);
  writeln('Press a key to finish up.');
  c:=readkey;

  PART3:

  clrscr; tc(3);
  writeln('Illusion 1.91 to 1.92 update utility ');
  writeln;

  tc(14);
  writeln('                Conversion complete!');
  writeln('Registered users, make sure you have an updated key!');
  writeln('All users:  Check your setup for any problems.');
  writeln; tc(3);
  writeln('Thank you for using Illusion!');

  halt(0);
end.
