(*****************************************************************************)
(* Illusion BBS - Registration routines                                      *)
(*****************************************************************************)

{$A+,B-,E-,F+,I+,N-,O+,R-,S-,V-}

{$IFDEF DBUG}
  {$D+,L+}
{$ELSE}
  {$D-,L-}
{$ENDIF}

unit fvtype;

INTERFACE

USES
  crt, dos,
  regmain, crc32,
  common, myio;


PROCEDURE DoRegistration(VAR Reg:RegRec);



IMPLEMENTATION


CONST TheWord:string[8]='DEMO';
      TheCRC:longint=522767851;

PROCEDURE DoRegistration(VAR Reg:RegRec);
TYPE String8=String[8];

VAR
  f:file;
  crc:longint;
  i:byte;

PROCEDURE ChkAccess(Typ:String8);
VAR T:Byte;
BEGIN

  If vertype=0 then exit;

  { Anybody can run a test copy }

  If Typ=('ALPHA') Then
    T:=4
  Else
    If Typ=('BETA') Then
      T:=3
    Else
      If Typ=('SPECIAL') Then
        T:=2
      Else
        If Typ=('STANDARD') Then
          T:=1
        Else
          T:=0;

  If T < VerType Then Begin
    writeln;
    writeln('This is a special copy of Illusion and can only be run by sites of class '+cstr(vertype));
    writeln('or higher.  If you are reading this message, you shouldn''t have this program!');
    writeln('Call an Illusion alpha site (phone numbers are available in the ILLUSION.NFO');
    writeln('file included with this package), and leave a note to the SysOp telling him');
    writeln('where you got this copy.  To obtain a valid copy of Illusion, call an alpha or');
    writeln('beta site.');
    writeln;
    if (exiterrors<>-1) then halt(exiterrors) else halt(254);
  end;

END;

PROCEDURE InvalidKey;
VAR c:char; i:byte;
BEGIN
  writeln;
  writeln('INVALID REGISTRATION KEY!!');
  writeln('The registration key found fails the authenticity check, and has been tampered');
  writeln('with.  Obtain a valid key from an Illusion alpha site (phone numbers are');
  writeln('available in the ILLUSION.NFO file included with this package).');
  writeln;
  writeln('Using a false key, somebody else''s key, or attempting to bypass the');
  writeln('registration system is illegal.  Please support Illusion, register it.');
  writeln;
  For i:=1 to 10 do
    begin
      Sound(300);
      sleep(150);
      Nosound;
      sleep(150);
    end;
  Writeln('- Press a key to continue.');
  Repeat until keypressed;
  While keypressed do c:=readkey;
  writeln;
  writeln('Your key may be invalid because the system configuration has a');
  writeln('different sysop name that what you registered with.  Would you');
  writeln('like to change the sysop name in the system configuration?');
  write('Y/N : ');
  repeat
    c:=upcase(readkey);
  until (c in ['Y','N']);
  writeln;
  if c='Y' then
    begin
      writeln;
      writeln('Enter new sysop name: ');
      infield_out_fgrd:=7;
      infield_out_bkgd:=0;
      infield_inp_fgrd:=15;
      infield_inp_bkgd:=1;
      infielde(Systat.SysOpName,sizeof(Systat.SysOpName)-1);
      savesystat;
      writeln; writeln;
      writeln('The new sysop name has been saved.  You can now attempt');
      writeln('to restart Illusion.');
    end;

  if (exiterrors<>-1) then halt(exiterrors) else halt(254);
END;

BEGIN { DoRegistration }

  FillChar(Reg,sizeof(Reg),0);

  Crc:=$FFFFFFFF;
  For i:=1 to length(TheWord) do
    Crc:=UpdC32(ord(TheWord[i]),crc);

  If crc<>TheCrc then
    begin
      writeln('Illegally modified copy of Illusion!');
      halt;
    end;

  Reg.SiteType:=TheWord;

  { - Open file }

  assign(f,start_dir+'\ILLUSION.REG');
  SetFileAccess(ReadOnly,DenyNone);
  {$I-} reset(f); {$I+}
  if ioresult<>0 then
    begin
      ChkAccess(TheWord);
      exit;
    end;

  close(f);

  { - Read in registration info }

  ReadReg(start_dir+'\ILLUSION.REG',Reg);

  Case CheckReg(Reg) of
    $00:Begin
          InvalidKey;
          halt;
        End;
    $01:Begin
          InvalidKey;
          halt;
        End;
    $FF:Begin
          With Reg do
            Begin
              If RRealName=('CRCERROR') then begin InvalidKey; halt; end;
              If RAlias=('CRCERROR') then begin InvalidKey; halt; end;
              If RRealName=('SNERROR') then begin InvalidKey; halt; end;
              If RAlias=('SNERROR') then begin InvalidKey; halt; end;

              If (Pos(allcaps(Systat.SysOpName),RRealName)<>1) then
                If (Pos(allcaps(Systat.SysOpName),RAlias)<>1) then
                  begin
                    InvalidKey;
                    halt;
                  end;
            end;
        end;
  end; {case}

  ChkAccess(Reg.SiteType);

END; {DoRegistration}

END.
