(*****************************************************************************)
(* Illusion BBS - Fireworks screen saver                                     *)
(*****************************************************************************)

{$A+,B-,E-,F+,I+,N-,O+,R-,S-,V-}

{$IFDEF DBUG}
  {$D+,L+}
{$ELSE}
  {$D-,L-}
{$ENDIF}

unit firework;

interface

uses crt,dos,common;

procedure disppix;
procedure init;
procedure readdata;

implementation

type
  color=record
    r,g,b:byte
  end;
  palette=array[0..255] of color;

  ppack=^pack;
  pload=^load;
  pack=record
    num:integer;
    vary:integer;
    stuff:pload;
    boost:integer;
    next:ppack;
  end;
  load=record
    name:byte;
    flash:boolean;
    cont:ppack;
    cset:byte;
    decay:byte;
    grav:longint;
    next:pload;
    gnext:pload;
  end;
  ppix=^pix;
  pix=record
    x,y,dx,dy:longint;
    k:byte;
    l:pload;
    last,next:ppix;
  end;

const
  sh=16;
  mul=65536;
  csize=64;
  delaycount=20;

  firewrk=212; imbedded=213; end1=214; firework1=213;
  red1=2; yellow1=0; green1=3; blue1=1;
  noflash=0; flash=1;

  redspark=0; yellowspark=1; greenspark=2; bluespark=3; greenbomb=4; chrys1=5;
  blitz=6; greenwow=7; splash=8; shower=9; waterfall=10; redbam=11; bammo1=12;
  double1=13; delay1=14; delayed=15; flashy=16; normal1=17; normal2=18;
  normal3=19; normal4=20; double2=21; double3=22; double4=23; triple1=24;
  bluebam=25; yellowbam=26; greenbam=27; bammo2=28; bammo3=29; bammo4=30;
  bluebomb=31; chrys2=32; chrys3=33;

  numdata=411;

  black:  color=(r:0;  g:0;  b:0 );
  white:  color=(r:63; g:63; b:63);
  red:    color=(r:63; g:0;  b:0 );
  blue:   color=(r:0;  g:0;  b:63);
  orange: color=(r:63; g:32; b:0 );
  jade:   color=(r:0;  g:63; b:32);

var
  disp:ppix;
  batt:pload;
  parts:pload;
  count,loads:integer;
  sina,cosa:array[0..360] of longint;
  launch:pix;
  r:registers;

{$L firework.obj}
procedure plot(x,y:word;c:byte); external;

procedure setcolors(p:palette;i,c:byte;n:word);
begin
  r.ax:=$1012;
  r.bh:=0;
  r.bl:=c;
  r.cx:=n;
  r.es:=seg(p);
  r.dx:=ofs(p[0])+i*3;
  intr($10,r)
end;

procedure mix(var p,c1:color;p1:byte;c2:color;p2:byte);
begin
  p.r:=(c1.r*p1+c2.r*p2) div 100;
  p.g:=(c1.g*p1+c2.g*p2) div 100;
  p.b:=(c1.b*p1+c2.b*p2) div 100
end;

procedure range(var p:palette;i1,i2:byte);
var i:byte;
begin
  for i:=i1 to i2 do
    mix(p[i],p[i1],(i2-i)*100 div (i2-i1),p[i2],(i-i1)*100 div (i2-i1))
end;

procedure assigncolor(index:byte;c:color);
begin
  r.ax:=$1010;
  r.bh:=0;
  r.bl:=index;
  r.dh:=c.r;
  r.ch:=c.g;
  r.cl:=c.b;
  intr($10,r)
end;

procedure addpix(d:pix);
var p:ppix;
begin
  new(p);
  p^:=d;
  p^.last:=nil;
  p^.next:=disp;
  if disp<>nil then disp^.last:=p;
  disp:=p;
  inc(count);
end;

procedure rempix(p:ppix);
begin
  if p^.last<>nil then
    p^.last^.next:=p^.next
  else
    disp:=p^.next;
  if p^.next<>nil then p^.next^.last:=p^.last;
  dispose(p);
  dec(count);
end;

procedure gentrig;
var i:integer;
begin
  for i:=0 to 360 do
  begin
    cosa[i]:=round(cos(pi*i/180)*mul);
    sina[i]:=round(sin(pi*i/180)*mul);
  end;
end;

procedure initpix(from:ppix);
var i:integer;
    p:pix;
    th:integer;
    pp:ppack;
begin
  with from^,from^.l^ do
  begin
    if flash then assigncolor(0,white);
    p.x:=x;
    p.y:=y;
    pp:=cont;
    while pp<>nil do
    with pp^ do
    begin
      p.l:=stuff;
      for i:=1 to num+random(vary+1)*2-vary do
        with p do
        begin
          k:=random(p.l^.decay);
          th:=random(360);
          dx:=round(cosa[th]*k*boost/p.l^.decay)+from^.dx;
          dy:=round(sina[th]*k*boost/p.l^.decay)+from^.dy;
          addpix(p);
        end;
      pp:=pp^.next;
    end;
    if flash then assigncolor(0,black);
  end;
end;

procedure fire;
var i:integer;
begin
  with launch do
  begin
    x:=longint(random(319)) shl sh;
    y:=longint(199) shl sh;
    if  x>longint(319) shl (sh-1) then
      dx:=-round(random*mul)
    else
      dx:=round(random*mul);
    dy:=longint(-5)*mul;
    l:=batt;
    for i:=1 to random(loads) do l:=l^.next;
    k:=0;
    addpix(launch);
  end;
end;

procedure disppix;
var p,q:ppix;
    xl,yl:longint;
begin
  xl:=longint(319) shl sh;
  yl:=longint(199) shl sh;
  p:=disp;
  while p<>nil do
    with p^,p^.l^ do
    begin
      q:=p^.next;
      plot(x shr sh,y shr sh,0);
      inc(x,dx*319 div 640);
      inc(y,dy*199 div 480);
      inc(dy,grav);
      inc(k);
      if (k=decay) or (x<0) or (x>xl) or (y<0) or (y>yl) then
      begin
        if (x>0) and (x<xl) and (y>0) and (y<yl) then initpix(p);
        rempix(p);
      end else
        plot(x shr sh,y shr sh,(integer(k)*csize div decay)+cset*csize);
      p:=q;
    end;
  sleep(delaycount);
  if count=0 then fire;
end;

procedure init;
var col:palette;
begin
  randomize;
  gentrig;
  count:=0;
  loads:=0;
  col[1]:=black;
  col[2]:=white;
  col[csize-1]:=orange;
  range(col,2,csize-1);
  col[csize]:=white;
  col[2*csize-1]:=blue;
  range(col,csize,2*csize-1);
  col[2*csize]:=white;
  col[3*csize-1]:=red;
  range(col,2*csize,3*csize-1);
  col[3*csize]:=white;
  col[4*csize-1]:=jade;
  range(col,3*csize,4*csize-1);
  setcolors(col,1,1,4*csize-1);
  disp:=nil;
  parts:=nil;
end;

procedure addload(l:load);
var p:pload;
begin
  new(p);
  p^:=l;
  p^.next:=batt;
  p^.cont:=nil;
  batt:=p;
  p^.gnext:=parts;
  parts:=p;
  inc(loads);
end;

procedure addpart(l:load);
var p:pload;
begin
  new(p);
  p^:=l;
  p^.next:=nil;
  p^.gnext:=parts;
  p^.cont:=nil;
  parts:=p;
end;

procedure addpack(l:pload;k:pack);
var p:ppack;
begin
  new(p);
  p^:=k;
  p^.next:=l^.cont;
  l^.cont:=p;
end;

function findload(n:word):pload;
var p:pload;
begin
  p:=parts;
  while (p<>nil) and (p^.name<>n) do p:=p^.gnext;
  findload:=p;
end;

function getdata(var i:word):byte;
const
  data : array[1..numdata] of byte = (
    imbedded,redspark,noflash,red1,150,3,end1,
    imbedded,bluespark,noflash,blue1,150,3,end1,
    imbedded,greenspark,noflash,green1,150,3,end1,
    imbedded,yellowspark,noflash,yellow1,150,3,end1,

    firewrk,normal1,flash,blue1,150,3,redspark,150,50,5,end1,
    firewrk,normal2,flash,green1,150,3,bluespark,150,50,5,end1,
    firewrk,normal3,flash,green1,150,3,yellowspark,150,50,5,end1,
    firewrk,normal4,flash,red1,150,3,greenspark,150,50,5,end1,
    firewrk,double1,flash,yellow1,150,3,bluespark,100,50,5,greenspark,100,50,5,end1,
    firewrk,double2,flash,blue1,150,3,redspark,100,50,5,greenspark,100,50,5,end1,
    firewrk,double3,flash,yellow1,150,3,bluespark,100,50,5,redspark,100,50,5,end1,
    firewrk,double4,flash,green1,150,3,redspark,100,50,5,yellowspark,100,50,5,end1,
    firewrk,triple1,flash,blue1,150,3,bluespark,50,25,5,greenspark,50,25,5,redspark,50,25,5,end1,

    imbedded,greenbomb,flash,green1,150,3,greenspark,10,0,1,end1,
    firewrk,chrys1,flash,blue1,125,3,redspark,200,75,7,greenbomb,5,3,3,end1,
    imbedded,bluebomb,flash,blue1,150,3,bluespark,10,0,1,end1,
    firewrk,chrys2,flash,blue1,125,3,redspark,200,75,7,bluebomb,5,3,3,end1,
    firewrk,chrys3,flash,blue1,125,3,bluespark,200,75,7,greenbomb,5,3,3,end1,

    imbedded,blitz,flash,green1,100,3,bluespark,50,25,4,end1,
    imbedded,greenwow,flash,red1,150,3,greenspark,30,5,6,end1,
    firewrk,splash,flash,yellow1,150,3,greenwow,5,3,3,blitz,5,3,3,redspark,125,25,5,end1,

    imbedded,shower,noflash,green1,125,3,bluespark,10,2,1,end1,
    firewrk,waterfall,flash,blue1,150,3,shower,25,5,3,end1,

    imbedded,redbam,noflash,red1,10,4,redspark,2,1,2,redbam,1,0,0,end1,
    firewrk,bammo1,flash,red1,150,3,redbam,7,2,3,end1,
    imbedded,bluebam,noflash,blue1,10,4,bluespark,2,1,2,bluebam,1,0,0,end1,
    firewrk,bammo2,flash,blue1,150,3,bluebam,7,2,3,end1,
    imbedded,greenbam,noflash,green1,10,4,greenspark,2,1,2,greenbam,1,0,0,end1,
    firewrk,bammo3,flash,green1,150,3,greenbam,7,2,3,end1,
    imbedded,yellowbam,noflash,yellow1,10,4,yellowspark,2,1,2,yellowbam,1,0,0,end1,
    firewrk,bammo4,flash,yellow1,150,3,yellowbam,7,2,3,end1,

    imbedded,delay1,flash,yellow1,150,3,yellowspark,200,50,5,end1,
    firewrk,delayed,flash,red1,150,3,delay1,1,0,0,greenspark,250,50,5,end1
  );
begin
  inc(i);
  getdata:=data[i-1];
end;

procedure readdata;
var l:load;
    p:pack;
    i,w:word;
begin
  i:=1;
  while (i<=numdata) do
  begin
    w:=getdata(i);
    l.name:=getdata(i);
    l.flash:=getdata(i)=1;
    l.cset:=getdata(i);
    l.decay:=getdata(i);
    l.grav:=getdata(i);
    l.grav:=l.grav*mul div 100;
    if (w=firewrk) then addload(l) else addpart(l);
    w:=getdata(i);
    while (w<>end1) do
    begin
      p.stuff:=findload(w);
      p.num:=getdata(i);
      p.vary:=getdata(i);
      p.boost:=getdata(i);
      addpack(parts,p);
      w:=getdata(i);
    end;
  end;
end;

end.
