                    {     Hype Bulletin Board System    }
                    {  Copyright 1997, 98 by Brian Zhou }
                    {      Stuctures for data files     }

CONST
  bbsTitle = 'Hype';
  ver:string[15]='1.00.a3';
  bbsRelease = '02.26.1998';
  bbsCopyInfo = '(C)opyright 1997, 98 by The Hype Development Team.';
  bbsAll = 'All rights reserved.';

  maxboards=254;      { 1 - x }
  maxuboards=143;     { 0 - x }
  maxprotocols=120;   { 0 - x }
  maxevents=10;       { 0 - x }   { #0 is Nightly Events (if active) }
  maxarcs=8;          { 1 - x }
  maxubatchfiles=50;
  maxmenucmds=100;

TYPE
  astr    =string[160];

  acstring=string[20];            { Access Condition String }
  acrq    ='@'..'Z';              { AR flags }

  uflags =
   (rlogon,                       { L - Restricted to one call a day }
    rchat,                        { C - Can't page the SysOp }
    rvalidate,                    { V - Posts marked unvalidated }
    rbackspace,                   { B - Can't do ^B/^N/etc in messages }
    ramsg,                        { A - Can't change the AutoMessage }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post at all }
    remail,                       { E - Can't send any e-mail }
    rvoting,                      { K - Can't vote }
    rmsg,                         { M - Force e-mail deletion }
    spcsr,                        { }
    onekey,                       { onekey input mode }
    avatar,                       { user has AVATAR }
    pause,                        { pause }
    novice,                       { user is at novice help level }
    ansi,                         { user has ANSI }
    color,                        { user has color }
    alert,                        { alert SysOp when user logs on }
    smw,                          { short-message waiting for user }
    nomail,                       { user mail-box is closed }
    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnofilepts,                   { 3 - No file points checking }
    fnodeletion);                 { 4 - Protection from deletion }

  flistflags =
   (fname,                        { filename }
    fsize,                        { file size }
    fpts,                         { file points }
    fdesc,                        { file desc. }
    extdesc,                      { extended desc. }
    whoul,                        { who uploaded it }
    dateul,                       { date uploaded }
    numdl);                       { num of d/l's. }

  anontyp =
   (atno,                         { No anonymous posts allowed }
    atyes,                        { Anonymous posts are allowed }
    atforced,                     { ALL posts are forced anonymous }
    atdearabby,                   { "Dear Abby" message base }
    atanyname);                   { User's can post as ANY name they want }

  clrs = array[FALSE..TRUE,0..9] of byte; { color records }
  secrange= array[0..255] of integer; { security tables }

  cpackdatetime=array[1..6] of byte;

  mzscanr = set of 1..maxboards;
  fzscanr = set of 0..maxuboards;
  mhireadr= array[1..maxboards] of cpackdatetime;

  dlnscan =set of 0..96;

  smalrec=                            { USER    .IDX : Sorted names listing }
  record                              { ----------------------------------- }
    name:string[36];                  { user name                           }
    realname:string[36];              { real name                           }
    deleted:boolean;                  { deleted                             }
    number:integer;                   { user number                         }
  end;                                { ----------------------------------- }

  userrec=                            { USER.LST : User account records }
  record                              { ----------------------------------- }
    name:string[36];                  { user name                       }
    realname:string[36];              { real name                       }
    pw:string[20];                    { user password                   }
    ph:string[12];                    { user phone #                    }
    bday:string[8];                   { user birthdate                  }
    firston:string[8];                { firston date                    }
    x1xs  :array[1..2] of byte;
    laston:string[8];                 { laston date                     }
    x2xs  :array[1..2] of byte;
    street:string[30];                { mailing address                 }
    citystate:string[30];             { city, state                     }
    zipcode:string[10];               { zipcode                         }
    computer:string[30];              { type of computer                }
    occupation:string[40];            { autosig                         }
    wherebbs:string[40];              { BBS reference    }
    note:string[39];                  { SysOp note       }

    lockedout:boolean;                { if locked out    }
    deleted:boolean;                  { if deleted       }
    lockedfile:string[8];             { lockout msg to print }

    ac:set of uflags;                 { user flags   }
    ar:set of acrq;                   { AR flags     }

    zzqscan:array[1..64] of word;     { last read msg pointers }
    xqxxx:array[1..64] of word;
    zzqscn:array[1..64] of boolean;   { scan boards flags  }
    zzdlnscn:dlnscan;                 { scan uboards flags }

    asdf:array[1..20] of byte;        { voting data  }

    sex:char;                         { user sex }

    ttimeon:longint;                  { total mins spent on  }
    x1xx:integer;
    uk:longint;                       { UL k                 }
    x2xx:integer;
    dk:longint;                       { DL k                 }
    x3xx:integer;

    uploads,downloads,                { # of ULs / # of DLs  }
    loggedon,                         { # times logged on    }
    tltoday,                          { # min left today     }
    msgpost,                          { # public posts       }
    emailsent,                        { # email sent         }
    feedback,                         { # feedback sent      }
    forusr,                           { forward mail to user # }
    filepoints:integer;               { # of file points     }

    waiting,                          { mail waiting         }
    linelen,                          { line length (# cols) }
    pagelen,                          { page length (# rows) }
    ontoday,                          { # times on today     }
    illegal,                          { # illegal logon attempts }
    sl,dsl:byte;                      { SL / DSL }

    cols:clrs;                        { user colors }

    lastmsg,lastfil:byte;             { last msg/file areas   }
    credit:longint;                   { $$$ credit in dollars }
    x4xx:integer;
    timebank:integer;                 { # mins in Time Bank   }
    boardsysop:array[1..5] of byte;   { msg board SysOp       }

    trapactivity,                     { if trapping users activity }
    trapseperate:boolean;             { if trap to seperate TRAP file }

    timebankadd:integer;              { time added to timebank TODAY }

    reserved:longint;                 { pointer to entry in MACRO.LST }

    chatauto,                         { if auto chat trapping }
    chatseperate:boolean;             { if seperate chat file to trap to }
    userstartmenu:string[8];          { menu to start user out on }
    slogseperate:boolean;             { seperate SysOp log? }
    clsmsg:byte;                      { 1 if clear-screen msg, 2 if not }

    flistopt:byte;                    { type of file list type to use }
    msgorder:byte;                    { 0:Chrono, 1:ReplyTree }
    avadjust:byte;                    { AVATAR color adjust: 1=no, 2=yes }
    fflag:set of flistflags;          { users configable file list }

    res:array[1..53] of byte;         { RESERVED                            }
  end;                                { ----------------------------------- }

  zscanrec=                       { ZSCAN.DAT : NewScan recs (file/msg) }
  record                          { ** b0..b3 }
    mhiread:mhireadr;             { NewScan high message pointers }
    mzscan:mzscanr;               { NewScan message bases }
    fzscan:fzscanr;               { NewScan file bases }
  end;

  msgindexstatr=
   (miexist,                      { does message actually exist? }
    miencrypted,                  { is it encrypted? }
    miunvalidated,                { is message unvalidated? }
    mipermanent,                  { is the message permanent? }
    miallowmci,                   { DID owner have access to MCI? }
    mithreads,                    { is message referenced? (threaded) }
    mimassmail,                   { is it private, mass mail? }
    miscanned);                   { is message scanned for FidoNet? }

  msgindexrec=                         { *.MIX : Message index records }
  record
    messagenum:word;                   { message number, tonum in EMAIL.MIX }
    hdrptr:longint;                    { pointer to message header }
    msgid:longint;                     { message ID (sequential) }
    isreplytoid:longint;               { ID of replied message }
    msgdate:cpackdatetime;             { message date/time (packed) }
    msgdowk:byte;                      { message day-of-week (0=Sun ...) }
    lastdate:array[1..6] of byte;     { update: date/time }
    lastdowk:byte;                    { update: day-of-week }
    msgindexstat:set of msgindexstatr; { status flags }
    isreplyto:word;                    { reply this message is to (-1=None) }
    numreplys:word;                    { number of replies to THIS message }
  end;

  fromtoinfo=                  { from/to information for mheaderrec }
  record
    anon:byte;                 { anonymous type }
    fusernum:word;              { user number }
    asn:string[42];             { given name for this case }
    real:string[36];           { user real name }
    alias:string[36];          { user alias }
  end;

  mheaderrec=                  { *.BRD : Message header records }
  record
    signature:longint;         { header signature - $FFFFFFFF }
    msgptr:longint;            { pointer to message text }
    msglength:longint;         { length of message text }
    fromi:fromtoinfo;          { from information }
    toi:fromtoinfo;            { to information }
    title:string[60];          { title of message }
    origindate:string[19];     { Echo/Group original msg date }
  end;

  zlogrec=                        { ZLOG.DAT : System log }
  record
    date:string[8];
    userbaud:array[0..4] of integer;
    active,calls,newusers,pubpost,privpost,fback,criterr:integer;
    uploads,downloads:integer;
    uk,dk:longint;
  end;

  filearcinforec=                 { Archive configuration records }
  record
    active:boolean;               { whether this archive format is active }
    ext:string[3];                { 3-chr file extension }
    listline,                     { /x for internal;
                                     x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline, '' for *None* }
    cmtline:string[25];           { comment cmdline, '' for *None* }
    succlevel:integer;            { success ERRORLEVEL, -1=ignore results }
  end;

  modemrec=
  record
    waitbaud:longint;            { wait baud }
    comport:byte;                { comport number }
    (*
    inoutbuff:byte;              { modem in/out buffer size }
    *)
    irqnum:byte;                 { irq number 0-7 (255 for none) }
    init:string[80];             { initialization string }
    answer:string[40];           { answer string }
    hangup:string[40];           { hangup string }
    offhook:string[40];          { phone off-hook string }
    nocallinittime:byte;         { reinit modem after x mins of inactivity }
    (*
    arq9600rate:longint;         { baud rate to USE when 9600 ARQ result code }
    noforcerate:boolean;         { whether to force baud rate }
    *)
    hardware:boolean;            { use hardware handshaking }
  end;

  fstringrec=                         { STRING  .DAT : Strings              }
  record                              { ----------------------------------- }
    ansiq:string[80];                 { "Do you want ANSI? " string         }
    note:array[1..2] of string[80];   { Logon notes (L #1-2)                }
    lprompt:string[80];               { Logon prompt (L #3)                 }
    echoc:char;                       { Echo char for PWs                   }
    sysopin,                          { "SysOp In" (inside SysOp hours)     }

    sysopout,                         { "SysOp Out"                         }
    engage,                           { "Engage Chat"                       }
    endchat,                          { "End Chat"                          }
    wait,                             { "SysOp Working"                     }
    pause,                            { "Pause"                             }
    entermsg1,                        { "Enter Message" line #1             }

    entermsg2,                        { "Enter Message" line #2             }
    newscan1,                         { "NewScan begin"                     }
    newscan2,                         { "NewScan done"                      }
    scanmessage,                      { Message scanning prompt             }
    automsgt:string[80];              { Auto-Message title                  }
    autom:char;                       { Auto-Message border characters      }

    shelldos1,                        { " >> SysOp shelling to DOS ..."     }
    shelldos2,                        { " ... thank you for waiting."       }
    chatcall1,                        { "Paging SysOp, please wait..."      }
    chatcall2,                        { ">>><*><<<"                         }
    illegalog,                        { "illegal logon"                     }
    namenotfound,                     { "Name NOT found in user list."      }

    whychat,                          { "Why do you wanna chat?"            }
    aborted,                          { "Aborted."                          }
    listline,                         { "List files - P to pause"           }
    newline,                          { "Search for new files -"            }
    searchline,                       { "Search all dirs for file mask"     }
    findline1,                        { "Search for descriptions... "       }

    findline2,                        { "Enter the string to search for.."  }
    downloadline,                     { "Download - "                       }
    uploadline,                       { "Upload - "                         }
    viewline,                         { "View interior files - "            }
    nofilepts,                        { "Insufficient file points."         }
    unbalance,                        { "Your UL/DL ratio is unbalanced"    }

    pninfo,                           { "P to Pause, N for next dir"        }
    gfnline1,                         { "[Enter]=All files"                 }
    gfnline2,                         { "File mask: "                       }
    batchadd:string[80];              { "File added to batch queue."        }
    FLPrompt:String[80];              { File Listings Prompt                }
    badcommand:string[80];            { "Invalid command"                   }

    userPW:String[80];                { "User Password"                     }
    userPH:String[80];                { "Complete phone #: ###-###-         }
    ntog_ansi:string[80];             { "Which emulation? (1) TTY (none), (2) ANSI, (3) AVATAR :" }
    n_voicephone:string[80];          { "Enter your voice phone:"           }
    n_alias:string[80];               { "Enter your alias:"                 }
    n_noalias:string[80];             { "Enter your REAL NAME, no handles!" }

    n_alreadyu:string[80];            { "That name is already used"         }
    n_cantusen:string[80];            { "Sorry, can't use that name"        }
    n_epw:string[80];                 { "Enter your pw, between 4-20 chrs"  }
    n_least4chr:string[80];           { "Must be atlease 4 chars long"      }
    n_less20chr:string[80];           { "Must be less than 20 chars"        }

    n_ypw:string[80];                 { "your password"                     }
    b4chpw:string[80];                { "enter your old pw for sec. reasons"}
    n_bdate:string[80];               { "enter your birthdate [mm/dd/yy]"   }
    n_address:string[80];             { "Enter your street address"         }
    n_city:string[80];                { "enter your city name"              }
    n_provstate:string[80];           { "enter your province abbreviation"  }

    n_sex:string[80];                 { "your sex [m]ale/[f]emale"          }

    m_ffull,                          { "forum full"                        }
    m_faband,                         { "forum abandoned"                   }
    m_fenter,                         { "chat forum entered [1-10"          }
    m_prmpt,                          { ":"                                 }
    m_brdcast,                        { "broadcast globally? [n]"           }
    m_entmsg                          { "enter message"                     }
    :string[80];
  end;                                { ----------------------------------- }

  systatrec =                         { HYPE    .DAT : System Data          }
  record                              { ----------------------------------- }
    gfilepath:string[79];             { DATA path                           }
    afilepath:string[79];             { ANSI path                           }
    menupath:string[79];              { MENU path                           }
    trappath:string[79];              { LOGS path                           }
    msgpath:string[79];               { MSGS path                           }
    temppath:string[79];              { TEMP path                           }
    startdir:string[79];              { batch file to run instead of NScan  }

    bbsname:string[80];               { BBS name                            }
    bbsphone:string[12];              { BBS phone number                    }
    sysopname:string[30];             { SysOp's full name or alias          }
    maxusers,                         { Max number of users system can have }
    lowtime,                          { SysOp begin minute (in minutes)     }
    hitime,                           { SysOp end time                      }
    dllowtime,                        { Normal downloading hours begin..    }
    dlhitime:integer;                 { ..and end                           }
    shuttlelog,                       { Is Shuttle Logon active?            }
    lock300:boolean;                  { Lock out 300 baud?                  }
    sysoppw,                          { SysOp PW                            }
    newuserpw,                        { Newuser PW (or NULL if none)        }
    shuttlepw:string[20];             { Shuttle PW (if Shuttle active)      }
    b300lowtime,                      { 300 baud calling hours begin..      }
    b300hitime,                       { ..and end                           }
    b300dllowtime,                    { 300 baud downloading hours begin..  }
    b300dlhitime:integer;             { ..and end                           }
    closedsystem:boolean;             { DON'T allow new users?              }
    swapshell:boolean;                { Is swap shell function enabled?     }
    eventwarningtime:integer;         { Time before event warning           }
    res1:array[1..20] of byte;        { RESERVED SPACE #1                   }

    sop,                              { SysOp                               }
    csop,                             { Co-SysOp                            }
    msop,                             { Message SysOp                       }
    fsop,                             { File SysOp                          }
    spw,                              { SysOp PW at logon                   }
    seepw,                            { See SysOp PWs remotely              }
    normpubpost,                      { Make normal public posts            }
    normprivpost,                     { Send normal e-mail                  }
    anonpubread,                      { See who posted public anon          }
    anonprivread,                     { See who sent anon e-mail            }
    anonpubpost,                      { Make anon posts                     }
    anonprivpost,                     { Send anon e-mail                    }
    seeunval,                         { See unvalidated files               }
    dlunval,                          { DL unvalidated files                }
    nodlratio,                        { No UL/DL ratio                      }
    nopostratio,                      { No post/call ratio                  }
    nofilepts,                        { No file points checking             }
    ulvalreq:acstring;                { Uploads require validation by SysOp }
    res2:array[1..100] of byte;       { RESERVED SPACE #2                   }

    maxprivpost,                      { Max e-mail can send per call        }
    maxfback,                         { Max feedback per call               }
    maxpubpost,                       { Max posts per call                  }
    maxchat,                          { Max chat-pages per call             }
    maxwaiting,                       { Max mail in mail-box                }
    csmaxwaiting,                     { Max mail in mail-box for Co-SysOp + }
    maxlines,                         { Max lines in message                }
    csmaxlines,                       { Max lines in message for Co-SysOp + }
    maxlogontries,                    { Tries allowed for PW's at logon     }
    sysopcolor,                       { SysOp color in chat mode            }
    usercolor:byte;                   { User color in chat mode             }
    minspaceforpost,                  { Minimum K drive space left to post  }
    minspaceforupload:integer;        { Minimum K drive space left to upload}
    backsysoplogs,                    { Days to keep SYSOP##.LOG            }
    wfcblanktime:byte;                { Minutes after which to blank WFC menu}
    linelen,                          { Default video line length           }
    pagelen:byte;                     { Default video page length           }
    res3:array[1..19] of byte;        { RESERVED SPACE #3                   }

    loglocal,                         { Log local logins?                   }
    fossil,                           { Make use of FOSSIL comm driver      }
    allowalias,                       { Allow alias's? (handles)            }
    phonepw,                          { Use phone number password in logon? }
    localsec,                         { Is local security ON?               }
    localscreensec,                   { Is local screen-security ON?        }
    globaltrap,                       { Trap ALL USER'S activity?           }
    autochatopen,                     { Does chat buffer auto-open?         }
    autominlogon,                     { Auto-Message in logon?              }
    lcallinlogon,                     { "Last Few Callers" list in logon?   }
    yourinfoinlogon,                  { "Your Info" in logon?               }
    multinode,                        { Is BBS multinode?                   }
    offhooklocallogon,                { Take phone off-hook for local logons? }
    forcevoting,                      { Is manditory logon voting active?   }
    compressbases,                    { "compress" file/message base numbers? }
    searchdup:boolean;                { Search for dup. filenames when UL?  }
    slogtype:byte;                    { SysOp log type: File/Printer/Both   }
    stripclog:boolean;                { Strip colors from SysOp log output? }
    newapp,                           { User# to send new user application to }
    timeoutbell,                      { Minutes before time-out bell        }
    timeout:integer;                  { Minutes before timeout (logoff)     }
    useems:boolean;                   { Attempt to use EMS for overlay      }
    usebios:boolean;                  { Use ROM BIOS for local video output }
    cgasnow:boolean;                  { Suppress snow on CGA systems        }
    res4:array[1..19] of byte;        { RESERVED SPACE #4                   }

    filearcinfo:array[1..maxarcs] of filearcinforec; { archive specs        }
    filearccomment:array[1..3] of string[80]; { BBS comments for archives   }
    uldlratio,                        { Are UL/DL ratios active?            }
    fileptratio:boolean;              { Is auto file-P compensation active? }
    fileptcomp,                       { File point compensation ratio       }
    fileptcompbasesize,               { File point "base compensation size" }
    ulrefund,                         { Percent time refund for ULs         }
    tosysopdir:byte;                  { "To SysOp" file base                }
    validateallfiles:boolean;         { Validate ALL FILES automatically?   }
    remdevice:string[10];             { Remote output device (COMx,etc)     }
    maxintemp,                        { Max K allowed in TEMP\3\            }
    minresume:integer;                { Min K to allow resume-later         }
    maxdbatch,                        { Max files in DL batch queue         }
    maxubatch:byte;                   { Max files in UL batch queue         }
    res5:array[1..30] of byte;        { RESERVED SPACE #5                   }

    newsl,                            { Newuser SL                          }
    newdsl:byte;                      { Newuser DSL                         }
    newar:set of acrq;                { Newuser AR                          }
    newac:set of uflags;              { Newuser AC                          }
    newfp:integer;                    { Newuser file points                 }
    autosl,                           { Auto-validation SL                  }
    autodsl:byte;                     { Auto-validation DSL                 }
    autoar:set of acrq;               { Auto-validation AR                  }
    autoac:set of uflags;             { Auto-validation AC                  }

    allstartmenu:string[8];           { Logon menu to start ALL users on    }
    chatcfilter1,                     { SysOp chat color-filter             }
    chatcfilter2:string[12];          { User chat color-filter              }
    bulletprefix:string[8];           { Default bulletins filename prefix   }
    numoflines:byte;                  { Lines of file_id.diz                }
    uselite:boolean;                  { Use lightbar toggles                }
    ulcheckit:boolean;                { Use Internal Upload Checker?        }
    swapwhat:byte;                    { Swap into (1/disk/2/xms/3/ems)      }
    res6:array[1..11] of byte;        { RESERVED SPACE #6                   }

    timeallow,                        { Time allowance                      }
    callallow,                        { Call allowance                      }
    dlratio,                          { # ULs/# DLs ratios                  }
    dlkratio,                         { DLk/ULk ratios                      }
    postratio:secrange;               { Post/call ratios                    }

    lastdate:string[8];               { Last system date                    }
    curwindow:byte;                   { Type of SysOp window currently in use }
    istopwindow:boolean;              { Is SysOp window on top of screen?   }
    callernum:longint;                { Total number of callers             }
    numusers:integer;                 { Number of users                     }

    todayzlog:zlogrec;                { TODAY's ZLOG record                 }

    postcredits:integer; { File points/upload credit compensation for posts }

    windowon:boolean;                 { ----------------------------------- }

    swappath:string[79];              { Swap shell path                     }
    usenuv:boolean;                   { Is new user voting active?          }
    nuvyes,                           { Yes votes required for validation   }
    nuvno:byte;                       { No votes required for validation    }
    boxstyle:char;                    { Style of ANSI box                   }
    regnum:string[10];                { Registration number                 }
    res:array[1..103] of byte;        {    ((((((>>> RESERVED <<<))))))     }
  end;                                { ----------------------------------- }


  smr =                               { SHORTMSG.DAT : One-line messages    }
  record                              { ----------------------------------- }
    msg:astr;                         { Message                             }
    destin:integer;                   { Destination (user #)                }
  end;                                { ----------------------------------- }

  mbflags=
   (mbunhidden,                   { whether *VISIBLE* to users w/o access }
    mbrealname,                   { whether real names are forced }
    mbisdir,                      { if a message base directory }
    mbmsgpath,                    { if *.BRD file stored in MSGPATH }
    mbfilter,                     { whether to filter ANSI/8-bit ASCII }
    mbskludge,                    { strip IFNA kludge lines }
    mbsseenby,                    { strip SEEN-BY lines }
    mbsorigin,                    { strip origin lines }
    mbscenter,                    { strip centering codes }
    mbsbox,                       { strip box codes }
    mbmcenter,                    { center boxed/centered lines }
    mbaddtear,                    { add tear/origin lines }
    mbtopstar);                   { whether Top Star for GroupMail base }

  boardrec=                       { BOARDS.DAT : Message base records }
  record
    name:string[40];              { message base description }
    filename:string[8];           { BRD/MIX data filename }
    lastmsgid:longint;            { last message ID number }
    msgpath:string[40];           { messages pathname   }
    acs,                          { access requirement }
    postacs,                      { post access requirement }
    mciacs:acstring;              { MCI usage requirement }
    maxmsgs:word;                 { max message count }
    anonymous:anontyp;            { anonymous type }
    password:string[20];          { base password }
    mbstat:set of mbflags;        { message base status vars }
    permindx:longint;             { permanent index # }
    mbtype:integer;               { base type (0=Local,1=Echo,2=Group) }
    origin:string[50];            { origin line }
    text_color,                   { color of standard text }
    quote_color,                  { color of quoted text }
    tear_color,                   { color of tear line }
    origin_color:byte;            { color of origin line }
    zone,                         { alternate address     }
    net,                          { (zone:net/node.point) }
    node,
    point:integer;
    res:array[1..3] of byte;      { RESERVED }
  end;

  fbflags=
   (fbnoratio,                    { if <No Ratio> active }
    fbunhidden,                   { whether *VISIBLE* to users w/o access }
    fbdirdlpath,                  { if *.DIR file stored in DLPATH }
    fbisdir,                      { if a file base directory }
    fbusegifspecs,                { whether to use GifSpecs }
    fbnetlink);                   { whether Net-Linked to other Telegards }

  ulrec=                          { UPLOADS.DAT : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:integer;             { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    fbdepth:integer;              { file base dir depth }
    fbstat:set of fbflags;        { file base status vars }
    acs,                          { access requirements }
    ulacs,                        { upload requirements }
    nameacs:acstring;             { see-names requirements }
    permindx:longint;             { permanent index # }
    res:array[1..6] of byte;      { RESERVED }
  end;

  filstat=
   (notval,                       { if file is NOT validated }
    isrequest,                    { if file is REQUEST }
    resumelater);                 { if file is RESUME-LATER }

  ulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[50];       { File description }
    filepoints:integer;           { File points }
    nacc:integer;                 { Number DLs }
    ft:byte;                      { File type (useless?) }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:integer;                { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;

  verbrec=                        { VERBOSE.DAT : Verbose descriptions }
  record
    descr:array[1..20] of string[50];
  end;

  lcallers=                       { LASTON.DAT : Last few callers records }
  record
    callernum:integer;            { system caller number }
    name:string[36];              { user name of caller }
    number:integer;               { user number of caller }
    citystate:string[30];         { city/state of caller }
  end;

  eventrec=                       { EVENTS.DAT : Event records }
  record
    active:boolean;               { whether active }
    description:string[30];       { event description (for logs) }
    etype:char;                   { A:CS, C:hat, D:os call, E:xternal }
    execdata:string[20];          { errorlevel if "E", commandline if "D" }
    busytime:integer;             { off-hook time before; 0 if none }
    exectime:integer;             { time of execution }
    busyduring:boolean;           { busy phone DURING event? }
    duration:integer;             { length of time event takes }
    execdays:byte;                { bitwise execution days or day of month if monthly }
    monthly:boolean;              { monthly event? }
  end;

  mnuflags=
   (clrscrbefore,                 { C: clear screen before menu display }
    dontcenter,                   { D: don't center the menu titles! }
    nomenuprompt,                 { N: no menu prompt whatsoever? }
    forcepause,                   { F: force a pause before menu display? }
    pulldown,                     { P: pulldown flag. }
    useglobal,                    { G: use the global menu }
    autotime);                    { T: is time displayed automatically? }

  menurec=                        { *.MNU : Menu records }
  record
    menuname:array[1..3] of string[100]; { menu name }
    directive,                           { help file displayed }
    tutorial:string[12];                 { tutorial help file }
    menuprompt:string[120];              { menu prompt }
    acs:acstring;                        { access requirements }
    password:string[15];                 { password required }
    fallback:string[8];                  { fallback menu }
    forcehelplevel:byte;                 { forced help level for menu }
    gencols:byte;                        { generic menus: # of columns }
    gcol:array[1..3] of byte;            { generic menus: colors }
    menuflags:set of mnuflags;           { menu status variables }
  end;

  cmdflags=
   (hidden,                           { H: command ALWAYS hidden?           }
    pull,                             { P: command flagged as Pulldown?     }
    unhidden);                        { U: command ALWAYS visible?          }

  commandrec=                         {        *.MNU : Command records      }
  record                              { ----------------------------------- }
    ldesc:string[70];                 { long command description            }
    sdesc:string[70];                 { short command description           }
    xpoint,                           { the command's X position            }
    ypoint:string[3];                 { the command's Y position            }
    ckeys:array[1..2] of string[14];  { command-execution keys              }
    acs:acstring;                     { access requirements                 }
    cmdkeys:string[2];                { command keys: type of command       }
    mstring:string[50];               { MString: command data               }
    commandflags:set of cmdflags;     { command status variables            }
  end;                                { ----------------------------------- }

  xbflags=
   (xbactive,
    xbisbatch,
    xbisresume,
    xbxferokcode);

  protrec=                            { PROTOCOL.DAT : Protocol config      }
  record                              { ----------------------------------- }
    xbstat:set of xbflags;            { protocol flags                      }
    ckeys:string[14];                 { command keys                        }
    descr:string[40];                 { description                         }
    acs:acstring;                     { access string                       }
    templog:string[25];               { temp. log file                      }
    uloadlog,dloadlog:string[25];     { permanent log files                 }
    ulcmd,dlcmd:string[78];           { UL/DL commandlines                  }
    ulcode,dlcode:array [1..6] of string[6]; { UL/DL codes                  }
    envcmd:string[60];             {B}{ environment setup cmd               }
    dlflist:string[25];            {B}{ DL file lists                       }
    maxchrs:integer;                  { max chrs in cmdline                 }
    logpf,logps:integer;           {B}{ pos in log file for data            }
    permindx:longint;                 { permanent index #                   }
    res:array[1..11] of byte          { RESERVED                            }
  end;                                { ----------------------------------- }

  datetimerec=                        { ----------------------------------- }
  record                              { ----------------------------------- }
    day,hour,min,sec:longint;         { ----------------------------------- }
  end;                                { ----------------------------------- }

  fidorec=                            { FIDONET .DAT : FidoNet information  }
  record                              { ----------------------------------- }
    zone:integer;                     { FidoNet zone number                 }
    net:integer;                      { FidoNet net number                  }
    node:integer;                     { FidoNet node number                 }
    point:integer;                    { FidoNet point number                }
    origin:string[50];                { origin line                         }
    text_color:byte;                  { color of standard text              }
    quote_color:byte;                 { color of quoted text                }
    tear_color:byte;                  { color of tear line                  }
    origin_color:byte;                { color of origin line                }
    skludge:boolean;                  { strip kludge lines?                 }
    sseenby:boolean;                  { strip SEEN-BY lines?                }
    sorigin:boolean;                  { strip origin line?                  }
    scenter:boolean;                  { strip centering codes?              }
    sbox:boolean;                     { strip box codes?                    }
    mcenter:boolean;                  { center boxed/centered lines?        }
    addtear:boolean;                  { add tear/origin lines?              }
    res:array[1..1978] of byte;       { RESERVED                            }
  end;                                { ----------------------------------- }

  noderec=                            { NODES   .DAT : Node information     }
  record                              { ----------------------------------- }
    desc:string[40];                  { Short node description              }
    acs:acstring;                     { ACS required to log in to that node }
    status:byte;                      { What the node is doing              }
    username:string[40];              { User that is on right now           }
    usernum:integer;                  { User # that is on right now         }
    res:array[1..10] of byte;         { RESERVED                            }
  end;                                { ----------------------------------- }

  nodemessrec=                        { NODEMESS.DAT : Online Message       }
  record                              { ----------------------------------- }
    mess:string[80];                  { Message that is going to that node  }
    deleted:boolean;                  { It is deleted?                      }
    nodeto:byte;                      { Which node is it going to?          }
    nodefrom:byte;                    { Which node is it from?              }
    namefrom:string[40];              { Username that it is from            }
    numfrom:integer;                  { User number that it is from         }
    res:array[1..10] of byte;         { RESERVED                            }
  end;                                { ----------------------------------- }

  forumrec=                           { FORUM%%%.??? : Forum chat           }
  record                              { ----------------------------------- }
    user:string[36];                  { Name of user in that slot           }
    deleted:boolean;                  { Is the slot record deleted?         }
    node:byte;                        { Node that they are on               }
  end;                                { ----------------------------------- }

  nuvrec=                             { NUV     .DAT : New User Voting data }
  record                              { ----------------------------------- }
    unum:integer;                     { User number being voted on          }
    handle:astr;                      { Handle of user being voted on       }
    no,                               { No votes                            }
    yes,                              { Yes votes                           }
    totvoted:integer;                 { # of users voted on him already     }
    votedby:array[1..255] of integer; { #'s of users that have voted on him, so they can't vote more than once }
    exists:boolean;                   { Still exists to be voted upon? }
    commentptr:longint;               { Pointer to comments in comment file }
    res:array[1..10] of byte;         { RESERVED }
  end;                                { ----------------------------------- }

  nuvcomrec=                          { NUVCMNT .DAT : NUV comment file     }
  record                              { ----------------------------------- }
    user:string[40];                  { User that left comment              }
    comm:astr;                        { Actual comment                      }
    nextcomment:longint;              { Pointer to next comment             }
    exists:boolean;                   { Does comment actually exist         }
    res:array[1..50] of byte;         { RESERVED                            }
  end;                                { ----------------------------------- }

 confrec=                             { CONF    .DAT : Conference File      }
  record                              { ----------------------------------- }
   key: char;                         { Conference letter / symbol          }
   desc:string;                       { Conference discription              }
   acs:acstring;                      { Required ACS to see/join            }
  end;                                { ----------------------------------- }

  Mcirec =                            { ----------------------------------- }
  Record                              { ----------------------------------- }
    mci:string[5];                    { ----------------------------------- }
    STR:STRING[80];                   { ----------------------------------- }
    len:byte;                         { ----------------------------------- }
    pw:boolean;                       { ----------------------------------- }
  END;                                { ----------------------------------- }

  TYPE MCIS=ARRAY[1..30] OF MCIREC;   { ----------------------------------- }
