{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}
                     {       Unit:   WinTTT5          }
                     {--------------------------------}

{History:    03/05/89   5.00a  corrected Get_ScreenWord procedure
             04/01/89   5.01   added DOS errorlevel 10 on fatal
                               and corrected screen scroll
}

{$S-,R-,V-,D-}       

UNIT  WinTTT5;

INTERFACE

USES CRT,DOS,FastTTT5,KeyTTT5;

TYPE
  Direction = (Up, Down, Left, Right);
CONST
  Shadow = 5;
VAR
  Shadcolor    : BYTE;
  DisplayLines : BYTE;

PROCEDURE MoveFromScreen(VAR Source,Dest;LENGTH:WORD);
PROCEDURE MoveToScreen(VAR Source,Dest; LENGTH:WORD);
PROCEDURE SizeCursor(Top,Bot:BYTE);
PROCEDURE FindCursor(VAR X,Y,Top,Bot:BYTE);
PROCEDURE PosCursor(X,Y: INTEGER);
PROCEDURE Fullcursor;
PROCEDURE HalfCursor;
PROCEDURE OnCursor;
PROCEDURE OffCursor;
PROCEDURE GotoXY(X,Y : BYTE);
FUNCTION  WhereX: BYTE;
FUNCTION  WhereY: BYTE;
FUNCTION  GetScreenChar(X,Y:BYTE):CHAR;
FUNCTION  GetScreenAttr(X,Y:BYTE):BYTE;
PROCEDURE GetScreenStr(X1,X2,Y:BYTE;VAR  St:StrScreen);
PROCEDURE CreateScreen(Page:BYTE;Lines:BYTE);
PROCEDURE SaveScreen(Page:BYTE);
PROCEDURE RestoreScreen(Page:BYTE);
PROCEDURE PartRestoreScreen(Page,X1,Y1,X2,Y2,X,Y:BYTE);
PROCEDURE SlideRestoreScreen(Page:BYTE;Way:Direction);
PROCEDURE PartSlideRestoreScreen(Page:BYTE;Way:Direction;X1,Y1,X2,Y2:BYTE);
PROCEDURE DisposeScreen(Page:BYTE);
PROCEDURE SetCondensedLines;
PROCEDURE Set25Lines;
PROCEDURE CopyScreenBlock(X1,Y1,X2,Y2,X,Y:BYTE);
PROCEDURE MoveScreenBlock(X1,Y1,X2,Y2,X,Y:BYTE);
PROCEDURE Scroll(Way:Direction;X1,Y1,X2,Y2:BYTE);
PROCEDURE PartSave(X1,Y1,X2,Y2:BYTE; VAR Dest);
PROCEDURE PartRestore(X1,Y1,X2,Y2:BYTE; VAR Source);
PROCEDURE Mkwin(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
PROCEDURE GrowMkwin(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
PROCEDURE Rmwin;
PROCEDURE FillScreen(X1,Y1,X2,Y2:BYTE; F,B:BYTE; C:CHAR);
PROCEDURE TempMessageCh(X,Y,F,B:INTEGER;St:StrScreen;VAR Ch : CHAR);
PROCEDURE TempMessage(X,Y,F,B:INTEGER;St:StrScreen);
PROCEDURE TempMessageBoxCh(X1,Y1,F,B,boxtype:INTEGER;St:StrScreen;VAR Ch : CHAR);
PROCEDURE TempMessageBox(X1,Y1,F,B,boxtype:INTEGER;St:StrScreen);
PROCEDURE Activate_Visible_Screen;
PROCEDURE Activate_Virtual_Screen(Page:BYTE);
PROCEDURE Reset_StartUp_Mode;

CONST
  Max_Windows = 10;          {Change this constant as necessary}
  Max_Screens = 10;          {Change this constant as necessary}
  WindowCounter : BYTE = 0;
  ScreenCounter : BYTE = 0;
  ActiveVScreen: BYTE = 0;

TYPE
  ScreenImage = RECORD
                  CursorX : BYTE;
                  CursorY : BYTE;
                  ScanTop : BYTE;
                  ScanBot : BYTE;
                  SavedLines:BYTE;
                  ScreenPtr: POINTER;
                END;
  ScreenPtr = ^ScreenImage;
  WindowImage = RECORD
                  ScreenPtr: POINTER;             {pointer to screen data}
                  Coord    : ARRAY[1..4] OF BYTE; {window coords}
                  CursorX  : BYTE;                {cursor location}
                  CursorY  : BYTE;
                  ScanTop  : BYTE;                {cursor shape}
                  ScanBot  : BYTE;
                END;
  WindowPtr = ^WindowImage;

VAR
  Screen : ARRAY[1..Max_Screens] OF ScreenPtr;
  Win    : ARRAY[1..Max_Windows] OF WindowPtr;
  W_error: INTEGER;     {Global error to report winTTT errors}
  W_fatal: BOOLEAN;

IMPLEMENTATION

CONST
  MonoAdr =$b000;
VAR
  StartTop,      {used to record initial screen state when program is run}
  StartBot   : BYTE;
  StartMode  : WORD;

{$L WINTTT5}

{$F+}
  PROCEDURE MoveFromScreen(VAR Source,Dest;LENGTH:WORD); EXTERNAL;
  PROCEDURE MoveToScreen(VAR Source,Dest; LENGTH:WORD); EXTERNAL;
{$F-}

  PROCEDURE WinTTT_Error(No : BYTE);
{Updates W_error and optionally displays error message then halts program}
  VAR Msg : STRING;
  BEGIN
  W_error := No;
  IF W_fatal = TRUE THEN
    BEGIN
    CASE No OF
      1 :  Msg := 'Max screens exceeded';
      2 :  Msg := 'Max Windows Exceeded';
      3 :  Msg := 'Insufficient memory to create screen';
      4 :  Msg := 'Screen not saved cannot activate.';
      5 :  Msg := 'Screen has not been created - cannot activate';
      6 :  Msg := 'Screen has not been created - cannot dispose';
      7 :  Msg := 'Screen has not been created - cannot restore';
      8 :  Msg := 'Screen does not exist cannot clear';
      9 :  Msg := 'Insufficient memory for Screen Copy/Move';
      10:  Msg := 'Visible screen must be active for Window operations';
      11:  Msg := 'Visible screen must be active for Message operations';
      12:; {reserved for non-fatal error settings condensed mode}
      13:  Msg := 'Can only save 25 screen lines - check CONST SavedLines';
      ELSE Msg := '?) -- Utterly confused';
    END; {Case}
    Msg := 'Fatal Error (WinTTT -- '+Msg;
    WRITELN(Msg);
    delay(5000);    {display long enough to read if child process}
    HALT(11);       {returns DOS ERRORLEVEL 11}
    END;
  END;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                                     }
{     V I S I B L E    a n d    V I R T U A L  P R O C E D U R E S    }
{                                                                     }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
  PROCEDURE PartSave (X1,Y1,X2,Y2:BYTE; VAR Dest);
{transfers data from active virtual screen to Dest}
  VAR
    I,width : BYTE;
    ScreenAdr: INTEGER;
  BEGIN
  width := SUCC(X2- X1);
  FOR I :=  Y1 TO Y2 DO
    BEGIN
    ScreenAdr := VOfs + PRED(I)*160 + PRED(X1)*2;
    MoveFromScreen(MEM[VSeg:ScreenAdr],
                   MEM[SEG(Dest):OFS(Dest)+(I-Y1)*width*2],
                   width);
    END;
  END;

  PROCEDURE PartRestore (X1,Y1,X2,Y2:BYTE; VAR Source);
{restores data from Source and transfers to active virtual screen}
  VAR
    I,width : BYTE;
    ScreenAdr: INTEGER;
  BEGIN
  width := SUCC(X2- X1);
  FOR I :=  Y1 TO Y2 DO
    BEGIN
    ScreenAdr := VOfs + PRED(I)*160 + PRED(X1)*2;
    MoveToScreen(MEM[SEG(Source):OFS(Source)+(I-Y1)*width*2],
                 MEM[VSeg:ScreenAdr],
                 width);
    END;
  END;

  PROCEDURE FillScreen(X1,Y1,X2,Y2:BYTE; F,B:BYTE; C:CHAR);
  VAR
    I : INTEGER;
    S : STRING;
  BEGIN
  W_error := 0;
  Attrib(X1,Y1,X2,Y2,F,B);
  S := Replicate(SUCC(X2-X1),C);
  FOR I := Y1 TO Y2 DO
    PlainWrite(X1,I,S);
  END;

  PROCEDURE GetScreenWord(X,Y:BYTE;VAR Attr:BYTE; VAR Ch : CHAR);
{updates vars Attr and Ch with attribute and character bytes in screen
 location (X,Y) of the active screen}
  TYPE
    ScreenWordRec = RECORD
                      Ch   : CHAR;   {5.00a}
                      Attr : BYTE;
                    END;
  VAR
    ScreenAdr: INTEGER;
    SW : ScreenWordRec;
  BEGIN
  ScreenAdr := VOfs + PRED(Y)*160 + PRED(X)*2;
  MoveFromScreen(MEM[VSeg:ScreenAdr],MEM[SEG(SW):OFS(SW)],1);
  Attr := SW.Attr;
  Ch   := SW.Ch;
  END;

  FUNCTION GetScreenChar(X,Y:BYTE):CHAR;
  VAR
    A : BYTE;
    C : CHAR;
  BEGIN
  GetScreenWord(X,Y,A,C);
  GetScreenChar := C;
  END;

  FUNCTION GetScreenAttr(X,Y:BYTE):BYTE;
  VAR
    A : BYTE;
    C : CHAR;
  BEGIN
  GetScreenWord(X,Y,A,C);
  GetScreenAttr := A;
  END;

  PROCEDURE GetScreenStr(X1,X2,Y:BYTE;VAR  St:StrScreen);
  VAR
    I : INTEGER;
  BEGIN
  St := '';
  FOR I := X1 TO X2 DO
    St := St + GetScreenChar(I,Y);
  END;

{++++++++++++++++++++++++++++++++++++++++++++++}
{                                              }
{         C U R S O R    R O U T I N E S       }
{                                              }
{++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE GotoXY(X,Y : BYTE);
{intercepts normal Turbo GotoXY procedure, in case a virtual screen
 is active.
}
  BEGIN
  IF VSeg = BaseOfScreen THEN
    CRT.GotoXY(X,Y)
  ELSE
    WITH Screen[ActiveVScreen]^ DO
      BEGIN
      CursorX := X;
      CursorY := Y;
      END; {with}
  END;  {proc GotoXY}

  FUNCTION WhereX: BYTE;
{intercepts normal Turbo WhereX procedure, in case a virtual screen
 is active.
}
  BEGIN
  IF VSeg = BaseOfScreen THEN
    WhereX := CRT.WhereX
  ELSE
    WITH Screen[ActiveVScreen]^ DO
      WhereX := CursorX;
  END; {of func WhereX}

  FUNCTION WhereY: BYTE;
{intercepts normal Turbo WhereX procedure, in case a virtual screen
 is active.
}
  BEGIN
  IF VSeg = BaseOfScreen THEN
    WhereY := CRT.WhereY
  ELSE
    WITH Screen[ActiveVScreen]^ DO
      WhereY := CursorY;
  END; {of func WhereY}

  PROCEDURE FindCursor(VAR X,Y,Top,Bot:BYTE);
  VAR
    Reg : registers;
  BEGIN
  IF VSeg = BaseOfScreen THEN    {visible screen is active}
    BEGIN   
    Reg.Ax := $0F00;              {get page in Bx}
    Intr($10,Reg);
    Reg.Ax := $0300;
    Intr($10,Reg);
    WITH Reg DO
      BEGIN
      X := LO(Dx) + 1;
      Y := HI(Dx) + 1;
      Top := HI(Cx) AND $0F;
      Bot := LO(Cx) AND $0F;
      END;
    END
  ELSE                            {virtual screen active}
    WITH Screen[ActiveVScreen]^ DO
      BEGIN
      X := CursorX;
      Y := CursorY;
      Top := ScanTop;
      Bot := ScanBot;
      END;
  END;

  PROCEDURE PosCursor(X,Y: INTEGER);
  VAR Reg : registers;
  BEGIN
  IF VSeg = BaseOfScreen THEN    {visible screen is active}
    BEGIN   
    Reg.Ax := $0F00;              {get page in Bx}
    Intr($10,Reg);
    WITH Reg DO
      BEGIN
      Ax := $0200;
      Dx := ((Y-1) SHL 8) OR ((X-1) AND $00FF);
      END;
    Intr($10,Reg);
    END
  ELSE                           {virtual screen active}
    WITH Screen[ActiveVScreen]^ DO
      BEGIN
      CursorX := X;
      CursorY := Y;
      END;
  END;

  PROCEDURE SizeCursor(Top,Bot:BYTE);
  VAR Reg : registers;
  BEGIN
  IF VSeg = BaseOfScreen THEN    {visible screen is active}
    WITH Reg DO
      BEGIN
      Ax := 1 SHL 8;
      Cx := Top SHL 8 + Bot;
      Intr($10,Reg);
      END
  ELSE                           {virtual screen active}
    WITH Screen[ActiveVScreen]^ DO
      BEGIN
      ScanTop := Top;
      ScanBot := Bot;
      END;
  END;

  PROCEDURE HalfCursor;
  BEGIN
  IF BaseOfScreen = MonoAdr THEN    
    SizeCursor(8,13)    
  ELSE
    SizeCursor(4,7);    
  END; {Proc HalfCursor}

  PROCEDURE Fullcursor;
  BEGIN
  IF BaseOfScreen = MonoAdr THEN
    SizeCursor(0,13)
  ELSE
    SizeCursor(0,7);
  END;

  PROCEDURE OnCursor;
  BEGIN
  IF BaseOfScreen = MonoAdr THEN
    SizeCursor(12,13)
  ELSE
    SizeCursor(6,7);
  END;

  PROCEDURE OffCursor;
  BEGIN
  SizeCursor(14,0);
  END;

{++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                    }
{   S C R E E N   S A V I N G  R O U T I N E S       }
{                                                    }
{++++++++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE DisposeScreen(Page:BYTE);
{Free memory and set pointer to nil}
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(6);
    EXIT;
    END
  ELSE
    W_error := 0;
  FREEMEM(Screen[Page]^.ScreenPtr,Screen[Page]^.SavedLines*160);
  FREEMEM(Screen[Page],SIZEOF(Screen[Page]^));
  Screen[Page] := NIL;
  IF ActiveVScreen = Page THEN
    Activate_Visible_Screen;
  DEC(ScreenCounter);
  END;

  PROCEDURE SaveScreen(Page:BYTE);
{Save screen display and cursor details}
  BEGIN
  IF (Page > Max_Screens) THEN
    BEGIN
    WinTTT_Error(1);
    EXIT;
    END;
  IF ((Screen[Page] <> NIL) AND (DisplayLines <> Screen[Page]^.SavedLines)) THEN
    DisposeScreen(Page);
  IF Screen[Page] = NIL THEN            {need to allocate memory}
    BEGIN
    IF MAXAVAIL < SIZEOF(Screen[Page]^) THEN
      BEGIN
      WinTTT_Error(3);
      EXIT;
      END;
    GETMEM(Screen[Page],SIZEOF(Screen[Page]^));
    IF MAXAVAIL < DisplayLines*160 THEN     {do check in two parts 'cos Maxavail is not same as MemAvail}
      BEGIN
      WinTTT_Error(3);
      FREEMEM(Screen[Page],SIZEOF(Screen[Page]^));
      Screen[Page] := NIL;
      EXIT;
      END;
    GETMEM(Screen[Page]^.ScreenPtr,DisplayLines*160);
    INC(ScreenCounter);
    END;
  WITH Screen[Page]^ DO
    BEGIN
    FindCursor(CursorX,CursorY,ScanTop,ScanBot);     {Save Cursor posn. and shape}
    SavedLines := DisplayLines;
    MoveFromScreen(MEM[BaseOfScreen:0],Screen[Page]^.ScreenPtr^,DisplayLines*80);
    END;
  W_error := 0;
  END;

  PROCEDURE RestoreScreen(Page:BYTE);
{Display a screen that was previously saved}
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(7);
    EXIT;
    END
  ELSE
    W_error := 0;
  WITH Screen[Page]^ DO
    BEGIN
    MoveToScreen(ScreenPtr^,MEM[BaseOfScreen:0], 80*SavedLines);
    PosCursor(CursorX,CursorY);
    SizeCursor(ScanTop,ScanBot);
    END;
  END;  {Proc RestoreScreen}


  PROCEDURE PartRestoreScreen(Page,X1,Y1,X2,Y2,X,Y:BYTE);
{Move from heap to screen, part of saved screen}
  VAR
    I,width     : BYTE;
    ScreenAdr,
    PageAdr     : INTEGER;
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(7);
    EXIT;
    END
  ELSE
    W_error := 0;
  width := SUCC(X2- X1);
  FOR I :=  Y1 TO Y2 DO
    BEGIN
    ScreenAdr := PRED(Y+I-Y1)*160 + PRED(X)*2;
    PageAdr   := PRED(I)*160 + PRED(X1)*2;
    MoveToScreen(MEM[SEG(Screen[Page]^.ScreenPtr^):OFS(Screen[Page]^.ScreenPtr^)+PageAdr],
                 MEM[BaseOfScreen:ScreenAdr],
                 width);
    END;
  END;

  PROCEDURE SlideRestoreScreen(Page:BYTE;Way:Direction);
{Display a screen that was previously saved, with fancy slide}
  VAR I : BYTE;
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(7);
    EXIT;
    END
  ELSE
    W_error := 0;
  CASE Way OF
    Up    : BEGIN
            FOR I := DisplayLines DOWNTO 1 DO
              BEGIN
              PartRestoreScreen(Page,
                                1,1,80,SUCC(DisplayLines -I),
                                1,I);
              delay(50);
              END;
            END;
    Down  : BEGIN
            FOR I := 1 TO DisplayLines DO
              BEGIN
              PartRestoreScreen(Page,
                                1,SUCC(DisplayLines -I),80,DisplayLines,
                                1,1);
              delay(50);  {savor the moment!}
              END;
            END;
    Left  : BEGIN
            FOR I := 1 TO 80 DO
              BEGIN
              PartRestoreScreen(Page,
                                1,1,I,DisplayLines,
                                SUCC(80-I),1);
              END;
            END;
    Right : BEGIN
            FOR I := 80 DOWNTO 1 DO
              BEGIN
              PartRestoreScreen(Page,
                                I,1,80,DisplayLines,
                                1,1);
              END;
            END;
  END; {case}
  PosCursor(Screen[Page]^.CursorX,Screen[Page]^.CursorY);
  SizeCursor(Screen[Page]^.ScanTop,Screen[Page]^.ScanBot);
  END;   {Proc SlideRestoreScreen}


  PROCEDURE PartSlideRestoreScreen(Page:BYTE;Way:Direction;X1,Y1,X2,Y2:BYTE);
{Display a screen that was previously saved, with fancy slide}
  VAR I : BYTE;
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(7);
    EXIT;
    END
  ELSE
    W_error := 0;
  CASE Way OF
    Up    : BEGIN
            FOR I := Y2 DOWNTO Y1 DO
              BEGIN
              PartRestoreScreen(Page,
                                X1,Y1,X2,Y1+Y2-I,
                                X1,I);
              delay(50);
              END;
            END;
    Down  : BEGIN
            FOR I := Y1 TO Y2 DO
              BEGIN
              PartRestoreScreen(Page,
                                X1,Y1+Y2 -I,X2,Y2,
                                X1,Y1);
              delay(50);  {savor the moment!}
              END;
            END;
    Left  : BEGIN
            FOR I := X1 TO X2 DO
              BEGIN
              PartRestoreScreen(Page,
                                X1,Y1,I,Y2,
                                X1+X2-I,Y1);
              END;
            END;
    Right : BEGIN
            FOR I := X2 DOWNTO X1 DO
              BEGIN
              PartRestoreScreen(Page,
                                I,Y1,X2,Y2,
                                X1,Y1);
              END;
            END;
  END; {case}
  END;   {Proc PartSlideRestoreScreen}


{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                                              }
{     V I R T U A L    S C R E E N    S P E C I F I C   P R O C E D U R E S    }
{                                                                              }
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE Clear_Vscreen(Page:BYTE);
  VAR
    Tseg, Tofs : WORD;
  BEGIN
  IF Screen[Page] = NIL THEN
    BEGIN
    WinTTT_Error(8);
    EXIT;
    END
  ELSE
    W_error := 0;
  Tseg := VSeg;
  Tofs := VOfs;
  VSeg := SEG(Screen[Page]^.ScreenPtr^);
  VOfs := OFS(Screen[Page]^.ScreenPtr^);
  ClearText(1,1,80,Screen[Page]^.SavedLines,yellow,black);
  VSeg := Tseg;
  VOfs := Tofs;
  END;

  PROCEDURE CreateScreen(Page:BYTE;Lines:BYTE);
  BEGIN
  W_error := 0;
  IF (Page > Max_Screens) THEN
    BEGIN
    WinTTT_Error(1);
    EXIT;
    END;
  IF ((Screen[Page] <> NIL) AND (Lines <> Screen[Page]^.SavedLines)) THEN
    DisposeScreen(Page);
  IF Screen[Page] = NIL THEN            {need to allocate memory}
    BEGIN
    IF MAXAVAIL < SIZEOF(Screen[Page]^) THEN
      BEGIN
      WinTTT_Error(3);
      EXIT;
      END;
    GETMEM(Screen[Page],SIZEOF(Screen[Page]^));
    IF MAXAVAIL < Lines*160 THEN     {do check in two parts 'cos Maxavail is not same as MemAvail}
      BEGIN
      WinTTT_Error(3);
      FREEMEM(Screen[Page],SIZEOF(Screen[Page]^));
      Screen[Page] := NIL;
      EXIT;
      END;
    GETMEM(Screen[Page]^.ScreenPtr,Lines*160);
    INC(ScreenCounter);
    END;
  WITH Screen[Page]^ DO
    BEGIN
    IF BaseOfScreen = $B000 THEN
      BEGIN
      ScanTop := 12;
      ScanBot := 13;
      END
    ELSE
      BEGIN
      ScanTop := 6;
      ScanBot := 7;
      END;
    CursorX := 1;
    CursorY := 1;
    SavedLines := Lines;
    Clear_Vscreen(Page);
    END;
  END;

  PROCEDURE Activate_Visible_Screen;
  BEGIN
  VSeg := BaseOfScreen;
  VOfs := 0;
  ActiveVScreen := 0;
  END;

  PROCEDURE Activate_Virtual_Screen(Page:BYTE);
{Page zero signifies the visible screen}
  BEGIN
  IF Screen[Page] = NIL THEN
    WinTTT_Error(4)
  ELSE
    BEGIN
    W_error := 0;
    IF Page = 0 THEN
      Activate_Visible_Screen
    ELSE
      BEGIN
      VSeg := SEG(Screen[Page]^.ScreenPtr^);
      VOfs := OFS(Screen[Page]^.ScreenPtr^);
      ActiveVScreen := Page;
      END;
    END;
  END;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                                                                              }
{     V I S I B L E    S C R E E N    S P E C I F I C   P R O C E D U R E S    }
{                                                                              }
{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE SetCondensedLines;
  BEGIN
  IF EGAVGASystem THEN
    BEGIN
    W_error := 0;
    TextMode(LO(LastMode)+Font8x8);
    DisplayLines := SUCC(HI(WindMax));
    END
  ELSE
    W_error := 12;
  END;  {proc SetCondensedDisplay}

  PROCEDURE Set25Lines;
  BEGIN
  TextMode(LO(LastMode));
  DisplayLines := SUCC(HI(WindMax));
  END;


  PROCEDURE CopyScreenBlock(X1,Y1,X2,Y2,X,Y:BYTE);
{copies text and attributes from one part of screen to another}
  VAR
    S : WORD;
    SPTR : POINTER;
  BEGIN
  W_error := 0;
  S := SUCC(Y2-Y1)*SUCC(X2-X1)*2;
  IF MAXAVAIL < S THEN
    WinTTT_Error(9)
  ELSE
    BEGIN
    GETMEM(SPTR,S);
    PartSave(X1,Y1,X2,Y2,SPTR^);
    PartRestore(X,Y,X+X2-X1,Y+Y2-Y1,SPTR^);
    FREEMEM(SPTR,S);
    END;
  END; {CopyScreenBlock}

  PROCEDURE MoveScreenBlock(X1,Y1,X2,Y2,X,Y:BYTE);
{Moves text and attributes from one part of screen to another,
 replacing with Replace_Char}
  CONST
    Replace_Char = ' ';
  VAR
    S : WORD;
    SPTR : POINTER;
    I : INTEGER;
    St : STRING;
  BEGIN
  W_error := 0;
  S := SUCC(Y2-Y1)*SUCC(X2-X1)*2;
  IF MAXAVAIL < S THEN
    WinTTT_Error(9)
  ELSE
    BEGIN
    GETMEM(SPTR,S);
    PartSave(X1,Y1,X2,Y2,SPTR^);
    St := Replicate(SUCC(X2-X1),Replace_Char);
    FOR I := Y1 TO Y2 DO
      PlainWrite(X1,I,St);
    PartRestore(X,Y,X+X2-X1,Y+Y2-Y1,SPTR^);
    FREEMEM(SPTR,S);
    END;
  END; {Proc MoveScreenBlock}

  PROCEDURE Scroll(Way:Direction;X1,Y1,X2,Y2:BYTE);
{used for screen scrolling, uses Copy & Plainwrite for speed}
  CONST
    Replace_Char = ' ';
  VAR
    I : INTEGER;
  BEGIN
  W_error := 0;
  CASE Way OF
    Up   : BEGIN
           CopyScreenBlock(X1,SUCC(Y1),X2,Y2,X1,Y1);
           PlainWrite(X1,Y2,Replicate(SUCC(X2-X1),Replace_Char));
           END;
    Down : BEGIN
           CopyScreenBlock(X1,Y1,X2,PRED(Y2),X1,SUCC(Y1));
           PlainWrite(X1,Y1,Replicate(SUCC(X2-X1),Replace_Char));
           END;
    Left : BEGIN
           CopyScreenBlock(SUCC(X1),Y1,X2,Y2,X1,Y1);
           FOR I := Y1 TO Y2 DO
             PlainWrite(X2,I,Replace_Char);   {5.01}
           END;
    Right: BEGIN
           CopyScreenBlock(X1,Y1,PRED(X2),Y2,SUCC(X1),Y1);
           FOR I := Y1 TO Y2 DO
             PlainWrite(X1,I,Replace_Char);   {5.01}
           END;
  END; {case}
  END;

  PROCEDURE CreateWin(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
{called by MkWin and GrowMkWin}
  BEGIN
  IF WindowCounter >= Max_Windows THEN
    BEGIN
    WinTTT_Error(2);
    EXIT;
    END;
  IF MAXAVAIL < SIZEOF(Win[WindowCounter]^) THEN
    BEGIN
    WinTTT_Error(3);
    EXIT;
    END
  ELSE
    W_error := 0;
  INC(WindowCounter);
  GETMEM(Win[WindowCounter],SIZEOF(Win[WindowCounter]^));    {allocate space}
  IF (boxtype IN [5..9]) AND (X1 > 1) THEN     {is there a drop shadow}
    BEGIN
    X1 := PRED(X1);    {increase dimensions for the box}
    Y2 := SUCC(Y2);
    END;
  IF MAXAVAIL < SUCC(Y2-Y1)*SUCC(X2-X1)*2 THEN
    BEGIN
    WinTTT_Error(3);
    EXIT;
    END;
  GETMEM(Win[WindowCounter]^.ScreenPtr,SUCC(Y2-Y1)*SUCC(X2-X1)*2);
  PartSave(X1,Y1,X2,Y2,Win[WindowCounter]^.ScreenPtr^);
  WITH Win[WindowCounter]^ DO
    BEGIN
    Coord[1] := X1;
    Coord[2] := Y1;
    Coord[3] := X2;
    Coord[4] := Y2;
    FindCursor(CursorX,CursorY,ScanTop,ScanBot);
    END;  {with}
  END; {Proc CreateWin}

  PROCEDURE Mkwin(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
{Main procedure for creating window}
  VAR I : INTEGER;
  BEGIN
  IF ActiveVScreen <> 0 THEN
    BEGIN
    W_error := 10;
    EXIT;
    END
  ELSE
    W_error := 0;
  CreateWin(X1,Y1,X2,Y2,F,B,boxtype);
  IF (boxtype IN [5..9]) AND (X1 > 1) THEN
    FBox(X1,Y1,X2,Y2,F,B,boxtype-Shadow)
  ELSE
    FBox(X1,Y1,X2,Y2,F,B,boxtype);
  IF (boxtype IN [5..9]) AND (X1 > 1) THEN     {is there a drop shadow}
    BEGIN
    FOR I := SUCC(Y1) TO SUCC(Y2) DO
      WriteAT(PRED(X1),I,Shadcolor,black,CHR(219));
    WriteAT(X1,SUCC(Y2),Shadcolor,black,
            Replicate(X2-SUCC(X1),CHR(219)));
    END;
  END;

  PROCEDURE GrowMkwin(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
{same as MKwin but window explodes}
  VAR I : INTEGER;
  BEGIN
  IF ActiveVScreen <> 0 THEN
    BEGIN
    W_error := 10;
    EXIT;
    END
  ELSE
    W_error := 0;
  CreateWin(X1,Y1,X2,Y2,F,B,boxtype);
  IF (boxtype IN [5..9]) AND (X1 > 1) THEN
    GrowFBox(X1,Y1,X2,Y2,F,B,boxtype-Shadow)
  ELSE
    GrowFBox(X1,Y1,X2,Y2,F,B,boxtype);
  IF (boxtype IN [5..9]) AND (X1 > 1) THEN     {is there a drop shadow}
    BEGIN
    FOR I := SUCC(Y1) TO SUCC(Y2) DO
      WriteAT(PRED(X1),I,Shadcolor,black,CHR(219));
    WriteAT(X1,SUCC(Y2),Shadcolor,black,
            Replicate(X2-SUCC(X1),CHR(219)));
    END;
  END;

  PROCEDURE Rmwin;
  BEGIN
  IF ActiveVScreen <> 0 THEN
    BEGIN
    W_error := 10;
    EXIT;
    END
  ELSE
    W_error := 0;
  IF WindowCounter > 0 THEN
    BEGIN
    WITH  Win[WindowCounter]^ DO
      BEGIN
      PartRestore(Coord[1],Coord[2],Coord[3],Coord[4],ScreenPtr^);
      PosCursor(CursorX,CursorY);
      SizeCursor(ScanTop,ScanBot);
      FREEMEM(ScreenPtr,SUCC(Coord[4]-Coord[2])*SUCC(Coord[3]-Coord[1])*2);
      FREEMEM(Win[WindowCounter],SIZEOF(Win[WindowCounter]^));
      END; {with}
    DEC(WindowCounter);
    END;
  END;

  PROCEDURE TempMessageCh(X,Y,F,B:INTEGER;St:StrScreen;VAR Ch : CHAR);
  VAR
    Cx,CY,CT,CB,I,locC:INTEGER;
    SavedLine : ARRAY[1..160] OF BYTE;
  BEGIN
  IF ActiveVScreen <> 0 THEN
    BEGIN
    W_error := 11;
    EXIT;
    END
  ELSE
    W_error := 0;
  PartSave(X,Y,PRED(X)+LENGTH(St),Y,SavedLine);
  WriteAT(X,Y,F,B,St);
  Ch := GetKey;
  PartRestore(X,Y,PRED(X)+LENGTH(St),Y,SavedLine);
  END;

  PROCEDURE TempMessage(X,Y,F,B:INTEGER;St:StrScreen);
  VAR Ch : CHAR;
  BEGIN
  TempMessageCh(X,Y,F,B,St,Ch);
  END;              

  PROCEDURE TempMessageBoxCh(X1,Y1,F,B,boxtype:INTEGER;St:StrScreen;VAR Ch : CHAR);
  BEGIN
  IF ActiveVScreen <> 0 THEN
    BEGIN
    W_error := 11;
    EXIT;
    END
  ELSE
    W_error := 0;
  Mkwin(X1,Y1,SUCC(X1)+LENGTH(St),Y1+2,F,B,boxtype);
  WriteAT(SUCC(X1),SUCC(Y1),F,B,St);
  Ch := GetKey;
  Rmwin;
  END;

  PROCEDURE TempMessageBox(X1,Y1,F,B,boxtype:INTEGER;St:StrScreen);
  VAR Ch : CHAR;
  BEGIN
  TempMessageBoxCh(X1,Y1,F,B,boxtype,St,Ch);
  END;

{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE InitWinTTT;
{set Pointers to nil for validity checking}
  VAR
    I : INTEGER;
    X,Y : BYTE;
  BEGIN
  FOR I := 1 TO Max_Screens DO
    Screen[I] := NIL;
  StartMode := LastMode;           { record the initial state of screen when program was executed}
  DisplayLines := SUCC(HI(WindMax));
  FindCursor(X,Y,StartTop,StartBot);
  END;


  PROCEDURE Reset_StartUp_Mode;
{resets monitor mode and cursor settings to the state they
 were in at program startup}
  BEGIN
  TextMode(StartMode);
  SizeCursor(StartTop,StartBot);
  END; {proc StartUp_Mode}

BEGIN
InitWinTTT;
W_error := 0;
W_fatal := FALSE;   {don't terminate program if fatal error}
Shadcolor := darkgray;
END.
