{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}                                       
                     {       Unit:   KeyTTT5          }
                     {--------------------------------}


{$S-,R-,V-,D-}       

UNIT KeyTTT5;
(*
{$DEFINE K_FULL}
*)
INTERFACE

USES CRT, DOS;

TYPE
  Button = (NoB,LeftB,RightB,BothB);

{$IFNDEF VER40}
  Key_Idle_Type = PROCEDURE;
  Key_Pressed_Type = PROCEDURE(VAR Ch:CHAR);
{$ENDIF}

  Key_Hooks = RECORD
{$IFNDEF VER40}
                Idle_Hook:    Key_Idle_Type;
                Pressed_Hook: Key_Pressed_Type;
{$ENDIF}
                Click       : BOOLEAN;           {tactile keyboard click}
              END;


VAR
  Moused : BOOLEAN;
  Horiz_Sensitivity : INTEGER;
  KTTT : Key_Hooks;      {used in getkey to jump to external procedure}

{$IFDEF VER40}
  Idle_Hook   : pointer;
  Pressed_Hook: pointer;
{$ENDIF}

{$IFDEF K_FULL}
{if}
{if}           CONST
{if}           BackSp  = #8;       PgUp  = #201;      CtrlPgUp = #138;
{if}           Tab     = #9;       PgDn  = #209;      CtrlPgDn = #246;
{if}           Enter   = #13;      Endkey= #207;      CtrlEnd  = #245;
{if}           Esc     = #27;      Home  = #199;      CtrlHome = #247;
{if}           STab    = #143;     Ins   = #210;      Del      = #211;
{if}
{if}           LArr    = #203;      CtrlLArr    = #243;    CtrlPrtsc = #242;
{if}           RArr    = #205;      CtrlRArr    = #244;
{if}           UArr    = #200;
{if}           DArr    = #208;
{if}
{if}
{if}           CtrlA  = #1;          AltA  = #158;        Alt1 = #248;
{if}           CtrlB  = #2;          AltB  = #176;        Alt2 = #249;
{if}           CtrlC  = #3;          AltC  = #174;        Alt3 = #250;
{if}           CtrlD  = #4;          AltD  = #160;        Alt4 = #251;
{if}           CtrlE  = #5;          AltE  = #146;        Alt5 = #252;
{if}           CtrlF  = #6;          AltF  = #161;        Alt6 = #253;
{if}           CtrlG  = #7;          AltG  = #162;        Alt7 = #254;
{if}           CtrlH  = #8;          AltH  = #163;        Alt8 = #255;
{if}           CtrlI  = #9;          AltI  = #151;        Alt9 = #134;
{if}           CtrlJ  = #10;         AltJ  = #164;        Alt0 = #135;
{if}           CtrlK  = #11;         AltK  = #165;        Altminus  = #136;
{if}           CtrlL  = #12;         AltL  = #166;        Altequals = #137;
{if}           CtrlM  = #13;         AltM  = #178;
{if}           CtrlN  = #14;         AltN  = #177;
{if}           CtrlO  = #15;         AltO  = #152;
{if}           CtrlP  = #16;         AltP  = #153;
{if}           CtrlQ  = #17;         AltQ  = #144;
{if}           CtrlR  = #18;         AltR  = #147;
{if}           CtrlS  = #19;         AltS  = #159;
{if}           CtrlT  = #20;         AltT  = #148;
{if}           CtrlU  = #21;         AltU  = #150;
{if}           CtrlV  = #22;         AltV  = #175;
{if}           CtrlW  = #23;         AltW  = #145;
{if}           CtrlX  = #24;         AltX  = #173;
{if}           CtrlY  = #25;         AltY  = #149;
{if}           CtrlZ  = #26;         AltZ  = #172;
{if}
{if}           F1  = #187;              sF1  = #212;
{if}           F2  = #188;              sF2  = #213;
{if}           F3  = #189;              sF3  = #214;
{if}           F4  = #190;              sF4  = #215;
{if}           F5  = #191;              sF5  = #216;
{if}           F6  = #192;              sF6  = #217;
{if}           F7  = #193;              sF7  = #218;
{if}           F8  = #194;              sF8  = #219;
{if}           F9  = #195;              sF9  = #220;
{if}           F10 = #196;              sF10 = #221;
{if}           F11 = #139;              sF11 = #141;
{if}           F12 = #140;              sF12 = #142;
{if}
{if}           CtrlF1  = #222;          AltF1  = #232;
{if}           CtrlF2  = #223;          AltF2  = #233;
{if}           CtrlF3  = #224;          AltF3  = #234;
{if}           CtrlF4  = #225;          AltF4  = #235;
{if}           CtrlF5  = #226;          AltF5  = #236;
{if}           CtrlF6  = #227;          AltF6  = #237;
{if}           CtrlF7  = #228;          AltF7  = #238;
{if}           CtrlF8  = #229;          AltF8  = #239;
{if}           CtrlF9  = #230;          AltF9  = #240;
{if}           CtrlF10 = #231;          AltF10 = #241;
{if}           CtrlF11 = #154;          AltF11 = #156;
{if}           CtrlF12 = #155;          AltF12 = #157;
{if}
{if}          {now the TTT mouse keys}
{if}
{if}           MUp     = #128;
{if}           MDown   = #129;
{if}           MLeft   = #130;
{if}           MRight  = #131;
{if}           MLeftB  = #133;
{if}           MEnter  = #133;
{if}           MEsc    = #132;
{if}           MRightB = #132;
{if}
{$ENDIF}  {def K_Const}
{$IFNDEF VER40}
PROCEDURE No_Idle_Hook;
PROCEDURE No_Pressed_Hook(VAR Ch:CHAR);
PROCEDURE Assign_Pressed_Hook(PassedProc : Key_Pressed_Type);
PROCEDURE Assign_Idle_Hook(PassedProc : Key_Idle_Type);
{$ENDIF}
PROCEDURE Set_Clicking(Clicking : BOOLEAN);
PROCEDURE Default_Settings;
FUNCTION  Mouse_Installed:BOOLEAN;
PROCEDURE Show_Mouse_Cursor;
PROCEDURE Hide_Mouse_Cursor;
PROCEDURE Get_Mouse_Action(VAR But: Button; VAR Hor,Ver: INTEGER);
PROCEDURE Move_Mouse(Hor,Ver: INTEGER);
PROCEDURE Confine_Mouse_Horiz(Left,Right:INTEGER);
PROCEDURE Confine_Mouse_Vert(Top,Bot:INTEGER);
PROCEDURE Set_Mouse_Cursor_Style(OrdChar: INTEGER);
FUNCTION  Alt_Pressed:BOOLEAN;
FUNCTION  Ctrl_Pressed:BOOLEAN;
FUNCTION  LeftShift_Pressed: BOOLEAN;
FUNCTION  RightShift_Pressed: BOOLEAN;
FUNCTION  Shift_Pressed: BOOLEAN;
FUNCTION  CapsOn: BOOLEAN;
FUNCTION  NumOn: BOOLEAN;
FUNCTION  ScrollOn: BOOLEAN;
PROCEDURE Set_Caps(On : BOOLEAN);
PROCEDURE Set_Num(On : BOOLEAN);
PROCEDURE Set_Scroll(On : BOOLEAN);
FUNCTION  GetKey : CHAR;
PROCEDURE DelayKey(Time : INTEGER);

IMPLEMENTATION

VAR
  Key_Status_Bits : WORD ABSOLUTE $0040:$0017;

{$IFDEF VER40}
   Procedure Call_Idle_Hook;
          Inline($FF/$1E/Idle_Hook);

   Procedure Call_Pressed_Hook(Var CH : char);
          Inline($FF/$1E/Pressed_Hook);

{$ENDIF}

{$F+}
  PROCEDURE No_Idle_Hook;
 {empty procs}
  BEGIN
  END; {of proc No_Idle_Hook}

  PROCEDURE No_Pressed_Hook(VAR Ch:CHAR);
 {empty procs}
  BEGIN
  END; {of proc No_Pressed_Hook}
{$F-}

{$IFNDEF VER40}
  PROCEDURE Assign_Pressed_Hook(PassedProc : Key_Pressed_Type);
  BEGIN
  KTTT.Pressed_Hook := PassedProc;
  END;

  PROCEDURE Assign_Idle_Hook(PassedProc : Key_Idle_Type);
  BEGIN
  KTTT.Idle_Hook := PassedProc;
  END;
{$ENDIF}

  PROCEDURE Set_Clicking(Clicking : BOOLEAN);
  BEGIN
  KTTT.Click := Clicking;
  END;


  PROCEDURE Default_Settings;
  BEGIN
  WITH KTTT DO
    BEGIN
{$IFNDEF VER40}
    Idle_Hook    := No_Idle_Hook;
    Pressed_Hook := No_Pressed_Hook;
{$ELSE}
             Idle_Hook    := Nil;
             Pressed_Hook := Nil;
{$ENDIF}
    Click := FALSE;
    END;
  END; {of proc Default_Settings}


  FUNCTION Mouse_Installed:BOOLEAN;
  VAR
    Reg: registers;

    FUNCTION Interrupt_loaded:BOOLEAN;
    BEGIN
    Reg.Ax := 0;
    Intr($33,Reg);
    Interrupt_loaded :=  Reg.Ax <> 0;
    END;

  BEGIN
  IF MEMW[$0000:$00CC] = 0 THEN
    Mouse_Installed := FALSE          {don't call interrupt if vector is zero}
  ELSE
    Mouse_Installed := Interrupt_loaded;
  END; {Func Mouse_Installed}

  PROCEDURE Show_Mouse_Cursor;
  VAR
    Reg: registers;
  BEGIN
  Reg.Ax := 1;
  Intr($33,Reg);
  END; {Proc Show_Mouse_Cursor}

  PROCEDURE Hide_Mouse_Cursor;
  VAR
    Reg : registers;
  BEGIN
  Reg.Ax := 2;
  Intr($33,Reg);
  END; {Proc Hide_Mouse_Cursor}

  PROCEDURE Get_Mouse_Action(VAR But: Button; VAR Hor,Ver: INTEGER);
  VAR
    Reg: registers;
  BEGIN
  WITH Reg DO
    BEGIN
    Ax := 3;
    Intr($33,Reg);
    Hor := Cx DIV 8;
    Ver := Dx DIV 8;
        {$B+}
    IF ((Bx AND $1) <> $1)  AND  ((Bx AND $2) <> $2) THEN
      BEGIN
      But := NoB;
      EXIT;
      END;
    IF ((Bx AND $1) = $1)  AND   ((Bx AND $2) = $2) THEN
      But := BothB
    ELSE
      BEGIN
      IF (Bx AND $1) = $1 THEN
        But := LeftB
      ELSE
        But := RightB;
      END;
        {$B-}
    END; {with}
  END;   {Get_Mouse_Action}

  PROCEDURE Move_Mouse(Hor,Ver: INTEGER);
  VAR
    Reg: registers;
  BEGIN
  Reg.Ax := 4;
  Reg.Cx := PRED(Hor*8);
  Reg.Dx := PRED(Ver*8);
  Intr($33,Reg);
  END; {Proc Move_mouse}

  PROCEDURE Confine_Mouse_Horiz(Left,Right:INTEGER);
  VAR
    Reg: registers;
  BEGIN
  Reg.Ax := 7;
  Reg.Cx := PRED(Left*8);
  Reg.Dx := PRED(Right*8);
  Intr($33,Reg);
  END;

  PROCEDURE Confine_Mouse_Vert(Top,Bot:INTEGER);
  VAR
    Reg: registers;
  BEGIN
  Reg.Ax := 8;
  Reg.Cx := PRED(Top*8);
  Reg.Dx := PRED(Bot*8);
  Intr($33,Reg);
  END;

  PROCEDURE Set_Mouse_Cursor_Style(OrdChar: INTEGER);
  VAR
    Reg: registers;
  BEGIN
  Reg.Ax := 10;
  Reg.Bx := 0;        {software text cursor}
  Reg.Cx := $7700;
  Reg.Dx := $77 AND OrdChar;
  Intr($33,Reg);
  END;

  FUNCTION Mouse_Released(Button:INTEGER):BOOLEAN;
 {}
  VAR Reg : registers;
  BEGIN
  Reg.Ax := 6;
  Reg.Bx := Button;
  Intr($33,Reg);
  Mouse_Released := (Reg.Bx > 0);
  END; {of proc Mouse_Released}

  FUNCTION Mouse_Pressed(Button:INTEGER):BOOLEAN;
 {}
  VAR Reg : registers;
  BEGIN
  Reg.Ax := 5;
  Reg.Bx := Button;
  Intr($33,Reg);
  Mouse_Pressed := (Reg.Bx > 0);
  END; {of proc Mouse_Released}



{++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  FUNCTION Alt_Pressed:BOOLEAN;
  VAR
    AltW : WORD;
  BEGIN
  AltW := SWAP(Key_Status_Bits);
  Alt_Pressed := (AltW AND $0800) <> 0;
  END;

  FUNCTION Ctrl_Pressed:BOOLEAN;
  VAR
    CtrlW : WORD;
  BEGIN
  CtrlW := SWAP(Key_Status_Bits);
  Ctrl_Pressed := (CtrlW AND $0400) <> 0;
  END;

  FUNCTION LeftShift_Pressed: BOOLEAN;
 {}
  VAR LSW : WORD;
  BEGIN
  LSW := SWAP(Key_Status_Bits);
  LeftShift_Pressed := (LSW AND $0200) <> 0;
  END; {of func LeftShift_Pressed}

  FUNCTION RightShift_Pressed: BOOLEAN;
 {}
  VAR RSW : WORD;
  BEGIN
  RSW := SWAP(Key_Status_Bits);
  RightShift_Pressed := (RSW AND $0100) <> 0;
  END; {of func RightShift_Pressed}

  FUNCTION Shift_Pressed: BOOLEAN;
 {}
  VAR SW : WORD;
  BEGIN
  SW := SWAP(Key_Status_Bits);
  Shift_Pressed := ((SW AND $0200) <> 0) OR ((SW AND $0100) <> 0);
  END; {of func LeftShift_Pressed}

  FUNCTION CapsOn: BOOLEAN;
 {}
  VAR CapsOnW : WORD;
  BEGIN
  CapsOnW := SWAP(Key_Status_Bits);
  CapsOn := (CapsOnW AND $4000) <> 0;
  END; {of func CapsOn}

  FUNCTION NumOn: BOOLEAN;
 {}
  VAR NumOnW : WORD;
  BEGIN
  NumOnW := SWAP(Key_Status_Bits);
  NumOn := (NumOnW AND $2000) <> 0;
  END; {of func NumOn}

  FUNCTION ScrollOn: BOOLEAN;
 {}
  VAR ScrollOnW : WORD;
  BEGIN
  ScrollOnW := SWAP(Key_Status_Bits);
  ScrollOn := (ScrollOnW AND $1000) <> 0;
  END; {of func ScrollOn}

  PROCEDURE Set_Caps(On : BOOLEAN);
 {}
  BEGIN
  IF On THEN
    Key_Status_Bits := (Key_Status_Bits OR $40)
  ELSE
    Key_Status_Bits := (Key_Status_Bits AND $BF);
  END; {of proc Set_Caps}

  PROCEDURE Set_Num(On : BOOLEAN);
 {}
  BEGIN
  IF On THEN
    Key_Status_Bits := (Key_Status_Bits OR $20)
  ELSE
    Key_Status_Bits := (Key_Status_Bits AND $DF);
  END; {of proc Set_Num}

  PROCEDURE Set_Scroll(On : BOOLEAN);
 {}
  BEGIN
  IF On THEN
    Key_Status_Bits := (Key_Status_Bits OR $10)
  ELSE
    Key_Status_Bits := (Key_Status_Bits AND $EF);
  END; {of proc Set_Scroll}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  PROCEDURE KeyClick;
  BEGIN
  IF KTTT.Click THEN
    BEGIN
    sound(1000);
    sound(50);
    delay(5);
    nosound;
    END;
  END; {of proc KeyClick}

  FUNCTION GetKey:CHAR;
{waits for keypress or mouse activity}

{Note that if an extended key is pressed e.g. F1, then a value of 128 is
 added to the Char value. Also if a mouse is active the trapped mouse
 activity is returned as follows:

}

  CONST
    H = 40;
    V = 13;
    MouseUp    =  #128;
    MouseDown  =  #129;
    MouseLeft  =  #130;
    MouseRight =  #131;
    MouseEsc   =  #132;
    MouseEnter =  #133;
  VAR
    Action,
    Finished : BOOLEAN;
    Hor, Ver : INTEGER;
    B : Button;
    Ch : CHAR;
  BEGIN
  Finished := FALSE;
  Action := FALSE;
  B := NoB;
  IF Moused THEN Move_Mouse(H,V);     {logically put mouse in middle of screen}
  REPEAT                      {keep checking Mouse for activity until keypressed}
{$IFNDEF VER40}
    KTTT.Idle_Hook;
{$ELSE}
         If Idle_Hook <> Nil then
            Call_Idle_Hook;
{$ENDIF}
    IF Moused THEN
      BEGIN
      Get_Mouse_Action(B,Hor,Ver);
      CASE B OF
        LeftB : BEGIN
                Ch := MouseEnter;
                Finished := TRUE;
                delay(200);
                REPEAT
                UNTIL Mouse_Pressed(0) = FALSE; {absorb}
                END;
        RightB: BEGIN
                Ch := MouseEsc;
                Finished := TRUE;
                delay(200);
                REPEAT
                UNTIL Mouse_Pressed(1) = FALSE; {absorb}
                END;
      END; {case}

      IF (Ver - V) > 1 THEN
        BEGIN
        Ch := MouseDown;
        Finished := TRUE;
        END
      ELSE
        IF (V - Ver) > 1 THEN
          BEGIN
          Ch := MouseUp;
          Finished := TRUE;
          END
      ELSE
        IF (Hor - H) > Horiz_Sensitivity THEN
          BEGIN
          Ch := MouseRight;
          Finished := TRUE;
          END
      ELSE
        IF (H - Hor) > Horiz_Sensitivity THEN
          BEGIN
          Ch := MouseLeft;
          Finished := TRUE;
          END;
      END;
    IF Keypressed OR Finished THEN Action := TRUE;
  UNTIL Action;
  WHILE NOT Finished DO
    BEGIN
    Finished := TRUE;
    Ch := ReadKey;
    KeyClick;
    IF Ch = #0 THEN
      BEGIN
      Ch := ReadKey;
      CASE ORD(Ch) OF    {set to TTT value}
        15,
        16..25,
        30..38,
        44..50,
        59..68,
        71..73,
        75,77,
        79..127 : Ch := CHR(ORD(Ch) + 128);
        128..140: Ch := CHR(ORD(Ch) + 6);
        ELSE      Finished := FALSE;
      END;  {case}
      END;
    END;
{$IFNDEF VER40}
  KTTT.Pressed_Hook(Ch);
{$ELSE}
      If Pressed_Hook <> Nil then
         Call_Pressed_Hook(Ch);
{$ENDIF}
  GetKey := Ch;
  END;

  PROCEDURE DelayKey(Time : INTEGER);
  VAR
    I : INTEGER;
    ChD : CHAR;
  BEGIN
  I := 1;
  WHILE I < Time DIV 100 DO
    BEGIN
    delay(100);
    I := SUCC(I);
    IF Keypressed THEN
      BEGIN
      I := MAXINT;
      ChD := GetKey;           {absorb the keypress}
      END;
    END;
  END; {DelayKey}

BEGIN   {unit initialization code}
Moused := Mouse_Installed;
IF Moused THEN Horiz_Sensitivity := 1;
Default_Settings;
END.

