  userrec=                            { USER.LST : User account records }
  record
    name:string[36];                  { user name        }
    realname:string[36];              { real name        }
    pw:string[20];                    { user password    }
    ph:string[12];                    { user phone #     }
    bday:string[8];                   { user birthdate   }
    firston:string[8];                { firston date     }
    x1xs  :array[1..2] of byte;
    laston:string[8];                 { laston date      }
    x2xs  :array[1..2] of byte;
    street:string[30];                { mailing address  }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    computer:string[30];              { type of computer }
    occupation:string[40];            { occupation       }
    wherebbs:string[40];              { BBS reference    }
    note:string[39];                  { SysOp note       }

    lockedout:boolean;                { if locked out    }
    deleted:boolean;                  { if deleted       }
    lockedfile:string[8];             { lockout msg to print }

    ac:set of uflags;                 { user flags   }
    ar:set of acrq;                   { AR flags     }

    zzqscan:array[1..64] of word;     { last read msg pointers }
    xqxxx:array[1..64] of word;
    zzqscn:array[1..64] of boolean;   { scan boards flags  }
    zzdlnscn:dlnscan;                 { scan uboards flags }

    vote:array[1..20] of byte;        { voting data  }

    sex:char;                         { user sex }

    ttimeon:longint;                  { total mins spent on  }
    x1xx:integer;
    uk:longint;                       { UL k                 }
    x2xx:integer;
    dk:longint;                       { DL k                 }
    x3xx:integer;

    uploads,downloads,                { # of ULs / # of DLs  }
    loggedon,                         { # times logged on    }
    tltoday,                          { # min left today     }
    msgpost,                          { # public posts       }
    emailsent,                        { # email sent         }
    feedback,                         { # feedback sent      }
    forusr,                           { forward mail to user # }
    filepoints:integer;               { # of file points     }

    waiting,                          { mail waiting         }
    linelen,                          { line length (# cols) }
    pagelen,                          { page length (# rows) }
    ontoday,                          { # times on today     }
    illegal,                          { # illegal logon attempts }
    sl,dsl:byte;                      { SL / DSL }

    cols:clrs;                        { user colors }

    lastmsg,lastfil:byte;             { last msg/file areas   }
    RESERVED1:longint;                {***** RESERVED FOR FUTURE USE *****}
    x4xx:integer;
    timebank:integer;                 { # mins in Time Bank   }
    boardsysop:array[1..5] of byte;   { msg board SysOp       }

    trapactivity,                     { if trapping users activity }
    trapseperate:boolean;             { if trap to seperate TRAP file }

    timebankadd:integer;              { time added to time bank TODAY }
    mpointer:longint;                 { pointer to entry in MACRO.LST }
    chatauto,                         { if auto chat trapping }
    chatseperate:boolean;             { if seperate chat file to trap to }
    userstartmenu:string[8];          { menu to start user out on }
    slogseperate:boolean;             { seperate SysOp log? }
    clsmsg:byte;                      { 1 if clear-screen msg, 2 if not }
    flistopt:byte;                    { type of file list type to use }
    msgorder:byte;                    { 0:Chrono, 1:ReplyTree }
    avadjust:byte;                    { AVATAR color adjust: 1=no, 2=yes }