(*****************************************************************************)
(*>                                                                         <*)
(*>  Telegard Bulletin Board System - Copyright 1988,89,90 by               <*)
(*>  Eric Oman, Martin Pollard, and Todd Bolitho - All rights reserved.     <*)
(*>                                                                         <*)
(*>  Module name:       SYSOP2A.PAS                                         <*)
(*>  Module purpose:    System Configuration "A" command                    <*)
(*>                     (Modem Configuration)                               <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2a;

interface

uses
  crt, dos, overlay,
  cuser,
  common;
var
ca:integer;
cb:integer;
cc:integer;
procedure pomodem;

implementation

const
  aresure='Are you sure this is what you want? ';

function wantit:boolean;
begin
  nl; wantit:=pynq(aresure);
end;

procedure noch;
begin
  print('No change.');
end;

function showmodemstring(s:astr):astr;
var o:astr;
    i:integer;
begin
  o:='';
  for i:=1 to length(s) do
    case s[i] of
      ^@..^L,^N..^[:
         o:=o+'^'+chr(ord(s[i])+64);
      ^M:o:=o+'|';
    else
         o:=o+s[i];
    end;
  showmodemstring:=o;
end;

procedure newmodemstring(var vs:astr; what:astr; len:integer);
var i:integer;
    changed:boolean;
begin
  Sprint('^5Current modem '+what+' string: "'+showmodemstring(vs)+'"');
  nl;
  Sprint('^4Use ^9: ^3"^5^^^3"^4 Preceding Control Codes. (^@..^[)');
  sprint('^4        ^3"^5|^3"^4 For a Carriage Return.');
  sprint('^4        ^3"^5~^3"^4 For a HalfSecond Delay.');
  nl;
  sprint('^9Enter NEW Modem '+what+' String.');
  prt(':');
  if (len>78) then mpl(78) else mpl(len);
  inputwn(vs,len,changed);
  if (changed) then begin
    for i:=1 to length(vs) do
      case vs[i] of
        '|':vs[i]:=^M;
        '^':if ((i<>length(vs)) and (vs[i+1] in ['@'..'['])) then begin
              vs[i]:=chr(ord(vs[i+1])-64);
              delete(vs,i+1,1);
            end;
      end;
  end else
    noch;
end;

procedure pomodem;
var modemrf:file of modemrec;
    s:string[80];
    i,c1,c2,cc:integer;
    c,ccc:char;
    abort,next,done:boolean;
begin
  done:=FALSE;
  repeat
    with modemr do begin
      cls;
      sprint('^4[ ^9Modem Configuration ^4]');
      nl;
      abort:=FALSE; next:=FALSE;
      printacr(#3#5'['+#3#3+'1'+#3#5+']. Maximum Baud Rate    : '+cstrl(waitbaud),abort,next);
      printacr(#3#5'['+#3#3+'2'+#3#5+']. COM Port Number      : '+cstr(comport),abort,next);
      printacr(#3#5'['+#3#3+'3'+#3#5+']. Modem String         : '+showmodemstring(init),abort,next);
      printacr(#3#5'['+#3#3+'4'+#3#5+']. Modem Answer String  : '+showmodemstring(answer),abort,next);
      printacr(#3#5'['+#3#3+'5'+#3#5+']. Modem Hangup String  : '+showmodemstring(hangup),abort,next);
      printacr(#3#5'['+#3#3+'6'+#3#5+']. Modem Offhook String : '+showmodemstring(offhook),abort,next);
      printacr(#3#5'['+#3#3+'7'+#3#5+']. NoCall Init Time    : '+cstr(nocallinittime),abort,next);
      printacr(#3#5'['+#3#3+'C'+#3#5+']. Connection delay     : '+cstr(waittime),abort,next);
      printacr(#3#5'['+#3#3+'F'+#3#5+']. Force Baud Rates?    : '+syn(not noforcerate),abort,next);
      printacr(#3#5'['+#3#3+'R'+#3#5+']. Modem Result Codes.',abort,next);
      nl;
      prt('Enter selection or (Q)uit : ');
      onek(c,'Q1234567BCFR'^M); nl;
      case c of
        '1':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!@M');
              pausescr;
            end else begin
              print('This is the baud rate that Genesis will use when waiting for calls');
              print('at the WFC menu.  This should be your modem''s MAXIMUM BAUD RATE.');
              nl;
              print('The current rate is: '+cstrl(waitbaud)+' baud.');
              nl;
              sprint('^4A: 300 baud');
              sprint('^4B: 1200 baud');
              sprint('^4C: 2400 baud');
              sprint('^4D: 4800 baud');
              sprint('^4F: 9600 baud');
              sprint('^4G: 12000 baud');
              sprint('^4H: 14400 baud');
              sprint('^4I: 16800 baud');
              sprint('^4J: 19200 baud');
              sprint('^4J: 38400 baud');
              nl;
              prt('Modem speed? (A-K) : '); onek(ccc,'QABCDFGHIJ'^M);
              if (ccc in ['A'..'J']) then
                case ccc of
                  'A':waitbaud:=300;
                  'B':waitbaud:=1200;
                  'C':waitbaud:=2400;
                  'D':waitbaud:=4800;
                  'F':waitbaud:=9600;
                  'G':waitbaud:=12000;
                  'H':waitbaud:=14400;
                  'I':waitbaud:=16800;
                  'J':waitbaud:=19200;
                  'k':waitbaud:=38400;
               end;
            end;
        '2':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!@M');
              pausescr;
            end else begin
              prt('Com port (1-4)? '); inu(cc);
              if (cc in [1..4]) then
                if (wantit) then begin
                  remove_port;
                  comport:=cc;
                  iport;
                end
                else noch;
            end;

        'C':if (incom) then begin
              sprint(#3#7+'This can only be changed locally!!@M');
              pausescr;
            end else begin
              sprint('This function will wait for connection to be established');
              sprint('without hanging the user up.  This function is commonly');
              sprint('used with high speed modems.  Set amount to 0 to disable.');
              nl;
              prt('Connection delay (0-255)? '); inu(cc);
              if (cc in [0..255]) then
                if (wantit) then begin
                waittime:=cc;
                end
                else noch;
            end;

        '3':newmodemstring(init,'init',80);
        '4':newmodemstring(answer,'answer',40);
        '5':newmodemstring(hangup,'hangup',40);
        '6':newmodemstring(offhook,'offhook',40);
        '7':begin
              prt('No Call Modem ReInitialization : '); inu(c1);
              if (not badini) then nocallinittime:=c1;
            end;
        'F':noforcerate:=not noforcerate;
        'R':begin
              CLs;
          nl;
          printacr(#3#4'   Primary         Alternative',abort,next);
          for i:=0 to 7 do begin
          case i of
              0:s:='300';   1:s:='1200';  2:s:='2400';
              3:s:='9600';  4:s:='12000'; 5:s:='14400';
              6:s:='16800'; 7:s:='19200';
          end;
         s:=#3#5'R'+cstr(i+1)+'. '+s+' Connect  : '+
         mn(resultcode[1][i],3)+'      '+
         mn(resultcode[2][i],3);
         printacr(s,abort,next);
        end;
        nl;
        prt('Change Which Result Code? '); onek(ccc,'Q123456789');
        cc:=ord(ccc)-48;
        if (cc in [1..8]) then begin
        prt('Enter Primary Result Code : '); inu(c1);
        if (not badini) then resultcode[1][cc-1]:=c1;
        prt('Enter Alternative Result Code : '); inu(c2);
        if (not badini) then resultcode[2][cc-1]:=c2;
        end;
        end;
        'Q':done:=TRUE;
      end;
    end;
  until ((done) or (hangup));
  assign(modemrf,systat.gfilepath+'modem.dat');
  reset(modemrf);
  seek(modemrf,0);
  write(modemrf,modemr);
  close(modemrf);
end;

end.
