{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit miscx;

interface

uses
  crt, dos, overlay,
  common,
  doors,
  mail0,
  misc1;

procedure finduser(var s:astr; var usernum:integer);
procedure dsr(uname:astr);
procedure ssm(dest:integer; s:astr);
procedure isr(uname:astr;usernum:integer);
procedure logon1st;

implementation

uses
  archive1;

procedure finduser(var s:astr; var usernum:integer);
var user:userrec;
    sr:smalrec;
    nn:astr;
    i,ii,t:integer;
    sfo,ufo:boolean;
begin
  s:=''; usernum:=0;
  sprompt(#3#7);
  input(nn,36);
  if (nn='?') then begin
  exit;
  end;
  while (copy(nn,1,1)=' ') do nn:=copy(nn,2,length(nn)-1);
  while (copy(nn,length(nn),1)=' ') do nn:=copy(nn,1,length(nn)-1);
  while (pos('  ',nn)<>0) do delete(nn,pos('  ',nn),1);
  if ((hangup) or (nn='')) then exit;
  s:=nn;
  usernum:=value(nn);
  if (usernum<>0) then begin
    if (usernum<0) then
      usernum:=-3             (* illegal negative number entry *)
    else begin
      ufo:=(filerec(uf).mode<>fmclosed);
      if (not ufo) then reset(uf);
      if (usernum>filesize(uf)-1) then begin
        sprint('^8Unknown User!');
        usernum:=0;
      end else begin
        seek(uf,usernum); read(uf,user);
        if (user.deleted) then begin
          sprint('^8Unknown User!');
          usernum:=0;
        end;
      end;
      if (not ufo) then close(uf);
    end;
  end else begin
    if (nn<>'') then begin
      sfo:=(filerec(sf).mode<>fmclosed);
      if (not sfo) then reset(sf);
      ii:=0; t:=1;
      while ((t<=filesize(sf)-1) and (ii=0)) do begin
        seek(sf,t); read(sf,sr);
        if (nn=sr.name) then ii:=sr.number;
        inc(t);
      end;
      if (ii<>0) then usernum:=ii;
    end;
    if (nn='NEW') then usernum:=-1;
    if (nn='GUEST') then
      if (systat.guestuser=-1) then
        sprint('^7No guest user account available!')
      else
        usernum:=-2;
    if (usernum=0) then sprint('^8Unknown User!');
    if (not sfo) then close(sf);
  end;
end;

procedure ssm(dest:integer; s:astr);
var u:userrec;
    x:smr;
    ufo:boolean;
begin
  {$I-} reset(smf); {$I+}
  if (ioresult<>0) then rewrite(smf);
  seek(smf,filesize(smf));
  x.msg:=s; x.destin:=dest;
  write(smf,x);
  close(smf);

  ufo:=(filerec(uf).mode<>fmclosed);
  if (not ufo) then reset(uf);
  if ((dest>=1) and (dest<=filesize(uf))) then begin
    seek(uf,dest); read(uf,u);
    if (not (smw in u.ac)) then begin
      u.ac:=u.ac+[smw];
      seek(uf,dest); write(uf,u);
    end;
  end;
  if (not ufo) then close(uf);
  if (dest=usernum) then thisuser.ac:=thisuser.ac+[smw];
end;

procedure dsr(uname:astr);
var t,ii:integer;
    sr:smalrec;
    sfo:boolean;
begin
  sfo:=(filerec(sf).mode<>fmclosed);
  if (not sfo) then reset(sf);

  ii:=0; t:=1;
  while ((t<=filesize(sf)-1) and (ii=0)) do begin
    seek(sf,t); read(sf,sr);
    if (sr.name=uname) then ii:=t;
    inc(t);
  end;

  if (ii<>0) then begin
    if (ii<>filesize(sf)-1) then
      for t:=ii to filesize(sf)-2 do begin
        seek(sf,t+1); read(sf,sr);
        seek(sf,t); write(sf,sr);
      end;
    seek(sf,filesize(sf)-1); truncate(sf);
    dec(systat.numusers); savesystat;
  end
  else sl1(#3#7'*** Couldn''t delete "'+uname+'"');
  if (not sfo) then close(sf);
end;

procedure isr(uname:astr; usernum:integer);
var t,i,ii:integer;
    sr:smalrec;
    sfo:boolean;
begin
  sfo:=(filerec(sf).mode<>fmclosed);
  if (not sfo) then reset(sf);
  if (filesize(sf)=1) then ii:=0
  else begin
    ii:=0; t:=1;
    while ((t<=filesize(sf)-1) and (ii=0)) do begin
      seek(sf,t); read(sf,sr);
      if (uname<sr.name) then ii:=t;
      inc(t);
    end;
    for i:=filesize(sf)-1 downto ii+1 do begin
      seek(sf,i); read(sf,sr);
      seek(sf,i+1); write(sf,sr);
    end;
  end;
  with sr do begin name:=uname; number:=usernum; end;
  seek(sf,ii+1); write(sf,sr);
  inc(systat.numusers); savesystat;
  if (not sfo) then close(sf);
end;

procedure logon1st;
  type
    shitstring = string[8];

var ul:text;
    temp,u:userrec;
    tmp:smalrec;
    zf:file of zlogrec;
    fil:file of astr;
    d1,d2:zlogrec;
    s,s1:astr;
    tries,cnt,n,z,c1,num,rcode,tempusernum:integer;
    c:char;
    abort:boolean;
    dt:string[8];
    nochange:bollean;

function difindays(curdate, lastondate : shitstring) : integer;

  var
    code : integer;
    curday,curmonth,
    lastday,lastmonth,
    d,m : integer;
    date,month: string[2];


  begin
    if (curdate[2] = '/') and (curdate[4] = '/') then
      date := curdate[3];
    if (curdate[2] = '/') and (curdate[5] = '/') then
      date := curdate[3]+curdate[4];
    if (curdate[3] = '/') and (curdate[6] = '/') then
      date:=curdate[4]+curdate[5];
    if (curdate[3] = '/') and (curdate[5] = '/') then
      date := curdate[4];
    val(date,curday,code);
    if curdate[3] = '/' then
      month:=curdate[1]+curdate[2]
    else month := curdate[1];
    val(month,curmonth,code);
    date:=lastondate[4]+lastondate[5];
    val(date,lastday,code);
    month:=lastondate[1]+lastondate[2];
    val(month,lastmonth,code);
    m := curmonth - lastmonth;
    if (m < 0) then
      begin
        curmonth := curmonth + 12;
        m := curmonth - lastmonth;
      end;
    d := curday - lastday;
    if (d < 0)  then
      begin
        case curmonth of
          1,3,5,7,8,10,12 : curday := curday + 31;
          4,6,9,11 : curday := curday + 30;
          2 : curday := curday + 28;
        end;
        d := curday - lastday;
        dec(m);
      end;
    difindays:=(d+(30*m)+(m div 2));
  end;

  procedure killusermail;
  var u:userrec;
      pinfo:pinforec;
      mixr:msgindexrec;
      i,j:longint;
  begin
    savepinfo(pinfo);
    initbrd(-1);
    for i:=0 to himsg do begin
      seek(mixf,i); blockread(mixf,mixr,1);
      j:=mixr.messagenum;
      if ((miexist in mixr.msgindexstat) and (j=cnt)) then s:=rmail(i);
    end;
    loadpinfo(pinfo);
  end;

  procedure killuservotes;
  var vdata:file of vdatar;
      vd:vdatar;
      i:integer;
  begin
    assign(vdata,systat.gfilepath+'voting.dat');
    {$I-} reset(vdata); {$I+}
    if (ioresult=0) then begin
      for i:=1 to filesize(vdata) do
        if (temp.vote[i]>0) then begin
          seek(vdata,i-1); read(vdata,vd);
          dec(vd.answ[temp.vote[i]].numres);
          seek(vdata,i-1); write(vdata,vd);
          temp.vote[i]:=0;
        end;
      close(vdata);
    end;
  end;

begin
  if (spd<>'KB') then begin
    inc(systat.callernum);
    inc(systat.todayzlog.calls);
  end;

  realsl:=thisuser.sl;
  realdsl:=thisuser.dsl;

  commandline('Purging files in TEMP directories 1, 2, and 3 ...');
  purgedir(systat.temppath+'1\');
  purgedir(systat.temppath+'2\');
  purgedir(systat.temppath+'3\');

  if (systat.lastdate<>date) then begin
    sprompt(#3#7+'Updating System, please wait ...');
    commandline('Updating user time left ...');
    reset(uf);
    for n:=1 to filesize(uf)-1 do begin
      seek(uf,n); read(uf,u);
      with u do begin
        tltoday:=systat.timeallow[sl];
        timebankadd:=0; ontoday:=0;
      end;
      seek(uf,n); write(uf,u);
    end;
    close(uf);

    commandline('Updating ZLOG.DAT ...');
    assign(zf,systat.gfilepath+'zlog.dat');
    {$I-} reset(zf); {$I+}
    if (ioresult<>0) then begin
      rewrite(zf);
      d1.date:='';
      for n:=1 to 2 do write(zf,d1);
    end;

    d1:=systat.todayzlog;
    d1.date:=systat.lastdate;

    for n:=filesize(zf)-1 downto 0 do begin
      seek(zf,n); read(zf,d2);
      seek(zf,n+1); write(zf,d2);
    end;
    seek(zf,0);
    write(zf,d1);
    close(zf);
    systat.lastdate:=date;

    commandline('Updating SysOp Log files ...');

    assign(ul,systat.trappath+'sysop'+cstr(systat.backsysoplogs)+'.log');
    {$I-} erase(ul); {$I+} num:=ioresult;

    for n:=systat.backsysoplogs-1 downto 1 do
      if (exist(systat.trappath+'sysop'+cstr(n)+'.log')) then begin
        assign(ul,systat.trappath+'sysop'+cstr(n)+'.log');
        rename(ul,systat.trappath+'sysop'+cstr(n+1)+'.log');
      end;

    d1:=systat.todayzlog;
    sl1('');
    sl1(#3#3+'Total time on        - '+#3#6+cstr(d1.active));
    sl1(#3#3+'Percent of activity  - '+#3#6+sqoutsp(ctp(d1.active,1440))+' ('+
                                  cstr(d1.calls)+' calls)');
    sl1(#3#3+'New users            - '+#3#6+cstr(d1.newusers));
    sl1(#3#3+'Public posts         - '+#3#6+cstr(d1.pubpost));
    sl1(#3#3+'Private mail sent    - '+#3#6+cstr(d1.privpost));
    sl1(#3#3+'Feedback sent        - '+#3#6+cstr(d1.fback));
    sl1(#3#3+'Critical Errors      - '+#3#6+cstr(d1.criterr));
    sl1(#3#3+'Downloads today      - '+#3#6+cstr(d1.downloads)+#3#3+'-'+#3#6+cstrl(d1.dk)+'k');
    sl1(#3#3+'Uploads today        - '+#3#6+cstr(d1.uploads)+#3#3+'-'+#3#6+cstrl(d1.uk)+'k');

    close(sysopf);
    rename(sysopf,systat.trappath+'sysop1.log');

    assign(sysopf,systat.trappath+'sysop.log');
    rewrite(sysopf); close(sysopf); append(sysopf);
    sl1('');
    sl1(#3#4' ͸ ');
    sl1(#3#4'   '+#3#3+'Genesis SysOp Log for '+date+':  '+#3#4+' ');
    sl1(#3#4' ; ');
    sl1('');
    sl1('');

    assign(ul,systat.gfilepath+'user.log');
    rewrite(ul);
    writeln(ul);
    writeln(ul,'Log of callers for '+date+':');
    writeln(ul);
    close(ul);

    systat.todayzlog.date:=date;
    with systat.todayzlog do begin
      for n:=0 to 4 do userbaud[n]:=0;
      active:=0; calls:=0; newusers:=0; pubpost:=0; privpost:=0;
      fback:=0; criterr:=0; uploads:=0; downloads:=0; uk:=0; dk:=0;
    end;

    if (exist('daystart.bat')) then
      shelldos(FALSE,process_door('daystart.bat @F @L @B @G @T @R'),rcode);

    if (systat.pwdays<>0) then
      begin
        tries:=0;
        commandline('Purging user passwords...');
        assign(uf,systat.gfilepath+'\user.lst');
        reset(uf);
        dt:=date;
        for cnt:=2 to (filesize(uf)-1) do
          begin
            seek(uf,cnt);
            read(uf,temp);
            if not(temp.deleted) then
              if (temp.name=thisuser.name) then nochange:=FALSE
                else nochange:=TRUE;
            if (not nochange) then
               begin
               if (not(fnodeletion in temp.ac)) then
                 if (difindays(dt,temp.laston) >= systat.pwdays) or
                      (temp.laston[8] = '1') then
                         begin
                      nl;
                   sprint('It has been '+systat.pwdays+' since you changed your password.');
               sprint('At this time, the sysop has requested for you to change your password');
            sprint('for security reasons.  Please do not try to abort this, if you do,');
           sprint('I will be forced to lock you out and notify the sysop.');
             nl;
          repeat
          sprint(#3#5+'Enter your new desired password.');
          mpl2(20);
          sprompt(#3#9+': ');
          input(s,20);
          if (length(s)<4) then
            begin
              nl;
              sprint(#3#7+'Must be at least 4 characters long!');
            nl;
            end
          else
            begin
              nl;
              sprompt(#3#5+'Your password is : '+#3#7+s);
              done1:=pynq(#3#5+'. Is this correct (No)? ');
              if (done1) then
              begin
              thisuser.pw:=s;
              sysoplog(#3#4+'Password change for user : '+#3#9+temp.name);
              tempusernum:=usernum; usernum:=cnt;
              rsm;
              usernum:=tempusernum;
              seek(uf,cnt);
              write(uf,temp);
              end;
              if (not done1) then inc(tries);
              if (tries>=3) then
              begin
              cls;
              nl;
              sprint(#3#0+'Excessive password change failure, hanging up...');
              sprint(#3#0+'The sysop has been notified, and you have been locked out...');
              sprint(#3#0+'Have a nice day!');
              nl;
              thisuser.lockedout:=TRUE;
              hangup:=TRUE;
              sysoplog(#3#4+'['+#3#8+'*'+#3#4+'] '+#3#3+'Locked out '+thisuser.name+' for trying to abort PW change.');
            end;
          end;
          until (done1) or (hangup);
        nl;
        end;
     end;
  end;
end;

    if (systat.purgedays<>0) then
      begin
        commandline('Purging inactive users...');
        assign(uf,systat.gfilepath+'\user.lst');
        reset(uf);
        dt:=date;
        for cnt:=2 to (filesize(uf)-1) do
          begin
            seek(uf,cnt);
            read(uf,temp);
            if not(temp.deleted) then
              if (temp.name<>thisuser.name) then
                if (not(fnodeletion in temp.ac)) then
                  if (not(temp.sl=255)) then
                    if (difindays(dt,temp.laston) >= systat.purgedays) or
                      (temp.laston[8] = '1') then
                         begin
                           temp.deleted:=TRUE;
                           sysoplog(#3#7+'Deleted Inactive User : '+#3#9+temp.name);
                           tempusernum:=usernum; usernum:=cnt;
                           rsm;
                           usernum:=tempusernum;
                           temp.waiting:=0;
                           killusermail;
                           killuservotes;
                           seek(uf,cnt);
                           write(uf,temp);
                         end;
        end;
        savesystat;
        tempusernum:=1;
        assign(sf,systat.gfilepath+'names.lst');
        {$I-} rewrite(sf); {$I+}
        for cnt:=1 to filesize(uf)-1 do
          begin
            seek(uf,cnt); read(uf,temp);
            if not(temp.deleted) then
              begin
                with tmp do
                  begin
                    name:=temp.name;
                    number:=cnt;
                  end;
                write(sf,tmp);
              end;
          end;
        systat.numusers:=filesize(sf);
        savesystat;
        close(sf);
      end;
sprint(#3#7+' Thanks ...');
nl;
enddayf:=TRUE;
end;

  if (thisuser.slogseperate) then begin
    assign(sysopf1,systat.trappath+'slog'+cstr(usernum)+'.log');
    {$I-} append(sysopf1); {$I+}
    if (ioresult<>0) then begin
      rewrite(sysopf1);
      append(sysopf1);
      s:=''; s1:='';
      for n:=1 to 26+length(nam) do begin s:=s+'_'; s1:=s1+' '; end;
      writeln(sysopf1,'');
      writeln(sysopf1,'  '+s);
      writeln(sysopf1,'>>'+s1+'<<');
      writeln(sysopf1,'>> Genesis SysOp Log for '+nam+': <<');
      writeln(sysopf1,'>>'+s+'<<');
      writeln(sysopf1,'');
    end;
    writeln(sysopf1);
    s:=#3#3+'Logon '+#3#5+'['+dat+']'+#3#4+' (';
    if (spd<>'KB') then s:=s+spd+' baud)' else s:=s+'Keyboard)';
    if (systat.stripclog) then s:=stripcolor(s);
    writeln(sysopf1,s);
  end;

  s:=#3#4+cstr(systat.callernum)+#3#3+'  '+#3#5+nam+#3#3+'  '+
     #3#4+'Today '+cstr(thisuser.ontoday+1);
  if (trapping) then s:=s+#3#7+'';
  sl1(s);

  if (spd<>'KB') then begin
    assign(ul,systat.gfilepath+'user.log');
    {$I-} append(ul); {$I+}
    if (ioresult<>0) then begin
      rewrite(ul);
      append(ul);
    end;
    s:=#3#3+mln(cstr(systat.callernum),6)+#3#2+'- '+
       #3#4+mln(nam,26)+#3#2+' - '+#3#4+time+#3#2+' -'+#3#4+mrn(spd,5);
    if (wasnewuser) then s:=s+#3#4+' ['+#3#3+'New User'+#3#4+']';
    if (wasguestuser) then s:=s+#3#4+' ['+#3#3+'Guest User'+#3#4+']';
    writeln(ul,s); close(ul);
  end;
end;

end.
