(*****************************************************************************)
(*>                                                                         <*)
(*>  NEWUSERS.PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Logon functions -- New users.                                          <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit newusers;

interface

uses
  crt, dos, overlay, PULLTTT5, KEYTTT5,
  mail0, mail1, mail2, mail3,
  misc2, misc3, misc4, miscx,
  cuser, cuser2,
  doors,
  archive1,
  menus,
  common, strings;

procedure newuser;
procedure newuserinit(nam:astr);

implementation

var
  newusername:astr;


procedure tcenter(i:astr);
  var p,x,y:integer;
  begin
    p:=40-(length(i) div 2);
    x:=wherex; y:=wherey;
    x:=p;
    gotoxy(x,y);
    writeln(i);
  end;

procedure p1;

const
  UP=#200;
  DOWN=#208;
  LEFT=#203;
  RIGHT=#205;
  HOMEKEY=#199;
  ENDKEY=#207;
  ESC=#027;
  ENTER=#13;
  F1=#187;

var c,c2:char;
    tries,i,ii,t:integer;
    s,s1,s2:astr;
    atype,pw:astr;
    done,abort,next,choseansi,chosecolor:boolean;
    y:integer;

  procedure showstuff;
  begin
    nl; nl; printf('system');
    nl; nl; printf('newuser');
    if (systat.newuserpw<>'') then begin
      tries:=0; pw:='';
      while ((pw<>systat.newuserpw) and
            (tries<systat.maxlogontries) and (not hangup)) do begin
        printf('nup');
        prt('New User Password : '); echo:=FALSE; input(pw,20); echo:=TRUE;
        if (systat.newuserpw<>pw) or (pw='') then begin
          sl1(#3#8+'>>'+#3#1+' Illegal NUP: "'+pw+'"');
          inc(tries);
        end;
      end;
      if (tries>=systat.maxlogontries) then begin
        printf('nonewusr');
        hangup:=TRUE;
      end;
    end;
  end;

  procedure doitall;
  type neworderrec=array[1..17] of integer;
  const neworder :neworderrec=(7,10,23,1,4,14,8,12,2,13,6,3,11,24,9,5,-1);
        neworder2:neworderrec=(7,10,23,1,4,14,8,12,2,6,5,13,3,11,24,9,-1);
  var i,y:integer;
      c:char;
  begin
    showstuff;
    if (newusername<>'') and (newusername<>'NEW USER') then begin
      thisuser.name:=newusername;
      newusername:='';
      i:=2;
    end else
      i:=1;
    if (systat.applytype=1) then
      begin
        printf('newusrs');
        if (thisuser.name<>'') and (thisuser.name<>'NEW USER') then
          begin
            i:=1;
            ansig(15,4);
            sprint(#3#0+thisuser.name);
            inc(i);
          end;
      end;
    repeat
      if (systat.applytype=0) then
        begin
          cstuff(neworder2[i],1,thisuser);
          inc(i);
        end
      else
        if (systat.applytype=1) then
          begin
            cstuff2(neworder[i],1,thisuser);
            inc(i);
          end;
    until ((neworder[i]=-1) or (hangup));
  end;

  procedure dc(var abort:boolean; c:char; n,v:astr);
  var s:string;
  begin
    printacr(#3#1+'('+#3#3+c+#3#1+') '+
             #3#4+mln(n,11)+#3#2+' - '+#3#5+v,abort,next);
  end;

  procedure show_users_stats;
    begin
      with thisuser do
        begin
          sprint(#3#9+'Newuser Information Change '+#3#0+'(Turn NUM LOCK on)');
          nl;
          dc(abort,'A','User name   ' ,name);
          dc(abort,'B','Real name',    realname);
          dc(abort,'C','Voice phone',    ph);
          dc(abort,'D','Computer',     computer);
          dc(abort,'E','Gender',          sex);
          dc(abort,'F','Birthdate',    bday+' ('+cstr(ageuser(bday))+' years old)');
          dc(abort,'G','City, State',  citystate);
          dc(abort,'H','Address',      street);
          dc(abort,'I','Zip code',     zipcode);
          dc(abort,'J','Sysop Def.',   occupation);
          dc(abort,'K','Reference',    wherebbs);
          dc(abort,'L','ANSI',         atype);
          dc(abort,'M','Screen size',  cstr(linelen)+'x'+cstr(pagelen));
          dc(abort,'N','Password',     pw);
          nl;
          sprint(#3#4+'Use Numerical Keypad (NUM LOCK ON!), press <Q> to quit.');
        end;
    end;

  procedure move_bar_up;
    begin  { Move bar up }
      ansig(1,y);
      case (y) of
        3:sprompt(#3#1+'('+#3#3+'A'+#3#1+')');
        4:sprompt(#3#1+'('+#3#3+'B'+#3#1+')');
        5:sprompt(#3#1+'('+#3#3+'C'+#3#1+')');
        6:sprompt(#3#1+'('+#3#3+'D'+#3#1+')');
        7:sprompt(#3#1+'('+#3#3+'E'+#3#1+')');
        8:sprompt(#3#1+'('+#3#3+'F'+#3#1+')');
        9:sprompt(#3#1+'('+#3#3+'G'+#3#1+')');
        10:sprompt(#3#1+'('+#3#3+'H'+#3#1+')');
        11:sprompt(#3#1+'('+#3#3+'I'+#3#1+')');
        12:sprompt(#3#1+'('+#3#3+'J'+#3#1+')');
        13:sprompt(#3#1+'('+#3#3+'K'+#3#1+')');
        14:sprompt(#3#1+'('+#3#3+'L'+#3#1+')');
        15:sprompt(#3#1+'('+#3#3+'M'+#3#1+')');
        16:sprompt(#3#1+'('+#3#3+'N'+#3#1+')');
      end;
      y:=y-1;
      if (y>16) then y:=3;
      if (y<3) then y:=16;
      ansig(1,y);
      cl(6);
      case (y) of
        3:sprompt(#3#6+'(A)');
        4:sprompt(#3#6+'(B)');
        5:sprompt(#3#6+'(C)');
        6:sprompt(#3#6+'(D)');
        7:sprompt(#3#6+'(E)');
        8:sprompt(#3#6+'(F)');
        9:sprompt(#3#6+'(G)');
        10:sprompt(#3#6+'(H)');
        11:sprompt(#3#6+'(I)');
        12:sprompt(#3#6+'(J)');
        13:sprompt(#3#6+'(K)');
        14:sprompt(#3#6+'(L)');
        15:sprompt(#3#6+'(M)');
        16:sprompt(#3#6+'(N)');
      end;
    end; { Move bar up }

procedure move_bar_down;
  begin
    ansig(1,y);
    case (y) of
      3:sprompt(#3#1+'('+#3#3+'A'+#3#1+')');
      4:sprompt(#3#1+'('+#3#3+'B'+#3#1+')');
      5:sprompt(#3#1+'('+#3#3+'C'+#3#1+')');
      6:sprompt(#3#1+'('+#3#3+'D'+#3#1+')');
      7:sprompt(#3#1+'('+#3#3+'E'+#3#1+')');
      8:sprompt(#3#1+'('+#3#3+'F'+#3#1+')');
      9:sprompt(#3#1+'('+#3#3+'G'+#3#1+')');
      10:sprompt(#3#1+'('+#3#3+'H'+#3#1+')');
      11:sprompt(#3#1+'('+#3#3+'I'+#3#1+')');
      12:sprompt(#3#1+'('+#3#3+'J'+#3#1+')');
      13:sprompt(#3#1+'('+#3#3+'K'+#3#1+')');
      14:sprompt(#3#1+'('+#3#3+'L'+#3#1+')');
      15:sprompt(#3#1+'('+#3#3+'M'+#3#1+')');
      16:sprompt(#3#1+'('+#3#3+'N'+#3#1+')');
    end;
    y:=y+1;
    if (y>16) then y:=3;
    if (y<3) then y:=16;
    ansig(1,y);
    cl(6);
    case (y) of
      3:sprompt(#3#6+'(A)');
      4:sprompt(#3#6+'(B)');
      5:sprompt(#3#6+'(C)');
      6:sprompt(#3#6+'(D)');
      7:sprompt(#3#6+'(E)');
      8:sprompt(#3#6+'(F)');
      9:sprompt(#3#6+'(G)');
      10:sprompt(#3#6+'(H)');
      11:sprompt(#3#6+'(I)');
      12:sprompt(#3#6+'(J)');
      13:sprompt(#3#6+'(K)');
      14:sprompt(#3#6+'(L)');
      15:sprompt(#3#6+'(M)');
      16:sprompt(#3#6+'(N)');
    end;
  end; {Move bar down}

begin
  t:=0;
  doitall;
  done:=false;
  cls;
  abort:=FALSE; next:=FALSE;
  printacr(#3#9+'Newuser Information Change '+#3#0+'(Turn NUM LOCK on)',abort,next);
  nl;
  if (ansi in thisuser.ac) then
    begin
      atype:='Enabled';
      if (color in thisuser.ac) then
        atype:=atype+' w/ color'
      else
        atype:=atype+' w/o color';
    end
  else
    atype:='Disabled';

  with thisuser do
    begin
      dc(abort,'A','User name   ' ,name);
      dc(abort,'B','Real name',    realname);
      dc(abort,'C','Voice phone',    ph);
      dc(abort,'D','Computer',     computer);
      dc(abort,'E','Gender',          sex);
      dc(abort,'F','Birthdate',    bday+' ('+cstr(ageuser(bday))+' years old)');
      dc(abort,'G','City, State',  citystate);
      dc(abort,'H','Address',      street);
      dc(abort,'I','Zip code',     zipcode);
      dc(abort,'J','SysOp Def.',   occupation);
      dc(abort,'K','Reference',    wherebbs);
      dc(abort,'L','ANSI',         atype);
      dc(abort,'M','Screen size',  cstr(linelen)+'x'+cstr(pagelen));
      dc(abort,'N','Password',     pw);
      nl;
      sprint(#3#4+'Use Numerical Keypad (NUM LOCK ON!), <Q> to quit.');
      ansig(1,3); sprompt(#3#6+'(A)');
      y:=3;
      done:=false;
      pulls:=TRUE;
      while (not done) and (not hangup) do
        begin
          checkhangup;
          c:=inkey;
            if (c=#0) then
              c2:=inkey
            else
              c2:=c;
            case c2 of
              'Q','q':done:=true;
              UP,#72,#072,'8':move_bar_up;
              LEFT,#75,#075,'4':move_bar_up;
              DOWN,#80,#080,'2':move_bar_down;
              RIGHT,#77,#077,'6':move_bar_down;
              ^M,ENTER,
              #013,#13:begin
                         case y of
                           3:c:='A';
                           4:c:='B';
                           5:c:='C';
                           6:c:='D';
                           7:c:='E';
                           8:c:='F';
                           9:c:='G';
                           10:c:='H';
                           11:c:='I';
                           12:c:='J';
                           13:c:='K';
                           14:c:='L';
                           15:c:='M';
                           16:c:='N';
                         end;
                         ansig(1,19);
                         cstuff(pos(c,'HFLGDJACNBMEKI'),1,thisuser);
                         cls;
                         show_users_stats;
                         ansig(1,y);
                         case y of
                           3:sprompt(#3#6+'(A)');
                           4:sprompt(#3#6+'(B)');
                           5:sprompt(#3#6+'(C)');
                           6:sprompt(#3#6+'(D)');
                           7:sprompt(#3#6+'(E)');
                           8:sprompt(#3#6+'(F)');
                           9:sprompt(#3#6+'(G)');
                           10:sprompt(#3#6+'(H)');
                           11:sprompt(#3#6+'(I)');
                           12:sprompt(#3#6+'(J)');
                           13:sprompt(#3#6+'(K)');
                           14:sprompt(#3#6+'(L)');
                           15:sprompt(#3#6+'(M)');
                           16:sprompt(#3#6+'(N)');
                         end;
                       end;
            end;
        end;
    end;
  ansig(1,19);
  pulls:=FALSE;
end;

procedure p2;
var user:userrec;
    pw:string;
    tries,i,j:integer;
    c:char;
begin
  if (not hangup) then begin
    nl;

    {prompt('User record is being added to the list, please wait ...');}
    getstringcr(82);

    reset(uf);
    j:=0;
    for i:=1 to filesize(uf)-1 do begin
      seek(uf,i); read(uf,user);
      if ((user.deleted) and (j=0)) then j:=i;
    end;
    if (j<>0) then usernum:=j else usernum:=filesize(uf);

    with thisuser do begin
      deleted:=FALSE; waiting:=0; firston:=date; laston:=date;
      loggedon:=1; msgpost:=0; emailsent:=0; feedback:=0; ontoday:=0;
      illegal:=0; forusr:=0; beep_mail:=0; headertype:=0; newyes:=0; newno:=0;
      downloads:=0; uploads:=0; dk:=0; uk:=0;
      ttimeon:=0; note:=''; pub_note:=systat.new_pub_note;

      for i:=1 to 5 do boardsysop[i]:=255;
      lastmsg:=1; lastfil:=1; RESERVED1:=0; timebank:=0;

      for i:=1 to 10 do res[i]:=0;
      for i:=1 to 20 do vote[i]:=0;

      readinzscan; { load old / create new zscan.dat record }
      with zscanr do begin
        for i:=1 to maxboards do
          for j:=1 to 6 do mhiread[i][j]:=0;
        mzscan:=[]; fzscan:=[];
        for i:=1 to maxboards do mzscan:=mzscan+[i];
        for i:=0 to maxuboards do fzscan:=fzscan+[i];
      end;
      savezscanr;

      trapactivity:=FALSE; trapseperate:=FALSE;
      timebankadd:=0;
      mpointer:=-1;
      chatauto:=FALSE; chatseperate:=FALSE;
      slogseperate:=FALSE;

      flistopt:=1;
      avadjust:=0;

      reset(uf); seek(uf,0); read(uf,user); close(uf);
      cols:=user.cols;
      sl:=systat.newsl; dsl:=systat.newdsl; realsl:=sl; realdsl:=dsl;
      filepoints:=systat.newfp;

      ar:=systat.newar;
      tltoday:=systat.timeallow[sl];
    end;

    reset(uf);
    seek(uf,usernum); write(uf,thisuser);
    close(uf);

    isr(thisuser.name,usernum);

    {sprint(#3#3+'Saved.');}
    getstringcr(83);

    repeat
      nl; nl;
      sprint('Your user name is "'+#3#3+allcaps(thisuser.name)+#3#1+
             '", and your user number is '+#3#3+cstr(usernum)+#3#1+'.');
      sprint('Your password is "'+#3#3+thisuser.pw+#3#1+'".');
      nl;
      printf('rempass');
      if (nofile) then
        begin
          print('Please remember these.  You will need your password to log on');
          print('again in the future, and your user number helps to log on faster.');
          nl;
        end
      else
        getstringcr(96);
    {  print('Enter your password again for verification.'); }
      prompt('Password: '); echo:=FALSE; input(pw,20); echo:=TRUE;
      if (pw<>thisuser.pw) then print(^G'Sorry, that is not correct.  Please try again.'^G);
    until ((pw=thisuser.pw) or (hangup));
    nl; nl; nl;

    useron:=TRUE;
    window(1,1,80,25);
    clrscr;
    schangewindow(not cwindowon,systat.curwindow);
    cls;

    if ((exist(systat.afilepath+'newuser.inf')) or
        (exist(systat.gfilepath+'newuser.inf'))) then
      readq('newuser',0);
    topscr;
    if (systat.newapp<>-1) then begin
      printf('newapp');
      irt:='New User Application';
    end;
    nl;
  end;
end;

procedure newuser;
var i:integer;
begin
  sl1(#3#8+' ***'+#3#3+' NewUser'+#3#8+' ***');
  p1; p2;
  if (systat.newapp<>-1) then
    begin
      reset(uf); i:=forwardm(systat.newapp); close(uf);
      if (i=0) then i:=systat.newapp;
      email1(i,'\NewUser Application');
    end;
  inc(systat.todayzlog.newusers);
  wasnewuser:=TRUE;
  useron:=TRUE;
end;

procedure newuserinit(nam:astr);
var s:astr;
begin
  newusername:=nam;
  clrscr;
  if systat.applytype = 0 then
    begin
      window(1,1,80,25); gotoxy(1,1);
      tc(14); textbackground(1); clreol;
      if (spd<>'KB') then s:=' New user on at '+spd+' baud '
        else s:=' New user on locally ';
      gotoxy(40-length(s) div 2,1); textbackground(4); write(s);
      tc(3); textbackground(0);
      window(1,2,80,25); gotoxy(1,1);
    end;
  if (systat.closedsystem) then begin
    printf('nonewusr');
    hangup:=TRUE;
  end else
  if (systat.numusers>systat.maxusers) then
    begin
      printf('maxusers');
      if (nofile) then
        begin
          sprint(#3#7+'Sorry, this BBS has reached its maximum capacity for new users.');
          if not(systat.registered) then
            begin
              sprint(#3#7+'This is an unregistered copy of Synergy.  It allows for a maximum of 5 users');
              sprint(#3#7+'at any one time until registered.  Please ask the SysOp to register his copy');
              sprint(#3#7+'of Synergy.  It''s quick, easy, and FREE!');
              pausescr;
            end;
        end;
      sysoplog(#3#8+'>>'+#3#0+' MAXIMUM USER COUNT HAS BEEN REACHED!');
      if not(systat.registered) then
        begin
          sysoplog(#3#8+'****************************************************************************');
          sysoplog(#3#8+'*'+#3#6+'                       REGISTER YOUR COPY OF SYNERGY!                     '
                  +#3#8+'*');
          sysoplog(#3#8+'****************************************************************************');
          sysoplog(#3#5+'An unregistered copy of Synergy only allows for a maximum of 5 users!');
        end;
      hangup:=TRUE;
    end
  else
    begin
      with thisuser do
        begin
          name:='NEW USER';
          trapactivity:=FALSE;
          trapseperate:=FALSE;
        end;
      inittrapfile;
    end;
end;

end.
