/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// PowerPPL Compiler - PPC Sources

#define YYSTYPE char*

#include <stdio.h>
#include <process.h>
#include <dir.h>
#include <io.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include "..\ppc\pps_tab.h"
#include "..\ppc\arrays.h"
#include "..\ppc\fortify.h"

#define STRCONST 1
#define INTCONST 2
#define HEXCONST 3
#define SYMBOL   4
#define DBLCONST 5
#define BINCONST 6
#define OCTCONST 7

#define FUNC_IDENTIFIER 1
#define PROC_IDENTIFIER 2
#define VAR_IDENTIFIER  3

#define LOOP_WHILE  1
#define LOOP_FOR    2
#define LOOP_IF     3
#define LOOP_CASE   4
#define LOOP_ELSEIF 5

#define CODEBUFFERSTARTSIZE 131072
#define CODEBUFFERINC 65535
#define BUFFERSINC 	  128
#define BUILDINC       32
#define LABELINC       64
#define IDENTIFIERINC  32
#define LABELSTACKINC  16
#define LOOPINC		   16
#define SELECTINC       8
#define PARAMNINC	   16
#define SYMCODEINC   4096
#define FILESINC        4
#define SOURCEINC       8

#define ARGVAR 1
#define ARGIMM 2
#define ARGEXP 3
#define ARGARR 4
#define ARGNONE 5

// 
// 
// 

typedef struct {
    char *name;
    int type;
    char nDim;
    int dim1;
    int dim2;
    int dim3;
    void *data;
    void *paramTypes;
    int external;
    long offset;
    int identHdr;
	} identListType;

typedef struct {
	char *name;
    int num;
    unsigned int offset;
    } labelType;

typedef struct {
    char *name;
    unsigned int offset;
	} gotoType;

typedef struct {
	unsigned long codeOffset;
    unsigned long sourceOffset;
    unsigned int line;
    } symType;

typedef struct {
	FILE *stream;
    unsigned int line;
    unsigned int cursource;
    } filesType;

// 
// 
// 

int check_type(void);
int check_func(void);
void compile(char *file);
void registerIdent(char *data);
void registerIdentList(int type);
void registerOneIdentFromList(int type);
void allocMem(void);
void unallocMem(void);
void freeIdentifier(void);
int globalVarType(int type);
void checkIdentifier(void);
void sendToBuffer(void *ptr, int size);
void writePPE(void);
void writeSYM(void);
void writeLIB(void);
void registerLabel(char *name, unsigned int offset);
void registerJump(char *name, unsigned int offset);
int mkLexRet(int a, int b);
void freeBuffers(void);
char *newcode(int l);
char *lookup(int type);
char *mkFunc(int f);
char *mkStat(unsigned int s);
char *concat(char *c1, char *c2);
void initbuild(void);
void build(char *value);
char *separator(int s, int arg);
char *retreiveBuild(void);
void allocBuffers(void);
void writeLines(int line);
void processJumps(void);
void processVars(void);
void checkJumps(void);
char *newTempLabel(void);
void fakeNextLabel(char *);
void pushLabelStack(char *s);
char *popLabelStack(void);
void closeLoop(char *s, int loopType);
void checkLoop(char *s, int loopType);
void openLoop(int loopType);
void endifLoop(void);
void beep(void);
void pushSelect(char *var);
char *popSelect(void);
void switchLastLabels(void);
char *semValue(char *s);
void checkDim(char *var, int n);
char *semText(char *s);
void invalidVar(char *v);
void registerProc(char *procName, int nArgs, char *argTypes, int pf, int funcReturnType);
void checkProc(char *procName, int nArgs, char *argTypes, int pf, int funcReturnType);
void enterProc(char *procName, int type);
void leaveProc(int type);
char *zero(void);
int isHex(char c);
void treatOption(char *o);
void mkUserVariable(char *name, int type, int ndim1);
char *toVar(char *sem);
void correctAssign(void);
void analyze(char *s);
void checkFunc(int f, int npar);
void pushParamN(int n);
int popParamN(void);
int isInternal(char *name);
void registerLibVars(char *name, int libNum);
int openLib(char *name);
void insertLibCode(char *name, int libNum);
void libSize(int line, long size);
void linking(int line);
void codeSize(int line, long size);
void writecode(char *file);
void mymemcpy(char huge *dest, char huge *src, unsigned long size);
void importLib(char *libn);
char *newstr(char *str);
void setLibPath(char *path);
void CheckCode(int uvarsConcerned);
void generateUserVars(void);
void invalidUserVars(void);
void checkUserProc(int varnum, int nargs);
void buildProcErrorMsg(char *d, char *deb, int var);
void tooManyArgsProc(int p);
void notEnoughArgsProc(int p);
void yyparse(void);
void yyerror(char *msg);
void yymessage(char *msg);
void yywarning(char *msg);
int gettoken(char *lltb, int lltbsiz);
void crypt(char *buffer, int len);
int recrypt(char *buffer, char *buffer2, int len);
void cryptXor(char *buffer, unsigned int len);
void setEncoding(char *s);
void honnor(int ver);
void checkStatArg(char *s, char *a1, char *a2, char *a3, char *a4, char *a5, char *a6, char *a7, char *a8, char *a9, char *a10);
int argClass(char *arg);
void checkUserProcArgTypes(char *p, int n);
void updateSym(void);
void emergencyExit(void);
void check_alloc(void *ptr);
void internalFunc(char *f);
void internalProc(char *f);
void checkSymbol(char *s);
void mustHaveUvars(char *n);
FILE *popFile(void);
void pushFile(FILE *file);
void include(char *file, int part);
void *farnormal(void *ptr);
void initLogicalLine(void);
void closeLogicalLine(void);
void setPPOutput(int val);
void pushSource(void);
int identcmp(identListType *p, const char *s2);
void writeSymbols(void);
void writeIntSYM(void);

// 
// 
// 

extern char drive[MAXDRIVE];
extern char dir[MAXDIR];
char name[MAXFILE];
extern char ext[MAXEXT];

int excludeUserVarsFromCheck=0;

int lineBlocks = 2048;
int ppoutput;

int declaration=0;
int yyStackSize;
char forceLet[128];
int linePart=0;
int rereadLine=0;
int xor17=0;
int cryptppe=0;
int honnorEnc=1;
int maxTokVer=0;
int forceFrt=0;

int onlySyntax=0;
int uvGenerated=0;

extern FILE *lexin;
int errorOccured=0;
int lookupType;
int registeringLib=0;
int column = 0;
int procfuncdecl=0;
int curProcType=0;
int curArg;
FILE *ppe;
FILE *sym;
FILE *lib;
char *libname[256];
int libnameNum=0;
char far out[256];
char far symname[256];
char far strParsed[256];
char far msg[512];
char *curProc=NULL;
int startNVars=0;
int makeSym=0, makeIntSym=0, noSymUpdate=0;
long symInc=0;

int makeDebugCod=0;
int makeLib=0;
char far libPath[256];

int implicitVars=0;

int forceLabel;

extern char yytext[256];
extern int ppltoken, ppltype;
extern int lineBlocks;
char predefValue[12];
int nVars=0;
int totalArgs=0;
extern char userProcArgType[256];
int totalParam=0;
int statArg;
int debug=0;
int line=0;
int localLine=0;
int lexn;
int mustBeType=0;
unsigned int ppecoresize;

int beginUsed=0;
int userVar=1;

int readProcs=1;
int readGlobal=1;

char nDim=0;
int dim1=0, dim2=0, dim3=0;

int identHdr=0;
int procCount=0;

char huge *codeBuffer=NULL;
long codeBufferSize=0;
signed long codeBufferPos=0;
unsigned long argType=0;

char fakeLabel[7]="";

char **buffers=NULL;
int buffersSize=0;
int buffersPos=0;

char *buildBuf=NULL;
int buildSize=0;
int buildPos=0;
int buildAllocated=0;

gotoType **jump=NULL;
int jumpSize=0;
int jumpPos=0;

identListType **identifier=NULL;
int identifierSize=0;
int identifierPos=0;

identListType **identList=NULL;
int identListSize=0;
int identListPos=0;

labelType **labels=NULL;
int labelSize=0;
int labelPos=0;

signed long nextBufLimit=-1;

char **labelStack=NULL;
int labelStackSize=0;
int labelStackPos=0;

int *loop=NULL;
int loopSize=0;
int loopPos=0;

char **select=NULL;
int selectSize=0;
int selectPos=0;

int *paramN=NULL;
int paramNsize=0;
int paramNpos=0;

symType *symCode=NULL;
unsigned long symCodePos=0;
unsigned long symCodeSize=0;
unsigned long beginLineOffset=0;

filesType *files=NULL;
unsigned long filesPos=0;
unsigned long filesSize=0;

char **source=NULL;
int sourceSize=0;
int sourcePos=0;
int cursource=0;

char loopName[5][15] = { "while/endwhile", "for/next", "if/endif", "select case", "if/endif"};
char curFile[256]="";

// 
//  COMPILE 
// 

void compile(char *file)
{
long pos;
long prevPos=0;
int a,b,c;
int oldProcCount;
int recovered=0;

generateUserVars();

for (a=0;a<libnameNum;a++)
    registerLibVars(libname[a], a+1);

fnsplit(file, NULL, NULL, name, ext);
fnmerge(curFile, NULL, NULL, name, ext);
if ((lexin = fopen(file, "rt")) == NULL)
	{
    printf("cannot open source (%s)\n", file);
    return;
    }
pushSource();

recover:
while (!feof(lexin) && !errorOccured)
	{
    line++;
    localLine++;
    rc1:
	pos = ftell(lexin);
    if (!recovered)
		if (pos != 0)
			fseek(lexin, -1, SEEK_CUR);
	fgets(strParsed, 255, lexin);
    beginLineOffset = prevPos;
    prevPos += strlen(strParsed);
    if (recovered==1)
    	{
        recovered=2;
        goto rc1;
        }
    if (recovered)
    	recovered=0;
    if (debug)
	   	printf(strParsed);
    else
    	if (codeBufferPos > nextBufLimit)
			{
            nextBufLimit += lineBlocks;
			writeLines(line);
            }
    if (*strParsed==0 && feof(lexin))
    	break;
    fseek(lexin, pos, SEEK_SET);
    updateSym();
    for (b=0,c=0;b<strlen(strParsed);b++)
    	{
        if (strParsed[b] == '\t')
        	c+=3;
        }
    symInc += c;
    for (a=0;a<128;a++)
	    forceLet[a]=0;
	linePart=0;
    rereadLine = 0;
    analyze(strParsed);
    if (rereadLine)
    	{
        llinit();
    	continue;
        }
    column=0;

    initLogicalLine();
	yyparse(); // Parse!
    closeLogicalLine();

    }

if (filesPos > 0)
	{
	fclose(lexin);
	lexin = popFile();
    recovered=1;
    llinit();
    goto recover;
    }

if (loopPos > 0)
	{
    sprintf(msg, "unterminated %s structure", loopName[loop[loopPos-1]-1]);
    yyerror(msg);
    }
if (curProc != NULL)
    yyerror("unterminated procedure/function");

writeLines(line);

if (!errorOccured)
	{
	a = 1;
	sendToBuffer(&a, 2);
    freeBuffers();

    if (makeDebugCod)
        writecode("debug.cod");
    if (makeLib)
    	{
	    checkJumps();
    	if (!errorOccured)
    		{
            libSize(line, codeBufferPos);
    		writeLIB();
            }
        }
    else
    	{
        linking(line);

		allocBuffers();
        oldProcCount=procCount;
        identHdr=0;
        procCount=0;
		for (a=0;a<libnameNum;a++)
	    	insertLibCode(libname[a], a+1);
        procCount=oldProcCount;
		freeBuffers();

		processVars();
	    processJumps();
    	if (!errorOccured)
    		{
            codeSize(line, codeBufferPos);
    		if (!onlySyntax)
				{
				writePPE();
				writeSymbols();
                }
	        }
        }
    }
fclose(lexin);

}

// 
//  YYWRAP 
// 

yywrap()
{
	return(1);
}

// 
//  COUNT 
// 

void count()
{
	int i;
    gettoken(yytext, sizeof yytext);

	for (i = 0; yytext[i] != '\0'; i++)
		if (yytext[i] == '\n')
			column = 0;
		else if (yytext[i] == '\t')
			column += 8 - (column % 8);
		else
			column++;
}

int mkLexRet(int a, int b)
{
char *value=newcode(4);
*(int *)value=2;
*(int *)(value+2)=a;
yylval = value;
return(b);
}

// 
//  CHECK_TYPE 
// 

int check_type(void)
{
int a;
int h;
char *p;
yylval = NULL;

predefValue[0]=0;

if (forceLabel) goto forcedLabel;

if (mustBeType || lexn == 1)
    {
    if (!stricmp(yytext,"Var"))			  { honnor(1520); declaration=1; return(VAR); }
    if (!stricmp(yytext,"BOOLEAN"))       { declaration=1; return mkLexRet(0, TYPE); }
    if (!stricmp(yytext,"DWORD"))         { declaration=1; return mkLexRet(1, TYPE); }
    if (!stricmp(yytext,"UNSIGNED"))      { declaration=1; return mkLexRet(1, TYPE); }
    if (!stricmp(yytext,"UDWORD"))        { declaration=1; return mkLexRet(1, TYPE); }
    if (!stricmp(yytext,"DATE"))          { declaration=1; return mkLexRet(2, TYPE); }
    if (!stricmp(yytext,"EDATE"))         { declaration=1; return mkLexRet(3, TYPE); }
    if (!stricmp(yytext,"INTEGER"))       { declaration=1; return mkLexRet(4, TYPE); }
    if (!stricmp(yytext,"SDWORD"))        { declaration=1; return mkLexRet(4, TYPE); }
    if (!stricmp(yytext,"LONG"))          { declaration=1; return mkLexRet(4, TYPE); }
    if (!stricmp(yytext,"MONEY"))         { declaration=1; return mkLexRet(5, TYPE); }
    if (!stricmp(yytext,"REAL"))          { declaration=1; return mkLexRet(6, TYPE); }
    if (!stricmp(yytext,"FLOAT"))         { declaration=1; return mkLexRet(6, TYPE); }
    if (!stricmp(yytext,"STRING"))        { declaration=1; return mkLexRet(7, TYPE); }
    if (!stricmp(yytext,"TIME"))          { declaration=1; return mkLexRet(8, TYPE); }
    if (!stricmp(yytext,"BYTE"))          { declaration=1; return mkLexRet(9, TYPE); }
    if (!stricmp(yytext,"UBYTE"))         { declaration=1; return mkLexRet(9, TYPE); }
    if (!stricmp(yytext,"WORD"))          { declaration=1; return mkLexRet(10, TYPE); }
    if (!stricmp(yytext,"UWORD"))         { declaration=1; return mkLexRet(10, TYPE); }
    if (!stricmp(yytext,"SBYTE"))         { declaration=1; return mkLexRet(11, TYPE); }
    if (!stricmp(yytext,"SHORT"))         { declaration=1; return mkLexRet(11, TYPE); }
    if (!stricmp(yytext,"INT"))           { declaration=1; return mkLexRet(12, TYPE); }
    if (!stricmp(yytext,"SWORD"))         { declaration=1; return mkLexRet(12, TYPE); }
    if (!stricmp(yytext,"BIGSTR"))        { honnor(1520); declaration=1; return mkLexRet(13, TYPE); }
    if (!stricmp(yytext,"DOUBLE"))        { honnor(1520); declaration=1; return mkLexRet(14, TYPE); }
    if (!stricmp(yytext,"DREAL"))         { honnor(1520); declaration=1; return mkLexRet(14, TYPE); }
    if (!stricmp(yytext,"DDATE"))         { honnor(1521); declaration=1; return mkLexRet(17, TYPE); }
    if (!stricmp(yytext,"SDATE"))         { honnor(2000); declaration=1; return mkLexRet(33, TYPE); }
    if (mustBeType)
    	{
		yyerror("type required");
    	mustBeType=0;
        }
    }

if (!stricmp(yytext,"Declare"))       	{ honnor(1520); return(DECLARE); }
if (!stricmp(yytext,"Procedure"))     	{ honnor(1520); return(PROCEDURE); }
if (!stricmp(yytext,"Function"))      	{ honnor(1520); return(FUNCTION); }
if (!stricmp(yytext,"Then")) 			{ return(THEN);}
if (!stricmp(yytext,"Do"))      	  	{ return(DO);}
if (!stricmp(yytext,"Begin"))         	{ return(BEGIN); }
if (!stricmp(yytext,"Break"))           { return(BREAK); }
if (!stricmp(yytext,"Quit"))        	{ return(BREAK); }
if (!stricmp(yytext,"Continue"))        { return(CONTINUE); }
if (!stricmp(yytext,"Loop"))     		{ return(CONTINUE); }
if (!stricmp(yytext,"End"))           	{ return(END); }
if (!stricmp(yytext,"Select"))          { return(SELECT); }
if (!stricmp(yytext,"Case"))     	    { return(CASE); }
if (!stricmp(yytext,"Default"))         { return(DEFAULT); }
if (!stricmp(yytext,"EndSelect"))       { return(ENDSELECT); }
if (!stricmp(yytext,"EndWhile"))        { return(ENDWHILE); }
if (!stricmp(yytext,"For")) 			{ return(FOR); }
if (!stricmp(yytext,"Step"))            { return(STEP); }
if (!stricmp(yytext,"While"))			{ return(WHILE); }
if (!stricmp(yytext,"Next")) 			{ return(NEXT); }
if (!stricmp(yytext,"EndFor")) 			{ return(NEXT); }
if (!stricmp(yytext,"If")) 				{ return(IF); }
if (!stricmp(yytext,"Else")) 			{ return(ELSE); }
if (!stricmp(yytext,"ElseIf")) 			{ return(ELSEIF); }
if (!stricmp(yytext,"Endif"))           { return(ENDIF); }
if (!stricmp(yytext,"To")) 			  	{ return(TO);}
if (!stricmp(yytext,"Func")) 		  	{ return(FUNC);}
if (!stricmp(yytext,"Proc")) 		  	{ return(PROC);}
if (!stricmp(yytext,"Goto"))            { return(GOTO); }
if (!stricmp(yytext,"Gosub"))           { return(GOSUB); }
if (!stricmp(yytext,"Go"))              { return(GO); }

if (lexn == 1)
	{
    if (!stricmp(yytext,"Cls"))           { return mkLexRet(2, S_0ARG); }
    if (!stricmp(yytext,"ClrEol"))        { return mkLexRet(3, S_0ARG); }
    if (!stricmp(yytext,"More"))          { return mkLexRet(4, S_0ARG); }
    if (!stricmp(yytext,"Wait"))          { return mkLexRet(5, S_0ARG); }
    if (!stricmp(yytext,"Color"))         { return mkLexRet(6, S_1ARG); }
    if (!stricmp(yytext,"Let"))           { return mkLexRet(8, LET); }
    if (!stricmp(yytext,"Print"))         { return mkLexRet(9, S_1PARG); }
    if (!stricmp(yytext,"PrintLn"))       { return mkLexRet(10, S_0PARG); }
    if (!stricmp(yytext,"ConfFlag"))      { return mkLexRet(12, S_2ARG); }
    if (!stricmp(yytext,"ConfUnflag"))    { return mkLexRet(13, S_2ARG); }
    if (!stricmp(yytext,"DispFile"))      { return mkLexRet(14, S_2ARG); }
    if (!stricmp(yytext,"Input"))         { return mkLexRet(15, S_2ARG); }
    if (!stricmp(yytext,"FCreate"))       { return mkLexRet(16, S_4ARG); }
    if (!stricmp(yytext,"FOpen"))         { return mkLexRet(17, S_4ARG); }
    if (!stricmp(yytext,"FAppend"))       { return mkLexRet(18, S_4ARG); }
    if (!stricmp(yytext,"FClose"))        { return mkLexRet(19, S_1ARG); }
    if (!stricmp(yytext,"FGet"))          { return mkLexRet(20, S_2ARG); }
    if (!stricmp(yytext,"FPut"))          { return mkLexRet(21, S_2PARG); }
    if (!stricmp(yytext,"FPutLn"))        { return mkLexRet(22, S_1PARG); }
    if (!stricmp(yytext,"ResetDisp"))     { return mkLexRet(23, S_0ARG); }
    if (!stricmp(yytext,"StartDisp"))     { return mkLexRet(24, S_1ARG); }
    if (!stricmp(yytext,"FPutPad"))       { return mkLexRet(25, S_3ARG); }
    if (!stricmp(yytext,"Hangup"))        { return mkLexRet(26, S_0ARG); }
    if (!stricmp(yytext,"GetUser"))       { mustHaveUvars("GetUser"); return mkLexRet(27, S_0ARG); }
    if (!stricmp(yytext,"PutUser"))       { mustHaveUvars("PutUser"); return mkLexRet(28, S_0ARG); }
    if (!stricmp(yytext,"PutAltUser"))    { mustHaveUvars("PutAltUser"); return mkLexRet(28, S_0ARG); }
    if (!stricmp(yytext,"DefColor"))      { return mkLexRet(29, S_0ARG); }
    if (!stricmp(yytext,"Delete"))        { return mkLexRet(30, S_1ARG); }
    if (!stricmp(yytext,"Erase"))         { return mkLexRet(30, S_1ARG); }
    if (!stricmp(yytext,"DelUser"))       { return mkLexRet(31, S_0ARG); }
    if (!stricmp(yytext,"AdjTime"))       { return mkLexRet(32, S_1ARG); }
    if (!stricmp(yytext,"Log"))           { return mkLexRet(33, S_2ARG); }
    if (!stricmp(yytext,"InputStr"))      { return mkLexRet(34, S_6ARG); }
    if (!stricmp(yytext,"InputYN"))       { return mkLexRet(35, S_3ARG); }
    if (!stricmp(yytext,"InputMoney"))    { return mkLexRet(36, S_3ARG); }
    if (!stricmp(yytext,"InputInt"))      { return mkLexRet(37, S_3ARG); }
    if (!stricmp(yytext,"InputCC"))       { return mkLexRet(38, S_3ARG); }
    if (!stricmp(yytext,"InputDate"))     { return mkLexRet(39, S_3ARG); }
    if (!stricmp(yytext,"InputTime"))     { return mkLexRet(40, S_3ARG); }
    if (!stricmp(yytext,"Return"))        { return mkLexRet(42, S_0ARG); }
    if (!stricmp(yytext,"PromptStr"))     { return mkLexRet(43, S_5ARG); }
    if (!stricmp(yytext,"DtrOn"))         { return mkLexRet(44, S_0ARG); }
    if (!stricmp(yytext,"DtrOff"))        { return mkLexRet(45, S_0ARG); }
    if (!stricmp(yytext,"CdChkOn"))       { return mkLexRet(46, S_0ARG); }
    if (!stricmp(yytext,"CdChkOff"))      { return mkLexRet(47, S_0ARG); }
    if (!stricmp(yytext,"Delay"))         { return mkLexRet(48, S_1ARG); }
    if (!stricmp(yytext,"SendModem"))     { return mkLexRet(49, S_1ARG); }
    if (!stricmp(yytext,"Inc"))           { return mkLexRet(50, S_1ARG); }
    if (!stricmp(yytext,"Dec"))           { return mkLexRet(51, S_1ARG); }
    if (!stricmp(yytext,"Newline"))       { return mkLexRet(52, S_0ARG); }
    if (!stricmp(yytext,"Newlines"))      { return mkLexRet(53, S_1ARG); }
    if (!stricmp(yytext,"Tokenize"))      { return mkLexRet(54, S_1ARG); }
    if (!stricmp(yytext,"GetToken"))      { return mkLexRet(55, S_1ARG); }
    if (!stricmp(yytext,"Shell"))         { return mkLexRet(56, S_4ARG); }
    if (!stricmp(yytext,"DispText"))      { return mkLexRet(57, S_2ARG); }
    if (!stricmp(yytext,"Stop"))          { return mkLexRet(58, S_0ARG); }
    if (!stricmp(yytext,"InputText"))     { return mkLexRet(59, S_4ARG); }
    if (!stricmp(yytext,"Beep"))          { return mkLexRet(60, S_0ARG); }
    if (!stricmp(yytext,"Push"))          { return mkLexRet(61, S_1PARG); }
    if (!stricmp(yytext,"Pop"))           { return mkLexRet(62, S_1PARG); }
    if (!stricmp(yytext,"KbdStuff"))      { return mkLexRet(63, S_1ARG); }
    if (!stricmp(yytext,"Call"))          { return mkLexRet(64, S_1ARG); }
    if (!stricmp(yytext,"Join"))          { return mkLexRet(65, S_1ARG); }
    if (!stricmp(yytext,"Quest"))         { return mkLexRet(66, S_1ARG); }
    if (!stricmp(yytext,"Blt"))           { return mkLexRet(67, S_1ARG); }
    if (!stricmp(yytext,"Dir"))           { return mkLexRet(68, S_1ARG); }
    if (!stricmp(yytext,"KbdFile"))       { return mkLexRet(69, S_1ARG); }
    if (!stricmp(yytext,"Bye"))           { return mkLexRet(70, S_0ARG); }
    if (!stricmp(yytext,"Goodbye"))       { return mkLexRet(71, S_0ARG); }
    if (!stricmp(yytext,"Broadcast"))     { return mkLexRet(72, S_3ARG); }
    if (!stricmp(yytext,"WaitFor"))       { return mkLexRet(73, S_3ARG); }
    if (!stricmp(yytext,"KbdChkOn"))      { return mkLexRet(74, S_0ARG); }
    if (!stricmp(yytext,"KbdChkOff"))     { return mkLexRet(75, S_0ARG); }
    if (!stricmp(yytext,"OpText"))        { return mkLexRet(76, S_1ARG); }
    if (!stricmp(yytext,"DispStr"))       { return mkLexRet(77, S_1ARG); }
    if (!stricmp(yytext,"RdUNet"))        { return mkLexRet(78, S_1ARG); }
    if (!stricmp(yytext,"WrUNet"))        { return mkLexRet(79, S_6ARG); }
    if (!stricmp(yytext,"DoIntr"))        { return mkLexRet(80, S_10ARG); }
    if (!stricmp(yytext,"VarSeg"))        { return mkLexRet(81, S_2ARG); }
    if (!stricmp(yytext,"VarOff"))        { return mkLexRet(82, S_2ARG); }
    if (!stricmp(yytext,"Poke"))          { return mkLexRet(83, S_2ARG); }
    if (!stricmp(yytext,"Pokeb"))         { return mkLexRet(83, S_2ARG); }
    if (!stricmp(yytext,"PokeW"))         { return mkLexRet(84, S_2ARG); }
    if (!stricmp(yytext,"VarAddr"))       { return mkLexRet(85, S_2ARG); }
    if (!stricmp(yytext,"AnsiPos"))       { return mkLexRet(86, S_2ARG); }
    if (!stricmp(yytext,"Backup"))        { return mkLexRet(87, S_1ARG); }
    if (!stricmp(yytext,"Forward"))       { return mkLexRet(88, S_1ARG); }
    if (!stricmp(yytext,"FreshLine"))     { return mkLexRet(89, S_0ARG); }
    if (!stricmp(yytext,"WrUSys"))        { return mkLexRet(90, S_0ARG); }
    if (!stricmp(yytext,"RdUSys"))        { return mkLexRet(91, S_0ARG); }
    if (!stricmp(yytext,"NewPwd"))        { return mkLexRet(92, S_2ARG); }
    if (!stricmp(yytext,"OpenCap"))       { return mkLexRet(93, S_2ARG); }
    if (!stricmp(yytext,"CloseCap"))      { return mkLexRet(94, S_0ARG); }
    if (!stricmp(yytext,"Message"))       { return mkLexRet(95, S_9ARG); }
    if (!stricmp(yytext,"SaveScrn"))      { return mkLexRet(96, S_0ARG); }
    if (!stricmp(yytext,"RestScrn"))      { return mkLexRet(97, S_0ARG); }
    if (!stricmp(yytext,"Sound"))         { return mkLexRet(98, S_1ARG); }
    if (!stricmp(yytext,"Chat"))          { return mkLexRet(99, S_0ARG); }
    if (!stricmp(yytext,"SPrint"))        { return mkLexRet(100, S_1PARG); }
    if (!stricmp(yytext,"SPrintLn"))      { return mkLexRet(101, S_0PARG); }
    if (!stricmp(yytext,"MPrint"))        { return mkLexRet(102, S_1PARG); }
    if (!stricmp(yytext,"MPrintLn"))      { return mkLexRet(103, S_0PARG); }
    if (!stricmp(yytext,"Rename"))        { return mkLexRet(104, S_2ARG); }
    if (!stricmp(yytext,"Frewind"))       { return mkLexRet(105, S_1ARG); }
    if (!stricmp(yytext,"PokeDw"))        { return mkLexRet(106, S_2ARG); }
    if (!stricmp(yytext,"DbgLevel"))      { return mkLexRet(107, S_1ARG); }
    if (!stricmp(yytext,"ShowOn"))        { return mkLexRet(108, S_0ARG); }
    if (!stricmp(yytext,"ShowOff"))       { return mkLexRet(109, S_0ARG); }
    if (!stricmp(yytext,"PageOn"))        { return mkLexRet(110, S_0ARG); }
    if (!stricmp(yytext,"PageOff"))       { return mkLexRet(111, S_0ARG); }
    if (!stricmp(yytext,"FSeek"))         { return mkLexRet(112, S_3ARG); }
    if (!stricmp(yytext,"FFlush"))        { return mkLexRet(113, S_1ARG); }
    if (!stricmp(yytext,"FRead"))         { return mkLexRet(114, S_3ARG); }
    if (!stricmp(yytext,"FWrite"))        { return mkLexRet(115, S_3ARG); }
    if (!stricmp(yytext,"FDefIn"))        { return mkLexRet(116, S_1ARG); }
    if (!stricmp(yytext,"FDefOut"))       { return mkLexRet(117, S_1ARG); }
    if (!stricmp(yytext,"FDGet"))         { return mkLexRet(118, S_1ARG); }
    if (!stricmp(yytext,"FDPut"))         { return mkLexRet(119, S_1PARG); }
    if (!stricmp(yytext,"FDPutLn"))       { return mkLexRet(120, S_0PARG); }
    if (!stricmp(yytext,"FDPutPad"))      { return mkLexRet(121, S_2ARG); }
    if (!stricmp(yytext,"FDRead"))        { return mkLexRet(122, S_2ARG); }
    if (!stricmp(yytext,"FDWrite"))       { return mkLexRet(123, S_2ARG); }
    if (!stricmp(yytext,"AdjBytes"))      { return mkLexRet(124, S_1ARG); }
    if (!stricmp(yytext,"KbdString"))     { return mkLexRet(125, S_1ARG); }
    if (!stricmp(yytext,"Alias"))         { return mkLexRet(126, S_1ARG); }
    if (!stricmp(yytext,"Redim"))         { return mkLexRet(127, S_1T4ARG); }
    if (!stricmp(yytext,"Append"))        { return mkLexRet(128, S_2ARG); }
    if (!stricmp(yytext,"Copy"))          { return mkLexRet(129, S_2ARG); }
    if (!stricmp(yytext,"KbdFlush"))      { return mkLexRet(130, S_0ARG); }
    if (!stricmp(yytext,"MdmFlush"))      { return mkLexRet(131, S_0ARG); }
    if (!stricmp(yytext,"KeyFlush"))      { return mkLexRet(132, S_0ARG); }
    if (!stricmp(yytext,"LastIn"))        { return mkLexRet(133, S_1ARG); }
    if (!stricmp(yytext,"Flag"))          { return mkLexRet(134, S_1ARG); }
    if (!stricmp(yytext,"Download"))      { return mkLexRet(135, S_1ARG); }
    if (!stricmp(yytext,"WrUSysDoor"))    { return mkLexRet(136, S_1ARG); }
    if (!stricmp(yytext,"GetAltUser"))    { mustHaveUvars("GetAltUser"); return mkLexRet(137, S_1ARG); }
    if (!stricmp(yytext,"AdjDBytes"))     { return mkLexRet(138, S_1ARG); }
    if (!stricmp(yytext,"AdjTBytes"))     { return mkLexRet(139, S_1ARG); }
    if (!stricmp(yytext,"AdjTFiles"))     { return mkLexRet(140, S_1ARG); }
    if (!stricmp(yytext,"Lang"))          { return mkLexRet(141, S_1ARG); }
    if (!stricmp(yytext,"Sort"))          { return mkLexRet(142, S_2ARG); }
    if (!stricmp(yytext,"MouseReg"))      { return mkLexRet(143, S_10ARG); }
    if (!stricmp(yytext,"ScrFile"))       { return mkLexRet(144, S_2ARG); }
    if (!stricmp(yytext,"SearchInit"))    { return mkLexRet(145, S_2ARG); }
    if (!stricmp(yytext,"SearchFind"))    { return mkLexRet(146, S_2ARG); }
    if (!stricmp(yytext,"SearchStop"))    { return mkLexRet(147, S_0ARG); }
    if (!stricmp(yytext,"PrFound"))       { return mkLexRet(148, S_1PARG); }
    if (!stricmp(yytext,"PrFoundLn"))     { return mkLexRet(149, S_0PARG); }
    if (!stricmp(yytext,"TpaGet"))        { return mkLexRet(150, S_2ARG); }
    if (!stricmp(yytext,"TpaPut"))        { return mkLexRet(151, S_2ARG); }
    if (!stricmp(yytext,"TpaCGet"))       { return mkLexRet(152, S_3ARG); }
    if (!stricmp(yytext,"TpaCPut"))       { return mkLexRet(153, S_3ARG); }
    if (!stricmp(yytext,"TpaRead"))       { return mkLexRet(154, S_2ARG); }
    if (!stricmp(yytext,"TpaWrite"))      { return mkLexRet(155, S_2ARG); }
    if (!stricmp(yytext,"TpaCRead"))      { return mkLexRet(156, S_3ARG); }
    if (!stricmp(yytext,"TpaCWrite"))     { return mkLexRet(157, S_3ARG); }
    if (!stricmp(yytext,"BitSet"))        { return mkLexRet(158, S_2ARG); }
    if (!stricmp(yytext,"BitClear"))      { return mkLexRet(159, S_2ARG); }
    if (!stricmp(yytext,"Brag"))          { return mkLexRet(160, S_0ARG); }
    if (!stricmp(yytext,"FReAltUser"))    { mustHaveUvars("FReAltUser"); return mkLexRet(161, S_0ARG); }
    if (!stricmp(yytext,"SetLmr"))        { honnor(1520); return mkLexRet(162, S_2ARG); }
    if (!stricmp(yytext,"SetEnv"))        { honnor(1520); return mkLexRet(163, S_1ARG); }
    if (!stricmp(yytext,"FCloseAll"))     { honnor(1520); return mkLexRet(164, S_0ARG); }
    if (!stricmp(yytext,"Static"))        { honnor(1520); return mkLexRet(172, S_0ARG); }
    if (!stricmp(yytext,"StackAbort"))    { honnor(1520); return mkLexRet(173, S_1ARG); }
    if (!stricmp(yytext,"DCreate"))       { honnor(1520); return mkLexRet(174, S_4ARG); }
    if (!stricmp(yytext,"DOpen"))         { honnor(1520); return mkLexRet(175, S_3ARG); }
    if (!stricmp(yytext,"DClose"))        { honnor(1520); return mkLexRet(176, S_1ARG); }
    if (!stricmp(yytext,"DSetAlias"))     { honnor(1520); return mkLexRet(177, S_2ARG); }
    if (!stricmp(yytext,"DPack"))         { honnor(1520); return mkLexRet(178, S_1ARG); }
    if (!stricmp(yytext,"DCloseAll"))     { honnor(1520); return mkLexRet(179, S_0ARG); }
    if (!stricmp(yytext,"DLock"))         { honnor(1520); return mkLexRet(180, S_1ARG); }
    if (!stricmp(yytext,"DLockR"))        { honnor(1520); return mkLexRet(181, S_2ARG); }
    if (!stricmp(yytext,"DLockG"))        { honnor(1520); return mkLexRet(182, S_3ARG); }
    if (!stricmp(yytext,"DUnlock"))       { honnor(1520); return mkLexRet(183, S_1ARG); }
    if (!stricmp(yytext,"DnCreate"))      { honnor(1520); return mkLexRet(184, S_3ARG); }
    if (!stricmp(yytext,"DnOpen"))        { honnor(1520); return mkLexRet(185, S_2ARG); }
    if (!stricmp(yytext,"DnClose"))       { honnor(1520); return mkLexRet(186, S_2ARG); }
    if (!stricmp(yytext,"DnCloseAll"))    { honnor(1520); return mkLexRet(187, S_1ARG); }
    if (!stricmp(yytext,"DNew"))          { honnor(1520); return mkLexRet(188, S_1ARG); }
    if (!stricmp(yytext,"DAdd"))          { honnor(1520); return mkLexRet(189, S_1ARG); }
    if (!stricmp(yytext,"DAppend"))       { honnor(1520); return mkLexRet(190, S_1ARG); }
    if (!stricmp(yytext,"DTop"))          { honnor(1520); return mkLexRet(191, S_1ARG); }
    if (!stricmp(yytext,"DGo"))           { honnor(1520); return mkLexRet(192, S_2ARG); }
    if (!stricmp(yytext,"DBottom"))       { honnor(1520); return mkLexRet(193, S_1ARG); }
    if (!stricmp(yytext,"DSkip"))         { honnor(1520); return mkLexRet(194, S_2ARG); }
    if (!stricmp(yytext,"DBlank"))        { honnor(1520); return mkLexRet(195, S_1ARG); }
    if (!stricmp(yytext,"DDelete"))       { honnor(1520); return mkLexRet(196, S_1ARG); }
    if (!stricmp(yytext,"DRecall"))       { honnor(1520); return mkLexRet(197, S_1ARG); }
    if (!stricmp(yytext,"DTag"))          { honnor(1520); return mkLexRet(198, S_2ARG); }
    if (!stricmp(yytext,"DSeek"))         { honnor(1520); return mkLexRet(199, S_2ARG); }
    if (!stricmp(yytext,"DFBlank"))       { honnor(1520); return mkLexRet(200, S_2ARG); }
    if (!stricmp(yytext,"DGet"))          { honnor(1520); return mkLexRet(201, S_3ARG); }
    if (!stricmp(yytext,"DPut"))          { honnor(1520); return mkLexRet(202, S_3ARG); }
    if (!stricmp(yytext,"DFCopy"))        { honnor(1520); return mkLexRet(203, S_4ARG); }
    if (!stricmp(yytext,"Eval"))          { honnor(1520); return mkLexRet(204, S_1ARG); }
    if (!stricmp(yytext,"Account"))       { honnor(1520); return mkLexRet(205, S_2ARG); }
    if (!stricmp(yytext,"RecordUsage"))   { honnor(1520); return mkLexRet(206, S_5ARG); }
    if (!stricmp(yytext,"MsgToFile"))     { honnor(1520); return mkLexRet(207, S_3ARG); }
    if (!stricmp(yytext,"QwkLimits"))     { honnor(1520); return mkLexRet(208, S_2ARG); }
    if (!stricmp(yytext,"Command"))       { honnor(1521); return mkLexRet(209, S_2ARG); }
    if (!stricmp(yytext,"UseLMRs"))       { honnor(1522); return mkLexRet(210, S_1ARG); }
    if (!stricmp(yytext,"ConfInfo"))      { honnor(1522); return mkLexRet(211, S_3ARG); }
    if (!stricmp(yytext,"AdjTUBytes"))    { honnor(1522); return mkLexRet(212, S_1ARG); }
    if (!stricmp(yytext,"GrafMode"))      { honnor(1522); return mkLexRet(213, S_1ARG); }
    if (!stricmp(yytext,"AddUser"))       { mustHaveUvars("AddUser"); honnor(1522); return mkLexRet(214, S_2ARG); }
    if (!stricmp(yytext,"KillMsg"))       { honnor(1522); return mkLexRet(215, S_2ARG); }
    if (!stricmp(yytext,"ChDir"))         { honnor(1522); return mkLexRet(216, S_1ARG); }
    if (!stricmp(yytext,"MkDir"))         { honnor(1522); return mkLexRet(217, S_1ARG); }
    if (!stricmp(yytext,"RmDir"))         { honnor(1522); return mkLexRet(218, S_1ARG); }
    if (!stricmp(yytext,"FDOWrAka"))      { honnor(1522); return mkLexRet(219, S_2ARG); }
    if (!stricmp(yytext,"FDOAddAKA"))     { honnor(1522); return mkLexRet(220, S_3ARG); }
    if (!stricmp(yytext,"FDOWrOrg"))      { honnor(1522); return mkLexRet(221, S_2ARG); }
    if (!stricmp(yytext,"FDOAddOrg"))     { honnor(1522); return mkLexRet(222, S_3ARG); }
    if (!stricmp(yytext,"FDOQMod"))       { honnor(1522); return mkLexRet(223, S_4ARG); }
    if (!stricmp(yytext,"FDOqAdd"))       { honnor(1522); return mkLexRet(224, S_3ARG); }
    if (!stricmp(yytext,"FDOqDel"))       { honnor(1522); return mkLexRet(225, S_1ARG); }
    if (!stricmp(yytext,"SoundDelay"))    { honnor(1522); return mkLexRet(226, S_2ARG); }
    if (!stricmp(yytext,"EndProc"))       { honnor(1520); leaveProc(PROC_IDENTIFIER); identHdr=0; return mkLexRet(169, S_0ARG); }
    if (!stricmp(yytext,"EndFunc"))       { honnor(1520); leaveProc(FUNC_IDENTIFIER); identHdr=0; return mkLexRet(171, S_0ARG); }
    // Frontier Specific
    if (!stricmp(yytext,"Abort"))         { honnor(2000); return mkLexRet(400, S_1ARG); }
    if (!stricmp(yytext,"WrPcbSys"))      { honnor(2000); return mkLexRet(401, S_0ARG); }
    if (!stricmp(yytext,"Leave"))         { honnor(2000); return mkLexRet(402, S_1ARG); }
    if (!stricmp(yytext,"DPrint"))        { honnor(2000); return mkLexRet(403, S_1PARG); }
    if (!stricmp(yytext,"DPrintLn"))      { honnor(2000); return mkLexRet(404, S_0PARG); }
    if (!stricmp(yytext,"DCls"))          { honnor(2000); return mkLexRet(405, S_0ARG); }
    if (!stricmp(yytext,"DAnsiPos"))      { honnor(2000); return mkLexRet(406, S_2ARG); }
    if (!stricmp(yytext,"DSaveScrn"))     { honnor(2000); return mkLexRet(407, S_0ARG); }
    if (!stricmp(yytext,"DRestScrn"))     { honnor(2000); return mkLexRet(408, S_0ARG); }
    if (!stricmp(yytext,"AdvMessage"))    { honnor(2000); return mkLexRet(409, S_2ARG); }
    if (!stricmp(yytext,"SetRead"))       { honnor(2000); return mkLexRet(410, S_4ARG); }
    if (!stricmp(yytext,"KillTime"))      { honnor(2000); return mkLexRet(411, S_0ARG); }
    if (!stricmp(yytext,"GetSystemUser")) { honnor(2000); return mkLexRet(412, S_1ARG); }
    if (!stricmp(yytext,"ScreenCleared")) { honnor(2000); return mkLexRet(413, S_1ARG); }
    if (!stricmp(yytext,"UnKillMsg"))     { honnor(2000); return mkLexRet(414, S_2ARG); }
    if (!stricmp(yytext,"SetCarrier"))    { honnor(2000); return mkLexRet(416, S_1ARG); }
    if (!stricmp(yytext,"SetLocal"))      { honnor(2000); return mkLexRet(417, S_0ARG); }
    if (!stricmp(yytext,"SetComHand"))    { honnor(2000); return mkLexRet(418, S_1ARG); }
    if (!stricmp(yytext,"SetErrorCorrect")) { honnor(2000); return mkLexRet(419, S_1ARG); }
    if (!stricmp(yytext,"PutProfile"))    { honnor(2000); return mkLexRet(420, S_4ARG); }
    if (!stricmp(yytext,"SuspendCom"))    { honnor(2000); return mkLexRet(421, S_0ARG); }
    if (!stricmp(yytext,"RestoreCom"))    { honnor(2000); return mkLexRet(422, S_0ARG); }
    if (!stricmp(yytext,"CTokenize"))     { honnor(2000); return mkLexRet(423, S_2ARG); }
    if (!stricmp(yytext,"RegisterCmd"))   { honnor(2000); return mkLexRet(424, S_3ARG); }
    if (!stricmp(yytext,"InvalidCmds"))   { honnor(2000); return mkLexRet(425, S_0ARG); }
    if (!stricmp(yytext,"LoadConf"))      { honnor(2000); return mkLexRet(426, S_1ARG); }
    if (!stricmp(yytext,"Macros"))        { honnor(2000); return mkLexRet(427, S_1ARG); }
    if (!stricmp(yytext,"SAnsiPos"))      { honnor(2000); return mkLexRet(428, S_2ARG); }
    if (!stricmp(yytext,"PageText"))      { honnor(2000); return mkLexRet(429, S_1ARG); }
    if (!stricmp(yytext,"BigShell"))      { honnor(2000); return mkLexRet(430, S_4ARG); }
    if (!stricmp(yytext,"RdPcbSys"))      { honnor(2000); return mkLexRet(431, S_0ARG); }
    if (!stricmp(yytext,"SetCom"))        { honnor(2000); return mkLexRet(432, S_3ARG); }
    if (!stricmp(yytext,"SearchFileFind")){ honnor(2000); return mkLexRet(433, S_2ARG); }
    if (!stricmp(yytext,"ResetLog"))      { honnor(2000); return mkLexRet(434, S_0ARG); }
    if (!stricmp(yytext,"GetCom"))        { honnor(2000); return mkLexRet(435, S_3ARG); }
    if (!stricmp(yytext,"SCls"))          { honnor(2000); return mkLexRet(436, S_0ARG); }
    if (!stricmp(yytext,"WrFrtSys"))      { honnor(2000); return mkLexRet(437, S_0ARG); }
    if (!stricmp(yytext,"RdFrtSys"))      { honnor(2000); return mkLexRet(438, S_0ARG); }
    if (!stricmp(yytext,"AdjTUFiles"))    { honnor(2000); return mkLexRet(439, S_1ARG); }
    if (!stricmp(yytext,"SetTTime"))      { honnor(2000); return mkLexRet(440, S_1ARG); }
    if (!stricmp(yytext,"SetLang"))       { honnor(2000); return mkLexRet(441, S_2ARG); }
	}

if (!stricmp(yytext, "Len")) 		{ return mkLexRet(20, INTFUNC); }/*0xFFEC*/
if (!stricmp(yytext, "Lower")) 		{ return mkLexRet(21, INTFUNC); }/*0xFFEB*/
if (!stricmp(yytext, "Upper")) 		{ return mkLexRet(22, INTFUNC); }/*0xFFEA*/
if (!stricmp(yytext, "Mid")) 		{ return mkLexRet(23, INTFUNC); }/*0xFFE9*/
if (!stricmp(yytext, "Left")) 		{ return mkLexRet(24, INTFUNC); }/*0xFFE8*/
if (!stricmp(yytext, "Right")) 		{ return mkLexRet(25, INTFUNC); }/*0xFFE7*/
if (!stricmp(yytext, "Space")) 		{ return mkLexRet(26, INTFUNC); }/*0xFFE6*/
if (!stricmp(yytext, "Ferr")) 		{ return mkLexRet(27, INTFUNC); }/*0xFFE5*/
if (!stricmp(yytext, "Chr")) 		{ return mkLexRet(28, INTFUNC); }/*0xFFE4*/
if (!stricmp(yytext, "Asc")) 		{ return mkLexRet(29, INTFUNC); }/*0xFFE3*/
if (!stricmp(yytext, "InStr")) 		{ return mkLexRet(30, INTFUNC); }/*0xFFE2*/
if (!stricmp(yytext, "Abort")) 		{ return mkLexRet(31, INTFUNC); }/*0xFFE1*/
if (!stricmp(yytext, "LTrim")) 		{ return mkLexRet(32, INTFUNC); }/*0xFFE0*/
if (!stricmp(yytext, "RTrim")) 		{ return mkLexRet(33, INTFUNC); }/*0xFFDF*/
if (!stricmp(yytext, "Trim")) 		{ return mkLexRet(34, INTFUNC); }/*0xFFDE*/
if (!stricmp(yytext, "Random")) 	{ return mkLexRet(35, INTFUNC) ; }/*0xFFDD*/
if (!stricmp(yytext, "Date")) 		{ return mkLexRet(36, INTFUNC); }/*0xFFDC*/
if (!stricmp(yytext, "Time")) 		{ return mkLexRet(37, INTFUNC); }/*0xFFDB*/
if (!stricmp(yytext, "U_Name")) 	{ return mkLexRet(38, INTFUNC); }/*0xFFDA*/
if (!stricmp(yytext, "U_LDate"))	{ return mkLexRet(39, INTFUNC); }/*0xFFD9*/
if (!stricmp(yytext, "U_LTime"))	{ return mkLexRet(40, INTFUNC); }/*0xFFD8*/
if (!stricmp(yytext, "U_LDir")) 	{ return mkLexRet(41, INTFUNC); }/*0xFFD7*/
if (!stricmp(yytext, "U_Logons")) 	{ return mkLexRet(42, INTFUNC); }/*0xFFD6*/
if (!stricmp(yytext, "U_Ful")) 		{ return mkLexRet(43, INTFUNC); }/*0xFFD5*/
if (!stricmp(yytext, "U_Fdl")) 		{ return mkLexRet(44, INTFUNC); }/*0xFFD4*/
if (!stricmp(yytext, "U_BdlDay")) 	{ return mkLexRet(45, INTFUNC); }/*0xFFD3*/
if (!stricmp(yytext, "U_TimeOn")) 	{ return mkLexRet(46, INTFUNC); }/*0xFFD2*/
if (!stricmp(yytext, "U_Bdl")) 		{ return mkLexRet(47, INTFUNC); }/*0xFFD1*/
if (!stricmp(yytext, "U_Bul")) 		{ return mkLexRet(48, INTFUNC); }/*0xFFD0*/
if (!stricmp(yytext, "Year")) 		{ return mkLexRet(49, INTFUNC); }/*0xFFCF*/
if (!stricmp(yytext, "Month")) 		{ return mkLexRet(50, INTFUNC); }/*0xFFCE*/
if (!stricmp(yytext, "Day")) 		{ return mkLexRet(51, INTFUNC); }/*0xFFCD*/
if (!stricmp(yytext, "Dow")) 		{ return mkLexRet(52, INTFUNC); }/*0xFFCC*/
if (!stricmp(yytext, "Hour")) 		{ return mkLexRet(53, INTFUNC); }/*0xFFCB*/
if (!stricmp(yytext, "Min")) 		{ return mkLexRet(54, INTFUNC); }/*0xFFCA*/
if (!stricmp(yytext, "Sec")) 		{ return mkLexRet(55, INTFUNC); }/*0xFFC9*/
if (!stricmp(yytext, "TimeAp")) 	{ return mkLexRet(56, INTFUNC); }/*0xFFC8*/
if (!stricmp(yytext, "Ver")) 		{ return mkLexRet(57, INTFUNC); }/*0xFFC7*/
if (!stricmp(yytext, "NoChar")) 	{ return mkLexRet(58, INTFUNC); }/*0xFFC6*/
if (!stricmp(yytext, "YesChar")) 	{ return mkLexRet(59, INTFUNC); }/*0xFFC5*/
if (!stricmp(yytext, "StripAtx")) 	{ return mkLexRet(60, INTFUNC); }/*0xFFC4*/
if (!stricmp(yytext, "Replace")) 	{ return mkLexRet(61, INTFUNC); }/*0xFFC3*/
if (!stricmp(yytext, "Strip")) 		{ return mkLexRet(62, INTFUNC); }/*0xFFC2*/
if (!stricmp(yytext, "Inkey")) 		{ return mkLexRet(63, INTFUNC); }/*0xFFC1*/
if (!stricmp(yytext, "String")) 	{ return mkLexRet(64, INTFUNC); }/*0xFFC0*/
if (!stricmp(yytext, "ToString")) 	{ return mkLexRet(64, INTFUNC); }/*0xFFC0*/
if (!stricmp(yytext, "Mask_Pwd")) 	{ return mkLexRet(65, INTFUNC); }/*0xFFBF*/
if (!stricmp(yytext, "Mask_Alpha")) { return mkLexRet(66, INTFUNC); }/*0xFFBE*/
if (!stricmp(yytext, "Mask_Num")) 	{ return mkLexRet(67, INTFUNC); }/*0xFFBD*/
if (!stricmp(yytext, "Mask_AlNum"))	{ return mkLexRet(68, INTFUNC); }/*0xFFBC*/
if (!stricmp(yytext, "Mask_File")) 	{ return mkLexRet(69, INTFUNC); }/*0xFFBB*/
if (!stricmp(yytext, "Mask_Path")) 	{ return mkLexRet(70, INTFUNC); }/*0xFFBA*/
if (!stricmp(yytext, "Mask_Ascii"))	{ return mkLexRet(71, INTFUNC); }/*0xFFB9*/
if (!stricmp(yytext, "CurConf"))	{ return mkLexRet(72, INTFUNC); }/*0xFFB8*/
if (!stricmp(yytext, "PCBDat")) 	{ return mkLexRet(73, INTFUNC); }/*0xFFB7*/
if (!stricmp(yytext, "PPEPath")) 	{ return mkLexRet(74, INTFUNC); }/*0xFFB6*/
if (!stricmp(yytext, "ValDate")) 	{ return mkLexRet(75, INTFUNC); }/*0xFFB5*/
if (!stricmp(yytext, "ValTime")) 	{ return mkLexRet(76, INTFUNC); }/*0xFFB4*/
if (!stricmp(yytext, "U_MsgRd")) 	{ return mkLexRet(77, INTFUNC); }/*0xFFB3*/
if (!stricmp(yytext, "U_MsgWr")) 	{ return mkLexRet(78, INTFUNC); }/*0xFFB2*/
if (!stricmp(yytext, "PcbNode")) 	{ return mkLexRet(79, INTFUNC); }/*0xFFB1*/
if (!stricmp(yytext, "FrtNode")) 	{ return mkLexRet(79, INTFUNC); }/*0xFFB1*/
if (!stricmp(yytext, "ReadLine")) 	{ return mkLexRet(80, INTFUNC); }/*0xFFB0*/
if (!stricmp(yytext, "SysopSec")) 	{ return mkLexRet(81, INTFUNC); }/*0xFFAF*/
if (!stricmp(yytext, "OnLocal")) 	{ return mkLexRet(82, INTFUNC); }/*0xFFAE*/
if (!stricmp(yytext, "UN_Stat")) 	{ return mkLexRet(83, INTFUNC); }/*0xFFAD*/
if (!stricmp(yytext, "UN_Name")) 	{ return mkLexRet(84, INTFUNC); }/*0xFFAC*/
if (!stricmp(yytext, "UN_City")) 	{ return mkLexRet(85, INTFUNC); }/*0xFFAB*/
if (!stricmp(yytext, "UN_Oper")) 	{ return mkLexRet(86, INTFUNC); }/*0xFFAA*/
if (!stricmp(yytext, "CurSec")) 	{ return mkLexRet(87, INTFUNC); }/*0xFFA9*/
if (!stricmp(yytext, "GetToken")) 	{ return mkLexRet(88, INTFUNC); }/*0xFFA8*/
if (!stricmp(yytext, "MinLeft")) 	{ return mkLexRet(89, INTFUNC); }/*0xFFA7*/
if (!stricmp(yytext, "MinOn")) 		{ return mkLexRet(90, INTFUNC); }/*0xFFA6*/
if (!stricmp(yytext, "GetEnv")) 	{ return mkLexRet(91, INTFUNC); }/*0xFFA5*/
if (!stricmp(yytext, "CallId")) 	{ return mkLexRet(92, INTFUNC); }/*0xFFA4*/
if (!stricmp(yytext, "RegAL")) 		{ return mkLexRet(93, INTFUNC); }/*0xFFA3*/
if (!stricmp(yytext, "RegAH")) 		{ return mkLexRet(94, INTFUNC); }/*0xFFA2*/
if (!stricmp(yytext, "RegBL")) 		{ return mkLexRet(95, INTFUNC); }/*0xFFA1*/
if (!stricmp(yytext, "RegBH")) 		{ return mkLexRet(96, INTFUNC); }/*0xFFA0*/
if (!stricmp(yytext, "RegCL")) 		{ return mkLexRet(97, INTFUNC); }/*0xFF9F*/
if (!stricmp(yytext, "RegCH")) 		{ return mkLexRet(98, INTFUNC); }/*0xFF9E*/
if (!stricmp(yytext, "RegDL")) 		{ return mkLexRet(99, INTFUNC); }/*0xFF9D*/
if (!stricmp(yytext, "RegDH")) 		{ return mkLexRet(100, INTFUNC); }/*0xFF9C*/
if (!stricmp(yytext, "RegAX")) 		{ return mkLexRet(101, INTFUNC); }/*0xFF9B*/
if (!stricmp(yytext, "RegBX")) 		{ return mkLexRet(102, INTFUNC); }/*0xFF9A*/
if (!stricmp(yytext, "RegCX")) 		{ return mkLexRet(103, INTFUNC); }/*0xFF99*/
if (!stricmp(yytext, "RegDX")) 		{ return mkLexRet(104, INTFUNC); }/*0xFF98*/
if (!stricmp(yytext, "RegSI")) 		{ return mkLexRet(105, INTFUNC); }/*0xFF97*/
if (!stricmp(yytext, "RegDI")) 		{ return mkLexRet(106, INTFUNC); }/*0xFF96*/
if (!stricmp(yytext, "RegF")) 		{ return mkLexRet(107, INTFUNC); }/*0xFF95*/
if (!stricmp(yytext, "RegCF")) 		{ return mkLexRet(108, INTFUNC); }/*0xFF94*/
if (!stricmp(yytext, "RegDS")) 		{ return mkLexRet(109, INTFUNC); }/*0xFF93*/
if (!stricmp(yytext, "RegES")) 		{ return mkLexRet(110, INTFUNC); }/*0xFF92*/
if (!stricmp(yytext, "B2W")) 		{ return mkLexRet(111, INTFUNC); }/*0xFF91*/
if (!stricmp(yytext, "Peek")) 		{ return mkLexRet(112, INTFUNC); }/*0xFF90*/
if (!stricmp(yytext, "Peekb")) 		{ return mkLexRet(112, INTFUNC); }/*0xFF90*/
if (!stricmp(yytext, "PeekW")) 		{ return mkLexRet(113, INTFUNC); }/*0xFF8F*/
if (!stricmp(yytext, "MkAddr")) 	{ return mkLexRet(114, INTFUNC); }/*0xFF8E*/
if (!stricmp(yytext, "Exist")) 		{ return mkLexRet(115, INTFUNC); }/*0xFF8D*/
if (!stricmp(yytext, "I2S")) 		{ return mkLexRet(116, INTFUNC); }/*0xFF8C*/
if (!stricmp(yytext, "S2I")) 		{ return mkLexRet(117, INTFUNC); }/*0xFF8B*/
if (!stricmp(yytext, "Carrier")) 	{ return mkLexRet(118, INTFUNC); }/*0xFF8A*/
if (!stricmp(yytext, "TokenStr")) 	{ return mkLexRet(119, INTFUNC); }/*0xFF89*/
if (!stricmp(yytext, "CDOn")) 		{ return mkLexRet(120, INTFUNC); }/*0xFF88*/
if (!stricmp(yytext, "LangExt")) 	{ return mkLexRet(121, INTFUNC); }/*0xFF87*/
if (!stricmp(yytext, "AnsiOn")) 	{ return mkLexRet(122, INTFUNC); }/*0xFF86*/
if (!stricmp(yytext, "ValCC")) 		{ return mkLexRet(123, INTFUNC); }/*0xFF85*/
if (!stricmp(yytext, "FmtCC")) 		{ return mkLexRet(124, INTFUNC); }/*0xFF84*/
if (!stricmp(yytext, "CCType")) 	{ return mkLexRet(125, INTFUNC); }/*0xFF83*/
if (!stricmp(yytext, "GetX")) 		{ return mkLexRet(126, INTFUNC); }/*0xFF82*/
if (!stricmp(yytext, "GetY")) 		{ return mkLexRet(127, INTFUNC); }/*0xFF81*/
if (!stricmp(yytext, "And")) 		{ return mkLexRet(128, INTFUNC); }/*0xFF80*/
if (!stricmp(yytext, "Or")) 		{ return mkLexRet(129, INTFUNC); }/*0xFF7F*/
if (!stricmp(yytext, "XOr")) 		{ return mkLexRet(130, INTFUNC); }/*0xFF7E*/
if (!stricmp(yytext, "Not")) 		{ return mkLexRet(131, INTFUNC); }/*0xFF7D*/
if (!stricmp(yytext, "U_PwdHist")) 	{ return mkLexRet(132, INTFUNC); }/*0xFF7C*/
if (!stricmp(yytext, "U_PwdLc")) 	{ return mkLexRet(133, INTFUNC); }/*0xFF7B*/
if (!stricmp(yytext, "U_PwdTc")) 	{ return mkLexRet(134, INTFUNC); }/*0xFF7A*/
if (!stricmp(yytext, "U_Stat")) 	{ return mkLexRet(135, INTFUNC); }/*0xFF79*/
if (!stricmp(yytext, "DefColor")) 	{ return mkLexRet(136, INTFUNC); }/*0xFF78*/
if (!stricmp(yytext, "Abs")) 		{ return mkLexRet(137, INTFUNC); }/*0xFF77*/
if (!stricmp(yytext, "GrafMode")) 	{ return mkLexRet(138, INTFUNC); }/*0xFF76*/
if (!stricmp(yytext, "Psa")) 		{ return mkLexRet(139, INTFUNC); }/*0xFF75*/
if (!stricmp(yytext, "FileInf")) 	{ return mkLexRet(140, INTFUNC); }/*0xFF74*/
if (!stricmp(yytext, "PPEName")) 	{ return mkLexRet(141, INTFUNC); }/*0xFF73*/
if (!stricmp(yytext, "MkDate")) 	{ return mkLexRet(142, INTFUNC); }/*0xFF72*/
if (!stricmp(yytext, "CurColor")) 	{ return mkLexRet(143, INTFUNC); }/*0xFF71*/
if (!stricmp(yytext, "KInkey")) 	{ return mkLexRet(144, INTFUNC); }/*0xFF70*/
if (!stricmp(yytext, "MInkey")) 	{ return mkLexRet(145, INTFUNC); }/*0xFF6F*/
if (!stricmp(yytext, "MaxNode")) 	{ return mkLexRet(146, INTFUNC); }/*0xFF6E*/
if (!stricmp(yytext, "SlPath")) 	{ return mkLexRet(147, INTFUNC); }/*0xFF6D*/
if (!stricmp(yytext, "HelpPath")) 	{ return mkLexRet(148, INTFUNC); }/*0xFF6C*/
if (!stricmp(yytext, "TempPath")) 	{ return mkLexRet(149, INTFUNC); }/*0xFF6B*/
if (!stricmp(yytext, "Modem")) 		{ return mkLexRet(150, INTFUNC); }/*0xFF6A*/
if (!stricmp(yytext, "LoggedOn")) 	{ return mkLexRet(151, INTFUNC); }/*0xFF69*/
if (!stricmp(yytext, "CallNum")) 	{ return mkLexRet(152, INTFUNC); }/*0xFF68*/
if (!stricmp(yytext, "MGetByte")) 	{ return mkLexRet(153, INTFUNC); }/*0xFF67*/
if (!stricmp(yytext, "TokCount")) 	{ return mkLexRet(154, INTFUNC); }/*0xFF66*/
if (!stricmp(yytext, "U_RecNum")) 	{ return mkLexRet(155, INTFUNC); }/*0xFF65*/
if (!stricmp(yytext, "U_InConf")) 	{ return mkLexRet(156, INTFUNC); }/*0xFF64*/
if (!stricmp(yytext, "PeekDW")) 	{ return mkLexRet(157, INTFUNC); }/*0xFF63*/
if (!stricmp(yytext, "DbgLevel")) 	{ return mkLexRet(158, INTFUNC); }/*0xFF62*/
if (!stricmp(yytext, "ScrText")) 	{ return mkLexRet(159, INTFUNC); }/*0xFF61*/
if (!stricmp(yytext, "ShowStat")) 	{ return mkLexRet(160, INTFUNC); }/*0xFF60*/
if (!stricmp(yytext, "PageStat")) 	{ return mkLexRet(161, INTFUNC); }/*0xFF5F*/
if (!stricmp(yytext, "ReplaceStr")) { return mkLexRet(162, INTFUNC); }/*0xFF5E*/
if (!stricmp(yytext, "StripStr")) 	{ return mkLexRet(163, INTFUNC); }/*0xFF5D*/
if (!stricmp(yytext, "ToBigStr")) 	{ return mkLexRet(164, INTFUNC); }/*0xFF5C*/
if (!stricmp(yytext, "ToBoolean")) 	{ return mkLexRet(165, INTFUNC); }/*0xFF5B*/
if (!stricmp(yytext, "ToByte")) 	{ return mkLexRet(166, INTFUNC); }/*0xFF5A*/
if (!stricmp(yytext, "ToUByte")) 	{ return mkLexRet(166, INTFUNC); }/*0xFF5A*/
if (!stricmp(yytext, "ToDate")) 	{ return mkLexRet(167, INTFUNC); }/*0xFF59*/
if (!stricmp(yytext, "ToDouble")) 	{ return mkLexRet(168, INTFUNC); }/*0xFF58*/
if (!stricmp(yytext, "ToEDate")) 	{ return mkLexRet(169, INTFUNC); }/*0xFF57*/
if (!stricmp(yytext, "ToInteger")) 	{ return mkLexRet(170, INTFUNC); }/*0xFF56*/
if (!stricmp(yytext, "ToSDWord")) 	{ return mkLexRet(170, INTFUNC); }/*0xFF56*/
if (!stricmp(yytext, "ToLong")) 	{ return mkLexRet(170, INTFUNC); }/*0xFF56*/
if (!stricmp(yytext, "ToMoney")) 	{ return mkLexRet(171, INTFUNC); }/*0xFF55*/
if (!stricmp(yytext, "ToReal")) 	{ return mkLexRet(172, INTFUNC); }/*0xFF54*/
if (!stricmp(yytext, "ToFloat")) 	{ return mkLexRet(172, INTFUNC); }/*0xFF54*/
if (!stricmp(yytext, "ToShort")) 	{ return mkLexRet(173, INTFUNC); }/*0xFF53*/
if (!stricmp(yytext, "ToSByte")) 	{ return mkLexRet(173, INTFUNC); }/*0xFF53*/
if (!stricmp(yytext, "ToInt")) 		{ return mkLexRet(174, INTFUNC); }/*0xFF52*/
if (!stricmp(yytext, "ToSWord")) 	{ return mkLexRet(174, INTFUNC); }/*0xFF52*/
if (!stricmp(yytext, "ToTime")) 	{ return mkLexRet(175, INTFUNC); }/*0xFF51*/
if (!stricmp(yytext, "ToDWord")) 	{ return mkLexRet(176, INTFUNC); }/*0xFF50*/
if (!stricmp(yytext, "ToUnsigned")) { return mkLexRet(176, INTFUNC); }/*0xFF50*/
if (!stricmp(yytext, "ToUDWord")) 	{ return mkLexRet(176, INTFUNC); }/*0xFF50*/
if (!stricmp(yytext, "ToWord")) 	{ return mkLexRet(177, INTFUNC); }/*0xFF4F*/
if (!stricmp(yytext, "ToUWord")) 	{ return mkLexRet(177, INTFUNC); }/*0xFF4F*/
if (!stricmp(yytext, "Mixed")) 		{ return mkLexRet(178, INTFUNC); }/*0xFF4E*/
if (!stricmp(yytext, "Alias")) 		{ return mkLexRet(179, INTFUNC); }/*0xFF4D*/
if (!stricmp(yytext, "ConfReg")) 	{ return mkLexRet(180, INTFUNC); }/*0xFF4C*/
if (!stricmp(yytext, "ConfExp")) 	{ return mkLexRet(181, INTFUNC); }/*0xFF4B*/
if (!stricmp(yytext, "ConfSel")) 	{ return mkLexRet(182, INTFUNC); }/*0xFF4A*/
if (!stricmp(yytext, "ConfSys")) 	{ return mkLexRet(183, INTFUNC); }/*0xFF49*/
if (!stricmp(yytext, "ConfMW")) 	{ return mkLexRet(184, INTFUNC); }/*0xFF48*/
if (!stricmp(yytext, "LPrinted")) 	{ return mkLexRet(185, INTFUNC); }/*0xFF47*/
if (!stricmp(yytext, "IsNonStop")) 	{ return mkLexRet(186, INTFUNC); }/*0xFF46*/
if (!stricmp(yytext, "ErrCorrect")) { return mkLexRet(187, INTFUNC); }/*0xFF45*/
if (!stricmp(yytext, "ConfAlias")) 	{ return mkLexRet(188, INTFUNC); }/*0xFF44*/
if (!stricmp(yytext, "UserAlias")) 	{ return mkLexRet(189, INTFUNC); }/*0xFF43*/
if (!stricmp(yytext, "CurUser")) 	{ return mkLexRet(190, INTFUNC); }/*0xFF42*/
if (!stricmp(yytext, "U_Lmr")) 		{ return mkLexRet(191, INTFUNC); }/*0xFF41*/
if (!stricmp(yytext, "ChatStat")) 	{ return mkLexRet(192, INTFUNC); }/*0xFF40*/
if (!stricmp(yytext, "DefAns")) 	{ return mkLexRet(193, INTFUNC); }/*0xFF3F*/
if (!stricmp(yytext, "LastAns")) 	{ return mkLexRet(194, INTFUNC); }/*0xFF3E*/
if (!stricmp(yytext, "MegaNum")) 	{ return mkLexRet(195, INTFUNC); }/*0xFF3D*/
if (!stricmp(yytext, "EvtTimeAdj")) { return mkLexRet(196, INTFUNC); }/*0xFF3C*/
if (!stricmp(yytext, "IsBitSet")) 	{ return mkLexRet(197, INTFUNC); }/*0xFF3B*/
if (!stricmp(yytext, "FmtReal")) 	{ return mkLexRet(198, INTFUNC); }/*0xFF3A*/
if (!stricmp(yytext, "FlagCnt")) 	{ return mkLexRet(199, INTFUNC); }/*0xFF39*/
if (!stricmp(yytext, "KbdBufSize")) { return mkLexRet(200, INTFUNC); }/*0xFF38*/
if (!stricmp(yytext, "PPLBufSize")) { return mkLexRet(201, INTFUNC); }/*0xFF37*/
if (!stricmp(yytext, "KbdFilUsed")) { return mkLexRet(202, INTFUNC); }/*0xFF36*/
if (!stricmp(yytext, "LoMsgNum")) 	{ return mkLexRet(203, INTFUNC); }/*0xFF35*/
if (!stricmp(yytext, "HiMsgNum")) 	{ return mkLexRet(204, INTFUNC); }/*0xFF34*/
if (!stricmp(yytext, "DriveSpace")) { honnor(1520); return mkLexRet(205, INTFUNC); }/*0xFF33*/
if (!stricmp(yytext, "OutBytes")) 	{ honnor(1520); return mkLexRet(206, INTFUNC); }/*0xFF32*/
if (!stricmp(yytext, "HiConfNum")) 	{ honnor(1520); return mkLexRet(207, INTFUNC); }/*0xFF31*/
if (!stricmp(yytext, "InBytes")) 	{ honnor(1520); return mkLexRet(208, INTFUNC); }/*0xFF30*/
if (!stricmp(yytext, "Crc32")) 		{ honnor(1520); return mkLexRet(209, INTFUNC); }/*0xFF2F*/
if (!stricmp(yytext, "PCBMac")) 	{ honnor(1520); return mkLexRet(210, INTFUNC); }/*0xFF2E*/
if (!stricmp(yytext, "FrtMac")) 	{ honnor(1520); return mkLexRet(210, INTFUNC); }/*0xFF2E*/
if (!stricmp(yytext, "ActMsgNum")) 	{ honnor(1520); return mkLexRet(211, INTFUNC); }/*0xFF2D*/
if (!stricmp(yytext, "StackLeft")) 	{ honnor(1520); return mkLexRet(212, INTFUNC); }/*0xFF2C*/
if (!stricmp(yytext, "StackErr")) 	{ honnor(1520); return mkLexRet(213, INTFUNC); }/*0xFF2B*/
if (!stricmp(yytext, "DGetAlias")) 	{ honnor(1520); return mkLexRet(214, INTFUNC); }/*0xFF2A*/
if (!stricmp(yytext, "DBof")) 		{ honnor(1520); return mkLexRet(215, INTFUNC); }/*0xFF29*/
if (!stricmp(yytext, "DChanged")) 	{ honnor(1520); return mkLexRet(216, INTFUNC); }/*0xFF28*/
if (!stricmp(yytext, "DDecimals")) 	{ honnor(1520); return mkLexRet(217, INTFUNC); }/*0xFF27*/
if (!stricmp(yytext, "DDeleted")) 	{ honnor(1520); return mkLexRet(218, INTFUNC); }/*0xFF26*/
if (!stricmp(yytext, "DEof")) 		{ honnor(1520); return mkLexRet(219, INTFUNC); }/*0xFF25*/
if (!stricmp(yytext, "DErr")) 		{ honnor(1520); return mkLexRet(220, INTFUNC); }/*0xFF24*/
if (!stricmp(yytext, "DFields")) 	{ honnor(1520); return mkLexRet(221, INTFUNC); }/*0xFF23*/
if (!stricmp(yytext, "DLength")) 	{ honnor(1520); return mkLexRet(222, INTFUNC); }/*0xFF22*/
if (!stricmp(yytext, "DName")) 		{ honnor(1520); return mkLexRet(223, INTFUNC); }/*0xFF21*/
if (!stricmp(yytext, "DRecCount")) 	{ honnor(1520); return mkLexRet(224, INTFUNC); }/*0xFF20*/
if (!stricmp(yytext, "DRecNo")) 	{ honnor(1520); return mkLexRet(225, INTFUNC); }/*0xFF1F*/
if (!stricmp(yytext, "DType")) 		{ honnor(1520); return mkLexRet(226, INTFUNC); }/*0xFF1E*/
if (!stricmp(yytext, "FNext")) 		{ honnor(1520); return mkLexRet(227, INTFUNC); }/*0xFF1D*/
if (!stricmp(yytext, "DNext")) 		{ honnor(1520); return mkLexRet(228, INTFUNC); }/*0xFF1C*/
if (!stricmp(yytext, "ToDDate")) 	{ honnor(1520); return mkLexRet(229, INTFUNC); }/*0xFF1B*/
if (!stricmp(yytext, "DCloseAll")) 	{ honnor(1520); return mkLexRet(230, INTFUNC); }/*0xFF1A*/
if (!stricmp(yytext, "DOpen")) 		{ honnor(1520); return mkLexRet(231, INTFUNC); }/*0xFF19*/
if (!stricmp(yytext, "DClose")) 	{ honnor(1520); return mkLexRet(232, INTFUNC); }/*0xFF18*/
if (!stricmp(yytext, "DSetAlias")) 	{ honnor(1520); return mkLexRet(233, INTFUNC); }/*0xFF17*/
if (!stricmp(yytext, "DPack")) 		{ honnor(1520); return mkLexRet(234, INTFUNC); }/*0xFF16*/
if (!stricmp(yytext, "DLockF")) 	{ honnor(1520); return mkLexRet(235, INTFUNC); }/*0xFF15*/
if (!stricmp(yytext, "DLock")) 		{ honnor(1520); return mkLexRet(236, INTFUNC); }/*0xFF14*/
if (!stricmp(yytext, "DLockR")) 	{ honnor(1520); return mkLexRet(237, INTFUNC); }/*0xFF13*/
if (!stricmp(yytext, "DUnlock")) 	{ honnor(1520); return mkLexRet(238, INTFUNC); }/*0xFF12*/
if (!stricmp(yytext, "DNOpen")) 	{ honnor(1520); return mkLexRet(239, INTFUNC); }/*0xFF11*/
if (!stricmp(yytext, "DNClose")) 	{ honnor(1520); return mkLexRet(240, INTFUNC); }/*0xFF10*/
if (!stricmp(yytext, "DNCloseAll")) { honnor(1520); return mkLexRet(241, INTFUNC); }/*0xFF0F*/
if (!stricmp(yytext, "DNew")) 		{ honnor(1520); return mkLexRet(242, INTFUNC); }/*0xFF0E*/
if (!stricmp(yytext, "DAdd")) 		{ honnor(1520); return mkLexRet(243, INTFUNC); }/*0xFF0D*/
if (!stricmp(yytext, "DAppend")) 	{ honnor(1520); return mkLexRet(244, INTFUNC); }/*0xFF0C*/
if (!stricmp(yytext, "DTop")) 		{ honnor(1520); return mkLexRet(245, INTFUNC); }/*0xFF0B*/
if (!stricmp(yytext, "DGo")) 		{ honnor(1520); return mkLexRet(246, INTFUNC); }/*0xFF0A*/
if (!stricmp(yytext, "DBottom")) 	{ honnor(1520); return mkLexRet(247, INTFUNC); }/*0xFF09*/
if (!stricmp(yytext, "DSkip")) 		{ honnor(1520); return mkLexRet(248, INTFUNC); }/*0xFF08*/
if (!stricmp(yytext, "DBlank")) 	{ honnor(1520); return mkLexRet(249, INTFUNC); }/*0xFF07*/
if (!stricmp(yytext, "DDelete")) 	{ honnor(1520); return mkLexRet(250, INTFUNC); }/*0xFF06*/
if (!stricmp(yytext, "DRecall")) 	{ honnor(1520); return mkLexRet(251, INTFUNC); }/*0xFF05*/
if (!stricmp(yytext, "DTag")) 		{ honnor(1520); return mkLexRet(252, INTFUNC); }/*0xFF04*/
if (!stricmp(yytext, "DSeek")) 		{ honnor(1520); return mkLexRet(253, INTFUNC); }/*0xFF03*/
if (!stricmp(yytext, "DFBlank")) 	{ honnor(1520); return mkLexRet(254, INTFUNC); }/*0xFF02*/
if (!stricmp(yytext, "DGet")) 		{ honnor(1520); return mkLexRet(255, INTFUNC); }/*0xFF01*/
if (!stricmp(yytext, "DPut")) 		{ honnor(1520); return mkLexRet(256, INTFUNC); }/*0xFF00*/
if (!stricmp(yytext, "DFCopy")) 	{ honnor(1520); return mkLexRet(257, INTFUNC); }/*0xFEFF*/
if (!stricmp(yytext, "DSelect")) 	{ honnor(1520); return mkLexRet(258, INTFUNC); }/*0xFEFE*/
if (!stricmp(yytext, "DChkStat")) 	{ honnor(1520); return mkLexRet(259, INTFUNC); }/*0xFEFD*/
if (!stricmp(yytext, "PCBAccount")) { honnor(1520); return mkLexRet(260, INTFUNC); }/*0xFEFC*/
if (!stricmp(yytext, "PCBAccStat")) { honnor(1520); return mkLexRet(261, INTFUNC); }/*0xFEFB*/
if (!stricmp(yytext, "DErrMsg")) 	{ honnor(1520); return mkLexRet(262, INTFUNC); }/*0xFEFA*/
if (!stricmp(yytext, "Account")) 	{ honnor(1520); return mkLexRet(263, INTFUNC); }/*0xFEF9*/
if (!stricmp(yytext, "ScanMsgHdr")) { honnor(1520); return mkLexRet(264, INTFUNC); }/*0xFEF8*/
if (!stricmp(yytext, "CheckRip")) 	{ honnor(1520); return mkLexRet(265, INTFUNC); }/*0xFEF7*/
if (!stricmp(yytext, "RipVer")) 	{ honnor(1520); return mkLexRet(266, INTFUNC); }/*0xFEF6*/
if (!stricmp(yytext, "QwkLimits")) 	{ honnor(1520); return mkLexRet(267, INTFUNC); }/*0xFEF5*/
if (!stricmp(yytext, "FindFirst")) 	{ honnor(1521); return mkLexRet(268, INTFUNC); }/*0xFEF4*/
if (!stricmp(yytext, "FindNext")) 	{ honnor(1521); return mkLexRet(269, INTFUNC); }/*0xFEF3*/
if (!stricmp(yytext, "UseLMRs")) 	{ honnor(1522); return mkLexRet(270, INTFUNC); }/*0xFEF2*/
if (!stricmp(yytext, "ConfInfo")) 	{ honnor(1522); return mkLexRet(271, INTFUNC); }/*0xFEF1*/
if (!stricmp(yytext, "TInkey")) 	{ honnor(1522); return mkLexRet(272, INTFUNC); }/*0xFEF0*/
if (!stricmp(yytext, "Cwd")) 		{ honnor(1522); return mkLexRet(273, INTFUNC); }/*0xFEEF*/
if (!stricmp(yytext, "InStrR")) 	{ honnor(1522); return mkLexRet(274, INTFUNC); }/*0xFEEE*/
if (!stricmp(yytext, "FDORdAka")) 	{ honnor(1522); return mkLexRet(275, INTFUNC); }/*0xFEED*/
if (!stricmp(yytext, "FDORdOrg")) 	{ honnor(1522); return mkLexRet(276, INTFUNC); }/*0xFEEC*/
if (!stricmp(yytext, "FDORdArea"))	{ honnor(1522); return mkLexRet(277, INTFUNC); }/*0xFEEB*/
if (!stricmp(yytext, "FDOQrd")) 	{ honnor(1522); return mkLexRet(278, INTFUNC); }/*0xFEEB*/
if (!stricmp(yytext, "GetDrive")) 	{ honnor(1522); return mkLexRet(279, INTFUNC); }/*0xFEE9*/
if (!stricmp(yytext, "SetDrive")) 	{ honnor(1522); return mkLexRet(280, INTFUNC); }/*0xFEE8*/
if (!stricmp(yytext, "Bs2I")) 		{ honnor(1522); return mkLexRet(281, INTFUNC); }/*0xFEE7*/
if (!stricmp(yytext, "Bd2I")) 		{ honnor(1522); return mkLexRet(282, INTFUNC); }/*0xFEE6*/
if (!stricmp(yytext, "I2Bs")) 		{ honnor(1522); return mkLexRet(283, INTFUNC); }/*0xFEE5*/
if (!stricmp(yytext, "I2Bd")) 		{ honnor(1522); return mkLexRet(284, INTFUNC); }/*0xFEE4*/
if (!stricmp(yytext, "FTell")) 		{ honnor(1522); return mkLexRet(285, INTFUNC); }/*0xFEE3*/
if (!stricmp(yytext, "Os")) 		{ honnor(1522); return mkLexRet(286, INTFUNC); }/*0xFEE2*/
if (!stricmp(yytext,"DScrText")) 	{ honnor(2000); return mkLexRet(400, INTFUNC); }
if (!stricmp(yytext,"DGetX")) 	    { honnor(2000); return mkLexRet(401, INTFUNC); }
if (!stricmp(yytext,"DGetY")) 	    { honnor(2000); return mkLexRet(402, INTFUNC); }
if (!stricmp(yytext,"DualScr")) 	{ honnor(2000); return mkLexRet(403, INTFUNC); }
if (!stricmp(yytext,"ConfName"))    { honnor(2000); return mkLexRet(404, INTFUNC); }
if (!stricmp(yytext,"SystemPath"))  { honnor(2000); return mkLexRet(405, INTFUNC); }
if (!stricmp(yytext,"Beta"))        { honnor(2000); return mkLexRet(406, INTFUNC); }
if (!stricmp(yytext,"ScreenCleared")) { honnor(2000); return mkLexRet(407, INTFUNC); }
if (!stricmp(yytext,"Call"))        { honnor(2000); return mkLexRet(408, INTFUNC); }
if (!stricmp(yytext,"LastExitValue")) { honnor(2000); return mkLexRet(409, INTFUNC); }
if (!stricmp(yytext,"Free"))        { honnor(2000); return mkLexRet(410, INTFUNC); }
if (!stricmp(yytext,"ComInit"))     { honnor(2000); return mkLexRet(411, INTFUNC); }
if (!stricmp(yytext,"GetComStat"))  { honnor(2000); return mkLexRet(412, INTFUNC); }
if (!stricmp(yytext,"GetUartType")) { honnor(2000); return mkLexRet(413, INTFUNC); }
if (!stricmp(yytext,"GetProfile"))  { honnor(2000); return mkLexRet(414, INTFUNC); }
if (!stricmp(yytext,"FrtIni"))      { honnor(2000); return mkLexRet(415, INTFUNC); }
if (!stricmp(yytext,"FileMatch"))   { honnor(2000); return mkLexRet(416, INTFUNC); }
if (!stricmp(yytext,"GetNextMsg"))  { honnor(2000); return mkLexRet(417, INTFUNC); }
if (!stricmp(yytext,"HiMsgNumC")) 	{ honnor(2000); return mkLexRet(418, INTFUNC); }
if (!stricmp(yytext,"LoMsgNumC")) 	{ honnor(2000); return mkLexRet(419, INTFUNC); }
if (!stricmp(yytext,"RootPath")) 	{ honnor(2000); return mkLexRet(420, INTFUNC); }
if (!stricmp(yytext,"ToSDate")) 	{ honnor(2000); return mkLexRet(421, INTFUNC); }
if (!stricmp(yytext,"LangFile")) 	{ honnor(2000); return mkLexRet(422, INTFUNC); }

if (!stricmp(yytext,"AUTO")) strcpy(predefValue, "8192");
if (!stricmp(yytext,"BELL")) strcpy(predefValue, "2048");
if (!stricmp(yytext,"CRC_FILE")) strcpy(predefValue, "1");
if (!stricmp(yytext,"CRC_STR")) strcpy(predefValue, "0");
if (!stricmp(yytext,"CUR_USER")) strcpy(predefValue, "0");
if (!stricmp(yytext,"DEFS")) strcpy(predefValue, "0");
if (!stricmp(yytext,"ECHODOTS")) strcpy(predefValue, "1");
if (!stricmp(yytext,"ERASELINE")) strcpy(predefValue, "32");
if (!stricmp(yytext,"FALSE")) strcpy(predefValue, "0");
if (!stricmp(yytext,"FCL")) strcpy(predefValue, "2");
if (!stricmp(yytext,"FIELDLEN")) strcpy(predefValue, "2");
if (!stricmp(yytext,"FNS")) strcpy(predefValue, "1");
if (!stricmp(yytext,"F_EXP")) strcpy(predefValue, "2");
if (!stricmp(yytext,"F_MW")) strcpy(predefValue, "16");
if (!stricmp(yytext,"F_REG")) strcpy(predefValue, "1");
if (!stricmp(yytext,"F_SEL")) strcpy(predefValue, "4");
if (!stricmp(yytext,"F_SYS")) strcpy(predefValue, "8");
if (!stricmp(yytext,"GRAPH")) strcpy(predefValue, "1");
if (!stricmp(yytext,"GUIDE")) strcpy(predefValue, "4");
if (!stricmp(yytext,"HIGHASCII")) strcpy(predefValue, "4096");
if (!stricmp(yytext,"LANG")) strcpy(predefValue, "4");
if (!stricmp(yytext,"LFAFTER")) strcpy(predefValue, "256");
if (!stricmp(yytext,"LFBEFORE")) strcpy(predefValue, "128");
if (!stricmp(yytext,"LOGIT")) strcpy(predefValue, "32768");
if (!stricmp(yytext,"LOGITLEFT")) strcpy(predefValue, "65536");
if (!stricmp(yytext,"NC")) strcpy(predefValue, "0");
if (!stricmp(yytext,"NEWLINE")) strcpy(predefValue, "64");
if (!stricmp(yytext,"NOCLEAR")) strcpy(predefValue, "1024");
if (!stricmp(yytext,"NO_USER")) strcpy(predefValue, "-1");
if (!stricmp(yytext,"O_RD")) strcpy(predefValue, "0");
if (!stricmp(yytext,"O_RW")) strcpy(predefValue, "2");
if (!stricmp(yytext,"O_WR")) strcpy(predefValue, "1");
if (!stricmp(yytext,"SECUR")) strcpy(predefValue, "2");
if (!stricmp(yytext,"STACKED")) strcpy(predefValue, "16");
if (!stricmp(yytext,"S_DB")) strcpy(predefValue, "3");
if (!stricmp(yytext,"S_DN")) strcpy(predefValue, "0");
if (!stricmp(yytext,"S_DR")) strcpy(predefValue, "1");
if (!stricmp(yytext,"S_DW")) strcpy(predefValue, "2");
if (!stricmp(yytext,"TRUE")) strcpy(predefValue, "1");
if (!stricmp(yytext,"UPCASE")) strcpy(predefValue, "8");
if (!stricmp(yytext,"WORDWRAP")) strcpy(predefValue, "512");
if (!stricmp(yytext,"YESNO")) strcpy(predefValue, "16384");
if (!stricmp(yytext,"NO_USER")) strcpy(predefValue, "-1");
if (!stricmp(yytext,"CUR_USER")) strcpy(predefValue, "0");
if (!stricmp(yytext,"SEEK_SET")) strcpy(predefValue, "0");
if (!stricmp(yytext,"SEEK_CUR")) strcpy(predefValue, "1");
if (!stricmp(yytext,"SEEK_END")) strcpy(predefValue, "2");
if (!stricmp(yytext,"NEWBALANCE")) strcpy(predefValue, "0");
if (!stricmp(yytext,"CHRG_CALL")) strcpy(predefValue, "1");
if (!stricmp(yytext,"CHRG_TIME")) strcpy(predefValue, "2");
if (!stricmp(yytext,"CHRG_PEAKTIME")) strcpy(predefValue, "3");
if (!stricmp(yytext,"CHRG_CHAT")) strcpy(predefValue, "4");
if (!stricmp(yytext,"CHRG_MSGREAD")) strcpy(predefValue, "5");
if (!stricmp(yytext,"CHRG_MSGCAP")) strcpy(predefValue, "6");
if (!stricmp(yytext,"CHRG_MSGWRITE")) strcpy(predefValue, "7");
if (!stricmp(yytext,"CHRG_MSGECHOED")) strcpy(predefValue, "8");
if (!stricmp(yytext,"CHRG_MSGPRIVATE")) strcpy(predefValue, "9");
if (!stricmp(yytext,"CHRG_DOWNFILE")) strcpy(predefValue, "10");
if (!stricmp(yytext,"CHRG_DOWNBYTES")) strcpy(predefValue, "11");
if (!stricmp(yytext,"PAY_UPFILE")) strcpy(predefValue, "12");
if (!stricmp(yytext,"PAY_UPBYTES")) strcpy(predefValue, "13");
if (!stricmp(yytext,"WARN_LEVEL")) strcpy(predefValue, "14");
if (!stricmp(yytext,"ACC_STAT")) strcpy(predefValue, "0");
if (!stricmp(yytext,"ACC_TIME")) strcpy(predefValue, "1");
if (!stricmp(yytext,"ACC_MSGR")) strcpy(predefValue, "2");
if (!stricmp(yytext,"ACC_MSGW")) strcpy(predefValue, "3");
if (!stricmp(yytext,"START_BAL")) strcpy(predefValue, "0");
if (!stricmp(yytext,"START_SESSION")) strcpy(predefValue, "1");
if (!stricmp(yytext,"DEB_CALL")) strcpy(predefValue, "2");
if (!stricmp(yytext,"DEB_TIME")) strcpy(predefValue, "3");
if (!stricmp(yytext,"DEB_MSGREAD")) strcpy(predefValue, "4");
if (!stricmp(yytext,"DEB_MSGCAP")) strcpy(predefValue, "5");
if (!stricmp(yytext,"DEB_MSGWRITE")) strcpy(predefValue, "6");
if (!stricmp(yytext,"DEB_MSGECHOED")) strcpy(predefValue, "7");
if (!stricmp(yytext,"DEB_MSGPRIVATE")) strcpy(predefValue, "8");
if (!stricmp(yytext,"DEB_DOWNFILE")) strcpy(predefValue, "9");
if (!stricmp(yytext,"DEB_DOWNBYTES")) strcpy(predefValue, "10");
if (!stricmp(yytext,"DEB_CHAT")) strcpy(predefValue, "11");
if (!stricmp(yytext,"DEB_TPU")) strcpy(predefValue, "12");
if (!stricmp(yytext,"DEB_SPECIAL")) strcpy(predefValue, "13");
if (!stricmp(yytext,"CRED_UPFILE")) strcpy(predefValue, "14");
if (!stricmp(yytext,"CRED_UPBYTES")) strcpy(predefValue, "15");
if (!stricmp(yytext,"CRED_SPECIAL")) strcpy(predefValue, "16");
if (!stricmp(yytext,"SEC_DROP")) strcpy(predefValue, "17");
if (!stricmp(yytext,"HDR_ACTIVE")) strcpy(predefValue, "14");
if (!stricmp(yytext,"HDR_BLOCKS")) strcpy(predefValue, "4");
if (!stricmp(yytext,"HDR_DATE")) strcpy(predefValue, "5");
if (!stricmp(yytext,"HDR_ECHO")) strcpy(predefValue, "15");
if (!stricmp(yytext,"HDR_FROM")) strcpy(predefValue, "11");
if (!stricmp(yytext,"HDR_MSGNUM")) strcpy(predefValue, "2");
if (!stricmp(yytext,"HDR_MSGREF")) strcpy(predefValue, "3");
if (!stricmp(yytext,"HDR_PWD")) strcpy(predefValue, "13");
if (!stricmp(yytext,"HDR_REPLY")) strcpy(predefValue, "10");
if (!stricmp(yytext,"HDR_RPLYDATE")) strcpy(predefValue, "8");
if (!stricmp(yytext,"HDR_RPLYTIME")) strcpy(predefValue, "9");
if (!stricmp(yytext,"HDR_STATUS")) strcpy(predefValue, "1");
if (!stricmp(yytext,"HDR_SUBJ")) strcpy(predefValue, "12");
if (!stricmp(yytext,"HDR_TIME")) strcpy(predefValue, "6");
if (!stricmp(yytext,"HDR_TO")) strcpy(predefValue, "7");
if (!stricmp(yytext,"MAXMSGS")) strcpy(predefValue, "0");
if (!stricmp(yytext,"CMAXMSGS")) strcpy(predefValue, "1");
if (!stricmp(yytext,"ATTACH_LIM_U")) strcpy(predefValue, "2");
if (!stricmp(yytext,"ATTACH_LIM_P")) strcpy(predefValue, "3");
if (!strnicmp(yytext,"@X",2) && isHex(yytext[2]) && isHex(yytext[3]))
	{
    h = strtol(yytext+2, &p, 16);
	itoa(h, predefValue, 10);
    }

if (predefValue[0]!=0)
	{
    strcpy(yytext, predefValue);
    yylval = lookup(INTCONST);
    return IDENTIFIER;
    }

yylval = lookup(SYMBOL);
if (yylval != NULL)
	{
    a = globalVarType( identList[(*(int *)(yylval+2))-1]->type );
	switch (a)
		{
		case FUNC_IDENTIFIER:
        	return USERFUNC;
        case PROC_IDENTIFIER:
        	return USERPROC;
        default:
        	return IDENTIFIER;
        }
    }

forcedLabel:
return IDENTIFIER;
}

// 
//  ALLOCMEM 
// 

void allocMem(void)
{
identifierSize += IDENTIFIERINC;
identifier = calloc(identifierSize,sizeof(identListType*));
check_alloc(identifier);
identifierPos=0;

identListSize += IDENTIFIERINC;
identList = calloc(identListSize,sizeof(identListType*));
check_alloc(identList);
identListPos=0;

labelSize += LABELINC;
labels = calloc(labelSize,sizeof(labelType*));
check_alloc(labels);
labelPos=0;

codeBufferSize = CODEBUFFERSTARTSIZE;
codeBuffer = farmalloc(codeBufferSize);
check_alloc(codeBuffer);
codeBufferPos = 0;

jumpSize += LABELINC;
jump = calloc(jumpSize,sizeof(gotoType*));
check_alloc(jump);
jumpPos = 0;

labelStackSize += LABELSTACKINC;
labelStack = calloc(labelStackSize, 4);
check_alloc(labelStack);
labelStackPos = 0;

loopSize += LOOPINC;
loop = calloc(loopSize, 1);
check_alloc(loop);
loopPos = 0;

selectSize += SELECTINC;
select = calloc(selectSize, sizeof(char *));
check_alloc(select);
selectPos = 0;

paramNsize += PARAMNINC;
paramN = calloc(paramNsize, sizeof(int));
check_alloc(paramN);
paramNpos = 0;

if (makeSym || makeIntSym)
	{
	symCodeSize += SYMCODEINC;
	symCode = calloc(symCodeSize, sizeof(symType));
	check_alloc(symCode);
	symCodePos = 0;
    }

filesSize += FILESINC;
files = calloc(filesSize,sizeof(filesType));
check_alloc(files);
filesPos=0;

sourceSize += SOURCEINC;
source = calloc(sourceSize, sizeof(char *));
check_alloc(files);
sourcePos=0;

}

// 
//  UNALLOCMEM 
// 

void unallocMem(void)
{
int a;

if (labels != NULL)
	for (a=0;a<labelPos;a++)
		{
        if (labels[a] != NULL)
        	{
		    if (labels[a]->name != NULL) free(labels[a]->name);
			free(labels[a]);
        	}
	    }
labelSize=0;
labelPos=0;
if (labels!=NULL) free(labels);
labels=NULL;

if (codeBuffer!=NULL) farfree(codeBuffer);
codeBuffer=NULL;
codeBufferPos=0;
codeBufferSize=0;

if (jump != NULL)
	for (a=0;a<jumpPos;a++)
		{
	    free(jump[a]->name);
		free(jump[a]);
	    }
jumpSize=0;
jumpPos=0;
if (jump!=NULL) free(jump);
jump=NULL;

if (identifier != NULL)
	for (a=0;a<identifierPos;a++)
		{
        if (identifier[a] != NULL)
        	{
		    if (identifier[a]->name != NULL) free(identifier[a]->name);
			if (identifier[a]->data != NULL)free(identifier[a]->data);
		    free(identifier[a]);
    	   	}
    	}
identifierSize=0;
identifierPos=0;
if (identifier!=NULL) free(identifier);
identifier=NULL;

if (identList != NULL)
	for (a=0;a<identListPos;a++)
		{
	    if (identList[a]->name != NULL) free(identList[a]->name);
		if (identList[a]->data != NULL) free(identList[a]->data);
	    if (identList[a]->paramTypes != NULL)
    		free(identList[a]->paramTypes);
	    if (identList[a] != NULL) free(identList[a]);
    	}
identListSize=0;
identListPos=0;
if (identList!=NULL) free(identList);
identList=NULL;

for (a=0;a<labelStackPos;a++)
    free(labelStack[a]);
labelStackSize=0;
labelStackPos=0;
if (labelStack!=NULL) free(labelStack);
labelStack=NULL;

loopPos=0;
if (loop!=NULL) free(loop);
loop=NULL;
loopSize=0;

if (select != NULL)
	for (a=0;a<selectPos;a++)
    	if (select[a] != NULL) free(select[a]);
selectPos=0;
selectSize=0;
if (select!=NULL) free(select);
select=NULL;

if (curProc != NULL) free(curProc);
curProc = NULL;

if (paramN != NULL)
	free(paramN);
paramN=NULL;
paramNpos=0;
paramNsize=0;

if (makeSym || makeIntSym)
	{
    if (symCode != NULL)
    	free(symCode);
    symCode=NULL;
    symCodePos=0;
    symCodeSize=0;
    }

for (a=0;a<libnameNum;a++)
	if (libname[a] != NULL) free(libname[a]);

filesSize=0;
filesPos=0;
if (files!=NULL) free(files);
files=NULL;

if (source != NULL)
	for (a=0;a<sourcePos;a++)
    	if (source[a] != NULL) free(source[a]);
sourcePos=0;
sourceSize=0;
if (source!=NULL) free(source);
source=NULL;

}

// 
//  FREEIDENTIFIER 
// 

void freeIdentifier(void)
{
int a;

for (a=0;a<identifierPos;a++)
	{
    free(identifier[a]->name);
    free(identifier[a]->data);
    free(identifier[a]);
    }
identifierPos = 0;
}

// 
//  REGISTERIDENT 
// 

void registerIdent(char *data)
{
int a;
identListType *p;
if (isInternal(yytext))
	{
	sprintf(msg, "cannot use '%s' (internal) as an identifier name", yytext);
    yyerror(msg);
    }
checkSymbol(yytext);
if (data == NULL)
	{
	data = calloc(8,1);
	check_alloc(data);
    }
while (identifierPos + 1 > identifierSize)
	{
    identifierSize += IDENTIFIERINC;
    identifier = realloc(identifier, identifierSize*sizeof(identListType *));
	check_alloc(identifier);
    }
identifier[identifierPos] = (identListType*) malloc(sizeof(identListType));
check_alloc(identifier[identifierPos]);
p = identifier[identifierPos];
identifierPos++;
if (identHdr != 0)
	a = 2;
else
	a=0;
p->name = (char *)calloc(strlen(yytext)+1+a,1);
check_alloc(p->name);
if (identHdr != 0)
	{
	*(char*)(p->name) = 1;
	*(((char*)p->name) + 1) = identHdr;
    strcat(((char*)p->name)+2, yytext);
	}
else
	strcpy(p->name, yytext);
p->type = 0;
p->data = data;
p->dim1 = dim1;
p->dim2 = dim2;
p->dim3 = dim3;
p->nDim = nDim;
p->offset = 0;
p->paramTypes=NULL;
}

// 
//  REGISTERIDENTLIST 
// 

void registerIdentList(int type)
{
identListType *p,*l;
int a=0,b;

for (b=0;b<identifierPos;b++)
	{
    p = identifier[b];
    checkSymbol(p->name);
	while (identListPos + 1 > identListSize)
		{
	    identListSize += IDENTIFIERINC;
	    identList = realloc(identList, identListSize*sizeof(identListType *));
        check_alloc(identList);
	    }
    identList[identListPos] = (identListType*) malloc(sizeof(identListType));
    check_alloc(identList[identListPos]);
    l = identList[identListPos];
    l->name = NULL;
    l->data = NULL;
    l->paramTypes = NULL;
    identListPos++;
	l->name = (char *)malloc(strlen(p->name)+1);
    check_alloc(l->name);
	strcpy(l->name, p->name);
	l->type = type;
    l->nDim = p->nDim;
    l->dim1 = p->dim1;
    l->dim2 = p->dim2;
    l->dim3 = p->dim3;
    l->external = p->external;
	l->paramTypes=NULL;
    l->offset = p->offset;
    if (type == 7)
		{
		l->data = malloc(strlen(p->data)+1);
        check_alloc(l->data);
		strcpy(l->data,p->data);
        }
    else
		{
		l->data = malloc(8);
        check_alloc(l->data);
		memcpy(l->data,p->data, 8);
        }
    free(p->name);
    free(p->data);
    free(p);
    a++;
    }
identifierPos=0;
}

// 
//  REGISTERIDENTLIST 
// 

void registerOneIdentFromList(int type)
{
identListType *p,*l;
int a=0,b;

b = identifierPos-1;

    p = identifier[b];
    checkSymbol(p->name);
	while (identListPos + 1 > identListSize)
		{
	    identListSize += IDENTIFIERINC;
	    identList = realloc(identList, identListSize*sizeof(identListType *));
        check_alloc(identList);
	    }
    identList[identListPos] = (identListType*) malloc(sizeof(identListType));
    check_alloc(identList[identListPos]);
    l = identList[identListPos];
    l->name = NULL;
    l->data = NULL;
    l->paramTypes = NULL;
    identListPos++;
	l->name = (char *)malloc(strlen(p->name)+1);
    check_alloc(l->name);
	strcpy(l->name, p->name);
	l->type = type;
    l->nDim = p->nDim;
    l->dim1 = p->dim1;
    l->dim2 = p->dim2;
    l->dim3 = p->dim3;
    l->external = p->external;
	l->paramTypes=NULL;
    l->offset = p->offset;
    if (type == 7)
		{
		l->data = malloc(strlen(p->data)+1);
        check_alloc(l->data);
		strcpy(l->data,p->data);
        }
    else
		{
		l->data = malloc(8);
        check_alloc(l->data);
		memcpy(l->data,p->data, 8);
        }
    free(p->name);
    free(p->data);
    free(p);
    a++;

identifierPos--;
}

// 
//  LOOKUP 
// 

char *lookup(int type)
{
identListType *p;
char *data, *t;
char *value;
int a;
char *tempName;

if (identHdr != 0)
	{
	tempName = newcode(strlen(yytext)+3);
    *tempName = 1;
    *(tempName+1) = identHdr;
    strcpy(tempName+2,yytext);
    }

relookup:

if (identHdr != 0)
	{
	for (a=0;a<identListPos;a++)
		{
	    p = identList[a];
        if (!identcmp(p, tempName) && p->type != 0xF && p->type != 0x10)
            {
		    lookupType = globalVarType(p->type);
		    value = newcode(4+strlen(tempName)+1+5+2+1);
		    *(int *)value=2+1+strlen(tempName)+5+2+1;
		    *(int *)(value+2)=a+1;
			strcpy(value+4, "@VAR@");
			*(unsigned char *)(value+9)=cursource;
			*(int *)(value+10)=localLine;
			*(char *)(value+12)=strlen(tempName);
			strncpy(value+13, tempName, strlen(tempName));
			return value;
			}
		}
	}

if (!(declaration && identHdr != 0))
	for (a=0;a<identListPos;a++)
		{
		p = identList[a];
		if (!identcmp(p, yytext) || (registeringLib && *yytext == 1 && !identcmp(p, yytext+1)))
			{
            if (!(!readProcs && (p->type == 0xF || p->type == 0x10)))
        	    {
			    lookupType = globalVarType(p->type);
			    value = newcode(4+strlen(yytext)+1+5+2+1);
			    *(int *)value=2+1+strlen(yytext)+5+2+1;
		    	*(int *)(value+2)=a+1;
                strcpy(value+4, "@VAR@");
				*(unsigned char *)(value+9)=cursource;
				*(int *)(value+10)=localLine;
				*(char *)(value+12)=strlen(yytext);
				strncpy(value+13, yytext, strlen(yytext));
				return value;
				}
			}
		}
if (type == SYMBOL)
	return 0;

nDim=0;
dim1=0;
dim2=0;
dim3=0;
switch (type)
	{
	case STRCONST:
		data = malloc(strlen(yytext)-1);
        check_alloc(data);
        strncpy(data, &yytext[1], strlen(yytext)-2);
        data[strlen(yytext)-2] = 0;
		registerIdent(data);
		registerOneIdentFromList(7);
        break;
	case HEXCONST:
		data = malloc(8);
        check_alloc(data);
        *(long *)data = strtoul(yytext, &t, 16);
		registerIdent(data);
		registerOneIdentFromList(4);
        break;
	case INTCONST:
		data = calloc(8,1);
        check_alloc(data);
        *(long *)data = strtoul(yytext, &t, 10);
		registerIdent(data);
		registerOneIdentFromList(4);
        break;
	case DBLCONST:
		data = calloc(8,1);
        check_alloc(data);
        *(double *)data = strtod(yytext, &t);
		registerIdent(data);
		registerOneIdentFromList(0xE);
        break;
	case BINCONST:
		data = malloc(8);
        check_alloc(data);
        *(long *)data = strtoul(yytext, &t, 2);
		registerIdent(data);
		registerOneIdentFromList(4);
        break;
	case OCTCONST:
		data = malloc(8);
        check_alloc(data);
        *(long *)data = strtoul(yytext, &t, 8);
		registerIdent(data);
		registerOneIdentFromList(4);
        break;
    }
goto relookup;
}

// 
//  GLOBALVARTYPE 
// 

int globalVarType(int type)
{
if (type == 0xF)
	return FUNC_IDENTIFIER;
if (type == 0x10)
	return PROC_IDENTIFIER;
return VAR_IDENTIFIER;
}

// 
//  CHECKIDENTIFIER 
// 

void checkIdentifier(void)
{
int type;

if (lookup(SYMBOL) == 0)
	{
    if (!implicitVars)
    	{
	    sprintf(msg, "undefined symbol '%s'", yytext);
		yyerror(msg);
        }
    else
    	{
        switch (yytext[strlen(yytext)-1])
        	{
            case '$':
            	type=7;
                break;
            case '%':
            	type=12;
                break;
            case '&':
            	type=4;
                break;
            case '!':
            	type=6;
                break;
            case '#':
            	type=14;
                break;
            default:
            	type=12;
            }
        nDim=0;
        dim1=0;
        dim2=0;
        dim3=0;
        registerIdent(NULL);
        registerIdentList(type);
        }
    }
}

void sendToBuffer(void *ptr, int size)
{
char *g;
static int inserting=0;

if (codeBufferPos == 0 && !inserting)
	{
	strcpy(yytext, "~BEGIN");
	g = concat(mkStat(7), mkStat(65535));
    inserting=1;
	sendToBuffer(g+2, *(int *)g);
    inserting=0;
    }

while (codeBufferPos + size > codeBufferSize)
	{
    codeBufferSize += CODEBUFFERINC;
    codeBuffer = farrealloc(codeBuffer, codeBufferSize);
    check_alloc(codeBuffer);
    }
mymemcpy(codeBuffer+codeBufferPos, ptr, size);
codeBufferPos += size;
}

// 
//  WRITEPPE 
// 

void writePPE(void)
{
identListType *l;
int b,d,e;
char *part1;
char *part2;
char *str;
unsigned int len;
char *buf;
char *ppever=" 2.00";
int frtHdr=0;

if (honnorEnc)
	{
    switch(maxTokVer)
    	{
        case 0:
        	cryptppe=0;
            xor17=0;
            break;
        case 1520:
        	cryptppe=1;
            xor17=0;
            strcpy(ppever, " 3.01");
        	break;
        case 1521:
        	cryptppe=1;
            xor17=0;
            strcpy(ppever, " 3.10");
        	break;
        case 1522:
        	cryptppe=1;
            xor17=0;
            strcpy(ppever, " 3.20");
        	break;
        case 2000:
            cryptppe=0;
            xor17=0;
            strcpy(ppever, " 1.00");
            frtHdr=1;
            break;
        }
    }
else
	{
    if (forceFrt)
    	{
    	strcpy(ppever, " 1.00");
        frtHdr=1;
        }
    else
	    if (cryptppe)
		    {
        	if (xor17)
	        	strcpy(ppever, " 3.30");
    	    else
        		strcpy(ppever, " 3.20");
	        }
    }

part1 = calloc(0xB,1);
check_alloc(part1);
part2 = calloc(0xC,1);
check_alloc(part2);

ppe = fopen(out, "wb");
if (!frtHdr)
	fwrite("PCBoard Programming Language Executable ", 40, 1, ppe);
else
	fwrite("Project: Frontier  -  Executable Script ", 40, 1, ppe);
fwrite(ppever, 5, 1, ppe);
fwrite("\r\n\x1A", 3, 1, ppe);
fwrite(&identListPos, 2, 1, ppe);
for (b=identListPos;b>0;b--)
	{
	l = identList[b-1];
	memset(part1, 0, 0xB);
	memset(part2, 0, 0xC);
    *(int*)part1 = b;                   // varnumber
	d=0;
    *(char*)(part1+2) = l->nDim;        // ndim
    *(int*)(part1+3) = l->dim1;         // dim1
    *(int*)(part1+5) = l->dim2;         // dim2
    *(int*)(part1+7) = l->dim3;         // dim3
    d=l->type;
    if (*(char*)l->name == 1)
    	d += 0x100;
    *(int*)(part1+9) = d;               // vartype
    if (cryptppe)
    	crypt(part1, 0x0B);
    fwrite(part1, 1, 0xB, ppe);
    if (l->type == 7)
    	{
        for(e=0;e<strlen(l->data);e++)
        	{
            if (((char *)l->data)[e] == '\"' && ((char *)l->data)[e+1] == '\"')
                strcpy(&((char *)l->data)[e], &((char *)l->data)[e+1]);
            }
        d = strlen(l->data)+1;
	    fwrite(&d, 2, 1, ppe); 			// len of data
        str = malloc(d);
        check_alloc(str);
        strcpy(str, l->data);
        if (cryptppe)
        	crypt(str, d);
	    fwrite(str, d, 1, ppe); 		// data
        free(str);
        }
    else
    	{
        if (l->type == 0x0F || l->type == 0x10)
        	{
            d = l->offset;
            *(((int*)(l->data))+1) = d;
            }
        d=0;
		*(int*)part2=d;                 // typeID (value=?)
		*(int*)(part2+2) = l->type;     // vartype
		mymemcpy(part2+4, l->data, 8);  // data
        if (cryptppe)
        	crypt(part2, 0xC);
        fwrite(part2, 1, 0xC, ppe);
        }
    }

free(part1);
free(part2);

fwrite(&codeBufferPos, 2, 1, ppe);
ppecoresize=codeBufferPos;
if (cryptppe)
	{
    buf = malloc(codeBufferPos+128);
    check_alloc(buf);
	len = recrypt((char *)codeBuffer, buf, codeBufferPos);
    if (len < codeBufferPos)
    	{
		crypt(buf, len);
		fwrite(buf, 1, len, ppe);
        ppecoresize = len;
    	}
    else
    	{
		crypt((char *)codeBuffer, codeBufferPos);
		fwrite(codeBuffer, 1, codeBufferPos, ppe);
    	}
    free(buf);
    }
else
	fwrite(codeBuffer, codeBufferPos, 1, ppe);
fclose(ppe);
}

void writeSymbols(void)
{
if (makeSym) writeSYM();
if (makeIntSym) writeIntSYM();
}

void writeIntSYM(void)
{
int a,b;
long nElems=0;
long pos;
symType prev;
char *endptr;
double value;
char *testvalue;

prev.sourceOffset=-1;
prev.codeOffset=-1;

sym = fopen(out, "r+b");
fseek(sym, 0, SEEK_END);
pos = ftell(sym);
fwrite(&nElems, 4, 1, sym);

for (a=0;a<symCodePos;a++)
    if (symCode[a].sourceOffset != prev.sourceOffset)
    	{
        if (symCode[a].codeOffset > 65535)
        	yywarning("internal error, cannot make a valid sym file");
        if (symCode[a].codeOffset == prev.codeOffset)
        	{
			fseek(sym, -4, SEEK_CUR);
            nElems--;
            }
	    fwrite(&symCode[a].codeOffset, 2, 1, sym);
	    fwrite(&symCode[a].line, 2, 1, sym);
        prev.sourceOffset = symCode[a].sourceOffset;
        prev.codeOffset = symCode[a].codeOffset;
        nElems++;
        }
fseek(sym, pos, SEEK_SET);
fwrite(&nElems, 4, 1, sym);
fseek(sym, 0, SEEK_END);

for (b=identListPos;b>0;b--)
    {
    testvalue = identList[b-1]->name;
    if (*testvalue == 1) testvalue += 2;
	value = strtod(testvalue, &endptr);
	if (value == 0 && endptr == testvalue && *testvalue != '\"')
    	{
		fputc(strlen(identList[b-1]->name), sym);
	    fputs(identList[b-1]->name, sym);
	    if (identList[b-1]->type == 0xF || identList[b-1]->type == 0x10)
	    	fwrite(&identList[b-1]->identHdr, 2, 1, sym);
        }
    else
    	fputc(0, sym);
    }

fputc(strlen(curFile), sym);
fputs(curFile, sym);

fputs("PPSYM1", sym);
fwrite(&ppecoresize, 2, 1, sym);
fwrite(&pos, 4, 1, sym);
fclose(sym);
}

void writeSYM(void)
{
int a,b;
long sourceSize=0, totalSize=0;
symType prev;

prev.sourceOffset=-1;
prev.codeOffset=-1;

sym = fopen(symname, "wb");
fwrite(&totalSize, 4, 1, sym);
fwrite(&sourceSize, 4, 1, sym);

fseek(lexin, 0, SEEK_SET);
while (1)
	{
    fgets(msg, 255, lexin);
    if (feof(lexin))
    	break;
    for (b=0;b<strlen(msg);b++)
    	{
        if (msg[b] == '\t')
		    fputs("    ", sym);
        else
		    fputc(msg[b], sym);
        }
    }
sourceSize = ftell(sym)-8;
for (a=0;a<symCodePos;a++)
    if (symCode[a].sourceOffset != prev.sourceOffset)
    	{
        if (symCode[a].codeOffset > 65535)
        	yywarning("internal error, cannot make a valid sym file");
	    fwrite(&symCode[a].codeOffset, 2, 1, sym);
	    fwrite(&symCode[a].sourceOffset, 4, 1, sym);
        prev.sourceOffset = symCode[a].sourceOffset;
        prev.codeOffset = symCode[a].codeOffset;
        }
totalSize = ftell(sym) - 8;
fseek(sym, 0, SEEK_SET);
fwrite(&totalSize, 4, 1, sym);
fwrite(&sourceSize, 4, 1, sym);
fclose(sym);
}

// 
//  WRITELIB 
// 

void writeLIB(void)
{
identListType *l;
int b,d;
char f;
unsigned long blockSize=0;
unsigned long blockBegin=0;
unsigned long curp=0;

ppe = fopen(out, "wb");
fwrite("Frontier PPL LIB  1.02\r\n\x1A", 25, 1, ppe);
fwrite(&blockSize, 4, 1, ppe);
fwrite(&blockSize, 4, 1, ppe);
blockBegin = ftell(ppe);
fwrite(&identListPos, 2, 1, ppe);
for (b=1;b<=identListPos;b++)
	{
    l = identList[b-1];
    d = strlen(l->name)+1;
    fwrite(&d, 2, 1, ppe);          // len of name
    fwrite(l->name, d, 1, ppe); 	// name
	d=0;
    fwrite(&l->nDim, 1, 1, ppe); 	// ndim
    fwrite(&l->dim1, 2, 1, ppe); 	// dim1
    fwrite(&l->dim2, 2, 1, ppe); 	// dim2
    fwrite(&l->dim3, 2, 1, ppe); 	// dim3
    d=l->type;
/*    if (*(char*)l->name == 1)
    	d += 0x100;*/
    fwrite(&d, 2, 1, ppe); 	// vartype
    if (l->type == 7)
    	{
        d = strlen(l->data)+1;
	    fwrite(&d, 2, 1, ppe); 			// len of data
	    fwrite(l->data, d, 1, ppe); 	// data
        }
    else
    	{
    	fwrite(&l->type, 2, 1, ppe); 	// vartype
	    fwrite(l->data, 8, 1, ppe); 	// data
        }
    if (l->type == 0xF || l->type == 0x10)
    	{
	    f = *(char *)(l->data);
	    fwrite(&f, 1, 1, ppe);
        fwrite(l->paramTypes, f, 1, ppe);
	    fwrite(&l->offset, 4, 1, ppe);
        }
    }

blockSize = ftell(ppe) - blockBegin;
fseek(ppe, blockBegin-4, SEEK_SET);
fwrite(&blockSize, 4, 1, ppe);

fseek(ppe, blockSize+blockBegin, SEEK_SET);
fwrite(&codeBufferPos, 4, 1, ppe);

for (curp=0;curp<=codeBufferPos;curp+=16384)
	if (codeBufferPos - curp >= 16384)
		fwrite(farnormal(codeBuffer+curp), 16384, 1, ppe);
    else
		fwrite(farnormal(codeBuffer+curp), codeBufferPos - curp, 1, ppe);
blockSize = ftell(ppe) - blockBegin;
fseek(ppe, blockBegin-8, SEEK_SET);
fwrite(&blockSize, 4, 1, ppe);
fclose(ppe);
}

// 
//  MKFUNC 
// 

char *mkFunc(int f)
{
char *value=newcode(4);
*(int *)value=2;
*(int *)(value+2)=~f+1;
return value;
}

// 
//  MKSTAT 
// 

char *mkStat(unsigned int s)
{
char *value;
int a,b=0;

switch (s)
	{
	case 65535: // insert a jump
		//	registerJump();
		a = 9+strlen(yytext)+1;
        if (identHdr && strcmp(yytext, "~BEGIN"))
        	b=2;
		value = newcode(a+3+b);
        if (identHdr && strcmp(yytext, "~BEGIN"))
			sprintf(&value[2], "@JMP@%c%c%c%c%c%c%c%s", cursource, localLine&0xFF, (localLine&0xFF00)>>8, strlen(yytext)+b+1, 1, identHdr, 2, yytext);
		else
			sprintf(&value[2], "@JMP@%c%c%c%c%c%s", cursource, localLine&0xFF, (localLine&0xFF00)>>8, strlen(yytext)+1, 2, yytext);
		*(int*)value = a+b;
		break;
	case 65534:
		a = 9+strlen(yytext)+1;
        if (identHdr)
        	b=2;
		value = newcode(a+3+b);
        if (identHdr)
		    sprintf(&value[2], "@LBL@%c%c%c%c%c%c%c%s", cursource, localLine&0xFF, (localLine&0xFF00)>>8, strlen(yytext)+b+1, 1, identHdr, 2, yytext);
        else
		    sprintf(&value[2], "@LBL@%c%c%c%c%c%s", cursource, localLine&0xFF, (localLine&0xFF00)>>8, strlen(yytext)+1, 2, yytext);
    	*(int*)value = a+b;
		break;
    default:
		value = newcode(4);
		*(int *)value=2;
		*(int *)(value+2)=s;
        break;
    }
return value;
}

// 
//  CONCAT 
// 

char *concat(char *c1, char *c2)
{
int l;
char *value;
l = *(int *)c1 + *(int *)c2;
value = newcode(l+2);
*(int *)value = l;
mymemcpy(value + 2, c1 + 2, *(int *)c1);
mymemcpy(value + 2 + *(int *)c1, c2 + 2, *(int *)c2);
return value;
}

// 
//  NEWCODE 
// 

char *newcode(int l)
{
char *value;
value = (char *)calloc(l,1);
check_alloc(value);
while (buffersPos + 1 > buffersSize)
	{
    buffersSize += BUFFERSINC;
    buffers = realloc(buffers, buffersSize*sizeof(value));
    check_alloc(buffers);
    }
buffers[buffersPos] = value;
buffersPos++;
return value;
}

// 
//  ALLOCBUFFERS 
// 

void allocBuffers(void)
{
buffersSize += BUFFERSINC;
buffers = calloc(buffersSize*sizeof(char *),1);
check_alloc(buffers);
}

// 
//  FREEBUFFERS 
// 

void freeBuffers(void)
{
int a;
for(a=0;a<buffersPos;a++)
	free(buffers[a]);
if (buffers!=NULL)
	{
	free(buffers);
    buffers=NULL;
    }
buffersPos=0;
buffersSize=0;
if (buildAllocated == 1)
	{
	free(buildBuf);
    buildAllocated=0;
    }
}

// 
//  INITBUILD 
// 

void initbuild(void)
{
if (buildAllocated == 1)
	free(buildBuf);
buildPos=2;
buildSize = BUILDINC;
buildBuf = calloc(buildSize,1);
check_alloc(buildBuf);
buildAllocated=1;
}

// 
//  BUILD 
// 

void build(char *value)
{
int size=*(int*)value;

while (buildPos + size > buildSize)
	{
    buildSize += BUILDINC;
    buildBuf = realloc(buildBuf, buildSize);
    check_alloc(buildBuf);
    }
mymemcpy(buildBuf+buildPos, value+2, size);
buildPos+=size;
*(int *)buildBuf = buildPos-2;
}

// 
//  RETREIVEBUILD 
// 

char *retreiveBuild(void)
{
char *buf;

buf = newcode(*(int *)buildBuf+2);
mymemcpy(buf, buildBuf, *(int *)buildBuf+2);
return buf;
}

// 
//  SEPARATOR 
// 

char *separator(int s, int arg)
{
char *value;
unsigned long argType=0;
int a = 8 * (arg-1);

switch(stat[s].argType)             // argType 0 = expr
	{                               // argType 1 = var only
	case 0x075F:                    // argType 2 = table only
    case 0x08B7:
		argType |= 1;
		break;

	case 0x075B:
		argType |= 1;
		argType |= 1 << 8;
		break;

	case 0x07B5:
		argType |= 1 << 8;
		break;

	case 0x07E5:
		argType |= (long)1 << 16;
		break;

	case 0x078C:
		argType |= 1;
		argType |= 1 << 8;
		break;

	case 0x0836:
		argType |= 2;
		break;

	case 0x088C:
		argType |= 2;
		argType |= 2 << 8;
		break;

	case 0x2585:
		argType |= (long)2 << 24;
		break;

    case 0x756:
		argType |= 1;
		argType |= 1 << 8;
		argType |= (long)1 << 16;
        break;

	default:
		break;
	}

if (!(((argType & ((long)0xFF << a)) >> a) == 1))
	{
    value = newcode(4);
    *(int *)value = 2;
    *(int *)(value+2) = 0;
    return value;
    }

value = newcode(2);
*(int *)value = 0;
return value;
}

// 
//  REGISTERLABEL 
// 

void registerLabel(char *name, unsigned int offset)
{
labelType *p;
int a=1;
int b;
char *n;

for (b=0;b<labelPos;b++)
    if (!stricmp(labels[b]->name, name))
    	{
        n = name;
        if (*n==1)
        	n+=2;
        if (!strcmp(n, "\002~BEGIN"))
        	yyerror("main program already defined");
        else
        	{
	        sprintf(msg, "label '%s' already defined", n);
			yyerror(msg);
            }
        }

while (labelPos + 1 > labelSize)
	{
    labelSize += LABELINC;
    labels = realloc(labels, labelSize*sizeof(labelType*));
    check_alloc(labels);
    }

labels[labelPos] = (labelType*) malloc(sizeof(labelType));
check_alloc(labels[labelPos]);
p = labels[labelPos];
labelPos++;
p->name = (char *)malloc(strlen(name)+1);
check_alloc(p->name);
strcpy(p->name, name);
p->num = a;
p->offset = offset;
}

// 
//  REGISTERJUMP 
// 

void registerJump(char *name, unsigned int offset)
{
gotoType *q;

q = (gotoType*)malloc(sizeof(gotoType));
check_alloc(q);
q->name = (char *)malloc(strlen(name)+1);
check_alloc(q->name);
strcpy(q->name, name);
q->offset = offset;
while (jumpPos + 1 > jumpSize)
	{
    jumpSize += LABELINC;
    jump = realloc(jump, jumpSize*sizeof(gotoType*));
    check_alloc(jump);
    }
jump[jumpPos] = q;
jumpPos++;
}

// 
//  PROCESSJUMPS 
// 

void processJumps(void)
{
int a,b,c,o=0,g;
labelType *p;
char msg[128];
unsigned long i;
char lblname[256];
unsigned int offset;
char *n;
unsigned int oldline=localLine;
unsigned int oldsource=cursource;

for (i=0;i<codeBufferPos;i++)
	{
    if (!strncmp((char *)(codeBuffer+i), "@JMP@", 5))
    	{
        c = *(unsigned char*)(codeBuffer+i+8);
        cursource =*(unsigned char*)(codeBuffer+i+5);
        localLine=*(unsigned int*)(codeBuffer+i+6);
        strncpy(lblname, (char *)(codeBuffer+i+9), c);
        lblname[c]=0;
        if (!strcmp(lblname, "\002~BEGIN") && !beginUsed)
        	g=2;
        else
        	{
        	g=0;
	        registerJump(lblname, i);
            }
        mymemcpy(codeBuffer+i+2-g*2,codeBuffer+i+9+c,codeBufferPos-i-7+c+g);
        codeBufferPos -= 7+c+g*2;
        i -= g;
        for (a=0;a<labelPos;a++)
        	{
            p = labels[a];
			if (p->offset > i)
            	p->offset -= 7+c+g*2;
            }
        for (a=0;a<identListPos;a++)
            if (identList[a]->type == 0xF || identList[a]->type == 0x10)
            	{
                if (identList[a]->offset > i)
					identList[a]->offset -= 7+c+g*2;
                }
        if (makeSym || makeIntSym)
	        for (a=0;a<symCodePos;a++)
    	    	{
        	    if (symCode[a].codeOffset > i)
            		symCode[a].codeOffset -= 7+c+g*2;
	            }
		i--;
		continue;
		}
	if (!strncmp((char *)(codeBuffer+i), "@LBL@", 5))
		{
		c = *(unsigned char*)(codeBuffer+i+8);
		localLine=*(unsigned int*)(codeBuffer+i+6);
        cursource =*(unsigned char*)(codeBuffer+i+5);
		strncpy(lblname, (char *)(codeBuffer+i+9), c);
		lblname[c]=0;
		registerLabel(lblname, i);
		mymemcpy(codeBuffer+i,codeBuffer+i+9+c,codeBufferPos-i-9+c);
		codeBufferPos -= 9+c;
		for (a=0;a<labelPos;a++)
			{
			p = labels[a];
			if (p->offset > i)
				p->offset -= 9+c;
			}
		for (a=0;a<identListPos;a++)
			if (identList[a]->type == 0xF || identList[a]->type == 0x10)
				{
				if (identList[a]->offset > i)
					identList[a]->offset -= 9+c;
				}
		if (makeSym || makeIntSym)
			for (a=0;a<symCodePos;a++)
				{
				if (symCode[a].codeOffset > i)
					symCode[a].codeOffset -= 9+c;
				}
		i--;
		continue;
		}
	}

if (codeBufferPos + o > 65535)
	yyerror("PPE too large (code size > 64kb)");

i=0;
for (b=0;b<jumpPos;b++)
	{
	for(a=0;a<labelPos;a++)
		{
		p = labels[a];
		if (!strcmpi(jump[b]->name, p->name))
			{
			(*(unsigned int *)(codeBuffer+jump[b]->offset)) = p->offset;
			goto nextJump;
			}
		}
	n = jump[b]->name;
	if (*n==1)
		n+=2;
	if (!strcmp(n, "\002~BEGIN"))
		yyerror("internal error: keyword 'begin' not found");
	else
		{
		sprintf(msg, "undefined label %s", n+1);
    	yyerror(msg);
        }
	nextJump:
	}
localLine=oldline;
cursource = oldsource;
}

// 
//  PROCESSVARS 
// 

void processVars(void)
{
int a,c;
labelType *p;
unsigned long i;
unsigned int offset;
unsigned int oldline=localLine;
unsigned int oldsource=cursource;

for (i=0;i<codeBufferPos;i++)
	{
	if (!strncmp((char *)(codeBuffer+i), "@VAR@", 5))
		{
		c = *(unsigned char *)(codeBuffer+i+8);
        cursource = *(unsigned char *)(codeBuffer+i+5);
		localLine=*(unsigned int*)(codeBuffer+i+6);
		strncpy(msg, (char *)(codeBuffer+i+9), c);
		msg[c]=0;
		mymemcpy(codeBuffer+i,codeBuffer+i+9+c,codeBufferPos-i-9+c);
		codeBufferPos -= 9+c;
		for (a=0;a<labelPos;a++)
			{
			p = labels[a];
			if (p->offset > i)
				p->offset -= 9+c;
			}
		for (a=0;a<identListPos;a++)
			if (identList[a]->type == 0xF || identList[a]->type == 0x10)
				{
				if (identList[a]->offset > i)
					identList[a]->offset -= 9+c;
				}
		if (makeSym || makeIntSym)
			for (a=0;a<symCodePos;a++)
				{
				if (symCode[a].codeOffset > i)
					symCode[a].codeOffset -= 9+c;
				}
		i--;
		}
	}

localLine=oldline;
cursource = oldsource;
}

// 
//  CHECKJUMPS 
// 

void checkJumps(void)
{
int a,b,c;
labelType *p;
char msg[128];
long i;
char lblname[256];
unsigned int offset;
char *n;
unsigned int oldline=localLine;
unsigned int oldsource=cursource;

for (i=0;i<codeBufferPos;i++)
	{
	if (!strncmp((char *)(codeBuffer+i), "@JMP@", 5))
		{
		c = *(codeBuffer+i+8);
        cursource = *(unsigned char *)(codeBuffer+i+5);
		localLine=*(int*)(codeBuffer+i+6);
		strncpy(lblname, (char *)(codeBuffer+i+9), c);
		lblname[c]=0;
		if (!strcmp(lblname, "\002~BEGIN") && !beginUsed)
			{
			mymemcpy(codeBuffer+i+2-4,codeBuffer+i+9+c,codeBufferPos-i-6+c+2);
			codeBufferPos -= 11+c;
			i -= 4;
			for (a=0;a<labelPos;a++)
				{
				p = labels[a];
				if (p->offset > i)
					p->offset -= 11+c;
				}
			for (a=0;a<identListPos;a++)
				if (identList[a]->type == 0xF || identList[a]->type == 0x10)
					{
					if (identList[a]->offset > i)
						identList[a]->offset -= 11+c;
					}
            if (makeSym || makeIntSym)
	            for (a=0;a<symCodePos;a++)
    	    	    {
        	        if (symCode[a].codeOffset > i)
            		    symCode[a].codeOffset -= 11+c;
	                }
			i--;
			}
		else
			registerJump(lblname, i);
		continue;
		}
	if (!strncmp((char *)(codeBuffer+i), "@LBL@", 5))
		{
		c = *(codeBuffer+i+8);
        cursource = *(unsigned char *)(codeBuffer+i+5);
		localLine=*(int*)(codeBuffer+i+6);
		strncpy(lblname, (char *)(codeBuffer+i+9), c);
		lblname[c]=0;
		registerLabel(lblname, i);
		}
	}

i=0;
for (b=0;b<jumpPos;b++)
	{
	for(a=0;a<labelPos;a++)
		{
		p = labels[a];
		if (!strcmpi(jump[b]->name, p->name))
   		    goto nextJump;
		}
    n = jump[b]->name;
    if (*n==1)
    	n+=2;
    if (!strcmp(n, "\002~BEGIN"))
        yyerror("internal error: keyword 'begin' not found");
    else
    	{
	    sprintf(msg, "undefined label %s", n);
    	yyerror(msg);
        }
	nextJump:
	}
localLine=oldline;
cursource=oldsource;
}

// 
//  NEWTEMPLABEL 
// 

char *newTempLabel(void)
{
static int label=0;
char *data;

if (*fakeLabel != 0)
	return fakeLabel;

data =newcode(7);
label++;
sprintf(data, "~%d", label);
return data;
}

// 
//  FAKENEXTLABEL 
// 

void fakeNextLabel(char *s)
{
if (*fakeLabel == 0)
	strcpy(fakeLabel, s);
else
	if (strcmp(s, fakeLabel))
		yyerror("internal error compiling conditional expression");
}

// 
//  PUSHLABELSTACK 
// 

void pushLabelStack(char *s)
{
char *name;

name = malloc(strlen(s)+1);
check_alloc(name);
strcpy(name,s);

while (labelStackPos + 1 > labelStackSize)
	{
	labelStackSize += LABELSTACKINC;
    labelStack = realloc(labelStack, labelStackSize*sizeof(char *));
    check_alloc(labelStack);
    }
labelStack[labelStackPos] = name;
labelStackPos++;
}

// 
//  POPLABELSTACK 
// 

char *popLabelStack(void)
{
char *data;
int a;
if (labelStackPos == 0)
	{
	yyerror("internal error translating structure");
    return NULL;
    }
a = strlen(labelStack[labelStackPos-1]);
data = newcode(a+1);
strcpy(data, labelStack[labelStackPos-1]);
free(labelStack[labelStackPos-1]);
labelStackPos--;
return data;
}

// 
//  OPENLOOP 
// 

void openLoop(int loopType)
{
while (loopPos + 1 > loopSize)
	{
    loopSize += LOOPINC;
    loop = realloc(loop, loopSize*2);
    check_alloc(loop);
    }
loop[loopPos] = loopType;
loopPos++;
}

// 
//  CLOSELOOP 
// 

void closeLoop(char *s, int loopType)
{
if (loopPos == 0)
	{
    sprintf(msg, "'%s' allowed only in a %s structure", s, loopName[loopType-1]);
	yyerror(msg);
    return;
    }
loopPos--;
if (loop[loopPos] != loopType && !((loopType==LOOP_IF||loopType==LOOP_ELSEIF) && loop[loopPos] >= LOOP_ELSEIF))
	{
    sprintf(msg, "'%s' cannot control a %s structure", s, loopName[loop[loopPos]-1]);
    yyerror(msg);
    }
}

// 
//  CHECKLOOP 
// 

void checkLoop(char *s, int loopType)
{
if (loopPos == 0)
	{
    sprintf(msg, "'%s' allowed only in a %s structure", s, loopName[loopType-1]);
	yyerror(msg);
    return;
    }
loopPos--;
if (loop[loopPos] != loopType && !((loopType==LOOP_IF||loopType==LOOP_ELSEIF) && loop[loopPos] >= LOOP_ELSEIF))
	{
    sprintf(msg, "'%s' cannot control a %s structure", s, loopName[loop[loopPos]-1]);
    yyerror(msg);
    }
loopPos++;
}

void endifLoop(void)
{
int a;
a = loop[loopPos-1];
if (a == LOOP_IF)
	a = LOOP_ELSEIF;
else
	if (a >= LOOP_ELSEIF)
    	a++;
    else
		yyerror("internal error compiling elseif structure");

loop[loopPos-1] = a;
}


// 
//  BEEP 
// 

void beep(void)
{
sound(2000);
delay(100);
nosound();
}

// 
//  PUSHSELECT 
// 

void pushSelect(char *var)
{
char *varValue;

varValue = malloc(*(int*)var+2);
check_alloc(varValue);
memcpy(varValue,var,*(int*)var+2);
while (selectPos + 1 > selectSize)
	{
    selectSize += SELECTINC;
    select = realloc(select, selectSize*sizeof(char *));
    check_alloc(select);
    }
select[selectPos] = varValue;
selectPos++;
}

// 
//  POPSELECT 
// 

char *popSelect(void)
{
char *data;
int a;
if (selectPos == 0)
	{
	yyerror("internal error translating 'select case' structure");
    return NULL;
    }
a = *(int *)select[selectPos-1];
data = newcode(a+2);
memcpy(data, select[selectPos-1], a+2);
free(select[selectPos-1]);
selectPos--;
return data;
}

// 
//  SWITCHLASTLABELS 
// 

void switchLastLabels(void)
{
char *c;

c = labelStack[labelStackPos-1];
labelStack[labelStackPos-1] = labelStack[labelStackPos-2];
labelStack[labelStackPos-2] = c;
}

// 
//  SEMVALUE 
// 

char *semValue(char *s)
{
int a;
char *data;
char *endptr;

if (*s == 1)
	s+=2;
a = strtol(s, &endptr, 10);
if (a == 0 && endptr == s)
	yyerror("numeric value required");

data=newcode(2);
*(int *)data = a;
return data;
}

// 
//  CHECKDIM 
// 

void checkDim(char *var, int n)
{
int a;

a = *(int*)(var+2);

if (identList[a-1]->nDim != n)
	yyerror("mismatch in number of dimensions");

}

// 
//  SEMTEXT 
// 

char *semText(char *s)
{
char *data=newcode(strlen(s)+1);

strcpy(data, s);
return data;
}

// 
//  INVALIDVAR 
// 

void invalidVar(char *v)
{
int a,b;

for (a=0;a<identListPos;a++)
	{
    if (!strcmpi(v, identList[a]->name))
		{
        if (a != identListPos - 1)
        	return;
        free(identList[a]->name);
        free(identList[a]->data);
	    if (identList[a]->paramTypes != NULL)
			free(identList[a]->paramTypes);
        free(identList[a]);
        for (b=a;b<identListPos-1;b++)
            identList[b] = identList[b+1];
        identListPos--;
        break;
        }
	}
}

// 
//  REGISTERPROC 
// 

void registerProc(char *procName, int nArgs, char *argTypes, int pf, int funcReturnType)
{
char *data;
int v,e,o,n,a;
unsigned char f,l;
char *ptr;
char *types;
identListType *p;

if (isInternal(procName))
	{
	sprintf(msg, "cannot use '%s' (internal) as a user defined %s", procName, pf == PROC_IDENTIFIER ? "procedure" : "function");
    yyerror(msg);
    }

f = nArgs;
v=0;
e=0;
o=0;
l=0;

data = calloc(8,1);
check_alloc(data);
types = calloc(nArgs+1,1);
check_alloc(types);

ptr = argTypes+2;
for(n=0;n<nArgs;n++)
	{
    a = *(int*)ptr;
    if (a == 255)
        {
        if (n > 15)
        	yyerror("VAR keyword limited to 16 first arguments of a procedure");
        else
        	{
		    ptr+=2;
    	    v |= 1 << n;
	        a = *(int*)ptr;
        	}
        }
	types[n] = a;
    ptr+=2;
    }
if (pf == FUNC_IDENTIFIER)
	v = funcReturnType;

*(char*)data=f;
*(char*)(data+1) = l;
*(int *)(data+2) = o;
*(int *)(data+4) = e;
*(int *)(data+6) = v;

while (identListPos + 1 > identListSize)
	{
    identListSize += IDENTIFIERINC;
    identList = realloc(identList, identListSize*sizeof(identListType *));
    check_alloc(identList);
    }

identList[identListPos] = (identListType*) malloc(sizeof(identListType));
check_alloc(identList[identListPos]);
p = identList[identListPos];
p->name=NULL;
p->data=NULL;
p->paramTypes=NULL;
identListPos++;
p->name = (char *)malloc(strlen(procName)+1);
check_alloc(p->name);
strcpy(p->name, procName);
if (pf == PROC_IDENTIFIER)
	p->type = 0x10;
else
	p->type = 0xF;
p->data = data;
p->dim1 = 0;
p->dim2 = 0;
p->dim3 = 0;
p->nDim = 0;
p->external=0;
p->offset=0;
p->paramTypes=types;
p->identHdr=0;
}

// 
//  CHECKPROC 
// 

void checkProc(char *procName, int nArgs, char *argTypes, int pf, int funcReturnType)
{
char *data;
int v,Ov,n,a,b;
unsigned char f;
char *ptr,*ptr2;

v=0;

for(a=0;a<identListPos;a++)
    if (!identcmp(identList[a], procName))
    	{
        identList[a]->identHdr = identHdr;
        data = identList[a]->data;
        f = *(char*)data;
        Ov = *(int *)(data+6);
        if (f != nArgs)
			{
            sprintf(msg, "body of '%s' mismatch number of arguments in declaration", procName);
            yyerror(msg);
            return;
			}
        identList[a]->offset = codeBufferPos;
        *(int *)(data+4) = identListPos-nArgs;

		ptr = argTypes+2;
		ptr2 = identList[a]->paramTypes;
		for(n=0;n<nArgs;n++)
			{
		    a = *(int*)ptr;
            b = *(char*)ptr2;
		    if (a == 255)
				{
		        if (n > 15)
        			yyerror("VAR keyword limited to 16 first arguments of a procedure");
                else
                	{
			        ptr+=2;
		            v |= 1 << n;
			        a = *(int*)ptr;
                	}
		        }
            if (a != b)
            	{
                sprintf(msg, "body of '%s' mismatch types of parameters in declaration", procName);
                yyerror(msg);
                return;
                }
            ptr+=2;
            ptr2++;
		    }
        if (pf == PROC_IDENTIFIER && v != Ov)
          	{
            sprintf(msg, "body of '%s' mismatch VAR keywords in declaration", procName);
            yyerror(msg);
            return;
            }
		if (pf == FUNC_IDENTIFIER)
			{
            if (Ov != funcReturnType)
	          	{
    	        sprintf(msg, "body of '%s' mismatch return type in declaration", procName);
        	    yyerror(msg);
            	return;
	            }
		    strcpy(yytext, procName);
            readProcs = 0;
		    registerIdent(NULL);
		    registerIdentList(funcReturnType);
            readProcs = 1;
		    ptr = lookup(SYMBOL);
		    v = (*(int*)(ptr+2));
	        *(int *)(data+6) = v;
		    }
        return;
	    }

sprintf(msg, "undefined %s '%s'", pf == PROC_IDENTIFIER ? "procedure" : "function", procName);
yyerror(msg);
}

// 
//  ENTERPROC 
// 

void enterProc(char *procName, int type)
{
curProc = malloc(strlen(procName)+1);
check_alloc(curProc);
strcpy(curProc, procName);
startNVars = identListPos;
curProcType = type;
}

// 
//  LEAVEPROC 
// 

void leaveProc(int type)
{
int a,g=0;
char *data;

if (curProc == NULL)
	yyerror("'endproc' invalid outside a procedure");

for(a=0;a<identListPos;a++)
    if (!identcmp(identList[a], curProc))
    	{
        data = identList[a]->data;
        free(curProc);
        curProc=NULL;
        break;
        }

if (curProc != NULL)
	{
    sprintf(msg, "internal error closing %s", curProcType == PROC_IDENTIFIER ? "procedure" : "function");
	yyerror(msg);
    }

if (curProcType != type)
	{
    sprintf(msg, "'%s' cannot close a %s", type == PROC_IDENTIFIER ? "endproc" : "endfunc", curProcType == PROC_IDENTIFIER ? "procedure" : "function");
	yyerror(msg);
    }

curProcType = 0;

if (type == FUNC_IDENTIFIER)
	g=1;
*(data+1) = identListPos-startNVars+g;
}

int identcmp(identListType *p, const char *s2)
{
if ((p->type == 0x7 || p->type == 0xD) && *(char *)p->name == '\"')
	return strcmp(p->name, s2);
return strcmpi(p->name, s2);
}



