// VECTBALL.CPP
// Vector Ball routines
// coded by Tumblin / Bodies In Motion

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "ssaver\XLib_all.h"
#include <dos.h>

signed int far mustQuit=0;

// This is a Mode-X Planar Bitmap
char far vbbitmap[] =
{
    6,  // width in bytes (4 pixel groups)
   24,  // height in pixels

  // plane 0
    0,  0, 43, 19,  0,  0,
    0,  0, 44, 16, 19,  0,
    0, 77, 44, 28, 22,  0,
	0, 12, 19, 40, 22,  0,
    0, 30, 19, 42, 50, 44,
    0, 30, 19, 45, 87, 29,
    0, 30, 13, 45, 73, 16,
    0, 12, 31, 70, 55, 19,
   23, 12, 31, 51, 62, 13,
   21, 12, 12, 71, 26, 13,
   11, 12, 12, 19, 16, 31,
   15, 11, 30, 64, 44, 31,
   14, 11, 11, 57, 13, 30,
   15, 11, 11, 57, 12, 15,
   21, 14, 14, 64, 64, 30,
    0, 14, 11, 11, 57, 12,
    0, 11, 11, 21, 11, 12,
    0, 15, 11, 14, 15, 15,
    0, 11, 15, 14, 11, 21,
    0, 15, 11, 14, 11,  0,
    0, 21, 21, 11, 11,  0,
    0,  0, 11, 21, 21,  0,
    0,  0, 21, 21,  0,  0,
	0,  0,  0,  0,  0,  0,
  // plane 1
    0,  0, 30, 44,  0,  0,
    0,  0, 44, 18,  0,  0,
    0, 30, 19, 41, 41,  0,
    0, 31, 16, 51, 22,  0,
    0, 44, 16, 45, 49,  0,
    0, 12, 18, 58, 80,  0,
   48, 12, 16, 66, 88, 16,
   11, 30, 19, 65, 94, 32,
   11, 31, 44, 42, 34, 16,
   15, 12, 31, 40, 41, 13,
   14, 12, 31, 16, 16, 13,
   14, 15, 12, 30, 16, 31,
   20, 11, 11, 11, 67, 12,
   14, 15, 11, 57, 12, 12,
   14, 14, 12, 11, 11, 12,
   15, 14, 11, 57, 11, 12,
   15, 21, 21, 11, 64, 11,
    0, 11, 11, 14, 11,  0,
	0, 11, 14, 14, 21,  0,
    0, 15, 11, 15, 11,  0,
    0, 11, 21, 11, 11,  0,
    0,  0, 11, 21,  0,  0,
    0,  0, 15, 21,  0,  0,
    0,  0,  0,  0,  0,  0,
  // plane 2
    0,  0, 44, 63,  0,  0,
    0, 64, 16, 18,  0,  0,
    0, 31, 16, 71, 30,  0,
    0, 44, 18, 51, 38,  0,
   23, 31, 71, 45, 41,  0,
   11, 30, 34, 66, 38,  0,
   12, 30, 26, 72, 38,  0,
   15, 31, 71, 58, 38,  0,
   15, 31, 18, 42, 28, 64,
   15, 31, 13, 40, 18, 31,
   11, 14, 44, 16, 18, 13,
   15, 15, 64, 30, 33, 13,
   14, 11, 57, 64, 31, 31,
   20, 11, 57, 64, 12, 64,
   20, 14, 11, 11, 64, 57,
   15, 15, 11, 11, 11,  0,
   11, 21, 21, 11, 11,  0,
   11, 21, 14, 14, 11,  0,
   53, 11, 14, 15, 11,  0,
    0, 11, 15, 15, 11,  0,
    0, 11, 11, 11, 53,  0,
    0, 11, 11, 21,  0,  0,
    0,  0, 11, 21,  0,  0,
    0,  0,  0,  0,  0,  0,
  // plane 3
    0,  0, 19,  0,  0,  0,
    0, 30, 16, 18,  0,  0,
    0, 44, 16, 71,  0,  0,
   48, 44, 71, 40, 19,  0,
   12, 44, 68, 70, 41,  0,
   12, 31, 93, 58, 18,  0,
   12, 13, 46, 66, 18,  0,
   12, 31, 51, 65, 18,  0,
   12, 31, 34, 42, 16,  0,
   15, 12, 18, 40, 32,  0,
   15, 12, 13, 16, 33,  0,
   11, 15, 12, 30, 67,  0,
   11, 57, 11, 30, 31,  0,
   14, 11, 57, 11, 64,  0,
   14, 14, 11, 11, 11,  0,
   14, 15, 21, 11, 11,  0,
   11, 11, 21, 11, 12,  0,
   15, 21, 14, 15, 11,  0,
   11, 11, 14, 11, 11,  0,
   21, 11, 14, 11, 21,  0,
	0, 11, 11, 11,  0,  0,
	0, 11, 11, 21,  0,  0,
	0,  0, 11,  0,  0,  0,
	0,  0,  0,  0,  0,  0
};


// This is palette data
char vbpalette[3*97]=
{
   0, 0, 0, // color # 0
  38,20,46, // color # 1
  50,20,46, // color # 2
  62,20,46, // color # 3
  22,24,46, // color # 4
  12,28,46, // color # 5
  40,30,46, // color # 6
  24,34,46, // color # 7
  38,40,46, // color # 8
   0,46,46, // color # 9
  24,14,46, // color # 10
  17,10,21, // color # 11
  18,11,22, // color # 12
  20,10,24, // color # 13
  19,12,23, // color # 14
  18,11,21, // color # 15
  22,10,27, // color # 16
   7, 4, 8, // color # 17
  23,11,28, // color # 18
  21,10,26, // color # 19
  20,12,24, // color # 20
  16,10,19, // color # 21
  26,12,32, // color # 22
  13, 8,16, // color # 23
   2, 1, 3, // color # 24
   4, 2, 5, // color # 25
  26,11,32, // color # 26
   5, 3, 6, // color # 27
  24,11,29, // color # 28
  25,12,30, // color # 29
  19, 9,22, // color # 30
  19,11,24, // color # 31
  23,12,28, // color # 32
  22,12,27, // color # 33
  28,11,34, // color # 34
   8, 5,10, // color # 35
   6, 3, 7, // color # 36
  12, 8,15, // color # 37
  26,12,31, // color # 38
  11, 5,13, // color # 39
  29,10,36, // color # 40
  25,11,30, // color # 41
  38,11,46, // color # 42
  15, 7,18, // color # 43
  20, 9,24, // color # 44
  43,12,52, // color # 45
  35,11,43, // color # 46
   8, 5, 9, // color # 47
  15, 9,18, // color # 48
  28,12,34, // color # 49
  33,13,40, // color # 50
  32,11,39, // color # 51
  52,14,63, // color # 52
  15,10,19, // color # 53
   3, 2, 4, // color # 54
  41,13,50, // color # 55
   3, 1, 4, // color # 56
  16, 9,19, // color # 57
  49,12,60, // color # 58
   6, 4, 7, // color # 59
  13, 6,16, // color # 60
   1, 1, 2, // color # 61
  33,11,40, // color # 62
  16, 7,20, // color # 63
  18, 9,21, // color # 64
  46,11,56, // color # 65
  51,12,62, // color # 66
  21,12,26, // color # 67
  31,11,38, // color # 68
  12, 5,14, // color # 69
  39,11,48, // color # 70
  26,11,31, // color # 71
  54,13,63, // color # 72
  44,14,53, // color # 73
  12, 7,14, // color # 74
  49,15,60, // color # 75
   9, 6,11, // color # 76
  14, 8,17, // color # 77
   4, 1, 4, // color # 78
  40,13,48, // color # 79
  30,12,37, // color # 80
  44,11,54, // color # 81
   3, 2, 3, // color # 82
  50,13,61, // color # 83
  38,12,46, // color # 84
  47,13,57, // color # 85
  10, 6,12, // color # 86
  42,14,50, // color # 87
  34,13,41, // color # 88
  14, 7,17, // color # 89
  44,13,53, // color # 90
  31,13,38, // color # 91
  30,10,36, // color # 92
  35,12,42, // color # 93
  32,12,39, // color # 94
  40,11,48, // color # 95
   9, 6,12, // color # 96
};


// function prototypes
void draw_vector_balls(void);
void create_lookup_tables(void);
void create_vector_object(void);
int main(void);

// sin and cos lookup tables
float cosine[360];
float sine[360];

// structure for one vector ball
typedef struct
{
	int x;
	int y;
	int z;
	int color;
} VectBallType;

// maximum number of balls in this demo's object
int maxballs=8;

// start off demo with some random initial angles
int xangle=random(360);
int yangle=random(360);
int zangle=random(360);

// the z distance from the center of the universe (0, 0, 0 :-)
int distance=140;
// flag to tell when the object is moving towards or away from you
int direction=1;

// origional vector ball object
VectBallType object[8];
// working copy of vector ball object
VectBallType temp[8];
// single dummy vector ball used for swaping
VectBallType dummy;

//---------------------------------------------------------------
void create_lookup_tables(void)
{
	int i;
	for(i=0; i<360; i++)
	{
		cosine[i] = cos(i * 3.14159265 / 180);
		sine[i] = sin(i * 3.14159265 / 180);
	}
}


//---------------------------------------------------------------
void create_vector_object(void)
{
	// This object will look like a cube
	// back top left
	object[0].x=-30;
	object[0].y=-30;
	object[0].z=30;
	// back top right
	object[1].x=30;
	object[1].y=-30;
	object[1].z=31;
	// back bottom left
	object[2].x=-30;
	object[2].y=30;
	object[2].z=32;
	// back bottom right
	object[3].x=30;
	object[3].y=30;
	object[3].z=33;
	// front top left
	object[4].x=-30;
	object[4].y=-30;
	object[4].z=-30;
	// front top right
	object[5].x=30;
	object[5].y=-30;
	object[5].z=-31;
	// front bottom left
	object[6].x=-30;
	object[6].y=30;
	object[6].z=-32;
	// front bottom right
	object[7].x=30;
	object[7].y=30;
	object[7].z=-33;
}

void draw_vector_object(void)
{
	int i,j,k,a,b,nx,ny,nz;

	// first we have to do all the rotations
	for(i=0;i<8;i++)
	{
		// rotate around the x-axis
		ny=(int)(object[i].y*cosine[xangle]-object[i].z*sine[xangle]);
		nz=(int)(object[i].y*sine[xangle]+object[i].z*cosine[xangle]);
		nx=(int)(object[i].x);
		temp[i].x=nx;
		temp[i].y=ny;
		temp[i].z=nz;

		// rotate around the y-axis
		nx=(int)(temp[i].x * cosine[yangle] +temp[i].z * sine[yangle]);
		nz=(int)(-temp[i].x * sine[yangle]+temp[i].z * cosine[yangle]);
		temp[i].x=nx;
		temp[i].z=nz;

		// rotate around the z-axis
		nx=(int)(temp[i].x * cosine[zangle]-temp[i].y * sine[zangle]);
		ny=(int)(temp[i].x * sine[zangle]+temp[i].y * cosine[zangle]);
		temp[i].x=nx;
		temp[i].y=ny;

		// now we have to push the z coordinates into the view area
		temp[i].z-=distance;

		// finally we project & copy the new x,y,z to a temporary array
		temp[i].x=(int)((temp[i].x*256)/temp[i].z+160);
		temp[i].y=(int)((temp[i].y*256)/temp[i].z+120);
		temp[i].color=object[i].color;
	}

	// now we need to do z-buffering
	// the z with most positive value should be in lowest index
	// I used bubble sort here because there are only 8 balls :-)
	for(j=0;j<7;j++)
	{
		for(k=j+1;k<8;k++)
		{
			a=temp[j].z;
			b=temp[k].z;
			if(a >= b)
			{
				// swap the two vector balls
				dummy=temp[j];
				temp[j]=temp[k];
				temp[k]=dummy;
			}
		}
	}

	// we're done everything, so draw the object!
	// first we erase the old stuff off the drawing zone
//	x_rect_fill(160-70,120-70,160+70,120+70,HiddenPageOffs,0);
	x_rect_fill(0,0,320,240,HiddenPageOffs,0);
	for(i=0;i<8;i++)
	{
#pragma warn -ucp
		x_put_masked_pbm(temp[i].x-11,temp[i].y-15,HiddenPageOffs,vbbitmap);
#pragma warn .ucp
	}
}

void far mouseMoved(void)
{
mustQuit = -1;
}

//---------------------------------------------------------------
void screenSaver(void)
{
	unsigned int of, se;

	mustQuit=0;

	of = FP_OFF(mouseMoved);
	se = FP_SEG(mouseMoved);

	asm{
	mov ax,0
	int 0x33
	cmp ax,0
	je nomouse
	mov ax, se
	mov es, ax
	mov dx, of
	mov ax, 0x000C
	mov cx, 0x11
	int 0x33

	}


	nomouse:


	randomize();
/*	x_text_mode();
	printf("\n\n\nV E C T O R   B A L L S");
	printf("\ncoded by Tumblin / Bodies In Motion  (a.k.a.  Terry Sznober)");
	printf("\n\n\nPress any key to begin demo.  Press a key again to quit demo.");
	getch();*/
	x_set_mode(X_MODE_320x240,320);
	create_lookup_tables();
	create_vector_object();
#pragma warn -ucp
	x_put_pal_raw(vbpalette,97,0);
#pragma warn .ucp
	x_set_doublebuffer(240);
	for(;;)	// do an infinite loop until user hits a key
	{
		if (kbhit())
			{
			if (getch() == 0)
				getch();
			break;
			}

		if (mustQuit)
			break;

		if(direction==1)	// if object is moving away from you,
		{
			distance+=1;	// move it even further
			if(distance>=600)	// if at the limit, make it come back
			{
				direction=0;
				distance=600;
			}
		}
		else	// no, object is moving towards you
		{
			distance-=1;	// bring it a little closer
			if(distance<=140)	// if at limit, make it go away again
			{
				direction=1;
				distance=140;
			}
		}
		// update the angles
		xangle+=3;
		if(xangle>=360)
			xangle=0;
		yangle+=3;
		if(yangle>=360)
			yangle=0;
		zangle-=2;
		if(zangle<=0)
			zangle=359;
		// draw the vector ball object on the hidden screen
		draw_vector_object();
		// show what we just did
		x_page_flip(0,0);
	}
	x_text_mode();

	// show the greets                                                                   |
/*	printf("                     Tumblin / Bodies In Motion  greets:\n\n");
	printf("                             The Future Crew\n");
	printf("                                Avalanche\n");
	printf("                         The Emulator Institute\n");
	printf("                                 Triton\n");
	printf("                                 Witan\n");
	printf("                                Silents\n\n");
	printf("                                 Shades\n");
	printf("                              Shadow Hunter\n");
	printf("                                 Gravis\n");
	printf("                     all the guys that helped me on IRC\n");
	printf("                  every coder who ever released source code\n");
	printf("                       and Themie Gouthas for XLib06\n");*/

	return;
}
