/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


class TMenuBar;
class TStatusLine;
class TEditWindow;
class TDialog;

class TEvent;
class TPalette;
class THeapView;
class fpstream;

#include "consts.h"

class TEditorApp : public TApplication
{

public:

    TEditorApp(int argc, char *argv[]);

    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );
    virtual void outOfMemory();
    void calculator();
    void calendar();
    void ascii();
	void colorchart();
	void openViewer(const char *fileName);
    void doDecompile();
    void selectParams();
    void showAbout();
    void doCompile();
    void loadConfig();
    void saLoadConfig();
    void saveConfig();
    virtual TPalette& getPalette() const;
    void openHelp( int );
    void doPathDialog();
    void idle();
    void colors();
    void defaultcolors();
    void pathOptions();
	void fileOptions();
	void doZippySearch();
    void fige();
    void defige();
    void openProject();
    void postCardInfo();
    void userInfo();
    void argumentLine();
    void runPPE();
    void setTabLen();

private:

    THeapView *heap;

    TEditWindow *openEditor( const char *fileName, Boolean visible );
	void openMessages( const char *fileName, int num );
	void openTags(int num);
	void fileOpen();
    void fileNew();
    void changeDir();
    void dosShell();
    void showClip();
    void tile();
    void cascade();
    void saveDesktop();
    void retrieveDesktop();
    void loadDesktop(fpstream& s);
    void storeDesktop(fpstream& s);
};

extern TEditWindow *clipWindow;

ushort execDialog( TDialog *d, void *data );
TDialog *createFindDialog();
TDialog *createReplaceDialog();
ushort doEditDialog( int dialog, ... );

struct tFormat{
	char	*name;
	short	argMini;
	short	argMaxi;
	int		argType;
	int		nUsed;
};

struct uFormat{
	char	*name;
	short	argMini;
	short	argMaxi;
	int		nUsed;
};
