/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/* Modified by Francis Gastellu for PowerPPL
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_TRect
#define Uses_TView
#define Uses_TDrawBuffer
#include <tv.h>

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <strstrea.h>
#include <iomanip.h>
#include <alloc.h>

#include "gadgets.h"


//
// ------------- Heap Viewer functions
//

THeapView::THeapView(TRect& r) : TView( r )
{
    oldMem = 0;
    newMem = heapSize();
}


void THeapView::draw()
{
    TDrawBuffer buf;
    char c = getColor(2);

    buf.moveChar(0, ' ', c, size.x);
    buf.moveStr(0, heapStr, c);
    writeLine(0, 0, size.x, 1, buf);
}


void THeapView::update()
{
    if( (newMem = heapSize()) != oldMem )
	{
	oldMem = newMem;
	drawView();
	}
}


long THeapView::heapSize()
{
    long total = farcoreleft();
    struct farheapinfo heap;
    ostrstream totalStr( heapStr, sizeof heapStr);

    switch( farheapcheck() )
	{
	case _HEAPEMPTY:
	    strcpy(heapStr, " No heap");
	    total = -1;
	    break;

	case _HEAPCORRUPT:
	    strcpy(heapStr, "Corrupt!");
	    total = -2;
	    break;

	case _HEAPOK:
	    heap.ptr = NULL;
	    while(farheapwalk(&heap) != _HEAPEND)
		if(!heap.in_use)
		    total += heap.size;
	    totalStr << setw(8) << total << ends;
	    break;
	}
    return(total);
}


