/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Macros translation

*/

#include <string.h>
#include <stdlib.h>
#include "..\com\system.h"
#include "..\com\pcbdat.h"

char far *pcbVar[] = {
	"ALIAS"         ,
	"AUTOMORE"      ,
	"BEEP"          ,
	"BICPS"         ,
	"BOARDNAME"     ,
	"BPS"           ,
	"BYTECREDIT"    ,
    "BYTELIMIT"     ,
    "BYTERATIO"     ,
    "BYTESLEFT"     ,
    "CARRIER"       ,
    "CITY"          ,
    "CLREOL"        ,
    "CLS"           ,
    "CONFNAME"      ,
    "CONFNUM"       ,
    "CURMSGNUM"     ,
    "DATAPHONE"     ,
    "DAYBYTES"      ,
    "DELAY"         ,
    "DIRNAME"       ,
    "DIRNUM"        ,
    "DLBYTES"       ,
    "DLFILES"       ,
    "ENV"           ,
    "EVENT"         ,
    "EXPDATE"       ,
    "EXPDAYS"       ,
    "FBYTES"        ,
    "FFILES"        ,
    "FILECREDIT"    ,
    "FILERATIO"     ,
    "FIRSTU"        ,
    "FIRST"         ,
    "FNUM"          ,
    "FREESPACE"     ,
    "HOMEPHONE"     ,
    "HIGHMSGNUM"    ,
    "INCONF"        ,
    "KBLEFT"        ,
    "KBLIMIT"       ,
    "LASTCALLERNODE",
    "LASTCALLERSYST",
    "LASTDATEON"    ,
    "LASTTIMEON"    ,
    "LMR"           ,
    "LOGDATE"       ,
    "LOGTIME"       ,
    "LOWMSGNUM"     ,
    "MAXBYTES"      ,
    "MAXFILES"      ,
    "MINLEFT"       ,
    "MORE"          ,
    "MSGLEFT"       ,
    "MSGREAD"       ,
    "NOCHAR"        ,
    "NODE"          ,
    "NUMBLT"        ,
    "NUMCALLS"      ,
    "NUMCONF"       ,
    "NUMDIR"        ,
    "NUMTIMESON"    ,
    "OFFHOURS"      ,
    "OPTEXT"        ,
    "PAUSE"         ,
    "POFF"          ,
    "PON"           ,
    "POS"           ,
    "PROLTR"        ,
    "PRODESC"       ,
    "PWXDATE"       ,
    "PWXDAYS"       ,
    "QOFF"          ,
    "QON"           ,
    "RATIOBYTES"    ,
    "RATIOFILES"    ,
    "RBYTES"        ,
    "RCPS"          ,
    "RFILES"        ,
    "SBYTES"        ,
    "SCPS"          ,
    "SECURITY"      ,
    "SFILES"        ,
    "SYSDATE"       ,
    "SYSOPIN"       ,
    "SYSOPOUT"      ,
    "SYSTIME"       ,
    "TIMELIMIT"     ,
    "TIMELEFT"      ,
    "TIMEUSED"      ,
    "TOTALTIME"     ,
    "UPBYTES"       ,
    "UPFILES"       ,
    "USER"          ,
    "WAIT"          ,
    "WHO"           ,
    "YESCHAR" };

void replacePcbVar(char *destString, int varNum, int width, int justif,  char *origStr);

void replacePcbVar(char *destString, int varNum, int width, int justif, char *origStr)
{
float a;
char *b;
char value[256]="";
switch (varNum+1)
	{
	case 1://"ALIAS"         ,
    	break;
	case 2://"AUTOMORE"      ,
    	break;
	case 3://"BEEP"          ,
    	AsyncPut("");
    	break;
	case 4://"BICPS"         ,
    	break;
	case 5://"BOARDNAME"     ,
    	strcpy(value, boardName);
    	break;
	case 6://"BPS"           ,
    	sprintf(value, "%ld", carrierSpeed);
    	break;
	case 7://"BYTECREDIT"    ,
    	break;
    case 8://"BYTELIMIT"     ,
    	break;
    case 9://"BYTERATIO"     ,
    	break;
    case 10://"BYTESLEFT"     ,
    	break;
    case 11://"CARRIER"       ,
    	break;
    case 12://"CITY"          ,
    	strcpy(value, user.City);
    	break;
    case 13://"CLREOL"        ,
    	clreol();
    	break;
    case 14://"CLS"           ,
    	cls();
        break;
    case 15://"CONFNAME"      ,
		sprintf(tmpStr, "Conf%d",(int) curConf);
		getProfileString(tmpStr, "Name", "MSGS", value, 79, iniFile);
    	break;
    case 16://"CONFNUM"       ,
    	itoa(curConf, value, 10);
    	break;
    case 17://"CURMSGNUM"     ,
    	break;
    case 18://"DATAPHONE"     ,
    	break;
    case 19://"DAYBYTES"      ,
    	break;
    case 20://"DELAY"         ,
    	delay(width);
    	break;
    case 21://"DIRNAME"       ,
    	break;
    case 22://"DIRNUM"        ,
    	break;
    case 23://"DLBYTES"       ,
    	break;
    case 24://"DLFILES"       ,
    	break;
    case 25://"ENV"           ,
        b = strchr(origStr, '=');
        if (!b) break;
        strcpy(tmpStr, b+1);
        tmpStr[strlen(tmpStr)-1] = 0;
        b = getenv(tmpStr);
        if (!b) break;
		strnzcpy(value, b, 255);
    	break;
    case 26://"EVENT"         ,
    	break;
    case 27://"EXPDATE"       ,
    	break;
    case 28://"EXPDAYS"       ,
    	break;
    case 29://"FBYTES"        ,
    	break;
    case 30://"FFILES"        ,
    	break;
    case 31://"FILECREDIT"    ,
    	break;
    case 32://"FILERATIO"     ,
    	break;
    case 33://"FIRSTU"        ,
    	break;
    case 34://"FIRST"         ,
    	break;
    case 35://"FNUM"          ,
    	break;
    case 36://"FREESPACE"     ,
    	break;
    case 37://"HOMEPHONE"     ,
		strcpy(value, user.VoicePhone);
    	break;
    case 38://"HIGHMSGNUM"    ,
    	break;
    case 39://"INCONF"        ,
    	break;
    case 40://"KBLEFT"        ,
    	break;
    case 41://"KBLIMIT"       ,
    	break;
    case 42://"LASTCALLERNODE",
    	break;
    case 43://"LASTCALLERSYST",
    	break;
    case 44://"LASTDATEON"    ,
    	break;
    case 45://"LASTTIMEON"    ,
    	break;
    case 46://"LMR"           ,
    	break;
    case 47://"LOGDATE"       ,
    	break;
    case 48://"LOGTIME"       ,
    	break;
    case 49://"LOWMSGNUM"     ,
    	break;
    case 50://"MAXBYTES"      ,
    	break;
    case 51://"MAXFILES"      ,
    	break;
    case 52://"MINLEFT"       ,
    	break;
    case 53://"MORE"          ,
    	more();
        break;
    case 54://"MSGLEFT"       ,
    	break;
    case 55://"MSGREAD"       ,
    	break;
    case 56://"NOCHAR"        ,
    	*value = no;
        value[1]=0;
    	break;
    case 57://"NODE"          ,
	    itoa(node, value, 10);
    	break;
    case 58://"NUMBLT"        ,
    	break;
    case 59://"NUMCALLS"      ,
    	break;
    case 60://"NUMCONF"       ,
    	break;
    case 61://"NUMDIR"        ,
    	break;
    case 62://"NUMTIMESON"    ,
    	break;
    case 63://"OFFHOURS"      ,
    	break;
    case 64://"OPTEXT"        ,
    	break;
    case 65://"PAUSE"         ,
    	pause();
    	break;
    case 66://"POFF"          ,
		linesCounting=0;
        break;
    case 67://"PON"           ,
		linesCounting=1;
        break;
    case 68://"POS"           ,
    	break;
    case 69://"PROLTR"        ,
    	break;
    case 70://"PRODESC"       ,
    	break;
    case 71://"PWXDATE"       ,
    	break;
    case 72://"PWXDAYS"       ,
    	break;
    case 73://"QOFF"          ,
    	break;
    case 74://"QON"           ,
    	break;
    case 75://"RATIOBYTES"    ,
    	break;
    case 76://"RATIOFILES"    ,
    	break;
    case 77://"RBYTES"        ,
    	break;
    case 78://"RCPS"          ,
    	break;
    case 79://"RFILES"        ,
    	break;
    case 80://"SBYTES"        ,
    	break;
    case 81://"SCPS"          ,
    	break;
    case 82://"SECURITY"      ,
    	itoa(user.Security, value, 10);
    	break;
    case 83://"SFILES"        ,
    	break;
    case 84://"SYSDATE"       ,
    	break;
    case 85://"SYSOPIN"       ,
    	break;
    case 86://"SYSOPOUT"      ,
    	break;
    case 87://"SYSTIME"       ,
    	break;
    case 88://"TIMELIMIT"     ,
    	break;
    case 89://"TIMELEFT"      ,
    	break;
    case 90://"TIMEUSED"      ,
    	break;
    case 91://"TOTALTIME"     ,
    	break;
    case 92://"UPBYTES"       ,
    	break;
    case 93://"UPFILES"       ,
    	break;
    case 94://"USER"          ,
		strcpy(value, user.FullName);
    	break;
    case 95://"WAIT"          ,
    	wait();
    	break;
    case 96://"WHO"           ,
    	who();
    	break;
    case 97://"YESCHAR" };
    	*value = yes;
        value[1]=0;
    	break;
    }
if (width != 0)
	{
    switch (justif)
	    {
        case 0:
		    sprintf(tmpStr, "%-*s", width, value);
    	    break;
        case 1:
            memset(tmpStr, ' ', width);
		    tmpStr[width]=0;
            a = ((float)(width-strlen(value)))/2;
            if ((int)a != a) a = ((int)a) + 1;
		    strcpy(&tmpStr[a], value);
    	    break;
        case 2:
		    sprintf(tmpStr, "%*s", width, value);
    	    break;
        }
    }
else
    strcpy(tmpStr, value);

strcpy(destString, tmpStr);
}


void setPcbVar(char *destVar, char *Value)
{
}

