/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*
                           + Project Frontier +

 PPL Runtime

 PPL FUNCTIONS 

*/
#pragma warn -par

#define YYSTYPE pplvar*

#include <alloc.h>
#include <ctype.h>
#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <stdlib.h>
#include <process.h>
#include <dir.h>
#include <fcntl.h>
#include <share.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>
#include "..\com\rs232.h"
#include "..\com\async2.h"
#include "..\lang\ppl_type.h"
#include "..\lang\ppl_tab.h"
#include "..\lang\ppl.h"
#include "..\lang\funcs.h"
#include "..\com\system.h"
#include "..\lang\fortify.h"
#include "..\com\mbfieee.h"
#include "..\com\pcbdat.h"
#include "..\dual\dual.h"
#include "..\com\tpa.h"
#include "..\ppc\profile\profile.h"
#include "..\lang\fnmatch.h"
#include "..\lang\pcbvar.h"
#include "..\lang\crc.h"

pplvar *pplRegVar(int n);
extern int far RdUNetNode;

/*

 OPERATOR ADD 

*/

pplvar *ppl_F_ADD(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(v1->type, 0, v1->dim);

if (fppe_isStr(v1) && fppe_isStr(v2))
	{
    strcpy(tmpStr, fppe_Cstr(v1->value));
	strcat(tmpStr, fppe_Cstr(v2->value));
    fppe_strcpy(s, tmpStr);
    return s;
    }
fppe_setValue(s, fppe_getValue(v1)+fppe_getValue(v2));
return s;
}

/*

 OPERATOR SUB 

*/

pplvar *ppl_F_SUB(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(v1->type, 0, v1->dim);
fppe_setValue(s, fppe_getValue(v1)-fppe_getValue(v2));
return s;
}

/*

 OPERATOR MUL 

*/

pplvar *ppl_F_MUL(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(v1->type, 0, v1->dim);
fppe_setValue(s, fppe_getValue(v1)*fppe_getValue(v2));
return s;
}

/*

 OPERATOR DIV 

*/

pplvar *ppl_F_DIV(pplvar **table)
{
pplvar *s;
double b;

s = fppe_newvar(table[0]->type, 0, s->dim);

b = fppe_getValue(table[1]);
if (b == 0)
	return s;
fppe_setValue(s, fppe_getValue(table[0])/b);

return s;
}

/*

 OPERATOR POW 

*/

pplvar *ppl_F_POW(pplvar **table)
{
pplvar *s;

s = fppe_newvar(table[0]->type, 0, s->dim);
fppe_setValue(s, pow(fppe_getValue(table[0]),fppe_getValue(table[1])));

return s;
}

/*

 OPERATOR MOD 

*/

pplvar *ppl_F_MOD(pplvar **table)
{
pplvar *s;
double b;

s = fppe_newvar(table[0]->type, 0, s->dim);

b = fppe_getValue(table[1]);
if (b == 0)
	return s;
fppe_setValue(s, fmod(fppe_getValue(table[0]), b));

return s;
}

/*

 OPERATOR UNEGATIVE 

*/

pplvar *ppl_F_UNEGATIVE(pplvar **table)
{
pplvar *s, *v1;

v1 = table[0];

s = fppe_newvar(v1->type, 0, v1->dim);
fppe_setValue(s, -fppe_getValue(v1));
return s;
}

/*

 OPERATOR UPOSITIVE 

*/

pplvar *ppl_F_UPOSITIVE(pplvar **table)
{
pplvar *s, *v1;

v1 = table[0];

s = fppe_newvar(v1->type, 0, v1->dim);
fppe_setValue(s, +fppe_getValue(v1));
return s;
}

/*

 OPERATOR UNOT 

*/

pplvar *ppl_F_UNOT(pplvar **table)
{
pplvar *s, *v1;

v1 = table[0];

s = fppe_newvar(v1->type, 0, v1->dim);
fppe_setValue(s, !fppe_getValue(v1));
return s;
}

/*

 TEST EQUAL == 

*/

pplvar *ppl_F_CMP_EQU(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (!strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)))
    	fppe_setValue(s, 1);
    }
else
	if (fppe_getValue(v1) == fppe_getValue(v2))
		fppe_setValue(s, 1);

return s;
}

/*

 TEST NOT EQUAL != 

*/

pplvar *ppl_F_CMP_NEQ(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)))
    	fppe_setValue(s, 1);
    }
else
	if (fppe_getValue(v1) != fppe_getValue(v2))
		fppe_setValue(s, 1);

return s;
}

/*

 TEST BELLOW < 

*/

pplvar *ppl_F_CMP_BEL(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)) < 0)
    	fppe_setValue(s, 1);
    }
else
	fppe_setValue(s, fppe_getValue(table[0]) < fppe_getValue(table[1]));

return s;
}

/*

 TEST BELLOW OR EQUAL <= 

*/

pplvar *ppl_F_CMP_BOE(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)) <= 0)
    	fppe_setValue(s, 1);
    }
else
	fppe_setValue(s, fppe_getValue(table[0]) <= fppe_getValue(table[1]));

return s;
}

/*

 TEST ABOVE > 

*/

pplvar *ppl_F_CMP_ABO(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)) > 0)
    	fppe_setValue(s, 1);
    }
else
	fppe_setValue(s, fppe_getValue(table[0]) > fppe_getValue(table[1]));

return s;
}

/*

 TEST ABOVE OR EQUAL >= 

*/

pplvar *ppl_F_CMP_AOE(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_isStr(v1) && fppe_isStr(v2))
    {
	if (strcmp(fppe_Cstr(v1->value), fppe_Cstr(v2->value)) >= 0)
    	fppe_setValue(s, 1);
    }
else
	fppe_setValue(s, fppe_getValue(table[0]) >= fppe_getValue(table[1]));

return s;
}

/*

 TEST AND && 

*/

pplvar *ppl_F_BOOL_AND(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_getValue(v1) && fppe_getValue(v2))
	fppe_setValue(s, 1);

return s;
}

/*

 TEST OR || 

*/

pplvar *ppl_F_BOOL_OR(pplvar **table)
{
pplvar *s, *v1, *v2;

v1 = table[0];
v2 = table[1];

s = fppe_newvar(0, 0, v1->dim);
if (fppe_getValue(v1) || fppe_getValue(v2))
	fppe_setValue(s, 1);

return s;
}

/*

 LEN 

*/

pplvar *ppl_F_LEN(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);

fppe_setValue(s, strlen(fppe_Cstr(fppe_toStringVar(table[0])->value)));
return s;
}

/*

 LOWER 

*/

pplvar *ppl_F_LOWER(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, fppe_Cstr(fppe_toStringVar(table[0])->value));
strlwr(fppe_Cstr(s->value));
return s;
}

/*

 UPPER 

*/

pplvar *ppl_F_UPPER(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, fppe_Cstr(fppe_toStringVar(table[0])->value));
strupr(fppe_Cstr(s->value));
return s;
}

/*

 MID 

*/

pplvar *ppl_F_MID(pplvar **table) // a verifier!
{
pplvar *s;
int d, l, m, a;
char *t;
char *db;

tmpStr[0] = 0;
s = fppe_newvar(7, 0, s->dim);

d = fppe_getValue(table[1]);
l = fppe_getValue(table[2]);
t = fppe_Cstr(fppe_toStringVar(table[0])->value);
if (l < 1)
	return s;
for (a=0;a<l;a++)
	strcat(tmpStr, " ");
db = (char*)&tmpStr;
m = l;
for (;d<1;d++,db++,m--);
strncpy(db, t+d-1, m);
tmpStr[l]=0;
if (strlen(tmpStr) < l)
	for (a=strlen(tmpStr);a<l;a++)
    	tmpStr[a] = 32;

fppe_strcpy(s, tmpStr);
return s;
}

/*

 LEFT 

*/

pplvar *ppl_F_LEFT(pplvar **table)
{
pplvar *s;
int n,a;

tmpStr[0]=0;
s = fppe_newvar(7, 0, s->dim);

n = fppe_getValue(table[1]);
if (n < 1)
	return s;
strncpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value), n);
tmpStr[n]=0;
if (strlen(tmpStr) < n)
	for (a=strlen(tmpStr);a<n;a++)
    	tmpStr[a] = 32;

fppe_strcpy(s, tmpStr);
return s;
}

/*

 RIGHT 

*/

pplvar *ppl_F_RIGHT(pplvar **table)
{
pplvar *s;
char *t;
int n,a,m,d;
char *db;

tmpStr[0]=0;
s = fppe_newvar(7, 0, s->dim);

t = fppe_Cstr(fppe_toStringVar(table[0])->value);
n = fppe_getValue(table[1]);
if (n < 1)
	return s;
for (a=0;a<n;a++)
	strcat(tmpStr, " ");
db = (char*)&tmpStr;
m = n;
d = strlen(t)-n+1;
for (;d<1;d++,db++,m--);
strncpy(db, t+d-1, m);
tmpStr[n] = 0;
if (strlen(tmpStr) < n)
	for (a=strlen(tmpStr);a<n;a++)
    	tmpStr[a] = 32;

fppe_strcpy(s, tmpStr);
return s;
}

/*

 SPACE 

*/

pplvar *ppl_F_SPACE(pplvar **table)
{
pplvar *s;
int a;

s = fppe_newvar(0xD, 0, s->dim);
a = fppe_getValue(table[0]);

if (a > 2048) a = 2048;
if (a < 0) a = 0;

memset(fppe_Cstr(s->value), ' ', a);
fppe_Cstr(s->value)[a] = 0;

return s;
}

/*

 FERR 

*/

pplvar *ppl_F_FERR(pplvar **table)
{
pplvar *s;
int f;

s = fppe_newvar(0, 0, s->dim);
f = fppe_getValue(table[0]);

if (fileHandle[f+1] == NULL)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, ferr[f + 1]);

ferr[f + 1] = 0;
return s;
}

/*

 CHR 

*/

pplvar *ppl_F_CHR(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7, 0, s->dim);

tmpStr[0] = fppe_getValue(table[0]);
tmpStr[1] = 0;

fppe_strcpy(s, tmpStr);
return s;
}

/*

 ASC 

*/

pplvar *ppl_F_ASC(pplvar **table)
{
char c;
pplvar *s;
c = *(char *)fppe_Cstr(fppe_toStringVar(table[0])->value);
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, c);
return s;
}

/*

 INSTR 

*/

pplvar *ppl_F_INSTR(pplvar **table)
{
char c,a;
pplvar *s;
char *p1, *p2;
c = *fppe_Cstr(fppe_toStringVar(table[1])->value);

s = fppe_newvar(4, 0, s->dim);
p2 = fppe_Cstr(fppe_toStringVar(table[1])->value);
p1 = (char *)strstr(fppe_Cstr(fppe_toStringVar(table[0])->value), p2);
if (p1 == NULL || c == 0)
	a = 0;
else
	a = (p1 - p2) + 1;

fppe_setValue(s, a);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ABORT(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, abortScroll);
return s;
}

/*

 LTRIM 

*/

pplvar *ppl_F_LTRIM(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7, 0, s->dim);

tmpStr[0]=0;
strcpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value));
while(tmpStr[0] == ' ')
	strcpy(tmpStr, &tmpStr[1]);

fppe_strcpy(s, tmpStr);
return s;
}

/*

 LTRIM 

*/

pplvar *ppl_F_RTRIM(pplvar **table)
{
pplvar *s;
int a;
s = fppe_newvar(7, 0, s->dim);

tmpStr[0] = 0;
strcpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value));
for (a=strlen(tmpStr)-1;a>=0;a--)
	if (tmpStr[a] == ' ')
		tmpStr[a] = 0;
    else
    	break;

fppe_strcpy(s, tmpStr);
return s;
}

/*

 TRIM 

*/

pplvar *ppl_F_TRIM(pplvar **table)
{
pplvar *s;
int a;
s = fppe_newvar(7, 0, s->dim);

tmpStr[0]=0;
strcpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value));
for (a=strlen(tmpStr)-1;a>=0;a--)
	if (tmpStr[a] == ' ')
		tmpStr[a] = 0;
    else
    	break;

while(tmpStr[0] == ' ')
	strcpy(tmpStr, &tmpStr[1]);

fppe_strcpy(s, tmpStr);
return s;
}

/*

 RANDOM 

*/

pplvar *ppl_F_RANDOM(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, random((int)fppe_getValue(table[0])+1));
return s;
}

/*

 DATE 

*/

pplvar *ppl_F_DATE(pplvar **table)
{
pplvar *s;
struct date d_date;
struct time d_time;
long a;
s = fppe_newvar(2, 0, s->dim);
getdate(&d_date);
d_time.ti_min=0;
d_time.ti_hour=0;
d_time.ti_hund=0;
d_time.ti_sec=0;

a = 25568 + DosToUnix(&d_date, &d_time) / 86400;
fppe_setValue(s, a);
return s;
}

/*

 TIME 

*/

pplvar *ppl_F_TIME(pplvar **table)
{
struct  time t;
signed long a;
pplvar *s;

s = fppe_newvar(8, 0, s->dim);
gettime(&t);
a = (long)t.ti_hour * 3600 + (long)t.ti_min * 60 + (long)t.ti_sec;
fppe_setValue(s, a);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_NAME(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);
strncpy(tmpStr, ppe_user.FullName, 25);

fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_LDATE(pplvar **table)
{
pplvar *s = fppe_newvar(2, 0, s->dim);
strncpy(tmpStr, ppe_user.LastDateOn, 6);
fppe_setValue(s, sysCharDateToPPLDate(tmpStr));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_LTIME(pplvar **table)
{
pplvar *s = fppe_newvar(8, 0, s->dim);
strncpy(tmpStr, ppe_user.LastTimeOn, 5);
fppe_setValue(s, charTimeToPPLTime(tmpStr));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_LDIR(pplvar **table)
{
pplvar *s = fppe_newvar(2, 0, s->dim);
fppe_setValue(s, sysCharDateToPPLDate(ppe_user.LastDir));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_LOGONS(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, ppe_user.TimesOn);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_FUL(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, ppe_user.FilesUploaded);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_FDL(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, ppe_user.FilesDownloaded);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_BDLDAY(pplvar **table)
{
pplvar *s = fppe_newvar(0xE, 0, s->dim);

fppe_setValue(s, BdReal2Double(ppe_user.BytesDownloadedToday));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_TIMEON(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);

fppe_setValue(s, ppe_user.TimeOn);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_BDL(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0xE, 0, s->dim);
fppe_setValue(s, BdReal2Double(ppe_user.BytesDownloaded));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_BUL(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0xE, 0, s->dim);
fppe_setValue(s, BdReal2Double(ppe_user.BytesUploaded));
return s;
}

/*

 YEAR 

*/

pplvar *ppl_F_YEAR(pplvar **table) // a modifier (acces direct a value!)
{
pplvar *s;
struct date d_date;
time_t t;
struct date d1;
struct time t1;

s = fppe_newvar(4, 0, s->dim);

t = (*(unsigned int *)table[0]->value - 25568) * 86400;
UnixToDos(t, &d1, &t1);
fppe_setValue(s, d1.da_year);

return s;
}

/*

 MONTH 

*/

pplvar *ppl_F_MONTH(pplvar **table)
{
pplvar *s;
struct date d_date;
time_t t;
//struct tm *local;
struct date d1;
struct time t1;

s = fppe_newvar(4, 0, s->dim);

t = (*(unsigned int *)table[0]->value - 25568) * 86400;
//local = localtime(&t);
UnixToDos(t, &d1, &t1);
fppe_setValue(s, d1.da_mon);

return s;
}

/*

 DAY 

*/

pplvar *ppl_F_DAY(pplvar **table)
{
pplvar *s;
struct date d_date;
time_t t;
struct date d1;
struct time t1;

s = fppe_newvar(4, 0, s->dim);

t = (*(unsigned int *)table[0]->value - 25568) * 86400;
UnixToDos(t, &d1, &t1);
fppe_setValue(s, d1.da_day);

return s;
}

/*

 DOW 

*/

pplvar *ppl_F_DOW(pplvar **table)
{
pplvar *s;
struct date d_date;
long t;

s = fppe_newvar(4, 0, s->dim);

t = (long)((fppe_getValue(table[0]) - 25568) + 3) % 7;

fppe_setValue(s, t);
return s;
}

/*

 HOUR 

*/

pplvar *ppl_F_HOUR(pplvar **table)
{
pplvar *s;
struct time t2;
unsigned long l;

s = fppe_newvar(4, 0, s->dim);

l = *(signed long *)table[0]->value;
t2.ti_hour = (long)(l / 3600);

fppe_setValue(s, t2.ti_hour);

return s;
}

/*

 MIN 

*/

pplvar *ppl_F_MIN(pplvar **table)
{
pplvar *s;
struct time t2;
unsigned long l;

s = fppe_newvar(4, 0, s->dim);

l = *(signed long *)table[0]->value;
t2.ti_hour = (long)(l / 3600);
l -= (long)t2.ti_hour * 3600;
t2.ti_min = (long)(l / 60);

fppe_setValue(s, t2.ti_min);

return s;
}

/*

 SEC 

*/

pplvar *ppl_F_SEC(pplvar **table)
{
pplvar *s;
struct time t2;
unsigned long l;

s = fppe_newvar(4, 0, s->dim);

l = *(signed long *)table[0]->value;
t2.ti_hour = (long)(l / 3600);
l -= (long)t2.ti_hour * 3600;
t2.ti_min = (long)(l / 60);
l -= (long)t2.ti_min * 60;
t2.ti_sec = l;

fppe_setValue(s, t2.ti_sec);

return s;
}

/*

  -  

*/

pplvar *ppl_F_TIMEAP(pplvar **table)
{
struct time t2;
unsigned long l;
int pm=0;
pplvar *d = fppe_newvar(7, 0, d->dim);
pplvar *s = fppe_newvar(8, 0, s->dim);

fppe_assignVar(s, table[0]);

l = *(signed long *)s->value;
t2.ti_hour = (long)(l / 3600);
l -= (long)t2.ti_hour * 3600;
t2.ti_min = (long)(l / 60);
l -= (long)t2.ti_min * 60;
t2.ti_sec = l;
pm=0;
if (t2.ti_hour > 12)
    {
    t2.ti_hour -= 12;
    pm=1;
    }
sprintf(tmpStr, "%2d:%02d:%02d %s", t2.ti_hour, t2.ti_min, t2.ti_sec, pm ? "PM" : "AM");
fppe_strcpy(d, tmpStr);
return d;
}

/*

 VER 

*/

pplvar *ppl_F_VER(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, FRONTIER_VERSION);
return s;
}

/*

  -  

*/

pplvar *ppl_F_NOCHAR(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
tmpStr[0] = no;
tmpStr[1] = 0;
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_YESCHAR(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
tmpStr[0] = yes;
tmpStr[1] = 0;
fppe_strcpy(s, tmpStr);
return s;
}

/*

 STRIPATX 

*/

pplvar *ppl_F_STRIPATX(pplvar **table)
{
pplvar *s;
int a=-1,b=0,end=0;
char c;
s = fppe_newvar(0xD, 0, s->dim);

strcpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value));
while (!end)
	{
    a++;
    c = tmpStr[a];
    switch (c)
    	{
        case 0 :
        	end=1;
			break;

        case '@':
        	if ( tmpStr[a+1] == 'X' && isHex( tmpStr[a+2] ) && isHex( tmpStr[a+3]) )
            	{
				a+=3;
                continue;
                }
        default :
            fppe_Cstr(s->value)[b] = c;
            b++;
        }
    }
return s;
}

/*

  -  

*/

pplvar *ppl_F_REPLACE(pplvar **table)
{
pplvar *s = fppe_newvar(0xD, 0, s->dim);
strncpy(fppe_Cstr(s->value), fppe_Cstr(fppe_toStringVar(table[0])->value), 2048);
strcrpl(fppe_Cstr(s->value), *fppe_Cstr(fppe_toStringVar(table[1])->value), *fppe_Cstr(fppe_toStringVar(table[2])->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_STRIP(pplvar **table)
{
pplvar *s = fppe_newvar(0xD, 0, s->dim);
strncpy(fppe_Cstr(s->value), fppe_Cstr(fppe_toStringVar(table[0])->value), 2048);
strcsup(fppe_Cstr(s->value), *fppe_Cstr(fppe_toStringVar(table[1])->value));
return s;
}

/*

 INKEY 

*/

pplvar *ppl_F_INKEY(pplvar **table)
{
return pplGetKey(MASK_BOTH);
}

/*

  -  

*/

pplvar *ppl_F_STRING(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, fppe_Cstr(fppe_toStringVar(table[0])->value));
return s;
}

/*

 MASK_PWD 

*/

pplvar *ppl_F_MASK_PWD(pplvar **table)
{
return mask_pwd();
}

pplvar *mask_pwd(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~");
return s;
}

/*

 MASK_ALPHA 

*/

pplvar *ppl_F_MASK_ALPHA(pplvar **table)
{
return mask_alpha();
}

pplvar *mask_alpha(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
return s;
}

/*

 MASK_NUM 

*/

pplvar *ppl_F_MASK_NUM(pplvar **table)
{
return mask_num();
}

pplvar *mask_num(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "0123456789");
return s;
}

/*

 MASK_ALNUM 

*/

pplvar *ppl_F_MASK_ALNUM(pplvar **table)
{
return mask_alnum();
}

pplvar *mask_alnum(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
return s;
}

/*

 MASK_FILE 

*/

pplvar *ppl_F_MASK_FILE(pplvar **table)
{
return mask_file();
}

pplvar *mask_file(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "!#$%&'()-.0123456789:@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz~");
return s;
}

/*

 MASK_PATH 

*/

pplvar *ppl_F_MASK_PATH(pplvar **table)
{
return mask_path();
}

pplvar *mask_path(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, ":\!#$%&'()-.0123456789:@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz~");
return s;
}

/*

 MASK_ASCII 

*/

pplvar *ppl_F_MASK_ASCII(pplvar **table)
{
return mask_ascii();
}

pplvar *mask_ascii(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~");
return s;
}


/*

  -  

*/

pplvar *ppl_F_CURCONF(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, curConf);
return s;
}

/*

  -  

*/

pplvar *ppl_F_PCBDAT(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);

strcpy(tmpStr, systemPath);
if (systemPath[strlen(systemPath)-1] != '\\')
	strcat(tmpStr, "\\");
strcat(tmpStr, "PCBOARD.DAT");
fppe_strcpy(s, tmpStr);
return s;
}

/*

 PPEPATH 

*/

pplvar *ppl_F_PPEPATH(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);

fnsplit(PPErunning, tmpDrive, tmpDir, NULL, NULL);
if (tmpDrive[0]==0)
	sprintf(tmpDrive, "%c:", getdisk() + 'A');
if (tmpDir[0] == 0)
	{
    tmpDir[0] = '\\';
    tmpDir[1] = 0;
	getcurdir(0, &tmpDir[1]);
    }

fnmerge(tmpStr, tmpDrive, tmpDir, NULL, NULL);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_VALDATE(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
charDateToPPLDate(fppe_Cstr(fppe_toStringVar(table[0])->value), 0);
if (validDate)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_VALTIME(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
charTimeToPPLTime(fppe_Cstr(fppe_toStringVar(table[0])->value));
if (validTime)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_MSGRD(pplvar **table)
{
return notImplemented("u_msgrd");
}

/*

  -  

*/

pplvar *ppl_F_U_MSGWR(pplvar **table)
{
return notImplemented("u_msgwr");
}

/*

  -  

*/

pplvar *ppl_F_PCBNODE(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, node);
return s;
}

/*

 READLINE 

*/

pplvar *ppl_F_READLINE(pplvar **table)
{
pplvar *s;
int n,l;
static long lastOff;
static int lastLine=0;
char *file;
int line;
char c;
int b, exit;
char *str;

str = calloc(256,1);
s = fppe_newvar(7, 0, s->dim);
file = fppe_Cstr(fppe_toStringVar(table[0])->value);
line = fppe_getValue(table[1]);
if (strcmp(file, readlineLastFile) || *readlineLastFile == 0)
	{
    if (fileHandle[0] != NULL)
    	{
		fclose(fileHandle[0]);
        ferr[0] = 0;
        }
	if ((fileHandle[0] = _fsopen(file, "rb", SH_DENYNONE)) == NULL)
		{
//	    sprintf(tmpStr, "Enable to open %s", file);
//		fppe_runtimeError(tmpStr);
        free(str);
        ferr[1] = 1;
        return &emptyVar;
		}
    ferr[0] = 0;
    strcpy(readlineLastFile, file);
	lastOff=0;
    lastLine=0;
    }

if (lastLine >= line)
    lastLine = 0;

if (lastLine == 0)
	lastOff = 0;

fseek(fileHandle[0], lastOff, SEEK_SET);

/*if (lastLine >= line)
	{
	fseek(fileHandle[0], -1, SEEK_CUR);
	while (lastLine >= line)
		{
		fseek(fileHandle[0], -1, SEEK_CUR);
        fread(&c, 1, 1, fileHandle[0]);
		if (c == '\n')
			{
			lastLine--;
			fseek(fileHandle[0], -1, SEEK_CUR);
			}
		fseek(fileHandle[0], -1, SEEK_CUR);
		}
	fseek(fileHandle[0], 2, SEEK_CUR);
	}*/

l = line - lastLine;

for (n=0;n<l;n++)
	{
    if (feof(fileHandle[0]))
    	{
		*str=0;
        break;
        }
    *str=0;
	fgets(str, 256, fileHandle[0]);
	if (str[strlen(str)-1] != '\n')
		{
	    strcpy(tmpStr, str);
    	while (tmpStr[strlen(tmpStr)-1] != '\n' && !feof(fileHandle[0]))
			fgets(tmpStr, 256, fileHandle[0]);
		}
    }

b = strlen(str);
if (str[b-1] == '\n' && b > 0)
   	str[b-1] = 0;
if (str[b-2] == '\r' && b > 1)
   	str[b-2] = 0;

if (feof(fileHandle[0])) ferr[0] = 1;
lastLine = line;
lastOff = ftell(fileHandle[0]);
fppe_strcpy(s, str);
free(str);
return s;
}

/*

  -  

*/

pplvar *ppl_F_SYSOPSEC(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, sysopLevel);
return s;
}

/*

 ONLOCAL 

*/

pplvar *ppl_F_ONLOCAL(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, initCode <= 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_UN_STAT(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
*tmpStr = nodeGetStatus(RdUNetNode);
tmpStr[1]=0;
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_UN_NAME(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
nodeGetUserName(RdUNetNode, tmpStr);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_UN_CITY(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
nodeGetUserCity(RdUNetNode, tmpStr);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_UN_OPER(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
nodeGetUserOperation(RdUNetNode, tmpStr);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CURSEC(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, ppe_user.Security);
return s;
}

/*

  -  

*/

pplvar *ppl_F_GETTOKEN(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
tmpStr[0]=0;
getToken(tmpStr, tokenStr);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_MINLEFT(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);

fppe_setValue(s, userTimeLeft);
return s;
}

/*

  -  

*/

pplvar *ppl_F_MINON(pplvar **table)
{
struct time t;
pplvar *s = fppe_newvar(4, 0, s->dim);

gettime(&t);
fppe_setValue(s, userMinsOn);
return s;
}

/*

 GETENV 

*/

pplvar *ppl_F_GETENV(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, getenv(fppe_Cstr(fppe_toStringVar(table[0])->value)));
return s;
}

/*

  -  

*/

pplvar *ppl_F_CALLID(pplvar **table)
{
return &emptyVar;
}

/*

 REGAL 

*/

pplvar *ppl_F_REGAL(pplvar **table)
{
return pplRegVar(0);
}

/*

 REGAH 

*/

pplvar *ppl_F_REGAH(pplvar **table)
{
return pplRegVar(1);
}

/*

 REGBL 

*/

pplvar *ppl_F_REGBL(pplvar **table)
{
return pplRegVar(2);
}

/*

 REGBH 

*/

pplvar *ppl_F_REGBH(pplvar **table)
{
return pplRegVar(3);
}

/*

 REGCL 

*/

pplvar *ppl_F_REGCL(pplvar **table)
{
return pplRegVar(4);
}

/*

 REGCH 

*/

pplvar *ppl_F_REGCH(pplvar **table)
{
return pplRegVar(5);
}

/*

 REGDL 

*/

pplvar *ppl_F_REGDL(pplvar **table)
{
return pplRegVar(6);
}

/*

 REGDH 

*/

pplvar *ppl_F_REGDH(pplvar **table)
{
return pplRegVar(7);
}

/*

 REGAX 

*/

pplvar *ppl_F_REGAX(pplvar **table)
{
return pplRegVar(8);
}

/*

 REGBX 

*/

pplvar *ppl_F_REGBX(pplvar **table)
{
return pplRegVar(9);
}

/*

 REGCX 

*/

pplvar *ppl_F_REGCX(pplvar **table)
{
return pplRegVar(10);
}

/*

 REGDX 

*/

pplvar *ppl_F_REGDX(pplvar **table)
{
return pplRegVar(11);
}

/*

 REGSI 

*/

pplvar *ppl_F_REGSI(pplvar **table)
{
return pplRegVar(12);
}

/*

 REGDI 

*/

pplvar *ppl_F_REGDI(pplvar **table)
{
return pplRegVar(13);
}

/*

 REGF 

*/

pplvar *ppl_F_REGF(pplvar **table)
{
return pplRegVar(14);
}

/*

 REGCF 

*/

pplvar *ppl_F_REGCF(pplvar **table)
{
return pplRegVar(15);
}

/*

 REGDS 

*/

pplvar *ppl_F_REGDS(pplvar **table)
{
return pplRegVar(16);
}

/*

 REGES 

*/

pplvar *ppl_F_REGES(pplvar **table)
{
return pplRegVar(17);
}

/*

 B2W 

*/

pplvar *ppl_F_B2W(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, fppe_getValue(table[0])*0x100+fppe_getValue(table[1]));
return s;
}

/*

 PEEK 

*/

pplvar *ppl_F_PEEK(pplvar **table)
{
pplvar *s;
long a, b;
unsigned int se,o;

s = fppe_newvar(4, 0, s->dim);
a = fppe_getValue(table[0]);

se = a/0x10000;
o = a & 0xFFFF;
b = (unsigned char)peekb(se, o);

fppe_setValue(s, b);
return s;
}

/*

 PEEKW 

*/

pplvar *ppl_F_PEEKW(pplvar **table)
{
pplvar *s;
long a, b;
unsigned int se,o;

s = fppe_newvar(4, 0, s->dim);
a = fppe_getValue(table[0]);

se = a/0x10000;
o = a & 0xFFFF;
b = (unsigned int)peek(se, o);

fppe_setValue(s, b);
return s;
}

/*

 MKADDR 

*/

pplvar *ppl_F_MKADDR(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, fppe_getValue(table[0]) * 0x10000 + fppe_getValue(table[1]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_EXIST(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
if (!access(fppe_Cstr(fppe_toStringVar(table[0])->value), 0))
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

 I2S 

*/

pplvar *ppl_F_I2S(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7, 0, s->dim);
tmpStr[0]=0;
if (fppe_isSigned(table[0]))
	ltoa((signed long)fppe_getValue(table[0]), tmpStr, (int)fppe_getValue(table[1]));
else
	ultoa((unsigned long)fppe_getValue(table[0]), tmpStr, (int)fppe_getValue(table[1]));
strupr(tmpStr);
fppe_strcpy(s, tmpStr);
return s;
}

/*

 S2I 

*/

pplvar *ppl_F_S2I(pplvar **table)
{
pplvar *s;
char *t;
s = fppe_newvar(4, 0, s->dim);
if (fppe_isSigned(table[0]))
	fppe_setValue(s, strtol(fppe_Cstr(fppe_toStringVar(table[0])->value), &t, fppe_getValue(table[1])));
else
	fppe_setValue(s, strtoul(fppe_Cstr(fppe_toStringVar(table[0])->value), &t, fppe_getValue(table[1])));
return s;
}

/*

 CARRIER 

*/

pplvar *ppl_F_CARRIER(pplvar **table)
{
pplvar *s;

if (initCode <= 0)
	return &zeroVar;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, carrierSpeed);

return s;
}

/*

  -  

*/

pplvar *ppl_F_TOKENSTR(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, tokenStr);
*tokenStr=0;
return s;
}

/*

 CDON 

*/

pplvar *ppl_F_CDON(pplvar **table)
{
pplvar *s;

if (initCode <= 0)
	return &zeroVar;

s = fppe_newvar(0,0,s->dim);
if (Carrier())
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);

return s;
}

/*

  -  

*/

pplvar *ppl_F_LANGEXT(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, langExt);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ANSION(pplvar **table)
{
return notImplemented("ansion");
}

/*

  -  

*/

pplvar *ppl_F_VALCC(pplvar **table)
{
return notImplemented("valcc");
}

/*

  -  

*/

pplvar *ppl_F_FMTCC(pplvar **table)
{
return notImplemented("fmtcc");
}

/*

  -  

*/

pplvar *ppl_F_CCTYPE(pplvar **table)
{
return notImplemented("cctype");
}

/*

 GETX 

*/

pplvar *ppl_F_GETX(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, VIOwherex()+1);
return s;
}

/*

 GETY 

*/

pplvar *ppl_F_GETY(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, VIOwherey()+1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_AND(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, (signed long)fppe_getValue(table[0]) & (signed long)fppe_getValue(table[1]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_OR(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, (signed long)fppe_getValue(table[0]) | (signed long)fppe_getValue(table[1]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_XOR(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, (signed long)fppe_getValue(table[0]) ^ (signed long)fppe_getValue(table[1]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_NOT(pplvar **table)
{
signed long a;
pplvar *s = fppe_newvar(4, 0, s->dim);
a = (signed long)fppe_getValue(table[0]);
a = a ^ 0xFFFFFFFF;
fppe_setValue(s, a);
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_PWDHIST(pplvar **table)
{
return notImplemented("pwdhist");
}

/*

  -  

*/

pplvar *ppl_F_U_PWDLC(pplvar **table)
{
return notImplemented("pwdlc");
}

/*

  -  

*/

pplvar *ppl_F_U_PWDTC(pplvar **table)
{
return notImplemented("pwdtc");
}

/*

  -  

*/

pplvar *ppl_F_U_STAT(pplvar **table)
{
return notImplemented("u_stat");
}

/*

  -  

*/

pplvar *ppl_F_DEFCOLOR(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, defaultColor);
return s;
}

/*

 ABS 

*/

pplvar *ppl_F_ABS(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, fabs(fppe_getValue(table[0])));
return s;
}

/*

  -  

*/

pplvar *ppl_F_GRAFMODE(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
*tmpStr = grafMode;
tmpStr[1]=0;
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_PSA(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, psa((int)fppe_getValue(table[0])));
return s;
}

/*

  -  

*/

pplvar *ppl_F_FILEINF(pplvar **table)
{
pplvar *s;
int option = fppe_getValue(table[1]);
struct ffblk ffblk;
int err;
int d[3];

/*
ff_ftime 15.....1110........54.......0
 ͹
         ͼ
            Hours     Minutes   Seconds/2

ff_fdate 15..........98.....54.......0
 ͹
         ͼ
           Years since   Month     Day
              1980
*/
switch (option)
	{
    case 1: // file exist, boolean
        s = fppe_newvar(0, 0, s->dim);
		if (!access(fppe_Cstr(fppe_toStringVar(table[0])->value), 0))
			fppe_setValue(s, 1);
		else
			fppe_setValue(s, 0);
        return s;
    case 2: // file date, date
		err = findfirst(fppe_Cstr(fppe_toStringVar(table[0])->value),&ffblk,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH | FA_LABEL | FA_DIREC);
        s = fppe_newvar(2, 0, s->dim);
        if (!err)
        	{
            d[0] = ffblk.ff_fdate & 0x1F;
            d[1] = (ffblk.ff_fdate & 0x1E0) >> 5;
            d[2] = ((ffblk.ff_fdate & 0xFE00) >> 9) + 80;
            sprintf(tmpStr, "%02d/%02d/%02d", d[dayPart()], d[monthPart()], d[2]);
            fppe_setValue(s, charDateToPPLDate(tmpStr, 0));
            }
        return s;
    case 3: // file time, date
		err = findfirst(fppe_Cstr(fppe_toStringVar(table[0])->value),&ffblk,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH | FA_LABEL | FA_DIREC);
        s = fppe_newvar(8, 0, s->dim);
        if (!err)
        	{
            d[0] = (ffblk.ff_ftime & 0x1F) << 1;
            d[1] = (ffblk.ff_ftime & 0x7E0) >> 5;
            d[2] = ((ffblk.ff_ftime & 0xF800) >> 11);
            sprintf(tmpStr, "%02d:%02d:%02d", d[2], d[1], d[0]);
            fppe_setValue(s, charTimeToPPLTime(tmpStr));
            }
        return s;
    case 4: // file size, longint
		err = findfirst(fppe_Cstr(fppe_toStringVar(table[0])->value),&ffblk,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH | FA_LABEL | FA_DIREC);
        s = fppe_newvar(4, 0, s->dim);
        if (!err)
            fppe_setValue(s, ffblk.ff_fsize);
        return s;
    case 5: // file attribs, longint
		err = findfirst(fppe_Cstr(fppe_toStringVar(table[0])->value),&ffblk,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH | FA_LABEL | FA_DIREC);
        s = fppe_newvar(4, 0, s->dim);
        if (!err)
            fppe_setValue(s, ffblk.ff_attrib);
        return s;
    case 6: // file drive, string
		fnsplit(fppe_Cstr(fppe_toStringVar(table[0])->value),tmpDrive, NULL, NULL, NULL);
        tmpDrive[1]=0;
        s = fppe_newvar(7, 0, s->dim);
        fppe_strcpy(s, tmpDrive);
        strupr(fppe_Cstr(s->value));
        return s;
    case 7: // file path, string
		fnsplit(fppe_Cstr(fppe_toStringVar(table[0])->value), NULL, tmpDir, NULL, NULL);
        s = fppe_newvar(7, 0, s->dim);
        fppe_strcpy(s, tmpDir);
        strupr(fppe_Cstr(s->value));
        return s;
    case 8: // file name, string
		fnsplit(fppe_Cstr(fppe_toStringVar(table[0])->value), NULL, NULL, tmpFile, NULL);
        s = fppe_newvar(7, 0, s->dim);
        fppe_strcpy(s, tmpFile);
        strupr(fppe_Cstr(s->value));
        return s;
    case 9: // file name, string
		fnsplit(fppe_Cstr(fppe_toStringVar(table[0])->value), NULL, NULL, NULL, tmpExt);
        s = fppe_newvar(7, 0, s->dim);
        fppe_strcpy(s, tmpExt+1);
        strupr(fppe_Cstr(s->value));
        return s;
    default:
        s = fppe_newvar(4, 0, s->dim);
        return s;
    }
}

/*

 PPENAME 

*/

pplvar *ppl_F_PPENAME(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);

fnsplit(PPErunning, NULL, NULL, tmpFile, tmpExt);
fnmerge(tmpStr, NULL, NULL, tmpFile, tmpExt);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_MKDATE(pplvar **table)
{
return notImplemented("mkdate");
}

/*

 CURCOLOR 

*/

pplvar *ppl_F_CURCOLOR(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, curColor);
return s;
}

/*

 KINKEY 

*/

pplvar *ppl_F_KINKEY(pplvar **table)
{
return pplGetKey(MASK_SYSOP);
}

/*

 MINKEY 

*/

pplvar *ppl_F_MINKEY(pplvar **table)
{
return pplGetKey(MASK_USER);
}

/*

  -  

*/

pplvar *ppl_F_MAXNODE(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, maxnode);
return s;
}

/*

  -  

*/

pplvar *ppl_F_SLPATH(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, secFilesPath);
return s;
}

/*

  -  

*/

pplvar *ppl_F_HELPPATH(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, helpFilesPath);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TEMPPATH(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, tempFilesPath);
return s;
}

/*

 MODEM 

*/

pplvar *ppl_F_MODEM(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, connectString);
return s;
}

/*

  -  

*/

pplvar *ppl_F_LOGGEDON(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, userLoggedNum > -1 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CALLNUM(pplvar **table)
{
return notImplemented("callnum");
}

/*

 MGETBYTE 

*/

pplvar *ppl_F_MGETBYTE(pplvar **table)
{
pplvar *s;
char c;
s=fppe_newvar(4,0,s->dim);
if (InStat() == 0)
	fppe_setValue(s, -1);
else
	{
    c = AsyncGet();
    fppe_setValue(s, c);
    }
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOKCOUNT(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, tokCount(tokenStr));
return s;
}

/*

  -  

*/

pplvar *ppl_F_U_RECNUM(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, userRecNr(fppe_Cstr(fppe_toStringVar(table[0])->value)));

return s;
}

/*

  -  

*/

pplvar *ppl_F_U_INCONF(pplvar **table)
{
return notImplemented("inconf");
}

/*

 PEEKDW 

*/

pplvar *ppl_F_PEEKDW(pplvar **table)
{
pplvar *s;
long a, b;
unsigned int se,o;

s = fppe_newvar(4, 0, s->dim);
a = fppe_getValue(table[0]);

se = a/0x10000;
o = a & 0xFFFF;
b = (unsigned int)peek(se, o) + (unsigned int)peek(se, o+2) * 0x10000;

fppe_setValue(s, b);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DBGLEVEL(pplvar **table)
{
return notImplemented("dbglevel");
}

/*

 SCRTEXT 

*/

pplvar *ppl_F_SCRTEXT(pplvar **table)
{
pplvar *s;
int col, lig, len, code;

s = fppe_newvar(0x7, 0, s->dim);
col = fppe_getValue(table[0]);
lig = fppe_getValue(table[1]);
len = fppe_getValue(table[2]);
code = fppe_getValue(table[3]);

tmpStr[0]=0;
scrtext(tmpStr, col, lig, len, code);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_SHOWSTAT(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
if (!globalNoDisplay)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_PAGESTAT(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
if (pageFlag)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_REPLACESTR(pplvar **table)
{
pplvar *s = fppe_newvar(0xD, 0, s->dim);
strncpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value), 2048);
strsrpl(tmpStr, fppe_Cstr(fppe_toStringVar(table[1])->value), fppe_Cstr(fppe_toStringVar(table[2])->value));
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_STRIPSTR(pplvar **table)
{
pplvar *s = fppe_newvar(0xD, 0, s->dim);
strncpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value), 2048);
strssup(tmpStr, fppe_Cstr(fppe_toStringVar(table[1])->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOBIGSTR(pplvar **table)
{
pplvar *s = fppe_newvar(0xD, 0, s->dim);
fppe_strcpy(s, fppe_Cstr(fppe_toStringVar(table[0])->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOBOOLEAN(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOBYTE(pplvar **table)
{
pplvar *s = fppe_newvar(9, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TODATE(pplvar **table)
{
pplvar *s = fppe_newvar(2, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TODOUBLE(pplvar **table)
{
pplvar *s = fppe_newvar(0xE, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOEDATE(pplvar **table)
{
pplvar *s = fppe_newvar(3, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOINTEGER(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOMONEY(pplvar **table)
{
pplvar *s = fppe_newvar(5, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOREAL(pplvar **table)
{
pplvar *s = fppe_newvar(6, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOSHORT(pplvar **table)
{
pplvar *s = fppe_newvar(0xB, 0, s->dim);
fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOINT(pplvar **table)
{
pplvar *s = fppe_newvar(0xC, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOTIME(pplvar **table)
{
pplvar *s = fppe_newvar(8, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TODWORD(pplvar **table)
{
pplvar *s = fppe_newvar(1, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOWORD(pplvar **table)
{
pplvar *s = fppe_newvar(0xA, 0, s->dim);
fppe_assignVar(s, table[0]);
//fppe_setValue(s, fppe_getValue(table[0]));
return s;
}

/*

  -  

*/

pplvar *ppl_F_MIXED(pplvar **table)
{
int a;
char pr=32;
pplvar *s = fppe_newvar(7, 0, s->dim);
strcpy(tmpStr, fppe_Cstr(fppe_toStringVar(table[0])->value));
strlwr(tmpStr);
for (a=0;a<strlen(tmpStr);a++)
	{
    if (pr == 32)
		tmpStr[a] = toupper(tmpStr[a]);
    pr = tmpStr[a];
    }
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ALIAS(pplvar **table)
{
return notImplemented("alias");
}

/*

  -  

*/

/*#define F_REG 			0x1
-Registered access allowed flag for CONFFLAG and CONFUNFLAG
#define F_EXP 			0x2
-Expired subscription access allowed flag for CONFFLAG and CONFUNFLAG
#define F_SEL 			0x4
-Conference selected flag for CONFFLAG and CONFUNFLAG
#define F_SYS 			0x8
-Conference SysOp access flag for CONFFLAG and CONFUNFLAG
#define F_MW 			0x10
Mail waiting flag for CONFFLAG and CONFUNFLAG*/

pplvar *ppl_F_CONFREG(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, (confFlags(fppe_getValue(table[0])) & 1) != 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFEXP(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, (confFlags(fppe_getValue(table[0])) & 2) != 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFSEL(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, (confFlags(fppe_getValue(table[0])) & 4) != 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFSYS(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, (confFlags(fppe_getValue(table[0])) & 8) != 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFMW(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);

fppe_setValue(s, (confFlags(fppe_getValue(table[0])) & 0x10) != 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_LPRINTED(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, CFcount);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ISNONSTOP(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
if (!linesCounting)
	fppe_setValue(s, 1);
else
	fppe_setValue(s, 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ERRCORRECT(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
fppe_setValue(s, errorcorrect);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFALIAS(pplvar **table)
{
return notImplemented("confalias");
}

/*

  -  

*/

pplvar *ppl_F_USERALIAS(pplvar **table)
{
return notImplemented("useralias");
}

/*

  -  

*/

pplvar *ppl_F_CURUSER(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4, 0, s->dim);
if (currentUserNum == userLoggedNum)
	fppe_setValue(s, -1);
else
	fppe_setValue(s, currentUserNum);

return s;
}

/*

  -  

*/

pplvar *ppl_F_U_LMR(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, getLmr(fppe_getValue(table[0]), currentUserNum));

return s;
}

/*

  -  

*/

pplvar *ppl_F_CHATSTAT(pplvar **table)
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);
fppe_setValue(s, ppe_user.ChatStatus ? 0 : 1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DEFANS(pplvar **table)
{
return notImplemented("defans");
}

/*

  -  

*/

pplvar *ppl_F_LASTANS(pplvar **table)
{
return notImplemented("lastans");
}

/*

  -  

*/

pplvar *ppl_F_MEGANUM(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
char *t=calloc(256,1);
tmpStr[0]=0;
itoa((int)fppe_getValue(table[0]), tmpStr, 36);

if (strlen(tmpStr) < 2)
	{
	*t = '0';
	*(t+1) = toupper(tmpStr[0]);
    }
else
	{
	*t = toupper(tmpStr[0]);
	*(t+1) = toupper(tmpStr[1]);
    }
fppe_strcpy(s, t);
free(t);
return s;
}

/*

  -  

*/

pplvar *ppl_F_EVTTIMEADJ(pplvar **table)
{
return notImplemented("evttimeadj");
}

/*

  -  

*/

pplvar *ppl_F_ISBITSET(pplvar **table)
{
return notImplemented("isbitset");
}

/*

  -  

*/

pplvar *ppl_F_FMTREAL(pplvar **table)
{
return notImplemented("fmtreal");
}

/*

  -  

*/

pplvar *ppl_F_FLAGCNT(pplvar **table)
{
pplvar *s;
runSystemPPE("FLAGCNT.PPE");

s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, fppe_getValue(&ppeReturnValue));

return s;
}

/*

  -  

*/

pplvar *ppl_F_KBDBUFSIZE(pplvar **table)
{
return notImplemented("kbdbufsize");
}

/*

  -  

*/

pplvar *ppl_F_PPLBUFSIZE(pplvar **table)
{
return notImplemented("pplbufsize");
}

/*

  -  

*/

pplvar *ppl_F_KBDFILUSED(pplvar **table)
{
return notImplemented("kbdfilused");
}

/*

  -  

*/

pplvar *ppl_F_LOMSGNUM(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, LoMsgNum(curConf));
return s;
}

/*

  -  

*/

pplvar *ppl_F_HIMSGNUM(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, HiMsgNum(curConf));
return s;
}

/*

  -  

*/

pplvar *ppl_F_DRIVESPACE(pplvar **table)
{
return notImplemented("drivespace");
}

/*

 OUTBYTES 

*/

pplvar *ppl_F_OUTBYTES(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, OutStat());
return s;
}

/*

  -  

*/

pplvar *ppl_F_HICONFNUM(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, nConfs);
return s;
}

/*

 INBYTES 

*/

pplvar *ppl_F_INBYTES(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, InStat());
return s;
}

/*

  -  

*/

pplvar *ppl_F_CRC32(pplvar **table)
{
pplvar *s;
char *str = fppe_Cstr(fppe_toStringVar(table[1])->value);

s = fppe_newvar(1, 0, s->dim);

if (fppe_getValue(table[0]) == 0)
	fppe_setValue(s, crc32str(str));
else
	fppe_setValue(s, crc32file(str));
return s;
}

/*

  -  

*/

pplvar *ppl_F_PCBMAC(pplvar **table)
{
int g,h,i,f,a=0,varOk=0;
char *str = fppe_Cstr(fppe_toStringVar(table[0])->value);
char var[81]="";
pplvar *s;
char *j, *k;
char sep;

s = fppe_newvar(7,0,s->dim);

for (h=0;h<MAXPCBVAR;h++)
    {
    sep = str[a+1+strlen(pcbVar[h])];
    if (!strncmp(&str[a+1], pcbVar[h], strlen(pcbVar[h])) && (sep == ':' || sep == 0 || sep == '='))
        {
        i = 0;
        f = strlen(pcbVar[h]);
        if ((&str[a+1])[f] == ':')
            {
            g = strtol(&(&str[a+1])[f+1], &j, 10);
            switch (*j)
                {
                case '@':
                    break;
                case 'C':
                    i = 1;
                    j++;
                    break;
                case 'R':
                    i = 2;
                    j++;
                    break;
                case 'L':
                    i = 0;
                    j++;
                    break;
                default:
                    break;
                }
            }
	        else
                {
    	        j = &(&str[a+1])[f];
                g = 0;
                }
        *var=0;
        if (*j == '=')
			{
			k = strchr(j, '@');
            if (k)
            	j = k;
			}
        if (*j == '@')
            {
            replacePcbVar(var, h, g, i, &str[a+1]);
            varOk=1;
            break;
            }
        }
    }

if (!varOk)
	strcpy(var, str);

fppe_strcpy(s, var);
return s;
}

/*

  -  

*/

pplvar *ppl_F_ACTMSGNUM(pplvar **table)
{
return notImplemented("actmsgnum");
}

/*

  -  

*/

pplvar *ppl_F_STACKLEFT(pplvar **table)
{
return notImplemented("stackleft");
}

/*

  -  

*/

pplvar *ppl_F_STACKERR(pplvar **table)
{
return notImplemented("stackerr");
}

/*

  -  

*/

pplvar *ppl_F_DGETALIAS(pplvar **table)
{
return &emptyVar;
//return notImplemented("dgetalias");
}

/*

  -  

*/

pplvar *ppl_F_DBOF(pplvar **table)
{
return &zeroVar;
//return notImplemented("dbof");
}

/*

  -  

*/

pplvar *ppl_F_DCHANGED(pplvar **table)
{
return &zeroVar;
//return notImplemented("dchanged");
}

/*

  -  

*/

pplvar *ppl_F_DDECIMALS(pplvar **table)
{
return &zeroVar;
//return notImplemented("ddecimals");
}

/*

  -  

*/

pplvar *ppl_F_DDELETED(pplvar **table)
{
return &zeroVar;
//return notImplemented("ddeleted");
}

/*

  -  

*/

pplvar *ppl_F_DEOF(pplvar **table)
{
return &zeroVar;
//return notImplemented("deof");
}

/*

  -  

*/

pplvar *ppl_F_DERR(pplvar **table)
{
return &zeroVar;
//return notImplemented("derr");
}

/*

  -  

*/

pplvar *ppl_F_DFIELDS(pplvar **table)
{
return &zeroVar;
//return notImplemented("dfields");
}

/*

  -  

*/

pplvar *ppl_F_DLENGTH(pplvar **table)
{
return &zeroVar;
//return notImplemented("dlength");
}

/*

  -  

*/

pplvar *ppl_F_DNAME(pplvar **table)
{
return &emptyVar;
//return notImplemented("dname");
}

/*

  -  

*/

pplvar *ppl_F_DRECCOUNT(pplvar **table)
{
return &zeroVar;
//return notImplemented("dreccount");
}

/*

  -  

*/

pplvar *ppl_F_DRECNO(pplvar **table)
{
return &zeroVar;
//return notImplemented("drecno");
}

/*

  -  

*/

pplvar *ppl_F_DTYPE(pplvar **table)
{
return &emptyVar;
//return notImplemented("dtype");
}

/*

  -  

*/

pplvar *ppl_F_FNEXT(pplvar **table)
{
return &zeroVar;
//return notImplemented("fnext");
}

/*

  -  

*/

pplvar *ppl_F_DNEXT(pplvar **table)
{
return &zeroVar;
//return notImplemented("dnext");
}

/*

  -  

*/

pplvar *ppl_F_TODDATE(pplvar **table)
{
pplvar *s = fppe_newvar(0x11, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DCLOSEALL(pplvar **table)
{
return &zeroVar;
//return notImplemented("dcloseall");
}

/*

  -  

*/

pplvar *ppl_F_DOPEN(pplvar **table)
{
fppe_runtimeError("dBase functions not supported");
return &zeroVar;
//return notImplemented("dopen");
}

/*

  -  

*/

pplvar *ppl_F_DCLOSE(pplvar **table)
{
return &zeroVar;
//return notImplemented("dclose");
}

/*

  -  

*/

pplvar *ppl_F_DSETALIAS(pplvar **table)
{
return &zeroVar;
//return notImplemented("dsetalias");
}

/*

  -  

*/

pplvar *ppl_F_DPACK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dpack");
}

/*

  -  

*/

pplvar *ppl_F_DLOCKF(pplvar **table)
{
return &zeroVar;
//return notImplemented("dlockf");
}

/*

  -  

*/

pplvar *ppl_F_DLOCK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dlock");
}

/*

  -  

*/

pplvar *ppl_F_DLOCKR(pplvar **table)
{
return &zeroVar;
//return notImplemented("dlockr");
}

/*

  -  

*/

pplvar *ppl_F_DUNLOCK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dunlock");
}

/*

  -  

*/

pplvar *ppl_F_DNOPEN(pplvar **table)
{
fppe_runtimeError("dBase functions not supported");
return &zeroVar;
//return notImplemented("dnopen");
}

/*

  -  

*/

pplvar *ppl_F_DNCLOSE(pplvar **table)
{
return &zeroVar;
//return notImplemented("dnclose");
}

/*

  -  

*/

pplvar *ppl_F_DNCLOSEALL(pplvar **table)
{
return &zeroVar;
//return notImplemented("dncloseall");
}

/*

  -  

*/

pplvar *ppl_F_DNEW(pplvar **table)
{
return &zeroVar;
//return notImplemented("dnew");
}

/*

  -  

*/

pplvar *ppl_F_DADD(pplvar **table)
{
return &zeroVar;
//return notImplemented("dadd");
}

/*

  -  

*/

pplvar *ppl_F_DAPPEND(pplvar **table)
{
return &zeroVar;
//return notImplemented("dappend");
}

/*

  -  

*/

pplvar *ppl_F_DTOP(pplvar **table)
{
return &zeroVar;
//return notImplemented("dtop");
}

/*

  -  

*/

pplvar *ppl_F_DGO(pplvar **table)
{
return &zeroVar;
//return notImplemented("dgo");
}

/*

  -  

*/

pplvar *ppl_F_DBOTTOM(pplvar **table)
{
return &zeroVar;
//return notImplemented("dbottom");
}

/*

  -  

*/

pplvar *ppl_F_DSKIP(pplvar **table)
{
return &zeroVar;
//return notImplemented("dskip");
}

/*

  -  

*/

pplvar *ppl_F_DBLANK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dblank");
}

/*

  -  

*/

pplvar *ppl_F_DDELETE(pplvar **table)
{
return &zeroVar;
//return notImplemented("ddelete");
}

/*

  -  

*/

pplvar *ppl_F_DRECALL(pplvar **table)
{
return &zeroVar;
//return notImplemented("drecall");
}

/*

  -  

*/

pplvar *ppl_F_DTAG(pplvar **table)
{
return &zeroVar;
//return notImplemented("dtag");
}

/*

  -  

*/

pplvar *ppl_F_DSEEK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dseek");
}

/*

  -  

*/

pplvar *ppl_F_DFBLANK(pplvar **table)
{
return &zeroVar;
//return notImplemented("dfblank");
}

/*

  -  

*/

pplvar *ppl_F_DGET(pplvar **table)
{
return &emptyVar;
//return notImplemented("dget");
}

/*

  -  

*/

pplvar *ppl_F_DPUT(pplvar **table)
{
return &zeroVar;
//return notImplemented("dput");
}

/*

  -  

*/

pplvar *ppl_F_DFCOPY(pplvar **table)
{
return &zeroVar;
//return notImplemented("dfcopy");
}

/*

  -  

*/

pplvar *ppl_F_DSELECT(pplvar **table)
{
return &zeroVar;
//return notImplemented("dselect");
}

/*

  -  

*/

pplvar *ppl_F_DCHKSTAT(pplvar **table)
{
return &zeroVar;
//return notImplemented("dchkstat");
}

/*

  -  

*/

pplvar *ppl_F_PCBACCOUNT(pplvar **table)
{
return notImplemented("pcbaccount");
}

/*

  -  

*/

pplvar *ppl_F_PCBACCSTAT(pplvar **table)
{
return notImplemented("pcbaccstat");
}

/*

  -  

*/

pplvar *ppl_F_DERRMSG(pplvar **table)
{
return &emptyVar;
//return notImplemented("derrmsg");
}

/*

  -  

*/

pplvar *ppl_F_ACCOUNT(pplvar **table)
{
return notImplemented("account");
}

/*

  -  

*/

pplvar *ppl_F_SCANMSGHDR(pplvar **table)
{
return notImplemented("scanmsghdr");
}

/*

  -  

*/

pplvar *ppl_F_CHECKRIP(pplvar **table)
{
return notImplemented("checkrip");
}

/*

  -  

*/

pplvar *ppl_F_RIPVER(pplvar **table)
{
return notImplemented("ripver");
}

/*

  -  

*/

pplvar *ppl_F_QWKLIMITS(pplvar **table)
{
return notImplemented("qwklimts");
}

/*

  -  

*/

pplvar *ppl_F_FINDFIRST(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);

if (findfirst(fppe_Cstr(fppe_toStringVar(table[0])->value),&ppl_ffblk, FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH | FA_LABEL | FA_DIREC))
	return s;
fppe_strcpy(s, ppl_ffblk.ff_name);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FINDNEXT(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
if (findnext(&ppl_ffblk))
	return s;
fppe_strcpy(s, ppl_ffblk.ff_name);
return s;
}

/*

  -  

*/

pplvar *ppl_F_USELMRS(pplvar **table) // always return true
{
pplvar *s;
s = fppe_newvar(0, 0, s->dim);
fppe_setValue(s, 1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFINFO(pplvar **table)
{
return notImplemented("confinfo");
}

/*

  -  

*/

pplvar *ppl_F_TINKEY(pplvar **table) // input with a timeout delay
{
pplvar *s;
long timetogo;
long t = fppe_getValue(table[0]);

s = fppe_newvar(7, 0, s->dim);

if (t) // if 0 specified then 4 hours timeout
	timetogo = clock() + t;
else
	timetogo = clock() + 262080;

tmpStr[0]=0;

while (*tmpStr == 0 && clock() < timetogo)
	getKey(tmpStr, MASK_BOTH);

fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CWD(pplvar **table)
{
char buffer[MAXPATH];
pplvar *s = fppe_newvar(7, 0, s->dim);

getcwd(buffer, MAXPATH);
fppe_strcpy(s, buffer);
return s;
}

/*

  -  

*/

pplvar *ppl_F_INSTRR(pplvar **table)
{
char c,a;
pplvar *s;
char *p1, *p2;
c = *fppe_Cstr(fppe_toStringVar(table[1])->value);

s = fppe_newvar(4, 0, s->dim);
p2 = fppe_Cstr(fppe_toStringVar(table[1])->value);
p1 = (char *)strrstr(fppe_Cstr(fppe_toStringVar(table[0])->value), p2);
if (p1 == NULL || c == 0)
	a = 0;
else
	a = (p1 - p2) + 1;

fppe_setValue(s, a);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FDORDAKA(pplvar **table)
{
return &zeroVar;
//return notImplemented("fdordaka");
}

/*

  -  

*/

pplvar *ppl_F_FDORDORG(pplvar **table)
{
return &zeroVar;
//return notImplemented("fdordorg");
}

/*

  -  

*/

pplvar *ppl_F_FDORDAREA(pplvar **table)
{
return &zeroVar;
//return notImplemented("fdordarea");
}

/*

  -  

*/

pplvar *ppl_F_FDOQRD(pplvar **table)
{
return &zeroVar;
//return notImplemented("fdoqrd");
}

/*

  -  

*/

pplvar *ppl_F_GETDRIVE(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, getdisk());
return s;
}

/*

  -  

*/

pplvar *ppl_F_SETDRIVE(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, setdisk(fppe_getValue(table[0])));
return s;
}

/*

  -  

*/

pplvar *ppl_F_BS2I(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, BsReal2Long(*(unsigned long*)table[0]->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_BD2I(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, (unsigned long)BdReal2Double(table[0]->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_I2BS(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, Long2BsReal(*(unsigned long*)table[0]->value));
return s;
}

/*

  -  

*/

pplvar *ppl_F_I2BD(pplvar **table)
{
bdreal a;
pplvar *s = fppe_newvar(0xE, 0, s->dim);

Double2BdReal(a, *(double *)table[0]->value);
memcpy(s->value, a, 8);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FTELL(pplvar **table)
{
int f = fppe_getValue(table[0]);
pplvar *s = fppe_newvar(4, 0, s->dim);

if (fileHandle[f+1]!=NULL)
	fppe_setValue(s, ftell(fileHandle[f+1]));

return s;
}

/*

  -  

*/

pplvar *ppl_F_OS(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, 1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_void(pplvar **table)
{
}

/*

  -  

*/

pplvar *pplRegVar(int n)
{
pplvar *s;
unsigned int v;

s = fppe_newvar(4, 0, s->dim);
switch (n)
	{
    case 0:
    	v = ppeREGS.r_ax & 0xFF;
        break;
    case 1:
    	v = (ppeREGS.r_ax & 0xFF00) >> 8;
        break;
    case 2:
    	v = ppeREGS.r_bx & 0xFF;
        break;
    case 3:
    	v = (ppeREGS.r_bx & 0xFF00) >> 8;
        break;
    case 4:
    	v = ppeREGS.r_cx & 0xFF;
        break;
    case 5:
    	v = (ppeREGS.r_cx & 0xFF00) >> 8;
        break;
    case 6:
    	v = ppeREGS.r_dx & 0xFF;
        break;
    case 7:
    	v = (ppeREGS.r_dx & 0xFF00) >> 8;
        break;
    case 8:
    	v = ppeREGS.r_ax;
        break;
    case 9:
    	v = ppeREGS.r_bx;
        break;
    case 10:
    	v = ppeREGS.r_cx;
        break;
    case 11:
    	v = ppeREGS.r_dx;
        break;
    case 12:
    	v = ppeREGS.r_si;
        break;
    case 13:
    	v = ppeREGS.r_di;
        break;
    case 14:
    	v = ppeREGS.r_flags;
        break;
    case 15:
    	v = ppeREGS.r_flags & 1;
        break;
    case 16:
    	v = ppeREGS.r_ds & 1;
        break;
    case 17:
    	v = ppeREGS.r_es & 1;
        break;
    }
fppe_setValue(s, v);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DSCRTEXT(pplvar **table)
{
pplvar *s;
int col, lig, len, code;

if (!debugScreen)
	return &emptyVar;

s = fppe_newvar(0x7, 0, s->dim);
col = fppe_getValue(table[0]);
lig = fppe_getValue(table[1]);
len = fppe_getValue(table[2]);
code = fppe_getValue(table[3]);

tmpStr[0]=0;
scrtext(tmpStr, col, lig, len, code);
fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DGETX(pplvar **table)
{
pplvar *s;

if (!debugScreen)
	return &zeroVar;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, debug_x+1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DGETY(pplvar **table)
{
pplvar *s;

if (!debugScreen)
	return &zeroVar;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, debug_y+1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_DUALSCR(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, debugScreen);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CONFNAME(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7,0,s->dim);

sprintf(tmpStr, "Conf%d",(int) fppe_getValue(table[0]));
//fppe_extendString(s, 80);
getProfileString(tmpStr, "Name", "", tmpStr2, 79, iniFile);
fppe_strcpy(s, tmpStr2);
return s;
}

/*

  -  

*/

pplvar *ppl_F_SYSTEMPATH(pplvar **table)
{
pplvar *s;

s = fppe_newvar(7, 0, s->dim);

/*fnsplit(systemPPEPath, tmpDrive, tmpDir, NULL, NULL);
if (tmpDrive[0]==0)
	sprintf(tmpDrive, "%c:", getdisk() + 'A');
if (tmpDir[0] == 0)
	{
    tmpDir[0] = '\\';
    tmpDir[1] = 0;
	getcurdir(0, &tmpDir[1]);
    }*/

//fnmerge(tmpStr, tmpDrive, tmpDir, NULL, NULL);
//fppe_strcpy(s, tmpStr);
fppe_strcpy(s, systemPPEPath);
return s;
}

/*

  -  

*/

pplvar *ppl_F_BETA(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, FRONTIER_BETA == 0 ? 0 : 1);
return s;
}

/*

  -  

*/

pplvar *ppl_F_SCREENCLEARED(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, screenCleared);
return s;
}

/*

  -  

*/

pplvar *ppl_F_CALL(pplvar **table)
{
pplvar *s;
char *p, *q;
int pos;

p = fppe_Cstr(fppe_toStringVar(table[0])->value); // Command line

q = strchr(p, ' '); // Are there arguments ?
if (q != NULL)
	{
    pos = q - p;
    p[pos] = 0; // separate ppe & args
    strcpy(tmpStr, q+1);
    tokenize(tmpStr, tokenStr); // tokenize args
    }
fppe_runPPE(fppe_Cstr(fppe_toStringVar(table[0])->value)); // run ppe
s = fppe_newvar(7,0,s->dim);
fppe_assignVar(s, &ppeReturnValue);
return s;
}

/*

  -  

*/

pplvar *ppl_F_LASTEXITVALUE(pplvar **table)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_assignVar(s, &ppeReturnValue);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FREE(pplvar **table)
{
pplvar *s;
s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, farcoreleft());
return s;
}

/*

  -  

*/

pplvar *ppl_F_COMINIT(pplvar **table)
{
pplvar *s = fppe_newvar(0, 0, s->dim);
fppe_setValue(s, comInit());
return s;
}

/*

  -  

*/

pplvar *ppl_F_GETCOMSTAT(pplvar **table)
{
long a;
pplvar *s = fppe_newvar(4, 0, s->dim);
a = rs_modctrl(RS_GETMCR) + rs_modctrl(RS_GETMSR) << 8;
fppe_setValue(s, a);
return s;
}

/*

  -  

*/

pplvar *ppl_F_GETUARTTYPE(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);
fppe_setValue(s, (long)initCode);
return s;
}

/*

  -  

*/

pplvar *ppl_F_GETPROFILE(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
char *s2 = fppe_Cstr(fppe_toStringVar(table[0])->value);
char *e = fppe_Cstr(fppe_toStringVar(table[1])->value);
char *f = fppe_Cstr(fppe_toStringVar(table[2])->value);

getProfileString( s2, e, "", tmpStr, 255, f );

fppe_strcpy(s, tmpStr);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FRTDAT(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, iniFile);
return s;
}

/*

  -  

*/

pplvar *ppl_F_FILEMATCH(pplvar **table)
{
int a, extok=0, exts=0, bases=0;
char *p = fppe_Cstr(fppe_toStringVar(table[0])->value);
pplvar *s = fppe_newvar(0, 0, s->dim);

for (a=strlen(p)-1;a>=0;a--)
	{
    if (!extok && p[a] == '.') { extok=1; exts = strlen(p)-a; }
    if (p[a] == '\\') break;
	}
bases = strlen(p) - a - exts - 1;

if (bases > 8 || exts > 4) { fppe_setValue(s, 0); return s; }
fppe_setValue(s, fnmatch(fppe_Cstr(fppe_toStringVar(table[1])->value), p, __FNM_FLAGS) == 0 ? 1 : 0);
return s;
}

/*

  -  

*/

pplvar *ppl_F_GETNEXTMSG(pplvar **table)
{
pplvar *s = fppe_newvar(4, 0, s->dim);

char *from, *to, *subject, *text, *toalias, *fromalias;
long fromdate;
int conf, inc, seeall;
long start;

conf = fppe_getValue(table[0]);
start = fppe_getValue(table[1]);
inc = fppe_getValue(table[2]);
from = fppe_Cstr(fppe_toStringVar(table[3])->value);
fromalias = fppe_Cstr(fppe_toStringVar(table[4])->value);
to = fppe_Cstr(fppe_toStringVar(table[5])->value);
toalias = fppe_Cstr(fppe_toStringVar(table[6])->value);
subject = fppe_Cstr(fppe_toStringVar(table[7])->value);
text = fppe_Cstr(fppe_toStringVar(table[8])->value);
fromdate = fppe_getValue(table[9]);
seeall = fppe_getValue(table[10]);
fppe_setValue(s, getNextMsg(conf, start, inc, from, fromalias, to, toalias, subject, text, fromdate, seeall));

return s;
}

/*

  -  

*/

pplvar *ppl_F_HIMSGNUMC(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, HiMsgNum(fppe_getValue(table[0])));
return s;
}

/*

  -  

*/

pplvar *ppl_F_LOMSGNUMC(pplvar **table)
{
pplvar *s;

s = fppe_newvar(4,0,s->dim);
fppe_setValue(s, LoMsgNum(fppe_getValue(table[0])));
return s;
}

/*

  -  

*/

pplvar *ppl_F_ROOTPATH(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);
fppe_strcpy(s, systemPath);
return s;
}

/*

  -  

*/

pplvar *ppl_F_TOSDATE(pplvar **table)
{
pplvar *s = fppe_newvar(0x21, 0, s->dim);
fppe_assignVar(s, table[0]);
return s;
}

/*

  -  

*/

pplvar *ppl_F_LANGFILE(pplvar **table)
{
pplvar *s = fppe_newvar(7, 0, s->dim);

strcpy(tmpStr, systemPath);
if (systemPath[strlen(systemPath)-1] != '\\')
	strcat(tmpStr, "\\");
strcat(tmpStr, "LANGUAGE");
strcat(tmpStr, langExt);
fppe_strcpy(s, tmpStr);
return s;
}

pplvar *mask_money(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
strcpy(tmpStr, "0123456789XX");
tmpStr[10] = currency;
tmpStr[11] = dot;
fppe_strcpy(s, tmpStr);
return s;
}

pplvar *mask_date(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "0123456789/");
return s;
}

pplvar *mask_time(void)
{
pplvar *s;
s = fppe_newvar(7,0,s->dim);
fppe_strcpy(s, "0123456789:");
return s;
}

#pragma warn .par
