/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef __SYSTEM_H
#define __SYSTEM_H

#include <dir.h>
#include <stdio.h>
#include <dos.h>
#include <time.h>
#include "..\lang\ppl_type.h"
#include "..\com\mbfieee.h"

typedef unsigned char bool;

typedef struct {
	char FullName[25];
    char City[24];
    char Password[12];
    char DataPhone[13];
    char VoicePhone[13];
    char LastDateOn[6];
    char LastTimeOn[5];
    bool Expert;
    unsigned char Protocol;
    char FlagsBitmap;
    char LastDir[6];
    unsigned char Security;
    unsigned int TimesOn;
    unsigned char PageLen;
    unsigned int FilesUploaded;
    unsigned int FilesDownloaded;
    bdreal BytesDownloadedToday;
    char Comment1[30];
    char Comment2[30];
    unsigned int TimeOn;
    char RegExpDate[6];
    unsigned char ExpSecurity;
    unsigned char Compatibility1;
    char ConfRegBitmap[5];
    char ExpConfBitmap[5];
    char SelConfBitmap[5];
    bdreal BytesDownloaded;
    bdreal BytesUploaded;
    unsigned char DeletedFlag;
    bsreal LastMsgRd[40];
    unsigned long RecNum;
    char Flags2Bitmap;
    char Reserved8[8];
    unsigned int LastConfIn;
    bool DirtyFlag;
    bool ClearScreen;
    bool MailFlag;
    bool NoAskFSEditor;
    bool FSEditor;
    bool ScrollMsgBody;
    bool ShortMsgHdr;
    bool WideEditor;
    bool ChatStatus;
    bool Reserved1;
    bool Reserved2;
    bool Reserved3;
    bool Reserved4;
    bool Reserved5;
    bool Reserved6;
    bool Reserved7;
	long Index;
	} userType;

#ifdef __cplusplus
extern "C" {
#endif

	void lineCounter(void);
	int  isHex(char c);
	void output(char *str, int to);
	int  isoStyle(unsigned char c);
	int  isoColor(unsigned char c);
	int  isoFore(unsigned char c);
	int  isoBack(unsigned char c);
	int  isoBlink(unsigned char c);
	void dispfile(char *file);
	pplvar *notImplemented(char *symb);
    void output(char *str, int to);
	pplvar *pplGetKey(int);
	void getKey(char *str, int from);
	int  isSigned(pplvar *s);
    void chat(void);
	void cls(void);
    void localCls(void);
    void remoteCls(void);
	void clrEol(void);
    void pause(void);
    void who(void);
    void ansiPos(int c, int l);
	void print(char *str);
	void print_saved(char *str);
	void scrtext(char *s, int col, int lig, int len, int code);
	void rtrim(char *s);
	void savescrn(void);
	void restscrn(void);
	void color(int c);
    void wait(void);
	void waitEnter(void);
	void readString(char *s, int max, FILE *f);
	bool readBool(FILE *f);
	long readLong(FILE *f);
	long readLongHex(FILE *f);
	void getUser(int userNum, userType *u);
	void getStr(char *s, size_t size, size_t n, FILE *f);
	int  userRecNr(char *u);
	unsigned long sysCharDateToPPLDate(char *d);
	unsigned long charDateToPPLDate(char *d, int forceEnglish);
	unsigned long charTimeToPPLTime(char *d);
	unsigned long charDDateToPPLDate(char *d);
	void PPLDateToSysCharDate(char *chardate, unsigned long ppldate);
	void PPLDateToCharDate(char *chardate, unsigned long ppldate, int forceEnglish);
	int  dayPart(void);
	int  monthPart(void);
	int  yearPart(void);
	int  militaryTime(void);
	int  inRange(unsigned long value, unsigned long min, unsigned long max);
	void UnixToDos(unsigned long DateVal, struct date *d, struct time *t);
	long DosToUnix(struct date *d, struct time *t);
	char boolean(char val);
	void tokenize(char *s, char *dest);
	void Ctokenize(char *s, char c, char *dest);
	void getToken(char *s, char *src);
	int  tokCount(char *src);
	void strcrpl(char *s, char a, char b);
	void strcsup(char *s, char a);
	void strsrpl(char *s, char *a, char *b);
	char *strnzcpy(char *a, char *b, int n);
	void more(void);
	void bye(void);
	void hangup(void);
	void goodbye(void);
	void inputText(char *s, char *allowed, int len);
	void ShiftKey1(void);
	void ShiftKey2(void);
	void ShiftKey3(void);
	void ShiftKey4(void);
	void ShiftKey5(void);
	void ShiftKey6(void);
	void ShiftKey7(void);
	void ShiftKey8(void);
	void ShiftKey9(void);
	void ShiftKey10(void);
	void ShiftKey11(void);
	void ShiftKey12(void);
//	void shell(void);
    void shellKey(void);
	int  runSystemPPE(char *ppename);
	void internal_chat(void);
	void lang(void);
	void closeAnsiColor(void);
	void sendAnsiColor(int colorCode);
	void scroll(void);
	void checkHotkeys(void);
	void updateStatusBar(void);
	int  puts_blind(char *c);
	int puts_blindn(char *c, int max);
	void join(int confNum);
	void loadConf(int confNum);
	void readCMDlst(int confNum);
	void registerCommand(char *keystrokes, char *command, int minlevel);
	void invalidCommands(void);
	void execCommand(char *command);
	int  strcmpicount(char *s1, char *s2);
	void debugAllocation(size_t size, char *file, int line);
	void debugAllocation2(void);
	void getMessageBase(int confNum, char *confpath);
	void loadConfData(char *confpath);
	void kbdFlush(void);
	void addUser(char *userName);
	int addUserRecNr(char *u, int userNum);
	int invalidUserRecNr(char *u);
	void makeSpaceString(char *dest, char*src, int size, int maj);
	void mapFlags(userType *u);
	void setConfFlags(int conf, unsigned char flags, int u);
	unsigned char confFlags(unsigned int conf);
	void setLmr(long confNum, long msgNum, long u);
	long HiMsgNum(long confNum);
	long LoMsgNum(long confNum);
	long getLmr(long confNum, long u);
	void backup(int n);
	void forward(int n);
	char *strrstr(char *s1, char *s2);
	char *strnchr(char *str, char c, int len);
	void suspendCom(void);
	void restoreCom(void);
    int connected(void);
    void dispOn(void);
    void dispOff(void);
	char *stristr(char *s1, char *s2);
	void getExistingDisplayFile(char *dest, char *base, int flag);
	int psa(int v);

#ifdef __cplusplus
}
#endif

extern char far thisConfPath[];
extern char far iniFile[];
extern char far scrbuf[23][400];
extern char far tmpStr[];
extern char far tmpStr2[];
extern int curColor;
extern int CFcount;
extern char far tmpFile[MAXPATH];
extern char far tmpDrive[MAXDRIVE];
extern char far tmpDir[MAXDIR];
extern char far tmpExt[MAXEXT];
extern char kbdString[];
extern long carrierSpeed;
extern char emptyStr[];
extern char *connectString;
extern char linesCounting;
extern char col[];
extern int currentUserNum;
extern int userLoggedNum;
extern int globalNoDisplay;
extern int pageFlag;
extern char langExt[];
extern char far systemPath[];
extern char far tokenStr[];
extern char yes, no, currency, dot;
extern int validDate, validTime;
extern int abortScroll;
extern int curConf;
extern int totalUsers;
extern long nConfs;
extern int screenCleared;
extern char wrap[];
extern int maxnode;
extern int errorcorrect;
extern pplvar ppeReturnValue;
extern int cmdError;
extern userType user;
extern int far macrosInterpretation;
extern int debugScreen;
extern char far nodeFilename[];
extern FILE *logFile;
typedef struct {
	char *command;
	char *keystroke;
	int  level;
	} CMDlstEntry;

extern CMDlstEntry far CMD[512];
extern int nCMDlist;
extern int far CDchecking;
extern volatile long lastKey;
extern char grafMode;
extern char far pageText[51];
extern char far userAlias[];
extern int far sc_day, sc_month, sc_year;
extern int screenState;
extern int printerState;
extern int pagebellState;
extern int callerAlarmState;
extern char sysopFlag;
extern int userMinsAllowed;
extern int userKbAllowed;
extern int eventOn;
extern int langNum;
extern int userTimeLeft;
extern int userTimeLog;
extern long userDateLog;
extern int userMinsOn;

#define MASK_SYSOP 1
#define MASK_USER 2
#define MASK_BOTH 3

#define DISP_GRAPH 	1
#define DISP_SEC 	2
#define DISP_LANG 	4

#ifndef DEBUG
#define KBISR
#define BREAKHANDLER
#endif

#endif
