/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Share-aware file opening

*/

#include <stdio.h>
#include <time.h>

#include "..\com\sharing.h"
#include "..\lang\ppl.h"
#include "..\com\pcbdat.h"

FILE *fopen_share(char *filename, char *mode, int shflg)
{
FILE *a=NULL;
int firstPart=0;
clock_t lastWarn=0, start;
int b;

b = linesCounting;
linesCounting = 0;
start = clock();
lastWarn = clock() + 18;

while (a == NULL)
	{
	a = _fsopen(filename, mode, shflg);

	if (a == NULL)
		{
        if (!access(filename,0))
        	{
			if (clock() > lastWarn + 18)
	            {
				if (!firstPart)
                	{
                    sprintf(tmpStr2,"@X0CNetwork delay (%s), Please wait...", filename);
    	        	print(tmpStr2);
                    firstPart=1;
                    }
                else
                	print(".");
                lastWarn = clock();
                }
            if (clock() > start + networkTimeoutError * 18)
            	{
				fppe_runtimeError("Network sharing violation attempt");
                firstPart=0;
                break;
                }
			}
        else
        	{
		    sprintf(tmpStr2, "Open file failure: \"%s\"", filename);
		    fppe_runtimeError(tmpStr2);
            linesCounting = b;
			return NULL;
		    }
        }
    }

if (firstPart)
	print("\n");

linesCounting = b;
return a;
}


