{$M 65500,0,655360}

UNIT OverInit;
INTERFACE
USES Overlay,
     ConfigRT,
     GenTypes;

IMPLEMENTATION

{=============================================================================}

{=============================================================================}

VAR Save_exit : POINTER;

{$F+}
Procedure Error_handler;
VAR Error_str : String[80];
Begin
  ExitProc := Save_exit;
  If ExitCode = e_Extended_code  THEN
    Begin
      Case Ext_code OF
        -1 : Writeln(USR,'Overlay manager error');
        -2 : Begin
              Writeln(USR,'Overlay file not found');
             End;
         1 : Begin
               writeln (USR,'The modem driver is not installed!  Please run the',
                        'program'^M^J^M^J'    MODEMDRV.COM'^M^J^M^J,
                        'and run Forum-PC again.');
               ExitCode := 2;
             End;
         2 : Begin
               writeln (USR,^M^J'Fatal error:  You MUST put the command',
               ^M^J^J'   FILES=30',
               ^M^J^J'in your CONFIG.SYS file on the disk from which you boot.',
               ^M^J^J'Note:  If you have been modifying Forum-PC, then you may',
                ^M^J'       be leaving a file open.');;
             End;
        End;
    End;
End;

{=============================================================================}

VAR Overlay_buffer : LONGINT;

Begin
  Move(Output,USR,Sizeof(text));
  Save_exit := ExitProc;
  ExitProc := @Error_handler;
  Writeln(USR,Versionnum,' (C) Copyright 1989, Kenneth Duda.'^M^J,
              '                Portions by Kevin Boyles.');
  ReadConfig;

  Ext_code := 0;
  OvrInit(OverlayPath+'Forum.OVR');          { init overlay system, reserve heap space }
  IF OvrResult <> 0 THEN
  Begin
    Ext_code := OvrResult;
    Halt(e_Extended_code);
  End;
  OvrInitEMS;
  If OvrResult = 0 THEN
    Writeln(USR,'Overlay loaded into Expanded Memory.')
  ELSE
    Writeln(USR,'No expanded memory available.');
  OvrResult := 0;
  Overlay_buffer := Longint(OVerlay_size)*1024;
  If (Overlay_size > 0) AND (Overlay_size < 640)  THEN
   Begin
    Writeln(USR,'Setting overlay buffer size to ',Overlay_size,'k');
    OvrSetBuf(Overlay_buffer)
   End
  ELSE
    If Overlay_size = 1000 THEN
      Begin
        Writeln(USR,'Using all available memory for overlay buffer');
        OvrSetBuf(MemAvail);
      End
    ELSE
      Writeln(USR,'Using default buffer size.');
  Writeln(USR,'Memory: ',Memavail);
  Writeln(USR,'Overlay code: ',OvrResult);
  Writeln(USR,'FORUM-PC Overlay buffer size: ',OvrGetBuf);
End.