{$R-,S-,I-,D-,V-,B-,N-,L- }
{$O+}

unit configur;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

interface

uses gentypes,userret,gensubs,subs1,subs2,flags;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

Procedure configure;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

implementation

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

Procedure configure;

const colorstr:array [0..7] of string[7]=
        ('Black','Blue','Green','Cyan','Red','Magenta','Brown','White');

Procedure options (c:configtype; VAR prompt,onstr,offstr:lstr);

  Procedure ret (x1,x2,x3:lstr);
  begin
    prompt:=x1;
    onstr:=x2;
    offstr:=x3
  end;

begin
  case c of
    linefeeds     : ret('Require line feeds','Yes','No');
    eightycols    : ret('Screen width','80 columns','40 columns');
    postprompts   : ret('Post prompts during newscan','Yes','No');
    moreprompts   : ret('Pause every screen','Yes','No');
    asciigraphics : ret('Use IBM graphics characters','Yes','No');
    showtime      : ret('Display time left at prompts','Yes','No');
    lowercase     : ret('Upper/lower case','Upper or lower case','Upper case only');
    fseditor      : ret('Use full-screen editor','Yes','No');
    ExtClrScr     : Ret('Clear screen between posts (extended newscan)',
                        'Yes','No');
  End
End;

Function getattrib (fg,bk:integer; hi,bl:boolean):byte;
begin
  getattrib:=fg+(byte(hi) shl 3)+(bk shl 4)+(byte(bl) shl 7)
end;

Procedure getcolorvar (attr:byte; VAR fg,bk:integer; VAR hi,bl:boolean);
begin
  fg:=attr and 7;
  hi:=(attr and 8)=8;
  bk:=(attr shr 4) and 7;
  bl:=(attr and 128)=128
end;

Procedure getthing (c:configtype);
VAR n:integer;
    name,onstr,offstr:lstr;
begin
  options (c,name,onstr,offstr);
  writehdr (name);
  write ('Current setting: '^S);
  if c in urec.config then write (onstr) else write (offstr);
  writeln (^B^M^M'Would you like:');
  writeln ('  1. ',onstr);
  writeln ('  2. ',offstr);
  writestr (^M'Your choice:');
  n:=valu(input);
  if (n>0) and (n<3) then begin
    if n=2
      then urec.config:=urec.config-[c]
      else urec.config:=urec.config+[c];
    writeurec
  end
end;

Procedure writecolorstr (a:byte);
VAR fg,bk:integer;
    hi,bl:boolean;
begin
  getcolorvar (a,fg,bk,hi,bl);
  ansicolor (a);
  if bl then write ('Blinking ');
  if hi then write ('Highlighted ');
  write (colorstr[fg]);
  if bk>0 then write (' on ',colorstr[bk])
end;

Function colorval (str:mstr):integer;
VAR cnt:integer;
begin
  colorval:=-1;
  if match(str,'None') then begin
    colorval:=0;
    exit
  end;
  for cnt:=0 to 7 do
    if match(str,colorstr[cnt]) then begin
      colorval:=cnt;
      exit
    end
end;

Procedure badcolor;
VAR cnt:integer;
begin
  write ('Invalid color!  Valid colors are Black, ');
  for cnt:=1 to 7 do begin
    ansicolor (cnt);
    write (colorstr[cnt]);
    if cnt=7
      then writeln ('.')
      else write (', ');
    if cnt=6
      then write (', and ');
  end;
  writestr ('')
end;

Procedure getcolor (prompt:mstr; VAR a:byte);

  Procedure getacolor (VAR q:integer; prompt:mstr);
  VAR n:integer;
  begin
    repeat
      writestr ('Enter new '+prompt+' color:');
      if hungupon or (length(input)=0) then exit;
      n:=colorval(input);
      if n=-1
        then badcolor
        else q:=n
    until n<>-1
  end;

VAR fg,bk:integer;
    hi,bl:boolean;
begin
  if not (ansigraphics in urec.config) then begin
    writestr ('You must have ANSI emulation to see color.');
    exit
  end;
  getcolorvar (a,fg,bk,hi,bl);
  write ('Current ',prompt,' color: ');
  writecolorstr (a);
  writestr (^M^M);
  getacolor (fg,'foreground');
  getacolor (bk,'background');
  writestr ('Highlight the characters? *');
  hi:=yes;
  writestr ('Should the characters blink? *');
  bl:=yes;
  a:=getattrib (fg,bk,hi,bl)
end;

Procedure emulation;
begin
  writeln (^B^M'Note:  ANSI is required for color.');
  writeln (    '       VT52 or ANSI is required for the full-screen editor.');
  writeln;
  writeln (^B'Please choose your terminal type.'^M^M,
           '   1. ANSI Color'^M,
           '   2. VT52 Emulation'^M,
           '   3. None'^M);
  writestr ('Emulation type:');
  if length(input)=0 then exit;
  urec.config:=urec.config-[ansigraphics,vt52];
  case valu(input) of
    1:urec.config:=urec.config+[ansigraphics];
    2:urec.config:=urec.config+[vt52]
  end
end;

Procedure Define_editor;
Begin
  writeln (^B^M'Note:  ANSI is required for color.');
  writeln (    '       VT52 or ANSI is required for the full-screen editor.');
  writeln;
  writeln (^B'Please choose your editor type.'^M^M,
           '   1. ANSI Full screen'^M,
           '   2. Standard Line'^M);
  writestr ('Editor type:');
  if length(input)=0 then exit;
  urec.config := urec.config-[Fseditor];
  case valu(input) of
    1 : urec.config := Urec.Config+[fseditor];
    2 : urec.config := Urec.Config-[Fseditor];
  end
end;

Procedure getdisplaylen;
VAR v:integer;
begin
  writeln ('Current display length is: '^S,urec.displaylen);
  writestr (^M'Enter new display length:');
  if length(input)=0 then exit;
  v:=valu(input);
  if (v<21) or (v>43)
    then writeln ('Invalid!')
    else urec.displaylen:=v
end;

Procedure configurenewscan;
VAR bd:boardrec;
    bn:integer;
    ac:accesstype;
begin
  opentempbdfile;
  seek (bdfile,0);
  for bn:=0 to filesize(bdfile)-1 do begin
    read (bdfile,bd);
    ac:=getuseraccflag(urec,bn);
    if (ac=letin) or ((ulvl>=bd.level) and (ac=bylevel)) then begin
      writestr ('Newscan '+bd.boardname+' (now '+
                yesno(not (bn in urec.newscanconfig))+'):');
      if length(input)<>0 then
        if yes
          then urec.newscanconfig:=urec.newscanconfig-[bn]
          else urec.newscanconfig:=urec.newscanconfig+[bn]
    end
  end;
  closetempbdfile
end;

Procedure showit (s,v:lstr);
begin
  if break then exit;
  tab (s+':',30);
  writeln (^S,v)
end;

Procedure showthing (c:configtype);
VAR n:integer;
    name,onstr,offstr:lstr;
begin
  if break then exit;
  options (c,name,onstr,offstr);
  tab (name+':',30);
  write (^S);
  if c in urec.config
    then write (^S,onstr)
    else write (^S,offstr);
  writeln
end;

Procedure showemulation;
VAR q:lstr;
begin
  if ansigraphics in urec.config
    then q:='ANSI Color'
    else if vt52 in urec.config
      then q:='VT52 Emulation'
      else q:='None';
  showit ('Terminal type',q)
end;

Procedure showdisplaylen;
begin
  showit ('Display length',strr(urec.displaylen))
end;

Procedure showcolor (prompt:mstr; attr:byte);
begin
  if break then exit;
  tab ('  '+prompt+' color:',30);
  writecolorstr (attr);
  writeln
end;

Procedure yourstatus;
begin
  writehdr ('Your Configuration');
  showthing (linefeeds);
  showthing (eightycols);
  showthing (postprompts);
  showthing (moreprompts);
  showthing (asciigraphics);
  showthing (showtime);
  showthing (lowercase);
  showemulation;
  showthing (fseditor);
  showdisplaylen;
  if ansigraphics in urec.config then begin
    showcolor ('Prompt',urec.promptcolor);
    showcolor ('Input',urec.inputcolor);
    showcolor ('Regular',urec.regularcolor);
    showcolor ('Statistic',urec.statcolor)
  end
end;

VAR q:integer;
begin
  repeat
    if (not (lowercase in urec.config)) and (ansigraphics in urec.config)
      then begin
        urec.config:=urec.config+[lowercase];
        writestr ('You may not use ANSI in uppercase-only mode.')
      end;
    if (fseditor in urec.config) and
       (urec.config=urec.config-[ansigraphics,vt52])
      then begin
        urec.config := urec.config - [fseditor];
        writestr ('You may not use the full-screen editor without ANSI or VT52 emulation.')
      end;
    q:=menu ('Configuration','CONFIG','QLWOMGTUEDPIRSNYFC');
    case q of
      2  : getthing (linefeeds);
      3  : getthing (eightycols);
      4  : getthing (postprompts);
      5  : getthing (moreprompts);
      6  : getthing (asciigraphics);
      7  : getthing (showtime);
      8  : getthing (lowercase);
      9  : emulation;
      10 : getdisplaylen;
      11 : getcolor ('prompt',urec.promptcolor);
      12 : getcolor ('input',urec.inputcolor);
      13 : getcolor ('regular',urec.regularcolor);
      14 : getcolor ('statistic',urec.statcolor);
      15 : configurenewscan;
      16 : yourstatus;
      17 : Define_Editor;
      18 : GetThing(ExtClrScr);
    end;
    writeurec
  until (q=1) or hungupon
end;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

{initialization}

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

begin
end.
