
{ CODE TO ALLOW INPUT OF STRINGS THAT ARE WIDER THAN THE CRT OR
  THE CURRENT WINDOW.  WILL SCROLL THE WINDOW TO ALLOW CONTINUED INPUT

THIS IS FOR ENTERING LARGE STRINGS IN A SMALLER
SCREEN (DO YOU HAVE A MONITOR THAT'S 255 CHARS WIDE???). IN ANY CASE, I'LL
GIVE IT TO YOU NOW. SO LONG AS YOU MAKE THE VIEWPORT LARGER THAN THE
LENGTH LIMIT OF THE STRING, YOU WILL HAVE NO SCROLLING AND NO PROBLEM. I
WILL SIMPLY HAVE TO FIX THE SCROLLING LATER. MODIFY AS YOU WISH, YOU MAY
FIND IT USEFUL. CRT.TPU IS REQUIRED. }

UNIT STRL;
INTERFACE
USES CRT;
FUNCTION EDSTR(VAR INSTRING;X,Y,VIEWPORT,COLOR,LIMIT:BYTE):BOOLEAN;
IMPLEMENTATION
CONST     KSINS = 128; {INSERT MODE ON}
VAR       KBSHIFT :    BYTE ABSOLUTE $40:$17; {SHIFT KEY STATUS}
FUNCTION GETKEY:WORD;
ASSEMBLER; ASM
 XOR AH,AH
 INT $16
END;
PROCEDURE BEEP(HZ,MS:WORD);
BEGIN
 SOUND(HZ);
 DELAY(MS);
 NOSOUND;
END;
FUNCTION EDSTR(VAR INSTRING;X,Y,VIEWPORT,COLOR,LIMIT:BYTE):BOOLEAN;
VAR
 WMAX,WMIN:WORD;
 SHOWPOS,XMAX,YMAX,EDITPOS,VIEWPOS,OLDX,OLDY,OLDCOLOR:BYTE;
 UPDATE,INSMODE:BOOLEAN;
 EDITSTR:STRING ABSOLUTE INSTRING;
 KEY:RECORD
  CH,SCAN:BYTE;
 END;
BEGIN
  WMAX:=WINDMAX; {STORE WINDOW}
  WMIN:=WINDMIN; {STORE WINDOW}
  OLDCOLOR:=TEXTATTR; {STORE COLOR}
  OLDX:=WHEREX; {STORE CURSOR}
  OLDY:=WHEREY; {STORE CURSOR}
  WINDOW(1,1,80,25);
  WINDOW(1,1,80,50);
  XMAX:=WINDMAX AND 255 + 1;
  YMAX:=WINDMAX SHR 8 + 1;
  {VERIFY VIEWPORT DIMENSIONS}
  IF (Y<=YMAX) AND (X+VIEWPORT-1<=XMAX) AND (VIEWPORT<>0) THEN BEGIN
  EDSTR:=TRUE;
  WINDOW(X,Y,X+VIEWPORT-1,Y); {SET WINDOW}
  TEXTATTR:=COLOR; {SET NEW COLOR}
  VIEWPOS:=1; {INIT VIEW POS}
  EDITPOS:=1; {INIT EDIT POS}
  CLRSCR; {CLEAR WINDOW}
  KBSHIFT:=KBSHIFT OR KSINS; {FORCE INSERT}
  UPDATE:=TRUE;
  IF EDITSTR[0]>CHAR(LIMIT) THEN EDITSTR[0]:=CHAR(LIMIT);
  REPEAT {LOOP UNTIL ENTER PRESSED}
   {UPDATE DISPLAY}
   IF UPDATE THEN BEGIN
    GOTOXY(1,1);
    INC(WINDMAX); {PREVENTS CRT SCROLLING}
    SHOWPOS:=VIEWPOS;
    WHILE (SHOWPOS<=LENGTH(EDITSTR)) AND (SHOWPOS<=VIEWPOS+VIEWPORT-1) DO
    BEGIN
     WRITE(EDITSTR[SHOWPOS]);
     INC(SHOWPOS);
    END;
    DEC(WINDMAX); {RESTORE WINDOW AFTER TEMPORARY ANTI-SCROLL}
    CLREOL;
   END;
   UPDATE:=TRUE;
   GOTOXY((EDITPOS-1) MOD VIEWPORT+1,1); {PROPER CURSOR EDIT POS}
   WORD(KEY):=GETKEY; {GET KEY}
   INSMODE:=KBSHIFT AND KSINS<>0; {CHECK INSERT MODE}
   {IF INSERT THEN FLAT CURSOR ELSE BLOCK CURSOR}
   CASE KEY.CH OF {CHECK KEY CHAR}
    0:CASE KEY.SCAN OF {CHECK KEY SCAN CODE}
     $47:EDITPOS:=1; {HOME}
     $4B:IF EDITPOS<>1 THEN DEC(EDITPOS); {LEFT}
     $4D:IF (EDITPOS<>LIMIT) AND (EDITPOS<>LENGTH(EDITSTR)+1) THEN
         INC(EDITPOS); {RIGHT}
     $4F:IF LENGTH(EDITSTR)=LIMIT THEN EDITPOS:=LIMIT
         ELSE EDITPOS:=LENGTH(EDITSTR)+1; {END}
     $53:DELETE(EDITSTR,EDITPOS,1); {DEL}
     $77:{^HOME, DEL TILL START OF LINE}
         BEGIN
          DELETE(EDITSTR,1,EDITPOS-1);
          EDITPOS:=1;
         END;
     $75:DELETE(EDITSTR,EDITPOS,255); {^END, DEL TILL END OF LINE}
     $73:{^LEFT, SEEK WORD LEFT}
         IF EDITPOS=1 THEN UPDATE:=FALSE
         ELSE REPEAT
          DEC(EDITPOS);
         UNTIL (EDITPOS=1) OR (EDITSTR[EDITPOS-1]=' ');
     $74:{^RIGHT, SEEK WORD RIGHT}
         IF (EDITPOS=LIMIT) OR (EDITPOS=LENGTH(EDITSTR)+1) THEN
          UPDATE:=FALSE
         ELSE REPEAT
          INC(EDITPOS);
         UNTIL (EDITSTR[EDITPOS-1]=' ') OR (EDITPOS=LIMIT)
          OR (EDITPOS=LENGTH(EDITSTR)+1);
     ELSE UPDATE:=FALSE; {DO NOT WASTE TIME UPDATING SCREEN}
    END; {CHECK KEY SCAN CODE}
    8:IF EDITPOS>1 THEN BEGIN {BACKSPACE}
     DEC(EDITPOS);
     DELETE(EDITSTR,EDITPOS,1);
    END
    ELSE UPDATE:=FALSE;
    32..255:BEGIN {VALID CHARS}
     IF INSMODE OR (LENGTH(EDITSTR)+1=EDITPOS) THEN
      {INSERTED IF USING INSERT MODE OR IF OVERSTRIKE AND AT STRING END}
      IF (LENGTH(EDITSTR)<>LIMIT) THEN INSERT(CHAR(KEY.CH),EDITSTR,EDITPOS)
      ELSE BEEP(5000,10) {ERROR: STRING FULL}
     ELSE EDITSTR[EDITPOS]:=CHAR(KEY.CH); {OVERSTRIKE CHAR}
     IF EDITPOS<>LIMIT THEN INC(EDITPOS); {INC POS WITHIN LIMIT}
    END; {VALID CHARS}
    ELSE UPDATE:=FALSE; {DO NOT WASTE TIME UPDATING SCREEN}
   END; {CHECK KEY CHAR}

   {UPDATE SCROLL WINDOW}
   WHILE EDITPOS<VIEWPOS DO DEC(VIEWPOS,VIEWPORT); {LEFT}
   WHILE EDITPOS>=VIEWPOS+VIEWPORT DO INC(VIEWPOS,VIEWPORT); {RIGHT}
  UNTIL KEY.CH=13; {ENTER ENDS LOOP/INPUT}
  TEXTATTR:=OLDCOLOR; {MINIMAL SCREEN CLEAN UP}
  CLRSCR;
 END {VALID VIEWPORT}
 ELSE EDSTR:=FALSE; {INVALID VIEWPORT}
 WINDMIN:=WMIN; {RESTORE WINDOW}
 WINDMAX:=WMAX; {RESTORE WINDOW}
 TEXTATTR:=OLDCOLOR; {RESTORE COLOR}
 GOTOXY(OLDX,OLDY); {RESTORE CURSOR}
END; {EDSTR}

VAR
     ASTR : STRING;

BEGIN
END.

