Unit Splits;

Interface

Uses crt, DOS, printer, globfel;

{$I FLSTRUCT.PAS}

Procedure drawsplit;
Procedure unsplit;
Procedure splitmode;
Procedure initwinds;
Procedure splitscreen;
Procedure setwind (n: Byte; nx1, ny1, nx2, ny2: Byte);
Procedure usewind (n: Byte);
Procedure getcoor;
Procedure Bottom;
Procedure initwind (n, nx1, ny1, nx2, ny2, ncolor: Byte);
Var winds: Array [0..2] Of windowrec;
  split, inuse: Integer;
Implementation



Procedure getcoor;
Var X : Word; XX, YY : Byte; W1 : Word;
Begin
  XX := WhereX; YY := WhereY;
  With winds [inuse] Do Begin
    CX := WhereX;
    cy := WhereY;
    If cy < 1 Then cy := 1;
    If cy > (Y2 - Y1) + 1 Then cy := (Y2 - Y1) + 1
  End
End;

Procedure usewind (n: Byte);
Begin
  getcoor;
  inuse := n;
  With winds [n] Do Begin
    Window (X1, Y1, X2, Y2);
    GotoXY (CX, cy);
    TextColor (Color);
    TextBackground (0);
    {lasty:=y2-y1+1}
  End
End;

Procedure setwind (n: Byte; nx1, ny1, nx2, ny2: Byte);
Var i: Integer;
Begin
  i := inuse;
  usewind (n);
  With winds [n] Do Begin
    X1 := nx1;
    Y1 := ny1;
    X2 := nx2;
    Y2 := ny2
  End;
  usewind (n);
  If n <> i Then usewind (i)
End;

Procedure drawsplit;
Var cnt: Integer;
Begin
  usewind (0);
  TextColor (1);
  GotoXY (1, split);
  For cnt := 0 To 79 Do Write ('');
  Bottom
End;

Procedure initwind (n, nx1, ny1, nx2, ny2, ncolor: Byte);
Begin
  With winds [n] Do Begin
    X1 := nx1;
    Y1 := ny1;
    X2 := nx2;
    Y2 := ny2;
    CX := 1;
    cy := 1;
    Color := ncolor
  End
End;

Procedure Top;
Begin
  usewind (1)
End;

Procedure Bottom;
Begin
  usewind (2)
End;

Procedure initwinds;
Begin
  {  splitmode:=false;}
  initwind (0, 1, 1, 80, 25, 9);
  If usebottom Then initwind (2, 1, 1, 80, 23, configset. normbotcolo) Else
    initwind (2, 1, 1, 80, 25, configset. normbotcolo);
  split := 0;
  inuse := 0;
  Bottom
End;

Procedure unsplit;
Var Y: Integer;
Begin
  If Not splitmode Then Exit;
  If inuse = 2
  Then Y := WhereY
  Else Y := winds [2].cy;
  Y := Y + split;
  If Usebottom Then setwind (2, 1, 1, 80, 23) Else
    setwind (2, 1, 1, 80, 25);
  setwind (1, 1, 1, 80, split);
  Top;
  ClrScr;
  splitmode := False;
  Bottom;
  GotoXY (WhereX, Y)
End;

Procedure splitscreen (v: Byte);
Var X, Y: Integer;
Begin
  If splitmode Then unsplit;
  X := WhereX;
  Y := WhereY - v;
  splitmode := True;
  split := v;
  drawsplit;
  initwind (1, 1, 1, 80, split - 1, configset. normtopcolo);
  If usebottom Then setwind (2, 1, split + 1, 80, 23) Else
    setwind (2, 1, split + 1, 80, 25);
  Top;
  ClrScr;
  Bottom;
  GotoXY (X, Y)
End;