(*
      PortObj, a low level FOSSIL communications object for afBBS
      is (C) 1994 Robert Minichino (aka. FAT Slayer).  Permission
      granted for use in not-for-profit computer programs, education,
      and afBBS only.
*)
Unit PortObj;

Interface

Type
  THandlerProc = Procedure;
  BaudRates = (b3, b6, b12, b24, b48, b96, b192, b384);
  TParityFlags = (Odd, Even, None);
  TCharBits = 1..5;
  TStopBits = 1..2; {2 doubles for 1.5!}
  PPort = ^TPort;
  TPort = Object { All communications are done w/FOSSIL! }
            Constructor Init (ComPort: Word; Speed: BaudRates; Parity: TParityFlags; CharSize: TCharBits; StopBits: TStopBits);
            Procedure SetBaud (Speed: BaudRates);
            Procedure SetIdleHandler (Handler: THandlerProc);
            Procedure SendCh (CH: Char);
            Procedure SendSt (St: String);
            Function RecvCh: Char;
            Function RecvSt: String;
            Function RecvReady: Boolean;
            Function SendReady: Boolean;
            Procedure DTR (Status: Boolean);
            Function GetDTR: Boolean;
            Function Carrier: Boolean;
            Procedure DoXON_XOFF (Enable: Boolean);
            Procedure DoCTS_RTS (Enable: Boolean);
            Procedure Break;
            Procedure ClearOut;
            Procedure ClearIn;
            Procedure FlushOut;
            Destructor DeInit;
            Procedure SetFlowControl;
            Private
            PortNum     : Word;
            IdleHandler : THandlerProc;
            XON_XOFF    : Boolean;
            CTS_RTS     : Boolean;
          End;
Const
  LBaudRate   : Array [b3..b384] Of LongInt = (300, 600, 1200, 2400, 4800,
  9600, 19200, 38400);
  ErrorCode : Byte = 0;
  { Error codes for above: }
  NoError = 0;
  NoFOSSIL = 1;
  {Bit position codes (16 bits)}
  Bit0 = $0001; {0000 0000 0000 0001}
  Bit1 = $0002; {0000 0000 0000 0010}
  Bit2 = $0004; {0000 0000 0000 0100}
  Bit3 = $0008; {0000 0000 0000 1000}
  Bit4 = $0010; {0000 0000 0001 0000}
  Bit5 = $0020; {0000 0000 0010 0000}
  Bit6 = $0040; {0000 0000 0100 0000}
  Bit7 = $0080; {0000 0000 1000 0000}
  Bit8 = $0100; {0000 0001 0000 0000}
  Bit9 = $0200; {0000 0010 0000 0000}
  BitA = $0400; {0000 0100 0000 0000}
  BitB = $0800; {0000 1000 0000 0000}
  BitC = $1000; {0001 0000 0000 0000}
  BitD = $2000; {0010 0000 0000 0000}
  BitE = $4000; {0100 0000 0000 0000}
  BitF = $8000; {1000 0000 0000 0000}
  
Implementation

{uses dos;
{
0=0000 1=0001 2=0010 3=0011 4=0100 5=0101 6=0110 7=0111
8=1000 9=1001 A=1010 B=1011 C=1100 D=1101 E=1110 F=1111


0100 =   300 baud $4
0110 =   600  ''  $6
1000 =  1200  ''  $8
1010 =  2400  ''  $A
1100 =  4800  ''  $C
1110 =  9600  ''  $E
0000 = 19200  ''  $0
0010 = 38400  ''  $2}

Const
  BaudBits : Array [b3..b384] Of Byte = ($40, $60, $80, $A0, $C0, $E0,
  $00, $20);
  
Procedure NullHandler; Far;
   Begin
   End;

Constructor TPort. Init; {ComPort:word; Speed:BaudRates}
   Var
     FoundFossil : Boolean;
     LineSetting : Byte;
   Begin
     PortNum := Pred (ComPort);
     Asm
       mov  AH, $04
       mov  DX, PortNum
       Int  $14
       cmp  AX, $1954
       jne  @NoFossil
       mov  Byte Ptr [FoundFossil], $01
       jmp  @Done
       @NoFossil:
       mov  Byte Ptr [FoundFossil], $00
       @Done:
     End;
     If Not FoundFossil Then
     Begin
       ErrorCode := NoFossil;
       Fail;
     End
     Else
       ErrorCode := NoError;
     LineSetting := 0;
     
     SetIdleHandler (NullHandler);
     XON_XOFF := False;
     CTS_RTS := False;
   End;

Procedure TPort. SetBaud;
   Begin
   End;

Procedure TPort. SetIdleHandler;
   Begin
     If @Handler <> Nil Then IdleHandler := Handler;
   End;

Function TPort. SendReady: Boolean; Assembler;
   Asm {Called often, use assembler. }
     mov  AH, 3
     mov  DX, PortNum
     Int  $14
     Test AX, $2000
     jnz  @Okay
     Test AX, $0080
     jz   @Okay
     mov  AL, False
     jmp  @Done
     @Okay:
     mov  AL, True
     @Done:
   End;

Function TPort. RecvReady: Boolean; Assembler;
   Asm
     mov  AH, 3
     mov  DX, PortNum
     Int  $14
     Test AX, $0100
     jz   @No
     mov  AL, True
     jmp  @Done
     @No:
     mov  AL, False
     @Done:
   End;

Procedure TPort. SendCh (CH: Char);
   Begin
     { ASM needed for speed in loops }
     While Not SendReady Do IdleHandler;
     Asm
       mov  AH, $01
       mov  AL, CH
       mov  DX, PortNum
       Int  $14
     End;
   End;

Procedure TPort. SendSt (St: String);
   Var
     ChOut : Char;
     X     : Byte;
   Begin
     For X := 1 To Length (St) Do
     Begin
       ChOut := St [X];
       While Not SendReady Do IdleHandler;
       Asm
         mov  AH, $01
         mov  AL, ChOut
         mov  DX, PortNum
         Int  $14
       End;
     End;
   End;

Function TPort. RecvCh: Char;
   Begin
     While Not RecvReady Do IdleHandler;
     Asm
       mov  AH, $02
       Int  $14
       mov  @Result, AL
       mov  DX, PortNum
     End;
   End;

Function TPort. RecvSt: String;
   Var
     TempStr : String;
     X       : Byte;
   Begin
     TempStr := '';
     While RecvReady And (X < 255) Do TempStr := TempStr + RecvCh;
     RecvSt := TempStr;
   End;

Procedure TPort. DTR; Assembler;
   Asm
     mov  AH, $06
     mov  DX, PortNum
     mov  AL, Status
     Int  $14
   End;

Function TPort. GetDTR: Boolean; Assembler;
   Asm
     mov  AH, $03
     mov  DX, PortNum
     Int  $14
     mov  CL, 3
     ShL  AL, CL
     jc   @DTROn
     mov  AL, False
     jmp  @Done
     @DTROn:
     mov  AL, True
     @Done:
   End;

Function TPort. Carrier: Boolean; Assembler;
   Asm
     mov  AH, $03
     mov  DX, PortNum
     Int  $14
     mov  CL, 1
     ShL  AL, CL
     jc   @CarrierOn
     mov  AL, False
     jmp  @Done
     @CarrierOn:
     mov  AL, True
     @Done:
   End;

Procedure TPort. SetFlowControl; Assembler;
   Asm
     mov  AH, $0F
     mov  AL, $00
     mov  DX, PortNum
     cmp  Byte Ptr XON_XOFF, 0
     je   @TestCTS
     Or   AL, Bit0 + Bit3
     @TestCTS:
     cmp  Byte Ptr CTS_RTS, 0
     je   @Done
     Or   AL, Bit1
     Int  $14
     @Done:
   End;

Procedure TPort. DoXON_XOFF;
   Begin
     XON_XOFF := Enable;
     SetFlowControl;
   End;

Procedure TPort. DoCTS_RTS;
   Begin
     CTS_RTS := Enable;
     SetFlowControl;
   End;

Procedure TPort. Break;
   {$I DELAY.INC}
   Begin
     Asm
       mov  AX, $1A01;
       mov  DX, PortNum
       Int  $14
     End;
     Delay (100);
     Asm
       mov  AX, $1A00
       mov  DX, PortNum
       Int  $14
     End;
   End;

Procedure TPort. ClearOut; Assembler;
   Asm
     mov  AH, $09
     mov  DX, PortNum
     Int  $14
   End;

Procedure TPort. ClearIn; Assembler;
   Asm
     mov  AH, $0A
     mov  DX, PortNum
     Int  $14
   End;

Procedure TPort. FlushOut; Assembler;
   Asm
     mov  AH, $08
     mov  DX, PortNum
     Int  $14
   End;

Destructor TPort. DeInit;
   Begin
     Asm
       mov  AH, $05
       mov  DX, PortNum
       Int  $14
     End;
   End;

Begin { Init code }
End.