program felviewer;

{$G+}

uses crt;

{$I FNY.INC}
type
   PMode8x16=^TMode8x16;
   TMode8x16=Array[char,1..16] of byte;
   PTextString=^TTextString;
   TTextString=string[80];
const
   NumPoints=8;
   Points:array[0..NumPoints-1,0..2] of integer=
      ((-30,-30,-40),(-30,-30, 40),( 30,-30, 40),( 30,-30,-40),
       (-30, 30,-40),(-30, 30, 40),( 30, 30, 40),( 30, 30,-40));
   NumPlanes=6;
   Planes:array[0..NumPlanes-1,0..3] of byte=
      ((0,4,5,1),(0,3,7,4),(0,1,2,3),(4,5,6,7),(7,6,2,3),(1,2,6,5));
   MinX=0; MinY=0;
   MaxX=80; MaxY=49;
   divd=128;
   dist=150;
var
   SineTable:Array[0..255] of integer;
   CosineTable:Array[0..255] of integer;
   PolyZCoords:Array[0..NumPlanes-1] of integer;
   DrawOrder:Array[0..NumPlanes-1] of byte;
   Mode8x8Font:Array[char,1..8] of byte;
   Mode8x16Font:PMode8x16;
   Randoms:Array[0..255] of byte;
   RandomCtr:word;
   XlateX,XlateY,Z:Array[0..NumPoints-1] of integer;
   VirScr:pointer;
   TextFile:Array[1..2048] of PTextString;
   NumLines:integer;

function MaxI(A,B:integer):integer;
   inline($58/        { pop  ax       }
          $5B/        { pop  bx       }
          $3B/$C3/    { cmp  ax,bx    }
          $7F/$01/    { jg   +1       }
          $93);       { xchg ax,bx    }

function MinI(A,B:integer):integer;
   inline($58/        { pop  ax       }
          $5B/        { pop  bx       }
          $3B/$C3/    { cmp  ax,bx    }
          $7C/$01/    { jl   +1       }
          $93);       { xchg ax,bx    }

function InRangeI(value,min,max:integer):integer;
   inline($59/        { pop  cx ; max }
          $5B/        { pop  bx ; min }
          $58/        { pop  ax ; val }
          $3B/$C3/    { cmp  ax, bx   }
          $7F/$03/    { jg   +3       }
          $93/        { xchg ax, bx   }
          $Eb/$05/    { jmp  +5       }
          $3B/$C1/    { cmp  ax, cx   }
          $7C/$01/    { jl   +1       }
          $91);       { xchg ax, cx   }

function SAR7_32(IntIn:longint):integer;
   inline($66/$58/    { pop  eax      }
          $66/$C1/$F8/$07); { sar  eax, 7   }

function SAR7(IntIn:integer):integer;
   inline($58/        { pop  ax       }
          $C1/$F8/$07);{ sar  ax, 7    }

procedure Retrace; assembler;
   asm
   mov  dx,3dah
   @vert1:
   in   al,dx
   test al,8
   jz   @vert1
   @vert2:
   in   al,dx
   test al,8
   jnz  @vert2
   end;

procedure GetFontPtr; assembler;
   asm
   mov  ax,1130h
   mov  bh,6
   push bp
   int  10h
   mov  ax,bp
   pop  bp
   mov  word ptr [Mode8x16Font],ax
   mov  word ptr [Mode8x16Font+2],es
   end;

procedure SetFont; assembler;
   asm
   mov  dx, seg Mode8x8Font
   mov  es, dx
   mov  ax, 1100h
   mov  bh, 8d
   mov  bl, 0
   mov  cx, 256d
   mov  dx, 0d
   push bp
   mov  bp, offset Mode8x8Font
   int  10h
   pop  bp
   end;

procedure setpal(c,r,g,b:byte); assembler;
   asm
   mov  dx,3c8h
   mov  al,[c]
   out  dx,al
   inc  dl
   mov  al,[r]
   out  dx,al
   mov  al,[g]
   out  dx,al
   mov  al,[b]
   out  dx,al;
   end;

{draws a horizontal line on the screen}
procedure horline(xb,xe,y:integer; c:byte); assembler;
   asm
   mov  bx, xb
   mov  cx, xe
   cmp  bx, cx
   jb   @skip
   xchg bx, cx
   @skip:
   {mov  ax, $B800
   mov  es, ax}
   les  si, VirScr
   mov  di, y
   mov  ax, y
   shl  di, 5
   shl  ax, 7
   add  di, ax
   shl  bx, 1
   add  di, bx
   shr  di, 1

   add  di, si
   shr  bx, 1
   sub  cx, bx
   inc  cx
   mov  ah, c
   shl  ah, 4 {set it to the background part of the color}
   {mov  al, 219}
   {rep  stosw}
   {inc  di}
   @loopbegin:{
   and byte ptr es:[di], $0F
   or  byte ptr es:[di], ah
   add di, 2}
   mov byte ptr es:[di], ah
   inc di
   dec cx
   jnz @loopbegin
   end;

procedure PutFelonyLogo; assembler;
   asm
   mov  si, offset FelonyLogo
   mov  ax, $B800
   mov  es, ax
   mov  bx, 346d
   mov  di, (50-8)*160
   inc  di
   xor  ch,ch
   @loopie:
   mov  al, byte ptr ds:[si]
   mov  cl, byte ptr ds:[si+1]
   or   al, al
   jz   @skiploop
   @@innerloop:
   mov  ah, byte ptr es:[di]
   {shr  ah, 4
   add  ah, 3
   shl  ah, 4}
   add  ah, 3 shl 4
   and  byte ptr es:[di], $0F
   or   byte ptr es:[di], ah
   add  di,2
   dec  cl
   jnz  @@innerloop
   @skiploop:
   add  di, cx
   add  di, cx
   add  si, 2
   dec  bx
   dec  bx
   jnz  @loopie
   end;

{returns a string of RptChar repeated Times times}
function RepeatChar(RptChar:char; Times:byte):string;
   var
      TmpStr:string;
   begin
   TmpStr[0]:=char(Times);
   FillChar(TmpStr[1],Times,RptChar);
   RepeatChar:=TmpStr;
   end;

{Calls the above to make some spaces}
function Space(Len:byte):string;
   begin
   Space:=RepeatChar(' ',Len);
   end;

{Pads StrIn to the left in Flen of PadChar's
   i.e. StrIn:='Good', FLen=10, PadChar:='#' then
       PadL will return 'Good######'}
function PadL(StrIn:string; Flen:byte; PadChar:char):string;
   begin
   if length(StrIn) > Flen then StrIn:=copy(StrIn,1,Flen);
   PadL:=StrIn+RepeatChar(PadChar,FLen-length(StrIn));
   end;


procedure polygon( {x1,y1, x2,y2, x3,y3, x4,y4}Counter :integer; c:byte);
var pos:array[0..199,0..1] of integer;
  xdiv1,xdiv2,xdiv3,xdiv4:integer;
  ydiv1,ydiv2,ydiv3,ydiv4:integer;
  dir1,dir2,dir3,dir4:byte;
  ly,gy,y,tmp,step:integer;
  x1,y1, x2,y2, x3,y3, x4,y4 : integer;
begin
  x1:=XlateX[planes[DrawOrder[Counter],0]];
  y1:=XlateY[planes[DrawOrder[Counter],0]];
  x2:=XlateX[planes[DrawOrder[Counter],1]];
  y2:=XlateY[planes[DrawOrder[Counter],1]];
  x3:=XlateX[planes[DrawOrder[Counter],2]];
  y3:=XlateY[planes[DrawOrder[Counter],2]];
  x4:=XlateX[planes[DrawOrder[Counter],3]];
  y4:=XlateY[planes[DrawOrder[Counter],3]];
  { determine highest and lowest point + vertical window checking }
  ly:=MaxI(MinI(MinI(MinI(y1,y2),y3),y4),miny);
  gy:=MinI(MaxI(MaxI(MaxI(y1,y2),y3),y4),maxy);

  if ly>maxy then exit;
  if gy<miny then exit;

  { check directions (-1=down, 1=up) and calculate constants }
  dir1:=byte(y1<y2); xdiv1:=x2-x1; ydiv1:=y2-y1;
  dir2:=byte(y2<y3); xdiv2:=x3-x2; ydiv2:=y3-y2;
  dir3:=byte(y3<y4); xdiv3:=x4-x3; ydiv3:=y4-y3;
  dir4:=byte(y4<y1); xdiv4:=x1-x4; ydiv4:=y1-y4;

  y:=y1;
  step:=dir1*2-1;
  if y1<>y2 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
        tmp:=xdiv1*(y-y1) div ydiv1+x1;
        pos[y,dir1]:=InRangeI(tmp,minx,maxx);
      end;
      inc(y,step);
    until y=y2+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir1]:=InRangeI(x1,minx,maxx);
    end;
  end;

  y:=y2;
  step:=dir2*2-1;
  if y2<>y3 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
        tmp:=xdiv2*(y-y2) div ydiv2+x2;
        pos[y,dir2]:=InRangeI(tmp,minx,maxx);
      end;
      inc(y,step);
    until y=y3+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir2]:=InRangeI(x2,minx,maxx);
    end;
  end;

  y:=y3;
  step:=dir3*2-1;
  if y3<>y4 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
        tmp:=xdiv3*(y-y3) div ydiv3+x3;
        pos[y,dir3]:=InRangeI(tmp,minx,maxx);
      end;
      inc(y,step);
    until y=y4+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir3]:=InRangeI(x3,minx,maxx);
    end;
  end;

  y:=y4;
  step:=dir4*2-1;
  if y4<>y1 then begin
    repeat
      if InRangeI(y,ly,gy)=y then begin
        tmp:=xdiv4*(y-y4) div ydiv4+x4;
        pos[y,dir4]:=InRangeI(tmp,minx,maxx);
      end;
      inc(y,step);
    until y=y1+step;
  end
  else begin
    if (y>=ly) and (y<=gy) then begin
      pos[y,dir4]:=InRangeI(x4,minx,maxx);
    end;
  end;

  for y:=ly to gy do horline(pos[y,0],pos[y,1],y,c);
end;

procedure quicksort(lo,hi:integer);
   procedure sort(l,r:integer);
      var
         i,j,x,y:integer;
      begin
      i:=l; j:=r; x:=PolyZCoords[(l+r) div 2];
      repeat
         while PolyZCoords[i]<x do inc(i);
         while x<PolyZCoords[j] do dec(j);
         if i<=j then
            begin
            y:=PolyZCoords[i]; PolyZCoords[i]:=PolyZCoords[j]; PolyZCoords[j]:=y;
            y:=DrawOrder[i]; DrawOrder[i]:=DrawOrder[j]; DrawOrder[j]:=y;
            inc(i); dec(j);
            end;
      until i>j;
      if l<j then sort(l,j);
      if i<r then sort(i,r);
      end;
   begin
   sort(lo,hi);
   end;

procedure RotateCube;
   const
      {xst=2; yst=3; zst=-2;}
      xst=2; yst=1; zst=4;
   type
      TPoint=Array[0..2] of integer;
   var
      XRotation,YRotation,ZRotation:byte;
      x,y,i,j,k:integer; {generic holding variables}
      Counter:byte;
      t1,t2,t3,t4,t5,t6:integer;
      tmp:^TPoint;
      MinZ,MaxZ:integer;
      ExitThis,change:boolean;
      curY:integer;s:string;

   begin
   (*
   MinZ:=MaxInt; {-340}
   MaxZ:=(-MaxInt)-1; {-260}
   *)
   {Clear the arrays that hold the transformed x/y coords}
   FillChar(XlateX,sizeof(XlateX),0);
   FillChar(XlateY,sizeof(XlateY),0);
   XRotation:=0; YRotation:=0; ZRotation:=0;
   exitthis:=False; CurY:=1; change:=true;
   repeat
     if Change then
        begin
        TextAttr:=$0F;
        Change:=False;
        for Counter:=0 to 39 do
           begin
           gotoxy(1,Counter+2);
           if TextFile[pred(Counter+CurY) div 2]<>nil then
              begin
              s:=TextFile[pred(Counter+CurY) div 2]^;
              if pred(Counter+CurY) and 1 = 1 then
                 for x:=1 to Length(S)do s[x]:=chr(ord(s[x])or$80);
              Write(padl(s,80,' '));
              end;
           end;
        end;
     RandomCtr:=Random(256);
      t1:=coSineTable[xrotation];t2:=coSineTable[YRotation];t3:=coSineTable[YRotation];
      t4:=SineTable[xrotation];  t5:=SineTable[YRotation];  t6:=SineTable[YRotation];
    for Counter:=0 to 7 do begin
      tmp:=addr(Points[Counter]);
      i:=SAR7(t2*tmp^[0]-t5*tmp^[2]);{ div divd;}
      j:=SAR7(t3*tmp^[1]-t6*i);{ div divd;}
      k:=SAR7(t2*tmp^[2]+t5*tmp^[0]);{ div divd;}
      x:=SAR7(t3*i+t6*tmp^[1]);{ div divd;}
      y:=SAR7(t1*j+t4*k);{ div divd;}
      z[Counter]:=SAR7(t1*k-t4*j);{ div divd;}
      {z[Counter]:=z[Counter]-250;}
      dec(z[Counter],390);
      XLateX[Counter]:=40+(-x*dist) div (z[Counter]-dist);
      XLateY[Counter]:=20+(-y*dist) div (z[Counter]-dist);
    end;
    for Counter:=0 to 5 do begin
      PolyZCoords[Counter]:=(z[planes[Counter,0]]+z[planes[Counter,1]]+z[planes[Counter,2]]+z[planes[Counter,3]]) div 4;
    {  MaxZ:=MaxI(PolyZCoords[Counter],MaxZ);
      MinZ:=MinI(PolyZCoords[Counter],MinZ);}
      DrawOrder[Counter]:=Counter;
    end;
    quicksort(0,5);
      FillChar(VirScr^,80*40,0);
    for Counter:=3 to 5 do
      polygon(Counter, MinI(DrawOrder[Counter]+2,8));
{procedure horline(xb,xe,y:integer; c:byte); assembler;}
      Retrace;
      {setpal(0,60,0,0);}
      asm
      mov  ax, $B800
      mov  es, ax
      mov  cx, 80*50
      mov  si, offset Randoms
      mov  bx, RandomCtr
      xor  di, di
      inc  di
      @loopie:
      mov  ah, byte ptr ds:[si][bx]
      and  ah, $30
      or   ah, $0F
      mov  byte ptr es:[di], ah
      add  di, 2
      inc  bx
      and  bx, $ff
      dec  cx
      jnz  @loopie
      end;{
      for i:=0 to 80*50-1 do
         begin
         Mem[$B800:i*2+1]:=$0F or (Randoms[RandomCtr] shr 6 shl 4);
         inc(RandomCtr);
         end;}
      putfelonylogo;
      asm
      push ds
      mov  ax, $B800
      mov  es, ax
      lds  si, VirScr
      mov  cx, 80*34
      xor  di, di
      inc  di
      add  si, 80*4
      add  di, 80*4*2
      @@loopy:
      mov  ah, byte ptr ds:[si]
      or   ah, ah
      jz   @@skippy
      and  byte ptr es:[di], $0F
      add  byte ptr es:[di], ah
      @@skippy:
      inc  si
      add  di, 2
      dec  cx
      jnz  @@loopy
      pop  ds
      end;
      {setpal(0,0,0,0);}
    retrace;
    inc(XRotation,xst); inc(YRotation,yst); inc(ZRotation,zst);
    if KeyPressed then
       case ReadKey of
         #0:
         case ReadKey of
           #72: {UP} if CurY>1 then begin change:=true; dec(CurY); end;
           #80: {DN} if CurY<MaxI((NumLines*2)-40,1) then begin change:=true; inc(CurY); end;
           #73: {PUP}begin CurY:=MaxI(CurY-40,1); Change:=true; end;
           #81: {PDN}begin CurY:=MinI(CurY+40,MaxI((NumLines*2)-40,1)); Change:=true; end;
           #79: {END}begin CurY:=MaxI((Numlines*2)-40,1); Change:=true; end;
           #71: {HOM}begin CurY:=1; Change:=true; end;
           end;
         #27,#13: exitthis:=true;
         end;
   until Exitthis;
   while Keypressed do if ReadKey=#0 then readkey;
   end;

var
   i,j:integer; x:text; s:string; c:char;
begin
if ParamCount<>1 then
   begin
   WriteLn('You must specify a filename to list (text).  e.g. fELVIEW \fileNAME.ext');
   Halt(1);
   end;
for i:=0 to 255 do cosinetable[i]:=round(-cos(i*pi/128)*divd);
for i:=0 to 255 do sinetable[i]:=round(sin(i*pi/128)*divd);
Randomize; delay(random(100)); randomize;
for i:=0 to 255 do Randoms[i]:=Random(256); RandomCtr:=Random(256);
TextMode(CO80+Font8x8);
GetFontPtr;
for c:=#0 to #127 do
   for i:=1 to 8 do
      Mode8x8Font[c,i]:=Mode8x16Font^[c,i];
for c:=#0 to #127 do
   for i:=1 to 8 do
      Mode8x8Font[chr(ord(c)+128),i]:=Mode8x16Font^[c,i+8];
SetFont;
for i:=0 to 2 do setpal(i,0,round(i*(64/15)),round(i*(64/15)));
for i:=3 to 20 do setpal(i,0,7+round(i*64/30),7+round(i*64/30));
setpal(i,0,20,20);
{$I-}
Assign(x,ParamStr(1)); reset(x);
fillchar(textfile, sizeof(textfile),0);
NumLines:=1;
while (IOResult=0) and (not eof(x)) do
   begin
   new(TextFile[NumLines]);
   ReadLn(x,TextFile[NumLines]^);
   Inc(NumLInes);
   {TextFile:Array[1..1024] of PTextString;
   NumLines:integer;}
   {if s[0]>#80 then s[0]:=#80;
   WriteLn(s);
   for j:=1 to length(s) do s[j]:=chr(ord(s[j]) or $80);
   WriteLn(s);}
   end;
dec(NumLines);
GetMem(VirScr,80*50);
RotateCube;
FreeMem(VirScr,80*50);
TextMode(CO80);
end.
