Unit FELAnsi;

Interface

Procedure ShowFile (FileName : String);
Procedure PipeParser (Input : String; LocalP : Boolean);
Function AnsiBackGround (Colour : Byte) : String;
Function AnsiColour (Colour : Byte) : String;
Procedure WriteSE (S : String);
Procedure WriteLnAns (S : String);

Const
  Blink : Boolean = False;
  Bold  : Boolean = False;

Implementation

uses Crt, DOS, Routine, Cursor, FelFOSS, FelFX, FelANS, GlobFEL, Fossil, FelSHNE, FelUsr,
fny_proc, AnsiDrv, fnylogin, fnyenter;

Procedure WriteLnAns (S : String);
Var X       : Byte;
  S2      : Array [1..14] Of String [10];
  X2      : Array [1..14] Of Byte;
  Cur     : Byte;
  CMD     : Char;
  SX, SY   : Byte;
  klar : boolean;
  klar2: boolean;
  tmp  : string;
  tmp2 : string[2];
  a    : byte;
  i    : integer;
  kn   :integer;
  OldX :Byte;
  OldY :Byte;
  q    :String;
Procedure Bolda (B : Boolean);
Begin
  If B Then TextAttr := TextAttr Or 8 Else
    TextAttr := TextAttr And 247;
End;

Procedure Blinka (B : Boolean);
Begin
  If B Then TextAttr := TextAttr Or 128 Else
    TextAttr := TextAttr And 127;
End;

Procedure DoCommand;
Var W       : Word;
  Z       : Byte;
  XV, YV  : Byte;

Const Tab : Array [0..7] Of Byte = (0, 4, 2, 6, 1, 5, 3, 7);

Begin
  Case (UpCase (CMD) ) Of
    'H'   : If Cur = 0 Then GotoXY (1, 1) Else
    Begin
      Val (S2 [1], X2 [1], W);
      Val (S2 [2], X2 [2], W);
      GotoXY (X2 [2], X2 [1] );
    End;
    'F'   : If Cur = 0 Then GotoXY (1, 1) Else
    Begin
      Val (S2 [1], X2 [1], W);
      Val (S2 [2], X2 [2], W);
      GotoXY (X2 [2], X2 [1] );
    End;
    'M'   : If Cur = 0 Then Begin Bold := False; Blink := False; TextAttr := 7 End Else
    Begin
      For Z := 1 To Cur Do
      Begin
        Val (S2 [Z], X2 [Z], W);
        If (X2 [Z] = 0) Then Begin TextAttr := 7; Bold := False; Blink := False; End;
        If (X2 [Z] = 1) Then Bold := True;
        If (X2 [Z] = 2) Then Bold := False;
        If (X2 [Z] >= 30) And (X2 [Z] <= 37) Then TextColor (Tab [X2 [Z] - 30] );
        If (X2 [Z] >= 40) And (X2 [Z] <= 47) Then TextBackground (Tab [X2 [Z] - 40] );
        Bolda (Bold);
      End;
    End;
    'A'   : If Cur = 0 Then GotoXY (WhereX, WhereY - 1) Else
    Begin
      Val (S2 [1], X2 [1], W);
      GotoXY (WhereX, WhereY - X2 [1] );
    End;
    'B'   : If Cur = 0 Then GotoXY (WhereX, WhereY + 1) Else
    Begin
      Val (S2 [1], X2 [1], W);
      GotoXY (WhereX, WhereY + X2 [1] );
    End;
    'C'   : If Cur = 0 Then GotoXY (WhereX + 1, WhereY) Else
    Begin
      Val (S2 [1], X2 [1], W);
      GotoXY (WhereX + X2 [1], WhereY);
    End;
    'D'   : If Cur = 0 Then GotoXY (WhereX - 1, WhereY) Else
    Begin
      Val (S2 [1], X2 [1], W);
      GotoXY (WhereX - X2 [1], WhereY);
    End;
    'S'   : 
            Begin
              SX := WhereX; SY := WhereY;
            End;
    'U'   :
            Begin
              GotoXY (SX, SY);
            End;
    'J'   : If (Cur = 0) Or (S2 [1] = '0') Then
    Begin
      For W := WindMin + (WhereX - 1) * 2 + (WhereY - 1) * 160 To WindMax Do
        Mem [$B800: W] := 0;
    End Else
      If (S2 [1] = '1') Then
      Begin
        For W := WindMin To WindMin + (WhereX - 1) * 2 + (WhereY - 1) * 160 Do
          Mem [$B800: W] := 0;
      End Else ClrScr;
    Else
  End;
End;

Var Ss : String;
  Y  : Word;
  Z  : Word;
  CH : Char;

Function GetCode (X : Byte) : String;
Var XY : Byte;

Begin
  Xy := X + 1;
  While S [Xy] <> '@' Do Inc (Xy);
  Ss := S;
  Delete (Ss, 1, X - 1);
  Delete (Ss, Xy - X + 2, 255);
  GetCode := UpCaseStr (Ss);
End;

Begin
  If S <> '' Then
    For X := 1 To Length (S) Do
    Begin
      If (S [X] = '') And (S [X + 1] = '[') Then
      Begin
        X := X + 2; Cur := 0;
        
        If (S [X] >= '0') And (S [X] <= '9') Then
          Repeat
            Inc (Cur);
            If S [X] = ';' Then Inc (X);
            S2 [Cur] := '';
            Repeat
              S2 [Cur] := S2 [Cur] + S [X];
              Inc (X);
            Until (S [X] = ';') Or (S [X] < '0') Or (S [X] > '9');
          Until S [X] <> ';';
        CMD := S [X];
        DoCommand;
      End Else
        If (UpCase (S [X] ) = '@') And (UpCase (S [X + 1] ) = 'X') And (Length (S) >= X + 3) Then
        Begin
          X := X + 3;
          If Y > 15 Then Y := 7; If Y < 0 Then Y := 0;
          CH := UpCase (S [X] );
          If CH = '0' Then Y := 0 Else If CH = '1' Then Y := 1 Else
            If CH = '2' Then Y := 2 Else If CH = '3' Then Y := 3 Else
              If CH = '4' Then Y := 4 Else If CH = '5' Then Y := 5 Else
                If CH = '6' Then Y := 6 Else If CH = '7' Then Y := 7 Else
                  If CH = '8' Then Y := 8 Else If CH = '9' Then Y := 9 Else
                    If CH = 'A' Then Y := 10 Else If CH = 'B' Then Y := 11 Else
                      If CH = 'C' Then Y := 12 Else If CH = 'D' Then Y := 13 Else
                        If CH = 'E' Then Y := 14 Else If CH = 'F' Then Y := 15;
          CH := UpCase (S [X - 1] );
          Z := 0;
          If CH = '0' Then Z := 0 Else If CH = '1' Then Z := 1 Else
            If CH = '2' Then Z := 2 Else If CH = '3' Then Z := 3 Else
              If CH = '4' Then Z := 4 Else If CH = '5' Then Z := 5 Else
                If CH = '6' Then Z := 6 Else If CH = '7' Then Z := 7;
          TextAtt (Y, Z);
        End Else
          If S [X] = '@' Then
          Begin
            Ss := GetCode (X);
            If SS = '@USER@' Then Begin FWrite (USR. Handle); X := X + 5; End Else {user}
            If SS = '@BEEP@' Then Begin FWrite (#7); X := X + 5; End Else {beep}
            If SS = '@CLS@' Then Begin FClrScr; X := X + 4; End Else {clearscreen}
            if SS = '@L1@' then Begin Login2; End Else; {handle prompt}
            if SS = '@L2@' then begin OldX := WhereX; {password prompt}
                                      OldY := WhereY;
                                      GotoXY (WhereX, WhereY-1);
                                      Login3; End Else; {login sequence}
            if SS = '@E1@' then begin Enter1; End Else; {animational enter1;}
            if SS = '@M1@' then begin pipeparser(mtx.mtx1,true); End Else; {matrix option1}
            if SS = '@M2@' then begin pipeparser(mtx.mtx2,true); End Else; {matrix option2}
            if SS = '@M3@' then begin pipeparser(mtx.mtx3,true); End Else; {matrix option3}
            if SS = '@M4@' then begin pipeparser(mtx.mtx4,true); End Else; {matrix option4}
            if SS = '@M5@' then begin pipeparser(mtx.mtx5,true); End Else; {matrix option5}
            if SS = '@O1@' then begin q := WriteString('24|**',true); End Else; {oliner1}
       {    If SS='@CITY@' Then Begin XWriteS(SXDoor.Location);X:=X+5;End Else}
          FWrite (S [X] );
          End Else
            If S [X] = #9 Then
              FWrite ('        ')
            Else
              FWrite (S [X] );
      If X > Length (S) Then Break;
    End;
  FWriteLn ('');
End;

Procedure ShowFile (FileName : String);
Var
  F    : Text;
  S    : String;
  O    : Boolean;
  X    : Byte;

Begin
  O := False;
  If (Colors) And (FileExists (Cfg. TextFileDi + FileName+ '.ANS') ) Then
    Assign (F, Cfg. TextFileDi + FileName+ '.ANS') 
  Else
    If (Colors) And (FileExists (Cfg. TextFileDi + FileName+ '.PCB') ) Then
      Assign (F, Cfg. TextFileDi + FileName+ '.PCB')
  Else
    If (Colors) And (FileExists (Cfg. TextFileDi + FileName+ '.HDR') ) Then
      Assign (F, Cfg. TextFileDi + FileName+ '.HDR')
  Else
    If (Colors) And (FileExists (Cfg. TextFileDi + FileName+ '.CRD') ) Then
      Assign (F, Cfg. TextFileDi + FileName+ '.CRD')
  Else
      If (Not Colors) And (FileExists (Cfg. TextFileDi + FileName+ '.ASC') ) Then
        Assign (F, Cfg. TextFileDi + FileName+ '.ASC');
  FileMode := 2;
  Reset (F);
  FileMode := 2;
  If IOResult <> 0 Then
    LogMsg ('I/O Error, couldn''t show the file ' + Cfg. TextFileDi + FileName) 
  Else
  Begin
    While Not (EoF (F) ) Do
    Begin
      ReadLn (F, S);
      WriteLnAns (S);
    End;
    Close (F);
  End;
End;
Procedure WriteSE (S : String);
Var Ss : String;
  
Function GetCode (X : Byte) : String;
Var XY : Byte;
Begin
  Xy := X + 1;
  While S [Xy] <> '@' Do Inc (Xy);
  Ss := S;
  Delete (Ss, 1, X - 1);
  Delete (Ss, Xy - X + 2, 255);
  GetCode := UpCaseStr (Ss);
End;

Var X, Y, Z : Byte; CH : Char;
Begin
  For X := 1 To Length (s) Do
  Begin
    If (UpCase (S [X] ) = '@') And (UpCase (S [X + 1] ) = 'X') And (Length (S) >= X + 3) Then
    Begin
      X := X + 3;
      If Y > 15 Then Y := 7; If Y < 0 Then Y := 0;
      CH := UpCase (S [X] );
      If CH = '0' Then Y := 0 Else If CH = '1' Then Y := 1 Else
        If CH = '2' Then Y := 2 Else If CH = '3' Then Y := 3 Else
          If CH = '4' Then Y := 4 Else If CH = '5' Then Y := 5 Else
            If CH = '6' Then Y := 6 Else If CH = '7' Then Y := 7 Else
              If CH = '8' Then Y := 8 Else If CH = '9' Then Y := 9 Else
                If CH = 'A' Then Y := 10 Else If CH = 'B' Then Y := 11 Else
                  If CH = 'C' Then Y := 12 Else If CH = 'D' Then Y := 13 Else
                    If CH = 'E' Then Y := 14 Else If CH = 'F' Then Y := 15;
      CH := UpCase (S [X - 1] );
      Z := 0;
      If CH = '0' Then Z := 0 Else If CH = '1' Then Z := 1 Else
        If CH = '2' Then Z := 2 Else If CH = '3' Then Z := 3 Else
          If CH = '4' Then Z := 4 Else If CH = '5' Then Z := 5 Else
            If CH = '6' Then Z := 6 Else If CH = '7' Then Z := 7;
      TextAtt (Y, Z);
    End Else
      If S [X] = '@' Then
      Begin
        Ss := GetCode (X);
        If SS = '@USER@' Then Begin FWrite (USR. Handle); X := X + 5; End Else
          If SS = '@BEEP@' Then Begin FWrite (#7); X := X + 5; End Else
            If SS = '@CLS@' Then Begin FClrScr; X := X + 4; End Else
              {      If SS='@CITY@' Then Begin XWriteS(SXDoor.Location);X:=X+5;End Else}
              FWrite (S [X] );
      End Else
        If S [X] = #9 Then
          FWrite ('        ')
        Else FWrite (S [X] );
  End;
End;

Procedure PipeParser (Input : String; LocalP : Boolean);
Var
  Lngth, Loop, X, Y : Byte;
Begin
  Input := RTrim (Input, ' ');
  Lngth := Length (Input);
  If LocalP = False Then
  Begin
    For Loop := 1 To Lngth Do
    Begin
      If Input [Loop] = '|' Then
      Begin
        If (Input [Loop + 1] In ['0'..'9', 'a'..'f', 'A'..'F'] ) And
           (Input [Loop + 2] In ['0'..'7'] ) 
        Then
        Begin
          If UpCase (Input [Loop + 1] ) = 'A' Then
          Begin
            WriteStringANSINOCR (AnsiColour (10) );
          End
          Else If UpCase (Input [Loop + 1] ) = 'B' Then
          Begin
            WriteStringANSINOCR (AnsiColour (11) );
          End
            Else If UpCase (Input [Loop + 1] ) = 'C' Then
            Begin
              WriteStringANSINOCR (AnsiColour (12) );
            End
              Else If UpCase (Input [Loop + 1] ) = 'D' Then
              Begin
                WriteStringANSINOCR (AnsiColour (13) );
              End
                Else If UpCase (Input [Loop + 1] ) = 'E' Then
                Begin
                  WriteStringANSINOCR (AnsiColour (14) );
                End
                  Else If UpCase (Input [Loop + 1] ) = 'F' Then
                  Begin
                    WriteStringANSINOCR (AnsiColour (15) );
                  End
                    Else If Input [Loop + 1] In ['0'..'9'] Then
                    Begin
                      WriteStringANSINOCR (AnsiColour (StrToInt (Input [Loop + 1] ) ) );
                    End;
          WriteStringANSINOCR (AnsiBackGround (StrToInt (Input [Loop + 2] ) ) );
          Inc (Loop, 2);
        End;
      End
      Else
      Begin
        WriteCharAnsi (Input [Loop] );
      End;
    End;
    WriteStringANSINOCR ('[0m');
  End
  Else
  Begin
    For Loop := 1 To Lngth Do
    Begin
      If Input [Loop] = '|' Then
      Begin
        If (Input [Loop + 1] In ['0'..'9', 'a'..'f', 'A'..'F'] ) And
           (Input [Loop + 2] In ['0'..'7'] ) 
        Then
        Begin
          If UpCase (Input [Loop + 1] ) = 'A' Then
          Begin
            WritePort (AnsiColour (10) );
          End
          Else If UpCase (Input [Loop + 1] ) = 'B' Then
          Begin
            WritePort (AnsiColour (11) );
          End
            Else If UpCase (Input [Loop + 1] ) = 'C' Then
            Begin
              WritePort (AnsiColour (12) );
            End
              Else If UpCase (Input [Loop + 1] ) = 'D' Then
              Begin
                WritePort (AnsiColour (13) );
              End
                Else If UpCase (Input [Loop + 1] ) = 'E' Then
                Begin
                  WritePort (AnsiColour (14) );
                End
                  Else If UpCase (Input [Loop + 1] ) = 'F' Then
                  Begin
                    WritePort (AnsiColour (15) );
                  End
                    Else If Input [Loop + 1] In ['0'..'9'] Then
                    Begin
                      WritePort (AnsiColour (StrToInt (Input [Loop + 1] ) ) );
                    End;
          WritePort (AnsiBackGround (StrToInt (Input [Loop + 2] ) ) );
          Inc (Loop, 2);
        End;
      End
      Else
      Begin
        WritePort (Input [Loop] );
      End;
    End;
  End;
End;

Function AnsiBackGround (Colour : Byte) : String;
Begin
  Case Colour Of
    0: 
       Begin AnsiBackGround := '[40m'; End;
    1: Begin AnsiBackGround := '[44m'; End;
    2: Begin AnsiBackGround := '[42m'; End;
    3: Begin AnsiBackGround := '[46m'; End;
    4: Begin AnsiBackGround := '[41m'; End;
    5: Begin AnsiBackGround := '[45m'; End;
    6: Begin AnsiBackGround := '[43m'; End;
    7: Begin AnsiBackGround := '[47m'; End;
  End;
End;

Function AnsiColour (Colour : Byte) : String;
Begin
  Case Colour Of
    0: Begin  AnsiColour := '[0;30m'; End;
    1: Begin  AnsiColour := '[0;34m'; End;
    2: Begin  AnsiColour := '[0;32m'; End;
    3: Begin  AnsiColour := '[0;36m'; End;
    4: Begin  AnsiColour := '[0;31m'; End;
    5: Begin  AnsiColour := '[0;35m'; End;
    6: Begin  AnsiColour := '[0;33m'; End;
    7: Begin  AnsiColour := '[0;37m'; End;
    8: Begin  AnsiColour := '[1;30m'; End;
    9: Begin  AnsiColour := '[1;34m'; End;
    10: Begin  AnsiColour := '[1;32m'; End;
    11: Begin  AnsiColour := '[1;36m'; End;
    12: Begin  AnsiColour := '[1;31m'; End;
    13: Begin  AnsiColour := '[1;35m'; End;
    14: Begin  AnsiColour := '[1;33m'; End;
    15: Begin  AnsiColour := '[1;37m'; End;
  End;
End;

End.
