Program NodeLists;        (* Generic program to
                             set up the node lists for
                             netmail ver 1.01 *)

Uses Crt,Dos,Gentypes,Configrt,GenSubs,PullTTT5;

Var Node:NodeNetRec;
    Fn:File of NodeNetRec;
    Input:String;
    I,J,Cnt:Integer;
    C:Char;
    TheMenu:Pull_Array;
    Major,Minor:Byte;

Procedure CiRRON_fx; (* Show Shadowed CiRRON *)
Begin
textcolor(1);
Write('C');
textcolor(9);
Write('i');
textcolor(3);
Write('R');
textcolor(11);
Write('R');
textcolor(15);
Write('O');
textcolor(11);
Write('N');
textcolor(3);
Write('');
textcolor(9);
Write('');
textcolor(1);
Write('');


End;
Procedure ShowNode;
Begin
  ClrScr;
  textcolor(9);
  Write('Node '); textcolor(11); Write('#'); textcolor(3); WriteLn(i);
  textcolor(9); Write('Node Password        :'); textcolor(3); WriteLn(node.Pass);
  textcolor(9); Write('Node Name            :'); textcolor(3); WriteLn(Node.Name);
  textcolor(9); Write('Node Phone Number    :'); textcolor(3); WriteLn(Node.Phone);
  textcolor(9); Write('Node Baud Rate       :'); textcolor(3); WriteLn(Node.Baud);
  textcolor(9); Write('Node ID Number       :'); textcolor(3); WriteLn(Node.Node);
  WriteLn;
  textcolor(15);
  WriteLn('Press Any Key to View Bases Netted.');
  C:=ReadKey;
  ClrScr;
  For I:=1 to 255 Do
    If Node.BaseSelection[I] Then textcolor(9); Write('Base Id ');
    textcolor(3); Write('#'); textcolor(11); write(I); textcolor(9);
    WriteLn(' is Networked.');
  WriteLn;
  textcolor(15);
  Write('Press Any Key to Continue.');
  C:=ReadKey;
  End;  (* End ShowNode *)

Procedure DisplayNodeInformation;
Begin
  ClrScr;
  textcolor(9);
  Write('Which Node to List');
  textcolor(3); Write(':'); textcolor(11); Write('[');
  textcolor(15); Write('1-',filesize(Fn)); textcolor(11); Write(']:');
  textcolor(15);
  ReadLn(Input);
  I:=Valu(Input);
  If (I<1) or (I>(FileSize(Fn))) Then Else Begin
  Seek(Fn,I-1);
  Read(Fn,Node);
  ShowNode;
  End; (* End If then Begin *)
End; (* End DisplayNodeInformation *)

Procedure InitializeThisStuff;
Begin
  ReadConfig;
  Assign(Fn,ConfigSet.ForumDi+'NodeList.BBS');
  If Exist (ConfigSet.ForumDi+'NodeList.BBS') then
    Reset(Fn) Else ReWrite(Fn);
  ClrScr;
  gotoxy(15,15);
  CiRRON_FX; Write(' BBS Graphical Node Editor v1.00');
  GotoXy(24,23);
  textcolor(15);
  Write('Press Any Key To Continue');
  C:=ReadKey;
  ClrScr;
  FillChar(TheMenu,SizeOf(TheMenu),0);
  TheMenu[1]:='\Node Maintenance';
  TheMenu[2]:='List Nodes';
  TheMenu[3]:='Modify Node';
  TheMenu[4]:='Delete a Node';
  TheMenu[5]:='\Add a Node      ';
  TheMenu[6]:='\About Node Edit ';
  TheMenu[7]:='\Quit Node Editor';
  TheMenu[8]:='\\';
  Major:=1;
  Minor:=1;
End;         (* End InitializeThisStuff *)

Procedure AboutNodeEdit;
Begin
  ClrScr;
  CiRRON_FX; Write(' FlashNET NodeList Editor Version 1.00');
  WriteLn;
  textcolor(15);
  Write('Written By ');
  textcolor(4);
  Write('D');
  textcolor(12);
  Write('ungeOn ');
  textcolor(4);
  Write('M');
  textcolor(12);
  Write('aster ');
  textcolor(15);
  WriteLn('For The CiRRON Users.');
  GotoXy(24,23);
  textcolor(15);
  Write('Press Any Key to Continue.');
  C:=ReadKey;
End;               (* End AboutNodeEdit *)


Procedure AddNode;
Begin
  ClrScr;
  FillChar(Node,SizeOf(Node),0);
  textcolor(3);
  Write('Enter Node Password:');
  textcolor(11);
  ReadLn(Input);
  If Input='' then Exit;
  Node.Pass:=Input;
  textcolor(3);
  Write('Enter Node Name:');
  textcolor(11);
  ReadLn(Input);
  If Input='' then Exit;
  Node.Name:=Input;
  textcolor(3);
  WriteLn('For this do NOT include any "-"s or "("s');
  Write('Enter Node Phone Number:');
  textcolor(11);
  ReadLn(Input);
  If Input='' then Exit;
  Node.Phone:=Input;
  textcolor(3);
  Write('Enter node Baud Rate (ex:38400):');
  textcolor(11);
  ReadLn(Input);
  If Input='' then Exit;
  If Input='1200' then Node.Baud:=1200;
  If Input='2400' then Node.Baud:=2400;
  If Input='4800' then Node.Baud:=4800;
  If Input='9600' then Node.Baud:=9600;
  If Input='19200' then Node.Baud:=19200;
  If Input='38400' then Node.Baud:=38400;
  textcolor(3);
  Write('Enter FlashNET Node ID Address:');
  textcolor(11);
  ReadLn(Input);
  If Input='' then Exit;
  Node.Node:=Input;
  ClrScr;
  textcolor(3);
  WriteLn('Now we are going to pick the BASE ID''s to be networked.');
  WriteLn('Just enter the net ID''s that you WISH to pick up and then enter');
  WriteLn('A "0" when you are done.');
   Repeat
     textcolor(9);
     Write('Base Id:');
     textcolor(11);
     ReadLn(Input);
     I:=Valu(Input);
     If (I>0) and (I<256) then Node.BaseSelection[I]:=True;
     If (I>255) or (I<0) then WriteLn('Invalid range!');
   Until I=0; (* End Repeat Loop *)
   textcolor(15);
   Write('Adding node to list...');
   Seek(Fn,FileSize(Fn));
   Write(Fn,Node);
   WriteLn('Completed!');
   WriteLn('Press Any Key to Continue.');
   C:=ReadKey;
  End;               (* End AddNode *)

Procedure DeleteNode;
Begin
  ClrScr;
  Write('Whice Node to Delete [1-',filesize(Fn),']:');
  ReadLn(Input);
  I:=Valu(Input);
  If (I<1) or (I>FileSize(Fn)) then Exit;
  Write('Deleting Node...');
  Dec(I);
  For Cnt:=i to FileSize(Fn)-2 do Begin
    Seek(Fn,Cnt+1);
    Read(Fn,Node);
    Seek(Fn,Cnt);
    Write(Fn,Node);
  End;
  Seek(Fn,FileSize(Fn)-1);
  Truncate(Fn);
  Close(Fn);
  Assign(Fn,Configset.ForumDi+'NodeList.BBS');
  Reset(Fn);
  WriteLn('Deleted.');
  WriteLn;
  WriteLn('Press Any Key to Continue.');
  C:=ReadKey;
End; (* End DeleteNode *)

Procedure EditNode;
Var EditMenu:Pull_Array;
    EMajor,EMinor:Byte;
    NodeNum:Integer;

  Procedure InitEditor;
  Begin
    FillChar(EditMenu,SizeOf(EditMenu),0);
    EMajor:=1;
    Eminor:=1;
    EditMenu[1]:='\General Editing ';
    EditMenu[2]:='Phone Number';
    EditMenu[3]:='Baud Rate';
    EditMenu[4]:='Node Name';
    EditMenu[5]:='Show Node Info';
    EditMenu[6]:='\Specific Editing';
    EditMenu[7]:='Node Password';
    EditMenu[8]:='Node ID Number';
    EditMenu[9]:='\Net Worked Bases';
    EditMenu[10]:='\Quit Editing    ';
    EditMenu[11]:='\\';
  End; (* End InitEditor *)

  Procedure GetPhoneNum;
  Begin
    ClrScr;
    Write('Enter the NEW Phone Number for this Node:');
    ReadLn(Input);
    If Input<>'' then Node.Phone:=Input;
  End;  (* End GetPhoneNum *)

  Procedure GetName;
  Begin
    ClrScr;
    Write('Enter the NEW Name for this Node:');
    ReadLn(Input);
    If Input<>'' then Node.Name:=Input;
  End; (* End GetName *)

  Procedure GetBaud;
  Begin
    ClrScr;
    Write('Enter the New baud Rate for this node:');
    ReadLn(Input);
    If Input='1200' then Node.Baud:=1200
      Else
    If Input='2400' then Node.baud:=2400
      Else
    If Input='4800' then Node.Baud:=4800
      Else
    If Input='9600' then Node.Baud:=9600
      Else
    If Input='19200' then Node.Baud:=19200
      Else
    If Input='38400' then Node.Baud:=38400;
  End; (* End GetBaud *)
  Procedure NodePassword;
  Begin
    ClrScr;
    Write('Enter the NEW Node Password:');
    ReadLn(Input);
    If Input<>'' then Node.Pass:=Input;
  End; (* End NodePassword *)

  Procedure NodeIDNumber;
  Begin
    ClrScr;
    Write('Enter the NEW Node ID Number:');
    ReadLn(Input);
    If Input<>'' then Node.Node:=Input;
  End; (* End NodeIDNumber *)

  Procedure NetBases;
  Begin
    ClrScr;
    WriteLn('To Change the status of a base ID Number to network, just enter the');
    WriteLn('The Base Number to change. When you are finished, just enter a "0"');
    WriteLn;
    Repeat
      Write('Base ID To change:');
      ReadLn(Input);
      I:=Valu(Input);
      If (I>0) and (I<256) then Begin
         Node.BaseSelection[I]:=Not Node.BaseSelection[I];
         If Node.BaseSelection[I] then WriteLn('Base ID:',i,' WILL be networked.')
         Else
         WriteLn('Base ID:',I,'Will NOT be networked.');
      End; (* End Conditional Begin *)
    Until I=0; (* End Repeat Loop *)
  End; (* End NetBases *)

  Begin (* Begin Main EditNode Loop *)
    InitEditor;
    ClrScr;
    textcolor(11);
    Write('Enter the Node to Edit');
    textcolor(3); write(':'); textcolor(15);
    write('[1-',filesize(Fn),']:');
    textcolor(9);
    ReadLn(Input);
    I:=Valu(Input);
    If (I<1) or (I>FileSize(Fn)) then Else Begin
      Seek(Fn,I-1);
      Read(Fn,Node);
      NodeNum:=i-1;
      Repeat  (* Begin Main Repeat Loop *)
        ClrScr;
        Pull_Menu(EditMenu,Emajor,Eminor);
        Case EMajor of
          1:Case Eminor of
              1:GetPhoneNum;
              2:GetBaud;
              3:GetName;
              4:ShowNode;
            End; (* End Eminor case *)
          2:Case Eminor of
              1:NodePassword;
              2:NodeIDNumber;
             End; (* End Case Eminor *)
          3:NetBases;
        End; (* End Case *)
      Until Emajor=4; (* End Main Repeat Loop *)
    Seek(Fn,NodeNum);
    Write(Fn,Node);
  End; (* End Conditional IF Then *)
End; (* End EditNode *)


Begin
 InitializeThisStuff;
 Repeat
 ClrScr;
 Pull_Menu(TheMenu,Major,Minor);
 Case Major of
   1:Case Minor of
      1:DisplayNodeInformation;
      2:EditNode;
      3:DeleteNode;
      End; (* End Case *)
   2:AddNode;
   3:AboutNodeEdit;
 End;  (* End Case *)
 Until Major=4;  (* End Repeat Loop *)
 ClrScr;
 GotoXY(10,10);
 textcolor(8);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(7);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(15);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(8);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(7);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(15);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(500);
 GotoXY(10,10);
 textcolor(8);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(7);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(15);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(8);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(7);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(199);
 GotoXY(10,10);
 textcolor(15);
 WriteLn('CiRRON ',versionnum,' Node Editor');
 delay(299);
 gotoxy(10,10);
 CiRRON_FX; writeLn(' ',versionnum,' Node Editor');
 delay(600);
 gotoxy(10,10);
 WriteLn('CiRRON: The Software Of The ''90s');
 GotoXy(23,20);
 Write('Written by DungeOn Master (c)1995 ');
 textcolor(1);
 write('C');
 textcolor(9);
 write('i');
 textcolor(3);
 write('R');
 textcolor(11);
 write('R');
 textcolor(15);
 writeLn('ON Software');
 Close(Fn);
End.        (* End Program *)



