PROCEDURE Vendors
    PRIVATE mFormOpen, lVoid, mDesk, mActive, mClass

     IF TYPE("Vend.ClassName") # "C"     && if form doesn't already exist
         mFormOpen=.F.
         DEFINE FORM mTemp PROPERTY VISIBLE .F.
         lVoid = mTemp.OPEN()
         mDesk = mTemp.PARENT
         lVoid = mTemp.CLOSE()

         mFormName=SPACE(8)
         mActive=mDesk.ActiveControl()
         IF TYPE("mActive.ClassName")="C"
             mClass=mActive.ClassName
             IF mClass="FORM"
                 mFormName=mActive.Name
                 mFormOpen=.T.
             ENDIF
         ENDIF

         PUBLIC NewRecord

         #include "Vendors.dfm"



         NewRecord = .F.

         Vend.Action = .F.
         lVoid = Vend.Open()

     ELSE
           lVoid = Vend.SetFocus()     && if form exists, make current
     ENDIF

RETURN
******************
PROCEDURE OpenVend
    PRIVATE lOpen

    lOpen = .T.     && Is .DBF already open?

    IF SUBSTR(DBF(),3)<>"VENDORS.DBF"
        SELECT SELECT()
        USE Vendors ORDER Vendor_Id ALIAS Vendors
        lOpen = .F.     &&  .DBF was not already open
    ELSE
        SET ORDER TO Vendor_Id
    ENDIF

    This.lOpen = lOpen  && save lOpen to form

    *Update radiobuttons
    DO RadioUpd

    *Update the screen
    lVoid = This.Refresh()

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.App.Gds.Enabled=.F.
        Main.App.Inv.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
    ENDIF
    Main.App.Vend.Enabled=.F.
    lVoid = Vend.Vendorid.Setfocus()

RETURN

******************
PROCEDURE PrevHand
    IF Form.Modified()
        lVoid = Form.Submit()
    ENDIF
    IF .NOT. BOF()
        SKIP -1
        IF BOF()
           DO ErrorMsg WITH "Top of file!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        *Update the Radio buttons
        DO RadioUpd

        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN
******************
PROCEDURE SkipHand
    IF Form.Modified()
        lVoid = Form.Submit()
    ENDIF
    IF .NOT. EOF()
        SKIP
        IF VENDOR_ID=' '
         SKIP -1
         DO ErrorMsg WITH "End of file encountered!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        * Update Radio Buttons
        DO RadioUpd

        * Update Screen repaint
        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.
RETURN
*******************
PROCEDURE RadioUpd
    DO CASE
        CASE Terms = "NET 15"
            Vend.Net15.value = .T.

        CASE Terms = "NET 30"
            Vend.Net30.Value = .T.
    ENDCASE
    *Set Focus to the Vendor Id field
    lVoid = Vend.Next1.SetFocus()

RETURN
*******************
PROCEDURE CloseVend
    IF This.Action
        lVoid = This.Submit()
    ELSE
        IF This.Modified()
            DO ErrorMsg WITH "Exit Vendors without saving ..."
        ENDIF
    ENDIF

    IF .NOT. This.lOpen && if .DBF was not open on startup
        USE IN Vendors  && shut it down
    ENDIF

    lVoid = This.Release()

    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()

    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.V.Frm.Enabled=.T.
        Main.App.Gds.Enabled=.T.
        Main.App.Inv.Enabled=.T.
        Main.F1.Bac.Enabled=.T.
    ENDIF
    Main.App.Vend.Enabled=.T.

    RELEASE Vend

RETURN
******************
FUNCTION DupCheck
     If NewRecord
         ? "Checking for Duplicates ..."
         SEEK(Vend.VendorId.Value)
         IF FOUND()
             DO ErrorMsg WITH "Duplicate Found, Try Again..."+Vend.VendorId.Value
             RETURN .F.
         ELSE
             Newrecord = .f.
         ENDIF
     Endif
RETURN .T.
******************
FUNCTION FindNum

    * Generate a form that will can be used by other procedures
    DO GenForm
    * Make the user select Ok before moving on
    lVoid = Search.sValue.Setfocus()
    lVoid = Search.ReadModal()

*    ?"FindLast ok"

RETURN .T.
**********************
PROCEDURE NotThisOne
      DO ErrorMsg WITH "... this red text does nothing"
RETURN
*****************
PROCEDURE CloseMe
    CLEAR
    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()
    * remove from memory
    lVoid = Search.Release()
    IF LEN(SearchFor) > 0
        *Now Search for value given - Exact match
        SEEK(SearchFor)

        IF FOUND()
            Vend.StatusMessage = "Found Vendor = "+SearchFor
            * repaint the form with the current record
            lVoid = Form.Refresh()
        ELSE
            DO Errormsg WITH "Vendor # Not Found ..."+SearchFor
        ENDIF
    ENDIF
RETURN
******************
PROCEDURE PrevHand

    * Check to see that the record pointer is not at Beginning of File
    IF .NOT. BOF()
        lVoid = Form.Submit()
        SKIP -1

        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN

*******************
PROCEDURE SkipHand

    * Check to see that the record pointer is not end of file
    IF .NOT. EOF()
        lVoid = Form.Submit()
        SKIP

        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        * Record pointer is at the end of file, tell user
        DO ErrorMsg WITH "End of file encountered!"
        SKIP -1
    ENDIF
    Form.Action = .F.

RETURN
******************
PROCEDURE Add_new
    NewRecord = .T.

    *Write data to disk
    lvoid = Form.submit()

    * Append a record
    APPEND BLANK

    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.cStatus.Text=""
RETURN
******************
PROCEDURE DelIt && Marks record for deletion
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
*****************
PROCEDURE RePaint
    SELE Vendors
    lVoid = Vend.Refresh()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM VENDORS TO PRINTER
    CASE Form.Lab.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         LABEL FORM Vendors TO PRINTER

ENDCASE
lVoid = Form.Close()
lVoid = Form.Release()
RETURN



